/***********************************************************************
	This file is a part of SkyBoost project 
		- idea and basic asm implementation by Arisu
		- conversion to c++ and advancing by Alexander Blade
***********************************************************************/

#pragma once

#include "skyboost.h"
#include <windows.h>
#include <math.h>

namespace func_1_3_10_0
{
		void WriteGetThisOff94(DWORD Address)
		{
			if (*(WORD *)(Address + 5) == 0xC085) // if next op is test eax, eax 
			{
				BYTE newcode[7];
				// 83B99400000000   cmp dword ptr [ecx + 0x94], 0
				newcode[0] = 0x83;
				newcode[1] = 0xB9;
				newcode[2] = 0x94;
				newcode[3] = 0x00;
				newcode[4] = 0x00;
				newcode[5] = 0x00;
				newcode[6] = 0x00;
				WriteData(Address, newcode, sizeof(newcode));
				//Print("get_this_off94 caller patched 0x%08x method #1", Address);
			} else
			if (*(BYTE *)(Address + 5) == 0x50) // if next op is push eax
			{
				BYTE newcode[6];
				// FFB194000000     push dword ptr [ecx + 0x94]
				newcode[0] = 0xFF;
				newcode[1] = 0xB1;
				newcode[2] = 0x94;
				newcode[3] = 0x00;
				newcode[4] = 0x00;
				newcode[5] = 0x00;
				WriteData(Address, newcode, sizeof(newcode));
				//Print("get_this_off94 caller patched 0x%08x method #2", Address);
			} //else Print("get_this_off94 caller not patched 0x%08x", Address);
		}

		void WriteGetThisOffB4(DWORD Address)
		{
			if (*(WORD *)(Address + 5) == 0xC085) // if next op is test eax, eax 
			{
				BYTE newcode[7];
				// 83B9B400000000   cmp dword ptr [ecx + 0xB4], 0
				newcode[0] = 0x83;
				newcode[1] = 0xB9;
				newcode[2] = 0xB4;
				newcode[3] = 0x00;
				newcode[4] = 0x00;
				newcode[5] = 0x00;
				newcode[6] = 0x00;
				WriteData(Address, newcode, sizeof(newcode));
				//Print("get_this_offB4 caller patched 0x%08x method #1", Address);
			} else
			if (*(WORD *)(Address + 5) == 0xC88B) // if next op is mov ecx, eax
			{
				BYTE newcode[7];
				// 8B89B4000000     mov ecx, [ecx + 0xB4]
				newcode[0] = 0x8B;
				newcode[1] = 0x89;
				newcode[2] = 0xB4;
				newcode[3] = 0x00;
				newcode[4] = 0x00;
				newcode[5] = 0x00;
				newcode[6] = 0x90;
				WriteData(Address, newcode, sizeof(newcode));
				//Print("get_this_offB4 caller patched 0x%08x method #2", Address);
			} //else Print("get_this_offB4 caller not patched 0x%08x", Address);
		}

		void WriteGetThisOff38(DWORD Address)
		{
			if (*(WORD *)(Address + 5) == 0xC085) // if next op is test eax, eax 
			{
				BYTE newcode[7];
				// 83B93800000000   cmp dword ptr [ecx + 0x38], 0
				newcode[0] = 0x83;
				newcode[1] = 0xB9;
				newcode[2] = 0x38;
				newcode[3] = 0x00;
				newcode[4] = 0x00;
				newcode[5] = 0x00;
				newcode[6] = 0x00;
				WriteData(Address, newcode, sizeof(newcode));
				//Print("get_this_off38 caller patched 0x%08x method #1", Address);
			} else
			if (*(WORD *)(Address + 5) == 0xC88B) // if next op is mov ecx, eax
			{
				BYTE newcode[7];
				// 8B8938000000     mov ecx, [ecx + 0x38]
				newcode[0] = 0x8B;
				newcode[1] = 0x89;
				newcode[2] = 0x38;
				newcode[3] = 0x00;
				newcode[4] = 0x00;
				newcode[5] = 0x00;
				newcode[6] = 0x90;
				WriteData(Address, newcode, sizeof(newcode));
				//Print("get_this_off38 caller patched 0x%08x method #2", Address);
			} else 
			if (*(BYTE *)(Address + 5) == 0x50) // if next op is push eax
			{
				BYTE newcode[6];
				// FFB194000000     push dword ptr [ecx + 0x38]
				newcode[0] = 0xFF;
				newcode[1] = 0xB1;
				newcode[2] = 0x38;
				newcode[3] = 0x00;
				newcode[4] = 0x00;
				newcode[5] = 0x00;
				WriteData(Address, newcode, sizeof(newcode));
				//Print("get_this_off38 caller patched 0x%08x method #3", Address);
			} //else Print("get_this_off38 caller not patched 0x%08x", Address);
		}

		void WriteGetRowColumn(DWORD Address)
		{
			if (*(BYTE *)(Address - 10) == 0x6A && *(BYTE *)(Address - 8) == 0x6A)
			{
				/* for ex.		6A 00 6A 00 8D 8D 74 FF FF FF E8 33 3B 00 00 
				  .text:0048F7AE                 push    0					; 6A 00
				  .text:0048F7B0                 push    0					; 6A 00
				  .text:0048F7B2                 lea     ecx, [ebp+var_8C]  ; 8D 8D 74 FF FF FF
				  .text:0048F7B8                 call    sub_4932F0         ; E8 33 3B 00 00      */  
				BYTE newcode[15], param1, param2;
				memcpy(newcode, (void *)(Address - 6), 6);
				param1 = *(BYTE *)(Address - 7);
				param2 = *(BYTE *)(Address - 9);
				newcode[6] = 0x8D;             //    lea	    eax, [ecx+12*param1]
				newcode[7] = 0x41;
				newcode[8] = param1 * 12;
				newcode[9] = 0xD9;			   //    fld	    dword [eax+4*param2] 	
				newcode[10] = 0x40;
				newcode[11] = param2 * 4;
				newcode[12] = 0x0F;			   //	 NOP_3	
				newcode[13] = 0x1F;
				newcode[14] = 0x00;
				WriteData(Address - 10, newcode, sizeof(newcode));
				//Print("get_row_column caller patched 0x%08x method #1", Address);
			} else 
			if (*(BYTE *)(Address - 7) == 0x6A && *(BYTE *)(Address - 5) == 0x6A)
			{
				/* for ex.		6A 00 6A 00 8D 4D A0 E8 DC 09 F0 FF
				.text:00592908                 push    0
				.text:0059290A                 push    0
				.text:0059290C                 lea     ecx, [ebp+var_60] ; lea/mov
				.text:0059290F                 call    sub_4932F0      */  
				BYTE newcode[12], param1, param2;
				memcpy(newcode, (void *)(Address - 3), 3);
				param1 = *(BYTE *)(Address - 4);
				param2 = *(BYTE *)(Address - 6);
				newcode[3] = 0x8D;             //    lea	    eax, [ecx+12*param1]
				newcode[4] = 0x41;
				newcode[5] = param1 * 12;
				newcode[6] = 0xD9;			   //    fld	    dword [eax+4*param2] 	
				newcode[7] = 0x40;
				newcode[8] = param2 * 4;
				newcode[9] = 0x0F;			   //	 NOP_3	
				newcode[10] = 0x1F;
				newcode[11] = 0x00;
				WriteData(Address - 7, newcode, sizeof(newcode));
				//Print("get_row_column caller patched 0x%08x method #2", Address);
			} else
			if (*(BYTE *)(Address - 8) == 0x6A && *(BYTE *)(Address - 6) == 0x6A)
			{
				/* for ex.		6A 00 6A 00 8D 4C 24 64 E8 55 27 60 FF
					.text:00E90B8E                 push    0
					.text:00E90B90                 push    0
					.text:00E90B92                 lea     ecx, [esp+1E8h+var_184]
					.text:00E90B96                 call    sub_4932F0
				*/  
				BYTE newcode[13], param1, param2;
				memcpy(newcode, (void *)(Address - 4), 4);
				param1 = *(BYTE *)(Address - 5);
				param2 = *(BYTE *)(Address - 7);
				newcode[4] = 0x8D;             //    lea	    eax, [ecx+12*param1]
				newcode[5] = 0x41;
				newcode[6] = param1 * 12;
				newcode[7] = 0xD9;			   //    fld	    dword [eax+4*param2] 	
				newcode[8] = 0x40;
				newcode[9] = param2 * 4;
				newcode[10] = 0x0F;			   //	 NOP_3	
				newcode[11] = 0x1F;
				newcode[12] = 0x00;
				WriteData(Address - 8, newcode, sizeof(newcode));
				//Print("get_row_column caller patched 0x%08x method #3", Address);
			} //else Print("get_row_column caller not patched 0x%08x", Address);
		}

		void WriteBitTest(DWORD Address, DWORD Mask)
		{
			if (*(WORD *)(Address + 5) == 0xB60F && *(BYTE *)(Address + 8) == 0x85)
			{	
				// F7819800000001000000 test [ecx+0x00000098], 0x00000001
				BYTE newcode[10];
				newcode[0] = 0xF7;
				newcode[1] = 0x81;
				newcode[2] = 0x98;
				newcode[3] = 0x00;
				newcode[4] = 0x00;
				newcode[5] = 0x00;
				*(DWORD *)&newcode[6] = Mask;
				WriteData(Address, newcode, sizeof(newcode));
				//Print("test_bit %x caller patched 0x%08x", Mask, Address);
			} //else Print("test_bit %x caller not patched 0x%08x", Mask, Address);
		}

		VOIDASMPROC fabs()
		{
			__asm
			{
				fld	    dword ptr [esp]
				fabs
			}
		}
		DWORD fabs_size = 5;

		VOIDASMPROC get_this()
		{
			__asm
			{
				mov	    eax, [ecx]
				NOP_3
			}
		}
		DWORD get_this_size = 5;

		VOIDASMPROC get_this_off4()
		{
			__asm
			{
				mov	    eax, [ecx + 4]
				NOP_2
			}
		}
		DWORD get_this_off4_size = 5;

		VOIDASMPROC get_this_off4_func()
		{
			__asm
			{
				mov	    eax, [ecx + 4]
				ret
			}
		}
		DWORD get_this_off4_func_size = 4;

		VOIDASMPROC get_this_off8()
		{
			__asm
			{
				mov	    eax, [ecx + 8]
				NOP_2
			}
		}
		DWORD get_this_off8_size = 5;

		VOIDASMPROC get_this_off8_func()
		{
			__asm
			{
				mov	    eax, [ecx + 8]
				ret
			}
		}
		DWORD get_this_off8_func_size = 4;

		VOIDASMPROC get_this_off3C()
		{
			__asm
			{
				mov	    eax, [ecx + 0x3C]
				NOP_2
			}
		}
		DWORD get_this_off3C_size = 5;

		VOIDASMPROC get_this_off3C_func()
		{
			__asm
			{
				mov	    eax, [ecx + 0x3C]
				ret
			}
		}
		DWORD get_this_off3C_func_size = 4;

		VOIDASMPROC get_this_off94_func()
		{
			__asm
			{
				mov	    eax, [ecx + 0x94]
				ret
			}
		}
		DWORD get_this_off94_func_size = 10;

		VOIDASMPROC get_this_offB4_func()
		{
			__asm
			{
				mov	    eax, [ecx + 0xB4]
				ret
			}
		}
		DWORD get_this_offB4_func_size = 10;

		VOIDASMPROC get_this_off38_func()
		{
			__asm
			{
				mov	    eax, [ecx + 0x38]
				ret
			}
		}
		DWORD get_this_off38_func_size = 10;

		VOIDASMPROC get_this_off60()
		{
			__asm
			{
				mov	    eax, [ecx + 0x60]
				NOP_2
			}
		}
		DWORD get_this_off60_size = 5;

		VOIDASMPROC set_this_off60()
		{
			__asm
			{
				pop     eax
				mov	    [ecx + 0x60], eax
				NOP_1
			}
		}
		DWORD set_this_off60_size = 5;

		VOIDASMPROC get_useless()
		{
			__asm
			{
				mov	    eax, ecx
				NOP_3
			}
		}
		DWORD get_useless_size = 5;

		VOIDASMPROC get_useless_func()
		{
			__asm
			{
				mov	    eax, ecx
				ret
			}
		}
		DWORD get_useless_func_size = 3;

		VOIDASMPROC sqrt()
		{
			__asm
			{
				fsqrt
				NOP_3
			}
		}
		DWORD sqrt_size = 5;

		VOIDASMPROC sqrt_jmped()
		{
			__asm
			{
				fsqrt
				ret
			}
		}
		DWORD sqrt_jmped_size = 3;

		VOIDASMPROC check_this_plus98_jmp_plus_48()
		{
			__asm
			{
				test    byte ptr [ecx+98h], 1
				jz		lc
				retn    4
				lc:                 
				mov     eax, [esp+4]
				mov     edx, [eax]
				mov     [esp+4], ecx
				mov     ecx, eax
				mov     eax, [edx+48h]
				jmp     eax
			}
		}
		DWORD check_this_plus98_jmp_plus_48_size = 0x1D;

		VOIDASMPROC determine_visiblity()
		{
			__asm
			{
				mov	    eax, [esp+4]
   				movups   xmm0, [ecx]
   				movups   xmm1, [eax]

   				movaps   xmm2, xmm0
   				movaps   xmm3, xmm1

   				mulps    xmm0, xmm1
   				psrldq   xmm2, 3*4
   				psrldq   xmm3, 3*4
   				pslldq   xmm0, 1*4

   				movaps   xmm1, xmm3
  				haddps   xmm0, xmm0
   				subps    xmm1, xmm2
   				haddps   xmm0, xmm0

   				ucomiss  xmm0, xmm1
   				jna	    isSmaller

   				xor	    eax, eax
   				addps    xmm2, xmm3
   				ucomiss  xmm0, xmm2

   				sbb	    eax, -1
   				retn     4

   				isSmaller:
      			mov      eax, 2
      			retn     4
			}
		}
		DWORD determine_visiblity_size = 0x4B;

		VOIDASMPROC dot_product()
		{
			__asm
			{
				mov	     eax, [esp+4]
				movups   xmm0, [ecx]
				movups   xmm1, [eax]

				mulps    xmm0, xmm1
				pslldq   xmm0, 1*4

				haddps   xmm0, xmm0
				haddps   xmm0, xmm0

				movss    [esp-4], xmm0
				fld	     dword ptr [esp-4]

				retn     4
			}
		}
		DWORD dot_product_size = 0x27;

		VOIDASMPROC dot_product_minus_unknown()
		{
			__asm
			{
				mov	     eax, [esp+4]
				movups   xmm0, [ecx]
				movups   xmm1, [eax]

				mulps    xmm0, xmm1
				pslldq   xmm0, 1*4

				haddps   xmm0, xmm0
				haddps   xmm0, xmm0

				movss    [esp-4], xmm0
				fld	     dword ptr [esp-4]
				fsub     dword ptr [ecx+12]

				retn     4
			}
		}
		DWORD dot_product_minus_unknown_size = 0x2A;

		VOIDASMPROC get_row_column()
		{
			__asm
			{
				mov	    eax, [esp+4]
				mov	    edx, [esp+8]
				lea	    eax, [eax+2*eax]
				lea	    eax, [ecx+4*eax]
				fld	    dword ptr [eax+4*edx]
				retn     8
			}
		}
		DWORD get_row_column_size = 0x14;

		VOIDASMPROC get_this_plus_12x()
		{
			__asm
			{
				mov	    eax, [esp+4]
				lea	    eax, [eax+2*eax]
				shl	    eax, 2
				add	    eax, [ecx]
				retn     4
			}
		}
		DWORD get_this_plus_12x_size = 0x0F;

		VOIDASMPROC get_this_plus_112x()
		{
			__asm
			{
				mov	    eax, [esp+4]
				lea	    edx, [eax+eax]
				shl	    eax, 4
				sub	    eax, edx
				shl	    eax, 3
				add	    eax, [ecx]
				retn     4
			}
		}
		DWORD get_this_plus_112x_size = 0x14;

		VOIDASMPROC initialize_object_A()
		{
			__asm
			{
				push     esi
				push     edi

				mov	    esi, [esp+12]
				mov	    eax, [esi]
				mov	    [ecx+120], eax

				mov	    eax, [ecx+8]
				mov	    edi, [ecx+38]

				sub	    eax, edi
				sbb	    edx, edx
				and	    edx, eax
				add	    edi, edx

				mov	    edx, [ecx]
				lea	    edi, [esi+4*edi]

				NOP_2
				startLoop:
				cmp      esi, edi
				je       exitLoop

				add      esi, 4
				mov      eax, [esi]
				mov      [edx+96], eax
				add      edx, 112
				jmp      startLoop

				exitLoop:
				pop      edi
				pop      esi
				retn     4
			}
		}
		DWORD initialize_object_A_size = 0x36;

		VOIDASMPROC initialize_object_B()
		{
			__asm
			{
				push     esi
				push     edi

				mov	    esi, [esp+12]
				mov	    eax, [ecx+120]
				mov	    [esi], eax

				mov	    eax, [ecx+8]
				mov	    edi, [ecx+38]

				sub	    eax, edi
				sbb	    edx, edx
				and	    edx, eax
				add	    edi, edx

				mov	    edx, [ecx]
				lea	    edi, [esi+4*edi]

				NOP_2
				startLoop:
				cmp      esi, edi
				je       exitLoop

				add      esi, 4
				mov      eax, [edx+96]
				mov      [esi], eax
				add      edx, 112

				jmp      startLoop

				exitLoop:
				pop      edi
				pop      esi
				retn     4
			}
		}
		DWORD initialize_object_B_size = 0x36;

		VOIDASMPROC traverse_list()
		{
			__asm
			{
 				push     ebx
				push     esi
				push     edi

				mov	    ebx, [esp+20]
				mov	    edx, [ebx+4]
				mov	    edx, [edx+60]

				mov	    esi, [esp+16]
				lea	    esi, [ecx+4*esi]

				nextItem:
				mov      edi, [esi]
				test     edi, edi
				jz       exitLoop

				mov      eax, [edi+4]
				//mov      eax, [eax+60]
				cmp      edx, [eax+60]
				jna      exitLoop

				lea      esi, [edi+28]
				jmp      nextItem

				exitLoop:
				mov      [esi], ebx
				mov      [ebx+28], edi

				mov      ebx, ecx
				mov      ecx, [esp+16]
				mov      eax, 1
				shl      eax, cl
				or       [ebx+20], eax
				mov      ecx, ebx

				pop      edi
				pop      esi
				pop      ebx
				retn     8
			}
		}
		DWORD traverse_list_size = 0x46;

		VOIDASMPROC test_bit1()
		{
			__asm
			{
				test     dword ptr [ecx+152], 0x00000001
				setnz    al
				retn
			}
		}

		VOIDASMPROC test_bit2()
		{
			__asm
			{
				test     dword ptr [ecx+152], 0x00000002
				setnz    al
				retn
			}
		}

		VOIDASMPROC test_bit6()
		{
			__asm
			{
				test     dword ptr [ecx+152], 0x00000020
				setnz    al
				retn
			}
		}

		VOIDASMPROC test_bit11()
		{
			__asm
			{
				test     dword ptr [ecx+152], 0x00000400
				setnz    al
				retn
			}
		}

		VOIDASMPROC test_bit12()
		{
			__asm
			{
				test     dword ptr [ecx+152], 0x00000800
				setnz    al
				retn
			}
		}

		VOIDASMPROC test_bit15()
		{
			__asm
			{
				test     dword ptr [ecx+152], 0x00004000
				setnz    al
				retn
			}
		}

		VOIDASMPROC test_bit16()
		{
			__asm
			{
				test     dword ptr [ecx+152], 0x00008000
				setnz    al
				retn
			}
		}

		VOIDASMPROC test_bit18()
		{
			__asm
			{
				test     dword ptr [ecx+152], 0x00020000
				setnz    al
				retn
			}
		}

		VOIDASMPROC test_bit21()
		{
			__asm
			{
				test     dword ptr [ecx+152], 0x00100000
				setnz    al
				retn
			}
		}

		VOIDASMPROC test_bit23()
		{
			__asm
			{
				test     dword ptr [ecx+152], 0x00400000
				setnz    al
				retn
			}
		}

		VOIDASMPROC test_bit27()
		{
			__asm
			{
				test     dword ptr [ecx+152], 0x04000000
				setnz    al
				retn
			}
		}

		VOIDASMPROC test_bit28()
		{
			__asm
			{
				test     dword ptr [ecx+152], 0x08000000
				setnz    al
				retn
			}
		}

		VOIDASMPROC test_not_bit30()
		{
			__asm
			{
				test     dword ptr [ecx+152], 0x20000000
				setz    al
				retn
			}
		}

		VOIDASMPROC test_is_zero()
		{
			__asm
			{
				cmp	     dword ptr [ecx], 0
				setz     al
				retn
			}
		}

		DWORD bit_test_size = 0x10;



		__forceinline int sub_937B20(int _this)
		{
		  return *(DWORD *)(_this + 148);
		}

		__forceinline char *sub_5FBED0(void *_this)
		{
		  return (char *)_this + 136;
		}

		__forceinline int unknown_libname_173(void *_this)
		{
		  return *(_DWORD *)_this;
		}

		__forceinline int sub_795AD0(void *_this, int a2)
		{
		  return 112 * a2 + unknown_libname_173(_this);
		}

		__forceinline int sub_6DF650(void *_this, int a2)
		{
		  return 12 * a2 + unknown_libname_173(_this);
		}

		__forceinline bool sub_E863E0()
		{
		  int v4;
		  _asm mov v4, ecx
		  return (*(DWORD *)(v4 + 152) & 0x800 || (0 != *(DWORD *)(v4 + 148))) && !(*(DWORD *)(v4 + 152) & 1);
		}

		__forceinline float sub_64DF40(int _this, int a2)
		{
		  return (float)(*(float *)_this * *(float *)a2
					   + *(float *)(_this + 4) * *(float *)(a2 + 4)
					   + *(float *)(_this + 8) * *(float *)(a2 + 8));
		}

		__forceinline float sub_4A6910(int _this, int a2)
		{
		  return (float)(sub_64DF40(_this, a2) - *(float *)(_this + 12));
		}

		__forceinline int _stdcall fpustuff0(int a2)
		{
		  signed int result; // eax@2
		  void *v3; // [sp+0h] [bp-8h]@1
		  float v4; // [sp+4h] [bp-4h]@1

		  _asm mov v3, ecx
		  v4 = sub_4A6910(a2, (int)v3);
		  if ( v4 > -*((float *)v3 + 3) )
			result = *((float *)v3 + 3) <= v4;
		  else
			result = 2;
		  return result;
		}

		__forceinline int sub_A09D90(int _this, int a2, int a3, int a4)
		{
		  *(DWORD *)_this = a2;
		  *(DWORD *)(_this + 4) = a3;
		  *(DWORD *)(_this + 8) = a4;
		  return _this;
		}

		__forceinline int _stdcall fpustuff1(int a2, int a3)
		{
		  int v3; // ST14_4@1
		  int v4; // ST10_4@1
		  int v5; // ST0C_4@1
		  int _this;
		  _asm mov _this, ecx

		  *(float *)&v3 = *(float *)(_this + 24) * *(float *)a3
						+ *(float *)(_this + 28) * *(float *)(a3 + 4)
						+ *(float *)(_this + 32) * *(float *)(a3 + 8);
		  *(float *)&v4 = *(float *)(_this + 12) * *(float *)a3
						+ *(float *)(_this + 16) * *(float *)(a3 + 4)
						+ *(float *)(_this + 20) * *(float *)(a3 + 8);
		  *(float *)&v5 = *(float *)_this * *(float *)a3
						+ *(float *)(_this + 4) * *(float *)(a3 + 4)
						+ *(float *)(_this + 8) * *(float *)(a3 + 8);
		  sub_A09D90(a2, v5, v4, v3);
		  return a2;
		}

		__forceinline void *_stdcall fpustuff2(void *a2, int a3)
		{
		  void *v3; // ST08_4@1
		  float farr[8];

		#define v5 farr[0]
		#define v6 farr[1]
		#define v7 farr[2]
		#define v8 farr[3]
		#define v9 farr[4]
		#define v10 farr[5]
		#define v11 farr[6]
		#define v12 farr[7]
		#define v13 farr[8]

		  _asm mov v3, ecx
		  v5 = *(float *)v3 * *(float *)a3 + *((float *)v3 + 1) * *(float *)(a3 + 12) + *((float *)v3 + 2) * *(float *)(a3 + 24);
		  v8 = *((float *)v3 + 3) * *(float *)a3
			 + *((float *)v3 + 4) * *(float *)(a3 + 12)
			 + *((float *)v3 + 5) * *(float *)(a3 + 24);
		  v11 = *((float *)v3 + 6) * *(float *)a3
			  + *((float *)v3 + 7) * *(float *)(a3 + 12)
			  + *((float *)v3 + 8) * *(float *)(a3 + 24);
		  v6 = *(float *)v3 * *(float *)(a3 + 4)
			 + *((float *)v3 + 1) * *(float *)(a3 + 16)
			 + *((float *)v3 + 2) * *(float *)(a3 + 28);
		  v9 = *((float *)v3 + 3) * *(float *)(a3 + 4)
			 + *((float *)v3 + 4) * *(float *)(a3 + 16)
			 + *((float *)v3 + 5) * *(float *)(a3 + 28);
		  v12 = *((float *)v3 + 6) * *(float *)(a3 + 4)
			  + *((float *)v3 + 7) * *(float *)(a3 + 16)
			  + *((float *)v3 + 8) * *(float *)(a3 + 28);
		  v7 = *(float *)v3 * *(float *)(a3 + 8)
			 + *((float *)v3 + 1) * *(float *)(a3 + 20)
			 + *((float *)v3 + 2) * *(float *)(a3 + 32);
		  v10 = *((float *)v3 + 3) * *(float *)(a3 + 8)
			  + *((float *)v3 + 4) * *(float *)(a3 + 20)
			  + *((float *)v3 + 5) * *(float *)(a3 + 32);
		  v13 = *((float *)v3 + 6) * *(float *)(a3 + 8)
			  + *((float *)v3 + 7) * *(float *)(a3 + 20)
			  + *((float *)v3 + 8) * *(float *)(a3 + 32);
		  memcpy(a2, &v5, 0x24u);
		  return a2;

		#undef v5
		#undef v6
		#undef v7
		#undef v8
		#undef v9
		#undef v10
		#undef v11
		#undef v12
		#undef v13
		}

		__forceinline bool sub_C47A70(int _this)
		{
		  return *(_DWORD *)(_this + 96) != 0;
		}

		__forceinline bool sub_C47A50(int _this, char a2)
		{
		  return ((1 << a2) & *(_DWORD *)(_this + 96)) != 0;
		}

		__forceinline char *sub_5450B0(void *_this, int a2)
		{
		  return (char *)_this + 16 * a2;
		}

		__forceinline signed int sub_4A68B0(void *_this, int a2)
		{
		  signed int result; // eax@2
		  void *v3; // [sp+0h] [bp-8h]@1
		  float v4; // [sp+4h] [bp-4h]@1

		  v3 = _this;
		  v4 = sub_4A6910(a2, (int)_this);
		  if ( v4 > -*((float *)v3 + 3) )
			result = *((float *)v3 + 3) <= (double)v4;
		  else
			result = 2;
		  return result;
		}

		__forceinline void *sub_C47A80(void *_this, char a2)
		{
		  void *result; // eax@1

		  result = _this;
		  *((_DWORD *)result + 24) &= ~(1 << a2);
		  return result;
		}

		__forceinline bool __stdcall sub_C97D30(void *a1, int a2)
		{
		  int v2; // eax@5
		  signed int v4; // [sp+4h] [bp-Ch]@5
		  signed int i; // [sp+8h] [bp-8h]@2
		  bool v6; // [sp+Fh] [bp-1h]@1

		  v6 = 1;
		  if ( sub_C47A70(a2) )
		  {
			for ( i = 0; i < 6; ++i )
			{
			  if ( sub_C47A50(a2, i) )
			  {
				v2 = (int)sub_5450B0((void *)a2, i);
				v4 = sub_4A68B0(a1, v2);
				if ( v4 == 2 )
				  break;
				if ( v4 == 1 )
				  sub_C47A80((void *)a2, i);
			  }
			}
			v6 = i == 6;
		  }
		  return v6;
		}

		__forceinline bool sub_C97DC0(void *a1, int a2)
		{
		  int v2; // eax@5
		  signed int i; // [sp+8h] [bp-8h]@2
		  bool v5; // [sp+Fh] [bp-1h]@1

		  v5 = 0;
		  if ( sub_C47A70(a2) )
		  {
			for ( i = 0; i < 6; ++i )
			{
			  if ( sub_C47A50(a2, i) )
			  {
				v2 = (int)sub_5450B0((void *)a2, i);
				if ( sub_4A68B0(a1, v2) != 1 )
				  break;
				sub_C47A80((void *)a2, i);
			  }
			}
			v5 = i != 6;
		  }
		  return v5;
		}

		bool _stdcall cpustuff0/*sub_C979A0*/(int a2)
		{
		  int v2; // eax@9
		  int v3; // eax@9
		  int v4; // eax@10
		  int v5; // eax@10
		  int v7; // [sp+0h] [bp-1Ch]@12
		  int v8; // [sp+4h] [bp-18h]@6
		  void *v9; // [sp+8h] [bp-14h]@1
		  bool v10; // [sp+Fh] [bp-Dh]@6
		  int i; // [sp+10h] [bp-Ch]@3
		  void *v12; // [sp+14h] [bp-8h]@2
		  bool v13; // [sp+1Bh] [bp-1h]@1

		  _asm mov v9, ecx
		  v13 = 0;
		  if ( sub_937B20(a2) )
		  {
			v12 = sub_5FBED0((void *)a2);
			v13 = 1;
			if ( *((_DWORD *)v9 + 39) > 0 )
			{
			  for ( i = *((_DWORD *)v9 + 40);
					*(_DWORD *)sub_6DF650((char *)v9 + 12, i) != 2 && *(_DWORD *)sub_6DF650((char *)v9 + 12, i) != 3;
					i = v7 )
			  {
				v10 = 0;
				v8 = *(_DWORD *)sub_6DF650((char *)v9 + 12, i);
				if ( v8 == 7 )
				{
				  v2 = sub_6DF650((char *)v9 + 12, i + 1);
				  v3 = sub_795AD0(v9, *(_DWORD *)v2);
				  v10 = sub_C97D30(v12, v3);
				}
				else
				{
				  if ( v8 == 8 )
				  {
					v4 = sub_6DF650((char *)v9 + 12, i + 1);
					v5 = sub_795AD0(v9, *(_DWORD *)v4);
					v10 = sub_C97DC0(v12, v5);
				  }
				}
				if ( v10 )
				  v7 = *(_DWORD *)(sub_6DF650((char *)v9 + 12, i) + 4);
				else
				  v7 = *(_DWORD *)(sub_6DF650((char *)v9 + 12, i) + 8);
			  }
			  v13 = *(_DWORD *)sub_6DF650((char *)v9 + 12, i) == 2;
			}
		  }
		  return v13;
		}

		VOIDASMPROC cpustuff1/*sub_4C1BB0*/()
		{
			  _asm
			  {
					mov     eax, [esp+4]
					movq    xmm0, qword ptr [eax]
					movq    qword ptr [ecx], xmm0
					mov     edx, [eax+8]
					mov     [ecx+8], edx
					mov     eax, ecx
					ret		4
			  }
		}

		VOIDASMPROC nop5_0() {NOP_2 NOP_3}

		__forceinline void * _stdcall sub_46BE10(void *_this, void *a2, int a3)
		{
			_asm mov ecx, _this
			return fpustuff2(a2, a3);
		}

		__forceinline int _stdcall sub_4B1920(int _this, int a2, int a3)
		{
			_asm mov ecx, _this
			return fpustuff1(a2, a3);
		}

		__forceinline int _cdecl sub_43AA10(int a1, float a2, int a3)
		{
		  int v3; // ST14_4@1
		  int v4; // ST10_4@1
		  int v5; // ST0C_4@1

		  *(float *)&v3 = a2 * *(float *)(a3 + 8);
		  *(float *)&v4 = a2 * *(float *)(a3 + 4);
		  *(float *)&v5 = a2 * *(float *)a3;
		  sub_A09D90(a1, v5, v4, v3);
		  return a1;
		}

		__forceinline int _stdcall sub_43D450(int _this, int a2, int a3)
		{
		  int v3; // ST14_4@1
		  int v4; // ST10_4@1
		  int v5; // ST0C_4@1

		  *(float *)&v3 = *(float *)(_this + 8) + *(float *)(a3 + 8);
		  *(float *)&v4 = *(float *)(_this + 4) + *(float *)(a3 + 4);
		  *(float *)&v5 = *(float *)_this + *(float *)a3;
		  sub_A09D90(a2, v5, v4, v3);
		  return a2;
		}

		__forceinline int _stdcall sub_4C1BB0(int _this, int a2)
		{
		  *(_DWORD *)_this = *(_DWORD *)a2;
		  *(_DWORD *)(_this + 4) = *(_DWORD *)(a2 + 4);
		  *(_DWORD *)(_this + 8) = *(_DWORD *)(a2 + 8);
		  return _this;
		}

		__forceinline void * _stdcall sub_46C090(void *_this, int a2)
		{
		  void *v2; // ST0C_4@1

		  v2 = _this;
		  memcpy(_this, (const void *)a2, 0x24u);
		  sub_4C1BB0((int)((char *)_this + 36), a2 + 36);
		  *((_DWORD *)v2 + 12) = *(_DWORD *)(a2 + 48);
		  return v2;
		}

		int __stdcall cpustuff2(int a2, int a3)
		{
		  int v2; // ecx@0
		  int v3; // ST14_4@1
		  int v4, v5, v6;

		#pragma pack (push, 1)
		  struct {
			  int v7[3];
			  char v8[0x70-0x64]; // [sp+20h] [bp-70h]@1
			  char v9[0x64-58]; // [sp+2Ch] [bp-64h]@1
			  char v10[0x58-0x34]; // [sp+38h] [bp-58h]@1
			  char v11[0x34-0x10]; // [sp+5Ch] [bp-34h]@1
			  char v12[0x10-0x4]; // [sp+80h] [bp-10h]@1
			  float v13; // [sp+8Ch] [bp-4h]@1
		  } a;
		#pragma pack (pop)

		  _asm mov v2, ecx
		  v3 = v2;
		  a.v13 = *(float *)(v2 + 48) * *(float *)(a3 + 48);
		  memcpy(&a.v11, sub_46BE10((void *)v2, &a.v10, a3), 0x24u);
		  v4 = sub_4B1920(v2, (int)&a.v9, a3 + 36);
		  v5 = sub_43AA10((int)&a.v8, *(float *)(v3 + 48), v4);
		  v6 = sub_43D450(v3 + 36, (int)&a.v7, v5);
		  sub_4C1BB0((int)&a.v12, v6);
		  sub_46C090((void *)a2, (int)&a.v11);
		  return a2;
		}

		int __stdcall sub_43A560(int a2, int a3);

		void * __stdcall fpustuff3(int a2, int a3, int a4) // sub_C3B500
		{
		  void *v4; // esi@1
		  int v5; // eax@1
		  double v6; // st7@1
		  void *result; // eax@1

		  #pragma pack (push, 1)
		  struct {
			  float v8; // [sp+4h] [bp-24h]@1
			  float v9; // [sp+8h] [bp-20h]@1
			  float v10; // [sp+Ch] [bp-1Ch]@1
			  float v11; // [sp+10h] [bp-18h]@1
			  float v12; // [sp+14h] [bp-14h]@1
			  float v13; // [sp+18h] [bp-10h]@1
			  int v14[5]; // [sp+1Ch] [bp-Ch]@1
			  float v15; // [sp+30h] [bp+8h]@1
		  } a;
		  #pragma pack (pop)

		  _asm mov v4, ecx

		  a.v11 = *(float *)a3;
		  a.v12 = *(float *)(a3 + 4);
		  a.v13 = *(float *)(a3 + 8);
		  a.v11 = a.v11 - *(float *)a2;
		  a.v12 = a.v12 - *(float *)(a2 + 4);
		  a.v13 = a.v13 - *(float *)(a2 + 8);
		  a.v8 = *(float *)a4;
		  a.v9 = *(float *)(a4 + 4);
		  a.v10 = *(float *)(a4 + 8);
		  a.v8 = a.v8 - *(float *)a3;
		  a.v9 = a.v9 - *(float *)(a3 + 4);
		  a.v10 = a.v10 - *(float *)(a3 + 8);

		  __asm lea ecx, a.v11
		  v5 = sub_43A560(/*(int)&a.v11, */(int)&a.v14, (int)&a.v8);
		/*  _asm {
			  lea eax, a.v8
			  push eax
			  lea eax, a.v14
			  push eax
			  lea ecx, a.v11
			  mov eax, addr_1_3_10_0::fpustuff3_call_inside
			  call eax
			  mov v5, eax
		  }*/
		  *(float *)v4 = *(float *)v5;
		  *((float *)v4 + 1) = *(float *)(v5 + 4);
		  v6 = *(float *)(v5 + 8);
		  result = v4;
		  a.v15 = (float)v6;
		  *((float *)v4 + 2) = a.v15;
		  *((float *)v4 + 3) = a.v15 * *(float *)(a2 + 8) + *(float *)(a2 + 4) * *((float *)v4 + 1) + *(float *)a2 * *(float *)v4;
		  return result;
		}

		__forceinline float __fastcall sub_416440(int a1)
		{
		  float v1; // ST04_4@1

		  v1 = *(float *)a1 * *(float *)a1 + *(float *)(a1 + 4) * *(float *)(a1 + 4) + *(float *)(a1 + 8) * *(float *)(a1 + 8);
		  return ::sqrt(v1);
		}

		__forceinline int sub_43A640(int _this, int a2, float a3)
		{
		  float v3; // ST1C_4@1
		  int v4; // ST14_4@1
		  int v5; // ST10_4@1
		  int v6; // ST0C_4@1

		  v3 = 1.0f / a3;
		  *(float *)&v4 = v3 * *(float *)(_this + 8);
		  *(float *)&v5 = v3 * *(float *)(_this + 4);
		  *(float *)&v6 = v3 * *(float *)_this;
		  sub_A09D90(a2, v6, v5, v4);
		  return a2;
		}

		int __stdcall sub_43A560(int a2, int a3)
		{
		  int v3; // ST14_4@1
		  int v4; // ST10_4@1
		  int v5; // ST0C_4@1
		  int result; // eax@2
		#pragma pack (push, 1)
		  struct {
			char v7[12]; // [sp+1Ch] [bp-10h]@1
			float v8; // [sp+28h] [bp-4h]@1
		  } a;
		#pragma pack (pop)
		  int _this;
		  _asm mov _this, ecx

		  *(float *)&v3 = *(float *)_this * *(float *)(a3 + 4) - *(float *)(_this + 4) * *(float *)a3;
		  *(float *)&v4 = *(float *)(_this + 8) * *(float *)a3 - *(float *)_this * *(float *)(a3 + 8);
		  *(float *)&v5 = *(float *)(_this + 4) * *(float *)(a3 + 8) - *(float *)(_this + 8) * *(float *)(a3 + 4);
		  sub_A09D90((int)&a.v7, v5, v4, v3);
		  a.v8 = sub_416440((int)&a.v7);
		  //v8 = v5;
		  if ( /**(float *)&v5*/ a.v8 <= 0.000001 )
		  {
			sub_A09D90(a2, 0, 0, 0);
			result = a2;
		  }
		  else
		  {
			sub_43A640((int)&a.v7, a2, *(float *)&a.v8);
			result = a2;
		  }
		  return result;
		}

		int __stdcall fpustuff4/*sub_C4B330*/(int a2, int a3)
		{
		  int result; // eax@1
		  int v4; // edx@1
		  float v5; // ST00_4@1
		  float v6; // ST04_4@1
		  float v7; // ST08_4@1
		  float v8; // ST0C_4@1
		  float v9; // ST10_4@1
		  float v10; // ST14_4@1
		  float v11; // [sp+1Ch] [bp+4h]@1
		  int _this;
		  _asm mov _this, ecx
		  result = a3;
		  v4 = a2;
		  v5 = *(float *)(a3 + 4) * *(float *)(a2 + 4) + *(float *)a2 * *(float *)a3 + *(float *)(a3 + 8) * *(float *)(a2 + 8);
		  v6 = *(float *)(a3 + 12) * *(float *)a2
			 + *(float *)(a3 + 16) * *(float *)(a2 + 4)
			 + *(float *)(a3 + 20) * *(float *)(a2 + 8);
		  v7 = *(float *)(a3 + 24) * *(float *)a2
			 + *(float *)(a3 + 28) * *(float *)(a2 + 4)
			 + *(float *)(a3 + 32) * *(float *)(a2 + 8);
		  v11 = *(float *)(a3 + 48);
		  v8 = v5 * v11;
		  v9 = v11 * v6;
		  v10 = v11 * v7;
		  *(float *)_this = v8;
		  *(float *)(_this + 4) = v9;
		  *(float *)(_this + 8) = v10;
		  *(float *)_this = v8 + *(float *)(a3 + 36);
		  *(float *)(_this + 4) = v9 + *(float *)(a3 + 40);
		  *(float *)(_this + 8) = v10 + *(float *)(a3 + 44);
		  *(float *)(_this + 12) = *(float *)(v4 + 12) * *(float *)(a3 + 48);
		  return result;
		}

}