/***********************************************************************
	This file is a part of SkyBoost project 
		- idea and basic asm implementation by Arisu
		- conversion to c++ and advancing by Alexander Blade
***********************************************************************/

#pragma once

#include <windows.h>

namespace addr_1_3_10_0
{
	//////////////////////////////////////////////////////////////////

	DWORD fpustuff0_calls[] = {0x004A508F, 0x00C47CEF, 0x00C80EEA, 0x00C87175, 0x00C87205, 0x00C97D87, 0x00C97E17, 0x00E6A97B, 0x00E83BEF};
	DWORD fpustuff1_calls[] = {0x0110640E, 0x011067D8, 0x011070FC, 0x01107636, 0x01107A11, 0x011717F8, 0x004B180E, 0x004C0550, 0x004C0761, 0x004C2595, 
						  0x004C572D, 0x004C5788, 0x004C57EA, 0x004C584A, 0x004C58AA, 0x004C5905, 0x004C5967, 0x004C59C7, 0x0051254A, 0x00534D2D, 
						  0x00534D61, 0x00539B9E, 0x0053B065, 0x005496CD, 0x00549FC5, 0x0054BE7F, 0x006117B1, 0x006128D8, 0x0064DB92, 0x0064DC6D, 
						  0x0064DCAD, 0x00667285, 0x0069A628, 0x006A900C, 0x006AAC8A, 0x006B3F03, 0x006C154C, 0x006C1594, 0x006C15DC, 0x006C1624, 
						  0x006C166C, 0x006C16B4, 0x006C16FC, 0x006C1744, 0x006C17BA, 0x006C18C7, 0x006C197E, 0x006E1F5A, 0x006E1F8A, 0x006E2EEE, 
						  0x006E36FD, 0x006E435C, 0x006E49E8, 0x00705806, 0x0071F8C5, 0x0073CE7B, 0x00744D92, 0x0074D038, 0x0077ACDE, 0x007A7D6F, 
						  0x007ACEC1, 0x007ACF5E, 0x007AD008, 0x007AD0FC, 0x007AD7EA, 0x007B05FA, 0x007BC082, 0x007BC53A, 0x007C1BC8, 0x007C2C8C, 
						  0x007CC54A, 0x007F5880, 0x0082FA47, 0x0084959F, 0x0085EB70, 0x0086B819, 0x0086D2AE, 0x0086D310, 0x0087C86A, 0x0087C98B, 
						  0x008A21D8, 0x008C8639, 0x008D7AA1, 0x008D7B55, 0x008D9EAB, 0x0092719A, 0x00967607, 0x009676C6, 0x0098F978, 0x0098FE7F, 
						  0x0099130E, 0x00991ADA, 0x00991B17, 0x0099752B, 0x00997A97, 0x00997AB5, 0x00998977, 0x009CF8E8, 0x009E16DF, 0x009E17B5, 
						  0x009E63C4, 0x009E63F2, 0x009E67B9, 0x009E67E7, 0x009ED5F5, 0x009ED51B, 0x009ED6EF, 0x009FEDF0, 0x00A80BC3, 0x00C05F18, 
						  0x00C0E656, 0x00C0E78B, 0x00C0E87D, 0x00C19AAC, 0x00C1A7DF, 0x00C35761, 0x00C35787, 0x00C419CF, 0x00C419EE, 0x00C71731, 
						  0x00C728B5, 0x00C7F9FC, 0x00C7FB2B, 0x00C8356A, 0x00C83586, 0x00C84C91, 0x00C84CB0, 0x00C84CCF, 0x00CAECC4, 0x00CAF568, 
						  0x00CBCD34, 0x00CC9A73, 0x00CCA283, 0x00CEC8FF, 0x00CF2EC0, 0x00CF4B97, 0x00CF4C94, 0x00CF4D39, 0x00CF4D63, 0x00CF4E2D, 
						  0x00CF4E57, 0x00CF5040, 0x00CF5128, 0x00CF551F, 0x00CFAC98, 0x00CFCB6B, 0x00CFD5AB, 0x00D02744, 0x00D02862, 0x00D02926, 
						  0x00D029BB, 0x00D02A0C, 0x00D0A2C3, 0x00D0A99C, 0x00D0AEC7, 0x00D0AF39, 0x00D0B34A, 0x00D1AF5A, 0x00E58F91, 0x00E59132, 
						  0x00E593EB, 0x00E595AA, 0x00E9F6D1, 0x00E9F712, 0x00EA068B, 0x00EA06CF, 0x00EB1E8A, 0x00EB88BA, 0x00EB8780, 0x00EBC29E, 
						  0x00EBFEC2, 0x00EBFED2, 0x00EBFB1B, 0x00EBFB2B, 0x00EC1A5E, 0x00EC2F19, 0x00EC3839, 0x00EC588F, 0x00EC670E, 0x00EC69CE, 
						  0x00EC6CB4, 0x00EEA736, 0x00EEAD01, 0x00F61819}; 
	DWORD fpustuff2_calls[] = {0x0046993E, 0x00469945, 0x00489798, 0x0048F79A, 0x004C0D57, 0x0052325E, 0x00549F2F, 0x0054BE60, 0x0058FD70, 0x0058FCE6, 
						  0x0058FD2B, 0x005AD4F7, 0x005AF8AE, 0x00624DF7, 0x0063159B, 0x00631666, 0x006317D9, 0x006318AD, 0x0064DEE0, 0x006A9034, 
						  0x006AACAF, 0x006ADE0A, 0x006AEF7E, 0x006AFAA4, 0x006C14FB, 0x006E51E9, 0x006E5211, 0x0072C2FF, 0x0073CE53, 0x00744CAF, 
						  0x00744DF9, 0x0074CFBA, 0x007B2C42, 0x007B2BFC, 0x007B5387, 0x007E1505, 0x007F345F, 0x0085F930, 0x0085F976, 0x00873CD9, 
						  0x0087C834, 0x008C7A5B, 0x008C7F75, 0x008C7F97, 0x008CC755, 0x008CFF73, 0x008D0207, 0x008D022E, 0x008D820E, 0x008D8678, 
						  0x008DACC3, 0x008E086B, 0x009912EF, 0x009989D0, 0x00999328, 0x0099E752, 0x009CF94E, 0x009DB199, 0x009DB89B, 0x009DBF40, 
						  0x009DC2CB, 0x009E17AE, 0x009E18EE, 0x009E63BD, 0x009E63EB, 0x009E67B2, 0x009E67E0, 0x009EC2B5, 0x009EC63A, 0x00C0982B, 
						  0x00C170B9, 0x00C188DB, 0x00C19E98, 0x00C2A2F2, 0x00C2C830, 0x00C2C83F, 0x00C2C962, 0x00C2C953, 0x00C2CA82, 0x00C2CA73, 
						  0x00C42364, 0x00C50416, 0x00C5B8F2, 0x00C716F5, 0x00CC16B2, 0x00CEC0FE, 0x00CEC8F8, 0x00CECFCD, 0x00CF2EB9, 0x00CF4C43, 
						  0x00CF50DB, 0x00CF53FC, 0x00CF54F8, 0x00CFAD5F, 0x00CFCA4F, 0x00CFCD2A, 0x00CFD48E, 0x00CFD765, 0x00D01892, 0x00D0273D, 
						  0x00D07153, 0x00D0AF8B, 0x00D0B302, 0x00D445E9, 0x00E5D969, 0x00E90B71, 0x00EBE2E8, 0x00EBE389}; 

	DWORD fpustuff3_calls[] = {0x00C83810, 0x00C8383D, 0x00C83875, 0x00C8389D, 0x00C838C5, 0x00C838ED, 0x00C8373D, 0x00C83766, 0x00C8379B, 0x00C837C0, 
		0x00C837E8, 0x00C83C8F, 0x00C840B8, 0x00C85612, 0x00C856EE, 0x00C953DE, 0x00C9581F, 0x00C957C5, 0x00E7CBE0};

	DWORD fpustuff3_call_inside = 0x0043A560;

	DWORD fpustuff4_calls[] = {0x00C4BBFD, 0x00C4CCA4, 0x00C4CCF6, 0x00C4FE76};

	DWORD mult_coords_get_sqrt_calls[] = {0x01107481, 0x01107D5C, 0x01107DF4, 0x01172986, 0x01172890, 0x01172B36, 0x01172A40, 0x01172F04, 0x011735F1, 0x00415A7E, 
						  0x0043A4EC, 0x0044F87C, 0x00488864, 0x004987ED, 0x004F225A, 0x004F5586, 0x005000A1, 0x0053988F, 0x00554E9C, 0x0055BAB8, 
						  0x0055BD22, 0x0057CCC6, 0x0057CDDC, 0x0057D006, 0x0057D11C, 0x00591767, 0x0059179C, 0x00591C86, 0x00591CBC, 0x00648D34, 
						  0x00666B68, 0x006784BD, 0x006789A7, 0x0067DE5B, 0x006A80EA, 0x006B10CC, 0x006B12E1, 0x006B1C15, 0x006D2249, 0x006D2278, 
						  0x006D34EA, 0x006D3427, 0x006D3457, 0x006D34BD, 0x006D3877, 0x006D3FCE, 0x006D65B3, 0x006D656D, 0x006D7AC5, 0x006D8345, 
						  0x006D85C0, 0x006D85CB, 0x006D9AFD, 0x006D9F83, 0x006DA37A, 0x006DA7DB, 0x006DA3BB, 0x006E1E66, 0x006E1E74, 0x006E4C96, 
						  0x006F7649, 0x0072C0FB, 0x0072CDD5, 0x0073909B, 0x00748E13, 0x00788C36, 0x00798DCB, 0x007B5077, 0x007C0993, 0x007CFC27, 
						  0x007E2BB6, 0x007E9F4D, 0x00812267, 0x008153AC, 0x008222FE, 0x0082F61C, 0x00833D0E, 0x00833DFA, 0x0083844D, 0x00838465, 
						  0x00838473, 0x008458F7, 0x008505E3, 0x0085133E, 0x00851529, 0x0085153D, 0x0085154B, 0x008515D5, 0x008543B0, 0x008543C8, 
						  0x008543D6, 0x00856420, 0x0086B778, 0x0086B8B5, 0x0086D4C3, 0x0086DCF4, 0x008705A7, 0x0087D04E, 0x0087D760, 0x0087E74A, 
						  0x008A0501, 0x008A8967, 0x008C80CE, 0x008C8C84, 0x008C9D35, 0x008CB294, 0x008CB8C1, 0x008CC15F, 0x008CC56D, 0x008CD308, 
						  0x008CD663, 0x008CED22, 0x008D0847, 0x008D6DF3, 0x008D733B, 0x008DF9ED, 0x008DFE59, 0x008E1042, 0x008E3F55, 0x008E3F69, 
						  0x008E7A9D, 0x008E7B35, 0x008E8007, 0x008EAD97, 0x00921349, 0x00923259, 0x00924AC1, 0x0092729F, 0x00929570, 0x00929FE3, 
						  0x0092A01C, 0x0092A826, 0x0092AE19, 0x0092AEE9, 0x0092AD60, 0x0092BD8E, 0x0092C657, 0x0092D244, 0x0092E2EC, 0x0092E370, 
						  0x0092E37B, 0x0092E38C, 0x0092E3B2, 0x0092E2C4, 0x0092E2D2, 0x0093F86A, 0x00944A2C, 0x0094F2D4, 0x00968341, 0x00976478, 
						  0x00984F08, 0x0098DA08, 0x00996C3B, 0x009BDD48, 0x009C0F18, 0x009F1759, 0x009F17B0, 0x009F181C, 0x00C7264D, 0x00C739ED, 
						  0x00C73A2E, 0x00C73A4E, 0x00C73B8E, 0x00C7FB03, 0x00C86E64, 0x00C870CC, 0x00C8727E, 0x00CA763E, 0x00CA7B08, 0x00CAA49E, 
						  0x00CAA527, 0x00CAA86B, 0x00CAA89C, 0x00CAA942, 0x00CAAAD0, 0x00CAC777, 0x00CAC805, 0x00CAC9F1, 0x00CAC6BF, 0x00CACFCC, 
						  0x00CAC719, 0x00CB3483, 0x00CB3536, 0x00CB37FD, 0x00CB3D3D, 0x00CB8137, 0x00CBC2B7, 0x00CBCF52, 0x00CBCF9F, 0x00CBD374, 
						  0x00CD7BB9, 0x00CD7BC4, 0x00CD82AC, 0x00CD81EA, 0x00CD8245, 0x00CD9B57, 0x00CD9BD0, 0x00CDB8B2, 0x00CDB932, 0x00CDC534, 
						  0x00CDC5CC, 0x00CDCD67, 0x00CDD2DE, 0x00CDE601, 0x00CDE6F2, 0x00CDE9C1, 0x00CDEAB2, 0x00CDEFE8, 0x00CE0A57, 0x00CE0E20, 
						  0x00CE8BA3, 0x00CE898F, 0x00CE8F54, 0x00CE8D02, 0x00CEA341, 0x00CEB56C, 0x00CEBE96, 0x00CEBF66, 0x00CEC2F0, 0x00CED104, 
						  0x00CED0B4, 0x00CED3ED, 0x00CED404, 0x00CED423, 0x00CF4B62, 0x00CF4BD5, 0x00CF4CA8, 0x00CF4CB3, 0x00CF4D81, 0x00CF4D8F, 
						  0x00CF5017, 0x00CF506F, 0x00CF513F, 0x00CF5351, 0x00CF538D, 0x00CFCB81, 0x00CFD5C1, 0x00D02A74, 0x00D02AF3, 0x00D05CE6, 
						  0x00D07958, 0x00D0A270, 0x00D0A5A8, 0x00D0AD1E, 0x00D0AD2F, 0x00D0B0F3, 0x00D0C3AE, 0x00D0F465, 0x00D0FD94, 0x00D0FDC8, 
						  0x00D0FE0B, 0x00D1513C, 0x00D1E087, 0x00D1E400, 0x00D1E417, 0x00D1E35B, 0x00D1E36F, 0x00D1E6B0, 0x00D2C4B0, 0x00D2DD32, 
						  0x00D2E610, 0x00E1EE85, 0x00E1F177, 0x00E1F8C8, 0x00E2A88F, 0x00E33E38, 0x00E4DD72, 0x00E7CACB, 0x00E84B68, 0x00E84E1C, 
						  0x00E84F66, 0x00E850AF, 0x00E997F4, 0x00E991C1, 0x00E9AF78, 0x00E9A8E9, 0x00EB9843, 0x00EB9B53, 0x00EB9ECF, 0x00EBC348, 
						  0x00EE0059, 0x00EEC6FB, 0x00F6139F};

	DWORD not_use_crtfplog_bool = 0x016041B0;

	//////////////////////////////////////////////////////////////////
	DWORD cpustuff0_calls[] = {0x00706E98, 0x00C80793, 0x00C80B7F, 0x011731B0, 0x01173203};
	DWORD cpustuff1_calls[] = {0x0117180C, 0x01171CB2, 0x01171CE2, 0x01171CF1, 0x01171D6B, 0x01172291, 0x0117230F, 0x01172546, 0x01172585, 0x011725A3, 
						  0x01172652, 0x01172D5F, 0x01172DEA, 0x01173DA3, 0x01173DBD, 0x01173F5B, 0x011745C9, 0x01174996, 0x011749C7, 0x011749FA, 
						  0x01174A2F, 0x011748D0, 0x011748FF, 0x01174930, 0x01174963, 0x01174DCF, 0x01174E02, 0x01174E37, 0x01174E6A, 0x01174E9B, 
						  0x01174EB7, 0x01174ED3, 0x01174EEF, 0x01174F0B, 0x01174F27, 0x01174F43, 0x01174F5F, 0x01174D20, 0x01174D4F, 0x01174D80, 
						  0x01174DB3, 0x01175165, 0x0117518D, 0x011751B8, 0x011751F5, 0x01175232, 0x0117525D, 0x01175288, 0x0117512E, 0x011757B0, 
						  0x011757C5, 0x011757DA, 0x011757EF, 0x01175804, 0x01175819, 0x0117582E, 0x01175843, 0x01175858, 0x0117586D, 0x01175882, 
						  0x01175897, 0x011758AC, 0x011758C1, 0x011758D6, 0x011758EB, 0x01175900, 0x01175915, 0x0117592A, 0x0117593F, 0x01175954, 
						  0x01175969, 0x0117597E, 0x01175993, 0x01175B6B, 0x01175B85, 0x01175B9F, 0x011761F1, 0x01176221, 0x01176254, 0x0117629A, 
						  0x011762C2, 0x011762DC, 0x01176BF2, 0x01176CE5, 0x011879DD, 0x011879FD, 0x01187A1D, 0x011B4CBD, 0x011B555D, 0x011B9AED, 
						  0x011C306D, 0x011CFD6D, 0x011E324D, 0x011E326D, 0x00412CC4, 0x00411D24, 0x00411D36, 0x00411D48, 0x0041A8D4, 0x0041AB35, 
						  0x0041AB85, 0x0041ABD5, 0x0041ABE1, 0x0041AC25, 0x0041AC31, 0x0041CCA5, 0x0042D30C, 0x0042D367, 0x0042D377, 0x0042D45C, 
						  0x0042D499, 0x0042D4A8, 0x0042D4E9, 0x0042D4F8, 0x0042D5EB, 0x0042D5FA, 0x00431094, 0x004310A8, 0x00432B19, 0x0043395E, 
						  0x00435B40, 0x00435B54, 0x00435B66, 0x00436F02, 0x00437130, 0x0043714B, 0x00437189, 0x00438F71, 0x0043906F, 0x00439C43, 
						  0x00439C53, 0x00439C62, 0x00439C71, 0x00439C81, 0x00439D06, 0x00439EC3, 0x00439ED2, 0x00439EE1, 0x00439F90, 0x00439F9F, 
						  0x0043A196, 0x0043A1A8, 0x0043A24C, 0x0043A31F, 0x0043A417, 0x0043A477, 0x0043A7BD, 0x0043A7AE, 0x0043A7EF, 0x0043A7FF, 
						  0x0043A80F, 0x0043A81F, 0x0043A7DF, 0x0043A997, 0x0043A9A6, 0x0043A9B5, 0x0043A895, 0x0043A91C, 0x0043B3E8, 0x0043B3F8, 
						  0x0043B4DD, 0x0043B4EC, 0x0043D3AF, 0x0043D439, 0x0043E847, 0x0043E924, 0x0043EB61, 0x0043EFBA, 0x0043F006, 0x0043F052, 
						  0x0043F09B, 0x0043F0E4, 0x0043F12D, 0x0043F176, 0x0043F1BF, 0x0043F261, 0x0043F2AF, 0x0043EEBD, 0x0043EED8, 0x0043F434, 
						  0x0043F48A, 0x0043F531, 0x0043F831, 0x0043F840, 0x0043FA15, 0x0043FAC4, 0x0043FC9E, 0x0044F43B, 0x004504FD, 0x00452BCA, 
						  0x0045405E, 0x00454289, 0x0045DE3D, 0x0045E3A4, 0x0045E41B, 0x0045E42B, 0x0045E69C, 0x0045E852, 0x0045E8C0, 0x0045E8D0, 
						  0x00469B62, 0x00469D42, 0x00469DF2, 0x0046A16E, 0x0046A222, 0x0046C0B3, 0x00484DE3, 0x00488B49, 0x00488B11, 0x00488EB6, 
						  0x00488EC4, 0x00489219, 0x004897CA, 0x004897F8, 0x0048980A, 0x00489AE8, 0x00489AF8, 0x00489B08, 0x0048F07B, 0x0048F166, 
						  0x0048F3F2, 0x0048F616, 0x0048F761, 0x0049366D, 0x00497C91, 0x00498277, 0x00498561, 0x004987B2, 0x004987C1, 0x00498B52, 
						  0x004A337C, 0x004A34A2, 0x004A34C7, 0x004A3F3F, 0x004A688E, 0x004A747B, 0x004B185D, 0x004B1775, 0x004B17B9, 0x004C0152, 
						  0x004C032E, 0x004C0502, 0x004C0770, 0x004C0855, 0x004C0865, 0x004C09CB, 0x004C09DB, 0x004C0ABF, 0x004C0C31, 0x004C0CA1, 
						  0x004C0DF1, 0x004C0E00, 0x004C1A73, 0x004C1B41, 0x004C1B50, 0x004C2140, 0x004C1E4A, 0x004C1E92, 0x004C367D, 0x004C38BF, 
						  0x004C3E6D, 0x004C5747, 0x004C57A5, 0x004C5807, 0x004C5867, 0x004C58C4, 0x004C5922, 0x004C5984, 0x004C59E4, 0x004CA878, 
						  0x004CB93D, 0x004CFF63, 0x004D7DCB, 0x004D7DFA, 0x004D8B91, 0x004D8BB1, 0x004E18A5, 0x004E1905, 0x004E2955, 0x004E3A11, 
						  0x004E3A41, 0x004E4443, 0x004E8D21, 0x004E8C41, 0x004E8C90, 0x004EBA77, 0x004EC196, 0x004EC1A7, 0x004EC2A5, 0x004EC2B5, 
						  0x004EC373, 0x004EC38D, 0x004EC399, 0x004F1ADA, 0x004F1BE0, 0x004F21E5, 0x004F2200, 0x004F222B, 0x004F288F, 0x004F3237, 
						  0x004F324A, 0x004FAA63, 0x004FECD5, 0x004FF2D4, 0x004FF2F4, 0x004FF35B, 0x004FF3EA, 0x004FF3FD, 0x004FF410, 0x004FF423, 
						  0x004FF436, 0x004FF449, 0x004FF9E4, 0x004FFB34, 0x004FFB54, 0x004FFB74, 0x004FFB94, 0x004FFC6B, 0x005061D0, 0x005061FD, 
						  0x0050625C, 0x0050628D, 0x005062C2, 0x00507495, 0x00508C4F, 0x00508D6D, 0x00508D99, 0x00508EC1, 0x0050B0C7, 0x0050B4C6, 
						  0x0050C551, 0x0050C5C1, 0x0050C6E8, 0x0050C7B5, 0x0050C882, 0x0050C94F, 0x0050C95B, 0x0050CA60, 0x0050CA7E, 0x0050C4FE, 
						  0x0050CE52, 0x0050CB92, 0x0050CEC8, 0x0050CB9F, 0x0050CFFB, 0x0050D0CE, 0x0050D1A1, 0x0050D274, 0x0050D280, 0x0050D2BD, 
						  0x0050D2DC, 0x0050D32A, 0x0050D34E, 0x0050CC1C, 0x0050CC31, 0x0050CC46, 0x0050E3E4, 0x0050E624, 0x0050F143, 0x0050F390, 
						  0x00510FEC, 0x005162DB, 0x005161CF, 0x005166C8, 0x005166FE, 0x005187F3, 0x005186A7, 0x005189D6, 0x00518D36, 0x00519518, 
						  0x0051979A, 0x005197C8, 0x005198BF, 0x005198D0, 0x005198E9, 0x005198FA, 0x00519913, 0x00519934, 0x0051994D, 0x00519CF2, 
						  0x00519A4D, 0x0051C75A, 0x0051D71C, 0x0051E383, 0x0051FD60, 0x0051FD6C, 0x0051FD84, 0x0051FD90, 0x0051FDED, 0x005208D9, 
						  0x005210B8, 0x005210EA, 0x0052150F, 0x00521665, 0x005213A2, 0x005217CE, 0x00521870, 0x0052192A, 0x00522F6F, 0x00522FDB, 
						  0x00522D05, 0x005230F3, 0x0052314D, 0x005233FF, 0x00527475, 0x00527A29, 0x00528161, 0x00528211, 0x00529445, 0x0052B9F9, 
						  0x0052BA08, 0x0052C4D1, 0x0052C580, 0x0052C6D6, 0x0052D292, 0x0052D2A3, 0x0052D25D, 0x0052D26C, 0x0052D388, 0x0052EFD9, 
						  0x0052F6AF, 0x0052F6BE, 0x0052F390, 0x0052FB1F, 0x0052FB0F, 0x00533A13, 0x00533A43, 0x00533DBF, 0x00534A84, 0x00534AD1, 
						  0x00534CC7, 0x005358B1, 0x00535918, 0x00537662, 0x005376CC, 0x0053773C, 0x0053779E, 0x005377B0, 0x00537E18, 0x00538021, 
						  0x00539BA7, 0x00539BBB, 0x0053A11C, 0x0053A148, 0x0053A172, 0x0053D4F1, 0x0053D619, 0x0053D8AF, 0x0053D8FD, 0x0053D968, 
						  0x0053DF30, 0x0053DFCA, 0x0053F14C, 0x0053F2ED, 0x0053F631, 0x0053EF24, 0x00540281, 0x0054131A, 0x00541340, 0x0054135D, 
						  0x0054137A, 0x0054139A, 0x005411D8, 0x005411E5, 0x005433DB, 0x0054349B, 0x0054362D, 0x00543648, 0x005432DC, 0x00545600, 
						  0x005455EE, 0x00549495, 0x00549589, 0x005495B9, 0x00549744, 0x00549FCE, 0x00549FB2, 0x0054BEAF, 0x0054C636, 0x0054C645, 
						  0x0054CB11, 0x0054CB4D, 0x005546A4, 0x00554E94, 0x0055564E, 0x00556773, 0x0055B211, 0x0055B220, 0x0055B916, 0x0055B979, 
						  0x0055B9D7, 0x0055BAAE, 0x0055B85D, 0x0055B86A, 0x0055BD91, 0x0055BDC9, 0x0055BDF5, 0x0055BE77, 0x0055BF01, 0x0056E1A2, 
						  0x0056E252, 0x0056E322, 0x0056E333, 0x00574FFA, 0x00575014, 0x00574FD0, 0x0057709C, 0x0057CA22, 0x0057CB62, 0x005813F5, 
						  0x0058167B, 0x0058F77C, 0x005928EF, 0x005929EF, 0x00592AB6, 0x00592DDC, 0x00592E0A, 0x00592ED3, 0x00592EE4, 0x00592F13, 
						  0x00592860, 0x00592878, 0x00597E33, 0x00597E4B, 0x00597E8D, 0x00597F56, 0x0059E116, 0x005A0F63, 0x005A0F84, 0x005A0EB6, 
						  0x005A464F, 0x005A4718, 0x005A4729, 0x005A5BC5, 0x005A5BE1, 0x005A6B3E, 0x005AD284, 0x005AD2A0, 0x005AD255, 0x005AD37B, 
						  0x005AD499, 0x005AF849, 0x005AF96B, 0x005AF5DE, 0x005B1B83, 0x005B66BB, 0x005B6703, 0x005B7AAF, 0x005C4DE5, 0x005C4DF5, 
						  0x005FE957, 0x005FFED1, 0x00611739, 0x00611758, 0x006117BF, 0x006128FB, 0x00614003, 0x00614E49, 0x00615052, 0x006193AF, 
						  0x006193BF, 0x0061B4D2, 0x0061B4FF, 0x0061B419, 0x0061B459, 0x0061B48D, 0x006204F4, 0x0062177E, 0x006217A9, 0x00621C4C, 
						  0x00623E1A, 0x00623E7A, 0x00623EB6, 0x00623F04, 0x00623F52, 0x00623FB2, 0x00623FEE, 0x0062403C, 0x0063059A, 0x006305DE, 
						  0x00630634, 0x0063067C, 0x00630695, 0x006306AE, 0x006306C7, 0x0063074C, 0x006307B4, 0x006307F8, 0x0063084E, 0x00630896, 
						  0x006308AF, 0x006308C8, 0x006308E1, 0x00630532, 0x0063148F, 0x00632019, 0x00637E0D, 0x00637F71, 0x00644C9E, 0x00644CCE, 
						  0x00647030, 0x00646FF6, 0x00647144, 0x00647E0C, 0x00648132, 0x0064C899, 0x0064CF6D, 0x0064DC82, 0x00650007, 0x006500D1, 
						  0x006500F8, 0x00653B69, 0x00653D54, 0x00654C46, 0x00654D19, 0x00655203, 0x00655295, 0x00655385, 0x006554C2, 0x00655558, 
						  0x0065579D, 0x00655DC1, 0x00655F0D, 0x006560E6, 0x006664C1, 0x00666BF8, 0x00669A86, 0x00669CE6, 0x00669D26, 0x00669EB8, 
						  0x0066A0A4, 0x0066A0D5, 0x0066C23C, 0x0066CFB7, 0x006701A2, 0x0067081E, 0x00672150, 0x0067213E, 0x006723CB, 0x00674A09, 
						  0x00674A1B, 0x00674A2A, 0x00673E30, 0x006749EE, 0x00677722, 0x00678143, 0x0067844C, 0x006787EB, 0x00678936, 0x0067A8A8, 
						  0x0067AD63, 0x0067B198, 0x0067DE42, 0x0067E16A, 0x0068062C, 0x006806CC, 0x006814AE, 0x00681428, 0x006830F7, 0x00685AB7, 
						  0x00689663, 0x0068F221, 0x00691C08, 0x00693D12, 0x00698BD4, 0x00698BFC, 0x00698C67, 0x00698C7A, 0x00698ADC, 0x00698CDC, 
						  0x00698CFD, 0x00698D09, 0x00698B49, 0x00698BA1, 0x00698F66, 0x00699654, 0x0069967C, 0x006996E7, 0x006996FA, 0x0069955C, 
						  0x00699756, 0x00699777, 0x00699783, 0x006995C9, 0x00699621, 0x00699D09, 0x0069A2A7, 0x0069A5E3, 0x0069A787, 0x0069A55C, 
						  0x006A208B, 0x006A2098, 0x006A275D, 0x006A2782, 0x006A2C0B, 0x006A2C18, 0x006A80CD, 0x006A8D2B, 0x006A8D3A, 0x006AA780, 
						  0x006A96EF, 0x006A973C, 0x006A975B, 0x006A977A, 0x006A9875, 0x006A9018, 0x006AC1A8, 0x006AB420, 0x006AB46A, 0x006AB47F, 
						  0x006AB494, 0x006AB4A4, 0x006AAC93, 0x006ADD39, 0x006AE061, 0x006AE64D, 0x006AF276, 0x006AF288, 0x006AF298, 0x006AF2A8, 
						  0x006AFADE, 0x006AFB01, 0x006AFB35, 0x006AFBD7, 0x006AFBF1, 0x006AFC09, 0x006AFC60, 0x006AF9DF, 0x006AF9F1, 0x006B1073, 
						  0x006B10A6, 0x006B10AF, 0x006B1230, 0x006B127F, 0x006B12BB, 0x006B12C4, 0x006B180E, 0x006B1820, 0x006B1832, 0x006B1848, 
						  0x006B1861, 0x006B1877, 0x006B1AE1, 0x006B1AF3, 0x006B1B05, 0x006B1B1B, 0x006B1B34, 0x006B1B4A, 0x006B1F4C, 0x006B2071, 
						  0x006B2083, 0x006B2095, 0x006B20ED, 0x006B2120, 0x006B2135, 0x006B215F, 0x006B22A9, 0x006B22BE, 0x006B22D3, 0x006B2337, 
						  0x006B23A9, 0x006B23C1, 0x006B1F19, 0x006B1F2B, 0x006B3E38, 0x006B3F0C, 0x006B402B, 0x006B48F6, 0x006B4909, 0x006BBA38, 
						  0x006BBCAE, 0x006C11D2, 0x006C12E1, 0x006C12F3, 0x006C1305, 0x006C1319, 0x006C132B, 0x006C133D, 0x006C1387, 0x006C1399, 
						  0x006C13AB, 0x006C13BF, 0x006C13D1, 0x006C13E3, 0x006C1412, 0x006C1430, 0x006C1440, 0x006C1465, 0x006C1498, 0x006C1558, 
						  0x006C15A0, 0x006C15E8, 0x006C1630, 0x006C1678, 0x006C16C0, 0x006C1708, 0x006C1750, 0x006C17D7, 0x006C18DD, 0x006C1994, 
						  0x006C19C8, 0x006C19F7, 0x006C1B5B, 0x006C1B8A, 0x006C23AE, 0x006C23DC, 0x006C2409, 0x006C2437, 0x006C76EF, 0x006C78F2, 
						  0x006C796D, 0x006C7995, 0x006C79BD, 0x006C7B42, 0x006C7B56, 0x006C7DCB, 0x006C7E50, 0x006C7E64, 0x006C82DE, 0x006C82FD, 
						  0x006C8379, 0x006C7FC0, 0x006C8521, 0x006C865D, 0x006C7FDF, 0x006C8693, 0x006C86B2, 0x006C8702, 0x006C8003, 0x006C8A53, 
						  0x006C8BA1, 0x006C8BB0, 0x006C8BBF, 0x006C8D4B, 0x006C8EE4, 0x006C8E4B, 0x006CDA96, 0x006CDAA8, 0x006CDABA, 0x006D1EEF, 
						  0x006D1F03, 0x006D2219, 0x006D23D3, 0x006D37CF, 0x006D36F6, 0x006D370C, 0x006D39D0, 0x006D3FB4, 0x006D4066, 0x006D4116, 
						  0x006D424D, 0x006D4BF2, 0x006D6236, 0x006D632F, 0x006D7924, 0x006D7988, 0x006D7817, 0x006D782A, 0x006D7AA8, 0x006D7B2F, 
						  0x006D7DAE, 0x006D7B5E, 0x006D7B86, 0x006D7FC0, 0x006D83D3, 0x006D8255, 0x006D831B, 0x006D8583, 0x006D859D, 0x006D8718, 
						  0x006D8B5A, 0x006D8BA8, 0x006D8CC3, 0x006D8D76, 0x006D8DF8, 0x006D8E6F, 0x006D92D3, 0x006D9392, 0x006D9501, 0x006D9AB9, 
						  0x006DA03A, 0x006DA087, 0x006DA0D9, 0x006DA1E0, 0x006DA2CD, 0x006DA319, 0x006D9F08, 0x006D9F14, 0x006D9F6F, 0x006DA48D, 
						  0x006DA366, 0x006DA7BE, 0x006DA39B, 0x006DAA3D, 0x006DA437, 0x006DA443, 0x006DC61E, 0x006DC631, 0x006DC7C4, 0x006DC884, 
						  0x006DD441, 0x006DD508, 0x006DD5BC, 0x006DDB46, 0x006DDBE2, 0x006DE1AE, 0x006DE2B8, 0x006DE36F, 0x006DE5A4, 0x006DE632, 
						  0x006DF144, 0x006DF1D7, 0x006DF6DA, 0x006E047F, 0x006E04A7, 0x006E04CF, 0x006E0632, 0x006E0683, 0x006E0D56, 0x006E0F20, 
						  0x006E1216, 0x006E1364, 0x006E13A4, 0x006E1470, 0x006E1607, 0x006E18A0, 0x006E18BF, 0x006E1F66, 0x006E1F96, 0x006E1FD6, 
						  0x006E200B, 0x006E1BEB, 0x006E252F, 0x006E1C0F, 0x006E280E, 0x006E1C4B, 0x006E2B54, 0x006E2B9B, 0x006E2BEF, 0x006E2BFF, 
						  0x006E2C0F, 0x006E2BDF, 0x006E2D8D, 0x006E2E98, 0x006E2F16, 0x006E3434, 0x006E3533, 0x006E3DA3, 0x006E3DF4, 0x006E3E34, 
						  0x006E3586, 0x006E35A5, 0x006E43B0, 0x006E47B4, 0x006E4900, 0x006E4924, 0x006E4A0C, 0x006E4EE7, 0x006E5000, 0x006E5011, 
						  0x006E5248, 0x006E52A4, 0x006E531A, 0x006E551D, 0x006E554E, 0x006E56DD, 0x006E57B2, 0x006E5912, 0x006E5824, 0x006E5843, 
						  0x006E5886, 0x006E58C5, 0x006E58EC, 0x006E599E, 0x006E59D7, 0x006E5BFC, 0x006E6114, 0x006E63E0, 0x006E63F2, 0x006E6404, 
						  0x006E63CE, 0x006E643E, 0x006E6D81, 0x006E7162, 0x006E7C64, 0x006E7C83, 0x006E7DF4, 0x006E7E08, 0x006E7E4F, 0x006E7EFF, 
						  0x006E7B05, 0x006E7B24, 0x006E8201, 0x006E87CE, 0x006EFABE, 0x006F45D8, 0x006F6349, 0x006FD9A0, 0x006FE4EC, 0x006FE542, 
						  0x006FE613, 0x006FE629, 0x006FE63F, 0x006FE655, 0x006FE43E, 0x006FE494, 0x006FF3A1, 0x006FF737, 0x00703C7B, 0x007057EC, 
						  0x0070580F, 0x007061E6, 0x007056C3, 0x007074BE, 0x00707761, 0x00707CAA, 0x00707BB6, 0x00707BCE, 0x00707C36, 0x00707E59, 
						  0x00707F52, 0x00707F67, 0x0070800F, 0x007084E2, 0x007092D7, 0x00709311, 0x00709336, 0x00718112, 0x0071861A, 0x0071881B, 
						  0x00719135, 0x00719148, 0x007197D0, 0x0071A37D, 0x0071EE0E, 0x0071F438, 0x0071F3BE, 0x0071F691, 0x0071F69E, 0x0071F8CE, 
						  0x0071F510, 0x0071F51D, 0x0072B754, 0x0072C0E4, 0x0072C820, 0x0072CAAE, 0x0072CC49, 0x0072CE62, 0x0072E1F8, 0x00736A18, 
						  0x00738FE1, 0x0073901A, 0x0073905D, 0x007390C9, 0x007390F7, 0x0073912B, 0x00739137, 0x0073B0F3, 0x0073B186, 0x0073B6BC, 
						  0x0073B7E2, 0x0073B873, 0x0073B96D, 0x0073BADE, 0x0073C0E3, 0x0073C695, 0x0073CD11, 0x0073CE87, 0x0073CF4C, 0x0073D0BE, 
						  0x0073CC5F, 0x0073D43F, 0x0073D785, 0x0073D923, 0x0073DA4E, 0x0073DD48, 0x0073DD9F, 0x0073DDAC, 0x0073DDFC, 0x0073DE18, 
						  0x0073DC82, 0x0073DF66, 0x0073DF79, 0x0073E09F, 0x0073E0B7, 0x0073E0DD, 0x0073E123, 0x0073E19E, 0x0073E1B6, 0x0073E1F2, 
						  0x0073DF22, 0x0073DF2F, 0x0073E4F1, 0x0073EBB2, 0x0073F0B3, 0x0073F0F6, 0x00744A8A, 0x00744B0A, 0x00744B52, 0x00744B73, 
						  0x007480DC, 0x0074811E, 0x0074C074, 0x0074CE72, 0x0074D041, 0x0074EC10, 0x0074F59C, 0x0074F5AC, 0x0074F5D1, 0x0074F873, 
						  0x0074F887, 0x0074F7CF, 0x0075002C, 0x00752408, 0x00754118, 0x007544F6, 0x0076175A, 0x0076176A, 0x0076281D, 0x00765BE9, 
						  0x00765FC5, 0x00765FD3, 0x00766077, 0x00766088, 0x007660BC, 0x007660CA, 0x00766114, 0x00766122, 0x00766239, 0x00766247, 
						  0x00765CEE, 0x00765CFC, 0x00768E18, 0x00769039, 0x00779E68, 0x00779EC9, 0x0077A5EE, 0x0077AB71, 0x0077ACE7, 0x0077ABF3, 
						  0x0077B233, 0x0077B26D, 0x0077B27F, 0x0077AC04, 0x0077AC8C, 0x0077B575, 0x0077DCBA, 0x0077E1C0, 0x0077E21B, 0x0077E497, 
						  0x0077E549, 0x0077E582, 0x0077E713, 0x0077E72A, 0x007871E9, 0x00787C24, 0x00787C44, 0x0078A041, 0x0078A05A, 0x0078B2B9, 
						  0x0078C151, 0x0078C196, 0x0078C2ED, 0x0078C2FB, 0x0078C1B3, 0x0078CD8A, 0x0078CF54, 0x0078D70A, 0x0078DB94, 0x0078DBA1, 
						  0x0078DC29, 0x0078DC35, 0x00798EBD, 0x00798EE8, 0x0079965F, 0x0079A273, 0x0079C274, 0x007A3B9C, 0x007A5AEB, 0x007A5BE4, 
						  0x007A6C20, 0x007A6C2C, 0x007A6D5B, 0x007A70D7, 0x007A71A9, 0x007A736A, 0x007A7D78, 0x007AC336, 0x007AC36A, 0x007AC3F8, 
						  0x007AC5AE, 0x007AC5CA, 0x007AC405, 0x007AC6B7, 0x007AC6E9, 0x007AC703, 0x007AC71F, 0x007AC73B, 0x007AC74A, 0x007ACC0A, 
						  0x007ACC5E, 0x007ACE4C, 0x007AD014, 0x007AD02B, 0x007AD249, 0x007AD22F, 0x007AD591, 0x007AD7F3, 0x007ADA00, 0x007ADA85, 
						  0x007AE116, 0x007AE146, 0x007AE1E6, 0x007B251F, 0x007B2B72, 0x007B41BE, 0x007B5EE9, 0x007B5F43, 0x007B5F55, 0x007B509F, 
						  0x007B4EF9, 0x007B52FC, 0x007B5316, 0x007B558B, 0x007B559D, 0x007B5BDF, 0x007B6A17, 0x007B6A3C, 0x007B6ACB, 0x007B6B23, 
						  0x007B7B51, 0x007B7BA6, 0x007B86F8, 0x007B9303, 0x007BC01B, 0x007BC08E, 0x007BAD65, 0x007BC503, 0x007BC543, 0x007BC70A, 
						  0x007BC755, 0x007BC8B6, 0x007BC901, 0x007BCA81, 0x007BCACC, 0x007BCD23, 0x007BF0F0, 0x007BF008, 0x007BF0BD, 0x007BF906, 
						  0x007BFA1E, 0x007BFB2D, 0x007C0973, 0x007C1BD1, 0x007C1DDB, 0x007C1DE7, 0x007C2822, 0x007C2C95, 0x007C2CCF, 0x007C2CF2, 
						  0x007C285B, 0x007C28A0, 0x007C28EE, 0x007C33E9, 0x007C33F8, 0x007C5255, 0x007C5283, 0x007C84B6, 0x007C8A4C, 0x007C8EE6, 
						  0x007C9089, 0x007C8FCE, 0x007C9175, 0x007C9215, 0x007CB9EF, 0x007CBE86, 0x007CC2EB, 0x007CC1B6, 0x007CC241, 0x007CC56D, 
						  0x007CCA18, 0x007CE82C, 0x007CE8D0, 0x007CF642, 0x007CF8FF, 0x007CF983, 0x007D3D1D, 0x007D3D8D, 0x007D4AE8, 0x007D625C, 
						  0x007D630B, 0x007D8336, 0x007D840F, 0x007D8B25, 0x007D8C8C, 0x007D8D0C, 0x007D8B8C, 0x007D8C09, 0x007D8E3E, 0x007D9735, 
						  0x007D99AD, 0x007D9A01, 0x007DEC6D, 0x007DEC79, 0x007E20AA, 0x007E2564, 0x007E2BA2, 0x007E2C15, 0x007E2B2C, 0x007E3AC6, 
						  0x007E3B13, 0x007E3B9C, 0x007E3BD0, 0x007E3CA0, 0x007E3CBC, 0x007E3CCE, 0x007E3D09, 0x007E9EE4, 0x007E9EF7, 0x007EFDD6, 
						  0x007EF942, 0x007EF9C9, 0x007F14A5, 0x007F1501, 0x007F28E1, 0x007F2920, 0x007F2943, 0x007F297E, 0x007F2E34, 0x007F331D, 
						  0x007F333A, 0x007F3726, 0x007F3754, 0x007F3766, 0x007F3A5C, 0x007F5889, 0x007F5D2B, 0x007F5D3C, 0x00807863, 0x00807AF8, 
						  0x00807A01, 0x00807B5C, 0x00807BC2, 0x00807BF4, 0x00807C07, 0x00807C40, 0x00807C8C, 0x00807C9F, 0x00807CF0, 0x00807D03, 
						  0x00807D29, 0x00807D3C, 0x00807D62, 0x00807D75, 0x00807D81, 0x00807ABF, 0x0080B2C5, 0x0080BA67, 0x0080BAE4, 0x0080FE1F, 
						  0x0080FE2B, 0x00811939, 0x00811970, 0x00811C8E, 0x00811CA8, 0x0081230A, 0x00812324, 0x00812EDA, 0x00814823, 0x00814871, 
						  0x008147A1, 0x00815ACD, 0x00815E20, 0x00814CF1, 0x008155ED, 0x00815605, 0x00819680, 0x0081A161, 0x0081A59C, 0x0081A5C3, 
						  0x0081A5E4, 0x0081AF83, 0x0081B13C, 0x00818958, 0x00818D2A, 0x0081CD28, 0x0081CD3F, 0x0081EC32, 0x0081F690, 0x00821044, 
						  0x00821061, 0x00820F6C, 0x00820FBD, 0x0082102F, 0x00822BA4, 0x008230A1, 0x00823430, 0x008234A0, 0x00823963, 0x008239AE, 
						  0x008239FC, 0x00823A48, 0x00823A88, 0x00823D2A, 0x00823D84, 0x00823D99, 0x00823DAE, 0x00823DC3, 0x00823DDB, 0x00823DF3, 
						  0x008247F0, 0x0082547D, 0x00825603, 0x00825630, 0x00825739, 0x0082574C, 0x008259D5, 0x008259E8, 0x00825373, 0x00825383, 
						  0x00825393, 0x008253A3, 0x008253B6, 0x008253C9, 0x0082CE83, 0x0082D841, 0x0082DA48, 0x0082DAA2, 0x0082DBBB, 0x0082DE55, 
						  0x0082DE87, 0x0082DDEB, 0x0082DDFC, 0x0082DE24, 0x0082E18D, 0x0082E19E, 0x0082E4E6, 0x0082E4F7, 0x0082FDA7, 0x0082FB96, 
						  0x0082FC8D, 0x0083228E, 0x00832C80, 0x0083379A, 0x008337E3, 0x008339D3, 0x008339EA, 0x00833A62, 0x00833DEF, 0x008377D7, 
						  0x00837DF0, 0x00837E25, 0x0083D132, 0x0083D864, 0x0083D87A, 0x0083E0E1, 0x0083EBEE, 0x0084032D, 0x0084033D, 0x00840380, 
						  0x00840393, 0x008403A6, 0x008403B9, 0x00840EE0, 0x0084114E, 0x0084320E, 0x0084344A, 0x008435DF, 0x00845724, 0x0084597F, 
						  0x00848660, 0x0084885B, 0x0084893A, 0x00848982, 0x00848A5F, 0x0084905E, 0x00848C67, 0x008495B8, 0x008495F0, 0x00849A01, 
						  0x0084CF57, 0x0084D0C7, 0x0084D68F, 0x0084D946, 0x0084F477, 0x00850B10, 0x00850FFE, 0x008514EE, 0x00851521, 0x00851736, 
						  0x008537C2, 0x00853A17, 0x00853D41, 0x00853D6F, 0x0085B6C6, 0x0085B6D9, 0x0085B7DB, 0x0085C29A, 0x0085CF2A, 0x0085CF3C, 
						  0x0085D431, 0x0085D44F, 0x0085D4B5, 0x0085D4CB, 0x0085D517, 0x0085D52D, 0x0085D8B5, 0x0085D8C5, 0x0085DE90, 0x0085DF3E, 
						  0x0085DF4B, 0x0085DF76, 0x0085DAEF, 0x0085E2EC, 0x0085E2FA, 0x0085E9A9, 0x0085E9BC, 0x0085EB83, 0x0085F721, 0x0085F753, 
						  0x0085F765, 0x0085FFC1, 0x00860C9E, 0x00860D4B, 0x00860E51, 0x0086118E, 0x00861260, 0x008612AB, 0x00860F93, 0x00860FA5, 
						  0x00861429, 0x0086257F, 0x0086266F, 0x00862680, 0x00865483, 0x0086556D, 0x008663B7, 0x00866F5F, 0x0086A9E4, 0x0086B746, 
						  0x0086CC7D, 0x0086D319, 0x0086D497, 0x0086D531, 0x0086D7D4, 0x0086D901, 0x0086D944, 0x0086D962, 0x0086DB27, 0x0086E437, 
						  0x0086E485, 0x0086E4FC, 0x0086E54A, 0x0086E325, 0x0086E3C0, 0x0086F868, 0x00872976, 0x0087304F, 0x00873D66, 0x00875E37, 
						  0x00875F35, 0x00875FBD, 0x00875D0C, 0x0087746E, 0x0087749E, 0x00878ABA, 0x0087C74F, 0x0087C765, 0x0087C87D, 0x0087C99E, 
						  0x0087CB07, 0x0087CB1C, 0x0087CC6B, 0x0087D199, 0x0087D3B8, 0x0087D44B, 0x0087D483, 0x0087D490, 0x0087D4CA, 0x0087D51A, 
						  0x0087D5A8, 0x0087D5F2, 0x0087D667, 0x0087D6F2, 0x0087D881, 0x0087D8A1, 0x0087D983, 0x0087D9CF, 0x0087D26E, 0x0088FA2F, 
						  0x008911DE, 0x00891410, 0x008913FE, 0x00893BB2, 0x00893BBF, 0x00893BCC, 0x00893BD9, 0x00893CB0, 0x00893CC2, 0x00893CD4, 
						  0x00893CE6, 0x00893CF8, 0x00893C9E, 0x00893FE3, 0x00894063, 0x008940EC, 0x0089751D, 0x008976C0, 0x008977CA, 0x00897B20, 
						  0x0089BA7D, 0x0089BA97, 0x0089BAD9, 0x0089BABF, 0x0089BBE0, 0x0089BD53, 0x0089BD60, 0x0089BE32, 0x0089BE41, 0x0089BED2, 
						  0x0089BEE1, 0x0089BF42, 0x0089BFC6, 0x0089C0A2, 0x0089C0D2, 0x0089C0EC, 0x0089C0FC, 0x0089C116, 0x0089C1BC, 0x0089D2BE, 
						  0x0089D2D1, 0x0089DCD0, 0x0089DC88, 0x0089E8FB, 0x0089E908, 0x0089F8CC, 0x0089FB02, 0x0089FB43, 0x0089FC19, 0x008A014F, 
						  0x008A015F, 0x008A05C0, 0x008A05D2, 0x008A0DC8, 0x008A0F8E, 0x008A0FE0, 0x008A0FF0, 0x008A2041, 0x008A2071, 0x008A20B1, 
						  0x008A21E1, 0x008A20E8, 0x008A2810, 0x008A287F, 0x008A28A8, 0x008A28B4, 0x008A8953, 0x008A88F5, 0x008AB084, 0x008AE650, 
						  0x008AE688, 0x008AE6FF, 0x008AF23F, 0x008AF269, 0x008AF2C5, 0x008B01D5, 0x008B0213, 0x008B0451, 0x008B0471, 0x008B049D, 
						  0x008B048E, 0x008B0686, 0x008B0877, 0x008B0B1D, 0x008B0B35, 0x008B0B65, 0x008B0B7D, 0x008B094C, 0x008B0959, 0x008B0ED2, 
						  0x008B100F, 0x008B16C3, 0x008B1F06, 0x008B1F18, 0x008B2013, 0x008B2023, 0x008B39A9, 0x008B3B2F, 0x008B3B8B, 0x008B3B9E, 
						  0x008B422D, 0x008B4248, 0x008B4263, 0x008B431C, 0x008B434E, 0x008B4368, 0x008B441A, 0x008B442A, 0x008B443A, 0x008B44BF, 
						  0x008B44E7, 0x008B9000, 0x008B900D, 0x008C421B, 0x008C4241, 0x008C52CA, 0x008C5331, 0x008C5370, 0x008C5535, 0x008C50DE, 
						  0x008C512E, 0x008C557F, 0x008C55DD, 0x008C6961, 0x008C6DBD, 0x008C7770, 0x008C7D17, 0x008C7DCF, 0x008C85D6, 0x008C8642, 
						  0x008C8892, 0x008C9194, 0x008C9540, 0x008C9A89, 0x008CA590, 0x008CA5A3, 0x008CA8C2, 0x008CA8D5, 0x008CB653, 0x008CB984, 
						  0x008CC123, 0x008CC1B6, 0x008CC484, 0x008CC4B3, 0x008CC5A9, 0x008CCA1A, 0x008CCA4A, 0x008CCA5F, 0x008CCD30, 0x008CCD69, 
						  0x008CCDB3, 0x008CCE1D, 0x008CCE31, 0x008CD9BE, 0x008CE097, 0x008CEB20, 0x008CF2E0, 0x008CF2F3, 0x008D070B, 0x008D04E4, 
						  0x008D0EFB, 0x008D0F2F, 0x008D0FD9, 0x008D0E61, 0x008D0E9D, 0x008D172A, 0x008D1679, 0x008D18ED, 0x008D18FA, 0x008D1B6A, 
						  0x008D2DF7, 0x008D2E18, 0x008D2D93, 0x008D3FB9, 0x008D3FC9, 0x008D40F2, 0x008D4104, 0x008D4332, 0x008D4356, 0x008D4BA3, 
						  0x008D4BEE, 0x008D4C00, 0x008D4C15, 0x008D57E0, 0x008D57F4, 0x008D589C, 0x008D5939, 0x008D5977, 0x008D5B01, 0x008D5B42, 
						  0x008D5BA7, 0x008D5C0C, 0x008D72AA, 0x008D793A, 0x008D7966, 0x008D796F, 0x008D79FC, 0x008D7A5B, 0x008D7B5E, 0x008D81DF, 
						  0x008D8649, 0x008D911F, 0x008D9E98, 0x008D9EB4, 0x008DAF3A, 0x008DAF4D, 0x008DB1DC, 0x008DB1EF, 0x008DDB13, 0x008DDB2C, 
						  0x008DE931, 0x008DE94F, 0x008DE98C, 0x008DEA4D, 0x008DEA5C, 0x008DEC7F, 0x008DEC6F, 0x008DF63C, 0x008DF00E, 0x008DFC55, 
						  0x008DFD34, 0x008DFD4E, 0x008DFD93, 0x008DFDB8, 0x008DFE39, 0x008E0780, 0x008E0B32, 0x008E0B72, 0x008E0B81, 0x008E0601, 
						  0x008E12A3, 0x008E12D1, 0x008E1307, 0x008E135F, 0x008E136D, 0x008E14CB, 0x008E14DA, 0x008E1C9A, 0x008E1EA5, 0x008E1F7A, 
						  0x008E21B4, 0x008E2949, 0x008E2A84, 0x008E3449, 0x008E3458, 0x008E3A66, 0x008E3ABA, 0x008E3B36, 0x008E3CD3, 0x008E3DC5, 
						  0x008E3F29, 0x008E3FF3, 0x008E7291, 0x008E72B2, 0x008E7321, 0x008E732D, 0x008E7AF2, 0x008E7E63, 0x008E7F2B, 0x008E7F45, 
						  0x008E7DC5, 0x008E7E31, 0x008E8362, 0x008E8271, 0x008E83CB, 0x008E846E, 0x008E829B, 0x008E8316, 0x008E8BB5, 0x008E90B9, 
						  0x008E8FF9, 0x008E900B, 0x008E901D, 0x008E902F, 0x008E9041, 0x008E921D, 0x008E92D1, 0x008E99E7, 0x008E993E, 0x008EA085, 
						  0x008EA17B, 0x008EA18B, 0x008EA19B, 0x008EA1AB, 0x008EA1BB, 0x008EA214, 0x008EA8A5, 0x008EAC59, 0x008EAC80, 0x008EAE2C, 
						  0x008EAEA0, 0x008EAEB3, 0x008EB0EB, 0x008EB101, 0x008EB267, 0x008EB2F3, 0x008EB329, 0x008ECA1C, 0x008ECA2A, 0x008ECA99, 
						  0x008EFC85, 0x008EFDCB, 0x008F1828, 0x008F183A, 0x008F2C35, 0x008F2C66, 0x008F2EBA, 0x008F2ECA, 0x008F3022, 0x008F303D, 
						  0x008F3804, 0x008F3816, 0x008F38EF, 0x008F3C2F, 0x008F3C3F, 0x008F3C96, 0x008F3DB1, 0x008F3DC0, 0x008F46F0, 0x008F470E, 
						  0x008F4591, 0x008F45ED, 0x008F5114, 0x008F8591, 0x008F9C5E, 0x008FA358, 0x008FDD1F, 0x0091CAA6, 0x0091D22E, 0x0091DA79, 
						  0x0091EE3B, 0x0091EFD5, 0x0091F3F4, 0x0091F561, 0x0091F7B8, 0x0091FAB0, 0x0091FBD0, 0x0092083A, 0x0092189D, 0x00921921, 
						  0x00921C63, 0x009228A2, 0x00924D0B, 0x00925463, 0x00926D77, 0x00926E3E, 0x00926E52, 0x00926FC1, 0x00926FDC, 0x0092744A, 
						  0x00927E4F, 0x00927E3F, 0x009281A5, 0x009285D8, 0x00928618, 0x00928658, 0x009286AE, 0x00928EDC, 0x00929429, 0x00929435, 
						  0x00929441, 0x00929418, 0x00929A0D, 0x009299FF, 0x00929F65, 0x00929F74, 0x0092A152, 0x0092A283, 0x0092A2FE, 0x0092A9D8, 
						  0x0092AA3E, 0x0092AA4A, 0x0092AA74, 0x0092AACA, 0x0092AAD8, 0x0092AAE6, 0x0092AB00, 0x0092AB0E, 0x0092AC82, 0x0092AC90, 
						  0x0092AC9E, 0x0092AEC5, 0x0092AF10, 0x0092AD15, 0x0092ADB7, 0x0092B1FD, 0x0092B25B, 0x0092B110, 0x0092B297, 0x0092B934, 
						  0x0092B992, 0x0092BC66, 0x0092BCC1, 0x0092C109, 0x0092D299, 0x0092D2A7, 0x0092D33D, 0x0092D32E, 0x0092D5CD, 0x0092E7F3, 
						  0x0092E6C2, 0x0092E708, 0x0092E72B, 0x0092E890, 0x0092E8AD, 0x0092EA92, 0x0092E989, 0x0092EC3A, 0x0092EC5C, 0x0092EC7E, 
						  0x0092ED96, 0x0092EDE9, 0x0092EE03, 0x0092EE85, 0x0092EE9F, 0x0092EECA, 0x0092EF05, 0x0092EF7E, 0x0092EF98, 0x0092F2F6, 
						  0x0092F5C9, 0x0092F5D5, 0x0092F5BD, 0x00930E8E, 0x00930F22, 0x00930CCD, 0x00930CDF, 0x00931040, 0x009313EE, 0x00931482, 
						  0x0093122D, 0x0093123F, 0x009317BE, 0x00931852, 0x009315FD, 0x0093160F, 0x009321BD, 0x009323FD, 0x0093F5AA, 0x0094480D, 
						  0x00944922, 0x009452B0, 0x009451D3, 0x0094816B, 0x00948813, 0x00948D7B, 0x009493B3, 0x0094A310, 0x0094A5E2, 0x0094BC40, 
						  0x0094D08B, 0x0094D6F3, 0x0094E323, 0x0094E333, 0x0094E343, 0x0094E353, 0x0094E463, 0x0094E472, 0x0094E494, 0x0094E777, 
						  0x0094E991, 0x0094F5AA, 0x0094F6BF, 0x0094F74C, 0x0094F8B5, 0x0094FA81, 0x00950FA8, 0x00950FD1, 0x0095128F, 0x00952820, 
						  0x0095280E, 0x0095480B, 0x00954E73, 0x0095530B, 0x00955943, 0x0095B81B, 0x0095B8E4, 0x0095BED3, 0x0095C2AB, 0x0095C8E3, 
						  0x0095E06B, 0x0095DF9A, 0x0095FB66, 0x00963080, 0x00966FAA, 0x00966FBA, 0x00967013, 0x00967022, 0x00967664, 0x0096823C, 
						  0x00968249, 0x0096900E, 0x00969020, 0x00969DDB, 0x00969E02, 0x0096A0E2, 0x0096A19B, 0x0096A7A2, 0x0096AB12, 0x0096B4CE, 
						  0x0096BA9B, 0x0096BB41, 0x0096C123, 0x0096C51B, 0x0096C5C1, 0x0096CBA3, 0x00971B94, 0x00971ECC, 0x00971E76, 0x00972187, 
						  0x009727FD, 0x00975334, 0x00975C52, 0x00975FE2, 0x009766DB, 0x00976D43, 0x0097724B, 0x009778B3, 0x00979F6F, 0x0097C203, 
						  0x0097F2A9, 0x00981171, 0x0098160E, 0x0098231E, 0x00982608, 0x00982D69, 0x00983416, 0x00983EDF, 0x009842CE, 0x00984362, 
						  0x0098410D, 0x0098411F, 0x009844A2, 0x009844D8, 0x00984559, 0x00984930, 0x00985138, 0x009851AC, 0x00987643, 0x0098F925, 
						  0x0098F981, 0x0098F9AD, 0x0098FDB4, 0x0098FDE3, 0x0098FE88, 0x0099022C, 0x009908BF, 0x009908CE, 0x00991317, 0x00991431, 
						  0x00991B20, 0x00991A75, 0x00991BDB, 0x00991C1E, 0x00991E5A, 0x00991E6C, 0x009925BF, 0x009925CE, 0x00992CF0, 0x00992DB5, 
						  0x00993285, 0x00993467, 0x009939C1, 0x00993D41, 0x00993D5B, 0x00993F05, 0x00993C53, 0x00993C60, 0x00993CC4, 0x00993CD2, 
						  0x009944F4, 0x00994520, 0x00994574, 0x00994590, 0x00994422, 0x009944DA, 0x009945EB, 0x009945FA, 0x0099691A, 0x00996929, 
						  0x00996C21, 0x00996C80, 0x00996E4E, 0x00996F00, 0x00996D56, 0x00996D9A, 0x00997104, 0x00997292, 0x009972DD, 0x009973FE, 
						  0x00997534, 0x009974DB, 0x0099768F, 0x00997591, 0x009979C7, 0x00997AA0, 0x00997ABE, 0x00997C11, 0x0099849A, 0x009984D4, 
						  0x00998595, 0x00998622, 0x00998746, 0x0099865B, 0x00998667, 0x00998930, 0x0099922E, 0x0099924B, 0x00999293, 0x009992AF, 
						  0x00999361, 0x0099E1FE, 0x0099E241, 0x0099E83C, 0x0099E85C, 0x0099ED50, 0x0099ED6E, 0x0099EFD6, 0x0099F93A, 0x0099F94A, 
						  0x009BD7F2, 0x009BDC39, 0x009BDD77, 0x009BDD92, 0x009BDDC7, 0x009BE124, 0x009C3D2E, 0x009C3D3E, 0x009C3F13, 0x009C418D, 
						  0x009C42B1, 0x009C42CC, 0x009C5092, 0x009C53E1, 0x009C5623, 0x009C562F, 0x009C5655, 0x009C569A, 0x009CD7D2, 0x009CD844, 
						  0x009CD690, 0x009CD69F, 0x009CD944, 0x009CE310, 0x009CECB2, 0x009CF216, 0x009D2263, 0x009DB0FD, 0x009DAD88, 0x009DAD97, 
						  0x009DBB08, 0x009DBB16, 0x009DBEA4, 0x009DD030, 0x009E1719, 0x009E17D7, 0x009E1854, 0x009E1876, 0x009E1540, 0x009E157E, 
						  0x009E616A, 0x009E63CD, 0x009E67C2, 0x009E6AFE, 0x009E7D58, 0x009E92A7, 0x009E92E8, 0x009E9329, 0x009E936A, 0x009E9101, 
						  0x009E9DE4, 0x009EB547, 0x009EBBEF, 0x009EBC03, 0x009EBC44, 0x009EBCB3, 0x009EBCC7, 0x009EBD34, 0x009EC013, 0x009EC328, 
						  0x009ECF92, 0x009ECFB6, 0x009ED1A5, 0x009ED2F0, 0x009ED08A, 0x009ED105, 0x009ED601, 0x009ED4A2, 0x009ED505, 0x009ED527, 
						  0x009ED704, 0x009EDEFA, 0x009EDF07, 0x009EDFA6, 0x009EDFFF, 0x009EEA31, 0x009EEA8B, 0x009EEAE8, 0x009EEB24, 0x009EFB62, 
						  0x009EFB96, 0x009EFC38, 0x009EFC47, 0x009F1AA1, 0x009F6B31, 0x009F6B88, 0x009F6C15, 0x009F72F7, 0x009FBB6A, 0x009FBB8F, 
						  0x009FBC5A, 0x009FC768, 0x009FD273, 0x009FD4CD, 0x009FD4DD, 0x009FD501, 0x009FD541, 0x009FD77A, 0x009FD8A8, 0x009FDA34, 
						  0x009FDB08, 0x009FDB4A, 0x009FDC34, 0x009FDC44, 0x009FD8E2, 0x009FDC9D, 0x009FDCC1, 0x009FDCFC, 0x009FE2C2, 0x009FE2D2, 
						  0x009FE2E2, 0x009FE2F2, 0x009FE34B, 0x009FE743, 0x009FE7A3, 0x009FE7DC, 0x009FF10A, 0x009FF316, 0x00A01658, 0x00A0166B, 
						  0x00A015CC, 0x00A0225A, 0x00A022D5, 0x00A03EF7, 0x00A04E08, 0x00A05FFD, 0x00A48D68, 0x00A48D89, 0x00A48CB4, 0x00A6254F, 
						  0x00A62560, 0x00A661B6, 0x00A661C5, 0x00A667E4, 0x00A667F5, 0x00A6740D, 0x00A67429, 0x00A7C36E, 0x00A7C295, 0x00A7C581, 
						  0x00A7C5A4, 0x00A7C540, 0x00A7C54F, 0x00A7C569, 0x00A7DF16, 0x00A7EF4F, 0x00A7F035, 0x00A80A04, 0x00A80A13, 0x00A80F96, 
						  0x00A8211E, 0x00A82FB5, 0x00A83925, 0x00C70D24, 0x00C70D44, 0x00C70D51, 0x00C70D5E, 0x00C7173D, 0x00C71A22, 0x00C71A40, 
						  0x00C71A5E, 0x00C71A7C, 0x00C71A9A, 0x00C71AB8, 0x00C71AD6, 0x00C719A4, 0x00C719BF, 0x00C719D7, 0x00C719EF, 0x00C71A07, 
						  0x00C71B19, 0x00C71BB3, 0x00C71BC3, 0x00C71BE1, 0x00C71F85, 0x00C725A6, 0x00C728C1, 0x00C73495, 0x00C73521, 0x00C7354F, 
						  0x00C735DF, 0x00C7360D, 0x00C736F3, 0x00C73721, 0x00C73799, 0x00C737C8, 0x00C73841, 0x00C73870, 0x00C738E8, 0x00C73917, 
						  0x00C73A04, 0x00C73A12, 0x00C73A67, 0x00C73A75, 0x00C73A83, 0x00C7B0E2, 0x00C7CC6B, 0x00C7CE32, 0x00C7D597, 0x00C7DAC3, 
						  0x00C7DAEE, 0x00C7DB0F, 0x00C7DB30, 0x00C7D9F5, 0x00C7DA7A, 0x00C7DC73, 0x00C7DC9E, 0x00C7DCBF, 0x00C7DCE0, 0x00C7DBA5, 
						  0x00C7DC2A, 0x00C7DF88, 0x00C7DE95, 0x00C7DFEC, 0x00C7FA05, 0x00C7FA14, 0x00C7F949, 0x00C7F97B, 0x00C7F9D8, 0x00C7FB3B, 
						  0x00C7FB4A, 0x00C7FADB, 0x00C82CA4, 0x00C82CB5, 0x00C82E17, 0x00C83325, 0x00C83603, 0x00C83625, 0x00C83647, 0x00C83573, 
						  0x00C8358F, 0x00C8359B, 0x00C835B3, 0x00C835E1, 0x00C836E0, 0x00C84164, 0x00C84A0F, 0x00C84A3B, 0x00C84ACA, 0x00C84D1E, 
						  0x00C84D6A, 0x00C84DB9, 0x00C84E08, 0x00C84E57, 0x00C84EA6, 0x00C84EF5, 0x00C84F44, 0x00C84C9A, 0x00C84CB9, 0x00C84CD8, 
						  0x00C853A3, 0x00C853F8, 0x00C85266, 0x00C85994, 0x00C859A4, 0x00C859B4, 0x00C859C4, 0x00C85B0F, 0x00C85BB0, 0x00C85C43, 
						  0x00C85CE4, 0x00C85D77, 0x00C85E18, 0x00C85EAB, 0x00C85F4C, 0x00C8698F, 0x00C869B4, 0x00C869D9, 0x00C869FE, 0x00C86411, 
						  0x00C86BD1, 0x00C875E1, 0x00C878AD, 0x00C8A9DF, 0x00C8AC1E, 0x00C8B13F, 0x00C8B14F, 0x00C8B5FE, 0x00C8B63E, 0x00C8CBB1, 
						  0x00C8CBE8, 0x00C8CC1F, 0x00C8CC56, 0x00C8CC8D, 0x00C8CCC4, 0x00C8CCFB, 0x00C8CD32, 0x00C8E866, 0x00C8E8C8, 0x00C8E9A7, 
						  0x00C8EA09, 0x00C9158F, 0x00C915FE, 0x00C935CE, 0x00C93601, 0x00C93632, 0x00C93665, 0x00C9369A, 0x00C9353B, 0x00C9356A, 
						  0x00C9359B, 0x00C94E8B, 0x00C94F0F, 0x00C94FF2, 0x00C9516C, 0x00C9BF03, 0x00C9BFDA, 0x00C9C58E, 0x00C9C671, 0x00C9C69B, 
						  0x00C9C4A6, 0x00C9C806, 0x00C9E4E1, 0x00C9F024, 0x00C9F713, 0x00C9F723, 0x00C9F9A9, 0x00C9F9CA, 0x00C9F8AB, 0x00C9F8C8, 
						  0x00C9F8E7, 0x00C9F9F2, 0x00C9FE8B, 0x00C9FE59, 0x00CA02AB, 0x00CA02C3, 0x00CA057A, 0x00CA1095, 0x00CA2DE4, 0x00CA30D7, 
						  0x00CA31E5, 0x00CA3268, 0x00CA32EB, 0x00CA3370, 0x00CA762A, 0x00CA7650, 0x00CA77E7, 0x00CA78B7, 0x00CA7906, 0x00CA79E8, 
						  0x00CA7DB2, 0x00CA7DCC, 0x00CA7DE2, 0x00CA7EBE, 0x00CA7FA3, 0x00CA8043, 0x00CA80DE, 0x00CA814E, 0x00CA81AE, 0x00CA8210, 
						  0x00CA8390, 0x00CA8490, 0x00CA854E, 0x00CA8660, 0x00CA89FC, 0x00CA8D36, 0x00CA8D62, 0x00CA941C, 0x00CA949C, 0x00CA9B98, 
						  0x00CA9BA4, 0x00CA9BDF, 0x00CA9C17, 0x00CA9C4F, 0x00CAAA16, 0x00CAAA34, 0x00CABF74, 0x00CAC047, 0x00CAC7B1, 0x00CAC84B, 
						  0x00CACA25, 0x00CACA72, 0x00CACAFE, 0x00CACBE8, 0x00CACCA4, 0x00CACCB8, 0x00CACCFC, 0x00CACD10, 0x00CACE42, 0x00CACEF8, 
						  0x00CACF0F, 0x00CACF5A, 0x00CACFAC, 0x00CACFE8, 0x00CAD892, 0x00CAD857, 0x00CAE15D, 0x00CAE453, 0x00CAE76D, 0x00CAE82E, 
						  0x00CAEB9F, 0x00CAEE86, 0x00CAEF68, 0x00CAEFC0, 0x00CAEFFE, 0x00CAF131, 0x00CAF232, 0x00CAF313, 0x00CAF3DB, 0x00CAECEA, 
						  0x00CAED5F, 0x00CAF6FD, 0x00CAF7D0, 0x00CAF58B, 0x00CAF5F4, 0x00CAFC1A, 0x00CB02A8, 0x00CB02BC, 0x00CB09E3, 0x00CB0C90, 
						  0x00CB0B83, 0x00CB0CB4, 0x00CB0D8C, 0x00CB0DD7, 0x00CB0BFE, 0x00CB0C69, 0x00CB11B8, 0x00CB1019, 0x00CB1517, 0x00CB1574, 
						  0x00CB15EB, 0x00CB18CF, 0x00CB18DE, 0x00CB1466, 0x00CB1990, 0x00CB147E, 0x00CB1DA2, 0x00CB1F04, 0x00CB2162, 0x00CB219D, 
						  0x00CB20C7, 0x00CB27D2, 0x00CB352E, 0x00CB3587, 0x00CB35B7, 0x00CB347B, 0x00CB379F, 0x00CB37BA, 0x00CB368B, 0x00CB369A, 
						  0x00CB3715, 0x00CB3CDF, 0x00CB3CFA, 0x00CB3BCB, 0x00CB3BDA, 0x00CB3C55, 0x00CB426D, 0x00CB4194, 0x00CB452D, 0x00CB4454, 
						  0x00CB47B9, 0x00CB4813, 0x00CB4A3E, 0x00CB4AD2, 0x00CB487D, 0x00CB488F, 0x00CB531E, 0x00CB53B2, 0x00CB515D, 0x00CB516F, 
						  0x00CB572E, 0x00CB57C2, 0x00CB556D, 0x00CB557F, 0x00CB5993, 0x00CB5CAC, 0x00CB5D40, 0x00CB5AED, 0x00CB5AFF, 0x00CB603C, 
						  0x00CB60D0, 0x00CB5E7D, 0x00CB5E8F, 0x00CB69CD, 0x00CB71F2, 0x00CB7798, 0x00CB7D3A, 0x00CB7FB2, 0x00CB807F, 0x00CB81B7, 
						  0x00CB8268, 0x00CB8A4F, 0x00CB915A, 0x00CB9147, 0x00CB9E01, 0x00CB9F31, 0x00CBA65C, 0x00CBAE28, 0x00CBADF6, 0x00CBB050, 
						  0x00CBB5DB, 0x00CBB9EB, 0x00CBB9F7, 0x00CBBC6C, 0x00CBBC2C, 0x00CBBC4C, 0x00CBC382, 0x00CBCB3C, 0x00CBCB92, 0x00CBCBBE, 
						  0x00CBCC5B, 0x00CBCC68, 0x00CBCCBE, 0x00CBCCCB, 0x00CBCCD8, 0x00CBCCE4, 0x00CBCD43, 0x00CBCE9D, 0x00CBCEBE, 0x00CBCEFC, 
						  0x00CBCF0E, 0x00CBE201, 0x00CC15B1, 0x00CC15CA, 0x00CC1619, 0x00CC1635, 0x00CC1708, 0x00CC1734, 0x00CC1DEF, 0x00CC1E0F, 
						  0x00CC2383, 0x00CC2399, 0x00CC3A62, 0x00CC3A6E, 0x00CC394F, 0x00CC3958, 0x00CC39C8, 0x00CC3C48, 0x00CC3C61, 0x00CC400C, 
						  0x00CC403B, 0x00CC406A, 0x00CC409C, 0x00CC4337, 0x00CC4346, 0x00CC4357, 0x00CC4366, 0x00CC4377, 0x00CC4386, 0x00CC4397, 
						  0x00CC43A6, 0x00CC4406, 0x00CC4415, 0x00CC4426, 0x00CC4435, 0x00CC4446, 0x00CC4455, 0x00CC5770, 0x00CC561F, 0x00CC564A, 
						  0x00CC5675, 0x00CC57AF, 0x00CC57DA, 0x00CC5805, 0x00CC62BB, 0x00CC62DA, 0x00CC62F9, 0x00CC633C, 0x00CC6843, 0x00CC6755, 
						  0x00CC6866, 0x00CC6B0B, 0x00CC6B8A, 0x00CC6CEC, 0x00CC6DF5, 0x00CC715E, 0x00CC74D9, 0x00CC7F89, 0x00CC8AC1, 0x00CC8AD0, 
						  0x00CC9474, 0x00CC94D8, 0x00CC953C, 0x00CC9A0A, 0x00CC9410, 0x00CC9C84, 0x00CC9CE8, 0x00CC9D4C, 0x00CCA21A, 0x00CC9C20, 
						  0x00CCB88B, 0x00CCCC33, 0x00CCCC42, 0x00CCCFD0, 0x00CCCFE2, 0x00CCE8A2, 0x00CCE8FD, 0x00CCE9B6, 0x00CCE9D0, 0x00CCEACF, 
						  0x00CCE7B6, 0x00CCE7D9, 0x00CCE7FC, 0x00CD03A3, 0x00CD03B5, 0x00CD02B6, 0x00CD02C2, 0x00CD056F, 0x00CD055F, 0x00CD05F1, 
						  0x00CD072C, 0x00CD0603, 0x00CD08B0, 0x00CD09F7, 0x00CD08C2, 0x00CD0B40, 0x00CD0B52, 0x00CD6511, 0x00CD6550, 0x00CD8295, 
						  0x00CD8185, 0x00CD81D3, 0x00CD822E, 0x00CD816D, 0x00CD82E5, 0x00CD831C, 0x00CD8348, 0x00CD8380, 0x00CD82CD, 0x00CD83DC, 
						  0x00CD8411, 0x00CD8456, 0x00CD8565, 0x00CD8606, 0x00CD854D, 0x00CD8B68, 0x00CD8CF5, 0x00CD8E02, 0x00CD8F71, 0x00CD9467, 
						  0x00CD9496, 0x00CD957E, 0x00CD9651, 0x00CD9671, 0x00CD9689, 0x00CD9867, 0x00CD9873, 0x00CD9BAA, 0x00CD9C42, 0x00CD9C6E, 
						  0x00CD9CA6, 0x00CDAADE, 0x00CDADDA, 0x00CDAE3C, 0x00CDAEAC, 0x00CDAEF2, 0x00CDB300, 0x00CDB2EE, 0x00CDB9DE, 0x00CDBA2F, 
						  0x00CDBBA3, 0x00CDC3F6, 0x00CDC428, 0x00CDC21A, 0x00CDC573, 0x00CDC88A, 0x00CDCC1D, 0x00CDD2B2, 0x00CDD315, 0x00CDD971, 
						  0x00CDDA3F, 0x00CDDB60, 0x00CDD899, 0x00CDDDA1, 0x00CDDE6F, 0x00CDDF90, 0x00CDDCC9, 0x00CDE26F, 0x00CDE2C8, 0x00CDE317, 
						  0x00CDE32E, 0x00CDE14E, 0x00CDE5E7, 0x00CDE62F, 0x00CDE70A, 0x00CDE9A7, 0x00CDE9EF, 0x00CDEACA, 0x00CDF292, 0x00CDF2AC, 
						  0x00CDF2C2, 0x00CDF571, 0x00CDF5D1, 0x00CDF5DD, 0x00CDF627, 0x00CDF491, 0x00CE04AE, 0x00CE04E3, 0x00CE084F, 0x00CE0728, 
						  0x00CE0789, 0x00CE07E2, 0x00CE0807, 0x00CE0B20, 0x00CE0B91, 0x00CE2D8A, 0x00CE3AB2, 0x00CE3AE8, 0x00CE5F08, 0x00CE5F15, 
						  0x00CE5F7C, 0x00CE5F89, 0x00CE6216, 0x00CE6289, 0x00CE7104, 0x00CE7EA2, 0x00CE7ED6, 0x00CE8525, 0x00CE85CA, 0x00CE844B, 
						  0x00CE87AF, 0x00CE8850, 0x00CE86BE, 0x00CEA36A, 0x00CEA39A, 0x00CEA3C4, 0x00CEA42D, 0x00CEA45A, 0x00CEA2A6, 0x00CEA2C7, 
						  0x00CEA2E2, 0x00CEA2EF, 0x00CEA2FF, 0x00CEA30C, 0x00CEA7AE, 0x00CEAC71, 0x00CEACDD, 0x00CEAD32, 0x00CEAB9F, 0x00CEABB4, 
						  0x00CEAFEE, 0x00CEB082, 0x00CEAE2D, 0x00CEAE3F, 0x00CEB35F, 0x00CEB3CB, 0x00CEB420, 0x00CEB28F, 0x00CEB2A4, 0x00CEB4A7, 
						  0x00CEB5D7, 0x00CEB8EE, 0x00CEB982, 0x00CEB72D, 0x00CEB73F, 0x00CEBC7E, 0x00CEBD12, 0x00CEBABD, 0x00CEBACF, 0x00CEC311, 
						  0x00CEC4CD, 0x00CEC76E, 0x00CEC908, 0x00CECF5B, 0x00CECF7C, 0x00CED0F0, 0x00CED025, 0x00CED0AC, 0x00CED3C9, 0x00CED1A1, 
						  0x00CED920, 0x00CEE023, 0x00CEDF73, 0x00CEF71F, 0x00CEF74D, 0x00CF1019, 0x00CF0FFF, 0x00CF10C9, 0x00CF10AF, 0x00CF1109, 
						  0x00CF10EF, 0x00CF1150, 0x00CF2E3C, 0x00CF2F7A, 0x00CF2F8A, 0x00CF300C, 0x00CF2FEE, 0x00CF3834, 0x00CF3840, 0x00CF4681, 
						  0x00CF4690, 0x00CF4761, 0x00CF4770, 0x00CF4782, 0x00CF4794, 0x00CF47F1, 0x00CF4800, 0x00CF480F, 0x00CF481E, 0x00CF4830, 
						  0x00CF4842, 0x00CF4854, 0x00CF4863, 0x00CF4875, 0x00CF4887, 0x00CF4ADF, 0x00CF4BBB, 0x00CF4CA0, 0x00CF4D42, 0x00CF4D76, 
						  0x00CF4DA1, 0x00CF4E36, 0x00CF4E6A, 0x00CF4E8C, 0x00CF4EB1, 0x00CF505B, 0x00CF5134, 0x00CF519C, 0x00CF51AC, 0x00CF51FB, 
						  0x00CF520B, 0x00CF521B, 0x00CF522B, 0x00CF4F97, 0x00CF5376, 0x00CF53AE, 0x00CF5418, 0x00CF5461, 0x00CF5471, 0x00CF5481, 
						  0x00CF5491, 0x00CF52B3, 0x00CF55EF, 0x00CF55FF, 0x00CF560F, 0x00CF561F, 0x00CF552B, 0x00CF553A, 0x00CF5781, 0x00CF57BE, 
						  0x00CF5801, 0x00CF5DD1, 0x00CF7F42, 0x00CF7F54, 0x00CF8259, 0x00CF82BF, 0x00CF82DE, 0x00CF8960, 0x00CF896D, 0x00CF926F, 
						  0x00CF925F, 0x00CF96F0, 0x00CF9702, 0x00CF96DE, 0x00CFA2C6, 0x00CF9CB3, 0x00CFA7F7, 0x00CFA807, 0x00CFA817, 0x00CFA827, 
						  0x00CFA837, 0x00CFA847, 0x00CFA91D, 0x00CFA92D, 0x00CFA93D, 0x00CFA94D, 0x00CFA95D, 0x00CFA96D, 0x00CFAC3C, 0x00CFAC4E, 
						  0x00CFAAD9, 0x00CFAC6F, 0x00CFACA1, 0x00CFAAE6, 0x00CFAB0E, 0x00CFAB1B, 0x00CFAF4C, 0x00CFAF5B, 0x00CFAF6A, 0x00CFAFA0, 
						  0x00CFAFB5, 0x00CFAFC5, 0x00CFAFD5, 0x00CFAFE5, 0x00CFAFF5, 0x00CFB005, 0x00CFAEA8, 0x00CFAEB7, 0x00CFAEC6, 0x00CFAEF9, 
						  0x00CFC96B, 0x00CFCA77, 0x00CFCB1C, 0x00CFCC02, 0x00CFCD52, 0x00CFD3B8, 0x00CFD55C, 0x00CFD642, 0x00CFE444, 0x00CFE451, 
						  0x00CFE504, 0x00CFE53C, 0x00CFED81, 0x00CFFAAF, 0x00CFFBF4, 0x00CFFC00, 0x00D025F9, 0x00D027EF, 0x00D02606, 0x00D028A8, 
						  0x00D028BA, 0x00D028ED, 0x00D02961, 0x00D029CB, 0x00D02B07, 0x00D02B33, 0x00D02B63, 0x00D02B72, 0x00D02C04, 0x00D02C63, 
						  0x00D02C75, 0x00D02D43, 0x00D03243, 0x00D0330F, 0x00D03D1D, 0x00D03D2C, 0x00D051C8, 0x00D0520C, 0x00D05272, 0x00D05396, 
						  0x00D05501, 0x00D05B12, 0x00D05A4C, 0x00D071AB, 0x00D07911, 0x00D07941, 0x00D083AE, 0x00D08400, 0x00D08419, 0x00D0843F, 
						  0x00D096BB, 0x00D0A1F2, 0x00D0A245, 0x00D0A151, 0x00D0A181, 0x00D0A191, 0x00D0A2B3, 0x00D0A548, 0x00D0A8A1, 0x00D0A8CF, 
						  0x00D0A8DF, 0x00D0AA66, 0x00D0A98C, 0x00D0AA55, 0x00D0AE2E, 0x00D0AE60, 0x00D0AE70, 0x00D0AED3, 0x00D0AEE3, 0x00D0B2B8, 
						  0x00D0B2C8, 0x00D0B356, 0x00D0B366, 0x00D0C0DB, 0x00D0C5F1, 0x00D0C6A1, 0x00D0CD48, 0x00D0CD68, 0x00D0CDEB, 0x00D0CE20, 
						  0x00D0CE9B, 0x00D0CFAD, 0x00D0CC9D, 0x00D0CD13, 0x00D0D1DB, 0x00D0D235, 0x00D0D2E7, 0x00D0D31E, 0x00D0D381, 0x00D0D433, 
						  0x00D0D163, 0x00D0D5C0, 0x00D0D7AE, 0x00D0D80A, 0x00D0D893, 0x00D0D8BD, 0x00D0DFDD, 0x00D0E116, 0x00D0E1D7, 0x00D0E3CD, 
						  0x00D0E50F, 0x00D0E5D4, 0x00D0EF49, 0x00D0F095, 0x00D0F55A, 0x00D0F745, 0x00D0F752, 0x00D0F762, 0x00D0F772, 0x00D0F7AC, 
						  0x00D0F831, 0x00D0F84F, 0x00D0F85E, 0x00D0F8F2, 0x00D0F910, 0x00D0F921, 0x00D0F94B, 0x00D0F999, 0x00D0F9A8, 0x00D0F9BC, 
						  0x00D0FA53, 0x00D0FA6E, 0x00D0FA9B, 0x00D0FAAA, 0x00D0FACD, 0x00D0FB48, 0x00D0FB8B, 0x00D0FBA9, 0x00D0FBB8, 0x00D12165, 
						  0x00D121C9, 0x00D123A0, 0x00D1282C, 0x00D1283D, 0x00D1284A, 0x00D128B8, 0x00D128C6, 0x00D12AE4, 0x00D12BB0, 0x00D12BDC, 
						  0x00D13683, 0x00D13882, 0x00D13963, 0x00D13A2B, 0x00D13A3A, 0x00D13B43, 0x00D13D16, 0x00D13D7E, 0x00D13F43, 0x00D141FD, 
						  0x00D14257, 0x00D142DD, 0x00D14337, 0x00D1487E, 0x00D14912, 0x00D146BD, 0x00D146CF, 0x00D14DDE, 0x00D14E72, 0x00D14C1D, 
						  0x00D14C2F, 0x00D150BF, 0x00D15B83, 0x00D15BE1, 0x00D16049, 0x00D16262, 0x00D16270, 0x00D16295, 0x00D160F6, 0x00D16138, 
						  0x00D160AD, 0x00D16187, 0x00D16317, 0x00D1672D, 0x00D16FC0, 0x00D16FAE, 0x00D179AC, 0x00D17AC5, 0x00D17DE3, 0x00D17FD0, 
						  0x00D17FFD, 0x00D18016, 0x00D180BF, 0x00D180CC, 0x00D17EB1, 0x00D17EDA, 0x00D17EEF, 0x00D17F22, 0x00D183DE, 0x00D18430, 
						  0x00D18464, 0x00D188A4, 0x00D191E4, 0x00D1927A, 0x00D1AE46, 0x00D1AE99, 0x00D1AF74, 0x00D1B080, 0x00D1ADA0, 0x00D1ADF3, 
						  0x00D1B4E8, 0x00D1C830, 0x00D1C84B, 0x00D1C866, 0x00D1C904, 0x00D1CA5F, 0x00D1CA7A, 0x00D1CA95, 0x00D1E005, 0x00D1E254, 
						  0x00D1E262, 0x00D1E270, 0x00D1E64D, 0x00D1E63E, 0x00D1E6CE, 0x00D1E8AA, 0x00D1E8B8, 0x00D1E8C6, 0x00D1EDBF, 0x00D1EDCF, 
						  0x00D1EDDF, 0x00D1EDAF, 0x00D259B1, 0x00D288A6, 0x00D2A001, 0x00D2A031, 0x00D2A040, 0x00D2A06B, 0x00D2A07B, 0x00D2A08B, 
						  0x00D2A09B, 0x00D2A0D1, 0x00D2A1AA, 0x00D2A344, 0x00D2A363, 0x00D2C499, 0x00D2C4E3, 0x00D2C531, 0x00D2C540, 0x00D2C5B1, 
						  0x00D2DBF7, 0x00D2DC23, 0x00D2DC3F, 0x00D2DC68, 0x00D2DC94, 0x00D2DCD2, 0x00D2DB56, 0x00D2DB7B, 0x00D43B69, 0x00D445C4, 
						  0x00E25447, 0x00E25608, 0x00E2792E, 0x00E291D2, 0x00E2A81C, 0x00E2A68E, 0x00E2A965, 0x00E2AA7D, 0x00E2AA99, 0x00E2A726, 
						  0x00E2A764, 0x00E2CEB1, 0x00E2ECA0, 0x00E2ED30, 0x00E31F7B, 0x00E39EDE, 0x00E39F1C, 0x00E3A9A9, 0x00E3C58E, 0x00E43D40, 
						  0x00E463BC, 0x00E463CF, 0x00E464C8, 0x00E464E0, 0x00E46591, 0x00E465A3, 0x00E4DD4A, 0x00E4DD5B, 0x00E57164, 0x00E57190, 
						  0x00E57394, 0x00E58F50, 0x00E58F9A, 0x00E5909A, 0x00E590A9, 0x00E590DE, 0x00E590ED, 0x00E59118, 0x00E5913B, 0x00E593CC, 
						  0x00E593F4, 0x00E5940B, 0x00E59437, 0x00E593A1, 0x00E59538, 0x00E59563, 0x00E59593, 0x00E595B3, 0x00E5A9F6, 0x00E5D984, 
						  0x00E5DD32, 0x00E67071, 0x00E66F70, 0x00E66FBC, 0x00E6C71E, 0x00E6D337, 0x00E6DF77, 0x00E6E5BE, 0x00E6E820, 0x00E74E54, 
						  0x00E79C8F, 0x00E79CAC, 0x00E7AE06, 0x00E7AE42, 0x00E7AF36, 0x00E7AF48, 0x00E7AF5A, 0x00E7AF6C, 0x00E7AFEA, 0x00E7B076, 
						  0x00E7B0F4, 0x00E7B180, 0x00E7B1C9, 0x00E79F33, 0x00E79F43, 0x00E79F53, 0x00E7B587, 0x00E7A03D, 0x00E7A05B, 0x00E7A08A, 
						  0x00E7A0A2, 0x00E7A0CB, 0x00E7A1B2, 0x00E7A1F2, 0x00E7A202, 0x00E7A235, 0x00E7A268, 0x00E7A37F, 0x00E7A40B, 0x00E7A489, 
						  0x00E7A515, 0x00E7A593, 0x00E7A61F, 0x00E7A69D, 0x00E79E7D, 0x00E7A729, 0x00E7A73D, 0x00E79E8D, 0x00E79E9D, 0x00E7A8D4, 
						  0x00E7A8E1, 0x00E7A95A, 0x00E7ADCA, 0x00E7D7DD, 0x00E8292F, 0x00E8295C, 0x00E83970, 0x00E847B8, 0x00E84B35, 0x00E8507C, 
						  0x00E8514A, 0x00E85619, 0x00E85651, 0x00E85689, 0x00E856DF, 0x00E856F1, 0x00E85739, 0x00E85781, 0x00E857C9, 0x00E85813, 
						  0x00E8582E, 0x00E85866, 0x00E8589E, 0x00E858F4, 0x00E85906, 0x00E8594E, 0x00E85996, 0x00E859DE, 0x00E85D6D, 0x00E85DA8, 
						  0x00E85DE2, 0x00E85E06, 0x00E85E60, 0x00E855FE, 0x00E86D35, 0x00E86EEA, 0x00E87B8B, 0x00E88596, 0x00E885B7, 0x00E885C8, 
						  0x00E8860E, 0x00E88738, 0x00E8B0A3, 0x00E8B973, 0x00ED0508, 0x00ED0529, 0x00ED0560, 0x00ED057E, 0x00ED234F, 0x00ED4CB8, 
						  0x00ED4CC4, 0x00EDAF4F, 0x00EE012D, 0x00EE168F, 0x00EE6CEC, 0x00EE6CFC, 0x00EE6D0C, 0x00EE75CA, 0x00EE75E9, 0x00EE7CA5, 
						  0x00EE7CB6, 0x00EE7CC7, 0x00EE7DB6, 0x00EE7E22, 0x00EE7E33, 0x00EE7E9D, 0x00EE7EAE, 0x00EE7F41, 0x00EE7F52, 0x00EE7FD6, 
						  0x00EE8121, 0x00EE82C2, 0x00EE8380, 0x00EE85FB, 0x00EE8D4A, 0x00EE9640, 0x00EE96E7, 0x00EE9720, 0x00EE978F, 0x00EEA597, 
						  0x00EEA742, 0x00EEA8C0, 0x00EEAD0D, 0x00EEAFAD, 0x00EED557, 0x00EED45B, 0x00EEE40E, 0x00F01B08, 0x00F01DBC, 0x00F023C4, 
						  0x00F023FA, 0x00F02433, 0x00F60F6F, 0x00F6137F, 0x00F613E1, 0x00F61424, 0x00F61698, 0x00F6199B, 0x00F619AB, 0x00F8C228, 
						  0x00F8C2B4};

	DWORD cpustuff2_calls[] = {0x0054B7D6, 0x0061152A, 0x006AE6A4, 0x006AEB42, 0x007B41FF, 0x007E21AC, 0x00823AD0, 0x008489DC, 0x008489E3, 0x008D70F5, 
						  0x008D80AA, 0x008D9173, 0x008D9408, 0x008D9EE8, 0x009C56EB, 0x009C56F2, 0x009C56F9, 0x00C31A9D, 0x00C393EC, 0x00C393FC, 
						  0x00C41C36, 0x00C4C005, 0x00C4C00C, 0x00C4BDD9, 0x00C4C5B5, 0x00C4C5BC, 0x00C4C961, 0x00C4C968, 0x00C4CD34, 0x00C8BCA6, 
						  0x00C8BCAD, 0x00C8BCE1, 0x00C9C6DD, 0x00C9C4BC, 0x00CFD3A9, 0x00D02825, 0x00D02BB3, 0x00D02C3A, 0x00E9F878, 0x00E9F8E8, 
						  0x00E9F908, 0x00E9F836, 0x00EB1E61, 0x00EB5B23, 0x00EB8727, 0x00EB8B53, 0x00EB8B5A, 0x00EB89DA, 0x00EBBD6E, 0x00EBC008, 
						  0x00EBC271, 0x00EBC728, 0x00EBC983, 0x00EBD150, 0x00EBF417, 0x00EBF5E7, 0x00EC040B, 0x00EC180E, 0x00EC1A3F, 0x00EC2F07, 
						  0x00EC357E, 0x00EC3811, 0x00EC5868, 0x00EC66D7, 0x00EC6997, 0x00EC6C99, 0x00ED5FBB, 0x00ED8747, 0x00EF6C67, 0x00EF6E7C};

	/////////////////////////////////////////////////////////////////
	DWORD cpustuff_nop5_0[] = {0x0043EAC3, 0x0043ED33, 0x00469694, 0x004E246A, 0x004E284C, 0x004E2932, 0x004E3575, 0x0051FAB0, 0x0053573E, 0x0054B759, 
						  0x0054B76F, 0x0054B924, 0x0054BE41, 0x00611484, 0x006114C4, 0x00615F21, 0x0061AE84, 0x0064FCB0, 0x006ADD5D, 0x006AE613, 
						  0x006AE679, 0x006C112D, 0x00723EEE, 0x00724D3D, 0x00724FAA, 0x0073DDCD, 0x007B06E5, 0x007B4185, 0x007B41AA, 0x007E2170, 
						  0x007E217B, 0x0082391F, 0x00823927, 0x00848827, 0x00848926, 0x00848970, 0x008489A6, 0x008A03E6, 0x008A284D, 0x008C6C5C, 
						  0x008D807F, 0x008D90B8, 0x008D90DC, 0x008D915A, 0x008D93D0, 0x008D9DC7, 0x008D9E3E, 0x008DAF17, 0x008DB1B9, 0x008DDAEE, 
						  0x008E3DA0, 0x009C563A, 0x009C568D, 0x009C55ED, 0x009C55F5, 0x009FB1CE, 0x009FB1D9, 0x00C7E0E3, 0x00C8BC60, 0x00C8FEC8, 
						  0x00C9C6B5, 0x00CBCB2D, 0x00CEE00F, 0x00CF4A35, 0x00CF4F48, 0x00CF5284, 0x00CFCA1A, 0x00CFCD06, 0x00CFD351, 0x00CFD36E, 
						  0x00CFD387, 0x00CFD45F, 0x00CFD741, 0x00D02493, 0x00D027DD, 0x00D0262D, 0x00D02B3E, 0x00D02BCD, 0x00D02CDA, 0x00D0308A, 
						  0x00D03225, 0x00D03230, 0x00D0321A, 0x00D032AA, 0x00D0337A, 0x00D0A440, 0x00D0B204, 0x00D0B220, 0x00D16A04, 0x00D444E8, 
						  0x00D4453F, 0x00D4457B, 0x00E2D1C5, 0x00E39EFE, 0x00E5A955, 0x00E5D94B, 0x00E885DF, 0x00ED4A75, 0x00ED5F87, 0x00ED5F95, 
						  0x00ED86BD, 0x00ED871D, 0x00EDE7E4, 0x00EF6DF1, 0x00EF6E4D, 0x00EFE656, 0x00F2ED39};

	DWORD cpustuff_unk_0 = 0x00E8466E;

	DWORD check_this_plus98_jmp_plus_48 = 0x00C2B200;
	/////////////////////////////////////////////////////////////////

	DWORD fabs = 0x00438FD0;

	DWORD fabs_calls[] = {0x0048F63B, 0x0048F64D, 0x0048F65F, 0x004CA7AA, 0x004CA7DD, 0x00631EE0, 0x00631EF4, 0x00642CA5, 0x00653D32, 0x00654CFB, 
						  0x0065553A, 0x00655DA6, 0x00655EF2, 0x006A119F, 0x006A11CE, 0x006C610A, 0x007A5C90, 0x008158A2, 0x0082EC02, 0x008C9AD1, 
						  0x00929470, 0x009298ED, 0x00C83F1E, 0x00C83F30, 0x00C83F42, 0x00C83FCD, 0x00E7D859}; 

	DWORD get_this = 0x00462C10, get_this_1 = 0x00BD98A0, get_this_2 = 0x00D4DD10;

	DWORD get_this_calls[] = {0x00939CA6, 0x00939CF2, 0x00939D15, 0x00939D38, 0x009731F9, 0x00973259, 0x0097328C, 0x009730D6, 0x00973183, 0x011733C3, 
						  0x01173523, 0x01173536, 0x0117402F, 0x0117416B, 0x011740DA, 0x011740FB, 0x0117467F, 0x011747EC, 0x01174748, 0x01174769, 
						  0x01189D98, 0x01189E18, 0x01189E78, 0x0118AA48, 0x0118AF48, 0x00402AA0, 0x00403648, 0x0040672E, 0x004099AF, 0x0040BB29, 
						  0x0040BBA2, 0x0040BBDE, 0x0040BC1E, 0x0040BFB6, 0x0040D0E5, 0x0040D1FA, 0x0040D579, 0x0040D7F3, 0x0040D8C3, 0x0040DA5A, 
						  0x0040DBF8, 0x0040DC0E, 0x0040E016, 0x0040F557, 0x004119F0, 0x00412C46, 0x00413212, 0x0041221D, 0x004128A7, 0x004128C3, 
						  0x00412941, 0x00412ABE, 0x00412B8E, 0x004161A6, 0x00414DB7, 0x00417582, 0x00417609, 0x00417699, 0x004176B9, 0x00417732, 
						  0x00417761, 0x0041778B, 0x004177BD, 0x0041784D, 0x00417867, 0x00417AEC, 0x00417C9B, 0x00418171, 0x00416DA0, 0x00416DF6, 
						  0x00416E20, 0x00416EC9, 0x00416F23, 0x004171D0, 0x00417208, 0x004172C1, 0x004172D4, 0x004173B2, 0x00417439, 0x004174CA, 
						  0x004174F3, 0x00419D0B, 0x00419D7A, 0x0041B3A8, 0x0041B4A8, 0x0041BB3E, 0x0041BB4A, 0x0041CDA2, 0x0041CF52, 0x0041D01F, 
						  0x0041D060, 0x0041D070, 0x0041D0B2, 0x0041D1B2, 0x0041D28C, 0x0041D39D, 0x0041D3DB, 0x0041D3E7, 0x0041D4FD, 0x0041D53B, 
						  0x0041D547, 0x0041D574, 0x0041D74D, 0x0041DD8E, 0x0041E0DD, 0x0041E1A2, 0x0041E2CD, 0x0041F55A, 0x0041F591, 0x0041F46A, 
						  0x0041F4A7, 0x0041F4B3, 0x0041F515, 0x0041F7CF, 0x0041F7DB, 0x0041F75F, 0x0041F76F, 0x0041F7AB, 0x0041F92E, 0x0041F9DE, 
						  0x0041FA82, 0x0041FB62, 0x00420B92, 0x00420C72, 0x00420E38, 0x00420E44, 0x00420E5F, 0x00420F25, 0x00420F31, 0x00420F4B, 
						  0x004218E5, 0x004218DB, 0x00421935, 0x0042192B, 0x00422B97, 0x00422B85, 0x00424D54, 0x00426253, 0x004242FD, 0x00428BB2, 
						  0x00428BBF, 0x00428DE5, 0x00428DF5, 0x00428E1F, 0x0042B048, 0x0042B054, 0x0042B06F, 0x0042B128, 0x0042B134, 0x0042B14F, 
						  0x0042B1E8, 0x0042B1F4, 0x0042B20F, 0x0042B2A8, 0x0042B2B4, 0x0042B2CF, 0x0042BDE0, 0x0042CD0D, 0x0042CD37, 0x0042EA6C, 
						  0x0042F2FA, 0x0042F3EA, 0x0042F42B, 0x0042F43F, 0x0042F4FA, 0x0042F5FA, 0x0042F63A, 0x00430DFA, 0x00431291, 0x00431349, 
						  0x004316B8, 0x004316C9, 0x004316D9, 0x00434155, 0x00434336, 0x004361C5, 0x004361E2, 0x00436313, 0x00436330, 0x00436403, 
						  0x00436420, 0x00436518, 0x00436535, 0x004365E0, 0x00436643, 0x0043670B, 0x00436715, 0x00436731, 0x0043673B, 0x0043675B, 
						  0x00436D4F, 0x00436D5B, 0x00436D7F, 0x00436DA5, 0x004385B6, 0x004385C6, 0x004385E5, 0x004385FC, 0x0043860E, 0x00438718, 
						  0x0043870C, 0x00438878, 0x0043886C, 0x00438918, 0x0043890C, 0x00438D19, 0x00438D35, 0x00438D4D, 0x00438C2E, 0x00438C65, 
						  0x00438EC0, 0x00438ED3, 0x00438EE6, 0x00438EFC, 0x00439115, 0x00439121, 0x0043916D, 0x0043917D, 0x004391A5, 0x004391CA, 
						  0x004391DB, 0x0043924A, 0x00439267, 0x0043927A, 0x00439290, 0x004392B5, 0x0043903C, 0x0043904C, 0x0043905F, 0x00439077, 
						  0x00439092, 0x00439320, 0x00439332, 0x004394CB, 0x0043943F, 0x00439740, 0x00439764, 0x0043994F, 0x00439A7C, 0x00439AFB, 
						  0x0043AFF8, 0x0043B051, 0x0043B0B8, 0x0043B0E5, 0x0043B29A, 0x0043B2B3, 0x0043B65F, 0x0043B675, 0x0043B9A5, 0x0043B9B0, 
						  0x0043B765, 0x0043B771, 0x0043BD60, 0x0043BD70, 0x0043BD8D, 0x0043BE34, 0x0043BE44, 0x0043BE61, 0x0043C12D, 0x0043C7DA, 
						  0x0043C8DA, 0x0043C98A, 0x0043CA3A, 0x0043CAEA, 0x0043CBEA, 0x0043CC9A, 0x0043D6FD, 0x0043DD2A, 0x0043EA34, 0x0043EA4C, 
						  0x0043EA9E, 0x0043EACF, 0x0043E962, 0x0043E979, 0x0043E9A9, 0x0043E9DA, 0x0043ECA4, 0x0043ECBC, 0x0043ED0E, 0x0043ED3F, 
						  0x0043EBD2, 0x0043EBE9, 0x0043EC19, 0x0043EC4A, 0x0043EE18, 0x0043EE28, 0x0043EEAA, 0x0043EEC5, 0x0043EEF2, 0x0043F561, 
						  0x0043F56D, 0x0043F5C1, 0x0043F5CD, 0x0043F638, 0x0043F644, 0x0043F669, 0x0043F701, 0x0043F70D, 0x0043F877, 0x0043FD94, 
						  0x0043FDA0, 0x0043FEE1, 0x0043FEED, 0x0043FFA3, 0x0043FFBD, 0x0043FFD9, 0x0044005B, 0x00440067, 0x00440186, 0x0044030E, 
						  0x00440332, 0x00440533, 0x00440546, 0x00440555, 0x00440581, 0x004405B1, 0x004405D3, 0x0044063B, 0x0044066D, 0x0044067C, 
						  0x004406A8, 0x004406CE, 0x00440715, 0x00440726, 0x00440764, 0x00440461, 0x00440471, 0x004404C3, 0x00440505, 0x004407B0, 
						  0x004407D0, 0x004408BE, 0x004408D8, 0x004408EB, 0x004408FA, 0x00440960, 0x004409B5, 0x00440D26, 0x00440D32, 0x00440D48, 
						  0x00440E7C, 0x00440E8C, 0x00440E9E, 0x00440EF1, 0x00440FA1, 0x00440FCC, 0x00440FE2, 0x00441050, 0x0044105E, 0x00441067, 
						  0x004410BD, 0x004410E2, 0x00441121, 0x00441130, 0x004412BC, 0x004412F1, 0x004411C2, 0x004411D2, 0x004411F6, 0x0044120E, 
						  0x00441243, 0x00441258, 0x00441268, 0x0044127E, 0x00441584, 0x004415C6, 0x004415D4, 0x004415DD, 0x0044174C, 0x00441652, 
						  0x00441762, 0x0044176B, 0x00441664, 0x00441688, 0x0044169E, 0x004416B0, 0x004416B9, 0x004416D8, 0x004416F7, 0x0044170A, 
						  0x00441720, 0x00441736, 0x00441800, 0x00441810, 0x00441836, 0x00441851, 0x00441870, 0x004418A2, 0x004418B4, 0x00441A60, 
						  0x00441A6E, 0x00441A7A, 0x00441A88, 0x00441A91, 0x00441AA6, 0x00441AC5, 0x00441ADD, 0x00441AF5, 0x00441B21, 0x00441B31, 
						  0x00441B45, 0x00441B58, 0x00441B6E, 0x00441B84, 0x00441B9A, 0x00441BB0, 0x00441BB9, 0x00441BCF, 0x00441BF4, 0x00441C0C, 
						  0x00441C1D, 0x00441C33, 0x00441C42, 0x00441C53, 0x00441970, 0x00441980, 0x00441996, 0x004419CE, 0x004419EB, 0x00441CE8, 
						  0x00441CF4, 0x00441CFF, 0x00441D16, 0x00441DC8, 0x00441E06, 0x00441E1E, 0x00441E40, 0x00441E5B, 0x00442149, 0x00442193, 
						  0x004421FE, 0x00442028, 0x0044208A, 0x004422F8, 0x00442308, 0x0044236E, 0x004423B1, 0x0044246C, 0x0044247C, 0x004424BF, 
						  0x00442650, 0x00442681, 0x00442771, 0x00442785, 0x004427D8, 0x0044284C, 0x00442858, 0x004428C1, 0x004428CD, 0x00442977, 
						  0x00442C36, 0x00442C5D, 0x00442CB5, 0x00442CED, 0x00442B2C, 0x00442B3C, 0x00442B4E, 0x00442B81, 0x00442BAA, 0x00442E14, 
						  0x00442E8B, 0x00442F11, 0x00442F23, 0x00442F2F, 0x00442F3E, 0x00442F53, 0x00442F65, 0x0044308D, 0x00443302, 0x0044332F, 
						  0x00443530, 0x00443540, 0x00443567, 0x00443F85, 0x00443D17, 0x00443D31, 0x004440B9, 0x00444108, 0x00444132, 0x004441D6, 
						  0x0044428B, 0x004442AA, 0x004442DB, 0x00444334, 0x00444527, 0x00444531, 0x0044453A, 0x0044454B, 0x00444555, 0x0044441A, 
						  0x0044442A, 0x004447DB, 0x00444B80, 0x00444A9D, 0x00444E73, 0x00444E7F, 0x00444FAC, 0x004458D5, 0x00447625, 0x00447998, 
						  0x004479A4, 0x004479CB, 0x004479EE, 0x00447A29, 0x00448332, 0x004484BD, 0x00448DAE, 0x004499D6, 0x00449F41, 0x0044AC00, 
						  0x0044B8AB, 0x0044B8D9, 0x0044D6A0, 0x0044D6B2, 0x0044DAD9, 0x0044E818, 0x0044E82A, 0x0044E907, 0x0044E918, 0x0044F965, 
						  0x0044F975, 0x0044F988, 0x0044F9A9, 0x0044F9B8, 0x0044F9C9, 0x0044F9E4, 0x0044FE0D, 0x00451490, 0x004514A0, 0x004514B7, 
						  0x004514DA, 0x004514F2, 0x0045150E, 0x00451530, 0x0045143B, 0x00451B79, 0x00451E11, 0x00451D22, 0x00451E6C, 0x00451D9B, 
						  0x00451F12, 0x00451F7C, 0x00451FC6, 0x00452175, 0x0045206B, 0x00452123, 0x0045235F, 0x004525B8, 0x004525CD, 0x00452D0C, 
						  0x00452D18, 0x00452D64, 0x00452D79, 0x00452DC8, 0x00452E14, 0x00452E35, 0x00452E5F, 0x00453312, 0x0045332D, 0x0045333B, 
						  0x00453350, 0x0045325B, 0x00453306, 0x004533E0, 0x00453750, 0x00453C7C, 0x00453D1D, 0x00453D7A, 0x00453D8B, 0x00453DA3, 
						  0x00454755, 0x00455106, 0x00455390, 0x00455544, 0x0045557F, 0x0045558E, 0x00455CEB, 0x00456EB0, 0x00456F50, 0x00456FC0, 
						  0x00457030, 0x004570A0, 0x00457172, 0x004571C8, 0x004572D2, 0x00457328, 0x004575AF, 0x004575BB, 0x00457614, 0x0045768F, 
						  0x0045769B, 0x00457713, 0x0045771F, 0x00457773, 0x0045777F, 0x00458376, 0x0045840E, 0x0045A283, 0x0045B746, 0x0045D311, 
						  0x0045D32B, 0x0045D385, 0x0045D3AF, 0x0045C209, 0x0045C24D, 0x0045C289, 0x0045C2E2, 0x0045C3EE, 0x0045C6C4, 0x0045C88E, 
						  0x0045C8A6, 0x0045C91F, 0x0045C936, 0x0045C955, 0x0045C96C, 0x0045C97B, 0x0045C996, 0x0045C9B3, 0x0045C9DD, 0x0045C9F8, 
						  0x0045CA26, 0x0045CA55, 0x0045CA8E, 0x0045CACE, 0x0045CAE1, 0x0045CB2D, 0x0045CB8C, 0x0045CBA8, 0x0045CBD5, 0x0045CBFA, 
						  0x0045CC3E, 0x0045CC57, 0x0045CC85, 0x0045CCAD, 0x0045CCC8, 0x0045CCDC, 0x0045CCF0, 0x0045CD02, 0x0045CD1B, 0x0045CD4B, 
						  0x0045CD64, 0x0045E5F7, 0x0045E7FF, 0x0045F55C, 0x00462499, 0x004624A9, 0x004624F4, 0x00462505, 0x00462518, 0x00462535, 
						  0x0046255C, 0x004625CC, 0x004625EF, 0x0046234E, 0x00462715, 0x00462725, 0x0046273B, 0x00462753, 0x00462766, 0x0046284D, 
						  0x00462B0A, 0x004670E4, 0x00467ED1, 0x00467EEB, 0x00467EFC, 0x00467DF8, 0x00467E35, 0x00467E43, 0x00467E51, 0x00467DDC, 
						  0x00467EA8, 0x00468268, 0x004682C3, 0x004682F6, 0x00468309, 0x004683DF, 0x004696F2, 0x00469B33, 0x00469BC3, 0x00469C04, 
						  0x00469D1C, 0x0046A7A4, 0x0046A8A2, 0x0046A8AE, 0x0046A8E3, 0x0046AC0E, 0x0046ACE0, 0x0046AD33, 0x0046AD50, 0x0046AD79, 
						  0x0046ADBB, 0x0046E29C, 0x0046E4AF, 0x0046E60D, 0x0046E654, 0x0046E77D, 0x0046E79E, 0x0046E9A1, 0x0046EA0A, 0x0046EA70, 
						  0x0046E8C9, 0x0046E933, 0x0046E96B, 0x0046EEA2, 0x0046EEC4, 0x00470829, 0x0047083A, 0x004708B9, 0x004708CA, 0x004708E6, 
						  0x004708F9, 0x004712B3, 0x004712CA, 0x004712FE, 0x00471405, 0x00471459, 0x00471543, 0x00471550, 0x00471592, 0x0047159C, 
						  0x00471918, 0x00471DF3, 0x00471F56, 0x00471F65, 0x00471F72, 0x00471F93, 0x00472053, 0x00472062, 0x00474BC4, 0x00475A30, 
						  0x00475A65, 0x00475AD5, 0x0047665A, 0x00476708, 0x00478CF5, 0x00478BF3, 0x0047ACAE, 0x0047AD31, 0x0047AE25, 0x0047B17E, 
						  0x0047AF85, 0x0047B47E, 0x0047B285, 0x0047CDB7, 0x0047CE67, 0x0047CF05, 0x0047CF4F, 0x0047CF82, 0x0047D00F, 0x0047D410, 
						  0x0047D504, 0x0047E434, 0x00480267, 0x004802D0, 0x00480499, 0x00480A24, 0x00480A4F, 0x00480A87, 0x004808FB, 0x00480A9F, 
						  0x00480AD5, 0x00480AED, 0x00480B1F, 0x00480B2A, 0x00480B6C, 0x00480919, 0x0048092F, 0x004809AD, 0x004809C7, 0x004809D9, 
						  0x00481838, 0x00481850, 0x0048188E, 0x004818D7, 0x00481B04, 0x00481C10, 0x00481C55, 0x00481C73, 0x00481C9D, 0x00481CB1, 
						  0x00481CD1, 0x00481CF6, 0x00481E08, 0x00481E1B, 0x00481E2E, 0x00481E48, 0x00481E5A, 0x004820BB, 0x004820E3, 0x004822CB, 
						  0x0048251D, 0x0048265F, 0x0048280E, 0x0048282E, 0x00482883, 0x004828B6, 0x004829CC, 0x00482D36, 0x00482CAD, 0x00482D0D, 
						  0x00482D14, 0x00482D70, 0x00482D83, 0x00482E88, 0x00482E99, 0x00482EA5, 0x00482EBD, 0x00482ED0, 0x00482EDD, 0x00482F20, 
						  0x0048302B, 0x00482F53, 0x00482F6F, 0x00482F97, 0x00482FCC, 0x00482FE0, 0x00482FF7, 0x004832CC, 0x004831D4, 0x00483237, 
						  0x00483248, 0x00483271, 0x0048327E, 0x004832B4, 0x004839C0, 0x004839EB, 0x00487C90, 0x00487C97, 0x00487F1A, 0x00488066, 
						  0x004882D8, 0x004882F4, 0x00488310, 0x00488341, 0x00488356, 0x0048839C, 0x004883BE, 0x0048842B, 0x0048845A, 0x0048847F, 
						  0x00488496, 0x004884BB, 0x004884D4, 0x004884E3, 0x00488600, 0x00488831, 0x00488843, 0x00488899, 0x00488A46, 0x00488C29, 
						  0x00488AEE, 0x00488AF5, 0x00488D84, 0x00488FEE, 0x00489002, 0x0048903D, 0x0048904C, 0x0048907B, 0x00488F0D, 0x00488F30, 
						  0x00488F42, 0x004890D0, 0x0048928F, 0x00489390, 0x004893A8, 0x00489146, 0x00489551, 0x0048915C, 0x00489704, 0x00489713, 
						  0x00489197, 0x004891AC, 0x004891DA, 0x00489202, 0x0048A0FA, 0x0048A1F4, 0x0048A455, 0x0048A472, 0x0048A3B3, 0x0048A3C4, 
						  0x0048A3D4, 0x0048A3EE, 0x0048A436, 0x0048A565, 0x0048A652, 0x0048A659, 0x0048A812, 0x0048A81E, 0x0048A825, 0x0048A842, 
						  0x0048A849, 0x0048A785, 0x0048A796, 0x0048A7A6, 0x0048A7C4, 0x0048A7DE, 0x0048A80B, 0x0048AA80, 0x0048AA9D, 0x0048ABE3, 
						  0x0048AC19, 0x0048AC25, 0x0048AC44, 0x0048B4BA, 0x0048B563, 0x0048B56F, 0x0048B584, 0x0048B593, 0x0048B5B0, 0x0048B5C2, 
						  0x0048B72A, 0x0048B7DA, 0x0048BD0A, 0x0048C016, 0x0048C01D, 0x0048C03C, 0x0048C043, 0x0048C052, 0x0048C059, 0x0048C2E5, 
						  0x0048C2EC, 0x0048C3EA, 0x0048C55A, 0x0048C603, 0x0048C620, 0x0048C688, 0x0048C6A5, 0x0048CCB2, 0x0048CCC2, 0x0048CCDA, 
						  0x0048CE39, 0x0048CE49, 0x0048CE65, 0x0048CF85, 0x0048CF97, 0x0048D363, 0x0048D383, 0x0048D5DA, 0x0048D50E, 0x0048D529, 
						  0x0048D54D, 0x0048D55D, 0x0048D6A0, 0x0048D6B6, 0x0048D756, 0x0048D76C, 0x0048D784, 0x0048E05C, 0x0048E24E, 0x0048E2E4, 
						  0x0048E2F7, 0x0048E317, 0x0048E3E9, 0x0048E419, 0x0048E9A0, 0x0048EB2E, 0x0048EB4D, 0x00490232, 0x0049026E, 0x004903CE, 
						  0x00490408, 0x004906DE, 0x00490718, 0x00491357, 0x00491555, 0x004917EC, 0x0049182C, 0x0049183A, 0x00491870, 0x0049189A, 
						  0x00491A18, 0x00491ACD, 0x00491ADF, 0x00491B40, 0x00491BF5, 0x00491C3D, 0x00491DF4, 0x00491FE6, 0x00492001, 0x004920FF, 
						  0x0049210B, 0x0049211B, 0x00492122, 0x00492D43, 0x00492D59, 0x00493EC2, 0x00494AFE, 0x00494C6C, 0x00494CA4, 0x00494CB1, 
						  0x00494DAC, 0x00494DB7, 0x00494DCF, 0x00494E03, 0x00494E3F, 0x00494E77, 0x00495279, 0x0049520B, 0x004953F7, 0x00495460, 
						  0x004954F9, 0x00495531, 0x0049558A, 0x004955C5, 0x004953A7, 0x0049574A, 0x00495945, 0x00495846, 0x004958C2, 0x00495ACF, 
						  0x00495B25, 0x00495B94, 0x00495CD0, 0x00495D54, 0x00495DD7, 0x00495E54, 0x00495F3C, 0x00495FB1, 0x00496150, 0x004961FE, 
						  0x00496232, 0x004962AA, 0x00496321, 0x0049636D, 0x0049608A, 0x004960B8, 0x004963DD, 0x004963EA, 0x0049652C, 0x0049654D, 
						  0x004965C3, 0x0049665E, 0x0049673A, 0x004968C3, 0x004968F7, 0x00496948, 0x00496979, 0x004969E7, 0x004967F3, 0x00496A5C, 
						  0x00496AA7, 0x0049746E, 0x00498DB2, 0x0049916D, 0x00499190, 0x004991B0, 0x004991D0, 0x004991F0, 0x00499212, 0x00499455, 
						  0x00499490, 0x004994B7, 0x004993D4, 0x004993E4, 0x0049943D, 0x00499896, 0x00499D22, 0x00499DFA, 0x00499E7E, 0x00499E8D, 
						  0x00499EA4, 0x00499FD4, 0x0049A010, 0x0049A028, 0x0049A089, 0x0049A0A1, 0x0049A171, 0x00499EFB, 0x0049A181, 0x0049A191, 
						  0x0049A1B2, 0x0049A1EC, 0x0049A205, 0x0049A275, 0x0049A296, 0x0049A396, 0x0049A3B2, 0x0049A3C7, 0x0049A3EA, 0x0049A449, 
						  0x0049A553, 0x0049A57C, 0x0049A660, 0x0049A6AC, 0x0049A6E3, 0x00499FB0, 0x00499FC8, 0x0049AB63, 0x0049ABB4, 0x0049ABDE, 
						  0x0049AA69, 0x0049AC87, 0x0049AC97, 0x0049AA7C, 0x0049AD86, 0x0049ADB0, 0x0049AE08, 0x0049AE14, 0x0049AE3E, 0x0049AE5C, 
						  0x0049AAA0, 0x0049AAC6, 0x0049AADA, 0x0049AB0C, 0x0049AB26, 0x0049B10D, 0x0049B119, 0x0049B35D, 0x0049B272, 0x0049B293, 
						  0x0049B2E1, 0x0049B32A, 0x0049B4BB, 0x0049B4C7, 0x0049B6B4, 0x0049B6C0, 0x0049B6D4, 0x0049B6F2, 0x0049B703, 0x0049B72B, 
						  0x0049B767, 0x0049B781, 0x0049B7C1, 0x0049B7D1, 0x0049B810, 0x0049B891, 0x0049B8CE, 0x0049B573, 0x0049B594, 0x0049B5E2, 
						  0x0049B618, 0x0049BAEB, 0x0049BAF7, 0x0049BB0B, 0x0049BB25, 0x0049BB36, 0x0049BB5E, 0x0049BB92, 0x0049BC0E, 0x0049BC32, 
						  0x0049BA54, 0x0049BCA5, 0x0049BCC6, 0x0049BE57, 0x0049BE6E, 0x0049BD6D, 0x0049BD8E, 0x0049BDC6, 0x0049BDDC, 0x0049BE0C, 
						  0x0049C056, 0x0049C072, 0x0049C086, 0x0049C0B4, 0x0049C10C, 0x0049C128, 0x0049C13D, 0x0049C160, 0x0049C179, 0x0049C18A, 
						  0x0049C19D, 0x0049C1C0, 0x0049C243, 0x0049C27F, 0x0049C344, 0x0049C3D3, 0x0049BF0C, 0x0049BF35, 0x0049BF8E, 0x0049C434, 
						  0x0049C457, 0x0049C521, 0x0049C535, 0x0049C5DD, 0x0049C600, 0x0049C6AD, 0x0049C6D0, 0x0049C77E, 0x0049C7B3, 0x0049C7CD, 
						  0x0049CBB5, 0x0049CDF9, 0x0049CE4E, 0x0049CFA4, 0x0049CC5E, 0x0049CC6A, 0x0049E153, 0x0049E16A, 0x0049E1CF, 0x0049E1E7, 
						  0x0049D182, 0x0049E2DB, 0x0049E2EC, 0x0049E38E, 0x0049E3FA, 0x0049D1FB, 0x0049D21B, 0x0049D087, 0x0049D2EA, 0x0049D32E, 
						  0x0049D34B, 0x0049D3D1, 0x0049D0AC, 0x0049D5B6, 0x0049D613, 0x0049D66B, 0x0049D0C2, 0x0049D6B0, 0x0049D70A, 0x0049D735, 
						  0x0049D822, 0x0049D0F0, 0x0049D9A8, 0x0049DABD, 0x0049DACB, 0x0049DAE2, 0x0049DB01, 0x0049DB24, 0x0049D111, 0x0049DC74, 
						  0x0049D125, 0x0049DCC9, 0x0049DD3E, 0x0049DD71, 0x0049DDAB, 0x0049DDB4, 0x0049DDCB, 0x0049DE00, 0x0049DE4A, 0x0049D143, 
						  0x0049E047, 0x0049E6C9, 0x0049E6D5, 0x0049E6F1, 0x0049E77D, 0x0049E634, 0x0049EBDC, 0x0049EC2B, 0x0049EC42, 0x0049EC94, 
						  0x0049ECC3, 0x0049E8B6, 0x0049EDDF, 0x0049EE20, 0x0049EE43, 0x0049EE68, 0x0049EE78, 0x0049EEA7, 0x0049EEC8, 0x0049EEEB, 
						  0x0049EF2E, 0x0049EF4F, 0x0049EF66, 0x0049EF82, 0x0049E8EE, 0x0049E914, 0x0049F15D, 0x0049F4F8, 0x0049F535, 0x0049F543, 
						  0x0049F33C, 0x0049F348, 0x0049F67D, 0x0049F689, 0x0049F69C, 0x0049F6C3, 0x0049F6DD, 0x0049F9F0, 0x0049FA0F, 0x0049FA1F, 
						  0x0049FA3B, 0x0049FA52, 0x0049FA68, 0x0049FA95, 0x0049FAA5, 0x0049FABB, 0x0049FAE2, 0x0049FB11, 0x0049FB28, 0x0049FC57, 
						  0x0049FC67, 0x0049FC7E, 0x0049F98C, 0x0049FDF6, 0x0049FE64, 0x004A010A, 0x0049FFA4, 0x0049FFC6, 0x0049FFE4, 0x004A000A, 
						  0x004A0028, 0x004A01FC, 0x004A03BA, 0x004A03D9, 0x004A03F6, 0x004A040A, 0x004A0454, 0x004A04C5, 0x004A04D1, 0x004A04F9, 
						  0x004A0505, 0x004A051C, 0x004A0528, 0x004A05A4, 0x004A06FC, 0x004A08DE, 0x004A0B4B, 0x004A0B54, 0x004A0BB0, 0x004A0BD0, 
						  0x004A0C13, 0x004A0C32, 0x004A0C5C, 0x004A0C6B, 0x004A0E52, 0x004A0D75, 0x004A0DCE, 0x004A0DDC, 0x004A0DF5, 0x004A0FA7, 
						  0x004A0FC1, 0x004A101E, 0x004A103C, 0x004A0E9D, 0x004A0EAD, 0x004A0EDD, 0x004A0EF7, 0x004A0F54, 0x004A0F72, 0x004A1102, 
						  0x004A1BBC, 0x004A1E95, 0x004A1E9D, 0x004A32BE, 0x004A30B6, 0x004A373C, 0x004A39D1, 0x004A39E1, 0x004A439C, 0x004A4CB5, 
						  0x004A4E89, 0x004A4EB0, 0x004A4F7A, 0x004A4F2C, 0x004A51B9, 0x004A53B0, 0x004A53CF, 0x004A5510, 0x004A552F, 0x004A58AD, 
						  0x004A694D, 0x004A6A2A, 0x004A6A42, 0x004A7E87, 0x004A80CC, 0x004A8B56, 0x004A8C23, 0x004A8C4A, 0x004A8C56, 0x004A8C7C, 
						  0x004A9108, 0x004A91F3, 0x004A9686, 0x004A9641, 0x004AA015, 0x004AA02B, 0x004AA630, 0x004AA702, 0x004AA88A, 0x004AA936, 
						  0x004AA9F6, 0x004AA76B, 0x004AAAD2, 0x004AAAF3, 0x004AAAFF, 0x004AAFA6, 0x004AB698, 0x004AB6CE, 0x004AB6F3, 0x004ABC49, 
						  0x004ABC6A, 0x004ABD00, 0x004AC397, 0x004AC3A5, 0x004ACB1B, 0x004ACB29, 0x004ACBBD, 0x004ACCDA, 0x004ACCFB, 0x004ACD23, 
						  0x004AD235, 0x004AD6CF, 0x004AD6E0, 0x004AD90D, 0x004AD808, 0x004AD81C, 0x004AED3A, 0x004AED9E, 0x004AEE9C, 0x004AEF48, 
						  0x004AEF88, 0x004ADE35, 0x004AF06E, 0x004AF0FF, 0x004AF1EE, 0x004AF1FD, 0x004AF276, 0x004AF282, 0x004AF31A, 0x004AF620, 
						  0x004AF6BA, 0x004AF71E, 0x004AF86B, 0x004AF8E4, 0x004AF978, 0x004AFBA7, 0x004AFCD1, 0x004AFCF7, 0x004AFD07, 0x004AFD2A, 
						  0x004AFE19, 0x004B029A, 0x004B02F9, 0x004B0384, 0x004B03E8, 0x004B041E, 0x004B0436, 0x004B044C, 0x004B0547, 0x004B0557, 
						  0x004B05AE, 0x004B05CC, 0x004B05E2, 0x004B05F8, 0x004B060E, 0x004B0628, 0x004B0631, 0x004B0647, 0x004ADF97, 0x004B0679, 
						  0x004B0751, 0x004B07DC, 0x004B0840, 0x004B09E0, 0x004B0A5D, 0x004B0AEF, 0x004B0B3A, 0x004B0C25, 0x004B0C34, 0x004B0DBF, 
						  0x004B0E48, 0x004B0ED3, 0x004B0F37, 0x004B105C, 0x004B107D, 0x004B12BC, 0x004AE0DF, 0x004AE28A, 0x004AE2C2, 0x004AE3CC, 
						  0x004AE429, 0x004AE823, 0x004AE86A, 0x004AE8BC, 0x004AE8D1, 0x004AE8E7, 0x004AE90C, 0x004AE993, 0x004AE9E5, 0x004ADDD8, 
						  0x004AEAC7, 0x004AEAD7, 0x004AEB25, 0x004AEB40, 0x004AEB56, 0x004AEB6C, 0x004AEB82, 0x004AEB9C, 0x004AEBA5, 0x004AEBBB, 
						  0x004AEBE9, 0x004AECAF, 0x004B137A, 0x004B1397, 0x004B13A9, 0x004B13DD, 0x004B13FF, 0x004B18AB, 0x004B18C2, 0x004B18D8, 
						  0x004B18F5, 0x004B177F, 0x004B179A, 0x004B1AD2, 0x004B1D63, 0x004B20FF, 0x004B33C5, 0x004B341C, 0x004B327B, 0x004B35F4, 
						  0x004B3600, 0x004B36AC, 0x004B3CD9, 0x004B3CFE, 0x004B3D24, 0x004B3D40, 0x004B3D5C, 0x004B3D78, 0x004B440F, 0x004B4423, 
						  0x004B510D, 0x004B5200, 0x004B5785, 0x004B5A5C, 0x004B5A8B, 0x004B5BFF, 0x004B62B8, 0x004B62D0, 0x004B62DC, 0x004B62F0, 
						  0x004B6372, 0x004B63D3, 0x004B6B25, 0x004B6B31, 0x004B6CC9, 0x004B6CE1, 0x004B6D8D, 0x004B6DA5, 0x004B84FF, 0x004B8849, 
						  0x004B95E8, 0x004B982B, 0x004B9852, 0x004B98C2, 0x004B98E5, 0x004B97C3, 0x004B97D3, 0x004B9BDD, 0x004BA0C0, 0x004BA17B, 
						  0x004BA355, 0x004BA648, 0x004BA776, 0x004BAAFB, 0x004BAB07, 0x004BAC70, 0x004BAB73, 0x004BAB7F, 0x004BAB93, 0x004BAE29, 
						  0x004BB148, 0x004BB13C, 0x004BB35B, 0x004BBD0A, 0x004BC54A, 0x004BC465, 0x004BC471, 0x004BCBC6, 0x004BCE18, 0x004BCF3C, 
						  0x004BCF8B, 0x004BD06C, 0x004BD0B9, 0x004BD184, 0x004BD213, 0x004BD227, 0x004BD244, 0x004BD398, 0x004BD883, 0x004BD899, 
						  0x004BF7FE, 0x004BFB08, 0x004BFB1E, 0x004C07AA, 0x004C07CF, 0x004C07FD, 0x004C097E, 0x004C0904, 0x004C0914, 0x004C0C08, 
						  0x004C0C6F, 0x004C0C4F, 0x004C0D72, 0x004C0D9A, 0x004C0DBF, 0x004C0E4B, 0x004C0F4E, 0x004C0F63, 0x004C118D, 0x004C119B, 
						  0x004C140D, 0x004C142B, 0x004C1444, 0x004C147B, 0x004C149E, 0x004C14DE, 0x004C1528, 0x004C1536, 0x004C1543, 0x004C1551, 
						  0x004C1228, 0x004C15E4, 0x004C15EF, 0x004C15FD, 0x004C1619, 0x004C1672, 0x004C1AB4, 0x004C1ADF, 0x004C19D3, 0x004C1A0B, 
						  0x004C1A63, 0x004C2C25, 0x004C2E9A, 0x004C45FB, 0x004C464B, 0x004C469B, 0x004C4B1A, 0x004C4B69, 0x004C4BD8, 0x004C4BF2, 
						  0x004C4F48, 0x004C4EFA, 0x004C50D5, 0x004C512C, 0x004C5153, 0x004C5093, 0x004C50BA, 0x004C5310, 0x004C53C3, 0x004C5508, 
						  0x004C5513, 0x004C5536, 0x004C5541, 0x004C5D63, 0x004C5D78, 0x004C5E5B, 0x004C74CF, 0x004C8FED, 0x004C9753, 0x004C9AD1, 
						  0x004C9B51, 0x004CD12E, 0x004CD1E3, 0x004CD3C8, 0x004CDB5A, 0x004CDC3C, 0x004CE28E, 0x004CE1D9, 0x004CE4A0, 0x004CE5FF, 
						  0x004CEEA3, 0x004CF105, 0x004CF110, 0x004CF150, 0x004CF15B, 0x004CF1D2, 0x004CF1FB, 0x004CF26E, 0x004CFB16, 0x004CFA8E, 
						  0x004D0096, 0x004D0A80, 0x004D0F33, 0x004D0FC1, 0x004D1096, 0x004D10B6, 0x004D19B3, 0x004D1B53, 0x004D2171, 0x004D2240, 
						  0x004D2679, 0x004D32C1, 0x004D3350, 0x004D3363, 0x004D35F5, 0x004D3724, 0x004D38F3, 0x004D3902, 0x004D3921, 0x004D3B24, 
						  0x004D3B5E, 0x004D4673, 0x004D45C1, 0x004D4E72, 0x004D4EB8, 0x004D5395, 0x004D53A4, 0x004D527D, 0x004D52E5, 0x004D55B7, 
						  0x004D5515, 0x004D5632, 0x004D6130, 0x004D6212, 0x004D6F4E, 0x004D77FE, 0x004D8B38, 0x004D8EAB, 0x004D8EC8, 0x004D8DCE, 
						  0x004D8DDF, 0x004D8E56, 0x004D9658, 0x004DA4FD, 0x004DA41F, 0x004DA43D, 0x004DA489, 0x004DA3FB, 0x004DA4A3, 0x004DB821, 
						  0x004DB86C, 0x004DB894, 0x004DB8E1, 0x004DB910, 0x004DB927, 0x004DB953, 0x004DB962, 0x004DB986, 0x004DB997, 0x004DBD03, 
						  0x004DBD59, 0x004DBEA2, 0x004DBEB7, 0x004DBF0B, 0x004DC281, 0x004DC299, 0x004DC45C, 0x004DC582, 0x004DD361, 0x004DDBD9, 
						  0x004DDE0E, 0x004DE3D4, 0x004DE964, 0x004DF86C, 0x004DF94E, 0x004DFE55, 0x004DFD7A, 0x004DFD9C, 0x004E01A6, 0x004E01B2, 
						  0x004E01CE, 0x004E01E4, 0x004E0201, 0x004E0C3C, 0x004E0C57, 0x004E0C84, 0x004E0DD1, 0x004E0DF9, 0x004E0EB9, 0x004E0F1F, 
						  0x004E0F3A, 0x004E0F67, 0x004E0A0F, 0x004E1AB2, 0x004E1ADB, 0x004E1AF0, 0x004E2409, 0x004E2417, 0x004E2496, 0x004E2563, 
						  0x004E2581, 0x004E271B, 0x004E2739, 0x004E2D3A, 0x004E348A, 0x004E3498, 0x004E34CE, 0x004E34DC, 0x004E3534, 0x004E3542, 
						  0x004E3642, 0x004E3650, 0x004E3730, 0x004E4009, 0x004E40EB, 0x004E4504, 0x004E4518, 0x004E4549, 0x004E4587, 0x004E4593, 
						  0x004E4EDE, 0x004E4ECF, 0x004E5108, 0x004E51DB, 0x004E5D9B, 0x004E634E, 0x004E635A, 0x004E63F2, 0x004E624E, 0x004E6336, 
						  0x004E7153, 0x004E728F, 0x004E72E1, 0x004E735D, 0x004E73E5, 0x004E742E, 0x004E7477, 0x004E74C0, 0x004E86A0, 0x004E8782, 
						  0x004E8FD6, 0x004E8F19, 0x004E8F58, 0x004E8F90, 0x004E9B9D, 0x004E9C7F, 0x004EA0AA, 0x004E9FE5, 0x004EA480, 0x004EABF4, 
						  0x004EAF25, 0x004EB007, 0x004EB366, 0x004EB39E, 0x004EB27C, 0x004EB523, 0x004EB56B, 0x004EB58C, 0x004EB788, 0x004EB7EF, 
						  0x004EB862, 0x004EB9C9, 0x004EBA04, 0x004EBA1D, 0x004EBB48, 0x004EBB8C, 0x004EBB9B, 0x004EBBAC, 0x004EBBC5, 0x004EBC86, 
						  0x004EC1BA, 0x004EC1FC, 0x004EC20D, 0x004EC24E, 0x004EC09E, 0x004EC0AE, 0x004EC0C8, 0x004EC0E0, 0x004EC10D, 0x004EC125, 
						  0x004EC144, 0x004EC153, 0x004EC446, 0x004EC47F, 0x004EC4C2, 0x004EC4EB, 0x004EC34F, 0x004EC363, 0x004EC37D, 0x004EC3B6, 
						  0x004EC33B, 0x004EC3E3, 0x004EC577, 0x004EC82A, 0x004EC86D, 0x004EC8DF, 0x004EC73E, 0x004EC907, 0x004EC74E, 0x004EC76D, 
						  0x004EC787, 0x004EC7AB, 0x004EC7E7, 0x004EC814, 0x004EC9BB, 0x004EC9C9, 0x004EC9E1, 0x004ECA09, 0x004ECA14, 0x004ECA23, 
						  0x004ECA2E, 0x004ECC6D, 0x004ECCC2, 0x004ECCD3, 0x004ECCE7, 0x004ECCF6, 0x004ED02F, 0x004ECF49, 0x004EDA7F, 0x004EDB61, 
						  0x004EE23E, 0x004EE189, 0x004EEA15, 0x004F06FD, 0x004F080C, 0x004F0C8F, 0x004F29F0, 0x004F2A15, 0x004F2B5B, 0x004F1B76, 
						  0x004F1C14, 0x004F1C3F, 0x004F1C6F, 0x004F1989, 0x004F1D58, 0x004F1DCE, 0x004F1E16, 0x004F1E25, 0x004F1E3A, 0x004F1E4D, 
						  0x004F1E82, 0x004F1FF7, 0x004F2006, 0x004F201E, 0x004F20C0, 0x004F20D4, 0x004F2112, 0x004F2159, 0x004F21D6, 0x004F220F, 
						  0x004F23D5, 0x004F24C1, 0x004F2594, 0x004F25DE, 0x004F28AF, 0x004F28BD, 0x004F2FD7, 0x004F319E, 0x004F31E6, 0x004F465D, 
						  0x004F48EF, 0x004F576B, 0x004F5777, 0x004F5791, 0x004F57AA, 0x004F57C0, 0x004F57D4, 0x004F59F6, 0x004F5A06, 0x004F5A1C, 
						  0x004F5A30, 0x004F5C47, 0x004F5C57, 0x004F5C73, 0x004F5C96, 0x004F5CB0, 0x004F5CD6, 0x004F5D0D, 0x004F5D38, 0x004F5D67, 
						  0x004F5D96, 0x004F5DD2, 0x004F5DE8, 0x004F5E07, 0x004F5E1D, 0x004F5E35, 0x004F5E5D, 0x004F5E75, 0x004F5E9B, 0x004F5EB1, 
						  0x004F5ED5, 0x004F5F00, 0x004F5F29, 0x004F5F3F, 0x004F5F5A, 0x004F5F70, 0x004F5F8C, 0x004F5FBB, 0x004F5FCE, 0x004F616E, 
						  0x004F617E, 0x004F619E, 0x004F61BE, 0x004F61D1, 0x004F61EE, 0x004F620D, 0x004F6216, 0x004F622E, 0x004F6249, 0x004F6093, 
						  0x004F60B2, 0x004F6AFA, 0x004F6FA3, 0x004F7F43, 0x004F7F59, 0x004F7F6F, 0x004F7D09, 0x004F7F92, 0x004F7FB5, 0x004F7FF5, 
						  0x004F8023, 0x004F804D, 0x004F80B9, 0x004F80F7, 0x004F8112, 0x004F8135, 0x004F813E, 0x004F8173, 0x004F7D48, 0x004F7D5C, 
						  0x004F7D82, 0x004F86DF, 0x004F86EF, 0x004F87A5, 0x004F888F, 0x004F889B, 0x004F88EE, 0x004FA042, 0x004F9267, 0x004F94D8, 
						  0x004F95F4, 0x004F9A37, 0x004F9DA0, 0x004FA334, 0x004FA38C, 0x004FA3D7, 0x004FA41E, 0x004FA476, 0x004FA4C1, 0x004FABA7, 
						  0x004FACDD, 0x004FACEE, 0x004FAD9B, 0x004FAD6F, 0x004FB5AA, 0x004FB5BE, 0x004FB5DC, 0x004FB6DA, 0x004FB6E6, 0x004FB708, 
						  0x004FCD2A, 0x004FDDC8, 0x004FE265, 0x004FE828, 0x004FE839, 0x004FF01A, 0x004FF03A, 0x004FF291, 0x0050074A, 0x00500760, 
						  0x00500875, 0x0050088D, 0x005009AE, 0x005009C2, 0x005009D8, 0x00500B72, 0x0050178C, 0x005017D4, 0x00501A78, 0x00501BFF, 
						  0x00501D0F, 0x005023A0, 0x005023BB, 0x00502670, 0x0050268B, 0x00502F13, 0x0050357D, 0x00503FAC, 0x00504282, 0x00504155, 
						  0x00504176, 0x0050450E, 0x005043D5, 0x005043F6, 0x0050487B, 0x00505022, 0x00505116, 0x0050513B, 0x005051EA, 0x005051FF, 
						  0x005052AF, 0x005052C4, 0x00505368, 0x0050537D, 0x005053C3, 0x005053D8, 0x0050541E, 0x00505433, 0x00505479, 0x0050548E, 
						  0x005054D4, 0x005054E9, 0x00505535, 0x0050554A, 0x00505596, 0x005055AB, 0x005055F1, 0x00505606, 0x0050564C, 0x00505661, 
						  0x005056A7, 0x005056BC, 0x00505702, 0x00505717, 0x00504FFD, 0x00505978, 0x0050595D, 0x005059C5, 0x00505A16, 0x00505A34, 
						  0x00505A49, 0x00506919, 0x00506AF1, 0x00506C96, 0x00506EEC, 0x00506F6A, 0x00507107, 0x00507168, 0x005071F4, 0x00507D0D, 
						  0x00507EDC, 0x00508078, 0x005082F0, 0x00508351, 0x005084EE, 0x0050854F, 0x00508831, 0x005089A7, 0x005089C4, 0x00508B7B, 
						  0x005095B2, 0x005095C7, 0x005095E8, 0x00509504, 0x005096C6, 0x00509AC3, 0x00509AF6, 0x00509A3B, 0x00509C3B, 0x00509FE8, 
						  0x0050A060, 0x0050A280, 0x0050B759, 0x0050B76A, 0x0050CC04, 0x0050E247, 0x0050E252, 0x0050E46B, 0x0050E4C9, 0x0050E4E8, 
						  0x0050E507, 0x0050E542, 0x0050DF9C, 0x0050DFB4, 0x0050E78F, 0x0050E8C0, 0x0050E8D3, 0x0050E930, 0x0050E96A, 0x0051062F, 
						  0x00510DE7, 0x00510E57, 0x00511B09, 0x00512385, 0x00512395, 0x005123B3, 0x005123E3, 0x0051240C, 0x00512429, 0x00512438, 
						  0x00512465, 0x005124C9, 0x00512503, 0x00512526, 0x00512552, 0x00512583, 0x005125A1, 0x0051263A, 0x00512646, 0x00512667, 
						  0x00512684, 0x00512726, 0x00514143, 0x00514168, 0x0051419B, 0x005141B9, 0x0051421F, 0x0051422B, 0x0051423D, 0x005140E8, 
						  0x005140F8, 0x00514112, 0x0051412C, 0x00514571, 0x0051458E, 0x005145AF, 0x0051450D, 0x00514519, 0x00514525, 0x00514544, 
						  0x0051473C, 0x0051474E, 0x005147C8, 0x0051482F, 0x00514865, 0x005148B9, 0x005148ED, 0x00514A38, 0x005156CF, 0x00515A21, 
						  0x005159B4, 0x005159C0, 0x00515D21, 0x00515E0E, 0x00515E28, 0x00515EA4, 0x00515EBE, 0x0051628D, 0x005162AC, 0x005162CB, 
						  0x005162E3, 0x005163A7, 0x00516234, 0x00516244, 0x00516267, 0x005168C9, 0x005168D9, 0x00516914, 0x00516A58, 0x00516B07, 
						  0x00516DB3, 0x00516E09, 0x00516E35, 0x00516734, 0x00516740, 0x00517110, 0x00517129, 0x00517148, 0x00517158, 0x00517178, 
						  0x005171A8, 0x005171C7, 0x005171DC, 0x005171FF, 0x005172A4, 0x005172B4, 0x005172F7, 0x00517334, 0x005173A9, 0x005173BF, 
						  0x005173F0, 0x0051744A, 0x00517542, 0x00517AC6, 0x00517AD6, 0x00517AF5, 0x00517B0F, 0x00517B29, 0x00517B4F, 0x00517B94, 
						  0x00517BA7, 0x00517DB2, 0x00517CC7, 0x00517CDC, 0x00517CFD, 0x00517D5A, 0x00517D66, 0x00517D7C, 0x00517E3C, 0x00517E48, 
						  0x00517E5F, 0x00517E76, 0x00517F0C, 0x00517F18, 0x00517F2F, 0x00517F46, 0x00517FD1, 0x00517FDD, 0x00517FF3, 0x00518006, 
						  0x00518066, 0x0051807C, 0x0051808F, 0x005181C4, 0x005181E3, 0x0051822F, 0x005182F4, 0x0051812E, 0x0051813E, 0x0051815F, 
						  0x0051816E, 0x0051818B, 0x005181AE, 0x00518498, 0x005184A8, 0x005184BB, 0x005184D2, 0x005184E9, 0x00518550, 0x0051856E, 
						  0x00518588, 0x005185A9, 0x005185BE, 0x005185E1, 0x00518603, 0x00518627, 0x005187D3, 0x00518874, 0x005188A0, 0x005188DF, 
						  0x005188FD, 0x0051890B, 0x00518941, 0x0051896D, 0x005189B6, 0x00518A57, 0x00518A83, 0x00518AC8, 0x00518AD6, 0x00518B35, 
						  0x00518B54, 0x00518B7B, 0x00518BA3, 0x00518BCB, 0x00518BF2, 0x00518C1A, 0x0051872A, 0x0051873A, 0x00518755, 0x00518DC7, 
						  0x00518DD3, 0x00518E97, 0x00518EA7, 0x00518ED0, 0x00518F17, 0x00519070, 0x0051909E, 0x005190F1, 0x00518FBA, 0x00518FCA, 
						  0x00518FF0, 0x00519023, 0x00519045, 0x0051915A, 0x005193D9, 0x005193FB, 0x005196B0, 0x005196CF, 0x005196E0, 0x00519706, 
						  0x00519725, 0x0051973C, 0x0051976D, 0x00519779, 0x005197D6, 0x00519803, 0x0051982D, 0x0051984C, 0x00519866, 0x00519885, 
						  0x00519604, 0x00519614, 0x00519634, 0x0051965A, 0x00519679, 0x0051968A, 0x00519ADF, 0x00519AEF, 0x00519B81, 0x00519B9B, 
						  0x00519BBA, 0x00519BD5, 0x00519C4A, 0x00519C99, 0x00519D1E, 0x00519D42, 0x00519D7A, 0x00519DA7, 0x00519DF6, 0x00519E20, 
						  0x00519F75, 0x00519F85, 0x0051A00F, 0x0051A0B0, 0x0051A0BC, 0x0051A0D2, 0x0051A0E8, 0x0051A112, 0x0051A1C9, 0x0051A1D9, 
						  0x0051A1F3, 0x0051A21D, 0x0051A230, 0x0051A300, 0x0051A310, 0x0051A32A, 0x0051A340, 0x0051A36A, 0x0051A37C, 0x0051A5FC, 
						  0x0051A617, 0x0051A628, 0x0051A697, 0x0051A587, 0x0051A597, 0x0051A5C7, 0x0051A5DA, 0x0051A979, 0x0051A98F, 0x0051A9A5, 
						  0x0051AA17, 0x0051AB02, 0x0051AB1A, 0x0051AB3D, 0x0051AB53, 0x0051AB69, 0x0051AB97, 0x0051ABA9, 0x0051AC66, 0x0051AC7C, 
						  0x0051AC9D, 0x0051ACAE, 0x0051ACCA, 0x0051ACD9, 0x0051AD5C, 0x0051AD76, 0x0051AD8A, 0x0051ADA0, 0x0051ADB8, 0x0051ADCB, 
						  0x0051ADDC, 0x0051AE19, 0x0051AE2C, 0x0051AE40, 0x0051AE5D, 0x0051AE77, 0x0051AE9B, 0x0051AEB1, 0x0051AEC2, 0x0051AED8, 
						  0x0051AF02, 0x0051AF18, 0x0051AF27, 0x0051AF48, 0x0051A8EE, 0x0051A8FE, 0x0051A928, 0x0051A93E, 0x0051A949, 0x0051BEB6, 
						  0x0051C0DA, 0x0051C12A, 0x0051C159, 0x0051C186, 0x0051C1E5, 0x0051C2C3, 0x0051C099, 0x0051C0A9, 0x0051C0C5, 0x0051C6AD, 
						  0x0051C6B9, 0x0051C6D0, 0x0051C91A, 0x0051C932, 0x0051C943, 0x0051C868, 0x0051C878, 0x0051C892, 0x0051C8B0, 0x0051C8D7, 
						  0x0051CAC9, 0x0051CAD5, 0x0051D53C, 0x0051D54C, 0x0051D680, 0x0051D6FA, 0x0051D70C, 0x0051D744, 0x0051D74D, 0x0051D7EB, 
						  0x0051D7FB, 0x0051D828, 0x0051D838, 0x0051D850, 0x0051D86C, 0x0051D8B4, 0x0051D8EA, 0x0051D91F, 0x0051D95F, 0x0051D995, 
						  0x0051D9BA, 0x0051D9D1, 0x0051DD2E, 0x0051DD64, 0x0051DFB3, 0x0051DFD5, 0x0051E099, 0x0051E0BA, 0x0051E0D0, 0x0051E439, 
						  0x0051E445, 0x0051E45C, 0x0051E465, 0x0051E64A, 0x0051E918, 0x0051E924, 0x0051E957, 0x0051E963, 0x0051E97F, 0x0051E9A1, 
						  0x0051EB64, 0x0051EB7B, 0x0051EB90, 0x0051EBB2, 0x0051EBC1, 0x0051EA68, 0x0051EBDB, 0x0051EBF2, 0x0051EBFB, 0x0051EC13, 
						  0x0051EC22, 0x0051EC38, 0x0051EC4E, 0x0051EC6D, 0x0051EC8A, 0x0051EC9E, 0x0051EA78, 0x0051ED09, 0x0051EDA0, 0x0051EA9E, 
						  0x0051EACA, 0x0051EADE, 0x0051EAFD, 0x0051EB12, 0x0051EB2D, 0x0051EB43, 0x0051F085, 0x0051F09A, 0x0051F3B9, 0x0051F3E0, 
						  0x0051F402, 0x0051F2A8, 0x0051F411, 0x0051F42B, 0x0051F43A, 0x0051F452, 0x0051F467, 0x0051F2CC, 0x0051F2EA, 0x0051F305, 
						  0x0051F32B, 0x0051F357, 0x0051F36B, 0x0051F38E, 0x0051F64E, 0x0051F66F, 0x0051F6C5, 0x0051F706, 0x0051F574, 0x0051F580, 
						  0x0051FD50, 0x0051FD74, 0x0051FDC2, 0x0051FDD1, 0x0051FDF5, 0x0051FE04, 0x0051FED7, 0x0051FF46, 0x0051FF54, 0x0051FD16, 
						  0x0051FD2B, 0x005200D9, 0x005200E5, 0x005200F8, 0x00520113, 0x0052014A, 0x005224F4, 0x00522516, 0x00522531, 0x00522549, 
						  0x005225A6, 0x005225B6, 0x005225D1, 0x005225EC, 0x00522607, 0x00522626, 0x00522641, 0x00522661, 0x0052267D, 0x00522699, 
						  0x005226B1, 0x00522461, 0x00522471, 0x00522488, 0x0052249F, 0x005224BA, 0x005224D9, 0x00522736, 0x00522742, 0x005227F1, 
						  0x005227FD, 0x0052281C, 0x00522831, 0x0052284C, 0x00522A18, 0x00522B60, 0x00522B76, 0x00522B9B, 0x00522BC4, 0x00522BD7, 
						  0x00522B16, 0x00522B41, 0x00522DA4, 0x00522E33, 0x00522E74, 0x00522F38, 0x00522F5C, 0x00522F7A, 0x00522FA5, 0x00523550, 
						  0x00523AD2, 0x00523ADE, 0x00523AF1, 0x00523B0C, 0x00523BBE, 0x00523BCA, 0x005240AA, 0x005240B6, 0x005240CC, 0x00524138, 
						  0x005242C0, 0x0052593A, 0x00525C7A, 0x005262CE, 0x0052634E, 0x00526AB7, 0x00526AD1, 0x00526AF2, 0x00526B09, 0x00526A11, 
						  0x00526A27, 0x00526A77, 0x00526B68, 0x00526CA8, 0x00526F99, 0x005277CA, 0x00527808, 0x00527D29, 0x00527D4A, 0x00527E5F, 
						  0x00527E72, 0x00527EAD, 0x00527F08, 0x005283F7, 0x00528680, 0x00528690, 0x005286A1, 0x005286B1, 0x005286C2, 0x005286CE, 
						  0x005286E8, 0x005286F4, 0x00528707, 0x00528710, 0x00528719, 0x0052879A, 0x005287A6, 0x005287DC, 0x005288EB, 0x005288DF, 
						  0x0052897F, 0x005289C7, 0x00528A6B, 0x00528C87, 0x00528CCE, 0x00528B9A, 0x00528BA6, 0x00528BDA, 0x00528BF5, 0x00528C33, 
						  0x00528D7E, 0x00528D8E, 0x00528DBE, 0x00528DF8, 0x00528FC3, 0x00528FCF, 0x00529083, 0x0052908F, 0x00529281, 0x005292B8, 
						  0x00529307, 0x00529321, 0x0052933B, 0x00529352, 0x00529416, 0x00529435, 0x00529477, 0x005294B8, 0x005291C3, 0x005291CF, 
						  0x00529204, 0x0052922E, 0x0052926C, 0x00529584, 0x00529590, 0x005295EA, 0x00529615, 0x005296D7, 0x005296E3, 0x005296F8, 
						  0x0052976A, 0x00529776, 0x0052A9C6, 0x0052A9DE, 0x0052AA00, 0x0052AA68, 0x0052AB26, 0x0052AB36, 0x0052AB9B, 0x0052ABAB, 
						  0x0052A904, 0x0052B7D2, 0x0052C08B, 0x0052C61C, 0x0052C632, 0x0052C922, 0x0052C931, 0x0052CA61, 0x0052CA7C, 0x0052CAA1, 
						  0x0052CD8D, 0x0052DA8E, 0x0052DAA4, 0x0052DBEA, 0x0052DC7D, 0x0052DC98, 0x0052DCBD, 0x0052E23E, 0x0052FFC8, 0x005300B7, 
						  0x00530287, 0x0053063F, 0x0053064B, 0x0053097F, 0x00531BC9, 0x00531E30, 0x00531DA8, 0x00531DBB, 0x00532299, 0x005322BD, 
						  0x005322CB, 0x0053231F, 0x0053232B, 0x00532341, 0x00532359, 0x00532365, 0x00532378, 0x00532384, 0x005323D5, 0x005323E1, 
						  0x00532427, 0x00532497, 0x00532517, 0x00532523, 0x00532553, 0x0053258E, 0x005325B3, 0x005325DE, 0x005325F1, 0x00532649, 
						  0x00532687, 0x00532698, 0x005326BE, 0x005326EC, 0x00532713, 0x0053273E, 0x00532765, 0x0053277A, 0x0053278B, 0x005327D0, 
						  0x005327E1, 0x005327F2, 0x00532834, 0x00532843, 0x00532878, 0x00532902, 0x005329B4, 0x00532A15, 0x00532A24, 0x00532A49, 
						  0x00532A79, 0x00532B52, 0x005321A9, 0x00532BB0, 0x00532C01, 0x00532C12, 0x00532C22, 0x00532CB0, 0x00532CEA, 0x00532CF9, 
						  0x00532D11, 0x00533376, 0x005333F9, 0x00533405, 0x005334DA, 0x005335CC, 0x005335F8, 0x005336B7, 0x00533775, 0x00533804, 
						  0x0053389B, 0x005338DB, 0x00533992, 0x005339A1, 0x005347EF, 0x00534987, 0x00534A59, 0x00534A6B, 0x0053543D, 0x00535611, 
						  0x0053577D, 0x00535958, 0x00535BE5, 0x00535D1A, 0x00535D2F, 0x00536849, 0x00536884, 0x00536E18, 0x00537057, 0x0053728E, 
						  0x0053729A, 0x005372B9, 0x005372DB, 0x005372EA, 0x005372F9, 0x00537313, 0x0053736A, 0x0053738B, 0x005373A8, 0x005373B7, 
						  0x005373C0, 0x005373D6, 0x005373EE, 0x005374CF, 0x005374DD, 0x0053751B, 0x00537B7B, 0x00537D63, 0x00537D71, 0x00537F30, 
						  0x00537F8C, 0x00537FE1, 0x00537FF8, 0x00538011, 0x00538029, 0x00538044, 0x00538060, 0x0053807B, 0x005380A3, 0x005380E2, 
						  0x005380F8, 0x005383BB, 0x00538429, 0x00538470, 0x005384DA, 0x00538564, 0x0053858C, 0x00537D0A, 0x00538F14, 0x00538F6E, 
						  0x00538FD4, 0x005390D4, 0x0053912E, 0x005392B8, 0x0053930C, 0x00539334, 0x00539262, 0x005393D2, 0x00539427, 0x005394E2, 
						  0x00539533, 0x00539E71, 0x00539EC1, 0x00539FA6, 0x00539FB2, 0x0053A016, 0x0053A022, 0x0053A602, 0x0053A656, 0x0053A6BE, 
						  0x0053A8D6, 0x0053A8FE, 0x0053A922, 0x0053A9A5, 0x0053A7E8, 0x0053AD42, 0x0053AD61, 0x0053AE3C, 0x0053A80A, 0x0053B6DE, 
						  0x0053B93D, 0x0053C02D, 0x0053C039, 0x0053C122, 0x0053C175, 0x0053C185, 0x0053C19B, 0x0053C1B1, 0x0053C1CE, 0x0053C1ED, 
						  0x0053C1FC, 0x0053BDA4, 0x0053BDC8, 0x0053C413, 0x0053C311, 0x0053C5F5, 0x0053C6DD, 0x0053C730, 0x0053C73C, 0x0053C752, 
						  0x0053C771, 0x0053C780, 0x0053C791, 0x0053C805, 0x0053C813, 0x0053C829, 0x0053C3EF, 0x0053C9DD, 0x0053C9EB, 0x0053CA01, 
						  0x0053CA17, 0x0053CB52, 0x0053CA6E, 0x0053CB2A, 0x0053CBC1, 0x0053CCC1, 0x0053CD86, 0x0053D135, 0x0053D7F2, 0x0053DDF0, 
						  0x0053DE03, 0x0053DE26, 0x0053DD46, 0x0053DD56, 0x0053DDC2, 0x0053DDD2, 0x0053DDE0, 0x0053E071, 0x0053E081, 0x0053E098, 
						  0x0053E0CA, 0x0053E0E5, 0x0053E2F6, 0x0053EDD8, 0x0053F044, 0x0053F0F5, 0x0053EEAD, 0x0053F16E, 0x0053F196, 0x0053F1C3, 
						  0x0053EEBD, 0x0053F299, 0x0053F2A7, 0x0053F2DD, 0x0053F30E, 0x0053F32D, 0x0053F350, 0x0053F36F, 0x0053F389, 0x0053F39A, 
						  0x0053F3B7, 0x0053F3C6, 0x0053F3CE, 0x0053F3FD, 0x0053F430, 0x0053F43C, 0x0053F488, 0x0053F49E, 0x0053F4EB, 0x0053F53D, 
						  0x0053F54E, 0x0053F561, 0x0053F5B3, 0x0053F5CD, 0x0053EEF7, 0x0053F639, 0x0053F6A2, 0x0053F9DE, 0x0053F9F8, 0x00540383, 
						  0x0054038F, 0x005403A2, 0x005403C3, 0x0054059E, 0x00540693, 0x00540561, 0x005407C9, 0x005407DC, 0x005407FD, 0x0054086B, 
						  0x005408AA, 0x00540FD4, 0x00541035, 0x00541072, 0x005410A7, 0x005410CB, 0x00540E99, 0x00540EBB, 0x00541865, 0x00541881, 
						  0x005418BB, 0x005418CD, 0x005418DF, 0x005417CD, 0x005417E7, 0x005417F9, 0x00541810, 0x00541B92, 0x00541BC2, 0x00541BF2, 
						  0x00541C0B, 0x00541C17, 0x00541B7F, 0x00541C94, 0x00541CA3, 0x00541D12, 0x00541D1E, 0x00541D31, 0x00541EAE, 0x00541ED1, 
						  0x00541EF7, 0x00541F02, 0x00541F48, 0x00541F76, 0x00541F7F, 0x00541E03, 0x00541E13, 0x00541E23, 0x00541E42, 0x00541E66, 
						  0x0054283B, 0x0054284B, 0x00542AAE, 0x00542E93, 0x00542D88, 0x00543D82, 0x00543D8E, 0x00543DA4, 0x00543C9E, 0x00543CAE, 
						  0x00543CC8, 0x00543CE7, 0x00543D1F, 0x005440B3, 0x005440D0, 0x0054417F, 0x00543FF8, 0x00544017, 0x0054445B, 0x00544687, 
						  0x0054533A, 0x005455A2, 0x00545C08, 0x00545C18, 0x00545C38, 0x00545D27, 0x00545D50, 0x00545D99, 0x00545DAC, 0x00545DE2, 
						  0x00545DF5, 0x00545B42, 0x00545B52, 0x00545B72, 0x00545B9D, 0x00545BE6, 0x00545F62, 0x00545E8D, 0x00546018, 0x005462AA, 
						  0x00546505, 0x005467C7, 0x00546824, 0x0054699A, 0x00546A6C, 0x00546BC2, 0x00546BE5, 0x00546E8C, 0x00546EFB, 0x0054713D, 
						  0x0054717C, 0x00547289, 0x005472F4, 0x005476CA, 0x0054779A, 0x00547A78, 0x00547B6B, 0x00547BBD, 0x00547CEC, 0x00548401, 
						  0x0054840D, 0x0054845A, 0x0054846A, 0x005485FC, 0x00548631, 0x0054863D, 0x00548E0B, 0x00548E17, 0x00548F91, 0x00548F9D, 
						  0x005490D9, 0x005490E5, 0x005490FB, 0x00549185, 0x00549193, 0x00549875, 0x005498A2, 0x005498CC, 0x00549906, 0x00549A54, 
						  0x00549A6A, 0x00549965, 0x00549AA7, 0x00549AC4, 0x00549ADA, 0x00549B01, 0x00549988, 0x005499B5, 0x005499E2, 0x00549A16, 
						  0x00549CBF, 0x00549CCF, 0x00549D2E, 0x00549E34, 0x00549E4C, 0x0054A207, 0x0054A217, 0x0054A252, 0x0054A32A, 0x0054A33A, 
						  0x0054A4B5, 0x0054A4C1, 0x0054A4DD, 0x0054A55A, 0x0054A566, 0x0054A6E0, 0x0054A73E, 0x0054A74E, 0x0054A63E, 0x0054A678, 
						  0x0054A689, 0x0054A6A3, 0x0054A6D2, 0x0054A7F5, 0x0054A80C, 0x0054A830, 0x0054A84F, 0x0054A85E, 0x0054AAE7, 0x0054AAF3, 
						  0x0054ABF8, 0x0054AC04, 0x0054ACA8, 0x0054ACB4, 0x0054ADC2, 0x0054ADD0, 0x0054ADE6, 0x0054B11B, 0x0054B3BE, 0x0054B803, 
						  0x0054B844, 0x0054B718, 0x0054B728, 0x0054B784, 0x0054BC85, 0x0054BC91, 0x0054C7DB, 0x0054D5F6, 0x0054D78B, 0x0054D85F, 
						  0x0054D894, 0x0054D8B9, 0x0054D8DE, 0x0054D903, 0x0054D94F, 0x0054D977, 0x0054D99F, 0x0054D9C7, 0x0054D9EF, 0x0054DA14, 
						  0x0054DA39, 0x0054DA5E, 0x0054DA83, 0x0054DAAB, 0x0054DAD3, 0x0054DAFB, 0x0054DB23, 0x0054DB5F, 0x0054DB87, 0x0054DBC3, 
						  0x0054DC16, 0x0054DC61, 0x0054DC89, 0x0054DCB1, 0x0054DCD9, 0x0054DD01, 0x0054DD51, 0x0054D6D1, 0x0054E2D0, 0x0054E966, 
						  0x0054FCCA, 0x0054FE0F, 0x00550EF0, 0x0055104B, 0x00551075, 0x005510E2, 0x0055110C, 0x0055112D, 0x0055113C, 0x00551151, 
						  0x00550F28, 0x00550F80, 0x00551183, 0x005512D9, 0x005512E5, 0x005512F1, 0x00551310, 0x00551199, 0x005511CA, 0x0055120C, 
						  0x00551238, 0x00551352, 0x00551371, 0x00551392, 0x005513B1, 0x005513E2, 0x00551401, 0x00551420, 0x0055143F, 0x00551472, 
						  0x00551488, 0x005514E4, 0x005514F0, 0x00551509, 0x00551516, 0x00552079, 0x00552558, 0x005525B4, 0x00555952, 0x0055596F, 
						  0x005559A1, 0x00555A72, 0x00555A82, 0x00555A95, 0x00555ABA, 0x00555ADE, 0x00555B04, 0x00555B1E, 0x00555B41, 0x00555B70, 
						  0x00555B8D, 0x00555BBF, 0x005558CD, 0x005558DD, 0x00555903, 0x0055591D, 0x005582DE, 0x005582EA, 0x00558300, 0x00558316, 
						  0x0055832C, 0x005584AB, 0x005584B7, 0x005584E6, 0x005584FB, 0x00558A07, 0x0055937B, 0x0055AB0A, 0x0055AF95, 0x0055AFD6, 
						  0x0055AFEE, 0x0055B015, 0x0055B0CC, 0x0055AEF7, 0x0055AF15, 0x0055AF26, 0x0055B462, 0x0055B494, 0x0055B4B5, 0x0055B4CB, 
						  0x0055B4E9, 0x0055B3AC, 0x0055B3BF, 0x0055B653, 0x0055B67C, 0x0055B59D, 0x0055B5B0, 0x0055B8FA, 0x0055B929, 0x0055B95B, 
						  0x0055B80A, 0x0055B99C, 0x0055B9C4, 0x0055B9F7, 0x0055BA15, 0x0055BA60, 0x0055BBE5, 0x0055B836, 0x0055B84B, 0x0055B882, 
						  0x0055BDD6, 0x0055BDE5, 0x0055BE21, 0x0055BE3C, 0x0055BEBD, 0x0055BF38, 0x0055BF1D, 0x0055C377, 0x0055CCDD, 0x0055D594, 
						  0x0055DA95, 0x0055DE4C, 0x0055DE73, 0x0055E305, 0x0055EEE0, 0x0055F2A2, 0x0055FF29, 0x00560098, 0x00560742, 0x00560E46, 
						  0x00561878, 0x00561C2F, 0x005621A7, 0x00562817, 0x00563673, 0x00563A1A, 0x00563B6A, 0x00564AC8, 0x00564D46, 0x005655CB, 
						  0x005655D9, 0x005655E4, 0x00565AA0, 0x00566293, 0x00566277, 0x00566566, 0x00566700, 0x005668BF, 0x00566F2F, 0x00567781, 
						  0x005687B3, 0x0056895F, 0x0056917A, 0x005692FE, 0x00569ACA, 0x00569ABF, 0x0056ADAA, 0x0056B5F4, 0x0056B631, 0x0056D834, 
						  0x0056D83F, 0x0056D675, 0x0056D68D, 0x0056DC09, 0x0056DC17, 0x0056DC23, 0x0056DAE1, 0x0056DB02, 0x0056DB35, 0x0056EC75, 
						  0x0056F13E, 0x0056F16E, 0x0056F19E, 0x0056F2C7, 0x0056F2D6, 0x0056F2E8, 0x0056FDF5, 0x0056FEFF, 0x0056FF18, 0x0056FF4B, 
						  0x005701E4, 0x0057012D, 0x00570173, 0x00570188, 0x005705DC, 0x00570605, 0x005719B4, 0x005719E4, 0x00571A14, 0x00571A44, 
						  0x00571F84, 0x0057293C, 0x00572948, 0x0057295C, 0x00572A46, 0x00572A5E, 0x00572B34, 0x00572B4F, 0x00572C15, 0x00572CF5, 
						  0x00573070, 0x0057307C, 0x00573090, 0x00574699, 0x00574749, 0x00574889, 0x00575004, 0x0057501E, 0x00574F3A, 0x00574F4A, 
						  0x00574F7A, 0x00574F8D, 0x00574FAD, 0x0057514B, 0x0057515A, 0x005751EB, 0x005751FA, 0x0057540B, 0x00575668, 0x005756F5, 
						  0x00575D68, 0x005764AB, 0x005767C8, 0x005768E9, 0x00576935, 0x00576A33, 0x00576BA7, 0x00576C71, 0x005779DB, 0x00577B65, 
						  0x00578161, 0x0057943F, 0x0057960F, 0x0057C10F, 0x0057C14F, 0x0057C21F, 0x0057C25F, 0x0057C32F, 0x0057C36F, 0x0057C439, 
						  0x0057C45E, 0x0057D3B2, 0x0057D75C, 0x0057D768, 0x0057D77C, 0x0057D97F, 0x0057DA5F, 0x0057DB3F, 0x0057E3D0, 0x0057E481, 
						  0x0057E4F7, 0x0057E591, 0x0057E77B, 0x0057E79C, 0x0057E815, 0x0057E82D, 0x0057E839, 0x0057E8B9, 0x0057E931, 0x0057EC6B, 
						  0x0057ECFB, 0x0057EDAA, 0x0057EDB6, 0x0057FB68, 0x0057FB74, 0x0057FD64, 0x0057FF7C, 0x005801EB, 0x00580CBD, 0x005810E0, 
						  0x00581577, 0x0058156C, 0x00583435, 0x00583563, 0x005839EA, 0x0058761C, 0x0058824A, 0x005883FC, 0x0058840B, 0x0058B3FE, 
						  0x0058C78F, 0x0058CE3F, 0x0058D124, 0x0058D2DC, 0x0058D45D, 0x0058D4C9, 0x0058D549, 0x0058D5D2, 0x0058D749, 0x0058E58F, 
						  0x0058E683, 0x0058E69F, 0x0058FFC7, 0x0059049D, 0x005904AC, 0x005904C4, 0x0059046F, 0x0059098E, 0x00591396, 0x00591867, 
						  0x00591876, 0x005918B8, 0x0059122A, 0x00591A51, 0x00591D09, 0x0059207B, 0x00592291, 0x005924A5, 0x005924C4, 0x005924DC, 
						  0x0059279B, 0x005927A7, 0x00592BF4, 0x00592C04, 0x00592CE5, 0x00592838, 0x00592DC9, 0x00592850, 0x00592EEC, 0x00592F03, 
						  0x00592F28, 0x00592F38, 0x00592F83, 0x00593005, 0x00592868, 0x0059288A, 0x00593233, 0x005934E9, 0x00593519, 0x00593549, 
						  0x005936FB, 0x00593710, 0x0059470D, 0x0059476D, 0x005947C6, 0x0059482D, 0x00594BF3, 0x0059545F, 0x00595476, 0x005954CF, 
						  0x005956BD, 0x00595756, 0x00595878, 0x00595887, 0x005958B8, 0x005958DB, 0x00595947, 0x00595958, 0x00595C1C, 0x005971C6, 
						  0x00597E11, 0x00597E23, 0x00597E3B, 0x00597E70, 0x00597ECE, 0x00597D2D, 0x00597EF5, 0x0059805A, 0x00597D92, 0x00597D9E, 
						  0x00597DE7, 0x00597D1E, 0x00597DFF, 0x00598383, 0x005983AE, 0x005983C5, 0x0059853C, 0x00598682, 0x00598BCB, 0x005990DB, 
						  0x005990E7, 0x005990FB, 0x0059910E, 0x00599126, 0x005991B9, 0x00599257, 0x005992D7, 0x005993E0, 0x005998C8, 0x005998D4, 
						  0x005999C8, 0x005999D4, 0x00599AF1, 0x00599B12, 0x00599B1E, 0x0059A0A6, 0x0059A0BE, 0x0059A098, 0x0059A570, 0x0059A5BD, 
						  0x0059A5D0, 0x0059A5F8, 0x0059A638, 0x0059A690, 0x0059ABBF, 0x0059AC1A, 0x0059ADEA, 0x0059AE45, 0x0059B2C3, 0x0059B42A, 
						  0x0059B8BE, 0x0059B939, 0x0059B970, 0x0059B9A7, 0x0059B95B, 0x0059BA4B, 0x0059BA60, 0x0059BBE6, 0x0059BC76, 0x0059C0B9, 
						  0x0059C1A9, 0x0059C2F4, 0x0059C4D6, 0x0059C599, 0x0059C69E, 0x0059C7C9, 0x0059D2CA, 0x0059D1DE, 0x0059DB94, 0x0059DBFD, 
						  0x0059E2A1, 0x0059E2B4, 0x0059F612, 0x0059F57B, 0x0059F5E2, 0x0059F66D, 0x0059F658, 0x0059F8AD, 0x0059FC36, 0x0059FC4E, 
						  0x0059FC5A, 0x0059FEB0, 0x0059FEC8, 0x0059FEF6, 0x0059FF1C, 0x0059FF2C, 0x005A03EB, 0x005A03FB, 0x005A0404, 0x005A0413, 
						  0x005A042D, 0x005A0436, 0x005A043F, 0x005A031D, 0x005A0341, 0x005A036A, 0x005A037B, 0x005A039F, 0x005A063E, 0x005A069E, 
						  0x005A0FFF, 0x005A127D, 0x005A1291, 0x005A12A5, 0x005A12B9, 0x005A12D7, 0x005A12F4, 0x005A1329, 0x005A1AD6, 0x005A1AE1, 
						  0x005A1D67, 0x005A1E0A, 0x005A1E16, 0x005A22B0, 0x005A2337, 0x005A32A1, 0x005A32AD, 0x005A37AF, 0x005A37BB, 0x005A4782, 
						  0x005A4F87, 0x005A4FCB, 0x005A50BE, 0x005A5100, 0x005A520A, 0x005A52D4, 0x005A531F, 0x005A5BD1, 0x005A5FD4, 0x005A5FBA, 
						  0x005A62A8, 0x005A6328, 0x005A777C, 0x005A778D, 0x005A77A6, 0x005A7697, 0x005A76BD, 0x005A796E, 0x005A787F, 0x005A800D, 
						  0x005A8044, 0x005A807A, 0x005A854B, 0x005A8560, 0x005A8D6D, 0x005A8FE1, 0x005A9049, 0x005A93EB, 0x005A932D, 0x005A933E, 
						  0x005A934A, 0x005A936B, 0x005A9454, 0x005A9473, 0x005A94BE, 0x005A9E09, 0x005A9E34, 0x005A9E75, 0x005A9ED2, 0x005A9F06, 
						  0x005A9F2A, 0x005A9F46, 0x005A9F6A, 0x005A9F8B, 0x005A9FAF, 0x005A9FC7, 0x005A9FD0, 0x005A9FF4, 0x005A9D23, 0x005AA02C, 
						  0x005AA050, 0x005AA09A, 0x005AA0A3, 0x005AA0C7, 0x005A9D31, 0x005AA1D4, 0x005AA1F2, 0x005A9D54, 0x005A9D7E, 0x005AA557, 
						  0x005AA41A, 0x005AA42A, 0x005AA467, 0x005AA81A, 0x005AA72A, 0x005AA9F1, 0x005AA92A, 0x005AADE8, 0x005AAD6F, 0x005AB002, 
						  0x005AB02F, 0x005AB03D, 0x005AB06F, 0x005AB09C, 0x005AB0AA, 0x005AB0D3, 0x005AB0FD, 0x005AB10B, 0x005AB134, 0x005AAF34, 
						  0x005AAF79, 0x005AAFBE, 0x005AAFCC, 0x005AB583, 0x005AB50A, 0x005AB82E, 0x005AB767, 0x005AC067, 0x005AC34E, 0x005ACC23, 
						  0x005ACFC8, 0x005ACFD8, 0x005ACFE8, 0x005ACFF8, 0x005AD017, 0x005AD009, 0x005AD063, 0x005AD048, 0x005AD290, 0x005AD55F, 
						  0x005AD775, 0x005ADC0D, 0x005ADC19, 0x005AEA2D, 0x005AEB3A, 0x005AEC2E, 0x005AEEDE, 0x005AF044, 0x005AEF53, 0x005AEFBF, 
						  0x005AEF2B, 0x005AEFEC, 0x005AFA01, 0x005AF63A, 0x005B055E, 0x005B0582, 0x005B06B6, 0x005B06D7, 0x005B0702, 0x005B071A, 
						  0x005B0748, 0x005B0756, 0x005B07C3, 0x005B07D1, 0x005B09F7, 0x005B0A18, 0x005B0A66, 0x005B0AD2, 0x005B0AF2, 0x005B0B0A, 
						  0x005B0B22, 0x005B0B48, 0x005B15DD, 0x005B1AF1, 0x005B1AD8, 0x005B1B60, 0x005B1B93, 0x005B1B4B, 0x005B2558, 0x005B257C, 
						  0x005B269C, 0x005B26BD, 0x005B26E8, 0x005B2700, 0x005B272E, 0x005B273C, 0x005B27A9, 0x005B27B7, 0x005B29DD, 0x005B29FE, 
						  0x005B2A4C, 0x005B2AB8, 0x005B2AD8, 0x005B2B0C, 0x005B2B1A, 0x005B2B37, 0x005B2B45, 0x005B2B6A, 0x005B2B8E, 0x005B2BA6, 
						  0x005B2BDB, 0x005B2E4E, 0x005B2E59, 0x005B2DAD, 0x005B2E2A, 0x005B3550, 0x005B35CA, 0x005B3646, 0x005B36F6, 0x005B378A, 
						  0x005B3D68, 0x005B3DCA, 0x005B3E29, 0x005B4187, 0x005B41DD, 0x005B4233, 0x005B4A79, 0x005B4BF3, 0x005B4FCE, 0x005B5140, 
						  0x005B65BA, 0x005B67DF, 0x005B68C6, 0x005B6B26, 0x005B6B4C, 0x005B6B66, 0x005B6B84, 0x005B6BB3, 0x005B6AA7, 0x005B6AE1, 
						  0x005B6AFB, 0x005B7DC2, 0x005B7E4F, 0x005B7D31, 0x005B7D5E, 0x005B804A, 0x005B8961, 0x005B8C7D, 0x005B8F71, 0x005B8F95, 
						  0x005B8FF6, 0x005B901A, 0x005B9249, 0x005B9339, 0x005B94E0, 0x005BA90E, 0x005BA923, 0x005BA94D, 0x005BA9C2, 0x005BA9D7, 
						  0x005BAA01, 0x005BAA72, 0x005BAA87, 0x005BAAB1, 0x005BC1ED, 0x005BC1F5, 0x005BC2AD, 0x005BC2B5, 0x005BC36D, 0x005BC375, 
						  0x005BCCFF, 0x005BCC13, 0x005BD618, 0x005BD624, 0x005BD63B, 0x005BD9FD, 0x005BDB2A, 0x005C048A, 0x005C065A, 0x005C082A, 
						  0x005C0973, 0x005C096A, 0x005C0EFF, 0x005C0F3A, 0x005C0F45, 0x005C0F79, 0x005C0F84, 0x005C0F8F, 0x005C0FB0, 0x005C0FFC, 
						  0x005C1014, 0x005C1020, 0x005C103B, 0x005C1046, 0x005C107A, 0x005C109A, 0x005C0EC5, 0x005C0EE0, 0x005C0EEF, 0x005C121F, 
						  0x005C122B, 0x005C1234, 0x005C123E, 0x005C1FDE, 0x005C1FED, 0x005C240C, 0x005C245F, 0x005C3060, 0x005C3D7C, 0x005C42A4, 
						  0x005C4992, 0x005C4B89, 0x005C4BB1, 0x005C5309, 0x005C5380, 0x005C5506, 0x005C55A5, 0x005C5619, 0x005C568D, 0x005C528E, 
						  0x005C575E, 0x005C5EB4, 0x005C6ADD, 0x005C7B28, 0x005C8055, 0x005C831B, 0x005C899F, 0x005C8FF2, 0x005C9004, 0x005C942D, 
						  0x005C953C, 0x005C9941, 0x005C9794, 0x005CA0B3, 0x005CA8B0, 0x005CB1A4, 0x005CB45A, 0x005CBE64, 0x005CC641, 0x005CC62C, 
						  0x005CD30B, 0x005CD2F9, 0x005CD433, 0x005CD444, 0x005CD465, 0x005CD3F0, 0x005CDD9E, 0x005CE3C9, 0x005CE2B8, 0x005CE49A, 
						  0x005CE57A, 0x005CE6AA, 0x005CE7BA, 0x005CED65, 0x005CEF01, 0x005CEF0D, 0x005CF5DA, 0x005CF6CA, 0x005CF7CA, 0x005CF8BA, 
						  0x005CFD27, 0x005CFDCA, 0x005CFFE0, 0x005D0071, 0x005D01CA, 0x005D031A, 0x005D0B9D, 0x005D0AB3, 0x005D0D70, 0x005D0F91, 
						  0x005D0F42, 0x005D0F86, 0x005D10D1, 0x005D1082, 0x005D10C6, 0x005D1AF7, 0x005D3069, 0x005D30BD, 0x005D3107, 0x005D2E5E, 
						  0x005D3154, 0x005D2E6E, 0x005D2F07, 0x005D32F2, 0x005D330C, 0x005D31FE, 0x005D320E, 0x005D3B10, 0x005D3B26, 0x005D3B50, 
						  0x005D47B3, 0x005D4C42, 0x005D5F8B, 0x005D69B2, 0x005D69BE, 0x005D69FB, 0x005D75C0, 0x005D75E2, 0x005D74DC, 0x005D7512, 
						  0x005D752C, 0x005D754B, 0x005D7574, 0x005D759D, 0x005D7884, 0x005D7890, 0x005D78AF, 0x005D7754, 0x005D7760, 0x005D7784, 
						  0x005D779E, 0x005D7BB6, 0x005D7C24, 0x005D805A, 0x005D806A, 0x005D8238, 0x005D8244, 0x005D8BF0, 0x005D8F0A, 0x005D8FBA, 
						  0x005D906A, 0x005D911A, 0x005D91CA, 0x005D927A, 0x005D932A, 0x005D93DA, 0x005D948A, 0x005D953A, 0x005D95EA, 0x005DA373, 
						  0x005DA3B7, 0x005DA3C3, 0x005DA3D4, 0x005DA421, 0x005DA230, 0x005DA240, 0x005DA252, 0x005DA276, 0x005DA543, 0x005DA54F, 
						  0x005DA571, 0x005DA597, 0x005DA6E2, 0x005DA6F0, 0x005DA71C, 0x005DA7A9, 0x005DA613, 0x005DA623, 0x005DA63B, 0x005DA6C5, 
						  0x005DAA01, 0x005DAA0F, 0x005DAC7D, 0x005DAC8D, 0x005DAC9F, 0x005DACC3, 0x005DAE78, 0x005DAE92, 0x005DB31C, 0x005DB32C, 
						  0x005DB4CA, 0x005DBE45, 0x005DC1F5, 0x005DCB80, 0x005DCF92, 0x005DD185, 0x005DD3AA, 0x005DD53A, 0x005DD63A, 0x005DDF63, 
						  0x005DDF79, 0x005DDF93, 0x005DE2A6, 0x005DE88A, 0x005DF05F, 0x005DF2D1, 0x005DF955, 0x005E0142, 0x005E0F5F, 0x005E17B0, 
						  0x005E1ED6, 0x005E1F82, 0x005E217E, 0x005E2430, 0x005E24C3, 0x005E252A, 0x005E272A, 0x005E2953, 0x005E296E, 0x005E2977, 
						  0x005E299A, 0x005E29A3, 0x005E29E1, 0x005E29EA, 0x005E36D6, 0x005E6DC7, 0x005E6DD5, 0x005E6DEA, 0x005E5AE8, 0x005E72F3, 
						  0x005E72FF, 0x005E7C9A, 0x005E7CB7, 0x005E7F69, 0x005E7F77, 0x005E8E2A, 0x005E8E7C, 0x005E8DFE, 0x005E913D, 0x005E9534, 
						  0x005E9553, 0x005E95F6, 0x005E96F8, 0x005E974B, 0x005E9F42, 0x005EA4C5, 0x005EA4E5, 0x005EA82A, 0x005EAA02, 0x005EAB66, 
						  0x005EABA3, 0x005EA929, 0x005EA94D, 0x005EA962, 0x005EA96F, 0x005EA9A9, 0x005EAD30, 0x005EAC64, 0x005EADB8, 0x005EAF6E, 
						  0x005EAFE5, 0x005EB0B3, 0x005EB0CE, 0x005EB0E9, 0x005EB170, 0x005EB2FA, 0x005EB3EC, 0x005EB486, 0x005EB1E3, 0x005EB24B, 
						  0x005EB99E, 0x005EB9BF, 0x005EB9E4, 0x005EB828, 0x005EB8AA, 0x005EBCE2, 0x005EBCF4, 0x005EBD12, 0x005EBD55, 0x005EBD88, 
						  0x005EBDAA, 0x005EBE66, 0x005EBE7D, 0x005EBE8C, 0x005EBEB7, 0x005EBF28, 0x005EBF39, 0x005EBF4C, 0x005EBF6D, 0x005EBFD8, 
						  0x005EBFF4, 0x005EC006, 0x005EC028, 0x005EC1FA, 0x005EC211, 0x005EC220, 0x005EC263, 0x005EC295, 0x005EC306, 0x005EC317, 
						  0x005EC35A, 0x005EC380, 0x005EC39B, 0x005EC3B2, 0x005EC3C6, 0x005EC3FD, 0x005EC815, 0x005EC754, 0x005EC95E, 0x005EC98D, 
						  0x005ECAB4, 0x005ECBEB, 0x005ECC05, 0x005ECDD1, 0x005ECDEC, 0x005ECDFD, 0x005ECE1E, 0x005ECE2A, 0x005ECEA7, 0x005ECEC9, 
						  0x005ECD7A, 0x005ECD9B, 0x005ECDAC, 0x005ECCDE, 0x005ECDC0, 0x005ECF20, 0x005ED344, 0x005ED390, 0x005ED3C2, 0x005ED506, 
						  0x005ED515, 0x005ED5F1, 0x005ED60B, 0x005ED646, 0x005ED6F8, 0x005ED73B, 0x005ED7D9, 0x005ED899, 0x005ED998, 0x005ED9AB, 
						  0x005EDB14, 0x005EDB97, 0x005EDBB1, 0x005EDC2C, 0x005EDC51, 0x005EDC87, 0x005EDD02, 0x005EDF0A, 0x005ED4A8, 0x005EDFCC, 
						  0x005EE1CF, 0x005EE3E3, 0x005EE3EF, 0x005EE413, 0x005EE428, 0x005EE5DF, 0x005EE652, 0x005EE2C1, 0x005EE301, 0x005EE324, 
						  0x005EF3B0, 0x005EF824, 0x005EF855, 0x005EF887, 0x005EF92A, 0x005EF946, 0x005EF97F, 0x005EF99E, 0x005EF9EC, 0x005EFAAE, 
						  0x005EFACD, 0x005EFB20, 0x005EF65C, 0x005EF67C, 0x005EF68D, 0x005EF6AE, 0x005EFD08, 0x005EFD2C, 0x005EFD58, 0x005F05BC, 
						  0x005F05D6, 0x005F1C2C, 0x005F1C58, 0x005F1C6D, 0x005F2207, 0x005F221C, 0x005F22AC, 0x005F1ECE, 0x005F252F, 0x005F2E12, 
						  0x005F358A, 0x005F36EA, 0x005F37DA, 0x005F38DA, 0x005F39FA, 0x005F3A41, 0x005F3AFA, 0x005F3CEA, 0x005F3EBA, 0x005F5387, 
						  0x005F5397, 0x005F53B1, 0x005F53D0, 0x005F53F0, 0x005F544B, 0x005F5461, 0x005F5478, 0x005F549B, 0x005F54C8, 0x005F54F4, 
						  0x005F550D, 0x005F553A, 0x005F5560, 0x005F559C, 0x005F55ED, 0x005F5623, 0x005F5655, 0x005F5688, 0x005F56B3, 0x005F56DC, 
						  0x005F56F5, 0x005F5712, 0x005F573A, 0x005F574B, 0x005F5771, 0x005F57C1, 0x005F5E66, 0x005F6369, 0x005F637D, 0x005F65B6, 
						  0x005F65C2, 0x005F65D8, 0x005F65F7, 0x005F6611, 0x005F67A6, 0x005F67CC, 0x005F685B, 0x005F66DE, 0x005F66EE, 0x005F671F, 
						  0x005F676A, 0x005F707A, 0x005F7034, 0x005F705B, 0x005F7264, 0x005F7270, 0x005F7471, 0x005F74B4, 0x005F74C5, 0x005F7538, 
						  0x005F754A, 0x005F87CE, 0x005F87E0, 0x005F880E, 0x005F8845, 0x005F885E, 0x005F88AA, 0x005F88B9, 0x005F88CC, 0x005F88E5, 
						  0x005F8AAB, 0x005F78C2, 0x005F8AD0, 0x005F8AE8, 0x005F8B09, 0x005F8B24, 0x005F78D2, 0x005F7900, 0x005F8EAE, 0x005F8ED0, 
						  0x005F8EF8, 0x005F8F04, 0x005F7916, 0x005F90F2, 0x005F9104, 0x005F9135, 0x005F9171, 0x005F918A, 0x005F91DC, 0x005F91EB, 
						  0x005F91FE, 0x005F9217, 0x005F9285, 0x005F92A3, 0x005F7A00, 0x005F7A55, 0x005F7A61, 0x005F7A77, 0x005F7B27, 0x005F7CE2, 
						  0x005F7CF4, 0x005F7D22, 0x005F7D65, 0x005F7D7E, 0x005F7DB2, 0x005F7DE6, 0x005F7DF5, 0x005F7E08, 0x005F7E21, 0x005F7F0A, 
						  0x005F7F84, 0x005F7F97, 0x005F7FB0, 0x005F8011, 0x005F809C, 0x005F80AF, 0x005F815B, 0x005F81E4, 0x005F81F3, 0x005F7842, 
						  0x005F82B5, 0x005F8348, 0x005F83C1, 0x005F849A, 0x005F84AC, 0x005F84DC, 0x005F84E8, 0x005F8508, 0x005F857C, 0x005F8607, 
						  0x005F8633, 0x005F8672, 0x005F869A, 0x005F86C3, 0x005F97CC, 0x005F9948, 0x005F9954, 0x005F9AB0, 0x005F9ABF, 0x005F9AEE, 
						  0x005F9B1C, 0x005F9B28, 0x005F9B38, 0x005F9B50, 0x005F9B89, 0x005F9F23, 0x005F9F48, 0x005F9FE4, 0x005FA009, 0x005F9EE4, 
						  0x005F9EF0, 0x005F9EFB, 0x005FAF4E, 0x005FBC5B, 0x005FC727, 0x005FC742, 0x005FC77F, 0x005FC7BE, 0x005FC7E0, 0x005FC81F, 
						  0x005FC880, 0x005FC889, 0x005FC8A7, 0x005FCB4C, 0x005FCB5E, 0x005FCD18, 0x005FCD2C, 0x005FCF87, 0x005FCFA2, 0x005FCFCD, 
						  0x005FD0A0, 0x005FD0D9, 0x005FD11D, 0x005FCE91, 0x005FD2AF, 0x005FD2BF, 0x005FD2DD, 0x005FD340, 0x005FD350, 0x005FD38F, 
						  0x005FD3B1, 0x005FD3C1, 0x005FD3D1, 0x005FD3E1, 0x005FD41D, 0x005FD44A, 0x005FD49B, 0x005FD4BE, 0x005FD4D6, 0x005FD4EC, 
						  0x005FD501, 0x005FD527, 0x005FD543, 0x005FD57B, 0x005FD587, 0x005FD5A0, 0x005FD5A9, 0x005FD5B8, 0x005FD5D6, 0x005FD5FC, 
						  0x005FDC41, 0x005FDC58, 0x005FDF4D, 0x005FE2A2, 0x005FEB7D, 0x005FEBEF, 0x005FEBFB, 0x005FEC83, 0x005FF2CE, 0x005FF2E7, 
						  0x005FF431, 0x005FF455, 0x005FF47C, 0x005FF68F, 0x005FF6BA, 0x005FF6C6, 0x005FF6D9, 0x005FF6F4, 0x005FFC2A, 0x005FFCFA, 
						  0x005FFDAA, 0x005FFE5A, 0x0060000A, 0x0060018A, 0x006006B5, 0x006005C8, 0x006005D4, 0x00600618, 0x0060062B, 0x00600649, 
						  0x00600663, 0x0060068C, 0x0060099A, 0x00600A8A, 0x00600B9A, 0x00600D95, 0x00600E30, 0x00600EE5, 0x00600F80, 0x006016E0, 
						  0x006017CA, 0x006017D1, 0x00602109, 0x0060216A, 0x006021A7, 0x006021C7, 0x00602C83, 0x00602C8F, 0x00602CA9, 0x00602CCA, 
						  0x006030A2, 0x006030B4, 0x00604B05, 0x00603EE9, 0x00606558, 0x0060657D, 0x006065AB, 0x0060645D, 0x00606478, 0x00606489, 
						  0x0060649A, 0x00606A8D, 0x00606AAB, 0x00606CB0, 0x00606D5C, 0x00607466, 0x00607483, 0x006074E9, 0x0060750A, 0x0060751D, 
						  0x0060753F, 0x0060755C, 0x006075C2, 0x006072B6, 0x006075E3, 0x006075F6, 0x00607780, 0x00607796, 0x0060947A, 0x0060AA2F, 
						  0x0060ABAE, 0x0060AB9F, 0x0060AF81, 0x0060BB90, 0x0060C0C7, 0x0060C67F, 0x0060D269, 0x0060D7A2, 0x0060DC5C, 0x0060E0F6, 
						  0x0060DFC8, 0x0060DFFE, 0x0060E2CB, 0x0060EEBF, 0x0060EF24, 0x0060EEAF, 0x0060EF50, 0x0060EF7C, 0x0060EFE1, 0x0060F0A5, 
						  0x0060F10A, 0x0060F1A7, 0x0060F18C, 0x0060F1EC, 0x0060F226, 0x0060F1DC, 0x0060F335, 0x0060F341, 0x0060FBF8, 0x0060FC04, 
						  0x00610477, 0x00610487, 0x006104BC, 0x006104CC, 0x0061163D, 0x00611C94, 0x00611CA2, 0x00612810, 0x00612826, 0x0061284F, 
						  0x0061352F, 0x0061372D, 0x00613777, 0x0061378F, 0x00613A60, 0x00613AC3, 0x00613862, 0x00613894, 0x0061408F, 0x00613FF4, 
						  0x0061440C, 0x0061493A, 0x0061494A, 0x00614955, 0x0061495F, 0x00614984, 0x00614991, 0x006149B4, 0x006149C3, 0x006149D8, 
						  0x006149EE, 0x006149F8, 0x00614A0D, 0x00614A17, 0x00614A34, 0x00614A41, 0x00614887, 0x0061488E, 0x0061489E, 0x006148B8, 
						  0x006148BF, 0x00614ACD, 0x00614F35, 0x00614F3E, 0x00614F70, 0x00614F85, 0x00615774, 0x006157A7, 0x006157CD, 0x00615801, 
						  0x00615828, 0x00615858, 0x00615867, 0x0061569D, 0x006156AD, 0x006156DC, 0x006156F6, 0x00615708, 0x0061599D, 0x006159A9, 
						  0x00615C58, 0x00615C64, 0x00615C8C, 0x00615C98, 0x00615CC5, 0x00615CF3, 0x00615D24, 0x00615D34, 0x00615D53, 0x00615D94, 
						  0x00615DCA, 0x00615DDB, 0x00615E05, 0x00615E51, 0x00615EAA, 0x00615EBA, 0x006178C4, 0x00618C7C, 0x00618DC4, 0x00618E1B, 
						  0x00618E4A, 0x00618F36, 0x00618F67, 0x00619625, 0x0061A28F, 0x0061A2F1, 0x0061A59A, 0x0061A5B9, 0x0061A5DA, 0x0061A679, 
						  0x0061A6B5, 0x0061A43F, 0x0061A81C, 0x0061AA1A, 0x0061AD17, 0x0061B24C, 0x0061B269, 0x0061B542, 0x0061B567, 0x0061CF3B, 
						  0x0061CF47, 0x0061D86F, 0x0061DE81, 0x0061DD9B, 0x0061E057, 0x0061E341, 0x0061E369, 0x0061E15E, 0x0061E1E4, 0x0061E627, 
						  0x0061EAD8, 0x0061EC83, 0x0061F102, 0x0061ECA2, 0x0061F1BC, 0x0061ECB8, 0x0061ECCE, 0x0061F388, 0x0061F39F, 0x00620539, 
						  0x006206A3, 0x006206CE, 0x00621788, 0x006217E0, 0x006217F2, 0x006218A4, 0x006218CE, 0x006218EE, 0x006208FA, 0x00620932, 
						  0x00620AD8, 0x00620B3A, 0x00620B50, 0x00620B88, 0x00620779, 0x00620C8D, 0x00620CBE, 0x00620D50, 0x00620D5E, 0x00620DCE, 
						  0x006207A0, 0x00620E34, 0x00620E56, 0x00620E6D, 0x00620EB9, 0x00620F04, 0x00620F1C, 0x006207C7, 0x00621150, 0x006211C0, 
						  0x006212BB, 0x006212E3, 0x0062134D, 0x006213B5, 0x00621588, 0x006215F2, 0x00621D04, 0x00621D10, 0x00621D23, 0x00622395, 
						  0x006223A5, 0x006222FB, 0x00622309, 0x00622383, 0x00622421, 0x00622739, 0x00622786, 0x006227BC, 0x006227DD, 0x006227FE, 
						  0x0062281C, 0x00622433, 0x0062283A, 0x0062285B, 0x00622884, 0x006228A2, 0x00622480, 0x00622493, 0x006224A5, 0x006224D3, 
						  0x00622E2B, 0x00622E3F, 0x00622D49, 0x00622D57, 0x00622D67, 0x006232A3, 0x006232C5, 0x00623301, 0x00623353, 0x0062336C, 
						  0x006233D5, 0x00623453, 0x00622F36, 0x00622F91, 0x00622FBC, 0x006236AA, 0x006236BD, 0x00623732, 0x00623745, 0x006238DE, 
						  0x00623910, 0x006237D6, 0x0062387C, 0x00623C1C, 0x00623C32, 0x00623C47, 0x00624509, 0x0062458E, 0x006245EA, 0x006245FE, 
						  0x00624612, 0x00624626, 0x0062463B, 0x0062464C, 0x006246A7, 0x006246CA, 0x0062470A, 0x00624749, 0x00624788, 0x00624857, 
						  0x0062486E, 0x00624883, 0x00624899, 0x006248BE, 0x006248D4, 0x006248F9, 0x0062490F, 0x00624934, 0x0062494A, 0x006249B9, 
						  0x006249D5, 0x00624A02, 0x00624A1E, 0x00624A37, 0x00624C97, 0x00624CDA, 0x00624D0A, 0x00624D52, 0x00624D70, 0x00624E06, 
						  0x00624E58, 0x00624E74, 0x00624E97, 0x00624EB5, 0x00624ED1, 0x00624EE6, 0x00624F10, 0x00624F9F, 0x00624FBD, 0x00624FD9, 
						  0x00624FEE, 0x00625018, 0x006253F7, 0x006253AF, 0x006259A3, 0x006259C3, 0x00625A64, 0x00625A9D, 0x00625B1E, 0x00625B90, 
						  0x00625C5F, 0x00625C88, 0x00625CA8, 0x00625C3F, 0x00625CE8, 0x00625D92, 0x0062654E, 0x00626564, 0x00626579, 0x006267DB, 
						  0x006267F7, 0x00626826, 0x00626708, 0x0062672D, 0x00626A0A, 0x00626A21, 0x00626A9F, 0x00626B26, 0x00626BAD, 0x00626C07, 
						  0x00626C17, 0x0062693C, 0x00626D3B, 0x00626D97, 0x00626DA8, 0x00626DB9, 0x00626DCA, 0x00626DDC, 0x00626DEA, 0x00626952, 
						  0x00626967, 0x006269E2, 0x006269F6, 0x00626F5B, 0x00626E65, 0x00627324, 0x0062734B, 0x00626E9C, 0x00626EAA, 0x00626ED4, 
						  0x00626F3E, 0x006275AB, 0x006275B7, 0x0062760B, 0x00627617, 0x00628D9B, 0x00628DA7, 0x00628DFB, 0x00628E07, 0x00629825, 
						  0x0062983C, 0x0062987E, 0x0062A6C8, 0x0062A704, 0x0062A71D, 0x0062A79D, 0x0062A7D9, 0x0062A89C, 0x0062A99F, 0x0062AA0F, 
						  0x0062A641, 0x0062BE86, 0x0062BE9A, 0x0062BF2A, 0x0062BF42, 0x0062BF64, 0x0062BF74, 0x0062BF93, 0x0062BFAA, 0x0062BFC1, 
						  0x0062BFDB, 0x0062C00C, 0x0062C01B, 0x0062C029, 0x0062C3C1, 0x0062C612, 0x0062C645, 0x0062C675, 0x0062C6C5, 0x0062C74C, 
						  0x0062C780, 0x0062C799, 0x0062C819, 0x0062C855, 0x0062C578, 0x0062C5AB, 0x0062C5DB, 0x0062CAFC, 0x0062CB18, 0x0062CB44, 
						  0x0062CB56, 0x0062CB7B, 0x0062CB8D, 0x0062CD68, 0x0062CDD9, 0x0062CE32, 0x0062CE44, 0x0062CE69, 0x0062CE84, 0x0062CE96, 
						  0x0062CEBB, 0x0062CFC4, 0x0062CFB6, 0x0062E328, 0x0062E398, 0x0062E3AA, 0x0062E3F7, 0x0062E409, 0x0062E27D, 0x0062E904, 
						  0x0062E94D, 0x0062E7A5, 0x0062E7B5, 0x0062E7D8, 0x0062EB78, 0x0062EB84, 0x0062EDB3, 0x0062F0D1, 0x0062F0F1, 0x0062F35A, 
						  0x0062F96C, 0x0062F980, 0x0062F99A, 0x0062FA9E, 0x0062FAAC, 0x0062FA8F, 0x0062FB21, 0x0062FB6E, 0x0062FB80, 0x0062FB8E, 
						  0x0062FD11, 0x0062FD2C, 0x0062FE69, 0x0062FE89, 0x0062FE98, 0x0062FEDE, 0x00630024, 0x0063004F, 0x0062FC09, 0x00630065, 
						  0x0062FC27, 0x0062FC38, 0x0062FC4A, 0x0062FC5A, 0x0062FC87, 0x0062FC98, 0x00630E04, 0x00630E69, 0x00630E80, 0x00630E95, 
						  0x00630EAB, 0x00630ED0, 0x00630EF6, 0x00630F23, 0x00630F3A, 0x00630F4F, 0x00630F65, 0x00631000, 0x00631065, 0x0063107C, 
						  0x0063109E, 0x006310B3, 0x006310C9, 0x006310EE, 0x00631104, 0x0063117F, 0x00631199, 0x006311B3, 0x006311C8, 0x006311DE, 
						  0x00631259, 0x00631273, 0x0063128D, 0x006312A2, 0x006312B8, 0x006312FB, 0x00631317, 0x0063133A, 0x006316B6, 0x00631909, 
						  0x00631920, 0x00631937, 0x00631962, 0x00631983, 0x00631BE1, 0x00631C0B, 0x00631CA7, 0x00631CD1, 0x00631F12, 0x00631F2B, 
						  0x00631FE3, 0x00632126, 0x0063214C, 0x00632186, 0x00632201, 0x00632223, 0x00632238, 0x00632256, 0x00632280, 0x0063229D, 
						  0x006322BB, 0x006322D9, 0x006322F7, 0x00632315, 0x0063232A, 0x00632340, 0x0063235E, 0x0063237C, 0x0063239A, 0x00632455, 
						  0x0063248A, 0x006324F5, 0x00632556, 0x006325C6, 0x0063259F, 0x00632657, 0x0063260F, 0x00633715, 0x006336B1, 0x006336CC, 
						  0x006336D9, 0x00634C1D, 0x00634C29, 0x0063507E, 0x0063508A, 0x00636E9A, 0x00637219, 0x006372EF, 0x0063754C, 0x0063757F, 
						  0x0063A47A, 0x0063A763, 0x0063A779, 0x0063B36A, 0x0063B357, 0x0063B50B, 0x0063B960, 0x0063BD53, 0x0063BE23, 0x0063C3EA, 
						  0x0063CAC8, 0x0063CADE, 0x0063CCC8, 0x0063CCDE, 0x0063D743, 0x0063D759, 0x00640C1E, 0x00640F1E, 0x00641554, 0x0064153C, 
						  0x00641591, 0x0064159A, 0x00641654, 0x0064163C, 0x00641C86, 0x00643136, 0x00643142, 0x00643174, 0x006431EF, 0x006432A5, 
						  0x00643476, 0x006434B6, 0x006436D7, 0x006436FD, 0x0064371B, 0x00643734, 0x00643743, 0x006437E1, 0x006437ED, 0x006437FE, 
						  0x00643824, 0x00643833, 0x0064388D, 0x0064366B, 0x00643CE6, 0x00643D29, 0x00643D4A, 0x00643D58, 0x00643D69, 0x00643A94, 
						  0x006441F7, 0x00644203, 0x006442A4, 0x00644322, 0x0064432E, 0x0064433A, 0x00644388, 0x006443E1, 0x006443FB, 0x006445C7, 
						  0x006445EC, 0x00644637, 0x006446B9, 0x00644716, 0x0064476B, 0x006447C0, 0x00644B75, 0x00644EFA, 0x00644FAA, 0x0064509A, 
						  0x006453B6, 0x00645534, 0x0064554C, 0x00645556, 0x0064556C, 0x00645576, 0x006455A8, 0x006455B2, 0x006455C8, 0x006455D2, 
						  0x006455FE, 0x0064561B, 0x00645625, 0x0064563B, 0x00645645, 0x0064565A, 0x00645664, 0x00645679, 0x00645683, 0x0064569C, 
						  0x006456A6, 0x006456B5, 0x006456BF, 0x006456DD, 0x006456E7, 0x00645725, 0x00645773, 0x0064577D, 0x006457A7, 0x006457DF, 
						  0x006457E9, 0x006457FD, 0x00645807, 0x006454F5, 0x00645519, 0x006459C9, 0x006459E3, 0x006458DA, 0x0064591D, 0x00645930, 
						  0x00645942, 0x00645960, 0x00645980, 0x006459A2, 0x006459B1, 0x00645B27, 0x00645B68, 0x00645B79, 0x00645B92, 0x00645BB5, 
						  0x00645BE1, 0x00645BF1, 0x00645C1E, 0x00645C5C, 0x00645A50, 0x00645A5A, 0x00645A6D, 0x00645A77, 0x00645AA9, 0x00645AB3, 
						  0x00645AD2, 0x00645ADC, 0x00645AF2, 0x00645B03, 0x00645B0E, 0x00645FFF, 0x0064600E, 0x006460D7, 0x006460E1, 0x0064682F, 
						  0x00647551, 0x006475F6, 0x0064769C, 0x00647741, 0x006477A7, 0x00647D62, 0x006480CB, 0x00648B3D, 0x00648FE9, 0x00648FF7, 
						  0x0064900D, 0x0064917A, 0x006491C3, 0x006491CF, 0x006491E6, 0x006491FB, 0x00649400, 0x0064941C, 0x00649430, 0x0064916E, 
						  0x00649D35, 0x00649D48, 0x00649D92, 0x00649DA1, 0x00649EC4, 0x0064A022, 0x00649E32, 0x0064A5C0, 0x0064A5F5, 0x0064A61E, 
						  0x0064A645, 0x00649EA7, 0x0064A84D, 0x0064A860, 0x0064AA58, 0x0064ACEE, 0x0064AD5F, 0x0064AD76, 0x0064AD85, 0x0064C16A, 
						  0x0064C24A, 0x0064CC2D, 0x0064D36F, 0x0064D848, 0x0064F65F, 0x0065297A, 0x00653A5E, 0x006539AD, 0x00653CA9, 0x00653D0A, 
						  0x00653BB7, 0x00653DB2, 0x00653DCE, 0x00653DE9, 0x00653BCF, 0x00653BDF, 0x00653BF2, 0x00653C1A, 0x00653C34, 0x00653C4E, 
						  0x00653C68, 0x00653C8B, 0x00654079, 0x00654447, 0x006545E4, 0x00654620, 0x0065468D, 0x006547A2, 0x006547E7, 0x0065487C, 
						  0x00654992, 0x006549D7, 0x00654A6C, 0x00654B98, 0x00654C12, 0x00654C36, 0x00654C9F, 0x00654CCB, 0x00654D9B, 0x00654DA7, 
						  0x00654DFB, 0x00654E07, 0x00654E5B, 0x00654E67, 0x00654EBB, 0x00654EC7, 0x00654F1B, 0x00654F27, 0x00654F7F, 0x00654F8B, 
						  0x0065503B, 0x0065504B, 0x006560B9, 0x00656110, 0x00656119, 0x00656133, 0x0065613C, 0x006562E2, 0x006562EE, 0x00656300, 
						  0x006563D6, 0x00656422, 0x00656440, 0x006565E2, 0x006565F1, 0x00656604, 0x00656662, 0x006566FB, 0x0065670B, 0x00656762, 
						  0x00656770, 0x006567C3, 0x006567E8, 0x006567FB, 0x00656836, 0x00656845, 0x00656868, 0x00656571, 0x00656584, 0x00657B71, 
						  0x00657C24, 0x00657ED0, 0x00657F48, 0x0065855B, 0x006585E8, 0x006585F4, 0x00658641, 0x0065870F, 0x00658AC8, 0x00658B16, 
						  0x006590A7, 0x006590B7, 0x006590CA, 0x006590DC, 0x006590E7, 0x0065910F, 0x00659143, 0x0065914E, 0x0065A8C3, 0x0065AC73, 
						  0x0065B442, 0x0065B489, 0x0065B495, 0x0065B4A8, 0x0065B4BD, 0x0065B563, 0x0065B56F, 0x0065B580, 0x0065B5B3, 0x0065B5C6, 
						  0x0065B5E6, 0x0065B679, 0x0065B685, 0x0065BA31, 0x0065BACF, 0x0065BB1E, 0x0065BB2A, 0x0065BB3D, 0x0065BB52, 0x0065BCD3, 
						  0x0065BCDF, 0x0065C081, 0x0065C095, 0x0065C0A9, 0x0065C0B4, 0x0065C75B, 0x0065CE5F, 0x0065CE79, 0x0065CEB7, 0x0065CEC3, 
						  0x0065CED6, 0x0065CEEB, 0x0065CF63, 0x0065CF7D, 0x0065CFBB, 0x0065CFC7, 0x0065CFDA, 0x0065CFFA, 0x0065D0A3, 0x0065D0AF, 
						  0x0065D10C, 0x0065D118, 0x0065D169, 0x0065FEC7, 0x0065FF47, 0x0065FF5B, 0x0065FFE4, 0x0065FFF2, 0x00660084, 0x00660092, 
						  0x00662E2C, 0x006632E5, 0x00663375, 0x006643AB, 0x00664219, 0x0066451C, 0x00664706, 0x00664714, 0x00664421, 0x00664808, 
						  0x006644B9, 0x006644D5, 0x00664B27, 0x00664E7D, 0x00664E94, 0x00664F3A, 0x00664DC4, 0x0066525C, 0x00665DB1, 0x00665DE5, 
						  0x00665E1D, 0x00665E3A, 0x00665E5A, 0x00665ED3, 0x00665EED, 0x00665F05, 0x00665F21, 0x00665F55, 0x00665F77, 0x00665F98, 
						  0x00665FC1, 0x00665FDD, 0x00666003, 0x0066606A, 0x00665D69, 0x00665D9F, 0x0066715B, 0x00666251, 0x0066716B, 0x0066717B, 
						  0x006671C6, 0x00667277, 0x0066729E, 0x006672BC, 0x0066626B, 0x0066730A, 0x0066731A, 0x006673DC, 0x006673EC, 0x006673FC, 
						  0x0066743E, 0x00667454, 0x0066746B, 0x00667482, 0x006674F2, 0x006675B4, 0x006675F6, 0x00667604, 0x00667624, 0x00667683, 
						  0x0066769D, 0x006676B4, 0x006676D3, 0x0066774A, 0x0066775B, 0x00667764, 0x006677DC, 0x006677FA, 0x00667837, 0x00667875, 
						  0x0066789A, 0x006678FB, 0x00667990, 0x006662D5, 0x00667A5B, 0x00667AB7, 0x00667B01, 0x00667B0A, 0x00667B28, 0x00667B6D, 
						  0x00667B8B, 0x00667BC8, 0x00667C06, 0x00667C16, 0x00667C86, 0x00667CDF, 0x00666309, 0x00667D78, 0x00667DEA, 0x00667E01, 
						  0x00667EBC, 0x00667F2E, 0x00667F45, 0x00666395, 0x006663C7, 0x006663E6, 0x00666434, 0x00666451, 0x006664D8, 0x006665A9, 
						  0x00666683, 0x00666693, 0x006667AB, 0x006667D3, 0x006668F4, 0x00666966, 0x0066697D, 0x006669D6, 0x006669E2, 0x00666A92, 
						  0x00666B4A, 0x00666BD2, 0x00666D34, 0x00666D44, 0x00666D88, 0x00666DB0, 0x00666219, 0x00666225, 0x00666F27, 0x00666F3E, 
						  0x00666F55, 0x00666F86, 0x00666F96, 0x00666FAD, 0x0066623B, 0x00667057, 0x00667067, 0x0066709A, 0x006670DB, 0x006670F2, 
						  0x0066833B, 0x006683AC, 0x006683B8, 0x0066868B, 0x00668D98, 0x00668E78, 0x00668E84, 0x00668D29, 0x00668F89, 0x00668F97, 
						  0x00668FB5, 0x00668FC3, 0x006694F1, 0x00669501, 0x0066950D, 0x00669672, 0x006696AE, 0x006696D4, 0x006696F6, 0x00669C11, 
						  0x00669C20, 0x00669C30, 0x00669C80, 0x00669CBD, 0x00669CEE, 0x00669D14, 0x00669E08, 0x00669E66, 0x00669ECC, 0x00669FC7, 
						  0x0066A00D, 0x0066A01C, 0x0066A032, 0x0066A0AC, 0x0066A0C3, 0x0066A0F9, 0x0066A127, 0x0066A142, 0x0066A1C7, 0x0066A1D7, 
						  0x0066A22D, 0x0066A23C, 0x0066A271, 0x0066992F, 0x0066A2B0, 0x0066A2F7, 0x0066A325, 0x0066993F, 0x00669989, 0x0066A505, 
						  0x0066A529, 0x0066A535, 0x0066A562, 0x0066A56E, 0x0066A421, 0x0066A431, 0x0066A44B, 0x0066A492, 0x0066A4A0, 0x0066A4B8, 
						  0x0066A63F, 0x0066A695, 0x0066A92B, 0x0066A937, 0x0066A960, 0x0066AEFB, 0x0066AF07, 0x0066AF38, 0x0066AE21, 0x0066AE2D, 
						  0x0066B26B, 0x0066B06D, 0x0066B0D3, 0x0066B3BD, 0x0066B414, 0x0066B5AC, 0x0066BE46, 0x0066BE57, 0x0066BEC0, 0x0066BEDC, 
						  0x0066BEF8, 0x0066BF4C, 0x0066BFC8, 0x0066C005, 0x0066C168, 0x0066C200, 0x0066C22A, 0x0066C628, 0x0066C642, 0x0066CADF, 
						  0x0066CB14, 0x0066CB24, 0x0066CBB3, 0x0066CCB4, 0x0066CCC0, 0x0066D06C, 0x0066D083, 0x0066D0EF, 0x0066D112, 0x0066D13D, 
						  0x0066D16D, 0x0066D1AE, 0x0066D20D, 0x0066D279, 0x0066D2FF, 0x0066D4A5, 0x0066D4BF, 0x0066D5DC, 0x0066D5F3, 0x0066D606, 
						  0x0066D61F, 0x0066D65B, 0x0066D6C7, 0x0066D74D, 0x0066D865, 0x0066DC7B, 0x0066DC8C, 0x0066DC9C, 0x0066DCB2, 0x0066DCF9, 
						  0x0066DD02, 0x0066DD18, 0x0066E476, 0x0066E49C, 0x0066E805, 0x0066EED1, 0x0066EF85, 0x0066F4EA, 0x0066F975, 0x0066F989, 
						  0x0066F9AD, 0x0066FAD1, 0x0066FB77, 0x0066FB8E, 0x0066FBBB, 0x0066FBD5, 0x0066FBE9, 0x0066FBF5, 0x0066FC1F, 0x0066FC36, 
						  0x0066FC63, 0x0066FCAF, 0x0066FCCD, 0x0066FD6E, 0x0066FD92, 0x0066FDA6, 0x0066FE75, 0x0066FEC9, 0x0066FEED, 0x0066FF14, 
						  0x0066FF36, 0x00670365, 0x00670569, 0x00670572, 0x006704A9, 0x006704C6, 0x006704D2, 0x006704F3, 0x006707AE, 0x006706C8, 
						  0x006706D9, 0x006706E5, 0x00670706, 0x00670AED, 0x00670B05, 0x00670B5C, 0x00670CF4, 0x00670D6E, 0x00670D98, 0x00670DB4, 
						  0x00670DDB, 0x00670E08, 0x00670E19, 0x00670E28, 0x00670E34, 0x00670E72, 0x00670F06, 0x00670F7A, 0x00670FAB, 0x00670FD2, 
						  0x00670FE1, 0x006710BE, 0x006710EB, 0x00671107, 0x00671134, 0x00671155, 0x0067117A, 0x00671197, 0x006711A6, 0x006711CD, 
						  0x006711DC, 0x006714AE, 0x006714BF, 0x006714CB, 0x006714EC, 0x00671510, 0x00671553, 0x00671695, 0x00671ACC, 0x00672302, 
						  0x006722E0, 0x006722EC, 0x006723A0, 0x006723BB, 0x006723EB, 0x006723FD, 0x00672680, 0x006726C8, 0x00672845, 0x00672856, 
						  0x00672869, 0x00672879, 0x0067289C, 0x006725B4, 0x00672A52, 0x00672A81, 0x00672C19, 0x00672CE4, 0x00672D2D, 0x00672D3D, 
						  0x00672D4D, 0x00672D76, 0x00672AF4, 0x00672B4D, 0x00672B95, 0x006732C4, 0x00673315, 0x0067351B, 0x0067355E, 0x0067366F, 
						  0x006736C0, 0x0067384B, 0x0067388E, 0x006749F6, 0x00674A32, 0x00674A47, 0x00674A8B, 0x00674B91, 0x00674BC5, 0x00674D48, 
						  0x00674E1C, 0x00674E42, 0x00674E7B, 0x00674EBA, 0x00675032, 0x00675042, 0x006750BD, 0x006750E3, 0x006750FE, 0x0067513D, 
						  0x00673B6C, 0x006751D5, 0x0067543B, 0x0067545C, 0x00675507, 0x00675538, 0x0067565D, 0x00675694, 0x00675761, 0x0067577B, 
						  0x006757A0, 0x006757BC, 0x006757DC, 0x006757FF, 0x00675846, 0x00673C11, 0x00673C1D, 0x00673C30, 0x00673C46, 0x00673C5E, 
						  0x00673CB0, 0x00673CEF, 0x00673D0E, 0x00673D24, 0x00673D30, 0x00673D77, 0x00673A2B, 0x00673DD7, 0x00673E20, 0x00673E38, 
						  0x00673E54, 0x00673E6C, 0x00673EA8, 0x00673EB7, 0x00673F80, 0x00673F91, 0x00673FA1, 0x00673FE4, 0x00674080, 0x00674094, 
						  0x006740A0, 0x0067415C, 0x006741F5, 0x00674282, 0x006742B0, 0x006742BC, 0x00674310, 0x0067436E, 0x006743A5, 0x00674404, 
						  0x00674418, 0x0067442E, 0x00674443, 0x006744A0, 0x006744CD, 0x0067458B, 0x006745C2, 0x00674615, 0x00674684, 0x006746E0, 
						  0x006747A1, 0x006747D0, 0x0067486C, 0x0067492A, 0x0067493C, 0x00675D8B, 0x00675DFD, 0x00675E2B, 0x00675E86, 0x00675EFD, 
						  0x00675F5D, 0x00675C81, 0x00675F6D, 0x00675FD2, 0x00675FF6, 0x00676005, 0x00676015, 0x00676026, 0x00675CCA, 0x00675CF2, 
						  0x00675D0C, 0x00676248, 0x00676262, 0x0067626E, 0x00676292, 0x0067620C, 0x00676416, 0x0067636A, 0x006763C0, 0x00676E56, 
						  0x00677381, 0x0067738D, 0x006773A5, 0x00677528, 0x0067753C, 0x0067755B, 0x00677573, 0x006775A5, 0x006775BB, 0x0067767E, 
						  0x006776B9, 0x006777FC, 0x00677B3A, 0x00677C6D, 0x00677CE5, 0x00677D6A, 0x00677D4C, 0x0067853C, 0x00678721, 0x00678755, 
						  0x00678A26, 0x00678BCF, 0x00678C03, 0x00678C3D, 0x00678CB5, 0x00679291, 0x00679309, 0x00679315, 0x0067925C, 0x00679285, 
						  0x00679535, 0x00679596, 0x00679F15, 0x0067A52A, 0x0067A697, 0x0067A6B5, 0x0067A6EC, 0x0067A597, 0x0067A704, 0x0067A751, 
						  0x0067A76B, 0x0067A5AF, 0x0067A5EF, 0x0067A617, 0x0067A631, 0x0067A64B, 0x0067A665, 0x0067A67F, 0x0067AC90, 0x0067AE1B, 
						  0x0067AB67, 0x0067B243, 0x0067B2C6, 0x0067AFFA, 0x0067B368, 0x0067B4DC, 0x0067B91D, 0x0067BA3C, 0x0067BA5C, 0x0067BBAA, 
						  0x0067BBE6, 0x0067BC19, 0x0067BC44, 0x0067BC88, 0x0067BCD2, 0x0067BB1F, 0x0067BF01, 0x0067BF1C, 0x0067BF8C, 0x0067C056, 
						  0x0067C291, 0x0067C3FE, 0x0067C40E, 0x0067C48D, 0x0067C812, 0x0067C8C5, 0x0067C951, 0x0067C961, 0x0067C971, 0x0067C99A, 
						  0x0067C9A9, 0x0067CA03, 0x0067CA1C, 0x0067CA61, 0x0067CA7A, 0x0067CAE6, 0x0067CB0B, 0x0067CB94, 0x0067CC1B, 0x0067CC7E, 
						  0x0067CD1D, 0x0067CD29, 0x0067CD5C, 0x0067CF56, 0x0067CF66, 0x0067CF92, 0x0067CFD6, 0x0067D029, 0x0067CE70, 0x0067CEB1, 
						  0x0067D194, 0x0067D1A0, 0x0067D30D, 0x0067D32E, 0x0067D38C, 0x0067D3BD, 0x0067D449, 0x0067D234, 0x0067D76E, 0x0067D77A, 
						  0x0067D649, 0x0067D661, 0x0067D9C1, 0x0067DA41, 0x0067DA51, 0x0067DA61, 0x0067DA8A, 0x0067DAB0, 0x0067DABF, 0x0067DAF8, 
						  0x0067DB11, 0x0067DB47, 0x0067DB60, 0x0067D883, 0x0067D8D4, 0x0067D8E0, 0x0067D912, 0x0067DD2B, 0x0067DDED, 0x0067DE2C, 
						  0x0067DE99, 0x0067DF36, 0x0067DC5B, 0x0067DC98, 0x0067E132, 0x0067E15A, 0x0067E172, 0x0067E045, 0x0067E070, 0x0067E541, 
						  0x0067E54D, 0x0067E5DC, 0x0067EAEA, 0x0067EB28, 0x0067EB34, 0x0067EE51, 0x0067EEC7, 0x0067EF18, 0x0067F036, 0x0067F076, 
						  0x0067F651, 0x0067F675, 0x0067F694, 0x0067FB6A, 0x0067FB82, 0x0067FD51, 0x0067FCDA, 0x0067FCF8, 0x0067FD1C, 0x0067FD45, 
						  0x0067FF6B, 0x00680199, 0x006801B3, 0x00680248, 0x0068025A, 0x006802CE, 0x006802E9, 0x00680301, 0x0068032A, 0x006806B0, 
						  0x006806BC, 0x006806D4, 0x006807F2, 0x00680802, 0x0068082C, 0x00680844, 0x006808A9, 0x006808F4, 0x00680967, 0x006809A5, 
						  0x006809FE, 0x00680A4B, 0x00680CF9, 0x00680D17, 0x00680DED, 0x00680E4B, 0x00680E57, 0x006814B6, 0x006814C8, 0x00681492, 
						  0x0068149E, 0x00681875, 0x0068188C, 0x006818AF, 0x006818C2, 0x006818CE, 0x00681912, 0x00681933, 0x0068178F, 0x00681973, 
						  0x00681A03, 0x00681A1C, 0x00681A3A, 0x0068179F, 0x00681AEE, 0x00681B18, 0x00681B24, 0x006817B1, 0x00681851, 0x00681E47, 
						  0x00681E8C, 0x00682382, 0x006823B7, 0x006823D6, 0x006822BA, 0x00682318, 0x00682336, 0x0068235D, 0x00682672, 0x006825E7, 
						  0x0068261D, 0x00682629, 0x00682857, 0x00682865, 0x0068287F, 0x00682B88, 0x00682BBE, 0x00682BCA, 0x00682F5D, 0x00682F7F, 
						  0x00682FE4, 0x00682FF0, 0x0068302F, 0x0068303B, 0x006830FF, 0x0068310B, 0x00683267, 0x0068327C, 0x0068328C, 0x0068329C, 
						  0x00683331, 0x006836C3, 0x00682E2A, 0x0068377F, 0x0068378F, 0x0068379F, 0x006837C9, 0x00683883, 0x00683ABF, 0x00683E5C, 
						  0x00683E6C, 0x00683EC4, 0x00683EF6, 0x00683F19, 0x006840DF, 0x0068419C, 0x006848BA, 0x006848DF, 0x00684A81, 0x00684A8D, 
						  0x00684AA0, 0x00684AEF, 0x006848AE, 0x0068528F, 0x0068537E, 0x00685482, 0x006854D0, 0x006856AB, 0x00685739, 0x006850D9, 
						  0x006858FF, 0x0068593B, 0x00685A27, 0x00685A5B, 0x00685C45, 0x00685CE1, 0x00685E55, 0x00685ED8, 0x00685F12, 0x00685F27, 
						  0x006862E7, 0x0068637C, 0x00686445, 0x00686BAA, 0x00686B22, 0x00686B32, 0x00686B53, 0x00686B9A, 0x00686D22, 0x00686D2E, 
						  0x00686CB6, 0x00686CC2, 0x00686E84, 0x00686E96, 0x00686EAC, 0x00686F35, 0x00686F6A, 0x00686FC9, 0x00686E38, 0x00686E48, 
						  0x00686E68, 0x00687305, 0x00687321, 0x00687333, 0x006873BC, 0x006873F1, 0x0068743D, 0x006872D5, 0x006872E5, 0x006876A6, 
						  0x0068778F, 0x006877BB, 0x006877CB, 0x00687870, 0x00687635, 0x00687672, 0x00687AAB, 0x00687B18, 0x00687B3D, 0x00687B51, 
						  0x00687BDF, 0x00687C17, 0x00687C85, 0x006879CB, 0x006879D7, 0x00687A14, 0x00687E61, 0x00687E71, 0x00687EA9, 0x00687F0C, 
						  0x00687F73, 0x00687F8A, 0x00687FA0, 0x00687FB1, 0x00687FC2, 0x00687FD1, 0x00688051, 0x00688061, 0x00688071, 0x0068809A, 
						  0x006880AE, 0x006880F9, 0x00687D75, 0x00687D81, 0x006891DB, 0x006891E7, 0x00689220, 0x00689478, 0x006894AA, 0x006894C7, 
						  0x00689621, 0x0068962D, 0x00689852, 0x00689872, 0x006898E1, 0x00689EBF, 0x00689ECB, 0x0068A3CE, 0x0068A87A, 0x0068B050, 
						  0x0068B083, 0x0068B6C7, 0x0068BA24, 0x0068B80F, 0x0068B87C, 0x0068BE23, 0x0068BC14, 0x0068BC86, 0x0068C16E, 0x0068C210, 
						  0x0068BF52, 0x0068BFB4, 0x0068C567, 0x0068C75B, 0x0068CC5D, 0x0068CA70, 0x0068CAD7, 0x0068D340, 0x0068D34C, 0x0068D35F, 
						  0x0068D5BE, 0x0068D5CE, 0x0068D5DE, 0x0068D607, 0x0068D616, 0x0068D64F, 0x0068D529, 0x0068D539, 0x0068D6D1, 0x0068D6F9, 
						  0x0068D90C, 0x0068D99D, 0x0068D7D1, 0x0068D827, 0x0068DC26, 0x0068DC36, 0x0068DC46, 0x0068DC6F, 0x0068DC7E, 0x0068DCB7, 
						  0x0068DB5B, 0x0068DF7C, 0x0068F86B, 0x0068F8C2, 0x0068F8FC, 0x0068F925, 0x0068F931, 0x0068F978, 0x0068E79A, 0x0068E7A6, 
						  0x0068E7D1, 0x0068E863, 0x0068E86F, 0x0068E89A, 0x0068E944, 0x0068EA39, 0x0068EA7C, 0x0068EFFF, 0x0068F02E, 0x0068F06F, 
						  0x0068F0A8, 0x0068F194, 0x0068F1C5, 0x0068F3C6, 0x0068F3DD, 0x0068F408, 0x0068FCAB, 0x0068FD2C, 0x0068FE25, 0x0068FE86, 
						  0x0069071B, 0x0069187B, 0x006919A5, 0x006919D3, 0x00691A0E, 0x00691A1A, 0x00691A69, 0x00691B7B, 0x00691BAC, 0x00691DB7, 
						  0x00691F39, 0x00691F45, 0x00692093, 0x006920B8, 0x006920D1, 0x00692128, 0x0069213C, 0x00692157, 0x0069218A, 0x006921B3, 
						  0x00692209, 0x0069223C, 0x0069231B, 0x006924A7, 0x006924B0, 0x006924D5, 0x00692521, 0x00692545, 0x00692662, 0x00692690, 
						  0x00690A6B, 0x00690A77, 0x00690AAE, 0x00690ACD, 0x00690BB5, 0x00690BC4, 0x00690E75, 0x00690EDD, 0x00690F00, 0x00690F62, 
						  0x006911A4, 0x006912CC, 0x00691781, 0x0069299C, 0x00692A95, 0x00692AF6, 0x00693BE7, 0x00693C08, 0x00693CE0, 0x00693EA0, 
						  0x00693EC1, 0x00693FCF, 0x006940E1, 0x006940FE, 0x0069411D, 0x00694147, 0x0069416B, 0x00694188, 0x006941A6, 0x006941C4, 
						  0x006941D8, 0x0069398D, 0x00694483, 0x006944A1, 0x00694545, 0x006972A3, 0x00698813, 0x0069881F, 0x0069884A, 0x0069887B, 
						  0x00698887, 0x006989F0, 0x006989FC, 0x00698A27, 0x00698A58, 0x00698A64, 0x00698C4B, 0x00698C57, 0x00698C8E, 0x00698CC0, 
						  0x00698CCC, 0x00698E5C, 0x00698E68, 0x00699120, 0x00699279, 0x00699285, 0x006992C3, 0x006992CF, 0x00699466, 0x00699472, 
						  0x006994B0, 0x006994BC, 0x006996CB, 0x006996D7, 0x00699721, 0x0069972D, 0x00699966, 0x00699972, 0x006998B2, 0x006998BE, 
						  0x0069A61A, 0x0069A639, 0x0069A64B, 0x0069A729, 0x0069A749, 0x0069A7B5, 0x0069A7EE, 0x0069A83C, 0x0069A858, 0x0069A86F, 
						  0x0069A90E, 0x0069A91A, 0x0069A526, 0x0069A54C, 0x0069A564, 0x0069A5C0, 0x0069A5D3, 0x0069AAC7, 0x0069AB68, 0x0069A9CE, 
						  0x0069A9EE, 0x0069AA00, 0x0069ACD7, 0x0069AD72, 0x0069ABDE, 0x0069ABFE, 0x0069AC10, 0x0069AF69, 0x0069AF75, 0x0069B283, 
						  0x0069B28F, 0x0069B2A2, 0x0069AED3, 0x0069B847, 0x0069B853, 0x0069B869, 0x0069B894, 0x0069B921, 0x0069B92F, 0x0069B945, 
						  0x0069BA2F, 0x0069BA3B, 0x0069BA8E, 0x0069BAD2, 0x0069BAEA, 0x0069B76C, 0x0069BB4F, 0x0069BB7A, 0x0069B7C3, 0x0069B7CF, 
						  0x0069B7E5, 0x0069B810, 0x0069C005, 0x0069C01C, 0x0069C033, 0x0069C0B3, 0x0069BF23, 0x0069BF33, 0x0069BF55, 0x0069BF6C, 
						  0x0069C63C, 0x0069C648, 0x0069CD1C, 0x0069CE1F, 0x0069CE2B, 0x0069E5F9, 0x0069EAA3, 0x0069EAAF, 0x0069F5F8, 0x006A17BA, 
						  0x006A180A, 0x006A1FF2, 0x006A20A7, 0x006A2200, 0x006A227B, 0x006A22C9, 0x006A2318, 0x006A239F, 0x006A23D1, 0x006A241B, 
						  0x006A1F34, 0x006A1F8D, 0x006A1FA5, 0x006A260A, 0x006A2616, 0x006A265B, 0x006A2690, 0x006A26A1, 0x006A26D6, 0x006A2730, 
						  0x006A2791, 0x006A2571, 0x006A2A96, 0x006A2AA6, 0x006A2AFF, 0x006A2B0F, 0x006A2E53, 0x006A2EB5, 0x006A2EC1, 0x006A2F56, 
						  0x006A2F93, 0x006A3011, 0x006A3A1A, 0x006A3850, 0x006A385C, 0x006A389F, 0x006A38AB, 0x006A3D15, 0x006A40D6, 0x006A4130, 
						  0x006A414E, 0x006A43D6, 0x006A47D6, 0x006A4B94, 0x006A4989, 0x006A4995, 0x006A49A8, 0x006A49E5, 0x006A49F1, 0x006A4D5A, 
						  0x006A50D6, 0x006A516A, 0x006A51CB, 0x006A51F7, 0x006A5257, 0x006A5270, 0x006A51EC, 0x006A538E, 0x006A5696, 0x006A6055, 
						  0x006A6068, 0x006A6096, 0x006A610D, 0x006A6155, 0x006A61E3, 0x006A6243, 0x006A62D1, 0x006A63B5, 0x006A6402, 0x006A64F4, 
						  0x006A66A7, 0x006A6009, 0x006A6BEB, 0x006A7AE8, 0x006A7B63, 0x006A7BE3, 0x006A8281, 0x006A8297, 0x006A82B0, 0x006A82C4, 
						  0x006A82FC, 0x006A8314, 0x006A832E, 0x006A81C0, 0x006A81F9, 0x006A821F, 0x006A8261, 0x006A8398, 0x006A83A7, 0x006A83BD, 
						  0x006A83D2, 0x006A83EE, 0x006A880D, 0x006A9F5A, 0x006A9F6E, 0x006A9F9A, 0x006A9FF8, 0x006AA04E, 0x006AA067, 0x006A9054, 
						  0x006AA084, 0x006AA0A3, 0x006AA0C0, 0x006AA0EC, 0x006AA0FD, 0x006AA12B, 0x006AA13F, 0x006AA18A, 0x006AA1A8, 0x006AA1C6, 
						  0x006AA1E4, 0x006AA202, 0x006AA220, 0x006AA23E, 0x006AA25C, 0x006AA2F5, 0x006AA35B, 0x006AA4C5, 0x006AA510, 0x006AA546, 
						  0x006AA647, 0x006A90B2, 0x006AA6B6, 0x006AA6C7, 0x006AA718, 0x006AA768, 0x006AA788, 0x006AA79B, 0x006AA7B9, 0x006AA7CC, 
						  0x006AA928, 0x006A8F5A, 0x006AA975, 0x006AA9CC, 0x006AAA8D, 0x006A913D, 0x006A9163, 0x006A9183, 0x006A91A5, 0x006A91C5, 
						  0x006A91E5, 0x006A93B8, 0x006A94A5, 0x006A94B1, 0x006A8FB2, 0x006A9747, 0x006A9766, 0x006A9782, 0x006A97A5, 0x006A97B8, 
						  0x006A97D6, 0x006A9805, 0x006A9820, 0x006A9842, 0x006A98E2, 0x006A9917, 0x006A9946, 0x006A99D2, 0x006A9B01, 0x006A9B24, 
						  0x006A9B44, 0x006A9CD4, 0x006A9DBF, 0x006A9DDD, 0x006A9DF7, 0x006A9E5F, 0x006A9EFB, 0x006AACCF, 0x006AC05A, 0x006AC07B, 
						  0x006AC099, 0x006AC0AA, 0x006AC0F1, 0x006AC102, 0x006AC113, 0x006AC4D7, 0x006AC524, 0x006AAD57, 0x006AABDE, 0x006AB20B, 
						  0x006AAC33, 0x006AB557, 0x006ACD87, 0x006ACDA8, 0x006ACDC9, 0x006ACDED, 0x006ACE0E, 0x006ACE2F, 0x006ACE91, 0x006AD0DC, 
						  0x006AD01F, 0x006AD03A, 0x006AD0B7, 0x006ACFDF, 0x006AD181, 0x006AD195, 0x006AD1AC, 0x006AD1BB, 0x006AD1D1, 0x006AD1E6, 
						  0x006AD3EE, 0x006AD401, 0x006AD429, 0x006AD44D, 0x006AD4B9, 0x006AD4C9, 0x006AD4E5, 0x006AD2D5, 0x006AD506, 0x006AD54F, 
						  0x006AD2F8, 0x006AD30B, 0x006AD33F, 0x006AD34E, 0x006AD365, 0x006AD37B, 0x006AD390, 0x006AD6AC, 0x006AD6BB, 0x006AD6C9, 
						  0x006AD6E5, 0x006AD6FB, 0x006AD722, 0x006AD738, 0x006AD74D, 0x006ADB7E, 0x006ADB87, 0x006ADBB2, 0x006ADBC4, 0x006ADFCA, 
						  0x006ADF3D, 0x006ADF4C, 0x006ADF5C, 0x006AE117, 0x006AE149, 0x006AE166, 0x006AE17A, 0x006AE1AF, 0x006AE0FF, 0x006AE364, 
						  0x006AE381, 0x006AE395, 0x006AE3D0, 0x006AE404, 0x006AE428, 0x006AE47C, 0x006AE284, 0x006AE4C2, 0x006AE4E1, 0x006AE503, 
						  0x006AE52A, 0x006AE568, 0x006AE577, 0x006AE594, 0x006AE5AA, 0x006AE5CF, 0x006AE5E9, 0x006AE600, 0x006AE65B, 0x006AE2C9, 
						  0x006AE6D3, 0x006AE6E6, 0x006AE6FF, 0x006AE718, 0x006AE72A, 0x006AE744, 0x006AE75D, 0x006AE83E, 0x006AE854, 0x006AE869, 
						  0x006AE885, 0x006AE894, 0x006AE82F, 0x006AE900, 0x006AE90F, 0x006AE925, 0x006AE93A, 0x006AEAD8, 0x006AEAE7, 0x006AEB0B, 
						  0x006AEB1A, 0x006AEB34, 0x006AEB51, 0x006AEB67, 0x006AEB80, 0x006AEE60, 0x006AEE82, 0x006AF594, 0x006AF5B9, 0x006AF5D6, 
						  0x006AF5EC, 0x006AF601, 0x006AF6B0, 0x006AF8AB, 0x006B01D9, 0x006B098C, 0x006B09FD, 0x006B0A45, 0x006B08A5, 0x006B0AF2, 
						  0x006B0B4F, 0x006B0B7E, 0x006B0B95, 0x006B0BA8, 0x006B0BBD, 0x006B0BD0, 0x006B0BE5, 0x006B0BFB, 0x006B0C25, 0x006B08C5, 
						  0x006B08E3, 0x006B0940, 0x006B0CED, 0x006B0D54, 0x006B0D6C, 0x006B0D84, 0x006B0D94, 0x006B0F5A, 0x006B0F39, 0x006B1594, 
						  0x006B159F, 0x006B1924, 0x006B192F, 0x006B1BD2, 0x006B25B4, 0x006B2632, 0x006B24B9, 0x006B2536, 0x006B2821, 0x006B26F2, 
						  0x006B2708, 0x006B2725, 0x006B273F, 0x006B27AB, 0x006B27BF, 0x006B2AE0, 0x006B2AEC, 0x006B2B0B, 0x006B2CED, 0x006B2F72, 
						  0x006B30AE, 0x006B30C4, 0x006B30D9, 0x006B309F, 0x006B3223, 0x006B326A, 0x006B3283, 0x006B32B3, 0x006B32DB, 0x006B324E, 
						  0x006B3308, 0x006B3884, 0x006B38E8, 0x006B3992, 0x006B39AD, 0x006B3A28, 0x006B3AB8, 0x006B3BF5, 0x006B3C8B, 0x006B40A8, 
						  0x006B412D, 0x006B4150, 0x006B4168, 0x006B4182, 0x006B4193, 0x006B41A5, 0x006B41B4, 0x006B41C3, 0x006B4247, 0x006B4298, 
						  0x006B422F, 0x006B4330, 0x006B438D, 0x006B4548, 0x006B457F, 0x006B45AE, 0x006B45BA, 0x006B45DA, 0x006B45F6, 0x006B4612, 
						  0x006B4628, 0x006B465E, 0x006B442F, 0x006B4448, 0x006B4470, 0x006B449D, 0x006B44AF, 0x006B47E0, 0x006B4816, 0x006B4758, 
						  0x006B4776, 0x006B4798, 0x006B47BC, 0x006B48B0, 0x006B48C8, 0x006B48E3, 0x006B4972, 0x006B498E, 0x006B49E9, 0x006B49FC, 
						  0x006B495F, 0x006B4A76, 0x006B4A85, 0x006B4AA9, 0x006B4C28, 0x006B4BF7, 0x006B4C6A, 0x006B4C7A, 0x006B4C94, 0x006B4CA4, 
						  0x006B4CE3, 0x006B4CFB, 0x006B4DAA, 0x006B4FF2, 0x006B5014, 0x006B50A9, 0x006B50BC, 0x006B51AC, 0x006B519D, 0x006B5BA6, 
						  0x006B5BB2, 0x006B5F79, 0x006B5FA4, 0x006B62FA, 0x006B631A, 0x006B632F, 0x006B6374, 0x006B639C, 0x006B6212, 0x006B61DA, 
						  0x006B62C5, 0x006B657E, 0x006B65A5, 0x006B65C0, 0x006B65D5, 0x006B65EA, 0x006B651E, 0x006B66B3, 0x006B66C7, 0x006B66DE, 
						  0x006B66F5, 0x006B670C, 0x006B6723, 0x006B673A, 0x006B6756, 0x006B67D2, 0x006B82EE, 0x006B830C, 0x006B8379, 0x006B83FD, 
						  0x006B842C, 0x006B8499, 0x006B70BA, 0x006B70D4, 0x006B71C7, 0x006B888C, 0x006B897C, 0x006B8A69, 0x006B879F, 0x006BA7A2, 
						  0x006BA824, 0x006BB6E5, 0x006BC167, 0x006BC78D, 0x006BC7C4, 0x006BC85F, 0x006BC8A8, 0x006BC6B1, 0x006BCB09, 0x006BCCB3, 
						  0x006BCE51, 0x006BD1AF, 0x006BD242, 0x006BD2ED, 0x006BD31E, 0x006BD3EE, 0x006BD5D1, 0x006BD5F0, 0x006BD5F9, 0x006BD621, 
						  0x006BD642, 0x006BD67A, 0x006BD6A6, 0x006BD6ED, 0x006BD70A, 0x006BD71C, 0x006BD784, 0x006BD7B5, 0x006BD7BE, 0x006BD847, 
						  0x006BD865, 0x006BD8D4, 0x006BD8FD, 0x006BD921, 0x006BD950, 0x006BD9BF, 0x006BD9E8, 0x006BDA34, 0x006BDA65, 0x006BDAB1, 
						  0x006BDB36, 0x006BDBC1, 0x006BDC1C, 0x006BDC3E, 0x006BDD06, 0x006BDD8B, 0x006BDE16, 0x006BDE3F, 0x006BDEB1, 0x006BE3FF, 
						  0x006BE296, 0x006BF49A, 0x006BF4A6, 0x006BF371, 0x006BF38D, 0x006BF5F9, 0x006BF605, 0x006BF572, 0x006BF5C8, 0x006BFF2F, 
						  0x006BFF4A, 0x006BFF5B, 0x006BFF65, 0x006C03AE, 0x006C03B8, 0x006C03C9, 0x006C03D3, 0x006C03E9, 0x006C03F3, 0x006C0410, 
						  0x006C0492, 0x006C0499, 0x006C04BB, 0x006C04C2, 0x006C04DB, 0x006C034C, 0x006C036B, 0x006C0386, 0x006C0390, 0x006C070E, 
						  0x006C0738, 0x006C0653, 0x006C0672, 0x006C0687, 0x006C0691, 0x006C06BE, 0x006C06EB, 0x006C0891, 0x006C0898, 0x006C08BA, 
						  0x006C08C1, 0x006C08DA, 0x006C0791, 0x006C07B4, 0x006C07DE, 0x006C07F2, 0x006C080F, 0x006C076C, 0x006C0A28, 0x006C0A39, 
						  0x006C0A43, 0x006C0A97, 0x006C0AB6, 0x006C0AD7, 0x006C0B59, 0x006C0B60, 0x006C0B82, 0x006C0B89, 0x006C0BA2, 0x006C0BD8, 
						  0x006C0BE2, 0x006C0964, 0x006C0983, 0x006C0998, 0x006C09BD, 0x006C09E0, 0x006C0A0A, 0x006C0A1E, 0x006C0D21, 0x006C0EDA, 
						  0x006C0EE4, 0x006C0EF3, 0x006C0F05, 0x006C0F16, 0x006C0F2B, 0x006C10E9, 0x006C1D13, 0x006C1D23, 0x006C1D87, 0x006C1DB1, 
						  0x006C1DD8, 0x006C239C, 0x006C23C9, 0x006C23F7, 0x006C2424, 0x006C24D6, 0x006C24F5, 0x006C257C, 0x006C258E, 0x006C28A2, 
						  0x006C2973, 0x006C29B4, 0x006C2AC4, 0x006C2B13, 0x006C2BC3, 0x006C2C16, 0x006C2CF4, 0x006C2D35, 0x006C2E62, 0x006C2F9F, 
						  0x006C2FDD, 0x006C2FF7, 0x006C301E, 0x006C3045, 0x006C305F, 0x006C3086, 0x006C32E4, 0x006C3217, 0x006C33DA, 0x006C341B, 
						  0x006C3436, 0x006C3684, 0x006C369F, 0x006C37EE, 0x006C37F5, 0x006C380D, 0x006C3814, 0x006C3871, 0x006C3878, 0x006C388B, 
						  0x006C375A, 0x006C3761, 0x006C3771, 0x006C3778, 0x006C3782, 0x006C390D, 0x006C3BFB, 0x006C3C0C, 0x006C3B37, 0x006C3B7F, 
						  0x006C3BB0, 0x006C3BC1, 0x006C3BE0, 0x006C3DA0, 0x006C3E12, 0x006C3E25, 0x006C3E2C, 0x006C3E4E, 0x006C3E55, 0x006C3E72, 
						  0x006C3E83, 0x006C3CF0, 0x006C3D7D, 0x006C406B, 0x006C407C, 0x006C3FA7, 0x006C3FEF, 0x006C4020, 0x006C4031, 0x006C4050, 
						  0x006C4263, 0x006C42BC, 0x006C4369, 0x006C4EAA, 0x006C5058, 0x006C5072, 0x006C50BE, 0x006C4F86, 0x006C4FA0, 0x006C525A, 
						  0x006C53D4, 0x006C53EE, 0x006C5298, 0x006C52C6, 0x006C5331, 0x006C5350, 0x006C5DEE, 0x006C5E1F, 0x006C5E30, 0x006C5E5D, 
						  0x006C5E6E, 0x006C5E90, 0x006C6856, 0x006C686C, 0x006C6899, 0x006C68A9, 0x006C68C7, 0x006C68D7, 0x006C67C2, 0x006C67CD, 
						  0x006C6C52, 0x006C6CB5, 0x006C6D0C, 0x006C6D1E, 0x006C6D75, 0x006C6DB0, 0x006C702D, 0x006C7650, 0x006C7663, 0x006C76D1, 
						  0x006C76F7, 0x006C78A8, 0x006C78BE, 0x006C78DB, 0x006C7778, 0x006C77C8, 0x006C7DA9, 0x006C7DB4, 0x006C8079, 0x006C809F, 
						  0x006C80C1, 0x006C80D6, 0x006C7F89, 0x006C8104, 0x006C8117, 0x006C81A5, 0x006C81BA, 0x006C8219, 0x006C8274, 0x006C8296, 
						  0x006C82CB, 0x006C8366, 0x006C7FB0, 0x006C8381, 0x006C8478, 0x006C84BC, 0x006C84DA, 0x006C7FC8, 0x006C850E, 0x006C8634, 
						  0x006C86C9, 0x006C877E, 0x006C881C, 0x006C8906, 0x006C8013, 0x006C8DE5, 0x006C8E18, 0x006C8E3B, 0x006C915C, 0x006C975C, 
						  0x006C9770, 0x006C9DF4, 0x006CA180, 0x006CA18C, 0x006CA1A2, 0x006CA4A5, 0x006CA558, 0x006CA568, 0x006CA57C, 0x006CA5A2, 
						  0x006CA5F5, 0x006CB222, 0x006CB2B4, 0x006CB37F, 0x006CB3DB, 0x006CB45F, 0x006CB4FE, 0x006CB872, 0x006CB904, 0x006CB9CF, 
						  0x006CBA2B, 0x006CBAAF, 0x006CBB4E, 0x006CC491, 0x006CCF0B, 0x006CD10B, 0x006CD30B, 0x006CD50B, 0x006CDFBA, 0x006CE06A, 
						  0x006CE11A, 0x006CE1CA, 0x006CE27A, 0x006CE2B3, 0x006CE313, 0x006CE373, 0x006CE3D3, 0x006CE433, 0x006CE48C, 0x006CE78A, 
						  0x006CE7BA, 0x006CEB27, 0x006CEB3A, 0x006CEBDF, 0x006CECC9, 0x006CED21, 0x006CED54, 0x006CED61, 0x006CEDA3, 0x006CED8F, 
						  0x006CEF2F, 0x006CEFB6, 0x006CEFC5, 0x006CF03F, 0x006CF0A6, 0x006CF116, 0x006CFA65, 0x006CFA71, 0x006CFAD5, 0x006CFAE1, 
						  0x006CFB45, 0x006CFB51, 0x006CFBB5, 0x006CFBC1, 0x006CFC28, 0x006CFC34, 0x006CFCC5, 0x006CFCD1, 0x006CFCE1, 0x006CFCF1, 
						  0x006CFDB5, 0x006CFDC5, 0x006CFDD1, 0x006CFE36, 0x006CFE42, 0x006CFE52, 0x006CFE62, 0x006CFF25, 0x006CFF31, 0x006CFFA5, 
						  0x006CFFB5, 0x006CFFC1, 0x006D0026, 0x006D0032, 0x006D00D5, 0x006D00E5, 0x006D00F1, 0x006D0156, 0x006D0175, 0x006D01F9, 
						  0x006D0291, 0x006D029D, 0x006D02A8, 0x006D089C, 0x006D08A8, 0x006D0AE1, 0x006D0AF6, 0x006D0B0D, 0x006D0B16, 0x006D0B30, 
						  0x006D0B76, 0x006D0A19, 0x006D0A40, 0x006D0A50, 0x006D0A60, 0x006D0A7A, 0x006D0AA0, 0x006D0ABA, 0x006D0C3C, 0x006D17E1, 
						  0x006D181F, 0x006D1832, 0x006D372D, 0x006D3622, 0x006D373B, 0x006D3764, 0x006D3772, 0x006D37F8, 0x006D3638, 0x006D392A, 
						  0x006D364E, 0x006D36A2, 0x006D36B5, 0x006D36DC, 0x006D3F4E, 0x006D459F, 0x006D48B5, 0x006D48F9, 0x006D4907, 0x006D4920, 
						  0x006D492E, 0x006D4997, 0x006D49B1, 0x006D49FA, 0x006D4A7A, 0x006D4AEE, 0x006D4B32, 0x006D4B40, 0x006D4B5C, 0x006D4B6A, 
						  0x006D45E2, 0x006D4614, 0x006D4636, 0x006D4651, 0x006D466C, 0x006D78DA, 0x006D7907, 0x006D7932, 0x006D7996, 0x006D7800, 
						  0x006D7832, 0x006D7850, 0x006D785E, 0x006D787D, 0x006D788B, 0x006D7C7C, 0x006D7CAD, 0x006D7CE3, 0x006D7D87, 0x006D7D95, 
						  0x006D7B40, 0x006D7B4E, 0x006D8003, 0x006D801B, 0x006D7F12, 0x006D8077, 0x006D80C2, 0x006D80D0, 0x006D80E6, 0x006D80F4, 
						  0x006D7FD6, 0x006D827D, 0x006D82BE, 0x006D8831, 0x006D884E, 0x006D8B43, 0x006D8C31, 0x006D8CD3, 0x006D8A70, 0x006D8AA7, 
						  0x006D8AB5, 0x006D8ACC, 0x006D8ADA, 0x006D8B19, 0x006D8B27, 0x006D8F6E, 0x006D8F9F, 0x006D8FD5, 0x006D9000, 0x006D9043, 
						  0x006D9061, 0x006D9091, 0x006D911D, 0x006D912B, 0x006D9144, 0x006D9152, 0x006D8F23, 0x006D949B, 0x006D932A, 0x006D934E, 
						  0x006D93C4, 0x006D93DC, 0x006DA772, 0x006DB1D3, 0x006DB091, 0x006DB0A0, 0x006DB100, 0x006DC019, 0x006DD17A, 0x006DD6D2, 
						  0x006DE731, 0x006DE73D, 0x006E0259, 0x006E0535, 0x006E054F, 0x006E056B, 0x006E0581, 0x006E0329, 0x006E0594, 0x006E05AF, 
						  0x006E05CA, 0x006E0363, 0x006E03EC, 0x006E076D, 0x006E0780, 0x006E0793, 0x006E07AB, 0x006E0757, 0x006E07C3, 0x006E0839, 
						  0x006E0989, 0x006E0AC9, 0x006E0CA4, 0x006E0D3C, 0x006E0E6B, 0x006E0EC6, 0x006E0EE4, 0x006E0F3B, 0x006E0F5D, 0x006E0F70, 
						  0x006E0F91, 0x006E0FDC, 0x006E0FE5, 0x006E100F, 0x006E1029, 0x006E1043, 0x006E105A, 0x006E10B7, 0x006E10D8, 0x006E1128, 
						  0x006E1141, 0x006E0BD3, 0x006E0C1C, 0x006E0B7C, 0x006E0C3D, 0x006E1374, 0x006E13CE, 0x006E1424, 0x006E1285, 0x006E1540, 
						  0x006E1553, 0x006E156B, 0x006E1583, 0x006E1596, 0x006E12AE, 0x006E12E7, 0x006E12F5, 0x006E1305, 0x006E1313, 0x006E126C, 
						  0x006E1334, 0x006E1342, 0x006E1779, 0x006E1850, 0x006E1949, 0x006E1959, 0x006E19C1, 0x006E19D5, 0x006E19E5, 0x006E1A18, 
						  0x006E1A48, 0x006E1A69, 0x006E1A79, 0x006E1AB3, 0x006E1AEA, 0x006E1877, 0x006E1889, 0x006E18A8, 0x006E18DE, 0x006E1902, 
						  0x006E191B, 0x006E192A, 0x006E193A, 0x006E1CBB, 0x006E1B8A, 0x006E1D12, 0x006E1D31, 0x006E1D3A, 0x006E1DCF, 0x006E1E03, 
						  0x006E1E7F, 0x006E1BA2, 0x006E2021, 0x006E1BC9, 0x006E1BDB, 0x006E226F, 0x006E1BF3, 0x006E23D8, 0x006E23EE, 0x006E2404, 
						  0x006E2417, 0x006E2426, 0x006E2453, 0x006E1BFF, 0x006E2486, 0x006E24A5, 0x006E24BB, 0x006E2509, 0x006E2519, 0x006E25A1, 
						  0x006E25DA, 0x006E1C17, 0x006E2615, 0x006E2642, 0x006E26E0, 0x006E2716, 0x006E273A, 0x006E274A, 0x006E2759, 0x006E276C, 
						  0x006E2791, 0x006E27A4, 0x006E2819, 0x006E282C, 0x006E283B, 0x006E284E, 0x006E28E1, 0x006E2917, 0x006E293B, 0x006E294B, 
						  0x006E1C57, 0x006E29F3, 0x006E2A29, 0x006E2A4A, 0x006E2A5A, 0x006E2AAA, 0x006E2AB9, 0x006E2AC9, 0x006E2AD8, 0x006E2AE8, 
						  0x006E2D3C, 0x006E2D53, 0x006E2C4B, 0x006E2FC8, 0x006E2FF2, 0x006E3073, 0x006E3087, 0x006E3097, 0x006E30D9, 0x006E310F, 
						  0x006E3130, 0x006E3140, 0x006E3162, 0x006E31A1, 0x006E2C8A, 0x006E31E8, 0x006E323F, 0x006E3301, 0x006E3324, 0x006E3342, 
						  0x006E3364, 0x006E3375, 0x006E3384, 0x006E3394, 0x006E33A3, 0x006E33B3, 0x006E33D4, 0x006E33E5, 0x006E2CBA, 0x006E2CDC, 
						  0x006E36D5, 0x006E3785, 0x006E38BE, 0x006E38E8, 0x006E351C, 0x006E3AF6, 0x006E3B05, 0x006E3B15, 0x006E3B4F, 0x006E353B, 
						  0x006E3B82, 0x006E3BCA, 0x006E3C41, 0x006E3C77, 0x006E354B, 0x006E3D2D, 0x006E3D6D, 0x006E3E3F, 0x006E3E52, 0x006E3E71, 
						  0x006E3EAF, 0x006E3ED8, 0x006E3EEC, 0x006E3EFC, 0x006E3F3E, 0x006E3F74, 0x006E358E, 0x006E34DD, 0x006E35AD, 0x006E4030, 
						  0x006E412A, 0x006E4153, 0x006E4173, 0x006E4187, 0x006E419A, 0x006E41C0, 0x006E41EE, 0x006E4214, 0x006E424E, 0x006E425D, 
						  0x006E4273, 0x006E42CC, 0x006E4321, 0x006E4055, 0x006E4372, 0x006E4061, 0x006E4452, 0x006E44AF, 0x006E44D9, 0x006E454A, 
						  0x006E455E, 0x006E456E, 0x006E45B0, 0x006E45E6, 0x006E4607, 0x006E4617, 0x006E4638, 0x006E46C5, 0x006E46EA, 0x006E46FB, 
						  0x006E470A, 0x006E471A, 0x006E4729, 0x006E4739, 0x006E475A, 0x006E40D7, 0x006E40F3, 0x006E4112, 0x006E48E9, 0x006E47F2, 
						  0x006E4908, 0x006E4914, 0x006E492C, 0x006E4801, 0x006E4A95, 0x006E4AD1, 0x006E4811, 0x006E4B23, 0x006E4820, 0x006E4830, 
						  0x006E4843, 0x006E4854, 0x006E4868, 0x006E4878, 0x006E488C, 0x006E489C, 0x006E48AB, 0x006E48BB, 0x006E48CA, 0x006E4BA4, 
						  0x006E4B69, 0x006E4C08, 0x006E4D85, 0x006E4D9F, 0x006E4DAD, 0x006E4E90, 0x006E4EAB, 0x006E4ED0, 0x006E4C79, 0x006E4EF7, 
						  0x006E52FC, 0x006E5432, 0x006E4CD8, 0x006E5506, 0x006E5530, 0x006E4CF6, 0x006E4D0E, 0x006E4D1A, 0x006E4C5E, 0x006E5610, 
						  0x006E562C, 0x006E55E9, 0x006E580D, 0x006E582C, 0x006E5A46, 0x006E5A6A, 0x006E596D, 0x006E5980, 0x006E59A6, 0x006E59B9, 
						  0x006E5939, 0x006E5AD7, 0x006E5A99, 0x006E5B4F, 0x006E5B75, 0x006E5BC3, 0x006E5BEC, 0x006E5BB7, 0x006E5C20, 0x006E5C2C, 
						  0x006E6629, 0x006E6749, 0x006E6869, 0x006E6989, 0x006E6AA9, 0x006E6BE9, 0x006E6CF0, 0x006E6E60, 0x006E6E82, 0x006E6E95, 
						  0x006E6EAB, 0x006E6EEA, 0x006E6EF3, 0x006E6D2A, 0x006E6D6A, 0x006E6DCB, 0x006E6FB9, 0x006E72E7, 0x006E7312, 0x006E737A, 
						  0x006E7454, 0x006E7472, 0x006E7498, 0x006E74AB, 0x006E74CB, 0x006E74FB, 0x006E7515, 0x006E70D5, 0x006E708C, 0x006E7148, 
						  0x006E7989, 0x006E7A60, 0x006E7B9B, 0x006E7BFF, 0x006E7C6C, 0x006E7D11, 0x006E7E60, 0x006E7EBE, 0x006E7ED3, 0x006E7A9A, 
						  0x006E7F63, 0x006E7F85, 0x006E7F98, 0x006E7FC0, 0x006E7FC9, 0x006E7ABB, 0x006E7ACD, 0x006E7AEE, 0x006E7B0D, 0x006E8099, 
						  0x006E8170, 0x006E82D6, 0x006E837E, 0x006E83A0, 0x006E83B3, 0x006E83D8, 0x006E83E1, 0x006E81AA, 0x006E81EA, 0x006E8209, 
						  0x006E823C, 0x006E84A9, 0x006E85EE, 0x006E8853, 0x006E8866, 0x006E8879, 0x006E882F, 0x006E88E2, 0x006E88E9, 0x006E88FE, 
						  0x006E891F, 0x006E8930, 0x006E8937, 0x006E8968, 0x006E8A4B, 0x006E8D7D, 0x006E8E43, 0x006E8F9F, 0x006E9163, 0x006E9280, 
						  0x006E93BE, 0x006E939F, 0x006E942E, 0x006E940F, 0x006E94C3, 0x006E9593, 0x006E97CA, 0x006E9C88, 0x006E9C9E, 0x006EA5B3, 
						  0x006EA5C9, 0x006EB7AE, 0x006EBB65, 0x006EBB3C, 0x006EBC7E, 0x006EBCA4, 0x006EBD81, 0x006EBD9F, 0x006EBDAD, 0x006EBDCD, 
						  0x006EBDE6, 0x006EBD5C, 0x006EBF13, 0x006EBFE3, 0x006EC0FA, 0x006EC288, 0x006EC29E, 0x006EC51C, 0x006EC52F, 0x006EC545, 
						  0x006EC558, 0x006EC45E, 0x006EC48C, 0x006EC49F, 0x006EC9F6, 0x006ECAEE, 0x006EC677, 0x006EC682, 0x006ECC06, 0x006ECE66, 
						  0x006ECE80, 0x006ECEBC, 0x006ECEDB, 0x006ECEEE, 0x006ECF0C, 0x006ED056, 0x006ED2F1, 0x006ED34C, 0x006ED362, 0x006ED376, 
						  0x006ED383, 0x006ED3A3, 0x006ED3B8, 0x006ED3EA, 0x006ED412, 0x006ED443, 0x006ED26B, 0x006ED478, 0x006ED76D, 0x006ED80D, 
						  0x006ED81C, 0x006ED832, 0x006EDA4C, 0x006EDA6B, 0x006EDACB, 0x006EDC33, 0x006EFE1E, 0x006F0028, 0x006F003E, 0x006F026B, 
						  0x006F027F, 0x006F0296, 0x006F02CE, 0x006F02ED, 0x006F0316, 0x006F058D, 0x006F05C6, 0x006F05F1, 0x006F073B, 0x006F0645, 
						  0x006F0654, 0x006F066A, 0x006F0678, 0x006F068B, 0x006F06AC, 0x006F06C8, 0x006F06ED, 0x006F0708, 0x006F07B6, 0x006F07C5, 
						  0x006F0935, 0x006F0948, 0x006F095E, 0x006F0982, 0x006F09A1, 0x006F09CA, 0x006F09FA, 0x006F0A01, 0x006F0A0E, 0x006F0A1D, 
						  0x006F0A24, 0x006F0A53, 0x006F0A5A, 0x006F0863, 0x006F0873, 0x006F087A, 0x006F089D, 0x006F08D3, 0x006F08E6, 0x006F08F8, 
						  0x006F090B, 0x006F0919, 0x006F0AAE, 0x006F0AC0, 0x006F0AD1, 0x006F0A9D, 0x006F0B0E, 0x006F0B20, 0x006F0B31, 0x006F0AFD, 
						  0x006F0C52, 0x006F0C66, 0x006F0C89, 0x006F0CA8, 0x006F0CBE, 0x006F0CD2, 0x006F0CEA, 0x006F0CF6, 0x006F0D1A, 0x006F0D3A, 
						  0x006F0D4D, 0x006F0D84, 0x006F0B84, 0x006F0EA2, 0x006F0EC6, 0x006F0B93, 0x006F0BA6, 0x006F0BC5, 0x006F0BE3, 0x006F0BFE, 
						  0x006F0C17, 0x006F0C2F, 0x006F0F93, 0x006F1153, 0x006F12A0, 0x006F13E1, 0x006F1573, 0x006F1643, 0x006F185A, 0x006F1CA8, 
						  0x006F1CBE, 0x006F2793, 0x006F27A9, 0x006F409E, 0x006F45E0, 0x006F45FE, 0x006F484B, 0x006F4852, 0x006F47FD, 0x006F474C, 
						  0x006F4804, 0x006F4818, 0x006F481F, 0x006F48EC, 0x006F493D, 0x006F49D1, 0x006F49EF, 0x006F49FD, 0x006F4A1D, 0x006F4A36, 
						  0x006F49AC, 0x006F4CC7, 0x006F4CEB, 0x006F4CFB, 0x006F4D0E, 0x006F4D2D, 0x006F4D3F, 0x006F4D8B, 0x006F4D9A, 0x006F4E0C, 
						  0x006F4E20, 0x006F4E4B, 0x006F4E72, 0x006F4E99, 0x006F4EC0, 0x006F4F13, 0x006F4F22, 0x006F502F, 0x006F503B, 0x006F5047, 
						  0x006F5053, 0x006F55DB, 0x006F5494, 0x006F6013, 0x006F602A, 0x006F6041, 0x006F605F, 0x006F6078, 0x006F6091, 0x006F60AA, 
						  0x006F5FFC, 0x006F60D4, 0x006F60ED, 0x006F6106, 0x006F611F, 0x006F682B, 0x006F684B, 0x006F6896, 0x006F68B6, 0x006F6909, 
						  0x006F675E, 0x006F67BB, 0x006F6A5C, 0x006F6DD6, 0x006F6DFB, 0x006F6D38, 0x006F6EFE, 0x006F6EEF, 0x006F7063, 0x006F7100, 
						  0x006F7146, 0x006F71FF, 0x006F721F, 0x006F7377, 0x006F7397, 0x006F73E2, 0x006F73FD, 0x006F7416, 0x006F746D, 0x006F77F4, 
						  0x006F7B82, 0x006F7BBE, 0x006F7E02, 0x006F8197, 0x006F817C, 0x006F82FC, 0x006F86EF, 0x006F870F, 0x006F87E7, 0x006F8800, 
						  0x006F8840, 0x006F8860, 0x006F8696, 0x006F86AF, 0x006F89E1, 0x006F89FA, 0x006F8A2B, 0x006F8A4B, 0x006F891F, 0x006F8938, 
						  0x006F8969, 0x006F8989, 0x006F8DB5, 0x006F8DD7, 0x006F8E1C, 0x006F8E40, 0x006F8CD2, 0x006F8D2F, 0x006F8D51, 0x006F8D96, 
						  0x006F9159, 0x006F91BC, 0x006F929C, 0x006F9446, 0x006F947F, 0x006F9716, 0x006F974F, 0x006F9D9F, 0x006F9F7F, 0x006FA281, 
						  0x006FA534, 0x006FA6CF, 0x006FAA7B, 0x006FB2F1, 0x006FB4CE, 0x006FB3A0, 0x006FB3D1, 0x006FB432, 0x006FD21E, 0x006FD438, 
						  0x006FD44E, 0x006FD774, 0x006FD6C9, 0x006FD6D5, 0x006FD6EA, 0x006FD844, 0x006FDB17, 0x006FDDA7, 0x006FDDB0, 0x006FDDC6, 
						  0x006FDDCF, 0x006FDFA1, 0x006FE94E, 0x006FE93F, 0x006FF0E1, 0x006FF522, 0x006FFCAA, 0x007005CA, 0x007005E3, 0x00700603, 
						  0x00700671, 0x00701CAE, 0x00701CCB, 0x00701CEA, 0x00701B91, 0x00701BBE, 0x00701BD1, 0x00701BE0, 0x00701C16, 0x00701C64, 
						  0x00701D63, 0x00701D6F, 0x00701DA8, 0x00701F5D, 0x0070229E, 0x007022B1, 0x007022D6, 0x00702207, 0x00702283, 0x0070228F, 
						  0x0070244F, 0x00702923, 0x0070296A, 0x007029A9, 0x007031DA, 0x00703602, 0x00703752, 0x00703762, 0x00703777, 0x007037EF, 
						  0x00703AD2, 0x00703AE5, 0x00703AF7, 0x00703B0A, 0x00703C64, 0x00703DFF, 0x00703E0D, 0x00703E59, 0x00703EC3, 0x00703ECD, 
						  0x00703F00, 0x00703F5B, 0x00703F7B, 0x00703F85, 0x00703FB4, 0x00703FBE, 0x00703FDE, 0x00703FE8, 0x00704009, 0x00704013, 
						  0x00704033, 0x0070403D, 0x00704070, 0x0070407A, 0x007040AB, 0x007040B5, 0x007040D5, 0x007040DF, 0x0070412D, 0x0070413C, 
						  0x0070416D, 0x00704193, 0x00704212, 0x00704248, 0x00704320, 0x00704345, 0x00704391, 0x007043F5, 0x0070441C, 0x00704443, 
						  0x007045ED, 0x0070493F, 0x00704956, 0x0070496D, 0x00704ADB, 0x00704AEE, 0x00704B05, 0x00704B0F, 0x00704B24, 0x00704B4F, 
						  0x00704B5D, 0x00704B6C, 0x00704B7F, 0x00704B96, 0x00704BA0, 0x00704BB5, 0x00704BE0, 0x00704BEE, 0x00704BFD, 0x00704C10, 
						  0x00704C27, 0x00704C31, 0x00704C46, 0x00704ABE, 0x00704ACC, 0x0070500C, 0x00705016, 0x00705031, 0x007050A1, 0x007050E9, 
						  0x00705120, 0x00705186, 0x007051B4, 0x007051D8, 0x00705308, 0x0070532C, 0x00705235, 0x0070525F, 0x00705289, 0x007052B6, 
						  0x007052DF, 0x0070537C, 0x007053CC, 0x0070541C, 0x0070543E, 0x007056E7, 0x0070570C, 0x0070571E, 0x0070577A, 0x0070579F, 
						  0x00705B35, 0x00705D4B, 0x00705D94, 0x00705DD8, 0x00705E19, 0x00705EB2, 0x00705ECF, 0x00705F63, 0x00705FE1, 0x00705FFA, 
						  0x00706075, 0x007061F1, 0x007062ED, 0x0070636E, 0x00706626, 0x0070664A, 0x0070666E, 0x00706721, 0x00706743, 0x007067E3, 
						  0x00706805, 0x00706845, 0x0070685F, 0x00706893, 0x00706585, 0x00706927, 0x007069DC, 0x00706A08, 0x00706A16, 0x00706A20, 
						  0x00706A2E, 0x00706A38, 0x00706A51, 0x00706B19, 0x00706D39, 0x00706F2B, 0x00707068, 0x00707124, 0x007072C2, 0x007071F9, 
						  0x00707228, 0x00707246, 0x00707267, 0x00707283, 0x007072A1, 0x0070749B, 0x007074AE, 0x007074D6, 0x007074E8, 0x0070754E, 
						  0x00707584, 0x007075AA, 0x00707743, 0x00707751, 0x00707790, 0x007078D3, 0x00707953, 0x00707962, 0x007079F3, 0x00707A09, 
						  0x00707A82, 0x00707A9D, 0x00707B88, 0x00707BA6, 0x00707BBE, 0x00707EAC, 0x00707F16, 0x0070804B, 0x00707F42, 0x0070836E, 
						  0x00708378, 0x00708383, 0x0070838D, 0x007083B4, 0x007083C2, 0x007083CC, 0x007083DA, 0x007083E4, 0x007083FD, 0x0070820D, 
						  0x00708217, 0x0070822E, 0x00708249, 0x00708253, 0x007081CE, 0x00708457, 0x00708465, 0x0070846F, 0x0070847D, 0x00708487, 
						  0x007084A0, 0x00708695, 0x007086AD, 0x0070871E, 0x00708736, 0x00708817, 0x00708846, 0x00708850, 0x007088B5, 0x007088BF, 
						  0x00708547, 0x00708B47, 0x00708B7A, 0x00708D8D, 0x00708DD0, 0x00708DEF, 0x00708DF9, 0x00709194, 0x007091F8, 0x00709222, 
						  0x00709276, 0x00709326, 0x0070935A, 0x0070936F, 0x0070939A, 0x007093AF, 0x007093B9, 0x007093C8, 0x00709416, 0x00709466, 
						  0x00709492, 0x007094BE, 0x007094E8, 0x00709682, 0x007097A3, 0x00709819, 0x0070983A, 0x00709867, 0x00709891, 0x0070992B, 
						  0x00709120, 0x0070912A, 0x0070915F, 0x00709B60, 0x00709D27, 0x00709D36, 0x00709D40, 0x00709D5A, 0x00709D1D, 0x00709EAD, 
						  0x00709EC4, 0x00709ED9, 0x00709EED, 0x00709F14, 0x00709F43, 0x00709FFA, 0x0070A043, 0x0070A077, 0x0070A0A1, 0x00709DD1, 
						  0x0070A35F, 0x0070A38A, 0x00709DF0, 0x0070A49D, 0x0070A4AC, 0x0070A4D7, 0x0070A4F0, 0x0070A537, 0x0070A5E2, 0x0070A5FF, 
						  0x0070A8C6, 0x0070A907, 0x0070A92B, 0x0070A952, 0x0070A9F9, 0x0070AA05, 0x0070AA2A, 0x0070AB09, 0x0070AB13, 0x0070AB1F, 
						  0x0070AB29, 0x0070A7F8, 0x0070A89F, 0x0070A8A9, 0x0070BC4C, 0x0070BC78, 0x0070BB97, 0x0070BBA7, 0x0070BBCD, 0x0070BBED, 
						  0x0070C428, 0x0070C434, 0x0070C453, 0x0070C547, 0x0070ECB2, 0x0070ED26, 0x0070EFCD, 0x0070F01A, 0x0070F5C8, 0x0070F5D4, 
						  0x0070F590, 0x007104A6, 0x007104B1, 0x0071053D, 0x0071056F, 0x0071086F, 0x00711907, 0x00711D9E, 0x00711DA9, 0x0071230A, 
						  0x00712315, 0x00712CE7, 0x00712CF2, 0x00714A74, 0x0071610A, 0x007161EA, 0x00716D93, 0x00716DA2, 0x00716E2F, 0x00716E6E, 
						  0x00716E9C, 0x00716F16, 0x00716F62, 0x00716F6D, 0x0071704E, 0x0071706C, 0x00717073, 0x00717101, 0x00717110, 0x00717170, 
						  0x00717186, 0x00717241, 0x0071727E, 0x00717293, 0x00716BD6, 0x00717341, 0x00717482, 0x0071749A, 0x0071750F, 0x00717546, 
						  0x0071756C, 0x00717605, 0x0071A97F, 0x0071AA1B, 0x0071AA62, 0x0071AA6D, 0x0071AB22, 0x0071AB29, 0x0071A671, 0x0071AB34, 
						  0x0071AC6E, 0x0071AC75, 0x0071AD74, 0x0071AE37, 0x0071AE3E, 0x0071B023, 0x0071BB12, 0x0071C73C, 0x0071C801, 0x0071DC65, 
						  0x0071DCB2, 0x0071DE35, 0x0071DEA6, 0x0071DD1A, 0x0071E041, 0x0071E23D, 0x0071E18C, 0x0071E19A, 0x0071E1B7, 0x0071E1C5, 
						  0x0071E1E5, 0x0071E3B3, 0x0071E483, 0x0071E5AA, 0x0071E748, 0x0071E75E, 0x0071EB8C, 0x0071ECD1, 0x0071ECE8, 0x0071ECEF, 
						  0x0071ECF8, 0x0071ED12, 0x0071ED19, 0x0071ED22, 0x0071EC61, 0x0071EC91, 0x0071EC9D, 0x0071ECAA, 0x0071ECB9, 0x0071EDC8, 
						  0x0071F322, 0x0071F33C, 0x0071F26B, 0x0071F2E4, 0x0071F59D, 0x0071F5CB, 0x0071F5E7, 0x0071F5FD, 0x0071F617, 0x0071F662, 
						  0x0071F672, 0x0071F6AA, 0x0071F6B4, 0x0071F6E8, 0x0071F712, 0x0071F781, 0x0071F78B, 0x0071F7BF, 0x0071F862, 0x0071F882, 
						  0x0071F8D6, 0x0071F8EE, 0x0071F4F1, 0x0071FA14, 0x0071FB12, 0x0071FE86, 0x0071FEEC, 0x0071FF46, 0x00720A2E, 0x00720E1A, 
						  0x00720E8B, 0x00720F0D, 0x0072147E, 0x007212F0, 0x00721300, 0x00722014, 0x00722033, 0x00722114, 0x00722133, 0x007223A4, 
						  0x007223C3, 0x00722A3F, 0x00722D32, 0x00722FA9, 0x00722FC4, 0x00722FE9, 0x00722F7E, 0x007234AF, 0x007234BB, 0x00723545, 
						  0x00723555, 0x0072358E, 0x0072363C, 0x0072372E, 0x0072377C, 0x0072397F, 0x0072378C, 0x0072384A, 0x00723A6E, 0x00723F43, 
						  0x00723BC0, 0x00724237, 0x00724280, 0x007242D2, 0x007242E4, 0x007243D1, 0x00724402, 0x007247FF, 0x00724952, 0x007249F8, 
						  0x00724A09, 0x00724A25, 0x0072490D, 0x0072492A, 0x00724D2E, 0x00724D57, 0x00724FBC, 0x00724C5F, 0x00725028, 0x00725222, 
						  0x007252B2, 0x007253E2, 0x007253F4, 0x00725436, 0x00725466, 0x0072549A, 0x007254B0, 0x007254C9, 0x0072553E, 0x007252F7, 
						  0x00725555, 0x00725636, 0x00725653, 0x00725675, 0x00725313, 0x007253B8, 0x007257D4, 0x007257E8, 0x007257EF, 0x00725757, 
						  0x0072575E, 0x00725773, 0x007257B0, 0x007257B7, 0x007257CD, 0x00725959, 0x00725839, 0x00725876, 0x0072589F, 0x00725916, 
						  0x00725A05, 0x00725AF9, 0x00725B00, 0x00725BBD, 0x00725BDA, 0x00725BF4, 0x00725C84, 0x00725CA1, 0x00725D82, 0x00725DAB, 
						  0x00725DC5, 0x00725E66, 0x00725E6D, 0x00725E83, 0x00725E8A, 0x00725E9B, 0x00725F5E, 0x00725F73, 0x00726015, 0x007260A1, 
						  0x007260B2, 0x0072669A, 0x00726934, 0x00726953, 0x00726E44, 0x00726E63, 0x007285FA, 0x0072886D, 0x007289CF, 0x00728A53, 
						  0x00728C5E, 0x00728DB0, 0x00728E71, 0x00728EEB, 0x00728F15, 0x00728F33, 0x00728FC2, 0x00729045, 0x007295CF, 0x0072963F, 
						  0x007296AF, 0x0072971F, 0x0072978F, 0x007297FF, 0x0072986F, 0x007298DF, 0x0072994F, 0x007299AB, 0x0072A0C3, 0x0072A103, 
						  0x0072A143, 0x0072A183, 0x0072A1C5, 0x0072A235, 0x0072A2A5, 0x0072A315, 0x0072A385, 0x0072A482, 0x0072A4E2, 0x0072A562, 
						  0x0072A5BC, 0x0072A5F6, 0x0072A636, 0x0072A676, 0x0072A6BC, 0x0072A71E, 0x0072A77F, 0x0072A7EE, 0x0072A846, 0x0072A8A6, 
						  0x0072A958, 0x0072A967, 0x0072A980, 0x0072A992, 0x0072A9B3, 0x0072AA74, 0x0072AAA7, 0x0072AAB6, 0x0072AAC8, 0x0072AC3E, 
						  0x0072AC2F, 0x0072AC8C, 0x0072AC7D, 0x0072AFA6, 0x0072B016, 0x0072B11D, 0x0072B18D, 0x0072B3B3, 0x0072B3C9, 0x0072B6DF, 
						  0x0072B706, 0x0072B714, 0x0072B574, 0x0072B89E, 0x0072B8AD, 0x0072B8DA, 0x0072B8F7, 0x0072B91E, 0x0072B92D, 0x0072B94C, 
						  0x0072B584, 0x0072B5E6, 0x0072B61B, 0x0072BC7E, 0x0072BE49, 0x0072BE5C, 0x0072BBB0, 0x0072C0AE, 0x0072C223, 0x0072C25D, 
						  0x0072C28F, 0x0072C29E, 0x0072C2CE, 0x0072C2DD, 0x0072C5DB, 0x0072C5FF, 0x0072C624, 0x0072C92E, 0x0072C967, 0x0072C9C9, 
						  0x0072CA11, 0x0072CA8A, 0x0072CB8D, 0x0072CBAF, 0x0072CC11, 0x0072CC36, 0x0072CE17, 0x0072CE3C, 0x0072CDB0, 0x0072D441, 
						  0x0072D5CB, 0x0072D779, 0x0072D809, 0x0072E0DC, 0x0072E995, 0x0072EC21, 0x0072EC4A, 0x0072EC60, 0x0072FF51, 0x0073050B, 
						  0x00730ACD, 0x00730ADD, 0x00730B08, 0x00730B2B, 0x00730E3E, 0x00730E4A, 0x00730EED, 0x00730F22, 0x007315C3, 0x00732446, 
						  0x00732A7F, 0x00732A92, 0x00732AC9, 0x00732AF9, 0x00732B0C, 0x00732B1A, 0x00732B7C, 0x00732B94, 0x00732BA0, 0x00732BCF, 
						  0x00732BE7, 0x00732CE5, 0x00732CF6, 0x007329FC, 0x00732A0D, 0x00732D7B, 0x00732E08, 0x00732E8C, 0x00732EE3, 0x00732EF4, 
						  0x00733118, 0x0073307F, 0x0073384C, 0x00733862, 0x007338A0, 0x0073399A, 0x007346BC, 0x007346AD, 0x00734706, 0x007346DF, 
						  0x0073476D, 0x0073479E, 0x0073478F, 0x00734A36, 0x00734A55, 0x00734B8A, 0x00734AB0, 0x00734ADD, 0x007350DA, 0x00735141, 
						  0x007355FA, 0x00735601, 0x007357FB, 0x00735807, 0x00735C85, 0x00735CDC, 0x007366E4, 0x00736795, 0x00736B30, 0x00736B3C, 
						  0x00736B5B, 0x00736B8A, 0x00736C40, 0x00736C4C, 0x00736C6F, 0x00736C78, 0x00736C95, 0x00736CF0, 0x00736D00, 0x00736D10, 
						  0x00736D34, 0x00736D7D, 0x00736D86, 0x00736D97, 0x00736DF0, 0x00736E13, 0x00736EE0, 0x00736EEC, 0x00736F0F, 0x00736F18, 
						  0x00736F6B, 0x00737015, 0x007370B1, 0x00737C47, 0x00737C59, 0x00737D05, 0x00737D16, 0x00737D68, 0x00737DCD, 0x00737DEE, 
						  0x00737DFD, 0x00737E0E, 0x00737E2A, 0x00737F84, 0x00737F94, 0x00738022, 0x00738088, 0x00738094, 0x007380C2, 0x007380CB, 
						  0x007381FB, 0x0073882A, 0x00738839, 0x00738A82, 0x00738A96, 0x007389F4, 0x00738A5C, 0x00738A74, 0x00738D32, 0x00738D48, 
						  0x00738D5E, 0x00738C46, 0x00738D91, 0x00738DA7, 0x00738C74, 0x00738CAF, 0x00738CE7, 0x00738CF7, 0x00738D03, 0x00738D1C, 
						  0x00738E46, 0x00738E52, 0x00738FC4, 0x00739049, 0x00739070, 0x007390E1, 0x00738F34, 0x00739799, 0x007397B1, 0x007397C6, 
						  0x007397F1, 0x007398D1, 0x007398EB, 0x007398AF, 0x007399EE, 0x00739CB8, 0x00739BDC, 0x00739D1C, 0x00739D42, 0x00739D56, 
						  0x00739D71, 0x00739E12, 0x00739E61, 0x0073B161, 0x0073B174, 0x0073B18E, 0x0073AF53, 0x0073AFB0, 0x0073AFBC, 0x0073AFDF, 
						  0x0073B5A5, 0x0073B5B8, 0x0073B5C7, 0x0073B63D, 0x0073B6DE, 0x0073B78E, 0x0073B79D, 0x0073B7B7, 0x0073B7CF, 0x0073B840, 
						  0x0073B84F, 0x0073B860, 0x0073BDD9, 0x0073BE05, 0x0073C27C, 0x0073C288, 0x0073C3FE, 0x0073C40A, 0x0073C979, 0x0073C9DB, 
						  0x0073C9FA, 0x0073CA1E, 0x0073CA45, 0x0073C898, 0x0073C8A4, 0x0073C8E2, 0x0073C8F6, 0x0073C916, 0x0073CCA6, 0x0073CDED, 
						  0x0073CE24, 0x0073CEB3, 0x0073CF0E, 0x0073CF21, 0x0073CF3C, 0x0073CF8C, 0x0073CFBA, 0x0073CFD2, 0x0073CFEA, 0x0073D021, 
						  0x0073D09F, 0x0073D0AE, 0x0073D0C9, 0x0073D0E0, 0x0073CC2A, 0x0073CC36, 0x0073D424, 0x0073D6C6, 0x0073D7FC, 0x0073D81A, 
						  0x0073D84A, 0x0073D87D, 0x0073D8B4, 0x0073D8E4, 0x0073D901, 0x0073D92E, 0x0073D951, 0x0073D963, 0x0073D979, 0x0073D9AB, 
						  0x0073D9E1, 0x0073DA10, 0x0073DA2C, 0x0073DA58, 0x0073E05F, 0x0073E090, 0x0073E0E5, 0x0073E16D, 0x0073E18F, 0x0073E1C0, 
						  0x0073E6AA, 0x0073E6FB, 0x0073E723, 0x0073E738, 0x0073E748, 0x0073E852, 0x0073F96A, 0x0073F971, 0x00741A23, 0x007437AF, 
						  0x00743BC5, 0x00743BD8, 0x00743B31, 0x00743B41, 0x00743B64, 0x00743B7A, 0x00743C85, 0x00743C96, 0x00743CBA, 0x00743CE4, 
						  0x00743CFF, 0x00743ED0, 0x00743EE4, 0x00743F20, 0x00743F69, 0x00743F7B, 0x0074405D, 0x0074406C, 0x00743DC5, 0x00743DD8, 
						  0x00743E1A, 0x00743E28, 0x00743E3F, 0x00743E4F, 0x00743E5F, 0x0074423E, 0x0074428A, 0x0074412B, 0x00744137, 0x0074418E, 
						  0x007444BF, 0x00744546, 0x00744704, 0x0074472D, 0x00744781, 0x0074478D, 0x007447E7, 0x00744913, 0x0074492B, 0x00744966, 
						  0x0074483D, 0x00744B14, 0x00744B27, 0x00744B81, 0x00744B97, 0x00744849, 0x00744BB5, 0x00744BCA, 0x00744BE0, 0x00744C09, 
						  0x00744C35, 0x00744C4A, 0x00744C93, 0x00744CBE, 0x0074485F, 0x00744D2C, 0x00744D4F, 0x00744DA1, 0x00744E1D, 0x00744E36, 
						  0x007448D3, 0x00744E93, 0x00744EA2, 0x007450BE, 0x007450DD, 0x00745131, 0x0074513D, 0x0074520E, 0x0074523C, 0x00745248, 
						  0x0074526F, 0x0074539E, 0x007453AD, 0x00745AB3, 0x00745AC9, 0x00745AE3, 0x00745B2D, 0x00745B43, 0x00745F2B, 0x00747004, 
						  0x00747029, 0x0074704B, 0x0074705E, 0x0074707E, 0x00747090, 0x007470BD, 0x007470E9, 0x00746F01, 0x007470FE, 0x00746F26, 
						  0x00746F36, 0x00746F62, 0x00746F79, 0x00746F8A, 0x00746F99, 0x00746FBA, 0x00746FD7, 0x00747181, 0x00747198, 0x007472FB, 
						  0x00747325, 0x00747336, 0x00747229, 0x0074724C, 0x00747277, 0x00747291, 0x007472A9, 0x007472CC, 0x007472E8, 0x0074783A, 
						  0x0074784A, 0x00747860, 0x00747BDB, 0x00747BE7, 0x00747C42, 0x00747C52, 0x00747D8C, 0x00747D98, 0x00748508, 0x0074854F, 
						  0x0074858B, 0x0074861B, 0x0074891B, 0x00748AC6, 0x00748D65, 0x00748EAA, 0x007491BC, 0x00749747, 0x0074979C, 0x007497A8, 
						  0x0074999A, 0x007499F6, 0x00749A02, 0x00749A23, 0x00749B22, 0x00749B68, 0x0074A009, 0x0074A023, 0x0074A2E8, 0x0074A217, 
						  0x0074A225, 0x0074A25D, 0x0074A2B8, 0x0074A2C4, 0x0074A537, 0x0074A598, 0x0074A4E3, 0x0074A51D, 0x0074A740, 0x0074A7C6, 
						  0x0074A7DD, 0x0074A6E4, 0x0074A90A, 0x0074A916, 0x0074A9BA, 0x0074A9C6, 0x0074AE1C, 0x0074ACE5, 0x0074AD02, 0x0074AD42, 
						  0x0074B11D, 0x0074B189, 0x0074B0C7, 0x0074B10A, 0x0074B68A, 0x0074B7D6, 0x0074B7FE, 0x0074B902, 0x0074B911, 0x0074B99F, 
						  0x0074BA0B, 0x0074BA90, 0x0074BAF4, 0x0074BB29, 0x0074BB40, 0x0074BB98, 0x0074BBAA, 0x0074BBB9, 0x0074BCC4, 0x0074BCE6, 
						  0x0074B608, 0x0074BE23, 0x0074B614, 0x0074BEE0, 0x0074BEEE, 0x0074BF1B, 0x0074BF29, 0x0074B644, 0x0074B65E, 0x0074C241, 
						  0x0074C24D, 0x0074C3E5, 0x0074C0B8, 0x0074C0C4, 0x0074C4D5, 0x0074C8FF, 0x0074C94C, 0x0074C11B, 0x0074CB25, 0x0074CB7B, 
						  0x0074CBDD, 0x0074CBFC, 0x0074CC08, 0x0074CC1E, 0x0074CA46, 0x0074CA52, 0x0074CE08, 0x0074CE3F, 0x0074CE8C, 0x0074CA68, 
						  0x0074CEAC, 0x0074CEC1, 0x0074CF41, 0x0074CF60, 0x0074CF9E, 0x0074CFD7, 0x0074D01C, 0x0074D068, 0x0074D084, 0x0074D0A0, 
						  0x0074D0EA, 0x0074D327, 0x0074D36C, 0x0074D171, 0x0074D1B5, 0x0074D208, 0x0074D214, 0x0074D632, 0x0074D641, 0x0074D64D, 
						  0x0074D7B1, 0x0074D7A5, 0x0074D870, 0x0074DF40, 0x0074E2DC, 0x0074E71D, 0x0074E729, 0x0074E7BE, 0x0074E7D4, 0x0074E871, 
						  0x0074E8B4, 0x0074EA9D, 0x0074EBAD, 0x0074ECD7, 0x0074ECE6, 0x0074ED0D, 0x0074ED2B, 0x0074ED50, 0x0074ED61, 0x0074EDFA, 
						  0x0074EEC3, 0x0074F0EE, 0x0074F0FC, 0x0074F10B, 0x0074F119, 0x0074F13C, 0x0074F14A, 0x0074F168, 0x0074EFFD, 0x0074F010, 
						  0x0074F047, 0x0074F055, 0x0074F071, 0x0074F07F, 0x0074F45E, 0x0074F46D, 0x0074F4B1, 0x0074F662, 0x0074F676, 0x0074F8DE, 
						  0x0074F8F0, 0x0074F90B, 0x0074FA40, 0x0074FA55, 0x0074FA64, 0x0074FA8D, 0x0074FAAE, 0x0074FAC9, 0x0074F97E, 0x0074F998, 
						  0x0074F9B2, 0x0074F9C9, 0x0074F9DC, 0x0074FA0E, 0x0074FA1D, 0x0074FA26, 0x0074FBFE, 0x0074FC4D, 0x0074FC59, 0x0074FCDE, 
						  0x0074FD1C, 0x0074FD30, 0x0074FD4C, 0x0074FD79, 0x0074FD8E, 0x0074FDA4, 0x0074FDB8, 0x0074FB2F, 0x0074FB6D, 0x0074FB7F, 
						  0x0074FBD3, 0x0074FBEC, 0x00750250, 0x00750260, 0x0075035E, 0x00750471, 0x00750483, 0x00750784, 0x00750798, 0x007506D0, 
						  0x007506E6, 0x0075070B, 0x00750730, 0x0075073C, 0x00750753, 0x0075076C, 0x00751268, 0x00751287, 0x00751290, 0x00751406, 
						  0x0075154A, 0x007516A2, 0x00751707, 0x00751766, 0x007517A6, 0x007517C2, 0x007515BD, 0x007515E5, 0x0075160C, 0x00751618, 
						  0x0075163B, 0x00751B39, 0x00751B52, 0x00751B5D, 0x00751B7F, 0x00751BA4, 0x00751BAD, 0x00751BB6, 0x00751BCE, 0x00751BFC, 
						  0x00751C8A, 0x00751DCB, 0x00751E0E, 0x00751E38, 0x007518E1, 0x007518ED, 0x0075195E, 0x00751F1E, 0x00751F2F, 0x0075217A, 
						  0x00752181, 0x007522BA, 0x007522C1, 0x007523F8, 0x0075253C, 0x00752371, 0x00752F7A, 0x007531B5, 0x00753242, 0x007532C0, 
						  0x007532D0, 0x00753307, 0x00753322, 0x00753367, 0x00753378, 0x00753651, 0x00753661, 0x00753702, 0x00753741, 0x0075374D, 
						  0x00753D3F, 0x00753D4F, 0x00753D65, 0x00754196, 0x007541A9, 0x007545FF, 0x007557BA, 0x00755868, 0x0075594A, 0x00755B2A, 
						  0x00755FBA, 0x00756F6E, 0x007575BB, 0x007577B2, 0x00757D03, 0x007580FC, 0x00758108, 0x00758125, 0x00758131, 0x00758144, 
						  0x00758710, 0x0075868A, 0x0075869A, 0x007586CA, 0x007586E1, 0x007586EA, 0x00758830, 0x00758C01, 0x00758D16, 0x007588F8, 
						  0x00758904, 0x00758960, 0x00758981, 0x00758F9A, 0x00758FFA, 0x00758DCE, 0x00758DDE, 0x00758E19, 0x00758E41, 0x00758E6B, 
						  0x007591EA, 0x007591F6, 0x00759215, 0x007590FB, 0x00759107, 0x0075939F, 0x007593E5, 0x00759538, 0x00759441, 0x00759676, 
						  0x00759682, 0x007596B1, 0x007596BA, 0x007598BB, 0x007598C7, 0x0075994B, 0x00759962, 0x0075998B, 0x007599A2, 0x007599B5, 
						  0x00759B26, 0x00759B50, 0x00759BB1, 0x00759BE6, 0x00759C03, 0x00759C0C, 0x00759A03, 0x00759C33, 0x00759AA4, 0x00759EF3, 
						  0x00759F11, 0x00759FBA, 0x00759E55, 0x00759E61, 0x00759EB8, 0x00759ED9, 0x0075A07B, 0x0075A240, 0x0075A29C, 0x0075A2BE, 
						  0x0075A13B, 0x0075A2E4, 0x0075A32A, 0x0075A333, 0x0075A35E, 0x0075A3B0, 0x0075A14B, 0x0075A48A, 0x0075A4A9, 0x0075A4BA, 
						  0x0075A4DD, 0x0075A19F, 0x0075A627, 0x0075AD6B, 0x0075ACB6, 0x0075AD12, 0x0075AF8A, 0x0075C5F1, 0x0075C639, 0x0075CB3A, 
						  0x0075CC47, 0x0075CCC6, 0x0075CE0D, 0x0075CE1E, 0x0075EF32, 0x0075EF5E, 0x0075EF6D, 0x0075EFB1, 0x0075EFCF, 0x0075F060, 
						  0x0075F6DC, 0x0075F6EB, 0x0075F8FA, 0x00760252, 0x007604B8, 0x00760610, 0x00760CB4, 0x00760CC9, 0x00760CD5, 0x0076136E, 
						  0x00761468, 0x00761AC7, 0x00761AFA, 0x00761A43, 0x0076199E, 0x007626A3, 0x00762F68, 0x00764038, 0x00764044, 0x00764057, 
						  0x00764072, 0x00764089, 0x00765B9D, 0x00765BB7, 0x00765B1B, 0x00765BD9, 0x00765E15, 0x00765EDE, 0x00765EF3, 0x00765EFE, 
						  0x00765F66, 0x00765FB3, 0x00765FDD, 0x007660D4, 0x007660F4, 0x0076612C, 0x0076613F, 0x00766172, 0x00766251, 0x00765CC0, 
						  0x00765CDC, 0x00765D06, 0x007665AA, 0x00766825, 0x00767173, 0x00767209, 0x007670E4, 0x007670FE, 0x007679E6, 0x00767E5A, 
						  0x0076966C, 0x0076969A, 0x007696C9, 0x007696E8, 0x00769709, 0x00769FA4, 0x0076A983, 0x0076A8BA, 0x0076A90B, 0x0076ABC0, 
						  0x0076ABCE, 0x0076ABE7, 0x0076AC02, 0x0076AC3B, 0x0076AD1C, 0x0076B5DF, 0x0076B9E4, 0x0076BCCE, 0x0076BD0E, 0x0076E883, 
						  0x0076EABD, 0x00771EF8, 0x00773B18, 0x007740C8, 0x00775128, 0x007752F6, 0x0077526E, 0x00775F40, 0x00775F4C, 0x00776138, 
						  0x0077973A, 0x00779A53, 0x00779A80, 0x00779A90, 0x00779AB5, 0x00779AD7, 0x00779B01, 0x00779BAB, 0x00779BC5, 0x00779BDF, 
						  0x00779BF9, 0x00779C3F, 0x00779FE6, 0x0077A055, 0x0077A0A6, 0x00779E83, 0x00779E93, 0x00779EB9, 0x00779F18, 0x0077A29A, 
						  0x0077A2F2, 0x0077A325, 0x0077A356, 0x0077A3A0, 0x0077A3E1, 0x0077A3FA, 0x0077A440, 0x0077A474, 0x0077A486, 0x0077A4D0, 
						  0x0077A1C7, 0x0077A1D7, 0x0077A22C, 0x0077A26F, 0x0077ADBF, 0x0077ADCE, 0x0077B045, 0x0077B1DD, 0x0077B1F5, 0x0077B21E, 
						  0x0077B5D3, 0x0077B5DF, 0x0077B5FE, 0x0077B61E, 0x0077B62C, 0x0077B64D, 0x0077C4D8, 0x0077DEE2, 0x0077DEEE, 0x0077E075, 
						  0x0077E246, 0x0077E252, 0x0077E269, 0x0077E275, 0x0077E306, 0x0077E316, 0x0077E35A, 0x0077E3B3, 0x0077E3C6, 0x0077E1A6, 
						  0x0077E203, 0x0077E23B, 0x0077E4DF, 0x0077E64E, 0x0077E688, 0x0077E566, 0x0077E572, 0x0077E58A, 0x0077FB31, 0x0077FB3D, 
						  0x0077FAD1, 0x0077FAEE, 0x0077FAFA, 0x0077FB11, 0x0077FC0B, 0x00780140, 0x00780156, 0x0078016B, 0x00780177, 0x007801E3, 
						  0x007801F9, 0x0078020F, 0x00780220, 0x00780240, 0x00780251, 0x0078026E, 0x00780281, 0x00780299, 0x007802AF, 0x007802C5, 
						  0x007802E1, 0x00780349, 0x00780085, 0x00780095, 0x007800AB, 0x007800BE, 0x007800D4, 0x007800E3, 0x00780100, 0x0078011F, 
						  0x00780B7A, 0x00780B86, 0x00780B9D, 0x00780BBE, 0x00780BCA, 0x00780D1A, 0x0078122A, 0x0078154A, 0x00781AE5, 0x0078382A, 
						  0x00783A5A, 0x00783F1A, 0x00783F31, 0x00783F48, 0x00783F5F, 0x00783F76, 0x00783F8D, 0x00784129, 0x00784180, 0x00784197, 
						  0x007841AE, 0x00784205, 0x0078421C, 0x00784273, 0x0078472B, 0x00784F72, 0x00784F83, 0x00784FA5, 0x00784FE4, 0x00784FFB, 
						  0x0078504D, 0x007850F0, 0x0078511A, 0x00785168, 0x00785179, 0x0078519C, 0x007851BC, 0x007851CD, 0x007851F3, 0x007854AF, 
						  0x007854CB, 0x007854E7, 0x00785503, 0x0078551F, 0x0078553B, 0x00785557, 0x0078557A, 0x007855AC, 0x007855C8, 0x00785634, 
						  0x0078564D, 0x0078565E, 0x007856B6, 0x007856C9, 0x007856E8, 0x00785701, 0x00785763, 0x00785776, 0x00785795, 0x007857AE, 
						  0x00785BAE, 0x00785BDC, 0x00785BF7, 0x00785C96, 0x00785CC9, 0x00785CDA, 0x00785D0F, 0x00785D36, 0x00785474, 0x00785FDF, 
						  0x00785FF0, 0x00785FFC, 0x0078601B, 0x0078602E, 0x007860FF, 0x007866E3, 0x007868A4, 0x00786B44, 0x00786CC9, 0x00786CD7, 
						  0x00786CEC, 0x00787020, 0x007870C6, 0x007872AD, 0x007872CB, 0x00787101, 0x00787138, 0x0078715D, 0x0078717E, 0x007871C5, 
						  0x007871D9, 0x00787324, 0x007874B9, 0x00787693, 0x0078785D, 0x0078764A, 0x00787B5B, 0x00787FA1, 0x00787DF5, 0x00788140, 
						  0x007882CA, 0x0078819B, 0x00788433, 0x0078844E, 0x007884CC, 0x0078850E, 0x00788553, 0x0078857E, 0x0078859A, 0x007885AC, 
						  0x007885BF, 0x00788665, 0x007886C9, 0x00788711, 0x00788731, 0x00788752, 0x0078876C, 0x00788793, 0x0078892A, 0x00788918, 
						  0x00789358, 0x00789368, 0x00789428, 0x00789458, 0x007899BD, 0x007899CF, 0x007899F4, 0x00789B10, 0x00789B28, 0x007898CB, 
						  0x00789EF4, 0x00789F0D, 0x00789F34, 0x00789F45, 0x00789F5E, 0x00789F87, 0x00789E3D, 0x00789E58, 0x0078A220, 0x0078A141, 
						  0x0078A173, 0x0078A1A9, 0x0078A36D, 0x0078AAC4, 0x0078AACB, 0x0078AB4F, 0x0078AC5F, 0x0078B1BB, 0x0078B1FD, 0x0078B247, 
						  0x0078B4C9, 0x0078B3D2, 0x0078B4E6, 0x0078B3EF, 0x0078B56C, 0x0078B57F, 0x0078B612, 0x0078B75B, 0x0078B778, 0x0078B62F, 
						  0x0078B8B2, 0x0078B95F, 0x0078B974, 0x0078B98F, 0x0078B99E, 0x0078B9B7, 0x0078B9CE, 0x0078BA21, 0x0078BA36, 0x0078BA53, 
						  0x0078BA6E, 0x0078BA7D, 0x0078BA96, 0x0078BAA7, 0x0078BAEB, 0x0078BB02, 0x0078B815, 0x0078B830, 0x0078B858, 0x0078B886, 
						  0x0078B89D, 0x0078BBE4, 0x0078BC07, 0x0078BC2A, 0x0078BC5D, 0x0078BE26, 0x0078BF88, 0x0078BFD9, 0x0078C008, 0x0078BD51, 
						  0x0078C06E, 0x0078BD75, 0x0078BD9E, 0x0078C0F8, 0x0078C108, 0x0078C41D, 0x0078C438, 0x0078C447, 0x0078C460, 0x0078C477, 
						  0x0078C32E, 0x0078C3E9, 0x0078C400, 0x0078C5CE, 0x0078C58E, 0x0078C645, 0x0078C6EB, 0x0078C700, 0x0078C8B0, 0x0078C902, 
						  0x0078C971, 0x0078C980, 0x0078C7B3, 0x0078CA01, 0x0078CA10, 0x0078CA31, 0x0078CA48, 0x0078CA5D, 0x0078CA6E, 0x0078CAA6, 
						  0x0078CADA, 0x0078CAF5, 0x0078CB34, 0x0078CB47, 0x0078CB61, 0x0078CB78, 0x0078CB99, 0x0078CBBE, 0x0078CBF0, 0x0078CC06, 
						  0x0078C7FE, 0x0078C870, 0x0078CD43, 0x0078CE6E, 0x0078CE87, 0x0078CEC6, 0x0078CEDB, 0x0078CF02, 0x0078CF18, 0x0078CDE7, 
						  0x0078CE00, 0x0078CE1E, 0x0078CFBA, 0x0078CFEB, 0x0078CF6E, 0x0078D0CC, 0x0078D0DA, 0x0078D16A, 0x0078D203, 0x0078D2FE, 
						  0x0078DCC7, 0x0078DCE5, 0x0078DC63, 0x0078DC74, 0x0078DD0C, 0x0078DE5D, 0x0078DF54, 0x0078DF65, 0x0078DF91, 0x0078DD74, 
						  0x0078DDA1, 0x0078DDB6, 0x0078DDC1, 0x0078DDD9, 0x0078E1B5, 0x0078E1FB, 0x0078E222, 0x0078E237, 0x0078E25D, 0x0078E0B5, 
						  0x0078E0C0, 0x0078E0D6, 0x0078E0F4, 0x0078E14A, 0x0078E2E8, 0x0078E301, 0x0078E356, 0x0078E4AA, 0x0078E899, 0x0078E706, 
						  0x0078E968, 0x0078E9A5, 0x0078E722, 0x0078E73E, 0x0078E778, 0x0078E7AF, 0x0078E7CA, 0x00795D52, 0x00796022, 0x00796102, 
						  0x0079611F, 0x00796572, 0x0079658C, 0x00796794, 0x0079677A, 0x007968E8, 0x007968F8, 0x0079691C, 0x0079693D, 0x00796958, 
						  0x00796973, 0x00796B7F, 0x00796B9E, 0x00796BC8, 0x00796BDF, 0x00796C02, 0x00796C19, 0x007977EE, 0x0079854C, 0x0079853D, 
						  0x007987D9, 0x007987CB, 0x00798A70, 0x00798A9B, 0x00798ADB, 0x00798B16, 0x00798A51, 0x0079966A, 0x00799728, 0x00799734, 
						  0x0079974A, 0x00799807, 0x00799821, 0x00799C80, 0x00799C8C, 0x00799E59, 0x0079A20B, 0x0079ABC3, 0x0079ADE3, 0x0079AE23, 
						  0x0079AEBE, 0x0079AF72, 0x0079B34A, 0x0079B3D3, 0x0079B413, 0x0079B41E, 0x0079B49F, 0x0079B4AB, 0x0079B635, 0x0079B851, 
						  0x0079B869, 0x0079B892, 0x0079B8B3, 0x0079CC43, 0x0079CC52, 0x0079D42E, 0x0079D444, 0x0079D496, 0x0079D4BB, 0x0079D8E6, 
						  0x0079DACA, 0x0079DADD, 0x0079DB42, 0x0079DB4E, 0x0079DB7E, 0x0079DDE9, 0x0079DE24, 0x0079DE58, 0x0079DF32, 0x0079DF53, 
						  0x0079DF5F, 0x0079DFB6, 0x0079DFD4, 0x0079BECE, 0x0079BEEE, 0x0079C056, 0x0079C0C5, 0x0079C0E5, 0x0079C105, 0x0079C120, 
						  0x0079C132, 0x0079C164, 0x0079C17E, 0x0079C4B2, 0x0079C4C1, 0x0079C8C5, 0x0079E596, 0x0079E6BB, 0x0079EEFF, 0x0079EF17, 
						  0x0079EECC, 0x0079EF75, 0x0079EFB4, 0x0079EF69, 0x0079F02C, 0x0079F514, 0x007A0650, 0x007A065F, 0x007A2E5A, 0x007A2F23, 
						  0x007A3FA1, 0x007A3FB3, 0x007A4381, 0x007A4418, 0x007A4B86, 0x007A5135, 0x007A561E, 0x007A57BF, 0x007A57CB, 0x007A5921, 
						  0x007A592D, 0x007A59A2, 0x007A59B0, 0x007A59C6, 0x007A59DC, 0x007A5D42, 0x007A6381, 0x007A6827, 0x007A683C, 0x007A7220, 
						  0x007A7239, 0x007A7253, 0x007A727D, 0x007A7296, 0x007A72A5, 0x007A72F0, 0x007A7CFC, 0x007A7E74, 0x007A7E80, 0x007A7F13, 
						  0x007A7F41, 0x007A8272, 0x007A8304, 0x007A8319, 0x007A84BE, 0x007A85D1, 0x007A866F, 0x007A8691, 0x007A8A74, 0x007A8B4B, 
						  0x007A8BD7, 0x007A8BF9, 0x007A8EDC, 0x007A900D, 0x007A9095, 0x007A93C8, 0x007A9496, 0x007A94A2, 0x007A9562, 0x007A9590, 
						  0x007A99F6, 0x007A9A88, 0x007A9EBB, 0x007A9FC0, 0x007A9FDE, 0x007AA037, 0x007AB69A, 0x007ABAF7, 0x007ABB5C, 0x007ABB78, 
						  0x007ABDB9, 0x007ABF2B, 0x007AC147, 0x007AC3BC, 0x007AC56E, 0x007AC8B1, 0x007AC8CE, 0x007AC8DC, 0x007AC949, 0x007AC978, 
						  0x007AC9A7, 0x007ACA0C, 0x007ACB85, 0x007ACBE4, 0x007ACBF7, 0x007ACC15, 0x007ACD54, 0x007AD2F8, 0x007AD465, 0x007AD4C4, 
						  0x007AD512, 0x007AD76B, 0x007AD95E, 0x007ADB4C, 0x007AE7E2, 0x007AEABA, 0x007AECC8, 0x007AED68, 0x007AEE18, 0x007AF212, 
						  0x007AF239, 0x007AF25D, 0x007AF284, 0x007AF2AB, 0x007AF2D8, 0x007AF319, 0x007AF351, 0x007AF3CA, 0x007AF195, 0x007AF1CA, 
						  0x007AF1EE, 0x007AFA7A, 0x007AFA92, 0x007AFB8C, 0x007AFCE8, 0x007AFD0C, 0x007B006C, 0x007B0294, 0x007B0706, 0x007B0873, 
						  0x007B0EAC, 0x007B22D0, 0x007B27C1, 0x007B27CD, 0x007B2811, 0x007B282B, 0x007B2837, 0x007B141D, 0x007B1485, 0x007B1495, 
						  0x007B1521, 0x007B152D, 0x007B1547, 0x007B1558, 0x007B157D, 0x007B1597, 0x007B1793, 0x007B1877, 0x007B1895, 0x007B1958, 
						  0x007B1964, 0x007B1D75, 0x007B229A, 0x007B2C64, 0x007B33EC, 0x007B34F1, 0x007B30C7, 0x007B30D3, 0x007B377E, 0x007B378A, 
						  0x007B38DD, 0x007B38E9, 0x007B397F, 0x007B3C82, 0x007B4124, 0x007B4191, 0x007B425B, 0x007B427A, 0x007B40D0, 0x007B40E0, 
						  0x007B40F2, 0x007B440F, 0x007B45DD, 0x007B4AE4, 0x007B4B12, 0x007B4B47, 0x007B4B7D, 0x007B4C34, 0x007B4C61, 0x007B49C2, 
						  0x007B4E0C, 0x007B4E18, 0x007B5055, 0x007B5061, 0x007B514E, 0x007B515C, 0x007B5183, 0x007B518F, 0x007B51A2, 0x007B57AF, 
						  0x007B5821, 0x007B582D, 0x007B590F, 0x007B591E, 0x007B5EA4, 0x007B5EB8, 0x007B62F7, 0x007B644F, 0x007B62AF, 0x007B65BE, 
						  0x007B6C09, 0x007B65E5, 0x007B714A, 0x007B715E, 0x007B717F, 0x007B71FD, 0x007B7432, 0x007B7720, 0x007B7736, 0x007B77AD, 
						  0x007B77BD, 0x007B77CB, 0x007B77DB, 0x007B783E, 0x007B7860, 0x007B7657, 0x007B76B4, 0x007B76EE, 0x007B76FE, 0x007B7A18, 
						  0x007B7A24, 0x007B7A38, 0x007B7BD8, 0x007B7BFE, 0x007B7C0E, 0x007B7C23, 0x007B7C2C, 0x007B7C5E, 0x007B7F53, 0x007B800F, 
						  0x007B80CA, 0x007B80D6, 0x007B8119, 0x007B8139, 0x007B820B, 0x007B8227, 0x007B823D, 0x007B8847, 0x007B8880, 0x007B889C, 
						  0x007B88BA, 0x007B88DB, 0x007B88FC, 0x007B8B31, 0x007B8B46, 0x007B8D19, 0x007B92BE, 0x007B92F1, 0x007B968B, 0x007B9697, 
						  0x007B97B8, 0x007B97C8, 0x007B952C, 0x007B9AE9, 0x007B9B2E, 0x007BBDFA, 0x007BACE7, 0x007BAD35, 0x007BAD53, 0x007BAD6D, 
						  0x007BAD76, 0x007BAD90, 0x007BADAA, 0x007BADC8, 0x007BAE24, 0x007BAED6, 0x007BAF3E, 0x007BB128, 0x007BB14C, 0x007BB25D, 
						  0x007BAA89, 0x007BB300, 0x007BB30F, 0x007BB3FC, 0x007BB40B, 0x007BB442, 0x007BB460, 0x007BB49F, 0x007BB4C3, 0x007BB588, 
						  0x007BB5D6, 0x007BB61D, 0x007BB66B, 0x007BB6A0, 0x007BB6E4, 0x007BB710, 0x007BAAD3, 0x007BB74D, 0x007BB7D0, 0x007BB92E, 
						  0x007BC767, 0x007BC79B, 0x007BC7CA, 0x007BC7E2, 0x007BC7EE, 0x007BC7F7, 0x007BC91D, 0x007BC951, 0x007BC980, 0x007BC9AD, 
						  0x007BC9B9, 0x007BC9C2, 0x007BCAE8, 0x007BCB1C, 0x007BCB4B, 0x007BCB78, 0x007BCB84, 0x007BCB8D, 0x007BCBFF, 0x007BCCC9, 
						  0x007BCD95, 0x007BCDCA, 0x007BCDE4, 0x007BCDF7, 0x007BCE09, 0x007BCE21, 0x007BCE2D, 0x007BC670, 0x007BC684, 0x007BDDA5, 
						  0x007BDDC1, 0x007BE1F8, 0x007BE20F, 0x007BE9C4, 0x007BEDF0, 0x007BEF15, 0x007BEF4C, 0x007BEF6E, 0x007BEF8D, 0x007BF270, 
						  0x007BF49D, 0x007BF5BF, 0x007BF5ED, 0x007BF5F9, 0x007BF7AE, 0x007BF7BE, 0x007BF7D4, 0x007BF7E7, 0x007BF80F, 0x007BF843, 
						  0x007BF85B, 0x007BF8CC, 0x007BF8D8, 0x007BF963, 0x007BF96F, 0x007BF9A1, 0x007C0102, 0x007C0112, 0x007C016E, 0x007C0197, 
						  0x007C001F, 0x007C002B, 0x007C00A9, 0x007C00B7, 0x007C03FF, 0x007C04D6, 0x007C04EE, 0x007C050A, 0x007C05A3, 0x007C066D, 
						  0x007C0784, 0x007C0794, 0x007C07C3, 0x007C0324, 0x007C0A14, 0x007C0B6D, 0x007C0BA0, 0x007C0C64, 0x007C0D15, 0x007C0D40, 
						  0x007C0EBF, 0x007C10E0, 0x007C12CB, 0x007C1313, 0x007C1901, 0x007C1930, 0x007C19A4, 0x007C1E95, 0x007C1FBB, 0x007C2767, 
						  0x007C2785, 0x007C27C0, 0x007C3C8D, 0x007C3C99, 0x007C3AC5, 0x007C424D, 0x007C4369, 0x007C4574, 0x007C5326, 0x007C5332, 
						  0x007C5345, 0x007C5373, 0x007C53D2, 0x007C53E2, 0x007C58DC, 0x007C5FC2, 0x007C6001, 0x007C6277, 0x007C62B7, 0x007C6340, 
						  0x007C6781, 0x007C6882, 0x007C6D88, 0x007C6A74, 0x007C7E15, 0x007C7FBC, 0x007C8410, 0x007C841C, 0x007C861B, 0x007C86B5, 
						  0x007C88F8, 0x007C8921, 0x007C89EC, 0x007C8A0C, 0x007C8530, 0x007C90A1, 0x007C8FB7, 0x007C8FD6, 0x007C9003, 0x007C92EE, 
						  0x007C92FA, 0x007C95EA, 0x007C98DC, 0x007C98E9, 0x007C99F3, 0x007C9A28, 0x007C9A55, 0x007C9754, 0x007C9788, 0x007C97BE, 
						  0x007C97E3, 0x007C9DC4, 0x007C9E0B, 0x007C9E43, 0x007C9E6A, 0x007C9C80, 0x007C9C8C, 0x007C9CDC, 0x007C9CEC, 0x007C9D18, 
						  0x007CA106, 0x007CA311, 0x007CA31D, 0x007CA330, 0x007CA34F, 0x007CA35F, 0x007CA378, 0x007CA38E, 0x007CA397, 0x007CA3AD, 
						  0x007CA3C5, 0x007CA3D4, 0x007CA3EA, 0x007CA402, 0x007CA41E, 0x007CA43C, 0x007CA445, 0x007CA45D, 0x007CA466, 0x007CA488, 
						  0x007CA4B1, 0x007CA4CD, 0x007CA4E6, 0x007CA4FE, 0x007CA51A, 0x007CA530, 0x007CA548, 0x007CA55F, 0x007CA56B, 0x007CA57F, 
						  0x007CA588, 0x007CA5A3, 0x007CA5BC, 0x007CA5FA, 0x007CA603, 0x007CA61B, 0x007CA624, 0x007CA687, 0x007CA299, 0x007CA2AE, 
						  0x007CAB1A, 0x007CAB2E, 0x007CAFA6, 0x007CAFD0, 0x007CAFF3, 0x007CB014, 0x007CB1BD, 0x007CB1F5, 0x007CB126, 0x007CB144, 
						  0x007CB19A, 0x007CB249, 0x007CB2BA, 0x007CB2C8, 0x007CB2F9, 0x007CB6AB, 0x007CB737, 0x007CB815, 0x007CBE38, 0x007CBF45, 
						  0x007CC0AE, 0x007CCB76, 0x007CD3F4, 0x007CD404, 0x007CD421, 0x007CD4F4, 0x007CD504, 0x007CD521, 0x007CD8F0, 0x007CD909, 
						  0x007CD951, 0x007CD961, 0x007CD976, 0x007CD98C, 0x007CD9E8, 0x007CD88B, 0x007CD897, 0x007CDCF0, 0x007CE0DC, 0x007CE0F2, 
						  0x007CDF1A, 0x007CE318, 0x007CE328, 0x007CE336, 0x007CDF7C, 0x007CDFA1, 0x007CDFBD, 0x007CE3F4, 0x007CE7DE, 0x007CEB88, 
						  0x007CEBA1, 0x007CF21F, 0x007CF332, 0x007CF35C, 0x007CF30C, 0x007CF773, 0x007CFAB4, 0x007CFBF0, 0x007CFBFF, 0x007D0325, 
						  0x007D033B, 0x007D0351, 0x007D0319, 0x007D04CF, 0x007D0577, 0x007D0583, 0x007D05C3, 0x007D0621, 0x007D0633, 0x007D064F, 
						  0x007D067E, 0x007D0698, 0x007D06AE, 0x007D06FF, 0x007D0783, 0x007D0ABC, 0x007D0C69, 0x007D0E6E, 0x007D0ED3, 0x007D0E20, 
						  0x007D1234, 0x007D1273, 0x007D1387, 0x007D13E9, 0x007D0FAC, 0x007D1502, 0x007D15A5, 0x007D16DD, 0x007D1741, 0x007D1751, 
						  0x007D1762, 0x007D17BB, 0x007D17D5, 0x007D17DE, 0x007D17F1, 0x007D1807, 0x007D182B, 0x007D184E, 0x007D1865, 0x007D0FF1, 
						  0x007D18A0, 0x007D194D, 0x007D1971, 0x007D199E, 0x007D19C2, 0x007D1C22, 0x007D1C5C, 0x007D1C80, 0x007D1DB9, 0x007D1FFF, 
						  0x007D1F17, 0x007D22D4, 0x007D22E4, 0x007D232D, 0x007D2347, 0x007D2350, 0x007D2363, 0x007D2379, 0x007D239D, 0x007D23D0, 
						  0x007D261B, 0x007D2638, 0x007D2673, 0x007D268F, 0x007D26A4, 0x007D26C1, 0x007D26DA, 0x007D24F7, 0x007D258F, 0x007D2870, 
						  0x007D290A, 0x007D29D9, 0x007D2A09, 0x007D2A28, 0x007D2A7E, 0x007D2A9D, 0x007D2ABB, 0x007D2AD9, 0x007D2AE2, 0x007D2AFD, 
						  0x007D2B32, 0x007D2B48, 0x007D2B6C, 0x007D2BFA, 0x007D2C03, 0x007D27AD, 0x007D2C46, 0x007D2C73, 0x007D2CE8, 0x007D2CFB, 
						  0x007D27BC, 0x007D2F87, 0x007D2F9A, 0x007D30A1, 0x007D30B1, 0x007D30D6, 0x007D30FA, 0x007D3129, 0x007D3143, 0x007D314C, 
						  0x007D315F, 0x007D3175, 0x007D2E48, 0x007D3199, 0x007D31CC, 0x007D31E8, 0x007D31F9, 0x007D3202, 0x007D3219, 0x007D3272, 
						  0x007D32E5, 0x007D32F8, 0x007D2E65, 0x007D2EBB, 0x007D3531, 0x007D3547, 0x007D359A, 0x007D360A, 0x007D33FC, 0x007D3799, 
						  0x007D37C6, 0x007D3428, 0x007D392E, 0x007D393A, 0x007D39D4, 0x007D39FF, 0x007D3A0B, 0x007D3A2A, 0x007D401E, 0x007D4298, 
						  0x007D4678, 0x007D46D1, 0x007D479F, 0x007D47DA, 0x007D47FD, 0x007D4818, 0x007D486D, 0x007D428C, 0x007D4A53, 0x007D4A72, 
						  0x007D49A9, 0x007D49CC, 0x007D49F1, 0x007D4A03, 0x007D4A1C, 0x007D4A34, 0x007D5358, 0x007D5416, 0x007D5424, 0x007D5446, 
						  0x007D5E1F, 0x007D65E8, 0x007D6773, 0x007D67A3, 0x007D6D4F, 0x007D6D5B, 0x007D6D90, 0x007D6DF1, 0x007D6E0B, 0x007D7338, 
						  0x007D7448, 0x007D74C9, 0x007D74D5, 0x007D7513, 0x007D76E7, 0x007D7701, 0x007D7834, 0x007D7FA8, 0x007D81BC, 0x007D81CF, 
						  0x007D85C0, 0x007D85D0, 0x007D9376, 0x007D93A3, 0x007D986E, 0x007D98A4, 0x007D994A, 0x007D999D, 0x007DA022, 0x007DA0EB, 
						  0x007DA127, 0x007DA20E, 0x007DA357, 0x007DA3AD, 0x007DA560, 0x007DA57A, 0x007DA441, 0x007DA4D2, 0x007DA4FD, 0x007DA621, 
						  0x007DA68D, 0x007DA6A8, 0x007DA6B1, 0x007DA88A, 0x007DA771, 0x007DA7E9, 0x007DA7F9, 0x007DA80B, 0x007DA9E0, 0x007DAA36, 
						  0x007DAB5C, 0x007DAC6C, 0x007DADD1, 0x007DB04B, 0x007DAFB9, 0x007DB0B3, 0x007DB672, 0x007DB69D, 0x007DB62B, 0x007DBFA2, 
						  0x007DBFBF, 0x007DBFD8, 0x007DC007, 0x007DC029, 0x007DC162, 0x007DC7A8, 0x007DCB64, 0x007DCFF1, 0x007DD01A, 0x007DD0EE, 
						  0x007DD117, 0x007DCF24, 0x007DCF4D, 0x007DCF62, 0x007DD2CA, 0x007DD2E8, 0x007DD31A, 0x007DD208, 0x007DD237, 0x007DD248, 
						  0x007DD278, 0x007DD509, 0x007DD59F, 0x007DD767, 0x007DD687, 0x007DD90F, 0x007DD931, 0x007DD94B, 0x007DD95D, 0x007DD984, 
						  0x007DD98D, 0x007DD9BC, 0x007DD9E7, 0x007DDA1C, 0x007DDA43, 0x007DDA58, 0x007DD879, 0x007DDBD2, 0x007DDC1C, 0x007DDB31, 
						  0x007DDB8B, 0x007DDDD7, 0x007DDDF3, 0x007DDE04, 0x007DDE1E, 0x007DDE6D, 0x007DDEA1, 0x007DDEC7, 0x007DDCCA, 0x007DDD27, 
						  0x007DE050, 0x007DE0A8, 0x007DE14B, 0x007DE2DC, 0x007DE1DB, 0x007DE240, 0x007DE274, 0x007DE2AA, 0x007DE363, 0x007DE5DE, 
						  0x007DE647, 0x007DE725, 0x007DE914, 0x007DE940, 0x007DEAC7, 0x007DEB94, 0x007DEC1F, 0x007DEC2E, 0x007DECEB, 0x007DEE06, 
						  0x007DEE20, 0x007DEFF5, 0x007DF044, 0x007DF390, 0x007DF2AF, 0x007DF2F3, 0x007DF483, 0x007DF4AB, 0x007DF3FE, 0x007DF58E, 
						  0x007DF63E, 0x007DF64A, 0x007DF6DB, 0x007DF6E7, 0x007DF884, 0x007DF7B0, 0x007DF7E3, 0x007DF7EF, 0x007DF846, 0x007DF855, 
						  0x007DF86D, 0x007DFB94, 0x007DFCFC, 0x007DFD0B, 0x007DFD23, 0x007DFD3A, 0x007DFDBB, 0x007DFE0E, 0x007DFE1D, 0x007DFE46, 
						  0x007E005C, 0x007E006C, 0x007E06A0, 0x007E06D0, 0x007E06DB, 0x007E0706, 0x007E0A59, 0x007E0A6D, 0x007E0A87, 0x007E0AA5, 
						  0x007E0AE2, 0x007E0B6B, 0x007E0BA6, 0x007E0C19, 0x007E0CCB, 0x007E0EC9, 0x007E0F71, 0x007E0DE5, 0x007E0DFB, 0x007E10B7, 
						  0x007E10C8, 0x007E14C7, 0x007E14DB, 0x007E14F1, 0x007E14B7, 0x007E1742, 0x007E1761, 0x007E176D, 0x007E1B24, 0x007E1B46, 
						  0x007E256F, 0x007E2582, 0x007E259C, 0x007E25C6, 0x007E29ED, 0x007E28F8, 0x007E2921, 0x007E29CB, 0x007E2C5E, 0x007E2EE1, 
						  0x007E2F0D, 0x007E3082, 0x007E33B1, 0x007E343E, 0x007E346A, 0x007E347E, 0x007E3575, 0x007E3605, 0x007E3636, 0x007E3646, 
						  0x007E36AD, 0x007E36C5, 0x007E3A07, 0x007E3A45, 0x007E3A8C, 0x007E3966, 0x007E4084, 0x007E40D9, 0x007E4DB0, 0x007E4DE6, 
						  0x007E593A, 0x007E5B68, 0x007E5B80, 0x007E5CCC, 0x007E5DAB, 0x007E5DD5, 0x007E5DFF, 0x007E5F11, 0x007E5F1D, 0x007E5FEB, 
						  0x007E606B, 0x007E620B, 0x007E625B, 0x007E62AB, 0x007E637B, 0x007E65D8, 0x007E65EA, 0x007E669C, 0x007E66AC, 0x007E66C6, 
						  0x007E66EA, 0x007E6720, 0x007E674B, 0x007E6761, 0x007E6AD3, 0x007E6ADC, 0x007E6AEE, 0x007E6B06, 0x007E6B16, 0x007E69D8, 
						  0x007E69E8, 0x007E6A02, 0x007E6A1C, 0x007E6A50, 0x007E6A78, 0x007E6A9B, 0x007E6AB8, 0x007E6EE4, 0x007E8324, 0x007E8343, 
						  0x007E8A4A, 0x007E8A51, 0x007E8FBE, 0x007E907A, 0x007E914A, 0x007E91FA, 0x007E9238, 0x007E9244, 0x007E9258, 0x007E9279, 
						  0x007E99CA, 0x007E9A2A, 0x007E9A8A, 0x007E9F2E, 0x007E9F59, 0x007E9DBC, 0x007E9F96, 0x007E9DC8, 0x007E9E37, 0x007E9E6A, 
						  0x007E9E91, 0x007EA672, 0x007EA69C, 0x007EB5CC, 0x007EB611, 0x007EB67A, 0x007EB6BF, 0x007EB82F, 0x007EBAFC, 0x007EC71E, 
						  0x007ED45C, 0x007ED6BB, 0x007ED6D4, 0x007ED6F2, 0x007ED8FA, 0x007ED9A2, 0x007EDA22, 0x007EDAF8, 0x007EDB09, 0x007EDB66, 
						  0x007EDBA9, 0x007EDCF8, 0x007EDDF6, 0x007EDE02, 0x007EDE25, 0x007EDFEB, 0x007EE029, 0x007EE163, 0x007EE17A, 0x007EE1AB, 
						  0x007EE1B7, 0x007EE29F, 0x007EE2F1, 0x007EE2FD, 0x007EE312, 0x007EDF13, 0x007EDF2A, 0x007EDF91, 0x007EDF9F, 0x007EDFBD, 
						  0x007EE48B, 0x007EE4DF, 0x007EE3A0, 0x007EE40A, 0x007EE418, 0x007EFA6D, 0x007EFA79, 0x007EEB1C, 0x007EFB5C, 0x007EFB7A, 
						  0x007EFBDA, 0x007EFC0A, 0x007EFC16, 0x007EFC3C, 0x007EFD31, 0x007EFD4B, 0x007EFD66, 0x007EFD7D, 0x007EFD90, 0x007EFDB1, 
						  0x007EFDC4, 0x007EFDF7, 0x007EFE07, 0x007EFE13, 0x007EFE98, 0x007EFEA4, 0x007EFEE0, 0x007EFF3D, 0x007EFF60, 0x007EEBBF, 
						  0x007EEBCF, 0x007EECA5, 0x007EED1E, 0x007EEDB7, 0x007EEE49, 0x007EEE6B, 0x007EEE77, 0x007EEFC2, 0x007EEFE5, 0x007EF000, 
						  0x007EF088, 0x007EF098, 0x007EF0B1, 0x007EF0BD, 0x007EF295, 0x007EF323, 0x007EF332, 0x007EF348, 0x007EF370, 0x007EF3C0, 
						  0x007EF3F1, 0x007EF427, 0x007EF5C9, 0x007EF64B, 0x007EF657, 0x007EF698, 0x007EF717, 0x007EF7B2, 0x007EF84B, 0x007EF857, 
						  0x007EF8F4, 0x007EF900, 0x007EEB09, 0x007F0304, 0x007F034E, 0x007F0362, 0x007F0578, 0x007F05BC, 0x007F05D6, 0x007F0690, 
						  0x007F069C, 0x007F0BC4, 0x007F0BDD, 0x007F0C34, 0x007F0F45, 0x007F0FF9, 0x007F0E7C, 0x007F0EE9, 0x007F116A, 0x007F11D3, 
						  0x007F1222, 0x007F1732, 0x007F1620, 0x007F167F, 0x007F1690, 0x007F19A9, 0x007F1A1A, 0x007F18FC, 0x007F1914, 0x007F1ABC, 
						  0x007F1C74, 0x007F1CA0, 0x007F1BAD, 0x007F1BD4, 0x007F1C1F, 0x007F1DB2, 0x007F1DE4, 0x007F1E10, 0x007F1F37, 0x007F1F66, 
						  0x007F2281, 0x007F228D, 0x007F243C, 0x007F230D, 0x007F2349, 0x007F250D, 0x007F2811, 0x007F2836, 0x007F2842, 0x007F28AC, 
						  0x007F3B73, 0x007F3BAD, 0x007F3BE5, 0x007F3C18, 0x007F3C30, 0x007F3C40, 0x007F3C4D, 0x007F2D93, 0x007F2DA2, 0x007F2AC7, 
						  0x007F3103, 0x007F314F, 0x007F2AD5, 0x007F3563, 0x007F35D5, 0x007F36E1, 0x007F36F5, 0x007F39B9, 0x007F39C8, 0x007F415A, 
						  0x007F4168, 0x007F44FF, 0x007F46A1, 0x007F46B9, 0x007F48DF, 0x007F4A21, 0x007F4A43, 0x007F4A51, 0x007F4A8D, 0x007F4AB2, 
						  0x007F4F54, 0x007F4F80, 0x007F4FC7, 0x007F4FED, 0x007F529A, 0x007F5522, 0x007F55B9, 0x007F55CF, 0x007F5669, 0x007F56F2, 
						  0x007F5709, 0x007F5717, 0x007F58FB, 0x007F5A09, 0x007F5BC0, 0x007F5C1D, 0x007F5C86, 0x007F5DDE, 0x007F5DBC, 0x007F5FCB, 
						  0x007F5FD7, 0x007F6419, 0x007F66F7, 0x007F6B66, 0x007F6C47, 0x007F6D73, 0x007F7145, 0x007F716E, 0x007F71AB, 0x007F71C3, 
						  0x007F7309, 0x007F7713, 0x007F9EA7, 0x007F9EB5, 0x007F9F3D, 0x007F9F4D, 0x007FA2E0, 0x007FA337, 0x007FA456, 0x007FA4CE, 
						  0x007FA73F, 0x007FABDA, 0x007FC329, 0x007FC352, 0x007FC54E, 0x007FC93A, 0x007FCF40, 0x007FCF56, 0x007FCFFD, 0x007FD33D, 
						  0x007FD353, 0x007FD36D, 0x007FD381, 0x007FD524, 0x007FD53A, 0x007FD5AD, 0x007FD8DC, 0x007FD8E9, 0x007FD8FD, 0x007FD909, 
						  0x007FD92F, 0x007FD93F, 0x007FDA91, 0x007FDA9D, 0x007FD9C8, 0x007FDA40, 0x007FDA54, 0x007FDA6C, 0x007FDB1C, 0x007FE82D, 
						  0x007FE79D, 0x007FE7B4, 0x007FEA8B, 0x007FED31, 0x007FED48, 0x007FED69, 0x007FED81, 0x007FED96, 0x007FF07C, 0x007FF093, 
						  0x007FF0B4, 0x007FF0CC, 0x007FF0E1, 0x007FF3CC, 0x007FF3E3, 0x007FF404, 0x007FF41C, 0x007FF431, 0x007FF760, 0x007FF776, 
						  0x007FF78E, 0x007FF7A3, 0x007FF9EB, 0x007FFA01, 0x007FFA19, 0x007FFA2E, 0x007FFC7B, 0x007FFC91, 0x007FFCA9, 0x007FFCBE, 
						  0x007FFEC3, 0x007FFED6, 0x0080039A, 0x008003A8, 0x008003BF, 0x00801051, 0x0080105F, 0x00801076, 0x00802168, 0x00802301, 
						  0x00802324, 0x008021FC, 0x0080220C, 0x008027BE, 0x008026BB, 0x008026CB, 0x00802738, 0x00802747, 0x00802759, 0x008029A2, 
						  0x008029F9, 0x00802A22, 0x00802A35, 0x0080286E, 0x0080287A, 0x00802D41, 0x00802D90, 0x00802932, 0x00803687, 0x00803726, 
						  0x00803997, 0x008039F5, 0x008037AD, 0x00803D30, 0x00803D81, 0x00803B06, 0x00803E4A, 0x00803EE2, 0x0080408E, 0x0080428C, 
						  0x008042E7, 0x00804118, 0x00804597, 0x008045E5, 0x008043D1, 0x00805921, 0x008059F8, 0x00805AD8, 0x00806813, 0x008069B0, 
						  0x008069C0, 0x008069DA, 0x008069F6, 0x00806A09, 0x00806A1F, 0x00806A41, 0x00806A50, 0x00806A62, 0x00806B63, 0x00806BB8, 
						  0x00806BC4, 0x00806BDC, 0x00806BF4, 0x00806C0C, 0x00806C1E, 0x00806F46, 0x00807659, 0x008076DF, 0x008076FD, 0x00807B64, 
						  0x00807B70, 0x00807B83, 0x00807B94, 0x00807BAC, 0x00807C70, 0x00807C7C, 0x00807D0D, 0x00807D19, 0x00807A23, 0x00807D46, 
						  0x00807D52, 0x00807F13, 0x00807F1F, 0x00807F53, 0x00807F5F, 0x00807FBE, 0x00807FCA, 0x0080804C, 0x00808058, 0x0080822E, 
						  0x0080823A, 0x0080828B, 0x00808297, 0x0080830B, 0x00808317, 0x008081EE, 0x008081FA, 0x008083DB, 0x008083F4, 0x00808416, 
						  0x00808DDA, 0x00808DE6, 0x00808E34, 0x008090DC, 0x0080910D, 0x00809125, 0x0080914E, 0x0080915E, 0x0080916E, 0x00808F65, 
						  0x00808F7D, 0x00808FCA, 0x00808FF5, 0x008091CB, 0x008091F6, 0x0080921D, 0x00809295, 0x00809794, 0x00809919, 0x00809DA7, 
						  0x00809DB3, 0x00809CA4, 0x00809CB0, 0x00809D19, 0x00809F34, 0x0080A2D7, 0x0080A31B, 0x0080AEC4, 0x0080B019, 0x0080B379, 
						  0x0080B4AD, 0x0080B597, 0x0080B349, 0x0080B91E, 0x0080B9BF, 0x0080B8CA, 0x0080BD23, 0x0080BD4E, 0x0080BD5A, 0x0080BEB6, 
						  0x0080BEC6, 0x0080C0BF, 0x0080C154, 0x0080C276, 0x0080C282, 0x0080C2CE, 0x0080C2DA, 0x0080C31F, 0x0080C32B, 0x0080C377, 
						  0x0080C383, 0x0080C48E, 0x0080C49C, 0x0080C4B4, 0x0080C52C, 0x0080C538, 0x0080C550, 0x0080C58D, 0x0080BE2F, 0x0080C67A, 
						  0x0080C686, 0x0080C6C4, 0x0080C6DC, 0x0080C764, 0x0080BE88, 0x0080BE96, 0x0080CE77, 0x0080D0E3, 0x0080D0EF, 0x0080D18E, 
						  0x0080D1B9, 0x0080D1C7, 0x0080D329, 0x0080D354, 0x0080D360, 0x0080D39E, 0x0080D3B6, 0x0080D437, 0x0080D4F5, 0x0080D916, 
						  0x0080DB55, 0x0080DB69, 0x0080DBAD, 0x0080DC59, 0x0080DC65, 0x0080DC89, 0x0080DCC3, 0x0080DA4D, 0x0080DD0A, 0x0080DD35, 
						  0x0080DD94, 0x0080DDAD, 0x0080DA59, 0x0080DDC7, 0x0080DDDF, 0x0080DDFB, 0x0080DE40, 0x0080DE82, 0x0080DED2, 0x0080DF11, 
						  0x0080DF30, 0x0080DF6D, 0x0080DF87, 0x0080DF9F, 0x0080DFBA, 0x0080DA8E, 0x0080E123, 0x0080E181, 0x0080E032, 0x0080E05D, 
						  0x0080E07B, 0x0080E0B7, 0x0080E485, 0x0080E493, 0x0080E4B1, 0x0080E4BF, 0x0080E51D, 0x0080E57C, 0x0080E59E, 0x0080E5B3, 
						  0x0080E39F, 0x0080E3AB, 0x0080E70A, 0x0080E71C, 0x0080E7B6, 0x0080E7DA, 0x0080E80C, 0x0080E86C, 0x0080E69E, 0x0080E6D6, 
						  0x0080E9EE, 0x0080E8CD, 0x0080E8D9, 0x0080E902, 0x0080E918, 0x0080E930, 0x0080E961, 0x0080E990, 0x0080EC10, 0x0080EC1C, 
						  0x0080EC33, 0x0080ED11, 0x0080ED1D, 0x0080ED30, 0x0080EA92, 0x0080EDAB, 0x0080EDB7, 0x0080EDE9, 0x0080EE1B, 0x0080EE85, 
						  0x0080EED6, 0x0080EEFB, 0x0080EF36, 0x0080EF5F, 0x0080EFE3, 0x0080EFF5, 0x0080F0E4, 0x0080F0FA, 0x0080EAE3, 0x0080EAEF, 
						  0x0080EB06, 0x0080EB34, 0x0080EB40, 0x0080EB53, 0x0080F318, 0x0080F384, 0x0080F3B4, 0x0080F291, 0x00810011, 0x0081002F, 
						  0x00810090, 0x008100BF, 0x0081013E, 0x0081015A, 0x0080FF37, 0x008101DA, 0x00810207, 0x0081023E, 0x0080FF51, 0x0080FF6E, 
						  0x0080FF91, 0x0080FFBC, 0x0080FFEF, 0x008102F7, 0x008103A8, 0x00810566, 0x00810817, 0x00810825, 0x00810A3C, 0x00810A4E, 
						  0x00810A67, 0x00810A7F, 0x0081102F, 0x0081103F, 0x00810F66, 0x00810F75, 0x00810F94, 0x008111A0, 0x008110AF, 0x0081147E, 
						  0x00811914, 0x00811920, 0x00811AC6, 0x00811AF0, 0x00811B06, 0x00811B1C, 0x00811B34, 0x00811BAD, 0x00811BD2, 0x00811C66, 
						  0x00811C7E, 0x00811C98, 0x00811CC4, 0x00811CD4, 0x00811CFC, 0x00811D21, 0x00811DB4, 0x00811E0A, 0x00811EEC, 0x00811F2C, 
						  0x00811F38, 0x00811F4C, 0x00811F66, 0x00811F7E, 0x00811F9A, 0x00811FDE, 0x00812042, 0x00812101, 0x00811A38, 0x00812181, 
						  0x008121B2, 0x008121BE, 0x00812228, 0x00812251, 0x008122E2, 0x008122FA, 0x00812314, 0x00812333, 0x0081234D, 0x00812365, 
						  0x00812381, 0x008123C0, 0x008123EC, 0x0081242D, 0x00812447, 0x00811A69, 0x0081245F, 0x0081247B, 0x00811A8B, 0x00812602, 
						  0x0081260E, 0x008126B2, 0x00812793, 0x008127A4, 0x008127D3, 0x00812559, 0x00812584, 0x00812590, 0x008125AA, 0x008125C9, 
						  0x008125E7, 0x0081293E, 0x0081294A, 0x00812A00, 0x00812A1E, 0x0081286F, 0x0081289A, 0x008128A6, 0x008128E1, 0x008128FF, 
						  0x00812C40, 0x00813242, 0x00813318, 0x00813335, 0x00813714, 0x00813CA9, 0x00813D6B, 0x00813E8B, 0x00813ED9, 0x00813F42, 
						  0x00814000, 0x00814476, 0x0081449C, 0x008144C9, 0x008144F5, 0x0081468E, 0x00814845, 0x008147AB, 0x008147D0, 0x00815B46, 
						  0x00815B52, 0x00814B65, 0x00815C22, 0x00815D57, 0x00815D81, 0x00814B84, 0x00815D91, 0x00815DC9, 0x00815E04, 0x00815E58, 
						  0x00815E64, 0x00814B9A, 0x00814BA6, 0x00816008, 0x00816014, 0x00814BBC, 0x00816234, 0x00816250, 0x00814BD4, 0x008162DC, 
						  0x00816301, 0x00814C18, 0x00814C99, 0x00814CE1, 0x00814D07, 0x00814D13, 0x00814D2B, 0x00814D3B, 0x00814DCF, 0x00814DE7, 
						  0x00814E18, 0x00814E4B, 0x00814A91, 0x00814E67, 0x00814E91, 0x00814ED6, 0x00814EE6, 0x00814EFE, 0x00814F14, 0x00814FC6, 
						  0x00814FDA, 0x00814FE6, 0x00814FFB, 0x00814ABF, 0x0081515E, 0x0081516A, 0x008151A8, 0x008151F8, 0x00815266, 0x00814AE0, 
						  0x008153B7, 0x008153CB, 0x008153E1, 0x008153F6, 0x00815475, 0x00815487, 0x008154D8, 0x00815542, 0x00815564, 0x008155B8, 
						  0x00814B11, 0x00815711, 0x00814B1D, 0x0081581D, 0x008159C0, 0x008159D2, 0x00815A19, 0x00817452, 0x00817461, 0x00817476, 
						  0x00817495, 0x008174A1, 0x008174B3, 0x008174DE, 0x00817536, 0x008164CB, 0x00817599, 0x0081760F, 0x00817642, 0x00817667, 
						  0x0081769F, 0x008176CC, 0x008176E6, 0x00817736, 0x00817773, 0x008177A6, 0x008177B8, 0x00817871, 0x0081789E, 0x008178B5, 
						  0x008178D8, 0x008178F0, 0x00817905, 0x0081650D, 0x00816519, 0x0081654D, 0x00816585, 0x00816591, 0x008165A4, 0x0081667E, 
						  0x0081668E, 0x0081677F, 0x0081678B, 0x008167EB, 0x008167FB, 0x008168C7, 0x008168DF, 0x00816901, 0x00816A5C, 0x00816B01, 
						  0x00816B10, 0x00816B43, 0x00816B73, 0x00816B95, 0x00816BCA, 0x00816BF4, 0x00816C24, 0x00816C35, 0x00816C5C, 0x00816C6B, 
						  0x00816C88, 0x00816D19, 0x00816D25, 0x00816D52, 0x00816D6C, 0x00816D80, 0x00816D90, 0x00816DA2, 0x00816DAE, 0x00816DDB, 
						  0x00816E39, 0x00816EE6, 0x00816F0A, 0x00816F2C, 0x00816F4F, 0x00816F61, 0x00816FAC, 0x0081705A, 0x008170FF, 0x0081710E, 
						  0x00817141, 0x00817171, 0x00817193, 0x008171C8, 0x008171F2, 0x00817222, 0x00817233, 0x0081725A, 0x00817269, 0x00817286, 
						  0x00817C95, 0x00817CA1, 0x00817CC0, 0x00817CFD, 0x00817B97, 0x00817BBD, 0x00817BD7, 0x00817FA2, 0x00818017, 0x00818111, 
						  0x008183BA, 0x008183E4, 0x008183FB, 0x0081841F, 0x00818449, 0x0081846E, 0x0081849B, 0x008184AA, 0x008184D1, 0x008184E0, 
						  0x00819668, 0x0081970A, 0x00819743, 0x0081977C, 0x008197A4, 0x008197B5, 0x0081983E, 0x0081984A, 0x00819883, 0x008199B2, 
						  0x008199BE, 0x00819A4F, 0x00819AF1, 0x00819B01, 0x00819B27, 0x00819B33, 0x00819B98, 0x00819BD4, 0x00819D13, 0x00819D1F, 
						  0x00819D8D, 0x00819DB9, 0x0081A12B, 0x0081A13B, 0x0081A184, 0x0081A194, 0x0081A247, 0x0081A276, 0x0081A30C, 0x0081A31C, 
						  0x0081A362, 0x0081A476, 0x0081A48A, 0x0081A49E, 0x0081A60D, 0x0081A653, 0x0081A718, 0x0081A727, 0x0081A733, 0x0081A752, 
						  0x0081A76B, 0x0081A77A, 0x0081A786, 0x0081A7BC, 0x0081A7CD, 0x0081A7DF, 0x0081A879, 0x0081A9EE, 0x0081A9FE, 0x0081887E, 
						  0x0081AA4E, 0x0081AA67, 0x0081AAA8, 0x0081AAC1, 0x0081AAD5, 0x0081888A, 0x0081AB34, 0x0081ACE0, 0x0081AD01, 0x0081AD10, 
						  0x0081AD44, 0x0081AD57, 0x0081AD83, 0x0081AE7E, 0x0081AE91, 0x0081AEA4, 0x0081AED3, 0x0081AF67, 0x0081AF98, 0x0081B107, 
						  0x0081B113, 0x0081B146, 0x0081B152, 0x00818925, 0x00818935, 0x00818675, 0x00818A1B, 0x00818A28, 0x00818A42, 0x00818AA5, 
						  0x00818AFF, 0x00818B0B, 0x00818B29, 0x00818B5D, 0x00818B69, 0x00818B85, 0x00818B92, 0x00818BB9, 0x00818BD3, 0x00818BE3, 
						  0x00818BFD, 0x00818C09, 0x00818CAA, 0x00818CC4, 0x00818D32, 0x00818D82, 0x00818D9D, 0x00818DB6, 0x00818E00, 0x00818E7B, 
						  0x00818E8B, 0x00818EF8, 0x00818F09, 0x00818F1A, 0x00818F86, 0x00819040, 0x00819058, 0x008190DB, 0x008190EB, 0x008190FB, 
						  0x00819127, 0x008191A9, 0x00819286, 0x00819313, 0x0081942D, 0x0081958C, 0x0081959D, 0x008195B5, 0x008195EF, 0x0081960D, 
						  0x0081B54E, 0x0081B591, 0x0081B5B5, 0x0081B5CF, 0x0081B630, 0x0081B640, 0x0081B680, 0x0081B6F3, 0x0081B71D, 0x0081B75A, 
						  0x0081B77B, 0x0081B7A5, 0x0081B7E4, 0x0081B836, 0x0081B8E9, 0x0081B911, 0x0081B500, 0x0081B538, 0x0081BB6B, 0x0081BB86, 
						  0x0081BA79, 0x0081BAA6, 0x0081BAC4, 0x0081C209, 0x0081C231, 0x0081C258, 0x0081C279, 0x0081C293, 0x0081C2A6, 0x0081C2D1, 
						  0x0081C2F6, 0x0081C310, 0x0081C323, 0x0081C36D, 0x0081C182, 0x0081C19A, 0x0081C1CC, 0x0081C1EA, 0x0081CB47, 0x0081CB68, 
						  0x0081CB7F, 0x0081CB94, 0x0081CBC4, 0x0081CBD6, 0x0081CBEE, 0x0081D007, 0x0081D020, 0x0081D048, 0x0081D42E, 0x0081D5EE, 
						  0x0081D62B, 0x0081DB8D, 0x0081DCED, 0x0081DE5E, 0x0081DEAD, 0x0081DF85, 0x0081DFD3, 0x0081E2D6, 0x0081E881, 0x0081E98A, 
						  0x0081E6F4, 0x0081EC00, 0x0081EC0C, 0x0081EDD9, 0x0081EDE5, 0x0081EE6C, 0x0081EE78, 0x0081FA1F, 0x0081FA93, 0x0081FBDD, 
						  0x0081FDE9, 0x0081FEA9, 0x00820039, 0x00820067, 0x0082008B, 0x0081FF91, 0x0081FFA4, 0x0081FFBD, 0x0081FFE1, 0x0081FFFF, 
						  0x0081FF1F, 0x00820578, 0x00820581, 0x0082059B, 0x008205A4, 0x008205AD, 0x008205D6, 0x008205DF, 0x008205F7, 0x00820615, 
						  0x0082061E, 0x0082064B, 0x00820654, 0x00820670, 0x00820696, 0x008206EC, 0x008206FF, 0x00820714, 0x00820737, 0x0082074E, 
						  0x00820757, 0x00820760, 0x00820789, 0x00820792, 0x008207AA, 0x008207B3, 0x008207D3, 0x008207DC, 0x008207FC, 0x0082081F, 
						  0x00820828, 0x0082084B, 0x00820854, 0x0082086C, 0x00820877, 0x008208AE, 0x008208B7, 0x008208D3, 0x008204A8, 0x008208E9, 
						  0x0082090E, 0x00820927, 0x0082095F, 0x00820988, 0x00820991, 0x008204B4, 0x008209A9, 0x008209B2, 0x008209C3, 0x008209D2, 
						  0x008204C0, 0x008204D3, 0x00820500, 0x00820509, 0x00820521, 0x00820536, 0x0082054E, 0x0082055D, 0x00820CCE, 0x00820CF9, 
						  0x00820D09, 0x00820BEE, 0x00820C0D, 0x00820C2C, 0x00820C50, 0x00820E5F, 0x00820E8E, 0x00820EB0, 0x00820F24, 0x008218B0, 
						  0x00821946, 0x00821958, 0x008219D3, 0x00821ADA, 0x00821B6D, 0x00821B97, 0x00821C9C, 0x00821CC6, 0x00821886, 0x00821E71, 
						  0x00822881, 0x00822BC4, 0x00822EE2, 0x00822EFC, 0x00822A14, 0x00822A20, 0x00823172, 0x0082307B, 0x0082331E, 0x00823644, 
						  0x00823716, 0x00823725, 0x00823748, 0x00823764, 0x00823AEB, 0x00823BAD, 0x00823C6D, 0x00823C7C, 0x00823C9A, 0x00823CB0, 
						  0x0082393B, 0x00824205, 0x00824211, 0x008245D1, 0x008246AD, 0x0082472E, 0x0082474A, 0x00824799, 0x008247DE, 0x00824869, 
						  0x00824988, 0x008249D9, 0x008249F2, 0x00824A0C, 0x00824A60, 0x00824A7A, 0x00824523, 0x00824543, 0x0082455F, 0x0082456B, 
						  0x0082458F, 0x008245A5, 0x008245BB, 0x00824CEF, 0x00824EBE, 0x00824EDA, 0x00824F88, 0x00824F97, 0x00824FB4, 0x00825DB4, 
						  0x00825DC0, 0x00827233, 0x008272CB, 0x00827387, 0x008273B6, 0x00827488, 0x008274B4, 0x008274C0, 0x008275B9, 0x008275C5, 
						  0x00827709, 0x0082783F, 0x0082789F, 0x008279A6, 0x008279C1, 0x00827A50, 0x00827A85, 0x00827A9B, 0x00827AB1, 0x00827AC9, 
						  0x00827AF0, 0x00827B1F, 0x00827BFF, 0x00827CCF, 0x00827CDB, 0x00827D08, 0x00827D2B, 0x00827FF9, 0x00828037, 0x00828050, 
						  0x0082866B, 0x0082869C, 0x008286A8, 0x0082655D, 0x0082656B, 0x0082658B, 0x0082659B, 0x00826686, 0x00826A0D, 0x00826A31, 
						  0x00826AE7, 0x00826B07, 0x00826CF2, 0x0082629A, 0x00826FD7, 0x00826FF8, 0x00827026, 0x0082710B, 0x00827177, 0x00828E71, 
						  0x00828F7A, 0x00828F92, 0x00829253, 0x0082927E, 0x008292AC, 0x008292E4, 0x008292FA, 0x00829310, 0x00829328, 0x00829361, 
						  0x00829390, 0x00829435, 0x00829460, 0x00828C47, 0x00829B26, 0x00829B32, 0x00829B53, 0x00829B65, 0x00829BB1, 0x00829BBA, 
						  0x00829CF3, 0x00829D14, 0x00829D47, 0x00829D6B, 0x00829D95, 0x00829D9E, 0x00829E11, 0x00829E1A, 0x00829ECF, 0x00829F0F, 
						  0x00829F40, 0x00829F83, 0x00829FA7, 0x00829FE7, 0x00829FFE, 0x0082A02D, 0x0082A090, 0x0082A099, 0x0082A0E4, 0x0082A0F0, 
						  0x0082A336, 0x0082A354, 0x0082A385, 0x0082A3C1, 0x0082A3EC, 0x0082A420, 0x0082A43C, 0x0082A48D, 0x0082A215, 0x0082A244, 
						  0x0082A260, 0x0082A700, 0x0082AA70, 0x0082AAA2, 0x0082AABD, 0x0082A99B, 0x0082AA54, 0x0082ABEB, 0x0082ADEC, 0x0082ADF7, 
						  0x0082AE29, 0x0082AE4E, 0x0082AE60, 0x0082AEE2, 0x0082AF08, 0x0082AF1A, 0x0082AF41, 0x0082AF71, 0x0082AF83, 0x0082AFBF, 
						  0x0082B04F, 0x0082B05B, 0x0082B07E, 0x0082B13F, 0x0082B151, 0x0082B16B, 0x0082B1ED, 0x0082B1FD, 0x0082B2D9, 0x0082B37D, 
						  0x0082B541, 0x0082CD6E, 0x0082CDEB, 0x0082CE07, 0x0082CE11, 0x0082CE30, 0x0082CE70, 0x0082CFF7, 0x0082D00F, 0x0082D02F, 
						  0x0082D098, 0x0082D0A4, 0x0082D3D3, 0x0082D401, 0x0082D486, 0x0082D492, 0x0082C03F, 0x0082C11F, 0x0082C14E, 0x0082C173, 
						  0x0082C185, 0x0082C207, 0x0082C22D, 0x0082C23F, 0x0082C266, 0x0082C296, 0x0082C2A8, 0x0082C301, 0x0082C319, 0x0082C339, 
						  0x0082C528, 0x0082C537, 0x0082C55C, 0x0082BDFE, 0x0082C93C, 0x0082C954, 0x0082C974, 0x0082CA12, 0x0082CA20, 0x0082CA96, 
						  0x0082CC55, 0x0082CC61, 0x0082CC90, 0x0082CCC3, 0x0082CCCF, 0x0082CCDB, 0x0082D656, 0x0082D708, 0x0082D795, 0x0082D579, 
						  0x0082D7FB, 0x0082D855, 0x0082D912, 0x0082D95A, 0x0082D969, 0x0082D979, 0x0082D9C1, 0x0082D9E5, 0x0082D9F5, 0x0082DA05, 
						  0x0082DA36, 0x0082DA50, 0x0082DA5F, 0x0082D5A4, 0x0082DA90, 0x0082DAAA, 0x0082D5C5, 0x0082D5D1, 0x0082D618, 0x0082D64A, 
						  0x0082DC4D, 0x0082DC5E, 0x0082DFE1, 0x0082E078, 0x0082DD97, 0x0082E206, 0x0082E233, 0x0082E255, 0x0082E26C, 0x0082E0CC, 
						  0x0082E283, 0x0082E292, 0x0082E2AD, 0x0082E0E0, 0x0082E14D, 0x0082E17D, 0x0082E64F, 0x0082E434, 0x0082E66C, 0x0082E6A7, 
						  0x0082E6E0, 0x0082E742, 0x0082E75E, 0x0082E77D, 0x0082E79C, 0x0082E7CF, 0x0082E479, 0x0082E4D6, 0x0082EBBD, 0x0082EC3C, 
						  0x0082EC5A, 0x0082EC90, 0x0082EA22, 0x0082EA4D, 0x0082EA59, 0x0082EA6C, 0x0082FD44, 0x0082FD95, 0x0082FDCA, 0x0082FDD8, 
						  0x0082EE4A, 0x0082FDF8, 0x0082FE73, 0x0082FE8D, 0x0082FEBC, 0x0082FF47, 0x0082FF5B, 0x0082EE62, 0x0082FF64, 0x0082FFFA, 
						  0x0083002B, 0x008300ED, 0x00830104, 0x00830142, 0x00830156, 0x0083015F, 0x008301DE, 0x008301FB, 0x00830268, 0x008303B2, 
						  0x0082EEAB, 0x0083045D, 0x00830498, 0x008304B5, 0x008304C6, 0x008304D2, 0x00830563, 0x0083056F, 0x008305DD, 0x008305E6, 
						  0x00830607, 0x0083066C, 0x00830818, 0x00830838, 0x00830848, 0x00830915, 0x0083092B, 0x0083093B, 0x0083094B, 0x0082EF02, 
						  0x00830982, 0x008309A2, 0x008309B2, 0x008309F0, 0x00830A00, 0x00830A10, 0x00830A6D, 0x00830B84, 0x00830B8D, 0x00830BAE, 
						  0x00830C03, 0x00830D21, 0x00830D34, 0x00830D7A, 0x00830DB2, 0x00830DBB, 0x00830DDC, 0x00830E25, 0x00830E6C, 0x00830E7C, 
						  0x00830E8C, 0x0082EF57, 0x00830EDE, 0x00830EEA, 0x00830F89, 0x00830F95, 0x0082EF93, 0x0082EFB3, 0x0082F04E, 0x0082F065, 
						  0x0082F0A5, 0x0082F0CC, 0x0082F0FE, 0x0082F11D, 0x0082F15D, 0x0082F189, 0x0082F20F, 0x0082F229, 0x0082F309, 0x0082F319, 
						  0x0082F385, 0x0082F396, 0x0082EDAD, 0x0082F4A2, 0x0082EDB9, 0x0082F5F2, 0x0082F675, 0x0082F696, 0x0082F6A6, 0x0082F6B6, 
						  0x0082F6F4, 0x0082F7CB, 0x0082F7DB, 0x0082F817, 0x0082EDF4, 0x0082F8F7, 0x0082F907, 0x0082F91E, 0x0082F945, 0x0082F955, 
						  0x0082F965, 0x0082F9A3, 0x0082FA39, 0x0082FA60, 0x0082FA7E, 0x0082FAC9, 0x0082FAD9, 0x0082EE1E, 0x0082FB21, 0x0082FB31, 
						  0x0082FB41, 0x0082FB7A, 0x0082FC3D, 0x0082FC7A, 0x0082EE34, 0x0082FCC8, 0x0082FD0E, 0x008311D9, 0x008310F2, 0x0083111D, 
						  0x0083113C, 0x008310BE, 0x0083173D, 0x00831749, 0x0083175F, 0x00831808, 0x00831814, 0x0083189E, 0x008318B9, 0x0083190A, 
						  0x00831929, 0x008319CE, 0x0083144A, 0x00831456, 0x0083146C, 0x00831C6B, 0x00831C7B, 0x00831D18, 0x00831B68, 0x00831BAC, 
						  0x00831BD4, 0x00831BFA, 0x00831F5D, 0x00831F69, 0x00831E94, 0x00831EA0, 0x00831EDC, 0x00831EE8, 0x00831EFB, 0x008323D9, 
						  0x00832417, 0x00832423, 0x00832462, 0x008324B0, 0x008324C6, 0x008324DE, 0x0083252C, 0x00832567, 0x00832825, 0x00832860, 
						  0x0083286C, 0x0083289F, 0x008328B9, 0x00832354, 0x00832374, 0x00832393, 0x00832C4C, 0x00832C6E, 0x00832CB4, 0x00832CDD, 
						  0x00832D0C, 0x00832D17, 0x00832DD8, 0x00832DE3, 0x00832A78, 0x00833052, 0x00832F54, 0x00832F7F, 0x00832F98, 0x008332A5, 
						  0x00833315, 0x00833325, 0x0083333E, 0x00833377, 0x00833483, 0x008331D2, 0x0083365E, 0x008337A8, 0x008337B3, 0x008337CE, 
						  0x00833FCC, 0x00833FED, 0x008341C6, 0x008341D8, 0x008341EE, 0x0083425B, 0x0083426B, 0x008340B1, 0x0083432C, 0x0083433B, 
						  0x008343C2, 0x008340E5, 0x00834158, 0x0083462A, 0x008346A1, 0x00834701, 0x00834760, 0x008347DC, 0x008347EE, 0x00834808, 
						  0x0083488B, 0x0083489B, 0x0083498B, 0x008349B5, 0x008349DF, 0x00834AAF, 0x00834B66, 0x00834B72, 0x00834B88, 0x00834C22, 
						  0x00834C45, 0x00834C85, 0x0083515A, 0x00835166, 0x008351A2, 0x00835306, 0x00835494, 0x008354A0, 0x008354D2, 0x00835015, 
						  0x008355A4, 0x00835021, 0x00835608, 0x00835675, 0x008356EF, 0x00835038, 0x0083588B, 0x008358E8, 0x00835958, 0x00835B76, 
						  0x00835080, 0x0083508C, 0x0083509F, 0x00835DC0, 0x00835DD5, 0x00835FBB, 0x00835FC7, 0x00836003, 0x0083608D, 0x00836099, 
						  0x0083611C, 0x0083618E, 0x008361EF, 0x008363B2, 0x0083640B, 0x00835ECB, 0x00835EE0, 0x00835EEF, 0x00835F08, 0x00835F42, 
						  0x00836610, 0x00836681, 0x00836691, 0x008366B0, 0x008366C6, 0x008366D5, 0x008366EF, 0x00836700, 0x0083670F, 0x0083674D, 
						  0x0083675E, 0x008364D1, 0x0083650D, 0x00836925, 0x0083693E, 0x00836952, 0x00836890, 0x00836A82, 0x00836AA9, 0x00836D0B, 
						  0x00836D17, 0x00836D4D, 0x00836E80, 0x00836EC4, 0x00836EED, 0x00836FA2, 0x00836FC4, 0x00836FD4, 0x00836FE4, 0x00837024, 
						  0x00837034, 0x00837044, 0x00836DB1, 0x008370FA, 0x00837106, 0x00837131, 0x0083715D, 0x008371D3, 0x00837209, 0x00837218, 
						  0x0083725C, 0x0083728B, 0x00837297, 0x008372AF, 0x008372BB, 0x008372F2, 0x00837315, 0x00836DDC, 0x00836DE8, 0x00836DFE, 
						  0x00836E62, 0x00836E6E, 0x008374A8, 0x008374BE, 0x008374D4, 0x008374EC, 0x00837529, 0x0083754F, 0x00837574, 0x00837625, 
						  0x00837631, 0x008376F5, 0x00837709, 0x0083772B, 0x008373E0, 0x008373F8, 0x00837442, 0x0083746D, 0x00837869, 0x0083787A, 
						  0x00837D46, 0x00837D52, 0x00837D86, 0x00837DFE, 0x00837E76, 0x00837FBE, 0x00837FCA, 0x00838011, 0x00838043, 0x008380A7, 
						  0x00837BF4, 0x008380FC, 0x00837C00, 0x00838298, 0x008382F2, 0x00837C17, 0x0083835C, 0x00838578, 0x008385A2, 0x008385B8, 
						  0x00837C5F, 0x00837C6B, 0x00837C7E, 0x00839C83, 0x00839E2A, 0x00839E42, 0x00839E7B, 0x00839FBD, 0x00839FCB, 0x00839FEE, 
						  0x0083A081, 0x0083A08F, 0x0083BBEF, 0x0083BC06, 0x0083BC28, 0x0083BC37, 0x0083BE2B, 0x0083C2FF, 0x0083AC4B, 0x0083ACBF, 
						  0x0083ACCF, 0x0083AD27, 0x0083AD97, 0x0083C794, 0x0083C7B0, 0x0083C7D4, 0x0083C811, 0x0083C835, 0x0083C86C, 0x0083C87B, 
						  0x0083C899, 0x0083C8B8, 0x0083C737, 0x0083C747, 0x0083CA92, 0x0083CAA7, 0x0083CAB3, 0x0083CAC6, 0x0083CAF3, 0x0083CB43, 
						  0x0083CC39, 0x0083CCCF, 0x0083DF79, 0x0083E07A, 0x0083E2EF, 0x0083E33C, 0x0083E34D, 0x0083E36B, 0x0083E374, 0x0083E3D1, 
						  0x0083E49D, 0x0083E4B8, 0x0083E51C, 0x0083E205, 0x0083E543, 0x0083E562, 0x0083E56B, 0x0083E590, 0x0083E5AA, 0x0083E5C4, 
						  0x0083E5E1, 0x0083E605, 0x0083E61F, 0x0083E642, 0x0083E64B, 0x0083E668, 0x0083E68D, 0x0083E6BA, 0x0083E6D0, 0x0083E23A, 
						  0x0083E24A, 0x0083E272, 0x0083E28C, 0x0083E2A6, 0x0083E2CE, 0x0083E749, 0x0083F45E, 0x0083F474, 0x0083F49F, 0x0083F4AB, 
						  0x0083F4D9, 0x0083F4E9, 0x0083F34C, 0x0083F50C, 0x0083F51D, 0x0083F537, 0x0083F556, 0x0083F564, 0x0083F575, 0x0083F58B, 
						  0x0083F5BE, 0x0083F5E9, 0x0083F35C, 0x0083F3A0, 0x0083F3B0, 0x0083F3CB, 0x0083F3F9, 0x0083F409, 0x0083F428, 0x0083FAE4, 
						  0x0083FEEB, 0x0083FF3D, 0x0083FFA0, 0x00840059, 0x0083FE83, 0x00840B20, 0x00840B32, 0x00840B6C, 0x00840B91, 0x00840E6E, 
						  0x00840E93, 0x00840EA4, 0x00840EB3, 0x008410FB, 0x00841111, 0x00841135, 0x00841158, 0x008411C9, 0x008411EA, 0x0084107C, 
						  0x0084109D, 0x008410AD, 0x008410E1, 0x00841427, 0x008415D5, 0x0084172E, 0x008417DE, 0x008415E3, 0x00841678, 0x0084168D, 
						  0x008416AA, 0x00841AD2, 0x00841AE0, 0x00841C12, 0x00841C20, 0x00841D30, 0x00841D3F, 0x00842082, 0x00842093, 0x00842125, 
						  0x00842136, 0x00842364, 0x008423D9, 0x00842687, 0x00842A6F, 0x00842AFE, 0x008428CB, 0x00842C75, 0x00842CBE, 0x00842CF0, 
						  0x00842D2D, 0x00842D6B, 0x00842DDB, 0x00843005, 0x00843216, 0x00843245, 0x0084333F, 0x00843364, 0x008433EE, 0x008433FE, 
						  0x0084340E, 0x00843431, 0x00843149, 0x00843161, 0x008431A8, 0x008431B4, 0x008431E9, 0x008431F5, 0x008435AA, 0x008435CD, 
						  0x0084347C, 0x0084383A, 0x0084384D, 0x00843886, 0x00843895, 0x008438AD, 0x008438C9, 0x008434A7, 0x0084390B, 0x00843929, 
						  0x00843A40, 0x00843A58, 0x00843504, 0x0084354F, 0x00843CB2, 0x00843CD9, 0x00843D26, 0x00843DFE, 0x00843EC0, 0x00843ED0, 
						  0x00843F39, 0x00843F66, 0x00843F88, 0x00843FBD, 0x00843FE1, 0x00844000, 0x0084400F, 0x0084401B, 0x00844038, 0x00844054, 
						  0x0084407B, 0x0084408A, 0x008440B7, 0x008440C7, 0x008440D7, 0x00844412, 0x00844446, 0x0084445E, 0x0084450E, 0x008445C9, 
						  0x008445DF, 0x008446D0, 0x00844223, 0x0084422F, 0x008447E6, 0x008447FC, 0x0084496C, 0x0084498E, 0x0084424E, 0x00844A18, 
						  0x00844A8C, 0x00844CC8, 0x00844D20, 0x00844DE2, 0x00844DEE, 0x00844E04, 0x00844C27, 0x00844C33, 0x008450E0, 0x008450FB, 
						  0x0084516D, 0x008451E1, 0x0084537E, 0x00845743, 0x00845792, 0x00845C87, 0x00845C96, 0x00845DB0, 0x00845DDC, 0x00845DF5, 
						  0x00845B17, 0x00845B23, 0x00845B39, 0x00845B59, 0x0084686B, 0x0084687A, 0x008468DD, 0x008471C2, 0x008471FC, 0x008472A1, 
						  0x0084745F, 0x0084791A, 0x0084793A, 0x00847988, 0x00847CB7, 0x00847CED, 0x00847D64, 0x00847D8A, 0x00847E40, 0x00847E72, 
						  0x00847E7E, 0x00847E91, 0x00847EAC, 0x00847EFE, 0x00847F2A, 0x00847F3F, 0x00848007, 0x00848046, 0x00848056, 0x00848089, 
						  0x008480FA, 0x00848114, 0x0084812C, 0x0084813D, 0x0084817D, 0x008481E4, 0x00848244, 0x0084840D, 0x00848454, 0x00847C98, 
						  0x00847CA4, 0x008487C4, 0x00848C88, 0x00848CB9, 0x00848CD1, 0x00848CF1, 0x00848D17, 0x00848DB1, 0x008490CA, 0x008490D8, 
						  0x0084915D, 0x0084916B, 0x00848C13, 0x00848C23, 0x00849794, 0x0084990F, 0x0084996C, 0x00849A8A, 0x008498C0, 0x00849E1E, 
						  0x00849C99, 0x0084A027, 0x0084A291, 0x0084A29D, 0x0084A2B0, 0x0084A2BD, 0x0084A20D, 0x0084A219, 0x0084A230, 0x0084A491, 
						  0x0084A49D, 0x0084AE4C, 0x0084B006, 0x0084B029, 0x0084AEF2, 0x0084AF0B, 0x0084AF24, 0x0084AF5C, 0x0084AF7C, 0x0084BDD0, 
						  0x0084CA41, 0x0084CAEB, 0x0084CBC7, 0x0084CBF4, 0x0084CC23, 0x0084CD0B, 0x0084CD5C, 0x0084CD68, 0x0084CD7E, 0x0084CD91, 
						  0x0084CDB7, 0x0084CEFB, 0x0084D26D, 0x0084D280, 0x0084D2B3, 0x0084D303, 0x0084D357, 0x0084D363, 0x0084D380, 0x0084D3A5, 
						  0x0084D55A, 0x0084D590, 0x0084DAA2, 0x0084DB49, 0x0084DB6C, 0x0084DB83, 0x0084DBEC, 0x0084DC10, 0x0084DCA1, 0x0084DCC6, 
						  0x0084DCEB, 0x0084DD16, 0x0084D510, 0x0084D51C, 0x0084DE94, 0x0084DECF, 0x0084DEF3, 0x0084DF34, 0x0084DFC0, 0x0084DFF4, 
						  0x0084E007, 0x0084E043, 0x0084E096, 0x0084E143, 0x0084E16B, 0x0084DE30, 0x0084DE48, 0x0084DE5B, 0x0084E1F6, 0x0084E2C0, 
						  0x0084E2D0, 0x0084E2E4, 0x0084E75F, 0x0084E77A, 0x0084E7C0, 0x0084E81D, 0x0084E848, 0x0084E854, 0x0084E8C2, 0x0084E976, 
						  0x0084E9B2, 0x0084E9CA, 0x0084E42F, 0x0084E43D, 0x0084E45D, 0x0084E46D, 0x0084F015, 0x0084EF9B, 0x0084F258, 0x0084F281, 
						  0x0084F2BA, 0x0084F2DF, 0x0084F30A, 0x0084F3E0, 0x0084F3F8, 0x0084F408, 0x0084F418, 0x0084F454, 0x0084F14B, 0x0084F4CC, 
						  0x0084F4DC, 0x0084F574, 0x0084F157, 0x0084F584, 0x0084F594, 0x0084F759, 0x0084F83E, 0x0084F84F, 0x0084F86E, 0x0084F8B9, 
						  0x0084F18C, 0x0084F98D, 0x0084F9AA, 0x0084F1CF, 0x0084F1E6, 0x0084FB60, 0x0084FBA8, 0x0084FA56, 0x0084FAD8, 0x0084FAEC, 
						  0x0084FEB5, 0x0084FEC1, 0x0084FED7, 0x0084FF0C, 0x0084FF2B, 0x0084FFB6, 0x0085027E, 0x00850291, 0x00850381, 0x008503D9, 
						  0x0085042B, 0x008501BB, 0x00850211, 0x008505A4, 0x008505CD, 0x00850656, 0x008504BC, 0x0085066E, 0x0085067E, 0x0085068E, 
						  0x008506C8, 0x008506D8, 0x008506E8, 0x00850769, 0x00850775, 0x008507AC, 0x008507ED, 0x00850814, 0x0085089C, 0x008508A8, 
						  0x008504E7, 0x008504F3, 0x00850509, 0x0085054E, 0x00850560, 0x00850EE9, 0x00850F17, 0x00850F3D, 0x00850FD7, 0x00851006, 
						  0x00851040, 0x00850E19, 0x00851173, 0x0085117F, 0x008511C6, 0x008511F8, 0x0085126C, 0x008512BB, 0x00851380, 0x0085138C, 
						  0x00851562, 0x00850E5B, 0x00850E67, 0x00850E7A, 0x00850ED9, 0x00851793, 0x008517BA, 0x008517CA, 0x008517E1, 0x008517F1, 
						  0x0085181B, 0x00851836, 0x00851842, 0x008518C3, 0x008518E1, 0x00851710, 0x00851724, 0x00851A7B, 0x00851A93, 0x00851AE3, 
						  0x00851B11, 0x00851B1D, 0x00851996, 0x008519C1, 0x00851A18, 0x00851A35, 0x00851C12, 0x00851C95, 0x00851CA1, 0x00851F26, 
						  0x00851F37, 0x008520DE, 0x00852118, 0x00852170, 0x00852182, 0x00852206, 0x008522F8, 0x0085231C, 0x0085232C, 0x0085233C, 
						  0x008523CA, 0x008525A7, 0x00852661, 0x00852671, 0x00852681, 0x008526AD, 0x0085274C, 0x008527C3, 0x008527E0, 0x00852817, 
						  0x0085202A, 0x0085203A, 0x0085205C, 0x00852065, 0x00852BA3, 0x00852B5A, 0x00852B6A, 0x00852DD5, 0x00852DED, 0x00853032, 
						  0x0085305D, 0x00853069, 0x008530FD, 0x00853128, 0x00853142, 0x0085314E, 0x00853163, 0x008537CA, 0x00853800, 0x00853905, 
						  0x00853933, 0x008539AA, 0x008539BA, 0x008539CA, 0x008539FE, 0x008536FA, 0x00853712, 0x0085375C, 0x00853768, 0x0085379D, 
						  0x008537A9, 0x00853A8F, 0x00853C8B, 0x00853C97, 0x00853CDA, 0x00853DC0, 0x00853EFC, 0x00853F08, 0x00853F4F, 0x00853F81, 
						  0x00853FD5, 0x00854026, 0x0085404B, 0x00853B2D, 0x008541D7, 0x00854234, 0x00853B39, 0x0085429A, 0x008542C8, 0x00853B50, 
						  0x00853B98, 0x00853BA4, 0x00853BB7, 0x008547C9, 0x008548B2, 0x0085506B, 0x008552BA, 0x0085544A, 0x00855CF3, 0x00855DC2, 
						  0x00855ED2, 0x00855FF5, 0x008563CA, 0x0085640B, 0x008577FC, 0x00857BA8, 0x00857CE9, 0x00857DFE, 0x00857E2E, 0x00857E3A, 
						  0x00858916, 0x0085890A, 0x00858A82, 0x00858AB4, 0x00858AC5, 0x00858AF7, 0x00858B35, 0x00858D29, 0x00859455, 0x0085946A, 
						  0x00859479, 0x00859446, 0x008595A8, 0x0085955D, 0x00859593, 0x008597B7, 0x008597CD, 0x0085987A, 0x00859907, 0x00859918, 
						  0x00859A88, 0x00859AA7, 0x00859ACB, 0x00859AD4, 0x00859AEA, 0x008599A7, 0x008599E2, 0x008599FF, 0x00859A23, 0x00859A4F, 
						  0x00859A5D, 0x00859A75, 0x00859B5A, 0x00859BFF, 0x00859C0B, 0x00859C5D, 0x00859C69, 0x00859C79, 0x00859C96, 0x00859CBA, 
						  0x00859D2B, 0x00859D3B, 0x00859D51, 0x00859DB0, 0x00859DC0, 0x00859DE7, 0x00859DFE, 0x00859F8B, 0x00859E83, 0x00859FBB, 
						  0x00859FDC, 0x0085A017, 0x0085A06E, 0x00859E93, 0x0085A0B2, 0x00859EA3, 0x00859EC1, 0x00859EF7, 0x00859F1D, 0x0085A212, 
						  0x0085A222, 0x0085A22B, 0x0085A242, 0x0085A24B, 0x0085A262, 0x0085A26F, 0x0085A298, 0x0085A2D0, 0x0085A2EE, 0x0085A2FC, 
						  0x0085A314, 0x0085A322, 0x0085A123, 0x0085A375, 0x0085A383, 0x0085A39B, 0x0085A3AE, 0x0085A14E, 0x0085A157, 0x0085A173, 
						  0x0085A187, 0x0085A197, 0x0085A1A0, 0x0085A1AF, 0x0085A1D7, 0x0085A42B, 0x0085A461, 0x0085A487, 0x0085A4A5, 0x0085C6B9, 
						  0x0085C6D1, 0x0085C6A7, 0x0085D0B9, 0x0085D0F2, 0x0085D3A7, 0x0085D3B9, 0x0085D3E3, 0x0085D3EE, 0x0085D403, 0x0085D41B, 
						  0x0085D439, 0x0085D598, 0x0085D5A4, 0x0085D606, 0x0085D787, 0x0085D867, 0x0085D872, 0x0085D04F, 0x0085D069, 0x0085D095, 
						  0x0085D0A5, 0x0085D9C2, 0x0085D9D7, 0x0085D9F4, 0x0085DA09, 0x0085DDE5, 0x0085DDF9, 0x0085DE2D, 0x0085DE4B, 0x0085E120, 
						  0x0085E131, 0x0085E304, 0x0085E42C, 0x0085E443, 0x0085E497, 0x0085E585, 0x0085E65F, 0x0085E70B, 0x0085E77C, 0x0085E78E, 
						  0x0085E79A, 0x0085E7B3, 0x0085E36F, 0x0085E87F, 0x0085E88E, 0x0085E942, 0x0085E958, 0x0085E964, 0x0085E97F, 0x0085EA00, 
						  0x0085EA58, 0x0085EA67, 0x0085EA9D, 0x0085EACD, 0x0085EADC, 0x0085EBBB, 0x0085EBCD, 0x0085EC0B, 0x0085EC1F, 0x0085EC54, 
						  0x0085ECCC, 0x0085ED27, 0x0085E416, 0x0085ED94, 0x0085EDA9, 0x0085EDB4, 0x0085EFA0, 0x0085EEC6, 0x0085F2AB, 0x0085F500, 
						  0x0085F548, 0x0085F554, 0x0085F8B9, 0x0085FBA0, 0x0085FBAC, 0x0085FBD5, 0x0085FC49, 0x0085FC74, 0x0085FC8E, 0x0085FCFA, 
						  0x0085FE92, 0x0085FEAB, 0x0085FED6, 0x0085FF53, 0x0085FA16, 0x0086067E, 0x00860771, 0x00860990, 0x008609A9, 0x008609B4, 
						  0x008609C9, 0x008609E2, 0x008609ED, 0x00860C75, 0x00860D35, 0x00860D53, 0x00860D66, 0x00860D80, 0x00860DA1, 0x0086102A, 
						  0x008615ED, 0x008615FD, 0x00861650, 0x00861669, 0x00861696, 0x0086169F, 0x008616B5, 0x008619B3, 0x008619D8, 0x008619EE, 
						  0x00861A05, 0x00861A20, 0x00861A56, 0x00861A73, 0x008618F6, 0x00861926, 0x00861C7B, 0x00861C96, 0x00861B79, 0x00861BA3, 
						  0x00861F8E, 0x00861F9C, 0x00861FAB, 0x00861E57, 0x00861E63, 0x00861E78, 0x00861E96, 0x00861E9F, 0x00861F2B, 0x00862107, 
						  0x00862129, 0x0086216C, 0x0086207C, 0x00862092, 0x008620A2, 0x008620B5, 0x008620C9, 0x008620DE, 0x008622D8, 0x008622F7, 
						  0x00862318, 0x0086232A, 0x00862343, 0x0086235B, 0x008626EF, 0x0086271B, 0x00862736, 0x0086281C, 0x00862862, 0x00862A56, 
						  0x00862A62, 0x00863166, 0x0086318A, 0x008631D6, 0x00863202, 0x00863216, 0x0086322B, 0x00863286, 0x00863327, 0x00863350, 
						  0x008633A5, 0x008633BC, 0x008633F1, 0x0086356A, 0x008630AC, 0x008630BD, 0x008630DC, 0x008630EB, 0x00863102, 0x00863133, 
						  0x008637BD, 0x008637EE, 0x008636D8, 0x008636F0, 0x00863718, 0x00863727, 0x008638BB, 0x008639FE, 0x00863A25, 0x00863A4C, 
						  0x00863B10, 0x00863B35, 0x00863B5A, 0x0086396B, 0x0086398F, 0x008639B6, 0x008639CA, 0x00863D14, 0x00863C0E, 0x00863C87, 
						  0x00864317, 0x00864329, 0x00864358, 0x00864397, 0x008649D7, 0x00864C3D, 0x00864E8C, 0x00864EA4, 0x00864E6E, 0x00864FDA, 
						  0x00864FF7, 0x00865078, 0x008652CB, 0x008652E6, 0x008651DD, 0x00865220, 0x00865244, 0x00865265, 0x00865278, 0x00865298, 
						  0x00865938, 0x00865944, 0x00865965, 0x0086596E, 0x008657D4, 0x008657EC, 0x00865872, 0x008659D4, 0x008659BC, 0x00865BEE, 
						  0x00865C02, 0x00865C38, 0x00865C4B, 0x00865D1A, 0x00865D38, 0x00865E04, 0x00866279, 0x00866289, 0x0086629E, 0x008662BA, 
						  0x008662CA, 0x0086633D, 0x008663A7, 0x008663F7, 0x0086642C, 0x00866452, 0x00866470, 0x00866481, 0x008664C1, 0x008664CA, 
						  0x008664E9, 0x008665DF, 0x00866615, 0x0086693A, 0x00866963, 0x008669AD, 0x008669F4, 0x00866A02, 0x00866A1C, 0x00866AA3, 
						  0x00866B8E, 0x00866BB4, 0x00866BE7, 0x00866F1F, 0x00866F2B, 0x0086733C, 0x00867348, 0x00867360, 0x00868EF4, 0x0086A391, 
						  0x0086A3A9, 0x0086A3BC, 0x0086A3CB, 0x0086A3E2, 0x0086A451, 0x0086A47B, 0x0086A599, 0x0086A5A5, 0x0086A5AE, 0x0086A2F7, 
						  0x0086A326, 0x0086ACF6, 0x0086AF6D, 0x0086AF86, 0x0086AF9F, 0x0086AFC6, 0x0086AFEB, 0x0086B007, 0x0086B024, 0x0086AE91, 
						  0x0086AEBC, 0x0086AF09, 0x0086AE6B, 0x0086AF1E, 0x0086B164, 0x0086B18A, 0x0086B1A8, 0x0086B1B1, 0x0086B1C9, 0x0086B075, 
						  0x0086B087, 0x0086B0B1, 0x0086BD47, 0x0086BE07, 0x0086BE6C, 0x0086C1F7, 0x0086C223, 0x0086C25A, 0x0086C0DB, 0x0086C3BD, 
						  0x0086C3E1, 0x0086C49E, 0x0086C4C3, 0x0086C0F6, 0x0086C111, 0x0086C720, 0x0086C787, 0x0086C9DF, 0x0086CA3F, 0x0086CBA1, 
						  0x0086C163, 0x0086CD03, 0x0086CD2A, 0x0086D031, 0x0086D03D, 0x0086CF3C, 0x0086CF5D, 0x0086CF89, 0x0086D356, 0x0086D0DC, 
						  0x0086D3E9, 0x0086D5DB, 0x0086D60D, 0x0086DBF9, 0x0086DC49, 0x0086DC55, 0x0086DC6D, 0x0086DBCE, 0x0086DDC5, 0x0086DDD1, 
						  0x0086DDF4, 0x0086DE00, 0x0086DE2C, 0x0086DEB5, 0x0086DF16, 0x0086DF27, 0x0086DF37, 0x0086DFC8, 0x0086E23D, 0x0086E249, 
						  0x0086E25E, 0x0086E267, 0x0086E1CE, 0x0086E353, 0x0086E83A, 0x0086E933, 0x0086EC32, 0x0086EC54, 0x0086EC73, 0x0086EEC2, 
						  0x0086EFE8, 0x0086EFF7, 0x0086F006, 0x0086F01C, 0x0086F041, 0x0086F063, 0x0086EEDC, 0x0086EF0E, 0x0086EF29, 0x0086EF4B, 
						  0x0086EF67, 0x0086EF79, 0x0086EF82, 0x0086EF94, 0x0086EFA6, 0x0086EFAF, 0x0086F10F, 0x0086F11B, 0x0086F13B, 0x0086F221, 
						  0x0086F28F, 0x0086F29B, 0x0086F2DA, 0x0086F3BB, 0x0086F5AA, 0x0086F5B8, 0x0086F5DA, 0x0086F6EC, 0x0086F70B, 0x0086F3D7, 
						  0x0086F782, 0x0086F79A, 0x0086F7B2, 0x0086F7D7, 0x0086F7E0, 0x0086F7F8, 0x0086F801, 0x0086F8B4, 0x0086F8C8, 0x0086F8E0, 
						  0x0086F8F8, 0x0086F919, 0x0086F987, 0x0086F993, 0x0086F9A9, 0x0086F9BF, 0x0086F9D9, 0x0086FA44, 0x0086FA69, 0x0086FA88, 
						  0x0086FA99, 0x0086FADB, 0x0086FB76, 0x0086FCC3, 0x0086FD60, 0x0086FD73, 0x0086FDBD, 0x0086FDD8, 0x0086FE1D, 0x0086FE3E, 
						  0x0086FEA0, 0x0086FEAF, 0x0086FF6A, 0x0086FF79, 0x0086FFA4, 0x008713FB, 0x00871413, 0x00871703, 0x0087177A, 0x008715FE, 
						  0x00871694, 0x008716A3, 0x008716BF, 0x008716CE, 0x00871899, 0x008719EE, 0x00871EB3, 0x00871E41, 0x00871F9C, 0x00871F4A, 
						  0x00872781, 0x008727C7, 0x008727F2, 0x0087293C, 0x00872948, 0x00872C17, 0x00872C6F, 0x00872B53, 0x00872ED6, 0x00872F2F, 
						  0x00872F76, 0x00872DD1, 0x00872FCB, 0x00873016, 0x008731E7, 0x008734E8, 0x008733A8, 0x008733D2, 0x008733EE, 0x0087340E, 
						  0x0087359F, 0x008735B1, 0x008735C8, 0x008735DA, 0x00873612, 0x00873624, 0x00873645, 0x00873669, 0x008736A8, 0x008736BC, 
						  0x008736D3, 0x00873839, 0x00873894, 0x008738AA, 0x008738C0, 0x00873905, 0x00873925, 0x0087396A, 0x00873982, 0x0087373E, 
						  0x0087374E, 0x00873766, 0x008739C2, 0x00873AF4, 0x00873B03, 0x00873B0F, 0x00873B5D, 0x00873B6F, 0x00873B98, 0x00873BAA, 
						  0x008739D4, 0x00873A5D, 0x00873A6C, 0x00873A78, 0x00873E23, 0x00873E2F, 0x00873F6D, 0x008741BF, 0x0087432B, 0x00874515, 
						  0x00874535, 0x00874595, 0x0087440B, 0x008744AA, 0x008744BA, 0x008744D4, 0x008744EC, 0x008746F4, 0x0087471B, 0x0087473B, 
						  0x00874747, 0x0087475A, 0x00874AAD, 0x00874B78, 0x00874B5B, 0x0087508E, 0x0087524A, 0x00875168, 0x008758CA, 0x008757F8, 
						  0x0087580D, 0x00875844, 0x0087587E, 0x00875893, 0x00875A04, 0x00875932, 0x00875947, 0x0087597E, 0x008759B8, 0x008759CD, 
						  0x00875E06, 0x00875E83, 0x00875E92, 0x00875EAA, 0x00875CB2, 0x0087658B, 0x008765AC, 0x0087678C, 0x008767FE, 0x0087935A, 
						  0x008793DA, 0x0087973F, 0x0087975C, 0x00879782, 0x0087983A, 0x008798FA, 0x00879A1A, 0x00879B8A, 0x00879C6A, 0x0087A184, 
						  0x0087A1A3, 0x0087A9E9, 0x0087AA5E, 0x0087ACF0, 0x0087ACFB, 0x0087ABFE, 0x0087AC1F, 0x0087AC37, 0x0087AC5E, 0x0087AC81, 
						  0x0087C10D, 0x0087C159, 0x0087C2F1, 0x0087C301, 0x0087C329, 0x0087C340, 0x0087C370, 0x0087C3C4, 0x0087C41A, 0x0087C5E8, 
						  0x0087C5F3, 0x0087C60F, 0x0087C618, 0x0087C62E, 0x0087C644, 0x0087CA8C, 0x0087CA9B, 0x0087CB27, 0x0087CB45, 0x0087CC30, 
						  0x0087CC51, 0x0087CD9D, 0x0087CDA9, 0x0087D039, 0x0087D009, 0x0087D294, 0x0087D2C6, 0x0087D2D6, 0x0087D369, 0x0087D3A1, 
						  0x0087D3C0, 0x0087D46C, 0x0087D53E, 0x0087D563, 0x0087D8ED, 0x0087D90F, 0x0087E149, 0x0087E1AE, 0x0087E1C4, 0x0087E21A, 
						  0x0087E22A, 0x0087E28E, 0x0087E2A4, 0x0087E2C8, 0x0087E413, 0x0087E10A, 0x0087E489, 0x0087E727, 0x0087E495, 0x0087E4B6, 
						  0x0087EBEA, 0x0087EC09, 0x0087ED11, 0x0087ED1D, 0x0087ED52, 0x0087EE2E, 0x0087EF11, 0x0087EF1D, 0x0087EF4C, 0x0087F296, 
						  0x0087F438, 0x0087F17C, 0x0087F84A, 0x0087F99D, 0x0087F9BE, 0x0087FEC9, 0x0087FED9, 0x0087FEF3, 0x0087FF0F, 0x0087FF25, 
						  0x0087FF3B, 0x0087FF51, 0x0087FF63, 0x0087FFEB, 0x0088013E, 0x00880150, 0x00880166, 0x008801A0, 0x008801F3, 0x00880217, 
						  0x008800D2, 0x008800E2, 0x008800FC, 0x00880112, 0x00880128, 0x0088036E, 0x00880380, 0x00880396, 0x008803D0, 0x00880423, 
						  0x00880447, 0x00880302, 0x00880312, 0x0088032C, 0x00880342, 0x00880358, 0x008805B0, 0x008805C8, 0x008805D1, 0x008805F6, 
						  0x00880615, 0x0088062D, 0x00880640, 0x0088065E, 0x00880675, 0x0088068C, 0x008806A7, 0x008806BA, 0x008806EC, 0x00880741, 
						  0x0088074F, 0x00880767, 0x0088077A, 0x008807A7, 0x008807DC, 0x008807FA, 0x00880827, 0x008808C2, 0x008808CE, 0x00880531, 
						  0x00880541, 0x00880586, 0x00880AB8, 0x00880AE1, 0x00880AF9, 0x008809C5, 0x00880B15, 0x00880B26, 0x00880B37, 0x00880B51, 
						  0x00880B69, 0x00880B85, 0x008809D5, 0x008809F7, 0x00880A11, 0x00880A2B, 0x00880A5C, 0x00880A80, 0x00880A94, 0x00880C97, 
						  0x00880CA8, 0x00880CB3, 0x00880DE8, 0x00880D48, 0x00880D58, 0x00880D76, 0x00880D8C, 0x00880DA2, 0x00880DB1, 0x00880DD9, 
						  0x00880E6A, 0x00880E7A, 0x00880E8C, 0x00880EAB, 0x00880ED4, 0x00880EF2, 0x00880F03, 0x00880F12, 0x00880F56, 0x00880F76, 
						  0x00880F96, 0x00880FB6, 0x00880FBF, 0x00880FE6, 0x00881013, 0x008815E5, 0x00881962, 0x00881987, 0x008819D6, 0x008819E4, 
						  0x008819FC, 0x00881A0F, 0x00881A41, 0x00881A78, 0x008818D3, 0x0088190E, 0x00881919, 0x00881C32, 0x00881C4A, 0x00881C67, 
						  0x00881C76, 0x00881C7F, 0x00881C26, 0x00881D95, 0x00881DA8, 0x00881DFD, 0x00881E0D, 0x00881E2B, 0x00881EA8, 0x00881EC2, 
						  0x00882047, 0x0088206D, 0x008820D5, 0x008820DE, 0x008820F6, 0x008820FF, 0x0088211C, 0x00881F8A, 0x00881F9A, 0x00881FB4, 
						  0x00881FC7, 0x00881FE0, 0x00881FFC, 0x00882013, 0x0088202D, 0x0088224F, 0x00882266, 0x00882279, 0x00882291, 0x008822AC, 
						  0x008822CA, 0x0088216D, 0x0088217D, 0x00882189, 0x008821B0, 0x008821C8, 0x008821E3, 0x008821F9, 0x0088220F, 0x00882222, 
						  0x0088223D, 0x0088230A, 0x008823D8, 0x008823E4, 0x0088240C, 0x0088248B, 0x008824C4, 0x008826BE, 0x008826EA, 0x00882704, 
						  0x008825DE, 0x00882606, 0x00882612, 0x00882625, 0x0088269B, 0x0088277B, 0x00882994, 0x008829A2, 0x008829B8, 0x008829CE, 
						  0x008827B8, 0x00882DAF, 0x00882DCC, 0x00882DDA, 0x008827E3, 0x008827EF, 0x00882F83, 0x00882F97, 0x00882F15, 0x00882F25, 
						  0x00882F5F, 0x00882F77, 0x008830EC, 0x008830FC, 0x00883118, 0x008831A7, 0x008831EB, 0x008831F8, 0x00883230, 0x008832BB, 
						  0x00883309, 0x008833CF, 0x008833E5, 0x0088340B, 0x0088342A, 0x0088343B, 0x0088344C, 0x0088352A, 0x0088353A, 0x0088355B, 
						  0x008835D1, 0x0088385C, 0x00883079, 0x00883089, 0x008830B8, 0x008830C4, 0x008839B6, 0x008839CF, 0x008839F4, 0x00883A05, 
						  0x00883A37, 0x0088392A, 0x0088393A, 0x00883954, 0x0088398E, 0x00883AAF, 0x00883AD7, 0x00883AE3, 0x00883AF9, 0x00883B13, 
						  0x00883C76, 0x00883C9E, 0x00883D0C, 0x00883D63, 0x00883D6C, 0x00883D7E, 0x00883D9C, 0x00883DA5, 0x00883DB7, 0x00883BC7, 
						  0x00883BD7, 0x00883BF1, 0x00883C11, 0x00883C38, 0x00883C51, 0x00883FA3, 0x00883FAC, 0x00883FCD, 0x00883FD6, 0x00883ED6, 
						  0x00883F05, 0x00883F15, 0x00883F3D, 0x00883F59, 0x00883F72, 0x00884161, 0x00884174, 0x008841A2, 0x008841B1, 0x008841C8, 
						  0x008841E3, 0x008840E2, 0x008840F2, 0x00884108, 0x0088411B, 0x0088414B, 0x0088435C, 0x00884431, 0x00884442, 0x00884452, 
						  0x00884475, 0x0088449D, 0x008844B3, 0x008844C6, 0x00884503, 0x00884525, 0x0088453D, 0x0088455F, 0x00884592, 0x008845E5, 
						  0x0088429F, 0x008842A9, 0x008842C3, 0x008842D4, 0x008842E4, 0x008842EE, 0x00884316, 0x008847B2, 0x008847BE, 0x00884871, 
						  0x00884916, 0x00884922, 0x00884A40, 0x00884A62, 0x008849F8, 0x00884A08, 0x00884A20, 0x00884BE5, 0x00884BF1, 0x00884F83, 
						  0x00884F8F, 0x008854A6, 0x008854B2, 0x008854CA, 0x008854DB, 0x0088558A, 0x00885596, 0x008855AC, 0x00885649, 0x0088565A, 
						  0x0088566D, 0x00885682, 0x008857AF, 0x008857BB, 0x00885923, 0x00885937, 0x0088594F, 0x00885966, 0x00885981, 0x008859D6, 
						  0x008858BE, 0x00885A57, 0x00885A63, 0x00885A73, 0x00885A9C, 0x00885C10, 0x00885C1C, 0x00885C2D, 0x00885C62, 0x00885C7C, 
						  0x00885CC6, 0x00885CD2, 0x00885CF3, 0x00885B8F, 0x00885BBA, 0x00885BC5, 0x00885BEE, 0x00885E5D, 0x00885E77, 0x00885E9D, 
						  0x00885EB8, 0x00885EC7, 0x00885EE7, 0x00885EFA, 0x00885F03, 0x00885F19, 0x00885DD5, 0x00885DE5, 0x00885E0F, 0x00885E18, 
						  0x00885E32, 0x00885E4E, 0x00886366, 0x0088636D, 0x0088646D, 0x00886776, 0x00886856, 0x00886974, 0x00886E1D, 0x008870AE, 
						  0x0088716B, 0x00886FF1, 0x008873A9, 0x008873B0, 0x00887459, 0x00887460, 0x008872F9, 0x00887300, 0x008875E6, 0x00887623, 
						  0x00887647, 0x0088766A, 0x00887686, 0x0088769C, 0x008876D2, 0x008876E3, 0x0088753A, 0x0088754A, 0x0088755F, 0x00887568, 
						  0x0088757E, 0x0088758D, 0x008875B4, 0x00887821, 0x0088783E, 0x008877AA, 0x008877BA, 0x008877DE, 0x008877F8, 0x0088780E, 
						  0x00887964, 0x00887982, 0x008879A1, 0x008879B8, 0x008879D7, 0x008879FB, 0x00887A06, 0x00887A27, 0x00887A51, 0x00887A5A, 
						  0x00887A74, 0x00887A7D, 0x0088790E, 0x00887920, 0x0088793C, 0x0088786E, 0x00887C2A, 0x00887C3A, 0x00887C54, 0x00887C64, 
						  0x00887C7A, 0x00887C91, 0x00887CC1, 0x00887CF2, 0x00887D0B, 0x00887DCF, 0x00887EA7, 0x00887EDC, 0x00887FD8, 0x00887FEE, 
						  0x00888014, 0x00887B25, 0x00888027, 0x00888046, 0x00888057, 0x00888068, 0x0088808F, 0x008880D4, 0x00888110, 0x0088817B, 
						  0x00887B3C, 0x008881BB, 0x00888220, 0x0088822C, 0x0088823F, 0x0088828C, 0x00887B6E, 0x00888895, 0x008888AF, 0x008888C9, 
						  0x008888F2, 0x0088890F, 0x00888938, 0x0088894B, 0x00888971, 0x00888804, 0x00888814, 0x00888837, 0x00888852, 0x0088886E, 
						  0x00888BD6, 0x00888BE2, 0x00888C35, 0x00888C41, 0x00888C5C, 0x00888C6A, 0x00888D8F, 0x00888DAE, 0x00888DC4, 0x00888C95, 
						  0x00888CA5, 0x00888CBC, 0x00888CE4, 0x00888D0A, 0x00888D24, 0x00888D43, 0x00888D4C, 0x00888D63, 0x00888D79, 0x00888F29, 
						  0x00889014, 0x0088902A, 0x00889033, 0x00889079, 0x008890BA, 0x00888E3F, 0x00889190, 0x00889199, 0x008891B3, 0x008891CD, 
						  0x008891ED, 0x008891F6, 0x0088920C, 0x0088923E, 0x00889282, 0x0088929D, 0x00888E81, 0x00888E91, 0x00888EFD, 0x0088936A, 
						  0x0088937A, 0x008893A2, 0x008893C8, 0x008893D1, 0x008893EA, 0x008893F5, 0x0088940D, 0x00889416, 0x00889565, 0x00889588, 
						  0x008894B1, 0x008894C1, 0x008894E9, 0x00889512, 0x0088952C, 0x00889546, 0x00889636, 0x00889644, 0x00889661, 0x008896C6, 
						  0x008896E9, 0x00889756, 0x0088976A, 0x008897D6, 0x008897E2, 0x00889AFF, 0x00889BEC, 0x00889BF8, 0x00889C0E, 0x00889E01, 
						  0x00889E0D, 0x00889E8A, 0x00889E96, 0x00889EBA, 0x0088A016, 0x0088A022, 0x0088A046, 0x0088A25A, 0x0088A266, 0x0088A27C, 
						  0x0088A294, 0x0088A29D, 0x0088A2B4, 0x0088A2BD, 0x0088A3E2, 0x0088A32A, 0x0088A33A, 0x0088A39E, 0x0088A76A, 0x0088A7A8, 
						  0x0088A7B8, 0x0088A7CA, 0x0088A7E4, 0x0088A807, 0x0088A82D, 0x0088A843, 0x0088A93A, 0x0088A9EA, 0x0088AA23, 0x0088AACA, 
						  0x0088AB03, 0x0088ABEE, 0x0088ABF5, 0x0088AD2E, 0x0088AD35, 0x0088AF2A, 0x0088AF31, 0x0088AFEA, 0x0088B01C, 0x0088B0EA, 
						  0x0088B13E, 0x0088B176, 0x0088B11C, 0x0088B29A, 0x0088B2EE, 0x0088B2CC, 0x0088B396, 0x0088B3AA, 0x0088B407, 0x0088B43C, 
						  0x0088B4B6, 0x0088B4CA, 0x0088B527, 0x0088B55C, 0x0088B5D6, 0x0088B5EA, 0x0088B647, 0x0088B67C, 0x0088B6F6, 0x0088B70A, 
						  0x0088B767, 0x0088B79C, 0x0088B87A, 0x0088B8BC, 0x0088B9DA, 0x0088B9E1, 0x0088BCCA, 0x0088BCD1, 0x0088BDEA, 0x0088BDF1, 
						  0x0088C12E, 0x0088C3DC, 0x0088C745, 0x0088C75C, 0x0088C7EB, 0x0088C803, 0x0088C81D, 0x0088C850, 0x0088C86F, 0x0088C885, 
						  0x0088C8F4, 0x0088C949, 0x0088C9A3, 0x0088CA03, 0x0088CA4B, 0x0088CA57, 0x0088CACE, 0x0088CADA, 0x0088CB4B, 0x0088CB57, 
						  0x0088CCFE, 0x0088CC1B, 0x0088CC50, 0x0088CC5B, 0x0088CC76, 0x0088CCA3, 0x0088CCC8, 0x0088CE4A, 0x0088CD51, 0x0088CE57, 
						  0x0088CEA9, 0x0088CEE1, 0x0088CD6D, 0x0088CD85, 0x0088CD95, 0x0088CDA5, 0x0088CDBC, 0x0088CE07, 0x0088CE2C, 0x0088CF4B, 
						  0x0088D1C3, 0x0088D1DE, 0x0088D1EE, 0x0088D154, 0x0088D17B, 0x0088D18B, 0x0088D19C, 0x0088D313, 0x0088D326, 0x0088D383, 
						  0x0088D396, 0x0088DA36, 0x0088DAAA, 0x0088DAFE, 0x0088DBE7, 0x0088DDE2, 0x0088DDF7, 0x0088DE0C, 0x0088DE21, 0x0088DE38, 
						  0x0088DE4B, 0x0088DE5E, 0x0088DED5, 0x0088DF6F, 0x0088DF84, 0x0088DCFC, 0x0088DFB6, 0x0088DD8B, 0x0088E15A, 0x0088E1EC, 
						  0x0088E21C, 0x0088E23C, 0x0088E254, 0x0088E1BC, 0x0088E389, 0x0088E3A2, 0x0088E3B7, 0x0088E3D0, 0x0088E3E5, 0x0088E3FE, 
						  0x0088E411, 0x0088E28D, 0x0088E2A8, 0x0088E2B9, 0x0088E2D4, 0x0088E2FD, 0x0088E32D, 0x0088E358, 0x0088E47C, 0x0088E45C, 
						  0x0088E4C0, 0x0088E530, 0x0088E51A, 0x0088E56E, 0x0088E58E, 0x0088E5AE, 0x0088E5CE, 0x0088E6F0, 0x0088E7BF, 0x0088E929, 
						  0x0088E990, 0x0088E9D7, 0x0088EBC2, 0x0088EBD9, 0x0088EBE9, 0x0088EC83, 0x0088EC9A, 0x0088EAB5, 0x0088EAFC, 0x0088EB49, 
						  0x0088ED1C, 0x0088EDB1, 0x0088EE71, 0x0088EF1C, 0x0088F0A5, 0x0088F0D7, 0x0088F11A, 0x0088F14C, 0x0088F2E3, 0x0088F314, 
						  0x0088F343, 0x0088F2B4, 0x0088F4F3, 0x0088F522, 0x0088F562, 0x0088F3E7, 0x0088F471, 0x0088F600, 0x0088F680, 0x0088F700, 
						  0x0088F785, 0x0088F7E5, 0x0088F870, 0x0088F8F0, 0x0088F9B4, 0x0088F9FB, 0x0088FA18, 0x0088FA94, 0x0088FADB, 0x0088FAF8, 
						  0x0088FB60, 0x0088FC10, 0x0088FC5F, 0x0088FE14, 0x0088FE55, 0x0088FE65, 0x0088FE76, 0x0088FE8F, 0x0088FCFE, 0x0088FED5, 
						  0x0088FEF0, 0x0088FF11, 0x0088FF94, 0x0088FFBE, 0x0088FFD9, 0x0088FFF4, 0x0089000F, 0x0089002A, 0x0088FD19, 0x0088FD3F, 
						  0x0088FD57, 0x0088FD76, 0x0089020F, 0x0089013C, 0x0089019E, 0x00890843, 0x00890859, 0x008908A3, 0x008908B9, 0x00890903, 
						  0x00890919, 0x00890963, 0x00890979, 0x008909C3, 0x008909D9, 0x00890DB6, 0x00891158, 0x00891175, 0x0089118A, 0x0089119F, 
						  0x008911CE, 0x008911FF, 0x008915A1, 0x00891642, 0x00891680, 0x008944ED, 0x008947B5, 0x00895171, 0x008952A2, 0x00895899, 
						  0x00895B19, 0x00895D8A, 0x0089611A, 0x00896560, 0x008972EA, 0x008973FA, 0x0089CC16, 0x0089CE2E, 0x0089E9BA, 0x0089E766, 
						  0x0089E7C5, 0x0089EBE2, 0x0089EBF4, 0x008A03D6, 0x008A03F2, 0x008A061B, 0x008A0627, 0x008A0D6C, 0x008A0DAA, 0x008A0DD0, 
						  0x008A0E0B, 0x008A0E37, 0x008A0EDF, 0x008A0F32, 0x008A0F53, 0x008A0CA3, 0x008A0CBF, 0x008A1425, 0x008A1438, 0x008A1557, 
						  0x008A156F, 0x008A158B, 0x008A15AC, 0x008A15CD, 0x008A15F1, 0x008A1615, 0x008A162D, 0x008A1309, 0x008A131D, 0x008A1358, 
						  0x008A173F, 0x008A1764, 0x008A18BC, 0x008A18DB, 0x008A17BD, 0x008A19CC, 0x008A1A2C, 0x008A1EEC, 0x008A1EFC, 0x008A1F19, 
						  0x008A1F64, 0x008A1F72, 0x008A227A, 0x008A2288, 0x008A20D3, 0x008A20F4, 0x008A2124, 0x008A2155, 0x008A2313, 0x008A2321, 
						  0x008A2672, 0x008A2682, 0x008A2832, 0x008A2841, 0x008A2859, 0x008A286B, 0x008A2DAC, 0x008A3390, 0x008A33D5, 0x008A33FC, 
						  0x008A3462, 0x008A3495, 0x008A34C0, 0x008A3E52, 0x008A4155, 0x008A4186, 0x008A419E, 0x008A41D6, 0x008A41EE, 0x008A42E1, 
						  0x008A42F9, 0x008A439E, 0x008A43B6, 0x008A43C7, 0x008A43D6, 0x008A4652, 0x008A4821, 0x008A4831, 0x008A483E, 0x008A4853, 
						  0x008A4A73, 0x008A4B88, 0x008A4EB4, 0x008A4ED4, 0x008A4F66, 0x008A4FBF, 0x008A5004, 0x008A505B, 0x008A5071, 0x008A5092, 
						  0x008A4E07, 0x008A4E2E, 0x008A4E54, 0x008A4E7B, 0x008A569F, 0x008A5766, 0x008A579A, 0x008A57B0, 0x008A57DE, 0x008A580D, 
						  0x008A55C2, 0x008A55D7, 0x008A5645, 0x008A5651, 0x008A5664, 0x008A5E66, 0x008A5D54, 0x008A5D6E, 0x008A5D87, 0x008A5D9D, 
						  0x008A5DD2, 0x008A5DEC, 0x008A5D2E, 0x008A5E0E, 0x008A62E3, 0x008A630A, 0x008A62BE, 0x008A65F0, 0x008A660E, 0x008A663D, 
						  0x008A6658, 0x008A6684, 0x008A6691, 0x008A68BC, 0x008A68DA, 0x008A6917, 0x008A692E, 0x008A6A88, 0x008A6A9F, 0x008A6B1C, 
						  0x008A697A, 0x008A69B4, 0x008A695E, 0x008A6BD8, 0x008A6BE5, 0x008A6C1C, 0x008A6C34, 0x008A6BAE, 0x008A6C81, 0x008A6E79, 
						  0x008A6ECF, 0x008A6F09, 0x008A6D78, 0x008A6D85, 0x008A6DBC, 0x008A6DD4, 0x008A6D4E, 0x008A6E2A, 0x008A7102, 0x008A7117, 
						  0x008A7128, 0x008A71C3, 0x008A71D9, 0x008A71F7, 0x008A7221, 0x008A7074, 0x008A7083, 0x008A708F, 0x008A70A5, 0x008A70BD, 
						  0x008A70D2, 0x008A70E3, 0x008A72FF, 0x008A7314, 0x008A7326, 0x008A7367, 0x008A737A, 0x008A749C, 0x008A787D, 0x008A78B2, 
						  0x008A78BF, 0x008A7A64, 0x008A7A83, 0x008A7A9B, 0x008A7AB3, 0x008A7ACE, 0x008A7BEB, 0x008A8305, 0x008A9616, 0x008A9668, 
						  0x008A9680, 0x008A9693, 0x008A95B5, 0x008A95C5, 0x008A95D1, 0x008A95F9, 0x008A9816, 0x008A983A, 0x008A984D, 0x008A98CC, 
						  0x008A98D5, 0x008A9742, 0x008A9758, 0x008A980A, 0x008A9A1A, 0x008A9A26, 0x008A9A39, 0x008A9A56, 0x008A9A6C, 0x008AA258, 
						  0x008AA26B, 0x008AA2B1, 0x008AA494, 0x008AA803, 0x008AA817, 0x008AA822, 0x008AA781, 0x008AA78D, 0x008AA865, 0x008AA87A, 
						  0x008AA88E, 0x008AA8A6, 0x008AAB3F, 0x008AAB4B, 0x008AAB57, 0x008AAB6F, 0x008AAB9A, 0x008AADD2, 0x008AAD17, 0x008AAD23, 
						  0x008AAD3D, 0x008AADC2, 0x008AB208, 0x008AB3C9, 0x008AB3D2, 0x008AB2E5, 0x008AB52E, 0x008AB35E, 0x008AB37B, 0x008AB38B, 
						  0x008AB3A1, 0x008AB67E, 0x008AB7FD, 0x008AB877, 0x008AB7C2, 0x008AB7D3, 0x008AB7E3, 0x008ABB85, 0x008ABB96, 0x008ABBA2, 
						  0x008ABBC6, 0x008ABC0C, 0x008ABD6B, 0x008ABD77, 0x008AC56A, 0x008AC578, 0x008AC77A, 0x008AC786, 0x008AC8A9, 0x008AC8D4, 
						  0x008AC8E4, 0x008AC938, 0x008AC96C, 0x008AC97E, 0x008AC991, 0x008AC9AE, 0x008AC9C6, 0x008AC9D8, 0x008ACA0C, 0x008ACC0A, 
						  0x008ACC16, 0x008ACC64, 0x008ACDF4, 0x008ACDA1, 0x008ACDAD, 0x008ACDD4, 0x008ACF60, 0x008ACF6C, 0x008ACF93, 0x008ACFD5, 
						  0x008ACE4B, 0x008ACE72, 0x008ACEB2, 0x008ACED3, 0x008ACF2B, 0x008AD439, 0x008AD49D, 0x008AD4A9, 0x008AD4EA, 0x008AD356, 
						  0x008AD364, 0x008AD560, 0x008AD56E, 0x008AD7FA, 0x008AD80C, 0x008AD830, 0x008AD8DB, 0x008AD90E, 0x008AD92D, 0x008ADD9A, 
						  0x008ADDB2, 0x008AE0DB, 0x008AE0F1, 0x008ADFE2, 0x008AE27B, 0x008AE410, 0x008AE456, 0x008AE471, 0x008AE6E3, 0x008AE6EF, 
						  0x008AE707, 0x008AE7C5, 0x008AE7E6, 0x008AE81E, 0x008AE891, 0x008AE8CF, 0x008AE911, 0x008AEA2F, 0x008AEA41, 0x008AEB6A, 
						  0x008AEB87, 0x008AE3C7, 0x008AED77, 0x008AED80, 0x008AEDB2, 0x008AEDE6, 0x008AEE2D, 0x008AEE8C, 0x008AEE95, 0x008AEEAB, 
						  0x008AEEBD, 0x008AEEC6, 0x008AEF0A, 0x008AEFB1, 0x008AEFE5, 0x008AEFEE, 0x008AF056, 0x008AF05F, 0x008AF0D3, 0x008AF0DC, 
						  0x008AF135, 0x008AF13E, 0x008AECAF, 0x008AECBB, 0x008AECFA, 0x008AED0A, 0x008AED20, 0x008AED36, 0x008AED4C, 0x008AF34A, 
						  0x008AF2A9, 0x008AF2B5, 0x008AF2CD, 0x008AF568, 0x008AF58C, 0x008AF5A3, 0x008AF5C6, 0x008AF5D9, 0x008AF43C, 0x008AF5E5, 
						  0x008AF629, 0x008AF64A, 0x008AF68A, 0x008AF711, 0x008AF72A, 0x008AF752, 0x008AF4A6, 0x008AF4B8, 0x008AFDA0, 0x008AFDC2, 
						  0x008AFE3B, 0x008AFCBC, 0x008AFE64, 0x008AFE88, 0x008AFCCA, 0x008AFCE8, 0x008AFCF6, 0x008AFD43, 0x008AFD92, 0x008B0078, 
						  0x008B0086, 0x008B0095, 0x008B00A3, 0x008B00EE, 0x008B0104, 0x008B0119, 0x008B00DF, 0x008B0177, 0x008B019F, 0x008B01AB, 
						  0x008B01DD, 0x008B01E9, 0x008B021B, 0x008B0229, 0x008B074B, 0x008B075D, 0x008B0776, 0x008B078E, 0x008B1174, 0x008B10C3, 
						  0x008B10CF, 0x008B121C, 0x008B1228, 0x008B151A, 0x008B152A, 0x008B154E, 0x008B1564, 0x008B157A, 0x008B15B9, 0x008B15D3, 
						  0x008B15FD, 0x008B160D, 0x008B1625, 0x008B1330, 0x008B134B, 0x008B1385, 0x008B1395, 0x008B13AD, 0x008B23D5, 0x008B23E7, 
						  0x008B274A, 0x008B276D, 0x008B279B, 0x008B2970, 0x008B297B, 0x008B29A2, 0x008B2B0F, 0x008B2CA2, 0x008B2CAE, 0x008B2CC1, 
						  0x008B2D85, 0x008B2DA2, 0x008B2DAB, 0x008B2E45, 0x008B2ED5, 0x008B2F04, 0x008B2FC1, 0x008B32F1, 0x008B3370, 0x008B338D, 
						  0x008B378F, 0x008B3805, 0x008B3824, 0x008B383C, 0x008B3850, 0x008B385C, 0x008B3868, 0x008B3886, 0x008B389A, 0x008B38BD, 
						  0x008B38D2, 0x008B390C, 0x008B3940, 0x008B3958, 0x008B3976, 0x008B397F, 0x008B39FA, 0x008B3A03, 0x008B3A12, 0x008B3A1E, 
						  0x008B3A68, 0x008B3A77, 0x008B3A80, 0x008B36F2, 0x008B419F, 0x008B4DEA, 0x008B52F4, 0x008B5300, 0x008B5341, 0x008B534D, 
						  0x008B50F9, 0x008B53F8, 0x008B50DE, 0x008B5704, 0x008B5710, 0x008B5751, 0x008B575D, 0x008B5509, 0x008B5808, 0x008B54EE, 
						  0x008B85D4, 0x008B8795, 0x008B88A4, 0x008B88B0, 0x008B8B02, 0x008B8EF3, 0x008B907D, 0x008B8DD5, 0x008B9138, 0x008B8E1C, 
						  0x008B8E37, 0x008B9449, 0x008B9455, 0x008B92D1, 0x008B935B, 0x008B9367, 0x008B9381, 0x008B950D, 0x008B9631, 0x008B9818, 
						  0x008B98AB, 0x008B99B2, 0x008B99CA, 0x008B9AB8, 0x008B9B7D, 0x008BA213, 0x008BA2F8, 0x008BA304, 0x008BA50B, 0x008BA5CB, 
						  0x008BA763, 0x008C01EB, 0x008C03BC, 0x008C0425, 0x008C0443, 0x008C07A9, 0x008C08DA, 0x008C0914, 0x008C086D, 0x008C08AA, 
						  0x008C0C72, 0x008C0C7B, 0x008C0C9D, 0x008C0C25, 0x008C0C4D, 0x008C0E90, 0x008C0ED2, 0x008C0EF7, 0x008C0F00, 0x008C0F39, 
						  0x008C0F58, 0x008C0F67, 0x008C0DD8, 0x008C0E15, 0x008C1072, 0x008C108F, 0x008C154E, 0x008C1564, 0x008C1579, 0x008C153F, 
						  0x008C188A, 0x008C1EB3, 0x008C1F27, 0x008C34E1, 0x008C37C5, 0x008C37D1, 0x008C3E3B, 0x008C3E6A, 0x008C3EEE, 0x008C3EFA, 
						  0x008C3DC5, 0x008C3DD1, 0x008C3DE9, 0x008C415B, 0x008C4181, 0x008C4199, 0x008C41BD, 0x008C4123, 0x008C4133, 0x008C493F, 
						  0x008C4960, 0x008C511B, 0x008C5704, 0x008C5723, 0x008C5A0A, 0x008C5EF6, 0x008C5F10, 0x008C5F82, 0x008C687F, 0x008C688F, 
						  0x008C68BB, 0x008C68CB, 0x008C6946, 0x008C6993, 0x008C6A0F, 0x008C6792, 0x008C67A2, 0x008C67CC, 0x008C6838, 0x008C6853, 
						  0x008C6D68, 0x008C6E4D, 0x008C6E92, 0x008C6EDB, 0x008C7313, 0x008C731F, 0x008C775C, 0x008C7CA7, 0x008C7CB3, 0x008C7DB8, 
						  0x008C7E32, 0x008C7E3E, 0x008C8AC8, 0x008C8B22, 0x008C8CBC, 0x008C8D0D, 0x008C8BDE, 0x008C8BEA, 0x008C8F9A, 0x008C9BAC, 
						  0x008C9BBB, 0x008C9A6E, 0x008CA33A, 0x008CA34A, 0x008CA360, 0x008CA382, 0x008CA398, 0x008CA3B0, 0x008CAC61, 0x008CAC70, 
						  0x008CAE41, 0x008CAE4D, 0x008CAE98, 0x008CAD66, 0x008CAD72, 0x008CADBA, 0x008CB11D, 0x008CB129, 0x008CB13A, 0x008CB10B, 
						  0x008CB51C, 0x008CB528, 0x008CB556, 0x008CB57E, 0x008CB587, 0x008CB6D5, 0x008CB27F, 0x008CBD7B, 0x008CBC58, 0x008CBFDA, 
						  0x008CBECE, 0x008CC098, 0x008CC0A4, 0x008CC1EC, 0x008CC3F2, 0x008CC42F, 0x008CC43E, 0x008CC829, 0x008CC89B, 0x008CC95E, 
						  0x008CC9D5, 0x008CC9E9, 0x008CBF69, 0x008CBF82, 0x008CBFA8, 0x008CD0F2, 0x008CD204, 0x008CD25D, 0x008CD28F, 0x008CD2A5, 
						  0x008CD2C7, 0x008CD109, 0x008CD139, 0x008CD15F, 0x008CD198, 0x008CD1A8, 0x008CD46A, 0x008CD487, 0x008CD4B1, 0x008CD4BD, 
						  0x008CD4D0, 0x008CD388, 0x008CD3AE, 0x008CD34F, 0x008CD6DC, 0x008CD7AB, 0x008CD86F, 0x008CD882, 0x008CD94B, 0x008CD986, 
						  0x008CD993, 0x008CDBC6, 0x008CDD23, 0x008CD5F7, 0x008CD607, 0x008CD621, 0x008CD64E, 0x008CDED2, 0x008CDE79, 0x008CE630, 
						  0x008CE642, 0x008CE682, 0x008CE6E4, 0x008CE72B, 0x008CE737, 0x008CED65, 0x008CED74, 0x008CEA81, 0x008CEF32, 0x008CEF44, 
						  0x008CF5C2, 0x008CF5D1, 0x008CF61D, 0x008CF700, 0x008CF72D, 0x008CF739, 0x008D037A, 0x008D0386, 0x008D0051, 0x008D00D9, 
						  0x008D00E5, 0x008D0519, 0x008D0528, 0x008D095E, 0x008D09D3, 0x008D1100, 0x008D110C, 0x008D1128, 0x008D1372, 0x008D139B, 
						  0x008D13A7, 0x008D1940, 0x008D1950, 0x008D1978, 0x008D1794, 0x008D19E8, 0x008D19F8, 0x008D1A20, 0x008D17A0, 0x008D1B11, 
						  0x008D1B72, 0x008D1B7E, 0x008D1D60, 0x008D1C6B, 0x008D1C77, 0x008D223A, 0x008D224A, 0x008D2267, 0x008D2276, 0x008D228C, 
						  0x008D22A2, 0x008D22BA, 0x008D2374, 0x008D2380, 0x008D2774, 0x008D2780, 0x008D3209, 0x008D33A7, 0x008D3268, 0x008D329F, 
						  0x008D32B9, 0x008D331D, 0x008D359C, 0x008D358D, 0x008D3603, 0x008D363D, 0x008D35DF, 0x008D3B2A, 0x008D3B78, 0x008D3B9B, 
						  0x008D3BCA, 0x008D3BE4, 0x008D3C20, 0x008D3C39, 0x008D3CEA, 0x008D3D3F, 0x008D3D74, 0x008D3D95, 0x008D3DAD, 0x008D3DCE, 
						  0x008D4245, 0x008D4262, 0x008D4287, 0x008D429E, 0x008D42B0, 0x008D44D8, 0x008D44E7, 0x008D4663, 0x008D4672, 0x008D4728, 
						  0x008D4737, 0x008D4751, 0x008D43F5, 0x008D4409, 0x008D4496, 0x008D4AE2, 0x008D4B29, 0x008D4B59, 0x008D4B6C, 0x008D4B7D, 
						  0x008D4E56, 0x008D5041, 0x008D50F3, 0x008D4F44, 0x008D5176, 0x008D5188, 0x008D51A4, 0x008D51C4, 0x008D5215, 0x008D4F50, 
						  0x008D522F, 0x008D5238, 0x008D524E, 0x008D5268, 0x008D5271, 0x008D52C6, 0x008D52E0, 0x008D5320, 0x008D538F, 0x008D539D, 
						  0x008D5408, 0x008D5502, 0x008D4F85, 0x008D5573, 0x008D5610, 0x008D4F9B, 0x008D4FD4, 0x008D4FFC, 0x008D501D, 0x008D57A4, 
						  0x008D5854, 0x008D5871, 0x008D58B0, 0x008D58DA, 0x008D58F7, 0x008D5941, 0x008D5986, 0x008D59B6, 0x008D56A7, 0x008D5B74, 
						  0x008D56B3, 0x008D5C6C, 0x008D5D09, 0x008D5D2C, 0x008D56D3, 0x008D5E45, 0x008D5E9A, 0x008D609E, 0x008D60AE, 0x008D60C8, 
						  0x008D60D8, 0x008D60EF, 0x008D6117, 0x008D6131, 0x008D617A, 0x008D6183, 0x008D61C4, 0x008D61CD, 0x008D61FE, 0x008D6207, 
						  0x008D6259, 0x008D5F56, 0x008D629E, 0x008D62EA, 0x008D630C, 0x008D5F62, 0x008D63B5, 0x008D640F, 0x008D641B, 0x008D6447, 
						  0x008D6453, 0x008D5F99, 0x008D5FB7, 0x008D5FCA, 0x008D5FE8, 0x008D6650, 0x008D66A3, 0x008D66CF, 0x008D6511, 0x008D6726, 
						  0x008D651D, 0x008D653D, 0x008D65BA, 0x008D6FC6, 0x008D6FD6, 0x008D6FFE, 0x008D7014, 0x008D702A, 0x008D71A5, 0x008D71B1, 
						  0x008D729A, 0x008D7CD3, 0x008D7CDF, 0x008D86ED, 0x008D86FC, 0x008D89C6, 0x008D8E20, 0x008D8E6C, 0x008D8E78, 0x008D8F84, 
						  0x008D8F90, 0x008D8FAC, 0x008D9093, 0x008D90A4, 0x008D9127, 0x008D9145, 0x008D919E, 0x008D91B1, 0x008D91C6, 0x008D91E7, 
						  0x008D920A, 0x008D921D, 0x008D9233, 0x008D925E, 0x008D932D, 0x008D935A, 0x008D937E, 0x008D939C, 0x008D8D5E, 0x008D93EE, 
						  0x008D941F, 0x008D942B, 0x008D967E, 0x008D968A, 0x008D9979, 0x008D99BF, 0x008D9A60, 0x008D9A8E, 0x008D9AB0, 0x008D9AC5, 
						  0x008D9AE3, 0x008D9A7F, 0x008D9B53, 0x008D9B7B, 0x008D9BB3, 0x008D9BD2, 0x008D9B3F, 0x008D9C2E, 0x008D9C55, 0x008D9C95, 
						  0x008D9BFF, 0x008D9ED1, 0x008D9D7A, 0x008D9F01, 0x008D9F3B, 0x008D9F63, 0x008D9F8C, 0x008D9FAB, 0x008D9FC4, 0x008D9FE0, 
						  0x008DA017, 0x008D9DB7, 0x008D9DD1, 0x008D9DE4, 0x008D9E15, 0x008DA180, 0x008DA1A4, 0x008DA1EC, 0x008DA1DD, 0x008DA248, 
						  0x008DA26B, 0x008DA2A9, 0x008DA22F, 0x008DA39C, 0x008DA3AC, 0x008DA3C4, 0x008DA3FA, 0x008DA4D5, 0x008DA4E1, 0x008DA7F9, 
						  0x008DA810, 0x008DA81F, 0x008DA835, 0x008DA84D, 0x008DA860, 0x008DA87E, 0x008DA8F5, 0x008DA901, 0x008DA71C, 0x008DA72F, 
						  0x008DA73E, 0x008DA756, 0x008DAA61, 0x008DAA72, 0x008DAA88, 0x008DAA9E, 0x008DAB8E, 0x008DAB9A, 0x008DAC0F, 0x008DAC3C, 
						  0x008DAC64, 0x008DB711, 0x008DB71D, 0x008DB752, 0x008DBC1B, 0x008DBC27, 0x008DBC33, 0x008DBD0D, 0x008DBD19, 0x008DBD25, 
						  0x008DBE15, 0x008DBE2F, 0x008DBE48, 0x008DBE64, 0x008DBE7A, 0x008DBEE1, 0x008DBF62, 0x008DBF94, 0x008DBFC6, 0x008DC010, 
						  0x008DC05F, 0x008DC07D, 0x008DC08E, 0x008DC0FC, 0x008DC111, 0x008DC136, 0x008DC160, 0x008DC190, 0x008DC1B1, 0x008DC1C2, 
						  0x008DC1D6, 0x008DC1FD, 0x008DC223, 0x008DC232, 0x008DC24E, 0x008DC266, 0x008DC283, 0x008DC29C, 0x008DC2AB, 0x008DC4F1, 
						  0x008DC53E, 0x008DC593, 0x008DC5DA, 0x008DC497, 0x008DC691, 0x008DC6B4, 0x008DC6FA, 0x008DC822, 0x008DC88C, 0x008DC994, 
						  0x008DC9BF, 0x008DC9CD, 0x008DCE47, 0x008DCE53, 0x008DCE73, 0x008DD0F8, 0x008DCFFD, 0x008DD025, 0x008DD04D, 0x008DD05F, 
						  0x008DD06D, 0x008DD138, 0x008DD148, 0x008DD166, 0x008DD17D, 0x008DD388, 0x008DD3CC, 0x008DD29F, 0x008DD2F1, 0x008DD442, 
						  0x008DD454, 0x008DD4A2, 0x008DD4B4, 0x008DD999, 0x008DD9A5, 0x008DDAE2, 0x008DDB00, 0x008DDD95, 0x008DDD04, 0x008DDFB5, 
						  0x008DDE2B, 0x008DDE37, 0x008DE108, 0x008DE114, 0x008DE4DC, 0x008DE4E8, 0x008DE79C, 0x008DE900, 0x008DE90C, 0x008DE96C, 
						  0x008DEC09, 0x008DE8A0, 0x008DF0AA, 0x008DF0B9, 0x008DF134, 0x008DF146, 0x008DF15F, 0x008DF6C9, 0x008DF927, 0x008DF95C, 
						  0x008DFA69, 0x008DFA96, 0x008DFADC, 0x008DFB11, 0x008DFBE0, 0x008DFC7C, 0x008DFCAE, 0x008E000B, 0x008E0035, 0x008E010E, 
						  0x008E01B4, 0x008E01DD, 0x008E01E6, 0x008E023F, 0x008E02A5, 0x008E02C4, 0x008E02FF, 0x008E030C, 0x008E031B, 0x008E033B, 
						  0x008E0347, 0x008E040D, 0x008DFF99, 0x008DFFD2, 0x008DFFFF, 0x008E0916, 0x008E0988, 0x008E0AD7, 0x008E0AEB, 0x008E0B20, 
						  0x008E0EF5, 0x008E0F01, 0x008E0F23, 0x008E0F2C, 0x008E1134, 0x008E1147, 0x008E1862, 0x008E1887, 0x008E1893, 0x008E18B4, 
						  0x008E18C0, 0x008E1912, 0x008E1951, 0x008E195D, 0x008E1D41, 0x008E1DEA, 0x008E1DF9, 0x008E2053, 0x008E2062, 0x008E20BD, 
						  0x008E20CC, 0x008E220B, 0x008E2430, 0x008E243E, 0x008E245C, 0x008E2483, 0x008E24AB, 0x008E24E2, 0x008E2538, 0x008E2575, 
						  0x008E25A3, 0x008E25EA, 0x008E2614, 0x008E2373, 0x008E237F, 0x008E26F0, 0x008E2702, 0x008E2740, 0x008E2796, 0x008E2D4B, 
						  0x008E2D5D, 0x008E30F9, 0x008E3A6E, 0x008E3A80, 0x008E3AD6, 0x008E3AE2, 0x008E3B1A, 0x008E3D64, 0x008E3D92, 0x008E3DB2, 
						  0x008E3DE6, 0x008E40B7, 0x008E40C3, 0x008E4253, 0x008E41B9, 0x008E41CE, 0x008E41F9, 0x008E43BA, 0x008E43CA, 0x008E4401, 
						  0x008E4419, 0x008E4455, 0x008E44CB, 0x008E44D7, 0x008E4BE4, 0x008E4BF0, 0x008E55EC, 0x008E5978, 0x008E5A14, 0x008E5A23, 
						  0x008E5ACD, 0x008E6B72, 0x008E6B8F, 0x008E6BC3, 0x008E6BE0, 0x008E6BFD, 0x008E6C15, 0x008E6C3F, 0x008E6C5A, 0x008E6C7E, 
						  0x008E6D71, 0x008E6D8A, 0x008E6DA1, 0x008E6E38, 0x008E6E53, 0x008E5DE9, 0x008E5DF5, 0x008E5E73, 0x008E60C0, 0x008E60DB, 
						  0x008E60FB, 0x008E6112, 0x008E5BBD, 0x008E615A, 0x008E6182, 0x008E619E, 0x008E61E4, 0x008E61F7, 0x008E620C, 0x008E5BEC, 
						  0x008E5BFB, 0x008E6797, 0x008E67BC, 0x008E69BE, 0x008E6A11, 0x008E6A72, 0x008E6A8B, 0x008E6A9C, 0x008E6ADF, 0x008E6B06, 
						  0x008E6B1D, 0x008E6B55, 0x008E6EED, 0x008E6F66, 0x008E6F96, 0x008E6FC5, 0x008E72D0, 0x008E7303, 0x008E77D4, 0x008E77FE, 
						  0x008E7846, 0x008E7859, 0x008E7868, 0x008E7874, 0x008E771A, 0x008E774C, 0x008E7771, 0x008E7783, 0x008E77A8, 0x008E77BB, 
						  0x008E7A2C, 0x008E7A4C, 0x008E7A62, 0x008E7ADB, 0x008E7AFA, 0x008E78ED, 0x008E791A, 0x008E7926, 0x008E7F03, 0x008E7F19, 
						  0x008E8022, 0x008E8061, 0x008E8081, 0x008E809F, 0x008E7D80, 0x008E7DE0, 0x008E8149, 0x008E80CF, 0x008E836A, 0x008E837D, 
						  0x008E83AC, 0x008E83BB, 0x008E83D6, 0x008E83EC, 0x008E827C, 0x008E828B, 0x008E82A6, 0x008E82F2, 0x008E8301, 0x008E832B, 
						  0x008E8346, 0x008E8352, 0x008E8538, 0x008E892A, 0x008E8A4A, 0x008E96DF, 0x008E976F, 0x008EA355, 0x008EA367, 0x008EB129, 
						  0x008EB18E, 0x008EB481, 0x008EB653, 0x008EB65F, 0x008EB722, 0x008EB73E, 0x008EB778, 0x008EB7E8, 0x008EC4BD, 0x008ECE2D, 
						  0x008ECE48, 0x008ECE83, 0x008EDB93, 0x008EE6FD, 0x008EF106, 0x008EF115, 0x008EF52D, 0x008EF578, 0x008EFF0C, 0x008EFFAC, 
						  0x008EFFD0, 0x008F008C, 0x008F00A9, 0x008F00CD, 0x008F016A, 0x008F0297, 0x008F02BD, 0x008F0911, 0x008F09C5, 0x008F0C88, 
						  0x008F0CDF, 0x008F1C70, 0x008F1E65, 0x008F1E81, 0x008F305A, 0x008F30A5, 0x008F3433, 0x008F3442, 0x008F35D1, 0x008F38DC, 
						  0x008F3A9C, 0x008F3B06, 0x008F3B59, 0x008F3B68, 0x008F3BD5, 0x008F3BBD, 0x008F4783, 0x008F478F, 0x008F47A7, 0x008F47BB, 
						  0x008F4A2E, 0x008F4A53, 0x008F4ACB, 0x008F5CD3, 0x008F5CF2, 0x008F5D12, 0x008F5D82, 0x008F5DA1, 0x008F5E0E, 0x008F595B, 
						  0x008F6805, 0x008F6811, 0x008F681D, 0x008F6829, 0x008F6832, 0x008F683B, 0x008F6B0A, 0x008F6B16, 0x008F6B76, 0x008F6B82, 
						  0x008F6BA7, 0x008F6F0A, 0x008F6F16, 0x008F712D, 0x008F713D, 0x008F750D, 0x008F7519, 0x008F75EE, 0x008F75FA, 0x008F767A, 
						  0x008F7686, 0x008F7820, 0x008F76FC, 0x008F77CB, 0x008F7AF4, 0x008F7B04, 0x008F7B1C, 0x008F7B3B, 0x008F7B63, 0x008F7B7F, 
						  0x008F7BEC, 0x008F7BF8, 0x008F7C10, 0x008F7C38, 0x008F7C54, 0x008F7D7E, 0x008F7DA0, 0x008F79E4, 0x008F79F0, 0x008F7A66, 
						  0x008F7A72, 0x008F85D2, 0x008F861C, 0x008F8628, 0x008F8631, 0x008F8770, 0x008F8781, 0x008F878A, 0x008F87F4, 0x008F8800, 
						  0x008F8818, 0x008F8825, 0x008F8B0E, 0x008F8B1A, 0x008F8D52, 0x008F8D62, 0x008F8D89, 0x008F8E17, 0x008F8E36, 0x008F8E50, 
						  0x008F8E77, 0x008F8FF3, 0x008F8F60, 0x008F8F81, 0x008F8F99, 0x008F8FC0, 0x008F9075, 0x008F9094, 0x008F916A, 0x008F9176, 
						  0x008F918C, 0x008F92C3, 0x008F92CE, 0x008F92D9, 0x008F92F0, 0x008F930E, 0x008F931E, 0x008F9227, 0x008F9237, 0x008F9251, 
						  0x008F926E, 0x008F928B, 0x008F91CE, 0x008F92AC, 0x008F94BE, 0x008F94D5, 0x008F94F0, 0x008F951A, 0x008F9624, 0x008F9630, 
						  0x008F9646, 0x008F96A9, 0x008F96D0, 0x008F9908, 0x008F992E, 0x008F9A1B, 0x008F9A2A, 0x008F9A63, 0x008F9AA3, 0x008F9B6B, 
						  0x008F9BAA, 0x008F9BBD, 0x008F9BFD, 0x008F9C22, 0x008F9ED3, 0x008F9EF1, 0x008F9F1A, 0x008F9F3F, 0x008FA239, 0x008FA24D, 
						  0x008FA265, 0x008FA278, 0x008FA281, 0x008FA2E7, 0x008FAD46, 0x008FADBF, 0x008FAE21, 0x008FACDC, 0x008FACE8, 0x008FB264, 
						  0x008FB27C, 0x008FB29E, 0x008FB2B2, 0x008FB2C8, 0x008FB2FC, 0x008FB0AB, 0x008FB0C3, 0x008FB0DD, 0x008FB0FE, 0x008FB115, 
						  0x008FB403, 0x008FB419, 0x008FB42B, 0x008FB525, 0x008FB53B, 0x008FB66F, 0x008FB67D, 0x008FB6A7, 0x008FB7F7, 0x008FB819, 
						  0x008FB83E, 0x008FB761, 0x008FB77B, 0x008FB7BB, 0x008FB9CF, 0x008FB9F3, 0x008FB9FC, 0x008FB90A, 0x008FB91A, 0x008FB96D, 
						  0x008FB993, 0x008FB99C, 0x008FB9BF, 0x008FC0C5, 0x008FC4B7, 0x008FC676, 0x008FC707, 0x008FC715, 0x008FC737, 0x008FC74F, 
						  0x008FC75C, 0x008FC7BB, 0x008FC7C7, 0x008FC5CA, 0x008FC5DA, 0x008FC817, 0x008FC823, 0x008FC836, 0x008FD8D0, 0x008FE092, 
						  0x008FE0A1, 0x008FE0BE, 0x008FE154, 0x008FE230, 0x008FE2EA, 0x008FEC09, 0x008FEE0E, 0x008FEE1F, 0x008FEE37, 0x008FEF43, 
						  0x008FF038, 0x008FEAF0, 0x008FF19A, 0x008FF1C2, 0x008FF306, 0x008FF211, 0x008FF223, 0x008FF248, 0x008FF25A, 0x008FF27F, 
						  0x008FF290, 0x008FF2A3, 0x008FF2B1, 0x008FF2C2, 0x008FF2D0, 0x008FF2EE, 0x008FF381, 0x008FF3B4, 0x008FF414, 0x008FF423, 
						  0x008FF650, 0x008FF697, 0x00901669, 0x0090167B, 0x009017B8, 0x00901985, 0x00901D4A, 0x00901D7F, 0x00901D14, 0x00901E89, 
						  0x00901EA6, 0x00901F76, 0x00901F82, 0x00901FB7, 0x00901FDE, 0x00902068, 0x00902088, 0x0090209F, 0x009020C0, 0x009020CE, 
						  0x009020F2, 0x0090225C, 0x00902442, 0x009027B5, 0x009029D0, 0x00902A80, 0x0090329B, 0x009032C8, 0x0090342B, 0x00903458, 
						  0x00903991, 0x00903A31, 0x00904E36, 0x00904E98, 0x0090576F, 0x0090578A, 0x009057D8, 0x00905A44, 0x0090648D, 0x009064FD, 
						  0x0090656D, 0x0090667D, 0x009067ED, 0x009068AD, 0x0090699D, 0x00906A0D, 0x00906AB5, 0x00906ADC, 0x00906B60, 0x00906B7A, 
						  0x00906BBF, 0x00906BE7, 0x0090731F, 0x0090739B, 0x00907453, 0x00907474, 0x00907482, 0x009074D8, 0x009077FD, 0x009078E9, 
						  0x0090793E, 0x00907E78, 0x00907EB2, 0x00908245, 0x0090826F, 0x00908291, 0x009082AC, 0x009082CA, 0x009082DC, 0x009082F6, 
						  0x00908306, 0x00908367, 0x00908389, 0x009083BA, 0x009083D1, 0x00908408, 0x0090843C, 0x00908453, 0x0090848A, 0x00908163, 
						  0x009081AA, 0x009081C2, 0x009081DF, 0x009081FD, 0x0090856D, 0x00908585, 0x00908591, 0x0090887D, 0x00908994, 0x00908A26, 
						  0x00908F28, 0x00908F50, 0x009093BE, 0x00909641, 0x009096A1, 0x00909743, 0x00909BEA, 0x0090A1E5, 0x0090A27E, 0x0090A28A, 
						  0x0090A2A9, 0x0090A2E0, 0x0090A302, 0x0090A3CA, 0x0090A3E3, 0x0090A37F, 0x0090A41B, 0x0090A593, 0x0090A50C, 0x0090A51C, 
						  0x0090A538, 0x0090A563, 0x0090A9BF, 0x00919BA5, 0x00919DD1, 0x00919E61, 0x00919EB4, 0x00919EE5, 0x00919DAC, 0x00919DBB, 
						  0x0091A018, 0x0091A024, 0x0091A243, 0x0091A25B, 0x0091A26C, 0x0091A296, 0x0091A2A9, 0x0091A2C9, 0x0091A2DB, 0x0091A191, 
						  0x0091A1AF, 0x0091A1C2, 0x0091A14E, 0x0091A229, 0x0091A445, 0x0091A4A3, 0x0091A745, 0x0091A753, 0x0091A6C5, 0x0091A6D1, 
						  0x0091A7F7, 0x0091A8AD, 0x0091A8B9, 0x0091AA52, 0x0091AAF6, 0x0091ACAC, 0x0091ACB7, 0x0091ACCA, 0x0091AD65, 0x0091AD93, 
						  0x0091ADF4, 0x0091ADFF, 0x0091AB90, 0x0091AC1A, 0x0091AC38, 0x0091B256, 0x0091B81F, 0x0091C896, 0x0091D505, 0x0091D5FE, 
						  0x0091D9C1, 0x0091DD2D, 0x0091E04F, 0x0091F0C2, 0x0091F10D, 0x0091F18F, 0x0091F1A8, 0x0091EFB4, 0x0091F4A4, 0x0091EFEF, 
						  0x0091F6A6, 0x0091FA8D, 0x0091FC3D, 0x0091FC77, 0x0092013C, 0x009201A6, 0x009201F9, 0x00920208, 0x00921425, 0x00921435, 
						  0x00921599, 0x009215B9, 0x009215D6, 0x00921603, 0x00921622, 0x00921634, 0x0092164A, 0x0092167C, 0x0092168A, 0x009216FA, 
						  0x00921714, 0x00921729, 0x00921769, 0x009214BF, 0x00921791, 0x009217A3, 0x009217C1, 0x009217E8, 0x009214D8, 0x009214F1, 
						  0x00921502, 0x00921514, 0x0092155B, 0x0092156B, 0x009218D3, 0x009218E6, 0x0092193D, 0x00922271, 0x009231BA, 0x00923979, 
						  0x009249B7, 0x00924CCF, 0x00924D33, 0x00924BAE, 0x00924BDB, 0x00925036, 0x00925061, 0x009250A0, 0x009250BE, 0x0092525F, 
						  0x00925553, 0x0092556D, 0x00925C7B, 0x00925C87, 0x00925FAB, 0x00925FED, 0x0092607A, 0x0092610A, 0x0092612B, 0x0092617A, 
						  0x0092625B, 0x00926333, 0x00926375, 0x009263EC, 0x0092642F, 0x009264C2, 0x00925E61, 0x009266AB, 0x009266B7, 0x00926FA2, 
						  0x00926FAE, 0x00926FC9, 0x00926FE4, 0x0092749B, 0x009274A7, 0x00927807, 0x00927821, 0x009278C5, 0x00927B00, 0x00927BD4, 
						  0x00927CC1, 0x00927F00, 0x00927FBB, 0x0092883B, 0x00928860, 0x00928889, 0x009288FE, 0x00928AAB, 0x00928ACC, 0x00928AF3, 
						  0x00928DAE, 0x00928D9C, 0x009290E6, 0x0092910D, 0x00929155, 0x0092917B, 0x0092918C, 0x009291AD, 0x00928FEE, 0x009291E7, 
						  0x00929216, 0x00929236, 0x0092924B, 0x0092927E, 0x009292BE, 0x009292EC, 0x0092900A, 0x00929028, 0x00929049, 0x00929064, 
						  0x00929811, 0x00929855, 0x00929872, 0x00929881, 0x00929C07, 0x0092B149, 0x0092B39C, 0x0092BE96, 0x0092BEA8, 0x0092BEE8, 
						  0x0092BEFB, 0x0092BF0F, 0x0092BF53, 0x0092BF8A, 0x0092BFA0, 0x0092BFF5, 0x0092F149, 0x0092F13F, 0x00930A9A, 0x00931A0A, 
						  0x00933272, 0x009335E8, 0x00933FFA, 0x009340DE, 0x009340F3, 0x009344C2, 0x009344D7, 0x00934774, 0x00934930, 0x00934FD5, 
						  0x00934FEA, 0x00935BBD, 0x00935C5A, 0x00935D0B, 0x00935D90, 0x00935E08, 0x00935E16, 0x00936C83, 0x00936BF2, 0x00936DF7, 
						  0x00936E0F, 0x0093772D, 0x009378DE, 0x00937E7D, 0x00938290, 0x009389D8, 0x009389E4, 0x00938D34, 0x00938F2C, 0x00939291, 
						  0x00939793, 0x009397E5, 0x00939855, 0x0093986A, 0x009399B1, 0x009399CE, 0x009399F9, 0x0093999F, 0x00939B93, 0x00939E6A, 
						  0x00939E84, 0x00939EB6, 0x00939D76, 0x00939EF1, 0x00939F13, 0x00939D85, 0x00939FCC, 0x00939FDC, 0x0093A00E, 0x0093A05C, 
						  0x00939D97, 0x00939DB7, 0x00939E5A, 0x0093A1F6, 0x0093F548, 0x0093F560, 0x0093F59A, 0x0093F5C1, 0x0093F71D, 0x0093F73E, 
						  0x0093FAA3, 0x0093FAB5, 0x0093FB17, 0x0093FB2D, 0x0093FCB4, 0x0093FCE1, 0x0093FBF3, 0x0093FBFF, 0x0093FC0E, 0x0093FC2B, 
						  0x0093FC65, 0x0093FC94, 0x0093FD9F, 0x0093FE18, 0x0093FE30, 0x0093FE66, 0x0093FE75, 0x00940960, 0x00940A4B, 0x009427F7, 
						  0x00942D32, 0x00942DD6, 0x00942E40, 0x00942F03, 0x00942F6E, 0x00942FB3, 0x0094306B, 0x00943166, 0x0094317E, 0x009432E9, 
						  0x0094335D, 0x00943397, 0x00943432, 0x00943452, 0x00943464, 0x00943484, 0x009434FA, 0x0094376E, 0x009437A3, 0x00943683, 
						  0x009436A0, 0x009436B6, 0x009436CE, 0x009436E6, 0x00943706, 0x0094366C, 0x0094372F, 0x0094373E, 0x00943757, 0x00943858, 
						  0x009438A6, 0x009438BE, 0x009438D6, 0x009438EE, 0x009439E3, 0x00943B81, 0x00943BA2, 0x00943BC3, 0x00943C28, 0x00943C49, 
						  0x00943C58, 0x00943C99, 0x00943CB6, 0x00943C8A, 0x00943F29, 0x00943F4B, 0x00943FAC, 0x00943FBB, 0x00943FF4, 0x00943F9C, 
						  0x00944074, 0x009442B4, 0x0094449A, 0x009444BC, 0x009444FB, 0x0094451B, 0x0094456C, 0x009444EC, 0x00944AA1, 0x00944AE1, 
						  0x00944AF4, 0x00944B03, 0x00944B5C, 0x00944CC0, 0x00944CE5, 0x00944BBB, 0x00944D53, 0x00944BDB, 0x00944BAC, 0x00944F8B, 
						  0x00944FAD, 0x00944FEB, 0x0094500B, 0x00944FDC, 0x0094509B, 0x00945365, 0x00945389, 0x00947E67, 0x0094812F, 0x00948193, 
						  0x0094800E, 0x0094803B, 0x009483E6, 0x00948411, 0x00948450, 0x0094846E, 0x0094860F, 0x00948A77, 0x00948D3F, 0x00948DA3, 
						  0x00948C1E, 0x00948C4B, 0x00948F86, 0x00948FB1, 0x00948FF0, 0x0094900E, 0x009491AF, 0x00949561, 0x0094959B, 0x009495AA, 
						  0x009495FD, 0x0094962D, 0x00949676, 0x009496AB, 0x00949739, 0x0094981D, 0x0094982B, 0x0094985A, 0x00949A3B, 0x00949AE3, 
						  0x00949AF1, 0x00949B1A, 0x00949B41, 0x00949B4F, 0x00949C33, 0x00949C41, 0x00949C6A, 0x0094A204, 0x0094A21D, 0x0094A241, 
						  0x0094A33A, 0x0094A4C0, 0x0094A545, 0x0094A557, 0x0094A579, 0x0094A43E, 0x0094A460, 0x0094A4AE, 0x0094A73E, 0x0094A758, 
						  0x0094A818, 0x0094A857, 0x0094A8B2, 0x0094A93F, 0x0094A67F, 0x0094A9A9, 0x0094A9C6, 0x0094A99A, 0x0094CCE7, 0x0094D04F, 
						  0x0094D0B3, 0x0094CF2E, 0x0094CF5B, 0x0094D2C6, 0x0094D2F1, 0x0094D330, 0x0094D34E, 0x0094D4EF, 0x0094D80A, 0x0094DB59, 
						  0x0094E1A0, 0x0094E24F, 0x0094E2E6, 0x0094E733, 0x0094E747, 0x0094E767, 0x0094E7B9, 0x0094E844, 0x0094EA99, 0x0094EADC, 
						  0x0094EAFC, 0x0094EB23, 0x0094EB9D, 0x0094E97A, 0x0094EC31, 0x0094EC99, 0x0094ECB4, 0x0094ED57, 0x0094ED6D, 0x0094ED9E, 
						  0x0094EDDA, 0x0094EE05, 0x0094E99F, 0x0094EEBA, 0x0094EFEE, 0x0094F05E, 0x0094F08C, 0x0094F0C8, 0x0094F25A, 0x0094F275, 
						  0x0094F2E8, 0x0094F3E7, 0x0094EA4F, 0x0094FC71, 0x0094FCA6, 0x0094FCEC, 0x0094FD2F, 0x0094FD5F, 0x0094FD7D, 0x0094FDB4, 
						  0x0094FDCB, 0x0094FBC7, 0x0094FBEC, 0x0094FC02, 0x0094FC3E, 0x0094FE79, 0x0094FE91, 0x00950004, 0x009500BC, 0x009500C8, 
						  0x009500DF, 0x009500EB, 0x0095012D, 0x009501CF, 0x00950242, 0x00950254, 0x00950423, 0x00950440, 0x00950456, 0x0095046E, 
						  0x00950486, 0x009504A6, 0x0095040C, 0x009504CF, 0x009504DE, 0x009504FB, 0x0095068E, 0x009506F3, 0x00950733, 0x009507CF, 
						  0x009507E1, 0x00950857, 0x009505F5, 0x009509CE, 0x00950A03, 0x009508E3, 0x00950900, 0x00950916, 0x0095092E, 0x00950946, 
						  0x00950966, 0x009508CC, 0x0095098F, 0x0095099E, 0x009509B7, 0x00950A56, 0x00950A6E, 0x00950A86, 0x00950A9E, 0x00950BC8, 
						  0x00950CE0, 0x00950D2B, 0x00950E3C, 0x00950E4B, 0x00950E6C, 0x00950CA9, 0x00950CB9, 0x00950CC8, 0x00950EF5, 0x00950F0D, 
						  0x00950F91, 0x00950FB7, 0x00950FE9, 0x009511C3, 0x009511D5, 0x00951167, 0x00952A6C, 0x00952A8C, 0x00952AD8, 0x00952AE4, 
						  0x00952AFF, 0x00952B0B, 0x00954497, 0x009547CF, 0x00954833, 0x009546AE, 0x009546DB, 0x00954A46, 0x00954A71, 0x00954AB0, 
						  0x00954ACE, 0x00954C6F, 0x00954F36, 0x00954F45, 0x00954F99, 0x00954FF7, 0x009552CF, 0x00955333, 0x009551AE, 0x009551DB, 
						  0x00955516, 0x00955541, 0x00955580, 0x0095559E, 0x0095573F, 0x00955D49, 0x00956169, 0x00956AD3, 0x00956A17, 0x00956A5E, 
						  0x00956A80, 0x00956AAA, 0x00956C44, 0x00956C54, 0x00956C6A, 0x00956C7D, 0x00956CE7, 0x00956F2C, 0x00956F7E, 0x00956F92, 
						  0x00956FBC, 0x009571C8, 0x009571E7, 0x0095721B, 0x00957227, 0x00957317, 0x009573C6, 0x00957419, 0x0095742D, 0x00957447, 
						  0x009575B3, 0x009575C2, 0x00957606, 0x00957617, 0x00957545, 0x00957574, 0x00957686, 0x00957692, 0x009576AF, 0x009576C5, 
						  0x009576F7, 0x0095766C, 0x00957725, 0x00957766, 0x0095777E, 0x00957796, 0x00957847, 0x00957983, 0x00957994, 0x009579B5, 
						  0x009579E7, 0x00957A56, 0x00957B03, 0x00957B11, 0x0095B487, 0x0095B563, 0x0095B7DF, 0x0095B843, 0x0095B6BE, 0x0095B6EB, 
						  0x0095B8C0, 0x0095B8D4, 0x0095BAA6, 0x0095BAD1, 0x0095BB10, 0x0095BB2E, 0x0095BCCF, 0x0095BF1A, 0x0095BF87, 0x0095C26F, 
						  0x0095C2D3, 0x0095C14E, 0x0095C17B, 0x0095C4B6, 0x0095C4E1, 0x0095C520, 0x0095C53E, 0x0095C6DF, 0x0095CCA9, 0x0095D0B9, 
						  0x0095DD03, 0x0095DD12, 0x0095DDA0, 0x0095DDAC, 0x0095DDBF, 0x0095DDC8, 0x0095E28C, 0x0095E351, 0x0095E35D, 0x0095E36C, 
						  0x0095E389, 0x0095E574, 0x0095E5DB, 0x0095E5CC, 0x0095E666, 0x0095E7CE, 0x0095E8D3, 0x0095E8EA, 0x0095EAD9, 0x0095EAE8, 
						  0x0095EBA9, 0x0095EBCA, 0x0095EA07, 0x0095EA13, 0x0095EA22, 0x0095EA3F, 0x0095EACD, 0x0095EC76, 0x0095EC8E, 0x0095EDE1, 
						  0x0095EDFD, 0x0095EE20, 0x0095EE9B, 0x0095EEBE, 0x0095EF3F, 0x0095ED79, 0x0095EDA8, 0x0095F123, 0x0095F17D, 0x0095F192, 
						  0x0095F027, 0x0095F033, 0x0095F042, 0x0095F05F, 0x0095F3B6, 0x0095F3CE, 0x0095F615, 0x0095F66B, 0x0095F4C9, 0x0095F698, 
						  0x0095F6A7, 0x0095F6C4, 0x0095F68C, 0x0095F7A6, 0x0095F7BE, 0x0095F9A6, 0x0095FA9D, 0x0095FAB4, 0x0095F8BF, 0x0095FBEC, 
						  0x0095FC4D, 0x0095FB93, 0x0095FC8C, 0x0095FC9B, 0x0095FCBB, 0x0095FD0E, 0x0095FC7C, 0x0095FDD6, 0x0095FDEE, 0x0095FE06, 
						  0x0095FFF8, 0x0095FF21, 0x00960768, 0x00960774, 0x0096233E, 0x009623BE, 0x009638B8, 0x009638C4, 0x00964035, 0x00964079, 
						  0x0096406A, 0x0096508A, 0x009650B4, 0x009650ED, 0x0096513F, 0x00965151, 0x0096515F, 0x00965178, 0x00964F74, 0x0096528E, 
						  0x009652AF, 0x009652BE, 0x00965394, 0x009653A6, 0x00965433, 0x0096537F, 0x00965479, 0x0096549A, 0x009654A9, 0x009654DB, 
						  0x009654FC, 0x0096550D, 0x0096552F, 0x009655E3, 0x0096562F, 0x0096566E, 0x0096565F, 0x00965733, 0x00965757, 0x0096579F, 
						  0x009657ED, 0x0096583F, 0x00965A02, 0x00965A1A, 0x00965AE0, 0x00965AF5, 0x00967448, 0x0096731D, 0x00967902, 0x00967C45, 
						  0x00967C68, 0x00967D83, 0x00967DD9, 0x00968054, 0x00968265, 0x00968402, 0x0096860E, 0x0096861C, 0x00969325, 0x0096934A, 
						  0x009692FE, 0x009696B5, 0x009696F9, 0x00969A13, 0x00969A2A, 0x00969A5B, 0x00969A7D, 0x00969C34, 0x00969C5E, 0x00969942, 
						  0x00969952, 0x00969961, 0x0096998B, 0x009699AD, 0x009699E2, 0x00969D1A, 0x00969D49, 0x00969D66, 0x00969D3A, 0x00969DA3, 
						  0x00969E2D, 0x00969EC7, 0x00969EEF, 0x00969F2C, 0x00969F60, 0x00969F77, 0x0096A009, 0x0096A024, 0x0096A03A, 0x00969FFA, 
						  0x0096A146, 0x0096A167, 0x0096A254, 0x0096A262, 0x0096A273, 0x0096B759, 0x0096B7E6, 0x0096BA5F, 0x0096BAC3, 0x0096B93E, 
						  0x0096B96B, 0x0096BCF6, 0x0096BD21, 0x0096BD60, 0x0096BD7E, 0x0096BF1F, 0x0096C217, 0x0096C4DF, 0x0096C543, 0x0096C3BE, 
						  0x0096C3EB, 0x0096C776, 0x0096C7A1, 0x0096C7E0, 0x0096C7FE, 0x0096C99F, 0x0096D299, 0x0096D879, 0x0096F437, 0x0096F40B, 
						  0x0096F428, 0x0096F4CE, 0x0096F4DD, 0x0096F560, 0x0096F4BC, 0x0096F5BF, 0x0096F5CB, 0x0096F60A, 0x0096F5FC, 0x0096F698, 
						  0x0096F68C, 0x0096F6D0, 0x0096F6F1, 0x0096F748, 0x0096F75D, 0x0096F769, 0x0096F7DB, 0x0096F7EB, 0x009704D2, 0x00970804, 
						  0x00970869, 0x0097085A, 0x00970A70, 0x00970A92, 0x00970ADB, 0x00970B56, 0x00970ACC, 0x00970BBE, 0x00970C25, 0x00971948, 
						  0x00971B2F, 0x00971A4A, 0x00971A56, 0x00971A69, 0x00971A77, 0x00971A83, 0x00971A91, 0x00971AD9, 0x00971AF3, 0x00971D30, 
						  0x00971D3C, 0x00971D57, 0x00971F40, 0x00971F50, 0x00972044, 0x009720B0, 0x00971DF6, 0x00972406, 0x00972433, 0x0097247C, 
						  0x009722F5, 0x00972304, 0x00972324, 0x00972366, 0x009722DC, 0x009725BB, 0x00972622, 0x0097275F, 0x009727DC, 0x0097267A, 
						  0x00972686, 0x00972699, 0x009726A7, 0x009726B3, 0x009726C1, 0x00972709, 0x00972723, 0x009729CB, 0x009729EC, 0x009728BC, 
						  0x00972980, 0x00972BD8, 0x00972C2A, 0x00972C78, 0x00972AB5, 0x00972CFF, 0x00972D1F, 0x00972CEC, 0x00972DB2, 0x00972E78, 
						  0x0097305B, 0x00973072, 0x00972F75, 0x009732CC, 0x009732DB, 0x00973300, 0x0097330C, 0x00973319, 0x00973337, 0x0097336B, 
						  0x009732BC, 0x00973377, 0x00973384, 0x009734E8, 0x00976327, 0x0097669F, 0x00976703, 0x0097657E, 0x009765AB, 0x00976916, 
						  0x00976941, 0x00976980, 0x0097699E, 0x00976B3F, 0x00976E20, 0x00976F07, 0x0097720F, 0x00977273, 0x009770EE, 0x0097711B, 
						  0x00977486, 0x009774B1, 0x009774F0, 0x0097750E, 0x009776AF, 0x00977B89, 0x009780E9, 0x00978609, 0x00978662, 0x0097867B, 
						  0x0097876F, 0x00978790, 0x0097879F, 0x009794FA, 0x00979530, 0x0097956A, 0x009795E9, 0x0097961F, 0x0097965A, 0x00979788, 
						  0x009797C6, 0x00979818, 0x0097982A, 0x009798B1, 0x009798C3, 0x00979936, 0x00979946, 0x00979967, 0x0097997D, 0x009799AF, 
						  0x0097991C, 0x009799E9, 0x00979A06, 0x00979A86, 0x00979A9E, 0x00979AB6, 0x00979B60, 0x00979B97, 0x00979BC7, 0x00979C1E, 
						  0x00979C30, 0x00979C50, 0x00979C0F, 0x00979EA4, 0x0097A021, 0x0097A051, 0x0097A07E, 0x00979F45, 0x00979F5F, 0x00979FA1, 
						  0x0097A006, 0x0097A0CC, 0x0097A0DE, 0x0097A0FE, 0x0097A0BD, 0x0097A1A8, 0x0097A1BD, 0x0097B9F7, 0x0097BAD3, 0x0097BC4A, 
						  0x0097BDD6, 0x0097BE01, 0x0097BE40, 0x0097BE5E, 0x0097BFFF, 0x0097C369, 0x0097C8A3, 0x0097CFF2, 0x0097D000, 0x0097CEF7, 
						  0x0097CF05, 0x0097CF8D, 0x0097CF99, 0x0097CFA7, 0x0097D088, 0x0097D0A7, 0x0097D0C3, 0x0097D0D2, 0x0097D0E0, 0x0097D1B1, 
						  0x0097D1E7, 0x0097D209, 0x0097D22B, 0x0097D482, 0x0097D492, 0x0097D4BA, 0x0097D4FE, 0x0097D539, 0x0097D605, 0x0097D652, 
						  0x0097D6BE, 0x0097D6CC, 0x0097D71A, 0x0097D856, 0x0097D93F, 0x0097D94E, 0x0097D96C, 0x0097D97A, 0x0097D78A, 0x0097D7AF, 
						  0x0097D7CD, 0x0097D839, 0x0097DACF, 0x0097DADE, 0x0097DAF1, 0x0097DB00, 0x0097DB13, 0x0097DB22, 0x0097DB35, 0x0097DB46, 
						  0x0097DB55, 0x0097DB66, 0x0097D9DB, 0x0097DB77, 0x0097DB86, 0x0097DB99, 0x0097DBB9, 0x0097DBC8, 0x0097DC34, 0x0097DC6D, 
						  0x0097DC8D, 0x0097DA01, 0x0097DA1B, 0x0097DA32, 0x0097DA4B, 0x0097DA5F, 0x0097DA84, 0x0097DA93, 0x0097DAA6, 0x0097DAB5, 
						  0x0097DE57, 0x0097DE77, 0x0097DD6B, 0x0097DD91, 0x0097DDAE, 0x0097DDBD, 0x0097DDD3, 0x0097DDEF, 0x0097DDFD, 0x0097DE48, 
						  0x0097DF53, 0x0097E2E7, 0x0097E234, 0x0097E244, 0x0097E253, 0x0097E263, 0x0097E276, 0x0097E28A, 0x0097E29A, 0x0097E2AE, 
						  0x0097E2BE, 0x0097E2CD, 0x0097E2D9, 0x0097E3AF, 0x0097E3BF, 0x0097E3CE, 0x0097E3DE, 0x0097E3F1, 0x0097E405, 0x0097E415, 
						  0x0097E429, 0x0097E439, 0x0097E4C6, 0x0097E557, 0x0097E57F, 0x0097E67E, 0x0097E6B7, 0x0097E6CD, 0x0097E6E6, 0x0097E715, 
						  0x0097E735, 0x0097E916, 0x0097E957, 0x0097EB86, 0x0097EB97, 0x0097EBAD, 0x0097F0C7, 0x0097F0D3, 0x0097F0E6, 0x0097F14D, 
						  0x0097F2C5, 0x0097F2D6, 0x0097F33B, 0x0097F344, 0x0097F1F1, 0x0097F201, 0x0097F225, 0x0097F244, 0x0097F26C, 0x0097F27C, 
						  0x0097F28A, 0x0097F4C3, 0x0097F4ED, 0x0097F5A2, 0x0097F61F, 0x0097F62F, 0x0097FA2A, 0x0098122B, 0x0098124C, 0x00981276, 
						  0x009812BC, 0x0098112C, 0x009812F5, 0x00981368, 0x00981384, 0x009813A7, 0x00981421, 0x00981153, 0x00981192, 0x009811A9, 
						  0x009816B8, 0x009816E8, 0x00981701, 0x0098190B, 0x00981925, 0x00981937, 0x00981943, 0x0098195B, 0x00981967, 0x0098197F, 
						  0x00981995, 0x009819BA, 0x00981869, 0x00981883, 0x009818A3, 0x009818BD, 0x009818D8, 0x00981ADC, 0x00981BE7, 0x00981DA2, 
						  0x00981DB2, 0x00981CA8, 0x00981CC0, 0x00981D30, 0x00981D40, 0x00981E15, 0x00981FEE, 0x00982004, 0x00982088, 0x00982227, 
						  0x0098223B, 0x0098228E, 0x009822B1, 0x00982177, 0x009821AC, 0x009821FA, 0x0098235C, 0x0098237E, 0x0098238C, 0x009824DE, 
						  0x00982664, 0x00982694, 0x009826AD, 0x009829CF, 0x00982A74, 0x00982B8B, 0x00982BEA, 0x00982C23, 0x00982C4B, 0x00982C8D, 
						  0x00982D30, 0x00982D45, 0x00982856, 0x0098287D, 0x009828E2, 0x00982EA5, 0x00983101, 0x00983228, 0x0098318A, 0x009831AA, 
						  0x009831C8, 0x0098335D, 0x009833EA, 0x00983425, 0x0098348E, 0x00983507, 0x0098351D, 0x00983533, 0x009835AC, 0x009835BE, 
						  0x009835E1, 0x009835F7, 0x0098361E, 0x009832A7, 0x0098376B, 0x009837A9, 0x00983AC0, 0x00983B25, 0x00983B8D, 0x00983B9F, 
						  0x00983BC2, 0x00983BD8, 0x00983BFF, 0x00983C4E, 0x00983C68, 0x00983C7A, 0x00983C94, 0x00983CAA, 0x00983CBC, 0x00983CDC, 
						  0x00983CF6, 0x009839B7, 0x00983A47, 0x00984F1F, 0x00985683, 0x0098570E, 0x0098571F, 0x00987067, 0x00987216, 0x00987241, 
						  0x00987280, 0x0098729E, 0x0098743F, 0x00987C29, 0x00987D69, 0x009882AF, 0x0098896D, 0x0098898C, 0x009889B5, 0x009889CC, 
						  0x009889E2, 0x00988A06, 0x00988A54, 0x00988A6F, 0x00988ABB, 0x00988ACB, 0x00988B08, 0x00988BE0, 0x00988C36, 0x00988C3F, 
						  0x00988C53, 0x00988C5C, 0x0098887A, 0x00988CD3, 0x00988CE1, 0x0098888A, 0x0098889A, 0x009888A8, 0x009888FB, 0x00988904, 
						  0x0098A288, 0x0098AD8A, 0x0098AE2A, 0x0098AE39, 0x0098AE59, 0x0098AEA5, 0x0098AEB1, 0x0098AECC, 0x0098AED8, 0x0098D009, 
						  0x0098D3B7, 0x0098F6E0, 0x0098F6EF, 0x0098F7C3, 0x0098F7D6, 0x0098F7FB, 0x0098F900, 0x0098F92D, 0x0098FC24, 0x0098FC3A, 
						  0x0098FC5F, 0x0098FAEE, 0x0098FAFF, 0x0098FCF2, 0x0098FD92, 0x0098FDA4, 0x0098FDBE, 0x0098FDEB, 0x0098FF40, 0x009901C6, 
						  0x0099027B, 0x009902C0, 0x009902D3, 0x009902F8, 0x00990050, 0x0099007E, 0x00990098, 0x0099033E, 0x00990370, 0x0099055B, 
						  0x0099059C, 0x009905FC, 0x0099069B, 0x009906E6, 0x0099072B, 0x00990908, 0x009908EF, 0x009910CC, 0x009910DF, 0x00991104, 
						  0x0099170C, 0x00991722, 0x0099176F, 0x00991791, 0x00991806, 0x0099189E, 0x009918B1, 0x009918D6, 0x0099192B, 0x00991A50, 
						  0x00991A7D, 0x00991AA0, 0x00991E86, 0x00991E92, 0x00991F4B, 0x00991F71, 0x00992188, 0x0099236E, 0x0099246E, 0x009924F4, 
						  0x00992507, 0x0099252C, 0x00992AA1, 0x00993255, 0x00993275, 0x0099329C, 0x00993123, 0x00993136, 0x0099313F, 0x0099349E, 
						  0x009934FE, 0x00993524, 0x009936EF, 0x009937AD, 0x0099390E, 0x0099392D, 0x00993D4B, 0x00993D63, 0x00993D88, 0x00993D9B, 
						  0x00993F11, 0x00993F60, 0x00993F86, 0x00993FD2, 0x00993FE1, 0x00993FF7, 0x00994015, 0x009940E1, 0x00994271, 0x009942B9, 
						  0x009942D2, 0x009942E3, 0x009941C1, 0x0099439F, 0x009943B5, 0x009943D0, 0x00994501, 0x00994510, 0x00994539, 0x0099455D, 
						  0x00994461, 0x0099448E, 0x009944A4, 0x009944E4, 0x009946A9, 0x009946EE, 0x009946FC, 0x00994846, 0x00994A2E, 0x00994A3A, 
						  0x00994A4D, 0x009949F8, 0x00994A0F, 0x00994AFD, 0x00994B17, 0x00994C8B, 0x00994C97, 0x00994CB5, 0x00994E3F, 0x00994DE5, 
						  0x0099521A, 0x009952B9, 0x009952FB, 0x0099534A, 0x00995155, 0x0099560A, 0x0099569F, 0x009956A6, 0x00995C4D, 0x00995E03, 
						  0x00995F9B, 0x00995E7B, 0x00995FFE, 0x00996015, 0x00996023, 0x00996049, 0x0099688A, 0x0099690A, 0x00996A93, 0x00996ACC, 
						  0x00996AF7, 0x00996B22, 0x00996B4D, 0x00996B78, 0x00996BF8, 0x00996C8C, 0x00996CB1, 0x00996F3A, 0x00996FCD, 0x00996FED, 
						  0x0099715E, 0x00997320, 0x00997351, 0x00997367, 0x0099738C, 0x00997450, 0x0099748C, 0x009974B9, 0x00997B07, 0x00997B38, 
						  0x00997DAC, 0x00997DCA, 0x00997CD8, 0x00997CF2, 0x00997D05, 0x00997F5B, 0x00997FB8, 0x00998220, 0x0099838A, 0x00998556, 
						  0x00998794, 0x009987A6, 0x009987E0, 0x00998816, 0x00998846, 0x009988D5, 0x00998905, 0x0099891A, 0x00998BF4, 0x00998C19, 
						  0x0099911E, 0x009991A4, 0x009991C8, 0x009991ED, 0x00999513, 0x00999AF3, 0x00999B28, 0x00999B45, 0x00999C28, 0x00999E0C, 
						  0x009999B2, 0x0099A243, 0x0099A2D0, 0x0099A2F8, 0x0099A65C, 0x0099A68A, 0x0099A701, 0x0099A74A, 0x0099A8C5, 0x0099A8D2, 
						  0x0099A92E, 0x0099A821, 0x0099ABE9, 0x0099AACC, 0x0099AB6C, 0x0099AD63, 0x0099AD90, 0x0099ADB7, 0x0099ADC2, 0x0099ADE0, 
						  0x0099ADEB, 0x0099ADFC, 0x0099AE0B, 0x0099AE6E, 0x0099AE9D, 0x0099AEC9, 0x0099AEE8, 0x0099AEF7, 0x0099AF3A, 0x0099AF98, 
						  0x0099ACBD, 0x0099ACD0, 0x0099ACEA, 0x0099AD08, 0x0099B90B, 0x0099B92F, 0x0099BF5E, 0x0099C05B, 0x0099C067, 0x0099C07E, 
						  0x0099C297, 0x0099C17B, 0x0099C1DB, 0x0099C213, 0x0099C22A, 0x0099C37A, 0x0099C394, 0x0099C514, 0x0099C543, 0x0099C4C2, 
						  0x0099C4E0, 0x0099C4FF, 0x0099C5BA, 0x0099C5D4, 0x0099C701, 0x0099C7B6, 0x0099C7C5, 0x0099C7AA, 0x0099C95A, 0x0099C9A7, 
						  0x0099C9BF, 0x0099CCCA, 0x0099D286, 0x0099D29A, 0x0099D2B2, 0x0099D2EB, 0x0099D340, 0x0099D1DE, 0x0099D1FC, 0x0099D20D, 
						  0x0099D22B, 0x0099D247, 0x0099D25E, 0x0099D3C8, 0x0099D59D, 0x0099D63C, 0x0099D65C, 0x0099D412, 0x0099D9D7, 0x0099DA33, 
						  0x0099DB2D, 0x0099DB3B, 0x0099DB87, 0x0099DB95, 0x0099DBC2, 0x0099DC36, 0x0099DC6C, 0x0099DCB3, 0x0099DCEA, 0x0099DD22, 
						  0x0099DD30, 0x0099DD8A, 0x0099D499, 0x0099D4AF, 0x0099DFB9, 0x0099E190, 0x0099E20C, 0x0099E22F, 0x0099E0A9, 0x0099E3EF, 
						  0x0099E413, 0x0099E429, 0x0099E0D7, 0x0099E6AA, 0x0099E8CF, 0x0099E907, 0x0099E94D, 0x0099E967, 0x0099E984, 0x0099E114, 
						  0x0099E9D9, 0x0099EA20, 0x0099EB46, 0x0099F0CF, 0x0099F12E, 0x0099F11F, 0x0099F26C, 0x0099F280, 0x0099F1A5, 0x0099F1CA, 
						  0x0099F221, 0x0099F247, 0x0099F16F, 0x0099F47D, 0x0099F419, 0x0099F658, 0x0099F667, 0x0099F68B, 0x0099F69D, 0x0099F989, 
						  0x0099F9EA, 0x0099FA4C, 0x0099FA3D, 0x0099FE5E, 0x0099FE4F, 0x0099FFDA, 0x009A0084, 0x009A023F, 0x009A025E, 0x009A0286, 
						  0x009A02B9, 0x009A02F4, 0x009A0337, 0x009A0144, 0x009A0366, 0x009A03C3, 0x009A0426, 0x009A0468, 0x009A0499, 0x009A04C1, 
						  0x009A0574, 0x009A05F2, 0x009A065E, 0x009A0195, 0x009A01C1, 0x009A01EA, 0x009A0216, 0x009A0BE4, 0x009A0BF4, 0x009A0C03, 
						  0x009A0D7B, 0x009A0D87, 0x009A0D95, 0x009A0E16, 0x009A0E2D, 0x009A0EBC, 0x009A0EDB, 0x009A0F5D, 0x009A0F7B, 0x009A0FE9, 
						  0x009A1066, 0x009A107D, 0x009A10B0, 0x009A1101, 0x009A1111, 0x009A112F, 0x009A11B0, 0x009A11C6, 0x009A1236, 0x009A124D, 
						  0x009A0CD0, 0x009A128B, 0x009A136E, 0x009A1385, 0x009A13F9, 0x009A1405, 0x009A1426, 0x009A1432, 0x009A1445, 0x009A14B9, 
						  0x009A0D30, 0x009A1731, 0x009A1744, 0x009A1773, 0x009A178B, 0x009A17E9, 0x009A206B, 0x009A214B, 0x009A2157, 0x009A216F, 
						  0x009A2178, 0x009A219D, 0x009A21B8, 0x009A21C3, 0x009A2864, 0x009A2902, 0x009A2997, 0x009A29F0, 0x009A2B9C, 0x009A2BD0, 
						  0x009A2C32, 0x009A2C51, 0x009A2C5C, 0x009A2C7F, 0x009A2512, 0x009A2F13, 0x009A2F3B, 0x009A2E0C, 0x009A2E2A, 0x009A3018, 
						  0x009A3024, 0x009A321A, 0x009A34BF, 0x009A34EB, 0x009A351A, 0x009A35A2, 0x009A36E4, 0x009A36F1, 0x009A3720, 0x009A372B, 
						  0x009A3631, 0x009A3670, 0x009A3878, 0x009A3799, 0x009A37AC, 0x009A37D4, 0x009A37EE, 0x009A3804, 0x009A3822, 0x009A385A, 
						  0x009A3A2F, 0x009A3A4E, 0x009A38E8, 0x009A3914, 0x009A38DC, 0x009A3BCA, 0x009A3BDE, 0x009A3BEA, 0x009A3C15, 0x009A3C29, 
						  0x009A3C36, 0x009A3C56, 0x009A3C85, 0x009A3B99, 0x009A3DFC, 0x009A3E2B, 0x009A3FF2, 0x009A401D, 0x009A4031, 0x009A404E, 
						  0x009A405B, 0x009A4066, 0x009A40A7, 0x009A40B4, 0x009A40BF, 0x009A40D2, 0x009A40DF, 0x009A40EA, 0x009A4157, 0x009A4179, 
						  0x009A3F0B, 0x009A419F, 0x009A41B0, 0x009A41D4, 0x009A41F1, 0x009A41FC, 0x009A4215, 0x009A4261, 0x009A3F1A, 0x009A42F8, 
						  0x009A4320, 0x009A432F, 0x009A4353, 0x009A4370, 0x009A437D, 0x009A3F7B, 0x009A3FC0, 0x009A3FCB, 0x009A4542, 0x009A459C, 
						  0x009A45B0, 0x009A45CD, 0x009A4781, 0x009A47D9, 0x009A47F0, 0x009A4819, 0x009A4830, 0x009A4881, 0x009A468E, 0x009A46A3, 
						  0x009A46BB, 0x009A48F4, 0x009A4912, 0x009A4964, 0x009A497C, 0x009A49A1, 0x009A4AEA, 0x009A4B52, 0x009A4B94, 0x009A4BE9, 
						  0x009A4BF5, 0x009A4C9F, 0x009A4CCF, 0x009A4F9E, 0x009A509B, 0x009A50A7, 0x009A50BE, 0x009A5208, 0x009A525A, 0x009A526B, 
						  0x009A5504, 0x009A5533, 0x009A54B2, 0x009A54D0, 0x009A54EF, 0x009A565A, 0x009A570A, 0x009A585B, 0x009A586E, 0x009A587B, 
						  0x009A589D, 0x009A574F, 0x009A5762, 0x009A57BE, 0x009A57D5, 0x009A598A, 0x009A59E0, 0x009A5DD8, 0x009A5DF2, 0x009A5E17, 
						  0x009A5E31, 0x009A61B2, 0x009A61C1, 0x009A61D0, 0x009A61DC, 0x009A633C, 0x009A6607, 0x009A6616, 0x009A6622, 0x009A6634, 
						  0x009A66A9, 0x009A66CF, 0x009A66E3, 0x009A66F2, 0x009A6282, 0x009A62BB, 0x009A62C7, 0x009A62DD, 0x009A62F0, 0x009A6319, 
						  0x009A632C, 0x009A677F, 0x009A679E, 0x009A67AA, 0x009A67D4, 0x009A67DF, 0x009A67F9, 0x009A6812, 0x009A6D4F, 0x009A6D56, 
						  0x009A6DBE, 0x009A6DD5, 0x009A6DDC, 0x009A6E54, 0x009A6E6D, 0x009A73A4, 0x009A73CB, 0x009A73F2, 0x009A7419, 0x009A7440, 
						  0x009A7469, 0x009A7325, 0x009A7364, 0x009A7643, 0x009A79E1, 0x009A7A0B, 0x009A7A1D, 0x009A79C8, 0x009A7BE9, 0x009A7BF5, 
						  0x009A7B2A, 0x009A7B71, 0x009A7B83, 0x009A7BDD, 0x009A7CC4, 0x009A7DE0, 0x009A7E0D, 0x009A7ECD, 0x009A7E9F, 0x009A824B, 
						  0x009A8485, 0x009A84E0, 0x009A8536, 0x009A855E, 0x009A856E, 0x009A863F, 0x009A86D8, 0x009A8A99, 0x009A8AD1, 0x009A8AED, 
						  0x009A8B12, 0x009A8B40, 0x009A8C57, 0x009A8C69, 0x009A8CC2, 0x009A8CD8, 0x009A8EE3, 0x009A8EEF, 0x009A8EFB, 0x009A8E89, 
						  0x009A91E5, 0x009A93C2, 0x009A93E1, 0x009A93EA, 0x009A93FA, 0x009A941F, 0x009A930E, 0x009A933B, 0x009A934E, 0x009A936D, 
						  0x009A9D07, 0x009AA148, 0x009AA175, 0x009AA210, 0x009AA225, 0x009AA22C, 0x009AA370, 0x009AA3C2, 0x009AA863, 0x009AA5D8, 
						  0x009AA620, 0x009AA63C, 0x009AABE1, 0x009AABF2, 0x009AAC11, 0x009AAC22, 0x009AAC41, 0x009AAC55, 0x009AAC69, 0x009AAC81, 
						  0x009AAC9E, 0x009AACA9, 0x009AAEB8, 0x009AB005, 0x009AB092, 0x009AAF86, 0x009AB2A7, 0x009AB5AF, 0x009AB486, 0x009AB4B1, 
						  0x009AB4DD, 0x009AB514, 0x009AB7A6, 0x009AB654, 0x009AB68D, 0x009ABE1D, 0x009ABE75, 0x009ABFF9, 0x009AC06B, 0x009AC076, 
						  0x009AC089, 0x009AC094, 0x009AC0BB, 0x009AC0EE, 0x009AC147, 0x009AC18D, 0x009AC1A4, 0x009AC1C7, 0x009AC1D7, 0x009AC1FC, 
						  0x009ABF43, 0x009AC3BC, 0x009ACBE2, 0x009AC9D4, 0x009ACA17, 0x009ACA42, 0x009ACA9D, 0x009ACE56, 0x009ACE6D, 0x009ACE7A, 
						  0x009ACE9B, 0x009ACEAD, 0x009ACEC0, 0x009ACED4, 0x009ACEE5, 0x009AD00C, 0x009AD03A, 0x009AD068, 0x009AD0E2, 0x009AD0F3, 
						  0x009AD160, 0x009AD17A, 0x009AD190, 0x009ACF2B, 0x009AD1B4, 0x009AD1DD, 0x009AD1FC, 0x009AD237, 0x009AD262, 0x009ACF8A, 
						  0x009ACFB5, 0x009ACFDA, 0x009AD374, 0x009AD69D, 0x009AD6A4, 0x009AD6B8, 0x009AD6BF, 0x009AD77A, 0x009AD90A, 0x009AD58D, 
						  0x009ADCDF, 0x009ADC10, 0x009ADC41, 0x009ADCC1, 0x009ADE3C, 0x009AE02F, 0x009AE0E8, 0x009AE702, 0x009AE84A, 0x009AE882, 
						  0x009AE8A6, 0x009AE8AD, 0x009AE8C1, 0x009AE9C6, 0x009AE9AD, 0x009AEBC3, 0x009AEBD1, 0x009AEC75, 0x009AEC92, 0x009AEA76, 
						  0x009AEA84, 0x009AF177, 0x009AF24F, 0x009AF505, 0x009AF79F, 0x009AF7AA, 0x009AF831, 0x009AF83C, 0x009AF84D, 0x009AF882, 
						  0x009AF89C, 0x009AF8F3, 0x009AF906, 0x009AF966, 0x009AF97D, 0x009AFA3B, 0x009AFA66, 0x009AFA83, 0x009AFAAC, 0x009AFB79, 
						  0x009AFBB5, 0x009AFE21, 0x009AFE5C, 0x009B00BD, 0x009B00FD, 0x009B019E, 0x009B034D, 0x009B07B5, 0x009B07EA, 0x009B0847, 
						  0x009B09A9, 0x009B088D, 0x009B08BD, 0x009B08D2, 0x009B0942, 0x009B0957, 0x009B0B4E, 0x009B0A8C, 0x009B0DA6, 0x009B0E20, 
						  0x009B1149, 0x009B0FF5, 0x009B11C4, 0x009B177E, 0x009B176F, 0x009B17CE, 0x009B17F8, 0x009B180C, 0x009B17BF, 0x009B204F, 
						  0x009B2075, 0x009B2133, 0x009B20F9, 0x009B22B9, 0x009B27DF, 0x009B2805, 0x009B2BDA, 0x009B32AF, 0x009B32D5, 0x009B373F, 
						  0x009B3765, 0x009B37C0, 0x009B3CBA, 0x009B4222, 0x009B422D, 0x009B427D, 0x009B4172, 0x009B41B5, 0x009B53A2, 0x009B53C9, 
						  0x009B54D2, 0x009B552F, 0x009B5556, 0x009B549F, 0x009B55BF, 0x009B58CB, 0x009B58DA, 0x009B5A42, 0x009B5A51, 0x009B5FE6, 
						  0x009B6230, 0x009B6271, 0x009B6072, 0x009B6493, 0x009B655E, 0x009B6695, 0x009B66E0, 0x009B69BB, 0x009B6AE0, 0x009B6B00, 
						  0x009B7026, 0x009B7135, 0x009B71F3, 0x009B717F, 0x009B73BC, 0x009B752A, 0x009B76D1, 0x009B7A2F, 0x009B7AF5, 0x009B7D33, 
						  0x009B7BDB, 0x009B7DBC, 0x009B7DC7, 0x009B7C2E, 0x009B7C82, 0x009B7CB2, 0x009B808D, 0x009B8261, 0x009B827A, 0x009B82AF, 
						  0x009B82C6, 0x009B8177, 0x009B82DB, 0x009B82E6, 0x009B830B, 0x009B8337, 0x009B835E, 0x009B8245, 0x009B8397, 0x009B8515, 
						  0x009B864B, 0x009B8664, 0x009B868B, 0x009B874F, 0x009B875B, 0x009B8799, 0x009B87B0, 0x009B87C5, 0x009B87D0, 0x009B87E6, 
						  0x009B87FC, 0x009B880C, 0x009B882D, 0x009B85B9, 0x009B85D9, 0x009B85F8, 0x009B8618, 0x009B8635, 0x009B8D8A, 0x009B8DCE, 
						  0x009B8E5A, 0x009B904D, 0x009B94AB, 0x009B95B7, 0x009B968E, 0x009B935F, 0x009B9834, 0x009B9861, 0x009B9891, 0x009B9908, 
						  0x009B99E0, 0x009B9B16, 0x009B9A71, 0x009B9B0B, 0x009B9D0F, 0x009B9D1E, 0x009B9D4B, 0x009B9D92, 0x009B9C2B, 0x009B9CA4, 
						  0x009B9EA8, 0x009BA012, 0x009BA0AB, 0x009BA0B7, 0x009BA0CE, 0x009BA318, 0x009BA211, 0x009BA554, 0x009BA583, 0x009BA502, 
						  0x009BA520, 0x009BA53F, 0x009BAAA6, 0x009BAAF2, 0x009BAADC, 0x009BB762, 0x009BB84A, 0x009BD274, 0x009BD2D9, 0x009BD2EF, 
						  0x009BD300, 0x009BC2CB, 0x009BC332, 0x009BC3F5, 0x009BC401, 0x009BC433, 0x009BC48A, 0x009BC56C, 0x009BC5A5, 0x009BC5B5, 
						  0x009BC5D4, 0x009BC5F9, 0x009BC614, 0x009BC629, 0x009BC66C, 0x009BC6BA, 0x009BC6F8, 0x009BC736, 0x009BC239, 0x009BCDE0, 
						  0x009BD002, 0x009BD024, 0x009BD8C9, 0x009BD9B9, 0x009BD7D1, 0x009BD9C9, 0x009BD9DF, 0x009BD9FB, 0x009BD7E2, 0x009BDB1B, 
						  0x009BDB2B, 0x009BDB45, 0x009BD7FC, 0x009BD863, 0x009BD879, 0x009BD895, 0x009BD8A9, 0x009BDD9C, 0x009BDDB0, 0x009BDC9F, 
						  0x009BDCB1, 0x009BDCCD, 0x009BDCEC, 0x009BDD26, 0x009BE02E, 0x009BE165, 0x009BE196, 0x009BE1BC, 0x009BE69F, 0x009BE877, 
						  0x009BEB18, 0x009BEB7D, 0x009BEC49, 0x009BEC62, 0x009BEC0E, 0x009BEDB1, 0x009BEDE5, 0x009BEDF6, 0x009BED1C, 0x009BED52, 
						  0x009BEE3E, 0x009BEF7C, 0x009BEFA6, 0x009BEFB7, 0x009BF0F1, 0x009BF106, 0x009BF1F2, 0x009BF206, 0x009BF3C5, 0x009BF66A, 
						  0x009BF3D1, 0x009BF711, 0x009BF77E, 0x009BFADB, 0x009BFAE7, 0x009BFB10, 0x009C0152, 0x009C0032, 0x009C0053, 0x009C045A, 
						  0x009C04FA, 0x009C0512, 0x009C0771, 0x009C0EED, 0x009C1747, 0x009C22C2, 0x009C2300, 0x009C24EA, 0x009C2513, 0x009C2603, 
						  0x009C26CE, 0x009C28EF, 0x009C2929, 0x009C29E6, 0x009C2A11, 0x009C29DA, 0x009C3851, 0x009C3861, 0x009C387C, 0x009C38A7, 
						  0x009C3AC1, 0x009C3B0B, 0x009C3A62, 0x009C3A82, 0x009C3F78, 0x009C4028, 0x009C40B0, 0x009C40C4, 0x009C410E, 0x009C4168, 
						  0x009C421A, 0x009C4278, 0x009C4309, 0x009C447C, 0x009C44B7, 0x009C4587, 0x009C4641, 0x009C4367, 0x009C4379, 0x009C4A0C, 
						  0x009C4A1D, 0x009C48AA, 0x009C491F, 0x009C492D, 0x009C493B, 0x009C4ABF, 0x009C4C66, 0x009C4C7C, 0x009C4C93, 0x009C4CA4, 
						  0x009C4CD7, 0x009C4B7D, 0x009C4BB5, 0x009C4BEC, 0x009C4C01, 0x009C4B6C, 0x009C4D93, 0x009C4DA2, 0x009C4DD3, 0x009C4D7C, 
						  0x009C4E4D, 0x009C4E65, 0x009C4F72, 0x009C50AE, 0x009C50C1, 0x009C4FE5, 0x009C5009, 0x009C502E, 0x009C504B, 0x009C505F, 
						  0x009C50F2, 0x009C5104, 0x009C5188, 0x009C521A, 0x009C523A, 0x009C56A9, 0x009C570A, 0x009C572A, 0x009C573D, 0x009C5762, 
						  0x009C5560, 0x009C5587, 0x009C55B9, 0x009C55CD, 0x009C62C2, 0x009C62CE, 0x009C6300, 0x009C6309, 0x009C6371, 0x009C633F, 
						  0x009C640D, 0x009C6427, 0x009C644C, 0x009C6466, 0x009C6CE3, 0x009C6D02, 0x009C6D4A, 0x009C6D6D, 0x009C6E79, 0x009C70EA, 
						  0x009C701C, 0x009C703C, 0x009C7083, 0x009C71E5, 0x009C7246, 0x009C739D, 0x009C744D, 0x009C7289, 0x009C72EF, 0x009C72FE, 
						  0x009C7588, 0x009C75A9, 0x009C75CA, 0x009C75EB, 0x009C78C1, 0x009C7B65, 0x009C7B84, 0x009C7BB7, 0x009C7C5A, 0x009C7BFC, 
						  0x009C7D01, 0x009C7E08, 0x009C7E13, 0x009C7EFA, 0x009C8068, 0x009C87E2, 0x009C8880, 0x009C8915, 0x009C89D4, 0x009C8A62, 
						  0x009C8ABB, 0x009C8BBD, 0x009C8503, 0x009C8BF1, 0x009C8C2B, 0x009C8C4A, 0x009C8C55, 0x009C8C78, 0x009C8CE1, 0x009C8E6E, 
						  0x009C8E5F, 0x009C8F43, 0x009C8FFD, 0x009C90F5, 0x009C9181, 0x009C920E, 0x009C921B, 0x009C938F, 0x009C95BC, 0x009C95D6, 
						  0x009C95EF, 0x009C9616, 0x009C94CC, 0x009C94E1, 0x009C94F9, 0x009C975E, 0x009C96AC, 0x009C970D, 0x009C9733, 0x009C9891, 
						  0x009C989C, 0x009C98C3, 0x009C9967, 0x009C99C0, 0x009C99CB, 0x009C99DA, 0x009C9A0D, 0x009C9A6A, 0x009C9AB4, 0x009C9AD2, 
						  0x009C9B24, 0x009C9B3C, 0x009C9B61, 0x009C9E04, 0x009C9E2B, 0x009C9F2B, 0x009C9D00, 0x009CA12B, 0x009CA137, 0x009CA14E, 
						  0x009CA354, 0x009CA383, 0x009CA302, 0x009CA320, 0x009CA33F, 0x009CA4DA, 0x009CA804, 0x009CA9CC, 0x009CA86A, 0x009CAA5D, 
						  0x009CAA71, 0x009CAA7C, 0x009CAAAB, 0x009CAB66, 0x009CAC59, 0x009CAC94, 0x009CAD53, 0x009CAD8A, 0x009CADA1, 0x009CADAC, 
						  0x009CAE85, 0x009CA8B4, 0x009CAE90, 0x009CAEA3, 0x009CAEB5, 0x009CB042, 0x009CB091, 0x009CB09C, 0x009CB145, 0x009CB18C, 
						  0x009CB577, 0x009CB5F9, 0x009CB604, 0x009CB66C, 0x009CB6BE, 0x009CB497, 0x009CBA15, 0x009CBA91, 0x009CBB0E, 0x009CBB19, 
						  0x009CBD77, 0x009CBCBF, 0x009CBE1A, 0x009CBEB1, 0x009CC0B9, 0x009CC0DB, 0x009CBFD2, 0x009CBFDD, 0x009CCA1C, 0x009CC941, 
						  0x009CCCDD, 0x009CCD1E, 0x009CCD4F, 0x009CCE66, 0x009CCE7F, 0x009CD1AF, 0x009CD2F6, 0x009CD88A, 0x009CD89C, 0x009CD6C7, 
						  0x009CD6D5, 0x009CD6F0, 0x009CDB1E, 0x009CDB2C, 0x009CDB4B, 0x009CE560, 0x009CEA5E, 0x009CEADE, 0x009CEC6F, 0x009CEC7D, 
						  0x009CECE9, 0x009CECF7, 0x009CED10, 0x009CED1E, 0x009CED50, 0x009CED5E, 0x009CED77, 0x009CED85, 0x009CEDB0, 0x009CEDBE, 
						  0x009CEDD8, 0x009CEDE6, 0x009CEEAC, 0x009CEEBA, 0x009CEED6, 0x009CEEE4, 0x009CEB32, 0x009CEFDD, 0x009CEFEB, 0x009CF002, 
						  0x009CF010, 0x009CF02B, 0x009CF039, 0x009CF0D7, 0x009CF0E5, 0x009CF10C, 0x009CF11A, 0x009CF3F5, 0x009CF403, 0x009CF358, 
						  0x009CF366, 0x009CF5FD, 0x009CF60C, 0x009CF809, 0x009CF96C, 0x009CF97A, 0x009CF993, 0x009CF9A1, 0x009CF920, 0x009CF92E, 
						  0x009CFCB8, 0x009CFD5B, 0x009CFD69, 0x009CFEA1, 0x009CFED8, 0x009CFF17, 0x009CFF3D, 0x009CFF63, 0x009CFDAC, 0x009CFE5E, 
						  0x009CFFE4, 0x009D0015, 0x009D003B, 0x009D0050, 0x009D0073, 0x009D0093, 0x009D00F9, 0x009D0273, 0x009D02A3, 0x009D01BE, 
						  0x009D055E, 0x009D077E, 0x009D05AD, 0x009D08E0, 0x009D07E6, 0x009D0A58, 0x009D080F, 0x009D0E96, 0x009D14F7, 0x009D1504, 
						  0x009D1548, 0x009D155C, 0x009D1569, 0x009D162D, 0x009D1689, 0x009D14A5, 0x009D14E3, 0x009D1947, 0x009D1B2F, 0x009D1B82, 
						  0x009D1B9A, 0x009D1CF9, 0x009D2109, 0x009D212F, 0x009D20CB, 0x009D229D, 0x009D260E, 0x009D277B, 0x009D2831, 0x009D28C9, 
						  0x009D2B3A, 0x009D2B1F, 0x009D30DF, 0x009D31DD, 0x009D321D, 0x009D3240, 0x009D3255, 0x009D32C3, 0x009D3352, 0x009D3648, 
						  0x009D3653, 0x009D3694, 0x009D369F, 0x009D3494, 0x009D3B2B, 0x009D3CDC, 0x009D3CAC, 0x009D406F, 0x009D4263, 0x009D428D, 
						  0x009D42A4, 0x009D41D4, 0x009D436D, 0x009D4481, 0x009D4527, 0x009D4C9D, 0x009D4DAE, 0x009D4F27, 0x009D4F3F, 0x009D549A, 
						  0x009D5DB8, 0x009D5D0C, 0x009D609A, 0x009D62C7, 0x009D6427, 0x009D6654, 0x009D66E7, 0x009D682B, 0x009D68B7, 0x009D77C1, 
						  0x009D77D1, 0x009D77E6, 0x009D87AE, 0x009D87CD, 0x009D87D9, 0x009D87EC, 0x009D872E, 0x009D8747, 0x009D9034, 0x009D904D, 
						  0x009D9080, 0x009D909F, 0x009D90AB, 0x009D90BE, 0x009D97FA, 0x009D9B73, 0x009D9BAB, 0x009DA076, 0x009DA2EC, 0x009DA3A1, 
						  0x009DA1FE, 0x009DA829, 0x009DA858, 0x009DAB43, 0x009DAB51, 0x009DAA71, 0x009DAA8C, 0x009DAA9D, 0x009DAAAB, 0x009DAADA, 
						  0x009DAAE8, 0x009DB03A, 0x009DB053, 0x009DB0D5, 0x009DB0ED, 0x009DB11E, 0x009DB423, 0x009DB436, 0x009DB444, 0x009DB479, 
						  0x009DB48E, 0x009DB350, 0x009DB35E, 0x009DB380, 0x009DB38E, 0x009DB3A5, 0x009DB3B3, 0x009DB5C9, 0x009DB61A, 0x009DB628, 
						  0x009DB65F, 0x009DB66D, 0x009DB709, 0x009DB717, 0x009DB731, 0x009DB73F, 0x009DB7C8, 0x009DB7D6, 0x009DB7F8, 0x009DB806, 
						  0x009DB917, 0x009DB519, 0x009DB527, 0x009DB5BB, 0x009DBAB7, 0x009DBA11, 0x009DBA1F, 0x009DBA34, 0x009DBA42, 0x009DBCB3, 
						  0x009DBCCC, 0x009DBCED, 0x009DBD31, 0x009DBD4F, 0x009DBD79, 0x009DBDA4, 0x009DBDB6, 0x009DBDCE, 0x009DBE4D, 0x009DBE7C, 
						  0x009DBE94, 0x009DBEC5, 0x009DBF8E, 0x009DBF7F, 0x009DC29A, 0x009DC2A8, 0x009DC2DA, 0x009DC2E8, 0x009DC2FF, 0x009DC30D, 
						  0x009DC33A, 0x009DC348, 0x009DC61B, 0x009DC60D, 0x009DC6F4, 0x009DC734, 0x009DC894, 0x009DC8D9, 0x009DC929, 0x009DC940, 
						  0x009DC9C7, 0x009DCA17, 0x009DCA2E, 0x009DCAB5, 0x009DCB05, 0x009DCB1C, 0x009DC767, 0x009DCBA3, 0x009DCBF3, 0x009DCC43, 
						  0x009DC7A0, 0x009DC7E7, 0x009DCE10, 0x009DCE2A, 0x009DD0B7, 0x009DD0F2, 0x009DD10E, 0x009DCFC5, 0x009DD06A, 0x009DD1B8, 
						  0x009DD1EA, 0x009DD208, 0x009DD21B, 0x009DD23E, 0x009DD265, 0x009DD335, 0x009DD35B, 0x009DD371, 0x009DD47A, 0x009DD48C, 
						  0x009DD630, 0x009DD80D, 0x009DD83F, 0x009DDA2F, 0x009DDA98, 0x009DDAD1, 0x009DDAFF, 0x009DDB77, 0x009DDBA2, 0x009DDC06, 
						  0x009DD767, 0x009DD79E, 0x009DE2E4, 0x009DE30D, 0x009DE329, 0x009DE353, 0x009DE3A5, 0x009DE275, 0x009DE2AF, 0x009DE406, 
						  0x009DE474, 0x009DE44E, 0x009DE4C0, 0x009DE60E, 0x009DE644, 0x009DE667, 0x009DE675, 0x009DE501, 0x009DE56A, 0x009DE6C1, 
						  0x009DE72A, 0x009DE961, 0x009DE97D, 0x009DE8CF, 0x009DE8E9, 0x009DE901, 0x009DE93D, 0x009DEABA, 0x009DEB02, 0x009DEB34, 
						  0x009DEB45, 0x009DEB77, 0x009DEB88, 0x009DEBA6, 0x009DEAA2, 0x009DED54, 0x009DED66, 0x009DED85, 0x009DED9A, 0x009DEF42, 
						  0x009DEF60, 0x009DF234, 0x009DF130, 0x009DF187, 0x009DF11E, 0x009DF555, 0x009DF452, 0x009DF4B2, 0x009DF43E, 0x009DF6D2, 
						  0x009DF961, 0x009DF732, 0x009DF6BE, 0x009DFAD4, 0x009DFC3E, 0x009DFCAB, 0x009DFCD8, 0x009DFB4C, 0x009DFB74, 0x009DFBA6, 
						  0x009DFE37, 0x009DFE49, 0x009E01A0, 0x009E01BA, 0x009E01CC, 0x009E045B, 0x009E047B, 0x009E0497, 0x009E063D, 0x009E0689, 
						  0x009E056C, 0x009E057E, 0x009E0A11, 0x009E0A34, 0x009E09FF, 0x009E0CF5, 0x009E0F79, 0x009E0F6B, 0x009E100E, 0x009E121A, 
						  0x009E112C, 0x009E1168, 0x009E119B, 0x009E111E, 0x009E1204, 0x009E15DA, 0x009E14EC, 0x009E1723, 0x009E152D, 0x009E154F, 
						  0x009E1588, 0x009E159A, 0x009E1B7C, 0x009E1BA3, 0x009E1BF8, 0x009E1F42, 0x009E21E2, 0x009E21F4, 0x009E2039, 0x009E204B, 
						  0x009E2324, 0x009E5C28, 0x009E5D52, 0x009E5D72, 0x009E5D8E, 0x009E5DEB, 0x009E271D, 0x009E273D, 0x009E2286, 0x009E2298, 
						  0x009E2C4A, 0x009E2C5C, 0x009E2D40, 0x009E22DD, 0x009E2FBC, 0x009E2FCE, 0x009E30B2, 0x009E2311, 0x009E60BA, 0x009E60D0, 
						  0x009E60F8, 0x009E6144, 0x009E6157, 0x009E6175, 0x009E61C6, 0x009E629D, 0x009E6466, 0x009E6471, 0x009E6504, 0x009E650F, 
						  0x009E62AE, 0x009E6808, 0x009E6813, 0x009E65DF, 0x009E65F0, 0x009E686E, 0x009E6893, 0x009E6A9A, 0x009E692C, 0x009E6948, 
						  0x009E6961, 0x009E696C, 0x009E6E6B, 0x009E7071, 0x009E70E5, 0x009E744A, 0x009E753A, 0x009E773A, 0x009E7DFA, 0x009E86F5, 
						  0x009E8726, 0x009E89DF, 0x009E8A10, 0x009E8909, 0x009E8923, 0x009E8B6F, 0x009E8BDE, 0x009E8C1E, 0x009E8CB1, 0x009E8FC0, 
						  0x009E9588, 0x009E9599, 0x009EA7DB, 0x009EA80C, 0x009EA829, 0x009EA840, 0x009EA8C3, 0x009EA8DC, 0x009EA8F9, 0x009EA90B, 
						  0x009EA923, 0x009EA93C, 0x009EA95D, 0x009EA96F, 0x009EA9B3, 0x009EA9D1, 0x009EAA13, 0x009EAA47, 0x009EAA75, 0x009EAA87, 
						  0x009EAAAB, 0x009EAACD, 0x009EABA7, 0x009E9936, 0x009E9989, 0x009E999B, 0x009E9AF9, 0x009E9B36, 0x009E9C8F, 0x009E9CD9, 
						  0x009E9CF2, 0x009E9D0F, 0x009E9D21, 0x009E9D39, 0x009E9D64, 0x009E9D76, 0x009E9EBD, 0x009E9EE2, 0x009E9EF7, 0x009E9F14, 
						  0x009E9F26, 0x009EA033, 0x009EA064, 0x009EA072, 0x009EA099, 0x009EA0A7, 0x009EA0D1, 0x009E9861, 0x009EA0F7, 0x009EA12B, 
						  0x009EA294, 0x009EA2F1, 0x009EA30E, 0x009EA326, 0x009EA35A, 0x009EA3AB, 0x009EA3C8, 0x009EA40D, 0x009EA46B, 0x009EA755, 
						  0x009EA77C, 0x009EA792, 0x009EA7C5, 0x009EAD0C, 0x009EAD52, 0x009EADA8, 0x009EAF62, 0x009EAF7A, 0x009EAF96, 0x009EB00B, 
						  0x009EB063, 0x009EAE7A, 0x009EAED4, 0x009EAEFE, 0x009EB1B5, 0x009EB218, 0x009EB237, 0x009EB24C, 0x009EB0D4, 0x009EB0FA, 
						  0x009EB139, 0x009EB162, 0x009EB0BD, 0x009EB180, 0x009EB198, 0x009EB3A9, 0x009EB2F3, 0x009EB356, 0x009EB36F, 0x009EB28F, 
						  0x009EB608, 0x009EB512, 0x009EB699, 0x009EB71B, 0x009EB529, 0x009EB537, 0x009EB56D, 0x009EB5E2, 0x009EB8D9, 0x009EB8E8, 
						  0x009EB8BF, 0x009EBACF, 0x009EBB2A, 0x009EBB3F, 0x009EBDBE, 0x009EC022, 0x009EC071, 0x009EC29E, 0x009EC2D3, 0x009EC344, 
						  0x009EC620, 0x009EC65E, 0x009EC6BF, 0x009EC847, 0x009EC728, 0x009EC8A4, 0x009EC916, 0x009EC92D, 0x009EC9D5, 0x009ECA47, 
						  0x009ECA5E, 0x009EC745, 0x009ECAFB, 0x009ECB6D, 0x009ECB84, 0x009ECC31, 0x009EC7A1, 0x009EC7B9, 0x009ECD1B, 0x009ECC9F, 
						  0x009ECD64, 0x009ECD75, 0x009ECD87, 0x009ECDB3, 0x009ECDC1, 0x009ECDF7, 0x009ECD4D, 0x009ECE93, 0x009ECEAA, 0x009ECEC1, 
						  0x009ECF5B, 0x009ECF7C, 0x009ED169, 0x009ED190, 0x009ED2B4, 0x009ED2DB, 0x009ED07A, 0x009ED0B2, 0x009ED0C0, 0x009ED0DD, 
						  0x009ED63F, 0x009ED67F, 0x009ED6A8, 0x009ED6B6, 0x009ED6CA, 0x009ED6D8, 0x009ED62C, 0x009EDFCA, 0x009EDFD8, 0x009EE143, 
						  0x009EE47F, 0x009EE497, 0x009EE4AE, 0x009EE4C5, 0x009EE4F8, 0x009EE506, 0x009EE519, 0x009EE46C, 0x009EE6EA, 0x009EE5FF, 
						  0x009EE91D, 0x009EE940, 0x009EEA56, 0x009EEA64, 0x009EEBF8, 0x009EEF38, 0x009EF07A, 0x009EF35B, 0x009EF40A, 0x009EEC83, 
						  0x009EF5F3, 0x009EF489, 0x009EF611, 0x009EF64F, 0x009EF66A, 0x009EF68E, 0x009EF6B6, 0x009EF6C5, 0x009EF6DF, 0x009EF497, 
						  0x009EF708, 0x009EF78F, 0x009EF4BA, 0x009EF4CC, 0x009EF4FA, 0x009EF547, 0x009EF7E8, 0x009EF9CB, 0x009EFA1D, 0x009EF890, 
						  0x009EF8B7, 0x009EFA76, 0x009EFB3D, 0x009EFB4B, 0x009EFE53, 0x009EFE69, 0x009EFDD3, 0x009EFDFB, 0x009F00D8, 0x009F0017, 
						  0x009F0057, 0x009F006F, 0x009F0230, 0x009F02A2, 0x009F0379, 0x009F043F, 0x009F050E, 0x009F0553, 0x009F056A, 0x009F05A6, 
						  0x009F05B5, 0x009F05C9, 0x009F062C, 0x009F065C, 0x009F064D, 0x009F094F, 0x009F09A8, 0x009F112A, 0x009F11EA, 0x009F148D, 
						  0x009F1576, 0x009F158E, 0x009F16F9, 0x009F1787, 0x009F186C, 0x009F189C, 0x009F18F2, 0x009F1902, 0x009F13A3, 0x009F24EB, 
						  0x009F26E2, 0x009F26F5, 0x009F270F, 0x009F2753, 0x009F2602, 0x009F2612, 0x009F262C, 0x009F28D9, 0x009F28EA, 0x009F28FA, 
						  0x009F2B98, 0x009F2BAA, 0x009F2BBE, 0x009F2EAA, 0x009F3341, 0x009F330C, 0x009F3923, 0x009F39FE, 0x009F3A11, 0x009F3A3A, 
						  0x009F3B20, 0x009F3C34, 0x009F3C3F, 0x009F3C59, 0x009F3C6A, 0x009F3C7F, 0x009F3B3A, 0x009F3B55, 0x009F3B8C, 0x009F3BED, 
						  0x009F3D09, 0x009F3EA6, 0x009F3F21, 0x009F3FD5, 0x009F3D40, 0x009F40EB, 0x009F4283, 0x009F4E45, 0x009F50D5, 0x009F4F3F, 
						  0x009F4FEE, 0x009F5006, 0x009F512A, 0x009F510F, 0x009F5341, 0x009F539F, 0x009F52AB, 0x009F554B, 0x009F55E0, 0x009F62DE, 
						  0x009F6306, 0x009F6320, 0x009F63A4, 0x009F63BB, 0x009F6425, 0x009F64AE, 0x009F64C5, 0x009F625A, 0x009F62C4, 0x009F660E, 
						  0x009F66D5, 0x009F6755, 0x009F676F, 0x009F6888, 0x009F68BE, 0x009F68DA, 0x009F691C, 0x009F6A87, 0x009F6B1E, 0x009F6B3C, 
						  0x009F6B5D, 0x009F6B0F, 0x009F6BC9, 0x009F6BE2, 0x009F6BFE, 0x009F6C41, 0x009F6BAF, 0x009F6C82, 0x009F6CAA, 0x009F6C6F, 
						  0x009F6D03, 0x009F6D2B, 0x009F6CCF, 0x009F6D62, 0x009F6D8A, 0x009F6D4F, 0x009F6DB0, 0x009F6EF7, 0x009F6DF7, 0x009F7353, 
						  0x009F7381, 0x009F73D1, 0x009F8F88, 0x009F8E8F, 0x009F8ED2, 0x009F8F1C, 0x009F8E7C, 0x009F91CF, 0x009F9218, 0x009F9353, 
						  0x009F9362, 0x009F9384, 0x009F9393, 0x009F95FC, 0x009F9608, 0x009F9E35, 0x009F9F06, 0x009F9FFB, 0x009FA011, 0x009F9FEB, 
						  0x009FA758, 0x009FA791, 0x009FA79F, 0x009FA7AD, 0x009FA814, 0x009FA82E, 0x009FA8A0, 0x009FAA92, 0x009FAB08, 0x009FAB1D, 
						  0x009FA984, 0x009FA99A, 0x009FAA16, 0x009FAC72, 0x009FAC94, 0x009FACAE, 0x009FACC8, 0x009FAEDF, 0x009FAEF2, 0x009FB065, 
						  0x009FB14A, 0x009FB160, 0x009FB17D, 0x009FB1E8, 0x009FB354, 0x009FB370, 0x009FB3D6, 0x009FAE0A, 0x009FB7CB, 0x009FB9F9, 
						  0x009FBA8D, 0x009FBB57, 0x009FBB7C, 0x009FBC34, 0x009FBC47, 0x009FC192, 0x009FC258, 0x009FC272, 0x009FC332, 0x009FC425, 
						  0x009FC498, 0x009FC72B, 0x009FC756, 0x009FCBD0, 0x009FCBBA, 0x009FCC83, 0x009FCC6C, 0x009FD7CE, 0x009FD7DF, 0x009FD823, 
						  0x009FD6F1, 0x009FD73C, 0x009FD764, 0x009FD78C, 0x009FD7A9, 0x009FDA6B, 0x009FDAE0, 0x009FD8B6, 0x009FD8D2, 0x009FD91F, 
						  0x009FDCA5, 0x009FDCB1, 0x009FDCC9, 0x009FDCE2, 0x009FDD3C, 0x009FDD2E, 0x009FDDD0, 0x009FDE00, 0x009FDE9F, 0x009FDEB7, 
						  0x009FDEDE, 0x009FDF07, 0x009FE6B1, 0x009FECD6, 0x009FF184, 0x009FF1A9, 0x009FF3FE, 0x009FF414, 0x009FF8BB, 0x009FF927, 
						  0x009FF98B, 0x009FF9ED, 0x009FFB75, 0x009FFBDE, 0x009FFA3F, 0x009FFC42, 0x009FFB0C, 0x009FFD6B, 0x009FFE14, 0x009FFF9C, 
						  0x009FFFA8, 0x009FFFC0, 0x00A001DF, 0x00A00283, 0x00A002CB, 0x00A0011B, 0x00A00139, 0x00A0015F, 0x00A00186, 0x00A001A6, 
						  0x00A005BF, 0x00A00601, 0x00A0060C, 0x00A00657, 0x00A00681, 0x00A00694, 0x00A00494, 0x00A004A4, 0x00A006E6, 0x00A006FE, 
						  0x00A0079B, 0x00A007A7, 0x00A00CFC, 0x00A00D08, 0x00A00E47, 0x00A00E61, 0x00A00E73, 0x00A00E87, 0x00A00EAE, 0x00A0128E, 
						  0x00A0171D, 0x00A01758, 0x00A01EEA, 0x00A02274, 0x00A0229A, 0x00A023CF, 0x00A023DF, 0x00A023F6, 0x00A0242D, 0x00A024E0, 
						  0x00A026C6, 0x00A02893, 0x00A029FC, 0x00A02BD2, 0x00A02BE5, 0x00A02C02, 0x00A02C15, 0x00A02CB5, 0x00A031E1, 0x00A0320C, 
						  0x00A02FD9, 0x00A02FFD, 0x00A03057, 0x00A0307C, 0x00A034AF, 0x00A03690, 0x00A038D6, 0x00A03913, 0x00A037CB, 0x00A037FC, 
						  0x00A0388D, 0x00A039AE, 0x00A03BE8, 0x00A03C1F, 0x00A03C49, 0x00A03D18, 0x00A03ED7, 0x00A03EE7, 0x00A03EFF, 0x00A03F1D, 
						  0x00A03F70, 0x00A03D48, 0x00A04384, 0x00A043A5, 0x00A043F9, 0x00A04488, 0x00A044D3, 0x00A0456A, 0x00A045D4, 0x00A04635, 
						  0x00A046BA, 0x00A047CD, 0x00A047DB, 0x00A0488E, 0x00A047BF, 0x00A048F7, 0x00A04940, 0x00A04A16, 0x00A04B5A, 0x00A04B68, 
						  0x00A04E20, 0x00A04E62, 0x00A04F0A, 0x00A04F3F, 0x00A04F67, 0x00A04F73, 0x00A04F86, 0x00A05026, 0x00A0503B, 0x00A0500E, 
						  0x00A0527A, 0x00A052B8, 0x00A052C4, 0x00A052DA, 0x00A0543D, 0x00A05458, 0x00A05489, 0x00A0549A, 0x00A0540B, 0x00A054B8, 
						  0x00A054FF, 0x00A054E9, 0x00A05533, 0x00A056B3, 0x00A057A9, 0x00A0595B, 0x00A05D69, 0x00A05D88, 0x00A05D9E, 0x00A05DB1, 
						  0x00A06073, 0x00A060C7, 0x00A06210, 0x00A064CB, 0x00A06938, 0x00A068B0, 0x00A068F3, 0x00A06C4B, 0x00A06CB0, 0x00A06FBF, 
						  0x00A06FFC, 0x00A0703B, 0x00A070BD, 0x00A077F5, 0x00A07803, 0x00A07819, 0x00A0782C, 0x00A07888, 0x00A07894, 0x00A07A1E, 
						  0x00A07EBD, 0x00A07ED5, 0x00A091F4, 0x00A093BC, 0x00A09417, 0x00A09ABD, 0x00A09B25, 0x00A0A05F, 0x00A0A06F, 0x00A0A07C, 
						  0x00A0A08C, 0x00A0A13A, 0x00A0A177, 0x00A0BB52, 0x00A0C72D, 0x00A0C8FB, 0x00A0C97E, 0x00A0C96F, 0x00A0CB9B, 0x00A0CC2A, 
						  0x00A0CCF0, 0x00A0CD51, 0x00A0CDAF, 0x00A0D074, 0x00A0D08C, 0x00A0D309, 0x00A0D4C6, 0x00A0D530, 0x00A0D53E, 0x00A0D844, 
						  0x00A0D8D2, 0x00A0D954, 0x00A0D9C1, 0x00A0DC51, 0x00A0DC6B, 0x00A0DC93, 0x00A0DB7D, 0x00A0DF57, 0x00A0E0DB, 0x00A0E288, 
						  0x00A0E297, 0x00A0E4D7, 0x00A0E4E6, 0x00A0E457, 0x00A0E6A8, 0x00A0E6C6, 0x00A0E8FF, 0x00A0E9E6, 0x00A0EA68, 0x00A0EA77, 
						  0x00A0EC74, 0x00A0ECB1, 0x00A0EDBF, 0x00A0EDCE, 0x00A0EDFA, 0x00A0FC8A, 0x00A105CE, 0x00A10984, 0x00A10993, 0x00A10C14, 
						  0x00A10C23, 0x00A11125, 0x00A111F5, 0x00A11275, 0x00A1162C, 0x00A118BF, 0x00A117F6, 0x00A1186A, 0x00A11A4A, 0x00A11A80, 
						  0x00A119B4, 0x00A11A07, 0x00A11E4C, 0x00A11EFC, 0x00A11FB9, 0x00A12102, 0x00A12049, 0x00A120BD, 0x00A12282, 0x00A121C9, 
						  0x00A1223D, 0x00A12309, 0x00A1233D, 0x00A12347, 0x00A1237D, 0x00A12387, 0x00A12429, 0x00A1245D, 0x00A12467, 0x00A1249D, 
						  0x00A124A7, 0x00A12577, 0x00A125BA, 0x00A125F0, 0x00A12760, 0x00A1276A, 0x00A126C7, 0x00A126EC, 0x00A12720, 0x00A1272A, 
						  0x00A128D0, 0x00A128DA, 0x00A12837, 0x00A1285C, 0x00A12890, 0x00A1289A, 0x00A129AE, 0x00A12A5E, 0x00A12B0E, 0x00A12B8B, 
						  0x00A12BBF, 0x00A12BC9, 0x00A12BFF, 0x00A12C09, 0x00A12CAB, 0x00A12CDF, 0x00A12CE9, 0x00A12D1F, 0x00A12D29, 0x00A12DCB, 
						  0x00A12DFF, 0x00A12E09, 0x00A12E3F, 0x00A12E49, 0x00A12F2B, 0x00A12FDC, 0x00A1301F, 0x00A13055, 0x00A16E2C, 0x00A16FD9, 
						  0x00A16FE5, 0x00A171DD, 0x00A1729D, 0x00A180F7, 0x00A18136, 0x00A18443, 0x00A199FC, 0x00A19A08, 0x00A19C80, 0x00A19D43, 
						  0x00A19D52, 0x00A19D60, 0x00A19D69, 0x00A19A74, 0x00A19E91, 0x00A19EA0, 0x00A19EAE, 0x00A19EB7, 0x00A19F77, 0x00A19F86, 
						  0x00A19F94, 0x00A19F9D, 0x00A19AB3, 0x00A19AF5, 0x00A19B1C, 0x00A1A55C, 0x00A1A568, 0x00A1A577, 0x00A1A585, 0x00A1A58E, 
						  0x00A1A661, 0x00A1A66D, 0x00A1A67C, 0x00A1A68A, 0x00A1A693, 0x00A1A821, 0x00A1A88C, 0x00A1A965, 0x00A1A999, 0x00A1B81E, 
						  0x00A1B827, 0x00A1B9F7, 0x00A1BBAE, 0x00A1BBE8, 0x00A1BC2A, 0x00A1C1EA, 0x00A1D1AA, 0x00A1E4EA, 0x00A1EF8E, 0x00A1EF9C, 
						  0x00A204B2, 0x00A20706, 0x00A20610, 0x00A20697, 0x00A206CE, 0x00A20ABD, 0x00A20AF6, 0x00A20FDE, 0x00A2100C, 0x00A21224, 
						  0x00A2122D, 0x00A21236, 0x00A2123F, 0x00A21154, 0x00A21182, 0x00A211AA, 0x00A211BF, 0x00A211D4, 0x00A211E9, 0x00A21EE5, 
						  0x00A21EF3, 0x00A22267, 0x00A22275, 0x00A221E4, 0x00A22450, 0x00A224EE, 0x00A224FD, 0x00A2258E, 0x00A2259D, 0x00A226E7, 
						  0x00A227B3, 0x00A227C1, 0x00A22C39, 0x00A22D07, 0x00A22D16, 0x00A22DEF, 0x00A22DFE, 0x00A22FAC, 0x00A22EC2, 0x00A22F0D, 
						  0x00A23057, 0x00A233E2, 0x00A234E0, 0x00A232E7, 0x00A236D6, 0x00A2384D, 0x00A24ACA, 0x00A25A5A, 0x00A261AC, 0x00A2629C, 
						  0x00A2638C, 0x00A26523, 0x00A26672, 0x00A26777, 0x00A26792, 0x00A269D7, 0x00A27453, 0x00A2784A, 0x00A278BF, 0x00A2776D, 
						  0x00A277AE, 0x00A277DA, 0x00A27B83, 0x00A27BB2, 0x00A27CC0, 0x00A27D37, 0x00A27DBE, 0x00A27EC2, 0x00A27F7B, 0x00A2831E, 
						  0x00A2840A, 0x00A29818, 0x00A2992C, 0x00A29938, 0x00A29D7B, 0x00A2DEAA, 0x00A2DFA4, 0x00A2E0F4, 0x00A2E244, 0x00A2E52C, 
						  0x00A2E53F, 0x00A2E60C, 0x00A2E61F, 0x00A2E6EC, 0x00A2E6FF, 0x00A2E7BD, 0x00A2F3D8, 0x00A2F455, 0x00A2F540, 0x00A30A4D, 
						  0x00A31038, 0x00A31065, 0x00A310E5, 0x00A31104, 0x00A31130, 0x00A31201, 0x00A31308, 0x00A313DE, 0x00A316CC, 0x00A318E0, 
						  0x00A319CA, 0x00A31AB4, 0x00A31B66, 0x00A31BBE, 0x00A31BD1, 0x00A31BE5, 0x00A31C0D, 0x00A31C91, 0x00A31CB3, 0x00A31D4F, 
						  0x00A31D87, 0x00A31DDF, 0x00A31DF2, 0x00A31E06, 0x00A31E2E, 0x00A31EB2, 0x00A31ED4, 0x00A3201E, 0x00A32169, 0x00A3242B, 
						  0x00A32975, 0x00A32990, 0x00A32C27, 0x00A32C42, 0x00A32F5F, 0x00A32F80, 0x00A32F90, 0x00A330C2, 0x00A3345F, 0x00A33512, 
						  0x00A33521, 0x00A33845, 0x00A338DD, 0x00A338FB, 0x00A33904, 0x00A3392F, 0x00A339F6, 0x00A33A91, 0x00A33AF3, 0x00A33B04, 
						  0x00A33B47, 0x00A33A6F, 0x00A33B58, 0x00A33C42, 0x00A33C54, 0x00A33C6D, 0x00A33CC5, 0x00A33CD4, 0x00A33CEA, 0x00A33DBD, 
						  0x00A33DDB, 0x00A33DE4, 0x00A33E0F, 0x00A33FF2, 0x00A3402B, 0x00A3403B, 0x00A34044, 0x00A3417B, 0x00A3418B, 0x00A34194, 
						  0x00A342DD, 0x00A342FB, 0x00A34304, 0x00A3432A, 0x00A34339, 0x00A3435C, 0x00A345CF, 0x00A34531, 0x00A3454F, 0x00A34558, 
						  0x00A3458C, 0x00A3480B, 0x00A3486A, 0x00A349C0, 0x00A34A84, 0x00A34EE1, 0x00A34E2B, 0x00A34E41, 0x00A34E5F, 0x00A34E68, 
						  0x00A34E9E, 0x00A34F9F, 0x00A34FAE, 0x00A34FC4, 0x00A350BD, 0x00A350DB, 0x00A350E4, 0x00A3510F, 0x00A352AD, 0x00A352CB, 
						  0x00A352D4, 0x00A35447, 0x00A3548E, 0x00A35597, 0x00A355C3, 0x00A355D7, 0x00A3565B, 0x00A3569A, 0x00A3543E, 0x00A3584A, 
						  0x00A35868, 0x00A35871, 0x00A359EB, 0x00A35A09, 0x00A35A12, 0x00A35AED, 0x00A35B0B, 0x00A35B14, 0x00A35B3F, 0x00A35CA2, 
						  0x00A35E52, 0x00A35E70, 0x00A35E79, 0x00A35EAA, 0x00A35EF7, 0x00A3602D, 0x00A3604B, 0x00A36054, 0x00A3611D, 0x00A3613B, 
						  0x00A36144, 0x00A3616F, 0x00A36274, 0x00A3637D, 0x00A3639B, 0x00A363A4, 0x00A363CF, 0x00A364D4, 0x00A3660B, 0x00A3661B, 
						  0x00A36624, 0x00A368A1, 0x00A368BF, 0x00A368C8, 0x00A36A1B, 0x00A36A39, 0x00A36A42, 0x00A36A8E, 0x00A36CA0, 0x00A36CE4, 
						  0x00A36CFE, 0x00A36D4A, 0x00A36D68, 0x00A36D71, 0x00A36D9C, 0x00A36FEE, 0x00A36F90, 0x00A36FD4, 0x00A370E6, 0x00A37118, 
						  0x00A37127, 0x00A3713D, 0x00A37254, 0x00A372A7, 0x00A37304, 0x00A37469, 0x00A374D0, 0x00A37425, 0x00A375D8, 0x00A375F6, 
						  0x00A375FF, 0x00A3756C, 0x00A37628, 0x00A37809, 0x00A3784A, 0x00A378B7, 0x00A37A1F, 0x00A37A31, 0x00A37AA6, 0x00A379DE, 
						  0x00A37D17, 0x00A37D58, 0x00A37DC5, 0x00A37E63, 0x00A3807A, 0x00A38098, 0x00A380A1, 0x00A380C9, 0x00A3836A, 0x00A383AB, 
						  0x00A383BD, 0x00A38428, 0x00A38496, 0x00A38690, 0x00A386AE, 0x00A386B7, 0x00A38703, 0x00A38746, 0x00A38786, 0x00A3859F, 
						  0x00A38849, 0x00A38B2A, 0x00A38B48, 0x00A38B51, 0x00A38B79, 0x00A38C2A, 0x00A38C48, 0x00A38C51, 0x00A38C79, 0x00A38D2A, 
						  0x00A38D48, 0x00A38D51, 0x00A38D79, 0x00A38FE8, 0x00A39045, 0x00A390B4, 0x00A3913A, 0x00A392CE, 0x00A391A7, 0x00A393AD, 
						  0x00A393BE, 0x00A3965D, 0x00A3966E, 0x00A39B5B, 0x00A39B92, 0x00A39C01, 0x00A39C87, 0x00A39D27, 0x00A3BA43, 0x00A3BAA2, 
						  0x00A3BB0F, 0x00A3BB74, 0x00A3BEE6, 0x00A3BEFD, 0x00A3BF87, 0x00A3BF9D, 0x00A3BFB3, 0x00A3BFF1, 0x00A3C029, 0x00A3C03A, 
						  0x00A3C058, 0x00A3C080, 0x00A3C08E, 0x00A3C0B2, 0x00A3C0E2, 0x00A3C2FF, 0x00A3C320, 0x00A3C330, 0x00A3C3D8, 0x00A3CC4D, 
						  0x00A3CCE1, 0x00A3CD79, 0x00A3CDF8, 0x00A3CBB9, 0x00A3DBFF, 0x00A3DC39, 0x00A3DB8E, 0x00A3DDFB, 0x00A3DE26, 0x00A3DEC1, 
						  0x00A3DEEC, 0x00A3E3C0, 0x00A3E6E8, 0x00A3E702, 0x00A3E632, 0x00A3E770, 0x00A3E9A8, 0x00A3E9CD, 0x00A3E9DC, 0x00A3E931, 
						  0x00A3E95E, 0x00A3EC9E, 0x00A3ECDC, 0x00A3EBDD, 0x00A3EC16, 0x00A3EC5A, 0x00A3EE2B, 0x00A3EE5C, 0x00A3EE6B, 0x00A3EF15, 
						  0x00A3EF64, 0x00A3ED85, 0x00A3EDB5, 0x00A3F0FB, 0x00A3F120, 0x00A3F014, 0x00A3F04D, 0x00A3F09B, 0x00A3F0BF, 0x00A3F1C0, 
						  0x00A3F22F, 0x00A3F271, 0x00A3F310, 0x00A3F37F, 0x00A3F8D6, 0x00A3F9EC, 0x00A42280, 0x00A422E7, 0x00A424FA, 0x00A426B6, 
						  0x00A427E4, 0x00A42934, 0x00A42A87, 0x00A42BD4, 0x00A42D24, 0x00A42E74, 0x00A42FC4, 0x00A44439, 0x00A44443, 0x00A4497C, 
						  0x00A44A7A, 0x00A44AB2, 0x00A44AEC, 0x00A44D98, 0x00A4500C, 0x00A4501F, 0x00A450EC, 0x00A450FF, 0x00A451CC, 0x00A451DF, 
						  0x00A452BC, 0x00A452CF, 0x00A4539C, 0x00A453AF, 0x00A4547C, 0x00A4548F, 0x00A4555C, 0x00A4556F, 0x00A45FEA, 0x00A4609A, 
						  0x00A4614A, 0x00A465FE, 0x00A46E57, 0x00A46FAC, 0x00A47011, 0x00A47079, 0x00A470E1, 0x00A47149, 0x00A471B1, 0x00A47219, 
						  0x00A47281, 0x00A472E9, 0x00A47351, 0x00A473B9, 0x00A47421, 0x00A46EDC, 0x00A47489, 0x00A474F1, 0x00A47519, 0x00A47586, 
						  0x00A475AE, 0x00A46EF8, 0x00A4761B, 0x00A47643, 0x00A476B0, 0x00A476D8, 0x00A47745, 0x00A477AD, 0x00A47815, 0x00A4787D, 
						  0x00A478E5, 0x00A4794D, 0x00A46F56, 0x00A479E5, 0x00A47A06, 0x00A47A70, 0x00A47B15, 0x00A47B60, 0x00A47BE5, 0x00A47C30, 
						  0x00A47CB5, 0x00A47D00, 0x00A47DA5, 0x00A47DC6, 0x00A47DF3, 0x00A47E40, 0x00A47F35, 0x00A47F56, 0x00A47F83, 0x00A47FD0, 
						  0x00A48085, 0x00A480A6, 0x00A48100, 0x00A481F5, 0x00A48216, 0x00A48243, 0x00A48290, 0x00A4883E, 0x00A48853, 0x00A4887D, 
						  0x00A488EE, 0x00A48903, 0x00A4892D, 0x00A489AD, 0x00A489B5, 0x00A48A6D, 0x00A48A75, 0x00A48E04, 0x00A48F5E, 0x00A48C3C, 
						  0x00A4900C, 0x00A4901C, 0x00A4906A, 0x00A4907E, 0x00A49092, 0x00A490A6, 0x00A490B7, 0x00A490C9, 0x00A490E6, 0x00A49109, 
						  0x00A49122, 0x00A49148, 0x00A48C80, 0x00A48C8E, 0x00A48CA4, 0x00A48CBC, 0x00A491D1, 0x00A491DD, 0x00A4943F, 0x00A49469, 
						  0x00A49474, 0x00A49501, 0x00A4950D, 0x00A498AC, 0x00A49E08, 0x00A49D31, 0x00A49D07, 0x00A49FF2, 0x00A4A213, 0x00A4A1E9, 
						  0x00A4A286, 0x00A4A2B0, 0x00A4A2DA, 0x00A4A350, 0x00A4A37A, 0x00A4A3B0, 0x00A4A3DA, 0x00A4A43E, 0x00A4A4CE, 0x00A4A74D, 
						  0x00A4A7A6, 0x00A4A873, 0x00A4ACDB, 0x00A4AFE1, 0x00A4AFB7, 0x00A4B039, 0x00A4B0CC, 0x00A4B0E2, 0x00A4B10E, 0x00A4B179, 
						  0x00A4B185, 0x00A4B5DA, 0x00A4B5F0, 0x00A4B811, 0x00A4B7E7, 0x00A4B8A1, 0x00A4B8FA, 0x00A4B8CA, 0x00A4BA68, 0x00A4B979, 
						  0x00A4B9B2, 0x00A4B969, 0x00A4BB26, 0x00A4BB40, 0x00A4BF40, 0x00A4BF61, 0x00A4C04B, 0x00A4C351, 0x00A4C3B8, 0x00A4C4BD, 
						  0x00A4C4AF, 0x00A4C6FF, 0x00A4C717, 0x00A4CA8C, 0x00A4C9CA, 0x00A4C9F1, 0x00A4CD6C, 0x00A4CCA4, 0x00A4CEE7, 0x00A4DF3A, 
						  0x00A4DFAB, 0x00A4E01C, 0x00A4E08D, 0x00A4E0FE, 0x00A4E16F, 0x00A4E1E0, 0x00A4D052, 0x00A4E251, 0x00A4E2C2, 0x00A4E333, 
						  0x00A4E3A4, 0x00A4E415, 0x00A4E486, 0x00A4E4F7, 0x00A4E568, 0x00A4E5D9, 0x00A4E64A, 0x00A4E6BB, 0x00A4E72C, 0x00A4E79D, 
						  0x00A4E80E, 0x00A4E87F, 0x00A4D0BA, 0x00A4E8F0, 0x00A4E961, 0x00A4E9D2, 0x00A4EA43, 0x00A4EAB4, 0x00A4EB25, 0x00A4EB96, 
						  0x00A4EC07, 0x00A4EC78, 0x00A4ECE9, 0x00A4ED5A, 0x00A4EDCB, 0x00A4EE3C, 0x00A4EEAD, 0x00A4EF1E, 0x00A4D122, 0x00A4EF8F, 
						  0x00A4F000, 0x00A4F071, 0x00A4F0E2, 0x00A4F153, 0x00A4F1C4, 0x00A4F235, 0x00A4F2A6, 0x00A4F317, 0x00A4F388, 0x00A4F3F9, 
						  0x00A4F46A, 0x00A4F4DB, 0x00A4F54C, 0x00A4F5BD, 0x00A4D18A, 0x00A4F62E, 0x00A4F69F, 0x00A4F710, 0x00A4F781, 0x00A4F7F2, 
						  0x00A4F863, 0x00A4F8D4, 0x00A4F945, 0x00A4F9B6, 0x00A4FA27, 0x00A4FA98, 0x00A4FB09, 0x00A4FB7A, 0x00A4FBEB, 0x00A4D1F2, 
						  0x00A4FC5C, 0x00A4FCCD, 0x00A4FD3E, 0x00A4FDAF, 0x00A4FE20, 0x00A4FE91, 0x00A4FF02, 0x00A4FF73, 0x00A4FFE4, 0x00A50055, 
						  0x00A500C6, 0x00A50137, 0x00A501A8, 0x00A50219, 0x00A5028A, 0x00A4D25A, 0x00A502FB, 0x00A5036C, 0x00A503DD, 0x00A5044E, 
						  0x00A504BF, 0x00A50530, 0x00A505A1, 0x00A50612, 0x00A50683, 0x00A506F4, 0x00A50765, 0x00A507D6, 0x00A50847, 0x00A508B8, 
						  0x00A50929, 0x00A4D2C2, 0x00A5099A, 0x00A50A0B, 0x00A50A7C, 0x00A50AED, 0x00A50B5E, 0x00A50BCF, 0x00A50C40, 0x00A50CB1, 
						  0x00A50D22, 0x00A50D93, 0x00A50E04, 0x00A50E75, 0x00A50EE6, 0x00A50F57, 0x00A4D32A, 0x00A50FC8, 0x00A51039, 0x00A510AA, 
						  0x00A5111B, 0x00A5118C, 0x00A4D392, 0x00A4D3FA, 0x00A4D462, 0x00A4D4CA, 0x00A4D532, 0x00A4CF82, 0x00A4D59A, 0x00A4D602, 
						  0x00A4D66A, 0x00A4D6D2, 0x00A4D73A, 0x00A4D7A2, 0x00A4D80A, 0x00A4D872, 0x00A4D8DA, 0x00A4D942, 0x00A4D9AA, 0x00A4DA12, 
						  0x00A4DA7A, 0x00A4DAE2, 0x00A4DB4A, 0x00A4DBB2, 0x00A4CFEA, 0x00A4DC23, 0x00A4DC94, 0x00A4DD05, 0x00A4DD76, 0x00A4DDE7, 
						  0x00A4DE58, 0x00A4DEC9, 0x00A51715, 0x00A51736, 0x00A51790, 0x00A51835, 0x00A51856, 0x00A518B0, 0x00A51955, 0x00A51976, 
						  0x00A519A3, 0x00A519F0, 0x00A51AE5, 0x00A51B06, 0x00A51B60, 0x00A51C05, 0x00A51C26, 0x00A51C80, 0x00A51D25, 0x00A51D70, 
						  0x00A51DF5, 0x00A51E16, 0x00A51E43, 0x00A51E90, 0x00A51F55, 0x00A51F76, 0x00A51FD0, 0x00A52075, 0x00A52096, 0x00A520C3, 
						  0x00A52110, 0x00A521C5, 0x00A521E6, 0x00A52213, 0x00A52240, 0x00A52290, 0x00A52365, 0x00A52386, 0x00A523E0, 0x00A52485, 
						  0x00A524A6, 0x00A524D3, 0x00A52520, 0x00A52655, 0x00A52676, 0x00A526D0, 0x00A52775, 0x00A527C0, 0x00A52845, 0x00A52890, 
						  0x00A52915, 0x00A52960, 0x00A529E5, 0x00A52A30, 0x00A52AB5, 0x00A52B00, 0x00A52B85, 0x00A52BA6, 0x00A52C00, 0x00A52CA5, 
						  0x00A52CC6, 0x00A52D20, 0x00A52DC5, 0x00A52E10, 0x00A52E95, 0x00A52EB6, 0x00A52F10, 0x00A52FB5, 0x00A52FD6, 0x00A53030, 
						  0x00A530D5, 0x00A530F6, 0x00A53150, 0x00A531F5, 0x00A53275, 0x00A532C0, 0x00A53345, 0x00A53390, 0x00A53415, 0x00A53460, 
						  0x00A534E5, 0x00A53530, 0x00A535B5, 0x00A53600, 0x00A53685, 0x00A536A6, 0x00A53735, 0x00A53756, 0x00A53783, 0x00A537D0, 
						  0x00A53885, 0x00A538A6, 0x00A53900, 0x00A539A5, 0x00A539C6, 0x00A53A20, 0x00A53AC5, 0x00A53AE6, 0x00A53B40, 0x00A53BE5, 
						  0x00A53C06, 0x00A53C60, 0x00A53D05, 0x00A53D26, 0x00A53D80, 0x00A53E25, 0x00A53E46, 0x00A53EA0, 0x00A53F45, 0x00A53F66, 
						  0x00A53FC0, 0x00A5413A, 0x00A54167, 0x00A54194, 0x00A541C1, 0x00A541EE, 0x00A54065, 0x00A54086, 0x00A540B3, 0x00A540E0, 
						  0x00A5410D, 0x00A54240, 0x00A543E5, 0x00A54406, 0x00A54460, 0x00A54505, 0x00A54526, 0x00A54553, 0x00A545A0, 0x00A5468D, 
						  0x00A546ED, 0x00A54730, 0x00A547F5, 0x00A54816, 0x00A54870, 0x00A54915, 0x00A54936, 0x00A54963, 0x00A549B0, 0x00A54A65, 
						  0x00A54A86, 0x00A54AE0, 0x00A54B85, 0x00A54BA6, 0x00A54C00, 0x00A54CA5, 0x00A54CC6, 0x00A54CF3, 0x00A54D40, 0x00A54E05, 
						  0x00A54E26, 0x00A54E80, 0x00A54F25, 0x00A54F46, 0x00A54FA0, 0x00A55045, 0x00A55066, 0x00A55093, 0x00A550E0, 0x00A55195, 
						  0x00A551B6, 0x00A551E3, 0x00A55230, 0x00A552E5, 0x00A55306, 0x00A55333, 0x00A55380, 0x00A55435, 0x00A55456, 0x00A554B0, 
						  0x00A55555, 0x00A55576, 0x00A555A3, 0x00A555F0, 0x00A556A5, 0x00A556C6, 0x00A55720, 0x00A557AD, 0x00A557F0, 0x00A55965, 
						  0x00A55986, 0x00A559B3, 0x00A55A35, 0x00A55A56, 0x00A55A83, 0x00A55AB0, 0x00A55ADD, 0x00A5716E, 0x00A57183, 0x00A571AD, 
						  0x00A5721E, 0x00A57233, 0x00A5725D, 0x00A572EE, 0x00A57303, 0x00A5732D, 0x00A573CE, 0x00A573E3, 0x00A5740D, 0x00A5747E, 
						  0x00A57493, 0x00A574BD, 0x00A575AE, 0x00A575C3, 0x00A575ED, 0x00A5767E, 0x00A57693, 0x00A576BD, 0x00A5772E, 0x00A57743, 
						  0x00A5776D, 0x00A577DE, 0x00A577F3, 0x00A5781D, 0x00A5788E, 0x00A578A3, 0x00A578CD, 0x00A5793E, 0x00A57953, 0x00A5797D, 
						  0x00A57A5E, 0x00A57A73, 0x00A57A9D, 0x00A57B2D, 0x00A57B35, 0x00A57BED, 0x00A57BF5, 0x00A57CAD, 0x00A57CB5, 0x00A57D6D, 
						  0x00A57D75, 0x00A57E2D, 0x00A57E35, 0x00A57EED, 0x00A57EF5, 0x00A57FAD, 0x00A57FB5, 0x00A5806D, 0x00A58075, 0x00A5812D, 
						  0x00A58135, 0x00A581ED, 0x00A581F5, 0x00A582AD, 0x00A582B5, 0x00A584B4, 0x00A58604, 0x00A58754, 0x00A588A4, 0x00A589F4, 
						  0x00A58B44, 0x00A58DAC, 0x00A58DBF, 0x00A58E8C, 0x00A58E9F, 0x00A58F6C, 0x00A58F7F, 0x00A5904C, 0x00A5905F, 0x00A5912C, 
						  0x00A5913F, 0x00A5920C, 0x00A5921F, 0x00A596A7, 0x00A59726, 0x00A59795, 0x00A597E0, 0x00A598CE, 0x00A598E3, 0x00A5990D, 
						  0x00A5998D, 0x00A59995, 0x00A59A07, 0x00A59A37, 0x00A59A67, 0x00A5A1A7, 0x00A5A320, 0x00A5A33C, 0x00A5A39A, 0x00A5A3B6, 
						  0x00A5A41A, 0x00A5A442, 0x00A5A4AF, 0x00A5A4D7, 0x00A5A544, 0x00A5A56C, 0x00A5A5D9, 0x00A5A601, 0x00A5A66E, 0x00A5A696, 
						  0x00A5A703, 0x00A5A72B, 0x00A5A22C, 0x00A5A798, 0x00A5A7C0, 0x00A5A82D, 0x00A5A855, 0x00A5A8C2, 0x00A5A8EA, 0x00A5A248, 
						  0x00A5A957, 0x00A5A97F, 0x00A5A9EC, 0x00A5AA14, 0x00A5AA81, 0x00A5AAA9, 0x00A5AB16, 0x00A5AB3E, 0x00A5ABAB, 0x00A5ABD3, 
						  0x00A5AC40, 0x00A5AC68, 0x00A5A2A6, 0x00A5A2C2, 0x00A5ACF5, 0x00A5AD40, 0x00A5ADC5, 0x00A5ADE6, 0x00A5AE13, 0x00A5AE60, 
						  0x00A5AF15, 0x00A5AF36, 0x00A5AF63, 0x00A5AFB0, 0x00A5B065, 0x00A5B086, 0x00A5B0E0, 0x00A5B185, 0x00A5B1D0, 0x00A5B255, 
						  0x00A5B276, 0x00A5B2A3, 0x00A5B2F0, 0x00A5B624, 0x00A5B78C, 0x00A5B79F, 0x00A5B857, 0x00A5B887, 0x00A5B8B7, 0x00A5B8E7, 
						  0x00A5B917, 0x00A5BAA7, 0x00A5BB26, 0x00A5BB7C, 0x00A5BCCA, 0x00A5BBF5, 0x00A5BC16, 0x00A5BC43, 0x00A5BC70, 0x00A5BC9D, 
						  0x00A5BD20, 0x00A5BE1D, 0x00A5BE60, 0x00A5C04A, 0x00A5BF75, 0x00A5BF96, 0x00A5BFC3, 0x00A5BFF0, 0x00A5C01D, 0x00A5C28E, 
						  0x00A5C2A3, 0x00A5C2CD, 0x00A5C34D, 0x00A5C355, 0x00A5C4B7, 0x00A5C62A, 0x00A5C646, 0x00A5C536, 0x00A5C552, 0x00A5C5B0, 
						  0x00A5C5CC, 0x00A5C6C5, 0x00A5C710, 0x00A5C795, 0x00A5C7E0, 0x00A5C865, 0x00A5C886, 0x00A5C8E0, 0x00A5CAD2, 0x00A5CAE7, 
						  0x00A5CB11, 0x00A5CB8D, 0x00A5CB95, 0x00A5CE37, 0x00A5CF65, 0x00A5CFBB, 0x00A5D011, 0x00A5D067, 0x00A5D0BD, 0x00A5D113, 
						  0x00A5D169, 0x00A5D1BF, 0x00A5CEB9, 0x00A5CF0F, 0x00A5D2F5, 0x00A5D316, 0x00A5D370, 0x00A5D415, 0x00A5D436, 0x00A5D490, 
						  0x00A5D535, 0x00A5D556, 0x00A5D583, 0x00A5D5D0, 0x00A5D685, 0x00A5D6A6, 0x00A5D700, 0x00A5D7A5, 0x00A5D7C6, 0x00A5D820, 
						  0x00A5D8C5, 0x00A5D910, 0x00A5D995, 0x00A5D9B6, 0x00A5DA10, 0x00A5DAB5, 0x00A5DAD6, 0x00A5DB03, 0x00A5DB50, 0x00A5E05E, 
						  0x00A5E073, 0x00A5E09D, 0x00A5E13D, 0x00A5E145, 0x00A5E2C7, 0x00A5E4CA, 0x00A5E67D, 0x00A5E66F, 0x00A5E787, 0x00A5E8B5, 
						  0x00A5E809, 0x00A5E85F, 0x00A5E92D, 0x00A5E970, 0x00A5EB15, 0x00A5EB36, 0x00A5EB63, 0x00A5EB90, 0x00A5EBBD, 0x00A5EC10, 
						  0x00A5ED05, 0x00A5ED26, 0x00A5ED80, 0x00A5EEFA, 0x00A5EF27, 0x00A5EF54, 0x00A5EF81, 0x00A5EFAE, 0x00A5EE25, 0x00A5EE46, 
						  0x00A5EE73, 0x00A5EEA0, 0x00A5EECD, 0x00A5F15E, 0x00A5F173, 0x00A5F19D, 0x00A5F21D, 0x00A5F225, 0x00A5F2F7, 0x00A5F376, 
						  0x00A5F3CC, 0x00A5F445, 0x00A5F490, 0x00A5F57E, 0x00A5F593, 0x00A5F5BD, 0x00A5F63D, 0x00A5F645, 0x00A5F6B7, 0x00A5F6E7, 
						  0x00A5F717, 0x00A5F8CF, 0x00A5F8DB, 0x00A5FA27, 0x00A5FB9D, 0x00A5FBB9, 0x00A5FC17, 0x00A5FC33, 0x00A5FC91, 0x00A5FCAD, 
						  0x00A5FD0B, 0x00A5FD27, 0x00A5FAA9, 0x00A5FAC5, 0x00A5FB23, 0x00A5FB3F, 0x00A5FDA5, 0x00A5FDC6, 0x00A5FE20, 0x00A5FEC5, 
						  0x00A5FF10, 0x00A5FF95, 0x00A5FFE0, 0x00A60065, 0x00A60086, 0x00A600E0, 0x00A602D2, 0x00A602E7, 0x00A60311, 0x00A6038D, 
						  0x00A60395, 0x00A605E7, 0x00A60666, 0x00A606BC, 0x00A60735, 0x00A60756, 0x00A60783, 0x00A607B0, 0x00A60800, 0x00A608D5, 
						  0x00A608F6, 0x00A60950, 0x00A60ADE, 0x00A60AF3, 0x00A60B1D, 0x00A60B9D, 0x00A60BA5, 0x00A60CC7, 0x00A60DF2, 0x00A60E48, 
						  0x00A60E9E, 0x00A60EF4, 0x00A60D46, 0x00A60D9C, 0x00A60FA5, 0x00A60FF0, 0x00A61075, 0x00A610C0, 0x00A61145, 0x00A61166, 
						  0x00A611C0, 0x00A61265, 0x00A612B0, 0x00A614EE, 0x00A61503, 0x00A6152D, 0x00A615AD, 0x00A615B5, 0x00A61667, 0x00A616E6, 
						  0x00A6173C, 0x00A617B5, 0x00A617D6, 0x00A61830, 0x00A6193E, 0x00A61953, 0x00A6197D, 0x00A619FD, 0x00A61A05, 0x00A61BF7, 
						  0x00A61D22, 0x00A61D78, 0x00A61DCE, 0x00A61E24, 0x00A61C76, 0x00A61CCC, 0x00A61E95, 0x00A61EE0, 0x00A61F65, 0x00A61F86, 
						  0x00A61FE0, 0x00A62162, 0x00A62177, 0x00A621A1, 0x00A6221D, 0x00A62225, 0x00A62297, 0x00A622C7, 0x00A62304, 0x00A6230F, 
						  0x00A625B1, 0x00A625E7, 0x00A6249F, 0x00A624D5, 0x00A624E0, 0x00A62947, 0x00A62976, 0x00A62AA1, 0x00A62AC5, 0x00A62B03, 
						  0x00A62D8A, 0x00A62E2E, 0x00A62EB4, 0x00A62FFE, 0x00A63066, 0x00A6308E, 0x00A630FB, 0x00A63163, 0x00A6318B, 0x00A631F8, 
						  0x00A63260, 0x00A632C8, 0x00A63330, 0x00A63398, 0x00A63400, 0x00A63428, 0x00A63495, 0x00A62F4C, 0x00A634FD, 0x00A63565, 
						  0x00A635CD, 0x00A63635, 0x00A6365D, 0x00A636CA, 0x00A636F2, 0x00A6375F, 0x00A63787, 0x00A637F4, 0x00A6381C, 0x00A63889, 
						  0x00A638F1, 0x00A63959, 0x00A639C1, 0x00A62FA2, 0x00A63A29, 0x00A63A51, 0x00A63ABE, 0x00A63AE6, 0x00A63B53, 0x00A63B7B, 
						  0x00A63D0D, 0x00A63D1B, 0x00A63E3D, 0x00A63EB5, 0x00A63ED6, 0x00A63F30, 0x00A63FD5, 0x00A63FF6, 0x00A64023, 0x00A64070, 
						  0x00A64125, 0x00A64146, 0x00A641A0, 0x00A6422D, 0x00A64270, 0x00A642F5, 0x00A64340, 0x00A643C5, 0x00A643E6, 0x00A64413, 
						  0x00A64460, 0x00A64515, 0x00A64536, 0x00A64590, 0x00A64635, 0x00A64656, 0x00A64683, 0x00A646D0, 0x00A64785, 0x00A647A6, 
						  0x00A647D3, 0x00A64800, 0x00A64850, 0x00A64925, 0x00A64B6E, 0x00A64B83, 0x00A64BAD, 0x00A64C2D, 0x00A64C35, 0x00A64D4A, 
						  0x00A64EFF, 0x00A64F2D, 0x00A64DDA, 0x00A64DE9, 0x00A64DFA, 0x00A64E2B, 0x00A64E59, 0x00A65027, 0x00A650A6, 0x00A650FD, 
						  0x00A65140, 0x00A651F5, 0x00A652A7, 0x00A65326, 0x00A653A5, 0x00A653F0, 0x00A654DE, 0x00A654F3, 0x00A6551D, 0x00A6559D, 
						  0x00A655A5, 0x00A6577D, 0x00A65795, 0x00A657DB, 0x00A6581B, 0x00A65833, 0x00A65879, 0x00A658BE, 0x00A658CC, 0x00A65912, 
						  0x00A65952, 0x00A65960, 0x00A659A6, 0x00A6564A, 0x00A659E1, 0x00A659F3, 0x00A65A27, 0x00A65A39, 0x00A65A73, 0x00A6565A, 
						  0x00A6566A, 0x00A6567C, 0x00A6568E, 0x00A65B48, 0x00A65B80, 0x00A664BE, 0x00A6644C, 0x00A6656B, 0x00A66852, 0x00A6690F, 
						  0x00A669EA, 0x00A66ABF, 0x00A66B9A, 0x00A66C2D, 0x00A66C39, 0x00A66CD5, 0x00A66D15, 0x00A66D2F, 0x00A66D61, 0x00A66D87, 
						  0x00A66DF1, 0x00A66E31, 0x00A66E73, 0x00A66ED8, 0x00A66F07, 0x00A66EEF, 0x00A66F53, 0x00A66F2B, 0x00A66F7B, 0x00A67028, 
						  0x00A66FBC, 0x00A6711A, 0x00A671FD, 0x00A67370, 0x00A67419, 0x00A6762A, 0x00A68767, 0x00A687D8, 0x00A68849, 0x00A688BA, 
						  0x00A6892B, 0x00A6899C, 0x00A68A0D, 0x00A67852, 0x00A68A7E, 0x00A68AEF, 0x00A68B60, 0x00A68BD1, 0x00A68C42, 0x00A68CB3, 
						  0x00A68D24, 0x00A68D95, 0x00A68E06, 0x00A68E77, 0x00A68EE8, 0x00A68F59, 0x00A68FCA, 0x00A6903B, 0x00A690AC, 0x00A678BA, 
						  0x00A6911D, 0x00A6918E, 0x00A691FF, 0x00A69270, 0x00A692E1, 0x00A69352, 0x00A693C3, 0x00A69434, 0x00A694A5, 0x00A69516, 
						  0x00A67922, 0x00A6798A, 0x00A679F2, 0x00A67A5A, 0x00A67AC2, 0x00A67B2A, 0x00A67B92, 0x00A67BFA, 0x00A67C62, 0x00A67CCA, 
						  0x00A67D32, 0x00A67782, 0x00A67D9A, 0x00A67E02, 0x00A67E6A, 0x00A67ED2, 0x00A67F3A, 0x00A67FA2, 0x00A6800A, 0x00A68032, 
						  0x00A6809F, 0x00A68107, 0x00A6816F, 0x00A681D7, 0x00A6823F, 0x00A682A7, 0x00A6830F, 0x00A68377, 0x00A677EA, 0x00A683DF, 
						  0x00A68450, 0x00A684C1, 0x00A68532, 0x00A685A3, 0x00A68614, 0x00A68685, 0x00A686F6, 0x00A69578, 0x00A6959D, 0x00A69699, 
						  0x00A696F7, 0x00A6971D, 0x00A6973D, 0x00A69845, 0x00A69866, 0x00A698C0, 0x00A69965, 0x00A69986, 0x00A699B3, 0x00A69A00, 
						  0x00A69AAD, 0x00A69AF0, 0x00A69C8D, 0x00A69CD0, 0x00A69DC5, 0x00A69DE6, 0x00A69E40, 0x00A69FBA, 0x00A69FE7, 0x00A6A014, 
						  0x00A6A041, 0x00A6A06E, 0x00A69EE5, 0x00A69F06, 0x00A69F33, 0x00A69F60, 0x00A69F8D, 0x00A6A0C0, 0x00A6A255, 0x00A6A276, 
						  0x00A6A2A3, 0x00A6A2D0, 0x00A6A2FD, 0x00A6A350, 0x00A6A445, 0x00A6A466, 0x00A6A4C0, 0x00A6A63A, 0x00A6A565, 0x00A6A586, 
						  0x00A6A5B3, 0x00A6A5E0, 0x00A6A60D, 0x00A6A690, 0x00A6A88A, 0x00A6A7B5, 0x00A6A7D6, 0x00A6A803, 0x00A6A830, 0x00A6A85D, 
						  0x00A6A8E0, 0x00A6AA05, 0x00A6AA26, 0x00A6AA53, 0x00A6AA80, 0x00A6AAAD, 0x00A6AB00, 0x00A6AC05, 0x00A6AC26, 0x00A6AC80, 
						  0x00A6AD25, 0x00A6AD46, 0x00A6ADA0, 0x00A6AE45, 0x00A6AE66, 0x00A6AEC0, 0x00A6AF4D, 0x00A6AFC5, 0x00A6B010, 0x00A6B095, 
						  0x00A6B0E0, 0x00A6B165, 0x00A6B1B0, 0x00A6B235, 0x00A6B256, 0x00A6B283, 0x00A6B2D0, 0x00A6B385, 0x00A6B3A6, 0x00A6B400, 
						  0x00A6B57A, 0x00A6B4A5, 0x00A6B4C6, 0x00A6B4F3, 0x00A6B520, 0x00A6B54D, 0x00A6B5D0, 0x00A6B6E5, 0x00A6B706, 0x00A6B760, 
						  0x00A6B805, 0x00A6B826, 0x00A6B853, 0x00A6B880, 0x00A6B8D0, 0x00A6B9A5, 0x00A6B9C6, 0x00A6BA20, 0x00A6BAC5, 0x00A6BAE6, 
						  0x00A6BB13, 0x00A6BB40, 0x00A6BB90, 0x00A6BC75, 0x00A6BC96, 0x00A6BCC3, 0x00A6BCF0, 0x00A6BD40, 0x00A6BE25, 0x00A6BE46, 
						  0x00A6BEA0, 0x00A6BF45, 0x00A6BF66, 0x00A6BFC0, 0x00A6C13A, 0x00A6C167, 0x00A6C194, 0x00A6C1C1, 0x00A6C1EE, 0x00A6C21B, 
						  0x00A6C065, 0x00A6C086, 0x00A6C0B3, 0x00A6C0E0, 0x00A6C10D, 0x00A6C2A5, 0x00A6C2C6, 0x00A6C2F3, 0x00A6C320, 0x00A6C34D, 
						  0x00A6CAFE, 0x00A6CB13, 0x00A6CB3D, 0x00A6CBBD, 0x00A6CBC5, 0x00A6D0ED, 0x00A6D3F7, 0x00A6D522, 0x00A6D578, 0x00A6D476, 
						  0x00A6D4CC, 0x00A6D625, 0x00A6D670, 0x00A6D6F5, 0x00A6D716, 0x00A6D770, 0x00A6D815, 0x00A6D860, 0x00A6D8E5, 0x00A6D930, 
						  0x00A6DB6E, 0x00A6DB83, 0x00A6DBAD, 0x00A6DC2D, 0x00A6DC35, 0x00A6DCA7, 0x00A6DE32, 0x00A6DE88, 0x00A6DEDE, 0x00A6DF34, 
						  0x00A6DD86, 0x00A6DDDC, 0x00A6E035, 0x00A6E056, 0x00A6E0B0, 0x00A6E155, 0x00A6E176, 0x00A6E1D0, 0x00A6E275, 0x00A6E2C0, 
						  0x00A6E345, 0x00A6E366, 0x00A6E3C0, 0x00A6E465, 0x00A6E4B0, 0x00A6EBB0, 0x00A6EBCC, 0x00A6EC2A, 0x00A6EC46, 0x00A6ECA4, 
						  0x00A6ECC0, 0x00A6ED1E, 0x00A6ED3A, 0x00A6ED9E, 0x00A6EDC6, 0x00A6EE33, 0x00A6EE5B, 0x00A6EEC8, 0x00A6EEF0, 0x00A6EF5D, 
						  0x00A6EF85, 0x00A6EFF2, 0x00A6F01A, 0x00A6EABC, 0x00A6F087, 0x00A6F0AF, 0x00A6F11C, 0x00A6F144, 0x00A6EAD8, 0x00A6EB36, 
						  0x00A6EB52, 0x00A6F205, 0x00A6F226, 0x00A6F280, 0x00A6F325, 0x00A6F346, 0x00A6F3A0, 0x00A6F445, 0x00A6F466, 0x00A6F493, 
						  0x00A6F4E0, 0x00A6F788, 0x00A6F796, 0x00A6F7B7, 0x00A6F7C5, 0x00A6F7DB, 0x00A6F818, 0x00A6F687, 0x00A6F69E, 0x00A6F6C8, 
						  0x00A6F732, 0x00A6FBC7, 0x00A6FC49, 0x00A6FC65, 0x00A6FCCD, 0x00A6FD10, 0x00A6FDC5, 0x00A6FDE6, 0x00A6FE13, 0x00A6FEFE, 
						  0x00A6FF13, 0x00A6FF3D, 0x00A6FFBD, 0x00A6FFC5, 0x00A70902, 0x00A7090B, 0x00A70914, 0x00A7091D, 0x00A70952, 0x00A70A90, 
						  0x00A70A84, 0x00A70EA7, 0x00A7101D, 0x00A70F29, 0x00A70F45, 0x00A70FA3, 0x00A70FBF, 0x00A7107D, 0x00A710C0, 0x00A7115D, 
						  0x00A711A0, 0x00A71275, 0x00A712C0, 0x00A71345, 0x00A71366, 0x00A71393, 0x00A71415, 0x00A71436, 0x00A71463, 0x00A71490, 
						  0x00A71797, 0x00A717C7, 0x00A71917, 0x00A71996, 0x00A719EC, 0x00A71A65, 0x00A71A86, 0x00A71AB3, 0x00A71B00, 0x00A71BC5, 
						  0x00A71BE6, 0x00A71C40, 0x00A71DBE, 0x00A71DD3, 0x00A71DFD, 0x00A71E7D, 0x00A71E85, 0x00A71F23, 0x00A71F74, 0x00A71F93, 
						  0x00A7211D, 0x00A720FA, 0x00A72149, 0x00A72179, 0x00A721A9, 0x00A721DC, 0x00A721FC, 0x00A7221C, 0x00A7223C, 0x00A7225C, 
						  0x00A72279, 0x00A722F9, 0x00A7235A, 0x00A7236A, 0x00A72373, 0x00A72382, 0x00A7239C, 0x00A723A5, 0x00A723AE, 0x00A725A9, 
						  0x00A725D9, 0x00A726C7, 0x00A727F8, 0x00A7284E, 0x00A728B3, 0x00A7291B, 0x00A72983, 0x00A729EB, 0x00A72A53, 0x00A72ABB, 
						  0x00A72B23, 0x00A72B8B, 0x00A72BF3, 0x00A72C5B, 0x00A7274C, 0x00A72CC3, 0x00A72D2B, 0x00A72D93, 0x00A72DFB, 0x00A72E63, 
						  0x00A72ECB, 0x00A72F33, 0x00A72F9B, 0x00A73003, 0x00A7306B, 0x00A727A2, 0x00A73175, 0x00A731C0, 0x00A73245, 0x00A73290, 
						  0x00A73315, 0x00A73336, 0x00A73390, 0x00A73435, 0x00A73456, 0x00A734B0, 0x00A73555, 0x00A73576, 0x00A735A3, 0x00A735F0, 
						  0x00A736A5, 0x00A736C6, 0x00A736F3, 0x00A73740, 0x00A737F5, 0x00A73816, 0x00A73843, 0x00A73890, 0x00A73945, 0x00A73990, 
						  0x00A739FD, 0x00A73A40, 0x00A73AF5, 0x00A73B16, 0x00A73B43, 0x00A73B70, 0x00A73BC0, 0x00A73C95, 0x00A73CB6, 0x00A73D10, 
						  0x00A73DB5, 0x00A73DD6, 0x00A73E30, 0x00A73ED5, 0x00A73EF6, 0x00A73F23, 0x00A745F7, 0x00A74E87, 0x00A74FB8, 0x00A7500E, 
						  0x00A75064, 0x00A750C9, 0x00A75131, 0x00A75199, 0x00A75201, 0x00A75269, 0x00A752D1, 0x00A75339, 0x00A753A1, 0x00A75409, 
						  0x00A74F0C, 0x00A75471, 0x00A75499, 0x00A75506, 0x00A7552E, 0x00A7559B, 0x00A75603, 0x00A7566B, 0x00A756D3, 0x00A7573B, 
						  0x00A757A3, 0x00A74F62, 0x00A75855, 0x00A758D5, 0x00A75920, 0x00A759A5, 0x00A759C6, 0x00A75A20, 0x00A75AC5, 0x00A75B10, 
						  0x00A75B95, 0x00A75BB6, 0x00A75BE3, 0x00A75C30, 0x00A75CE5, 0x00A75D06, 0x00A75D33, 0x00A75D80, 0x00A75E35, 0x00A75E56, 
						  0x00A75EB0, 0x00A75F55, 0x00A75FA0, 0x00A76025, 0x00A76046, 0x00A76073, 0x00A760C0, 0x00A76447, 0x00A764B7, 0x00A76536, 
						  0x00A76552, 0x00A765B0, 0x00A765CC, 0x00A76655, 0x00A766A0, 0x00A76725, 0x00A76746, 0x00A767A0, 0x00A7691E, 0x00A76933, 
						  0x00A7695D, 0x00A769DD, 0x00A769E5, 0x00A76A57, 0x00A76B17, 0x00A76C42, 0x00A76C98, 0x00A76CEE, 0x00A76B96, 0x00A76BEC, 
						  0x00A76D85, 0x00A76DA6, 0x00A76E00, 0x00A76EA5, 0x00A76EC6, 0x00A76EF3, 0x00A76F40, 0x00A77005, 0x00A77050, 0x00A772DE, 
						  0x00A772F3, 0x00A7731D, 0x00A7739D, 0x00A773A5, 0x00A77417, 0x00A774C7, 0x00A77546, 0x00A7759C, 0x00A77625, 0x00A77646, 
						  0x00A77673, 0x00A776C0, 0x00A77775, 0x00A777C0, 0x00A7791E, 0x00A77933, 0x00A7795D, 0x00A779DD, 0x00A779E5, 0x00A77AE7, 
						  0x00A77B66, 0x00A77BBC, 0x00A77C35, 0x00A77C56, 0x00A77C83, 0x00A77CB0, 0x00A77D00, 0x00A77DD5, 0x00A77E20, 0x00A77F7E, 
						  0x00A77F93, 0x00A77FBD, 0x00A7803D, 0x00A78045, 0x00A78137, 0x00A781B6, 0x00A7820C, 0x00A78285, 0x00A782A6, 0x00A782D3, 
						  0x00A78320, 0x00A783D5, 0x00A78420, 0x00A7857E, 0x00A78593, 0x00A785BD, 0x00A7863D, 0x00A78645, 0x00A78727, 0x00A78855, 
						  0x00A788AB, 0x00A78901, 0x00A78957, 0x00A789AD, 0x00A78A03, 0x00A78A59, 0x00A78AB5, 0x00A78B1D, 0x00A78B85, 0x00A78BED, 
						  0x00A787A9, 0x00A787FF, 0x00A78D55, 0x00A78DA0, 0x00A78E25, 0x00A78E70, 0x00A78EF5, 0x00A78F40, 0x00A78FC5, 0x00A79010, 
						  0x00A79095, 0x00A790E0, 0x00A79165, 0x00A79186, 0x00A791E0, 0x00A79285, 0x00A792A6, 0x00A792D3, 0x00A79320, 0x00A7978E, 
						  0x00A797A3, 0x00A797CD, 0x00A7984D, 0x00A79855, 0x00A79934, 0x00A79A84, 0x00A79B7C, 0x00A79B8F, 0x00A79C5C, 0x00A79C6F, 
						  0x00A79D97, 0x00A79DC7, 0x00A79DF7, 0x00A7A017, 0x00A7A148, 0x00A7A19E, 0x00A7A1F4, 0x00A7A24A, 0x00A7A2A0, 0x00A7A2F6, 
						  0x00A7A34C, 0x00A7A3A2, 0x00A7A3FE, 0x00A7A09C, 0x00A7A0F2, 0x00A7A4F5, 0x00A7A540, 0x00A7A5C5, 0x00A7A610, 0x00A7A695, 
						  0x00A7A6E0, 0x00A7A765, 0x00A7A7B0, 0x00A7A835, 0x00A7A856, 0x00A7A8B0, 0x00A7A955, 0x00A7A976, 0x00A7A9D0, 0x00A7AB4A, 
						  0x00A7AB77, 0x00A7AA75, 0x00A7AA96, 0x00A7AAC3, 0x00A7AAF0, 0x00A7AB1D, 0x00A7ABD0, 0x00A7AD05, 0x00A7AD26, 0x00A7AD53, 
						  0x00A7ADA0, 0x00A7AE65, 0x00A7AE86, 0x00A7AEE0, 0x00A7AF85, 0x00A7AFA6, 0x00A7B000, 0x00A7B4FE, 0x00A7B513, 0x00A7B53D, 
						  0x00A7B5BD, 0x00A7B5C5, 0x00A7B637, 0x00A7B667, 0x00A7B697, 0x00A7B6C7, 0x00A7BABB, 0x00A7BAC7, 0x00A7B969, 0x00A7B979, 
						  0x00A7B9C7, 0x00A7B9D5, 0x00A7BC56, 0x00A7BC83, 0x00A7BB6B, 0x00A7BBBC, 0x00A7BBE7, 0x00A7BC05, 0x00A7BC1B, 0x00A7BC40, 
						  0x00A7C107, 0x00A7C113, 0x00A7C12D, 0x00A7C2E5, 0x00A7C444, 0x00A7C238, 0x00A7C244, 0x00A7C270, 0x00A7C571, 0x00A7C594, 
						  0x00A7C5CA, 0x00A7C5F2, 0x00A7C602, 0x00A7C619, 0x00A7C4AE, 0x00A7C4FA, 0x00A7C508, 0x00A7C559, 0x00A7CB1F, 0x00A7CB4B, 
						  0x00A7CC1F, 0x00A7CC61, 0x00A7CC78, 0x00A7D3FF, 0x00A7D429, 0x00A7D441, 0x00A7D50F, 0x00A7D546, 0x00A7D55D, 0x00A7D56D, 
						  0x00A7D581, 0x00A7D7EF, 0x00A7D82D, 0x00A7D83D, 0x00A7D84D, 0x00A7D861, 0x00A7D9B2, 0x00A7D9CF, 0x00A7D8C6, 0x00A7D90E, 
						  0x00A7D952, 0x00A7D98F, 0x00A7DBCB, 0x00A7DBDB, 0x00A7DC36, 0x00A7DC4C, 0x00A7DC6C, 0x00A7DC83, 0x00A7DF44, 0x00A7DF52, 
						  0x00A7DF68, 0x00A7DE4B, 0x00A7DE5B, 0x00A7E3AE, 0x00A7E3CB, 0x00A7E3D7, 0x00A7E3E7, 0x00A7E3FA, 0x00A7E409, 0x00A7E425, 
						  0x00A7E45C, 0x00A7E47D, 0x00A7E24A, 0x00A7E4C8, 0x00A7E4E2, 0x00A7E25A, 0x00A7E27E, 0x00A7E2D1, 0x00A7E2EA, 0x00A7E30A, 
						  0x00A7E31A, 0x00A7EB3A, 0x00A7EB46, 0x00A7EB52, 0x00A7EB5B, 0x00A7EB71, 0x00A7EC17, 0x00A7F536, 0x00A7F993, 0x00A7FD95, 
						  0x00A7FE38, 0x00A7FED8, 0x00A81067, 0x00A812D3, 0x00A812E3, 0x00A81374, 0x00A81386, 0x00A813C5, 0x00A813D5, 0x00A81429, 
						  0x00A81451, 0x00A81465, 0x00A8148F, 0x00A814A2, 0x00A814BD, 0x00A811A9, 0x00A811E7, 0x00A811F9, 0x00A815E5, 0x00A81613, 
						  0x00A81639, 0x00A81649, 0x00A815CD, 0x00A8196D, 0x00A818FC, 0x00A81A56, 0x00A81E7A, 0x00A81EDD, 0x00A81EE9, 0x00A82201, 
						  0x00A82277, 0x00A82BC9, 0x00A82B2D, 0x00A83032, 0x00A830D1, 0x00A83174, 0x00A8347C, 0x00A8360B, 0x00A8361B, 0x00A8363F, 
						  0x00A8365E, 0x00A8366F, 0x00A83699, 0x00A836A7, 0x00A836C5, 0x00A83AEF, 0x00A83D8B, 0x00A83DA1, 0x00A83DB5, 0x00A83E4F, 
						  0x00A84102, 0x00A84143, 0x00A8404F, 0x00A84387, 0x00A844B0, 0x00A853BB, 0x00A8542C, 0x00A8549D, 0x00A8550E, 0x00A8557F, 
						  0x00A855F0, 0x00A844D8, 0x00A85661, 0x00A856D2, 0x00A85743, 0x00A857B4, 0x00A85825, 0x00A85896, 0x00A85907, 0x00A85978, 
						  0x00A859E9, 0x00A85A5A, 0x00A85ACB, 0x00A85B3C, 0x00A85BAD, 0x00A85C1E, 0x00A85C8F, 0x00A84545, 0x00A85D00, 0x00A85D71, 
						  0x00A85DE2, 0x00A85E53, 0x00A85EC4, 0x00A85F35, 0x00A85FA6, 0x00A86017, 0x00A86088, 0x00A860F9, 0x00A8616A, 0x00A861DB, 
						  0x00A8624C, 0x00A862BD, 0x00A8632E, 0x00A845AD, 0x00A8639F, 0x00A86410, 0x00A86481, 0x00A864F2, 0x00A86563, 0x00A865D4, 
						  0x00A86645, 0x00A866B6, 0x00A86727, 0x00A86798, 0x00A86809, 0x00A8687A, 0x00A868EB, 0x00A8695C, 0x00A869CD, 0x00A84615, 
						  0x00A86A3E, 0x00A86AAF, 0x00A843D7, 0x00A86B20, 0x00A86B91, 0x00A86BB9, 0x00A86C2F, 0x00A8463D, 0x00A86CA0, 0x00A86D11, 
						  0x00A86D39, 0x00A86DAF, 0x00A86E20, 0x00A86E91, 0x00A86F02, 0x00A86F73, 0x00A86FE4, 0x00A87055, 0x00A870C6, 0x00A87137, 
						  0x00A871A8, 0x00A87219, 0x00A8728A, 0x00A872FB, 0x00A846AA, 0x00A8736C, 0x00A873DD, 0x00A8744E, 0x00A874BF, 0x00A87530, 
						  0x00A875A1, 0x00A87612, 0x00A87683, 0x00A876F4, 0x00A87765, 0x00A84712, 0x00A8477A, 0x00A847E2, 0x00A8484A, 0x00A848B2, 
						  0x00A8491A, 0x00A84982, 0x00A849EA, 0x00A84A52, 0x00A84A7A, 0x00A84AE7, 0x00A84B0F, 0x00A84B7C, 0x00A84BE4, 0x00A84C0C, 
						  0x00A84C79, 0x00A84CE1, 0x00A84D09, 0x00A84448, 0x00A84D76, 0x00A84DDE, 0x00A84E46, 0x00A84EAE, 0x00A84F16, 0x00A84F7E, 
						  0x00A84FE6, 0x00A8504E, 0x00A850B6, 0x00A8511E, 0x00A85186, 0x00A851F7, 0x00A85268, 0x00A852D9, 0x00A8534A, 0x00A87BD5, 
						  0x00A87BF6, 0x00A87C23, 0x00A87C70, 0x00A87D25, 0x00A87D46, 0x00A87DA0, 0x00A87E45, 0x00A87E66, 0x00A87EC0, 0x00A87F65, 
						  0x00A87F86, 0x00A87FE0, 0x00A8806D, 0x00A880B0, 0x00A88185, 0x00A881A6, 0x00A88200, 0x00A8828D, 0x00A882D0, 0x00A883D5, 
						  0x00A883F6, 0x00A88450, 0x00A884F5, 0x00A88540, 0x00A885C5, 0x00A88610, 0x00A88695, 0x00A886B6, 0x00A886E3, 0x00A88730, 
						  0x00A887CD, 0x00A88810, 0x00A8889D, 0x00A888FD, 0x00A88975, 0x00A88996, 0x00A889F0, 0x00A88A7D, 0x00A88AC0, 0x00A88B75, 
						  0x00A88BC0, 0x00A88C45, 0x00A88C90, 0x00A88D15, 0x00A88D36, 0x00A88D90, 0x00A88E35, 0x00A88E56, 0x00A88EB0, 0x00A88F55, 
						  0x00A88F76, 0x00A88FD0, 0x00A89075, 0x00A890C0, 0x00A89145, 0x00A89190, 0x00A89215, 0x00A89260, 0x00A892E5, 0x00A89330, 
						  0x00A893B5, 0x00A893D6, 0x00A89430, 0x00A894D5, 0x00A89520, 0x00A895A5, 0x00A895C6, 0x00A89620, 0x00A896C5, 0x00A89710, 
						  0x00A89795, 0x00A897B6, 0x00A89810, 0x00A898B5, 0x00A898D6, 0x00A89930, 0x00A899D5, 0x00A89A55, 0x00A89AA0, 0x00A89B25, 
						  0x00A89B70, 0x00A89BF5, 0x00A89C40, 0x00A89CC5, 0x00A89CE6, 0x00A89D40, 0x00A89DE5, 0x00A89E06, 0x00A89E60, 0x00A89F05, 
						  0x00A89F26, 0x00A89F53, 0x00A89FA0, 0x00A8A055, 0x00A8A076, 0x00A8A0A3, 0x00A8A0F0, 0x00A8A1B5, 0x00A8A1D6, 0x00A8A203, 
						  0x00A8A250, 0x00A8A2ED, 0x00A8A330, 0x00A8A42D, 0x00A8A48D, 0x00A8A4D0, 0x00A8A585, 0x00A8A5A6, 0x00A8A5D3, 0x00A8A600, 
						  0x00A8A62D, 0x00A8A680, 0x00A8A775, 0x00A8A796, 0x00A8A7C3, 0x00A8A7F0, 0x00A8A840, 0x00A8A8FD, 0x00A8A940, 0x00A8A9F5, 
						  0x00A8AA16, 0x00A8AA43, 0x00A8AA70, 0x00A8AAC0, 0x00A8AC6A, 0x00A8AC97, 0x00A8ACC4, 0x00A8ACF1, 0x00A8AB95, 0x00A8ABB6, 
						  0x00A8ABE3, 0x00A8AC10, 0x00A8AC3D, 0x00A8AD40, 0x00A8AEB5, 0x00A8AED6, 0x00A8AF03, 0x00A8AF30, 0x00A8AF80, 0x00A8B03D, 
						  0x00A8B080, 0x00A8B195, 0x00A8B1B6, 0x00A8B1E3, 0x00A8B230, 0x00A8B3BA, 0x00A8B3E7, 0x00A8B414, 0x00A8B441, 0x00A8B46E, 
						  0x00A8B49B, 0x00A8B4C8, 0x00A8B2E5, 0x00A8B306, 0x00A8B333, 0x00A8B360, 0x00A8B38D, 0x00A8B520, 0x00A8B6F5, 0x00A8B716, 
						  0x00A8B743, 0x00A8B790, 0x00A8B855, 0x00A8B876, 0x00A8B8A3, 0x00A8B8D0, 0x00A8B920, 0x00A8B9F5, 0x00A8BA16, 0x00A8BA43, 
						  0x00A8BA70, 0x00A8BA9D, 0x00A8BAF0, 0x00A8BBE5, 0x00A8BC06, 0x00A8BC33, 0x00A8BC60, 0x00A8BCB0, 0x00A8BD85, 0x00A8BDA6, 
						  0x00A8BE00, 0x00A8BEA5, 0x00A8BEC6, 0x00A8BF20, 0x00A8BFAD, 0x00A8BFF0, 0x00A8C0D5, 0x00A8C0F6, 0x00A8C123, 0x00A8C170, 
						  0x00A8C225, 0x00A8C246, 0x00A8C273, 0x00A8C2C0, 0x00A8C375, 0x00A8C396, 0x00A8C3C3, 0x00A8C410, 0x00A8C4D5, 0x00A8C4F6, 
						  0x00A8C550, 0x00A8C5F5, 0x00A8C616, 0x00A8C670, 0x00A8C6FD, 0x00A8C84A, 0x00A8C877, 0x00A8C8A4, 0x00A8C8D1, 0x00A8C775, 
						  0x00A8C796, 0x00A8C7C3, 0x00A8C7F0, 0x00A8C81D, 0x00A8C920, 0x00A8CB7A, 0x00A8CBA7, 0x00A8CBD4, 0x00A8CC01, 0x00A8CC2E, 
						  0x00A8CAA5, 0x00A8CAC6, 0x00A8CAF3, 0x00A8CB20, 0x00A8CB4D, 0x00A8CC80, 0x00A8CEFA, 0x00A8CE25, 0x00A8CE46, 0x00A8CE73, 
						  0x00A8CEA0, 0x00A8CECD, 0x00A8CF50, 0x00A8D04D, 0x00A8D195, 0x00A8D1B6, 0x00A8D1E3, 0x00A8D210, 0x00A8D295, 0x00A8D2B6, 
						  0x00A8D2E3, 0x00A8D310, 0x00A8D33D, 0x00A8D3C5, 0x00A8D3E6, 0x00A8D475, 0x00A8D496, 0x00A8D4C3, 0x00A8D61A, 0x00A8D545, 
						  0x00A8D566, 0x00A8D593, 0x00A8D5C0, 0x00A8D5ED, 0x00A8D6A5, 0x00A8D6C6, 0x00A8D6F3, 0x00A8D775, 0x00A8D796, 0x00A8D7C3, 
						  0x00A8D91A, 0x00A8D845, 0x00A8D866, 0x00A8D893, 0x00A8D8C0, 0x00A8D8ED, 0x00A8D9A5, 0x00A8D9C6, 0x00A8D9F3, 0x00A8DA20, 
						  0x00A8F49E, 0x00A8F4B3, 0x00A8F4DD, 0x00A8F54E, 0x00A8F563, 0x00A8F58D, 0x00A8F5FE, 0x00A8F613, 0x00A8F63D, 0x00A8F83D, 
						  0x00A8F845, 0x00A8F8FD, 0x00A8F905, 0x00A8F9BD, 0x00A8F9C5, 0x00A8FF44, 0x00A90094, 0x00A901E4, 0x00A90334, 0x00A90484, 
						  0x00A9073C, 0x00A9074F, 0x00A9081C, 0x00A9082F, 0x00A908FC, 0x00A9090F, 0x00A909DC, 0x00A909EF, 0x00A90ABC, 0x00A90ACF, 
						  0x00A920A7, 0x00A92167, 0x00A921E6, 0x00A92255, 0x00A92276, 0x00A922A3, 0x00A922F0, 0x00A924CE, 0x00A924E3, 0x00A9250D, 
						  0x00A9257E, 0x00A92593, 0x00A925BD, 0x00A9263D, 0x00A92645, 0x00A926FD, 0x00A92705, 0x00A927A7, 0x00A92826, 0x00A9287C, 
						  0x00A92905, 0x00A92950, 0x00A929D5, 0x00A92A20, 0x00A92B7E, 0x00A92B93, 0x00A92BBD, 0x00A92C3D, 0x00A92C45, 0x00A93377, 
						  0x00A934AD, 0x00A93503, 0x00A93568, 0x00A935D0, 0x00A93638, 0x00A936A0, 0x00A93708, 0x00A93770, 0x00A937D8, 0x00A93840, 
						  0x00A938A8, 0x00A93910, 0x00A93978, 0x00A93401, 0x00A939E0, 0x00A93A48, 0x00A93AB0, 0x00A93B18, 0x00A93B80, 0x00A93BE8, 
						  0x00A93C50, 0x00A93CB8, 0x00A93D20, 0x00A93457, 0x00A93F75, 0x00A93FC0, 0x00A94045, 0x00A94066, 0x00A940C0, 0x00A94165, 
						  0x00A941B0, 0x00A94235, 0x00A94280, 0x00A94305, 0x00A94326, 0x00A94380, 0x00A94425, 0x00A94446, 0x00A944A0, 0x00A9452D, 
						  0x00A945A5, 0x00A945C6, 0x00A945F3, 0x00A94640, 0x00A946F5, 0x00A94716, 0x00A94743, 0x00A94770, 0x00A947C0, 0x00A9487D, 
						  0x00A948F5, 0x00A94916, 0x00A94970, 0x00A94FD7, 0x00A950CC, 0x00A950DF, 0x00A951A7, 0x00A951D7, 0x00A95207, 0x00A952DC, 
						  0x00A953F2, 0x00A95577, 0x00A956AA, 0x00A95700, 0x00A955FE, 0x00A95654, 0x00A957C5, 0x00A957E6, 0x00A95840, 0x00A958CD, 
						  0x00A95910, 0x00A959B5, 0x00A959D6, 0x00A95A03, 0x00A95A50, 0x00A95B75, 0x00A95B96, 0x00A95D8E, 0x00A95DA3, 0x00A95DCD, 
						  0x00A95E5D, 0x00A95E65, 0x00A95F27, 0x00A95FA6, 0x00A96015, 0x00A96060, 0x00A96147, 0x00A961C6, 0x00A96235, 0x00A96280, 
						  0x00A9636E, 0x00A96383, 0x00A963AD, 0x00A9642D, 0x00A96435, 0x00A96567, 0x00A96692, 0x00A966E8, 0x00A9673E, 0x00A96794, 
						  0x00A967EA, 0x00A96840, 0x00A96896, 0x00A965E6, 0x00A9663C, 0x00A969C5, 0x00A96A10, 0x00A96A95, 0x00A96AE0, 0x00A96B65, 
						  0x00A96B86, 0x00A96BE0, 0x00A96C85, 0x00A96CA6, 0x00A96D00, 0x00A96DA5, 0x00A96DC6, 0x00A96DF3, 0x00A96E40, 0x00A96EF5, 
						  0x00A96F40, 0x00A9724E, 0x00A97263, 0x00A9728D, 0x00A9732D, 0x00A97335, 0x00A97414, 0x00A9750C, 0x00A9751F, 0x00A975D7, 
						  0x00A97607, 0x00A978A5, 0x00A97887, 0x00A9790C, 0x00A9794A, 0x00A979CF, 0x00A97A0D, 0x00A97A8C, 0x00A97ACA, 0x00A97B3E, 
						  0x00A97B51, 0x00A97B8F, 0x00A97D68, 0x00A97DBE, 0x00A97E14, 0x00A97E6A, 0x00A97EC0, 0x00A97F16, 0x00A97F6C, 0x00A97FC8, 
						  0x00A98030, 0x00A98098, 0x00A98100, 0x00A97CBC, 0x00A97D12, 0x00A981DD, 0x00A98220, 0x00A982C5, 0x00A982E6, 0x00A98313, 
						  0x00A98360, 0x00A98415, 0x00A98436, 0x00A98463, 0x00A984B0, 0x00A9854D, 0x00A985C5, 0x00A985E6, 0x00BB9447, 0x00BB94A3, 
						  0x00BB962B, 0x00BB97FB, 0x00BB983F, 0x00BB9B78, 0x00BB9AD8, 0x00BB9B4D, 0x00BBA0E3, 0x00BBA234, 0x00BBA36D, 0x00BBA594, 
						  0x00BBA5C3, 0x00BBA63B, 0x00BBA64D, 0x00BBA529, 0x00BBA873, 0x00BBA88B, 0x00BBB47D, 0x00BBB5DB, 0x00BBB66D, 0x00BBB729, 
						  0x00BBB7BD, 0x00BBB859, 0x00BBB878, 0x00BBBC33, 0x00BBBC6A, 0x00BBBC74, 0x00BBBC7F, 0x00BBBC89, 0x00BBBCBF, 0x00BBBCC9, 
						  0x00BBBCD7, 0x00BBBDCF, 0x00BBBDDD, 0x00BBBEB3, 0x00BBBECC, 0x00BBBEF4, 0x00BBBF00, 0x00BBBF07, 0x00BBC06B, 0x00BBBFED, 
						  0x00BBC028, 0x00BBBF4F, 0x00BBC122, 0x00BBC13B, 0x00BBC196, 0x00BBD51E, 0x00BBD53A, 0x00BBD54B, 0x00BBD50D, 0x00BBD9DD, 
						  0x00BBDAB7, 0x00BBDD4D, 0x00BBE271, 0x00BBE2D4, 0x00BBE3BC, 0x00BBE1D0, 0x00BBE20A, 0x00BC160B, 0x00BC16FB, 0x00BC17EB, 
						  0x00BC18DB, 0x00BC19CB, 0x00BC1ABB, 0x00BC2EA4, 0x00BC2EAE, 0x00BC2EC3, 0x00BC2ECD, 0x00BC386D, 0x00BC38FD, 0x00BC3944, 
						  0x00BC398D, 0x00BC39CD, 0x00BC3A41, 0x00BC3A6D, 0x00BC3D22, 0x00BC3ED8, 0x00BC4288, 0x00BC4551, 0x00BC4EFF, 0x00BC4F0B, 
						  0x00BC5008, 0x00BC5017, 0x00BC5023, 0x00BC566C, 0x00BC567E, 0x00BC5690, 0x00BC56B3, 0x00BC5769, 0x00BC5778, 0x00BC5784, 
						  0x00BC5C52, 0x00BC6CBC, 0x00BC6CE9, 0x00BC6D1C, 0x00BC6D44, 0x00BC6D7C, 0x00BC6DA4, 0x00BC7219, 0x00BC723D, 0x00BC7297, 
						  0x00BC72AA, 0x00BC73BC, 0x00BC73DF, 0x00BC7478, 0x00BC7486, 0x00BC746A, 0x00BC74C8, 0x00BC74DC, 0x00BC74E6, 0x00BC74EF, 
						  0x00BC7504, 0x00BC7514, 0x00BC751E, 0x00BC753C, 0x00BC7546, 0x00BC7557, 0x00BC7561, 0x00BC7585, 0x00BC75AA, 0x00BC7706, 
						  0x00BC7744, 0x00BC77A2, 0x00BC77AC, 0x00BC77D0, 0x00BC77DA, 0x00BC785C, 0x00BC7885, 0x00BC788F, 0x00BC78C1, 0x00BC78CB, 
						  0x00BC78E7, 0x00BC78F1, 0x00BC7928, 0x00BC793F, 0x00BC79A6, 0x00BC79BE, 0x00BC79C8, 0x00BC79EF, 0x00BC79F9, 0x00BC7A19, 
						  0x00BC7A37, 0x00BC7654, 0x00BC7ACA, 0x00BC7AD1, 0x00BC7ADD, 0x00BC7AE4, 0x00BC7AFC, 0x00BC7B03, 0x00BC7CC0, 0x00BC7CC7, 
						  0x00BC7CD1, 0x00BC7D90, 0x00BC7D97, 0x00BC7DA1, 0x00BC7DED, 0x00BC7DF4, 0x00BC7E02, 0x00BC7E23, 0x00BC7E45, 0x00BC7E4C, 
						  0x00BC7E7B, 0x00BC7E82, 0x00BC7E8C, 0x00BC7EA1, 0x00BC7EA8, 0x00BC7EB6, 0x00BC7F2F, 0x00BC7F36, 0x00BC7F8E, 0x00BC7F95, 
						  0x00BC7C37, 0x00BC7C3E, 0x00BC7C4A, 0x00BC7C51, 0x00BC7C6D, 0x00BC7C74, 0x00BC7C82, 0x00BC8161, 0x00BC8168, 0x00BC8176, 
						  0x00BC818C, 0x00BC8193, 0x00BC809A, 0x00BC80A1, 0x00BC80C6, 0x00BC80CD, 0x00BC80DB, 0x00BC80F1, 0x00BC80F8, 0x00BC8142, 
						  0x00BC8149, 0x00BC836B, 0x00BC8372, 0x00BC837E, 0x00BC8385, 0x00BC83B0, 0x00BC83B7, 0x00BC83C1, 0x00BC83CA, 0x00BC83D1, 
						  0x00BC83E9, 0x00BC83F0, 0x00BC840A, 0x00BC842D, 0x00BC8434, 0x00BC8442, 0x00BC8458, 0x00BC8461, 0x00BC8468, 0x00BC8478, 
						  0x00BC847F, 0x00BC84BD, 0x00BC84C4, 0x00BC84E4, 0x00BC84EB, 0x00BC84F5, 0x00BC84FE, 0x00BC8505, 0x00BC851D, 0x00BC8524, 
						  0x00BC854D, 0x00BC8554, 0x00BC8562, 0x00BC8578, 0x00BC8581, 0x00BC8588, 0x00BC8598, 0x00BC859F, 0x00BC85E3, 0x00BC85EA, 
						  0x00BC85F4, 0x00BC85FD, 0x00BC8604, 0x00BC861C, 0x00BC8623, 0x00BC8642, 0x00BC8649, 0x00BC866D, 0x00BC8674, 0x00BC8682, 
						  0x00BC8698, 0x00BC86A1, 0x00BC86A8, 0x00BC86B8, 0x00BC86BF, 0x00BC86F8, 0x00BC86FF, 0x00BC8723, 0x00BC872A, 0x00BC8738, 
						  0x00BC874E, 0x00BC8757, 0x00BC875E, 0x00BC876E, 0x00BC8775, 0x00BC87C4, 0x00BC87CB, 0x00BC87D7, 0x00BC87DE, 0x00BC87F6, 
						  0x00BC87FD, 0x00BC880C, 0x00BC8829, 0x00BC8830, 0x00BC883A, 0x00BC8878, 0x00BC888B, 0x00BC8892, 0x00BC88A0, 0x00BC88B6, 
						  0x00BC88BD, 0x00BC88C7, 0x00BC88DC, 0x00BC832C, 0x00BC8333, 0x00BC896B, 0x00BC8991, 0x00BC89A9, 0x00BC89CB, 0x00BC89E3, 
						  0x00BC8CDA, 0x00BC8DD4, 0x00BC8E4A, 0x00BC8ED0, 0x00BC8EE3, 0x00BC8F09, 0x00BC8FF1, 0x00BC90A7, 0x00BC9414, 0x00BC965A, 
						  0x00BC969C, 0x00BC998A, 0x00BC9E71, 0x00BC9EA8, 0x00BC9F0E, 0x00BC9F18, 0x00BC9F38, 0x00BC9F56, 0x00BC9DB9, 0x00BC9E2E, 
						  0x00BC9E51, 0x00BC9E5B, 0x00BC9FA1, 0x00BCA0D1, 0x00BCA108, 0x00BCA16E, 0x00BCA178, 0x00BCA198, 0x00BCA1B6, 0x00BCA019, 
						  0x00BCA08E, 0x00BCA0B1, 0x00BCA0BB, 0x00BCA23E, 0x00BCA25A, 0x00BCA593, 0x00BCA5A1, 0x00BCB38F, 0x00BD2CE3, 0x00BD966F, 
						  0x00BD9659, 0x00BDACA0, 0x00BDACA7, 0x00BDACB7, 0x00BDACBE, 0x00BDACDA, 0x00BDACE1, 0x00BDB0B7, 0x00BDB0BE, 0x00BDB0D4, 
						  0x00BDB0DB, 0x00BDB0EA, 0x00BDB0F1, 0x00BDB107, 0x00BDB10E, 0x00BDB121, 0x00BDB128, 0x00BDB65A, 0x00BDB661, 0x00BDB675, 
						  0x00BDB693, 0x00BDB69A, 0x00BDB6C9, 0x00BDB6D0, 0x00BDB6E6, 0x00BDB709, 0x00BDB710, 0x00BDB566, 0x00BDB576, 0x00BDB5A5, 
						  0x00BDB5CB, 0x00BDB895, 0x00BDB89C, 0x00BDB8B0, 0x00BDB8CA, 0x00BDB8D1, 0x00BDB900, 0x00BDB907, 0x00BDB91D, 0x00BDB930, 
						  0x00BDB937, 0x00BDB7C5, 0x00BDB7D5, 0x00BDB804, 0x00BDB81A, 0x00BDBDBE, 0x00BDBDC5, 0x00BDBDD8, 0x00BDBDDF, 0x00BDBE18, 
						  0x00BDBE1F, 0x00BDCA0A, 0x00BDCA11, 0x00BDCA36, 0x00BDCA3D, 0x00BDEAC4, 0x00BDEA78, 0x00BDEEA2, 0x00BDEEB9, 0x00BDEEE3, 
						  0x00BDEEFC, 0x00BDEF53, 0x00BDEF71, 0x00BDEF8F, 0x00BDEFA5, 0x00BDEFBB, 0x00BDEFD5, 0x00BDEFEE, 0x00BDF01A, 0x00BDF046, 
						  0x00BDF074, 0x00BDEDA1, 0x00BDEDBF, 0x00BDEDD7, 0x00BDEE15, 0x00BDEE42, 0x00BDF159, 0x00BDF18B, 0x00BDF1A5, 0x00BDF1C9, 
						  0x00BDF239, 0x00BDF26B, 0x00BDF285, 0x00BDF2A9, 0x00BDFA93, 0x00BDFC80, 0x00BDFCAE, 0x00BE0450, 0x00BE0466, 0x00BE0490, 
						  0x00BE04A2, 0x00BE474B, 0x00BE4757, 0x00BE479B, 0x00BE47C1, 0x00BE480B, 0x00BE4817, 0x00BE486B, 0x00BE484A, 0x00BE878A, 
						  0x00BE87A0, 0x00BE909B, 0x00BE90A7, 0x00BE9131, 0x00BE9150, 0x00BE9162, 0x00BE911F, 0x00BE93B0, 0x00BE9488, 0x00BE94A6, 
						  0x00BE94E2, 0x00BE94F2, 0x00BE9511, 0x00BE958F, 0x00BE95C5, 0x00BE95FB, 0x00BE9631, 0x00BE9664, 0x00BE9675, 0x00BE9699, 
						  0x00BE96AD, 0x00BE96CB, 0x00BE96EE, 0x00BE97B5, 0x00BE97FE, 0x00BE9849, 0x00BE9896, 0x00BE98BB, 0x00BE98F1, 0x00BE9927, 
						  0x00BE995D, 0x00BE9990, 0x00BE999F, 0x00BE99B3, 0x00BE99D1, 0x00BE99F7, 0x00BE9A55, 0x00BE9A61, 0x00BE9A89, 0x00BE9B74, 
						  0x00BE9C19, 0x00BE9C20, 0x00BE9C4A, 0x00BE9C51, 0x00BE9C82, 0x00BE9D7B, 0x00BE9D8F, 0x00BE9E39, 0x00BE9E40, 0x00BE9E56, 
						  0x00BE9E5D, 0x00BE9E87, 0x00BE9E8E, 0x00BE9F90, 0x00BEA09D, 0x00BEA0A4, 0x00BEA27E, 0x00BEA285, 0x00BEA34B, 0x00BEA352, 
						  0x00BEA35E, 0x00BEA365, 0x00BEA432, 0x00BEA439, 0x00BEA462, 0x00BEA469, 0x00BEA527, 0x00BEA535, 0x00BEA5CD, 0x00BEA5DB, 
						  0x00BEA657, 0x00BEA724, 0x00BEA785, 0x00BEA78C, 0x00BEA7A3, 0x00BEA8FE, 0x00BEA905, 0x00BEAA1C, 0x00BEAA23, 0x00BEAAF7, 
						  0x00BEAB03, 0x00BEAB67, 0x00BEAB79, 0x00BEABAD, 0x00BEABD5, 0x00BEC87E, 0x00BEC895, 0x00BEC8A6, 0x00BEC86A, 0x00BED6E3, 
						  0x00BED6F9, 0x00BEDA2F, 0x00BEDA54, 0x00BEDAB3, 0x00BEDAC2, 0x00BEECAE, 0x00BEEE0E, 0x00BEEF18, 0x00BEEF2E, 0x00BEF6A0, 
						  0x00BEF6CC, 0x00BEF6E3, 0x00BEF6F8, 0x00BEF88F, 0x00BEF8E1, 0x00BEF90D, 0x00BEF9A1, 0x00BF1462, 0x00BF14B6, 0x00BF1CBA, 
						  0x00BF1D41, 0x00BF1D7A, 0x00BF1DDD, 0x00BF2050, 0x00BF20B2, 0x00BF227E, 0x00BF2290, 0x00BF2A09, /*skyui collide*/0x00BF2A84, 0x00BF2AB7, 
						  0x00BF2AE5, 0x00BF2C39, 0x00BF2C8E, 0x00BF2CA0, 0x00BF2CB4, 0x00BF2CE7, 0x00BF2D1E, 0x00BF2D32, 0x00BF29A1, 0x00BF29BF, 
						  0x00BF29D6, 0x00BF2E76, 0x00BF2F75, 0x00BF2FD0, 0x00BF3036, 0x00BF3896, 0x00BF38B7, 0x00BF388A, 0x00BF3A16, 0x00BF455C, 
						  0x00BF456E, 0x00BF45B0, 0x00BF459D, 0x00BF45EF, 0x00BF4618, 0x00BF466D, 0x00BF483C, 0x00BF4862, 0x00BF480F, 0x00BF49EC, 
						  0x00BF49FC, 0x00BF4A0B, 0x00BF4C16, 0x00BF63E2, 0x00BF645F, 0x00BF6472, 0x00BF64C1, 0x00BF64E5, 0x00BF653F, 0x00BF62DA, 
						  0x00BF6686, 0x00BF6AB6, 0x00BF6AD7, 0x00BF6AAA, 0x00BF72B4, 0x00BF72D2, 0x00BF7319, 0x00BF733F, 0x00BF734A, 0x00BF7BCC, 
						  0x00BF7BFF, 0x00BF8491, 0x00BF857C, 0x00BF859C, 0x00BF85B3, 0x00BF845A, 0x00BF847A, 0x00BF8BF3, 0x00BF8C37, 0x00BF900F, 
						  0x00BF901A, 0x00BF90A8, 0x00BF90B1, 0x00BF90CD, 0x00BF90E2, 0x00BF90EE, 0x00BF90FA, 0x00BF9115, 0x00BF9128, 0x00BF9133, 
						  0x00BF8F83, 0x00BF8F93, 0x00BF92AD, 0x00BF92D7, 0x00BF9304, 0x00BF924B, 0x00BF925F, 0x00BF9280, 0x00BF9DB3, 0x00BFA243, 
						  0x00BFA522, 0x00BFA53A, 0x00BFA64C, 0x00C5D208, 0x00C5D268, 0x00C6763A, 0x00C67651, 0x00C6774D, 0x00C67779, 0x00C678F3, 
						  0x00C6794C, 0x00C6795F, 0x00C67AD8, 0x00C6837A, 0x00C6838A, 0x00C683A0, 0x00C687E6, 0x00C6884E, 0x00C68A28, 0x00C69590, 
						  0x00C69599, 0x00C696A0, 0x00C696A9, 0x00C696EB, 0x00C696F4, 0x00C697DC, 0x00C697E5, 0x00C69827, 0x00C69830, 0x00C69B8E, 
						  0x00C69B98, 0x00C69C59, 0x00C69C62, 0x00C69AC6, 0x00C69AD0, 0x00C69B33, 0x00C69B4A, 0x00C69E1F, 0x00C69E29, 0x00C69EC3, 
						  0x00C69ECC, 0x00C69D56, 0x00C69D60, 0x00C69DC3, 0x00C69DDA, 0x00C69FCA, 0x00C69FD4, 0x00C6A2F3, 0x00C6A52A, 0x00C6A569, 
						  0x00C6A7D2, 0x00C6AA12, 0x00C6A913, 0x00C6A96A, 0x00C6A98E, 0x00C6A99C, 0x00C6A9C5, 0x00C6A9D3, 0x00C6A9EC, 0x00C6AD8E, 
						  0x00C6AE6C, 0x00C6B260, 0x00C6C794, 0x00C6C7B2, 0x00C6C7C0, 0x00C6C7E0, 0x00C6C7F9, 0x00C6C77C, 0x00C6CB18, 0x00C6CB32, 
						  0x00C6CB50, 0x00C6CB02, 0x00C6D41A, 0x00C6DB7B, 0x00C6DD8E, 0x00C7082F, 0x00C708E6, 0x00C70929, 0x00C70A2E, 0x00C70A1F, 
						  0x00C72B3E, 0x00C72C41, 0x00C72C6B, 0x00C72CF6, 0x00C72D1E, 0x00C72DB6, 0x00C72DDE, 0x00C72F56, 0x00C72FBB, 0x00C72E90, 
						  0x00C72EB2, 0x00C74277, 0x00C7428E, 0x00C742B6, 0x00C742D9, 0x00C74502, 0x00C7452E, 0x00C745AE, 0x00C745DA, 0x00C74484, 
						  0x00C7469F, 0x00C746CE, 0x00C746F7, 0x00C74712, 0x00C747E7, 0x00C75634, 0x00C75CC7, 0x00C77533, 0x00C77777, 0x00C77811, 
						  0x00C7782A, 0x00C77922, 0x00C77CBB, 0x00C77D4A, 0x00C7801E, 0x00C78227, 0x00C78290, 0x00C7839D, 0x00C783C1, 0x00C783DA, 
						  0x00C7841E, 0x00C7A9AE, 0x00C7B306, 0x00C7B853, 0x00C7B869, 0x00C7BBE1, 0x00C7BBE8, 0x00C7C3F8, 0x00C7C513, 0x00C7C5B6, 
						  0x00C7C5E8, 0x00C7C724, 0x00C7C68D, 0x00C7C694, 0x00C7C71D, 0x00C7F478, 0x00C7F898, 0x00C803F0, 0x00C80D11, 0x00C80D24, 
						  0x00C8149B, 0x00C814E4, 0x00C81505, 0x00C8154F, 0x00C815A5, 0x00C81625, 0x00C816A4, 0x00C818A6, 0x00C8443F, 0x00C84572, 
						  0x00C84584, 0x00C845CE, 0x00C845BF, 0x00C87341, 0x00C873A2, 0x00C873B3, 0x00C87416, 0x00C87438, 0x00C87730, 0x00C8773B, 
						  0x00C8823C, 0x00C884E7, 0x00C8925D, 0x00C89492, 0x00C894A5, 0x00C894E1, 0x00C89406, 0x00C8941E, 0x00C89430, 0x00C89441, 
						  0x00C89698, 0x00C89B38, 0x00C89A63, 0x00C89ADA, 0x00C89CEB, 0x00C8A1FD, 0x00C8A30A, 0x00C8B9D4, 0x00C8B9FC, 0x00C8BA0B, 
						  0x00C8BA3E, 0x00C8BA92, 0x00C8BD23, 0x00C8BD3D, 0x00C8BD53, 0x00C8BD0C, 0x00C8C13A, 0x00C8C176, 0x00C8C193, 0x00C8C1B6, 
						  0x00C8C1D2, 0x00C8C16A, 0x00C8FE92, 0x00C8FEA4, 0x00C8FEE9, 0x00C8FF25, 0x00C8FF37, 0x00C8FF61, 0x00C90142, 0x00C90229, 
						  0x00C9026C, 0x00C90476, 0x00C904B6, 0x00C9053E, 0x00C903A6, 0x00C903BC, 0x00C903E8, 0x00C906C4, 0x00C9065F, 0x00C91850, 
						  0x00C918A5, 0x00C9193E, 0x00C9195E, 0x00C919A8, 0x00C91AC3, 0x00C91AF3, 0x00C91B28, 0x00C91D1F, 0x00C91B62, 0x00C92817, 
						  0x00C92FF8, 0x00C9300C, 0x00C9308B, 0x00C930A3, 0x00C9311A, 0x00C93193, 0x00C93234, 0x00C972BE, 0x00C98A73, 0x00C98A82, 
						  0x00C98AE1, 0x00C98AF0, 0x00C98B80, 0x00C98BAE, 0x00C989C2, 0x00C989FD, 0x00C98A0C, 0x00C9A0E5, 0x00C9A0F7, 0x00C9A10E, 
						  0x00C9A201, 0x00C9A285, 0x00C9A2BB, 0x00C9A315, 0x00C9A356, 0x00C9A3EA, 0x00C9A45A, 0x00C9A471, 0x00C9A4B2, 0x00C9A53E, 
						  0x00C9A59E, 0x00C9A5B5, 0x00C9A8E7, 0x00C9A982, 0x00C9ADDC, 0x00C9AF83, 0x00C9AF95, 0x00C9B0C2, 0x00C9B0D4, 0x00C9B07C, 
						  0x00C9B08E, 0x00C9B09F, 0x00C9B1AA, 0x00C9CF1A, 0x00C9D33A, 0x00C9D481, 0x00C9D615, 0x00C9D68D, 0x00C9E6FB, 0x00C9E9BC, 
						  0x00C9E9C3, 0x00C9F014, 0x00C9F260, 0x00C9F274, 0x00C9F29C, 0x00C9F2B0, 0x00C9F422, 0x00CA03CE, 0x00CA03ED, 0x00CA0460, 
						  0x00CA0A7E, 0x00CA0E00, 0x00CA0FAF, 0x00CA1AF1, 0x00CA1B08, 0x00CA1C58, 0x00CA1FD5, 0x00CA2973, 0x00CA297E, 0x00CA299B, 
						  0x00CA29F7, 0x00CA2A02, 0x00CA2744, 0x00CA2766, 0x00CA2F11, 0x00CA4E3A, 0x00CA511D, 0x00CA5135, 0x00CA515F, 0x00CA5197, 
						  0x00CA51CF, 0x00CA5207, 0x00CA5032, 0x00CA504B, 0x00CA5064, 0x00CA507D, 0x00CA5096, 0x00CA50B5, 0x00CA50D4, 0x00CA50EC, 
						  0x00CA501F, 0x00CA5105, 0x00CA831D, 0x00CA8270, 0x00CA83D9, 0x00CA84C2, 0x00CA8C22, 0x00CA8E6B, 0x00CA8B05, 0x00CA8B5B, 
						  0x00CA920C, 0x00CA9271, 0x00CA9295, 0x00CA9399, 0x00CA93C6, 0x00CA9452, 0x00CA9484, 0x00CA9A1A, 0x00CA98B8, 0x00CA9D3D, 
						  0x00CA9DD4, 0x00CA9F70, 0x00CA9FB5, 0x00CA9FDC, 0x00CAA1D4, 0x00CAA630, 0x00CAA73C, 0x00CAA76C, 0x00CAAA73, 0x00CABF5D, 
						  0x00CAC019, 0x00CABEB0, 0x00CABECD, 0x00CABF25, 0x00CAC924, 0x00CAC97C, 0x00CAD66C, 0x00CAD6B3, 0x00CAD6CB, 0x00CAD708, 
						  0x00CAD71B, 0x00CAD72E, 0x00CAD572, 0x00CAD5AF, 0x00CAD5C6, 0x00CAD5F9, 0x00CAD863, 0x00CAD872, 0x00CAD8D1, 0x00CAD8ED, 
						  0x00CAD90C, 0x00CAD932, 0x00CAD95C, 0x00CAD97B, 0x00CAD999, 0x00CAD9BF, 0x00CAD9D7, 0x00CAD789, 0x00CADA02, 0x00CADB23, 
						  0x00CADB3F, 0x00CADB5B, 0x00CADD0C, 0x00CADEE0, 0x00CADF1C, 0x00CADF48, 0x00CADF72, 0x00CADFC8, 0x00CAE007, 0x00CAE046, 
						  0x00CAE074, 0x00CAE0A0, 0x00CAD83F, 0x00CAE14D, 0x00CAEBEC, 0x00CAFC65, 0x00CAFC82, 0x00CAFC95, 0x00CAFB88, 0x00CAFD06, 
						  0x00CAFD54, 0x00CAFD6B, 0x00CAFD7A, 0x00CAFD91, 0x00CAFDA2, 0x00CAFE26, 0x00CAFE5E, 0x00CAFE74, 0x00CAFEB2, 0x00CAFEC8, 
						  0x00CB138B, 0x00CB1CE0, 0x00CB2957, 0x00CB7A9D, 0x00CB7AAE, 0x00CB7B9C, 0x00CB7BB3, 0x00CB7C0C, 0x00CB7C35, 0x00CB8D00, 
						  0x00CB8D45, 0x00CB8D6C, 0x00CB97C0, 0x00CB97D5, 0x00CB980C, 0x00CB99E1, 0x00CB970F, 0x00CB9D60, 0x00CB9D8D, 0x00CB9784, 
						  0x00CBA15D, 0x00CBA18B, 0x00CBA1B8, 0x00CBA614, 0x00CBA638, 0x00CBA6B3, 0x00CBA75E, 0x00CBA76C, 0x00CBA554, 0x00CBA59C, 
						  0x00CBA84B, 0x00CBA92C, 0x00CBA90A, 0x00CBAA7F, 0x00CBAA9F, 0x00CBAC70, 0x00CBAE11, 0x00CBAE36, 0x00CBAD3D, 0x00CBAD5F, 
						  0x00CBAD7B, 0x00CBADA6, 0x00CBADC2, 0x00CBAE9C, 0x00CBB078, 0x00CBB09C, 0x00CBAEF9, 0x00CBAF17, 0x00CBAF33, 0x00CBAFB7, 
						  0x00CBB159, 0x00CBB177, 0x00CBB193, 0x00CBB1EE, 0x00CBB29A, 0x00CBB34F, 0x00CBB36F, 0x00CBB406, 0x00CBB49A, 0x00CBB4C1, 
						  0x00CBB619, 0x00CBB598, 0x00CBB5C8, 0x00CBB771, 0x00CBB78D, 0x00CBB821, 0x00CBB83D, 0x00CBB89F, 0x00CBB92E, 0x00CBBA41, 
						  0x00CBBCB3, 0x00CBBE46, 0x00CBBE54, 0x00CBBFF5, 0x00CBC287, 0x00CBC182, 0x00CBC1B2, 0x00CBC1CA, 0x00CBC1EA, 0x00CBC20A, 
						  0x00CBC22A, 0x00CBC24B, 0x00CBC40A, 0x00CBC431, 0x00CBC315, 0x00CBC3A3, 0x00CBC3C6, 0x00CBC8D4, 0x00CBCA94, 0x00CBCAE9, 
						  0x00CBCBF3, 0x00CBCC01, 0x00CBCC81, 0x00CBCD54, 0x00CBCDFF, 0x00CBCE65, 0x00CBCE7D, 0x00CBCFDB, 0x00CBC9E7, 0x00CBCA06, 
						  0x00CBCA5D, 0x00CBD191, 0x00CBD1B5, 0x00CBD2E2, 0x00CBD347, 0x00CBD399, 0x00CBD59F, 0x00CBD5C3, 0x00CBD64E, 0x00CBD6CC, 
						  0x00CBD6EA, 0x00CBD706, 0x00CBD731, 0x00CBD784, 0x00CBD7CC, 0x00CBD8B3, 0x00CBD8D5, 0x00CBD90E, 0x00CBD987, 0x00CBD9DA, 
						  0x00CBDA00, 0x00CBDA21, 0x00CBDA7A, 0x00CBDA88, 0x00CBDBFC, 0x00CBDB02, 0x00CBDB6A, 0x00CBDBC5, 0x00CBDC50, 0x00CBDE9D, 
						  0x00CBDEC1, 0x00CBDFD7, 0x00CBE0D6, 0x00CBE21A, 0x00CBE344, 0x00CBE35D, 0x00CBF5CB, 0x00CBF5F8, 0x00CBF60E, 0x00CBF624, 
						  0x00CBF73B, 0x00CBF94F, 0x00CBF9F4, 0x00CBFA29, 0x00CBFC6A, 0x00CBFC92, 0x00CBFE10, 0x00CBFE6F, 0x00CBFF6B, 0x00CC0770, 
						  0x00CC08BA, 0x00CC096B, 0x00CC0BF5, 0x00CC0C1A, 0x00CC0C2C, 0x00CC27BC, 0x00CC33FB, 0x00CC33EE, 0x00CC35BC, 0x00CC3B2C, 
						  0x00CC59F7, 0x00CC5A50, 0x00CC5E47, 0x00CC5E5F, 0x00CC5E79, 0x00CC7A90, 0x00CC7AB6, 0x00CC7AF0, 0x00CC7B31, 0x00CC7B91, 
						  0x00CC7BB3, 0x00CC7949, 0x00CC7DC3, 0x00CC7E1F, 0x00CC7F62, 0x00CC7F72, 0x00CC81D9, 0x00CC9448, 0x00CC947C, 0x00CC948B, 
						  0x00CC94AC, 0x00CC94E0, 0x00CC94EF, 0x00CC9510, 0x00CC9366, 0x00CC9782, 0x00CC97A0, 0x00CC9848, 0x00CC9388, 0x00CC98DB, 
						  0x00CC98E7, 0x00CC992F, 0x00CC993B, 0x00CC9A48, 0x00CC9A69, 0x00CC9A82, 0x00CC9AA5, 0x00CC93B4, 0x00CC93C3, 0x00CC93E4, 
						  0x00CC9418, 0x00CC9427, 0x00CC9C58, 0x00CC9C8C, 0x00CC9C9B, 0x00CC9CBC, 0x00CC9CF0, 0x00CC9CFF, 0x00CC9D20, 0x00CC9B76, 
						  0x00CC9F92, 0x00CC9FB0, 0x00CCA058, 0x00CC9B98, 0x00CCA0EB, 0x00CCA0F7, 0x00CCA13F, 0x00CCA14B, 0x00CCA258, 0x00CCA279, 
						  0x00CCA292, 0x00CCA2B5, 0x00CC9BC4, 0x00CC9BD3, 0x00CC9BF4, 0x00CC9C28, 0x00CC9C37, 0x00CCB818, 0x00CCB80D, 0x00CCC1E5, 
						  0x00CCC587, 0x00CCC6E0, 0x00CCD129, 0x00CCDF2C, 0x00CCE36C, 0x00CD0FA0, 0x00CD102B, 0x00CD1061, 0x00CD10C6, 0x00CD10D2, 
						  0x00CD112B, 0x00CD1185, 0x00CD123A, 0x00CD1D35, 0x00CD286A, 0x00CD2AC5, 0x00CD2AEA, 0x00CD2B04, 0x00CD2B22, 0x00CD2B39, 
						  0x00CD2AB9, 0x00CD2B54, 0x00CD2B6B, 0x00CD3194, 0x00CD31BE, 0x00CD31E4, 0x00CD320E, 0x00CD3221, 0x00CD3236, 0x00CD3261, 
						  0x00CD328B, 0x00CD30C9, 0x00CD3BB1, 0x00CD3C4C, 0x00CD3F38, 0x00CD3F43, 0x00CD3F89, 0x00CD3F96, 0x00CD3FDE, 0x00CD411E, 
						  0x00CD40F3, 0x00CD4283, 0x00CD4258, 0x00CD4CFC, 0x00CD4D84, 0x00CD4B9B, 0x00CD4BBA, 0x00CD4BE9, 0x00CD4C08, 0x00CD4C33, 
						  0x00CD5D41, 0x00CDC7AB, 0x00CDC707, 0x00CDCBCA, 0x00CDCCF7, 0x00CDD0F3, 0x00CDD271, 0x00CE045D, 0x00CE044A, 0x00CE0F10, 
						  0x00CE0F19, 0x00CE0F71, 0x00CE10E0, 0x00CE10E9, 0x00CE1141, 0x00CE12A8, 0x00CE13B7, 0x00CE16E8, 0x00CE166C, 0x00CE1723, 
						  0x00CE1810, 0x00CE18B7, 0x00CE1C69, 0x00CE1CCF, 0x00CE1DF3, 0x00CE1FED, 0x00CE1EF9, 0x00CE1F15, 0x00CE1F34, 0x00CE1F7C, 
						  0x00CE1FA6, 0x00CE205A, 0x00CE2E33, 0x00CE2E6C, 0x00CE2FE7, 0x00CE39FF, 0x00CE3DFF, 0x00CE4175, 0x00CE419E, 0x00CE41DC, 
						  0x00CE41FC, 0x00CE421C, 0x00CE4235, 0x00CE4256, 0x00CE427F, 0x00CE42BA, 0x00CE430B, 0x00CE4328, 0x00CE4346, 0x00CE409F, 
						  0x00CE40B8, 0x00CE40D2, 0x00CE4106, 0x00CE4132, 0x00CE43FC, 0x00CE441E, 0x00CE4431, 0x00CE4443, 0x00CE4456, 0x00CE449B, 
						  0x00CE467E, 0x00CE4697, 0x00CE46AF, 0x00CE46C1, 0x00CE46FE, 0x00CE4731, 0x00CE45C8, 0x00CE45E7, 0x00CE4603, 0x00CE461D, 
						  0x00CE463B, 0x00CE456F, 0x00CE4650, 0x00CE477D, 0x00CE47F1, 0x00CE480C, 0x00CE484B, 0x00CE4995, 0x00CE49AB, 0x00CE49F1, 
						  0x00CE4A2A, 0x00CE4A7D, 0x00CE4AA8, 0x00CE48B8, 0x00CE4B6C, 0x00CE4BAA, 0x00CE4C07, 0x00CE4C3A, 0x00CE48D4, 0x00CE4CD3, 
						  0x00CE4D01, 0x00CE4D17, 0x00CE4D30, 0x00CE48F2, 0x00CE492A, 0x00CE494B, 0x00CE4E70, 0x00CE4E98, 0x00CE4D83, 0x00CE4DBD, 
						  0x00CE4E0F, 0x00CE4E3E, 0x00CE5003, 0x00CE500F, 0x00CE5038, 0x00CE504E, 0x00CE4F51, 0x00CE4F62, 0x00CE4F86, 0x00CE4F95, 
						  0x00CE4FBA, 0x00CE4FD7, 0x00CE4FE3, 0x00CE4F0F, 0x00CE51D1, 0x00CE51ED, 0x00CE508C, 0x00CE5269, 0x00CE509D, 0x00CE50DF, 
						  0x00CE5362, 0x00CE53E3, 0x00CE54F3, 0x00CE5528, 0x00CE553D, 0x00CE5716, 0x00CE586D, 0x00CE5984, 0x00CE599C, 0x00CE572B, 
						  0x00CE5750, 0x00CE5765, 0x00CE5FE7, 0x00CE5F5E, 0x00CE5FCC, 0x00CE6228, 0x00CE629B, 0x00CE62DF, 0x00CE630E, 0x00CE63BF, 
						  0x00CE63E0, 0x00CE64A1, 0x00CE64BC, 0x00CE64F5, 0x00CE6516, 0x00CE6542, 0x00CE655D, 0x00CE65A7, 0x00CE65C4, 0x00CE65DB, 
						  0x00CE6646, 0x00CE66D4, 0x00CE672B, 0x00CE675E, 0x00CE6863, 0x00CE6905, 0x00CE6943, 0x00CE6964, 0x00CE6996, 0x00CE6A1C, 
						  0x00CE6A3D, 0x00CE6A93, 0x00CE6B59, 0x00CE6B75, 0x00CE619E, 0x00CE6BF0, 0x00CE6C96, 0x00CE6CB1, 0x00CE6CEA, 0x00CE6D0B, 
						  0x00CE6D37, 0x00CE6D52, 0x00CE6D9C, 0x00CE6DB9, 0x00CE6DD0, 0x00CE6DF1, 0x00CE6E54, 0x00CE6F2F, 0x00CE6FE0, 0x00CE7099, 
						  0x00CE743F, 0x00CE7468, 0x00CE7531, 0x00CE7364, 0x00CE7672, 0x00CE7681, 0x00CE7372, 0x00CE7812, 0x00CE78AB, 0x00CE7388, 
						  0x00CE78C9, 0x00CE7903, 0x00CE7912, 0x00CE79AD, 0x00CE79EB, 0x00CE7A08, 0x00CE7A41, 0x00CE7A5E, 0x00CE7A9F, 0x00CE7ABF, 
						  0x00CE7ADD, 0x00CE7AFB, 0x00CE7B4D, 0x00CE7B5C, 0x00CE7B9D, 0x00CE7BDB, 0x00CE7BF8, 0x00CE7D57, 0x00CE7D70, 0x00CE7DB0, 
						  0x00CE7DDB, 0x00CE7E1A, 0x00CE7E2A, 0x00CE7F5D, 0x00CE8063, 0x00CE80A3, 0x00CE80AF, 0x00CE84CC, 0x00CE875B, 0x00CE8B2D, 
						  0x00CE8B7E, 0x00CE8E34, 0x00CE8EDE, 0x00CE8F2F, 0x00CE9050, 0x00CE9076, 0x00CE90B3, 0x00CE90D6, 0x00CE90FA, 0x00CE9114, 
						  0x00CE91FE, 0x00CE9CA9, 0x00CEDB03, 0x00CEDB2E, 0x00CEDB41, 0x00CEDB5B, 0x00CEDFC8, 0x00CEE04F, 0x00CEE07F, 0x00CEE0D9, 
						  0x00CEE191, 0x00CEDEED, 0x00CEE6FA, 0x00CEEE41, 0x00CEEE96, 0x00CEEEA8, 0x00CEEEBA, 0x00CEEE8A, 0x00CEFE5E, 0x00CF0624, 
						  0x00CF06E1, 0x00CF077B, 0x00CF0814, 0x00CF0B25, 0x00CF0B7E, 0x00CF0940, 0x00CF0993, 0x00CF1E2C, 0x00CF3512, 0x00CF3862, 
						  0x00CF389E, 0x00CF39F3, 0x00CF3A01, 0x00CF3A63, 0x00CF5B5E, 0x00CF5D85, 0x00CF5DFC, 0x00CF5F38, 0x00CF5E59, 0x00CF5F2A, 
						  0x00CF6D3D, 0x00CF6D2F, 0x00CF79DB, 0x00CF79E9, 0x00CF7A32, 0x00CF7A98, 0x00CF7C1E, 0x00CF7B0C, 0x00CF7E8F, 0x00CF7D27, 
						  0x00CF7D35, 0x00CF7D83, 0x00CF7DA2, 0x00CF7DC6, 0x00CF84DD, 0x00CF84FD, 0x00CF850B, 0x00CF887B, 0x00CFE0ED, 0x00CFE107, 
						  0x00CFE115, 0x00CFE144, 0x00CFE163, 0x00CFE658, 0x00CFE683, 0x00CFE6DF, 0x00CFE738, 0x00CFE779, 0x00CFE96E, 0x00CFE9C2, 
						  0x00CFE2CB, 0x00CFEDD1, 0x00CFEF80, 0x00CFEFC5, 0x00CFEFEC, 0x00CFF54A, 0x00CFF584, 0x00CFF592, 0x00CFF53C, 0x00CFF71F, 
						  0x00CFF7A0, 0x00CFF7DC, 0x00CFF893, 0x00CFF8AA, 0x00CFF8E6, 0x00CFF8FA, 0x00CFF911, 0x00CFFC29, 0x00CFFC5F, 0x00D00BFE, 
						  0x00D00C23, 0x00D00D67, 0x00D00D92, 0x00D00DE3, 0x00D00E06, 0x00D00E54, 0x00D00E8A, 0x00D00CAF, 0x00D00CE9, 0x00D00D02, 
						  0x00D00D17, 0x00D02DC0, 0x00D02E7C, 0x00D03DCC, 0x00D03E4C, 0x00D04DF0, 0x00D04E5B, 0x00D04F45, 0x00D04FC0, 0x00D05051, 
						  0x00D055BC, 0x00D0563C, 0x00D078C5, 0x00D078F3, 0x00D07923, 0x00D0796F, 0x00D077DC, 0x00D07821, 0x00D07893, 0x00D07B82, 
						  0x00D07C34, 0x00D07D6E, 0x00D07D8B, 0x00D07CA2, 0x00D07F55, 0x00D07F76, 0x00D07FA5, 0x00D08019, 0x00D07E89, 0x00D07ED7, 
						  0x00D07E5F, 0x00D08165, 0x00D083E2, 0x00D0846B, 0x00D08282, 0x00D0856D, 0x00D082CA, 0x00D082E7, 0x00D082F5, 0x00D0834C, 
						  0x00D0913B, 0x00D09178, 0x00D0918D, 0x00D091D5, 0x00D091F2, 0x00D09200, 0x00D09263, 0x00D0929C, 0x00D092B4, 0x00D092D0, 
						  0x00D0933F, 0x00D09043, 0x00D0936B, 0x00D09417, 0x00D09433, 0x00D09459, 0x00D09496, 0x00D0953D, 0x00D09564, 0x00D095BF, 
						  0x00D095D8, 0x00D0965B, 0x00D0969D, 0x00D096C9, 0x00D090A6, 0x00D090C9, 0x00D090E2, 0x00D09896, 0x00D098DB, 0x00D09BF9, 
						  0x00D0C30D, 0x00D0C326, 0x00D0D0B6, 0x00D0D0D8, 0x00D0D0F7, 0x00D110AA, 0x00D12385, 0x00D123B1, 0x00D11F32, 0x00D12537, 
						  0x00D1254C, 0x00D12674, 0x00D1265F, 0x00D12ECC, 0x00D12F19, 0x00D12F0C, 0x00D12F5F, 0x00D12F71, 0x00D12F4C, 0x00D159B8, 
						  0x00D15A0A, 0x00D159AC, 0x00D15AA0, 0x00D15AD1, 0x00D15C6E, 0x00D16124, 0x00D16163, 0x00D163C3, 0x00D16440, 0x00D162F9, 
						  0x00D1634C, 0x00D1635A, 0x00D16486, 0x00D164C8, 0x00D164DF, 0x00D1650F, 0x00D167BB, 0x00D16A8D, 0x00D169DC, 0x00D16A1E, 
						  0x00D16A65, 0x00D16A7E, 0x00D16B73, 0x00D16C00, 0x00D1993F, 0x00D1995C, 0x00D19A1A, 0x00D19A37, 0x00D1AE54, 0x00D1AE69, 
						  0x00D1AE7E, 0x00D1AEA7, 0x00D1AEB7, 0x00D1AF22, 0x00D1AF50, 0x00D1AFCF, 0x00D1AD5B, 0x00D1AFFE, 0x00D1AD70, 0x00D1AD85, 
						  0x00D1ADAE, 0x00D1ADC3, 0x00D1ADD8, 0x00D1AE01, 0x00D1AE16, 0x00D1AE2B, 0x00D1C96F, 0x00D1C998, 0x00D1CEE4, 0x00D1CEF1, 
						  0x00D1F9DF, 0x00D1F9F4, 0x00D1FA5E, 0x00D1FAFE, 0x00D1FB1E, 0x00D1FB54, 0x00D1FB76, 0x00D2028C, 0x00D20123, 0x00D21129, 
						  0x00D21C9D, 0x00D22325, 0x00D22528, 0x00D224A5, 0x00D226BE, 0x00D232CC, 0x00D23482, 0x00D23493, 0x00D23C21, 0x00D23CF0, 
						  0x00D24A13, 0x00D2526E, 0x00D2525F, 0x00D2537E, 0x00D2536F, 0x00D26D65, 0x00D26D71, 0x00D26D89, 0x00D2719A, 0x00D27B9C, 
						  0x00D27B8A, 0x00D2ACA2, 0x00D2BDAA, 0x00D2CC1C, 0x00D2CC3C, 0x00D2CD24, 0x00D2CDC4, 0x00D2CE1E, 0x00D2CE52, 0x00D2CFEB, 
						  0x00D2CFAB, 0x00D2D198, 0x00D2D1DA, 0x00D2D0AD, 0x00D2D0C8, 0x00D2D149, 0x00D2D3D4, 0x00D2D63A, 0x00D2D930, 0x00D2D9CA, 
						  0x00D2D9F5, 0x00D2D79D, 0x00D2DEA0, 0x00D2E3A1, 0x00D2E3D4, 0x00D2E40E, 0x00D2E45F, 0x00D2E4D3, 0x00D2E331, 0x00D2E8E0, 
						  0x00D2E920, 0x00D2E94F, 0x00D2EA29, 0x00D2EA52, 0x00D2EBB4, 0x00D2EBCC, 0x00D2EC37, 0x00D2EC6D, 0x00D2ECDE, 0x00D2ECFB, 
						  0x00D2ED18, 0x00D2ED3D, 0x00D2EA9E, 0x00D2EAB9, 0x00D2EEF3, 0x00D2EF23, 0x00D2EFC1, 0x00D2EE1C, 0x00D2EE43, 0x00D2EE94, 
						  0x00D2EED0, 0x00D2F12F, 0x00D2F704, 0x00D2F87A, 0x00D2FB92, 0x00D2FBB4, 0x00D2FC20, 0x00D2FC41, 0x00D2FC5A, 0x00D2FCC1, 
						  0x00D2FCCA, 0x00D2FCDF, 0x00D2FD36, 0x00D302E3, 0x00D30300, 0x00D3036F, 0x00D3038D, 0x00D303F8, 0x00D30695, 0x00D30469, 
						  0x00D30AA6, 0x00D309B0, 0x00D30A0F, 0x00D30A4D, 0x00D30B0B, 0x00D30B6B, 0x00D31D61, 0x00D31E53, 0x00D31E83, 0x00D31F58, 
						  0x00D31F7C, 0x00D320E8, 0x00D3228B, 0x00D322AC, 0x00D321FE, 0x00D323C9, 0x00D324F6, 0x00D325FD, 0x00D327B9, 0x00D327E8, 
						  0x00D32987, 0x00D3291F, 0x00D32A59, 0x00D32B95, 0x00D32C3A, 0x00D32C6B, 0x00D32CFA, 0x00D32D28, 0x00D33CFB, 0x00D33B37, 
						  0x00D33F54, 0x00D33F68, 0x00D33F78, 0x00D34094, 0x00D340A8, 0x00D340B8, 0x00D3413C, 0x00D3416C, 0x00D341FC, 0x00D3422C, 
						  0x00D3429C, 0x00D34DAB, 0x00D34BE7, 0x00D36953, 0x00D36AD0, 0x00D36C02, 0x00D36C36, 0x00D36C7D, 0x00D36D4D, 0x00D38563, 
						  0x00D38579, 0x00D3B9AE, 0x00D3BC7E, 0x00D3D77C, 0x00D3E65E, 0x00D3E686, 0x00D3E6AC, 0x00D3E6BE, 0x00D3E6D9, 0x00D3EAC8, 
						  0x00D3F333, 0x00D3F48C, 0x00D3F8D6, 0x00D3F8E8, 0x00D3F8F6, 0x00D401EE, 0x00D40202, 0x00D40223, 0x00D4026C, 0x00D40280, 
						  0x00D402FC, 0x00D40313, 0x00D40A44, 0x00D40A57, 0x00D40B25, 0x00D40D4C, 0x00D40D5F, 0x00D40DCA, 0x00D40DDD, 0x00D40F43, 
						  0x00D411F0, 0x00D412E5, 0x00D4243A, 0x00D42C5F, 0x00D42DEB, 0x00D42F8E, 0x00D43136, 0x00D432D6, 0x00D43AF1, 0x00D43B26, 
						  0x00D43B3C, 0x00D439BB, 0x00D43A02, 0x00D43A2E, 0x00D43E72, 0x00D43F05, 0x00D440AD, 0x00D440BF, 0x00D440CD, 0x00D440DF, 
						  0x00D440ED, 0x00D44C13, 0x00D44C26, 0x00D44C5A, 0x00D44B61, 0x00D44EC9, 0x00D44FF4, 0x00D45A73, 0x00D493B7, 0x00D493E5, 
						  0x00D4A5DA, 0x00D4A6DA, 0x00D5205D, 0x00D520D1, 0x00D5215F, 0x00D521DC, 0x00D573A1, 0x00D58005, 0x00D58415, 0x00D582DE, 
						  0x00D582F8, 0x00D58301, 0x00D5830C, 0x00D58315, 0x00D58320, 0x00D5B741, 0x00D5B75E, 0x00D5B791, 0x00D5B7A4, 0x00D5B967, 
						  0x00D5B99A, 0x00D5B85A, 0x00D5B884, 0x00D5BA16, 0x00D5CAAF, 0x00D5CB06, 0x00D5CB77, 0x00D5CDDB, 0x00D5CEF6, 0x00D5D0AF, 
						  0x00D5D145, 0x00D5D098, 0x00D5D627, 0x00D5D659, 0x00D5D538, 0x00D5D58F, 0x00D5DDD8, 0x00D5E006, 0x00D5F1B6, 0x00D611CC, 
						  0x00D62586, 0x00D6258F, 0x00D625B0, 0x00D625FC, 0x00D6A414, 0x00D6B88B, 0x00D6C699, 0x00D6E0C9, 0x00D6E45B, 0x00D6E351, 
						  0x00D6E3B9, 0x00D6E5DB, 0x00D6E4D1, 0x00D6E539, 0x00D6E75B, 0x00D6E651, 0x00D6E6B9, 0x00D6E97A, 0x00D84A70, 0x00D84A8A, 
						  0x00DCF614, 0x00DCF623, 0x00DCF5CC, 0x00DCF89A, 0x00DCF8B4, 0x00DCF8EE, 0x00DCF87C, 0x00DCFB97, 0x00DCFC23, 0x00DCFC4E, 
						  0x00DCFCA0, 0x00DCFB27, 0x00DCFB52, 0x00DD0211, 0x00DD023E, 0x00DD025D, 0x00DD0274, 0x00DD031A, 0x00DD0332, 0x00DD034D, 
						  0x00DD01FC, 0x00DD0CB0, 0x00DD0CB9, 0x00DD105E, 0x00DD11B5, 0x00DD1179, 0x00DD13BF, 0x00DD13C9, 0x00DD13E2, 0x00DD1405, 
						  0x00DD142F, 0x00DD1465, 0x00DD14B2, 0x00DD14EA, 0x00DD1515, 0x00DD1529, 0x00DD1556, 0x00DD159F, 0x00DD295A, 0x00DD2A7A, 
						  0x00DD2B2A, 0x00DD2BD7, 0x00DD2C0B, 0x00DD2D23, 0x00DD2DF3, 0x00DD4EC7, 0x00DD50F0, 0x00DD50FF, 0x00DD510D, 0x00DD5172, 
						  0x00DD52AC, 0x00DD52BE, 0x00DD52CD, 0x00DD52DB, 0x00DD52E7, 0x00DD567C, 0x00DD568A, 0x00DD5707, 0x00DD5713, 0x00DD5721, 
						  0x00DD57A7, 0x00DD583A, 0x00DD58A5, 0x00DD58B3, 0x00DD59FB, 0x00DD5A09, 0x00DD5A80, 0x00DD5A8C, 0x00DD5A9A, 0x00DD5B41, 
						  0x00DD5B4D, 0x00DD5B5B, 0x00DD60E9, 0x00DD612F, 0x00DD6166, 0x00DD6193, 0x00DD6220, 0x00DD6297, 0x00DD62FE, 0x00DD6ACE, 
						  0x00DD6B00, 0x00DD6B6E, 0x00DD6BA0, 0x00DD6C45, 0x00DD6C77, 0x00DD6F2C, 0x00DD6F38, 0x00DD6F44, 0x00DD6F9D, 0x00DD6FA9, 
						  0x00DD7008, 0x00DD7039, 0x00DD7045, 0x00DD6E43, 0x00DD7087, 0x00DD70A9, 0x00DD70B5, 0x00DD711A, 0x00DD714B, 0x00DD7157, 
						  0x00DD7199, 0x00DD71BB, 0x00DD71C7, 0x00DD721D, 0x00DD7247, 0x00DD727F, 0x00DD728B, 0x00DD7297, 0x00DD72D9, 0x00DD72FB, 
						  0x00DD7307, 0x00DD7313, 0x00DD7371, 0x00DD737D, 0x00DD7389, 0x00DD742B, 0x00DD746D, 0x00DD74C3, 0x00DD7509, 0x00DD7531, 
						  0x00DD753D, 0x00DD7578, 0x00DD7584, 0x00DD8BD3, 0x00DD8C8B, 0x00DD7693, 0x00DD79FE, 0x00DD7A5C, 0x00DD7ABD, 0x00DD7B1E, 
						  0x00DD7B7C, 0x00DD7BFC, 0x00DD7C5A, 0x00DD7F7F, 0x00DD7F8E, 0x00DD8D56, 0x00DD8DC9, 0x00DD8E42, 0x00DD8EB6, 0x00DD8F1A, 
						  0x00DD8FB3, 0x00DD90B2, 0x00DD911A, 0x00DD92B6, 0x00DD9580, 0x00DD95AC, 0x00DD95C6, 0x00DD96EE, 0x00DD9771, 0x00DD9864, 
						  0x00DD989C, 0x00DD9938, 0x00DD9964, 0x00DD99A3, 0x00DD9A37, 0x00DD9AF3, 0x00DDA827, 0x00DDA993, 0x00DDA97C, 0x00DDAA4A, 
						  0x00DDAC7F, 0x00DDAB93, 0x00DDAE0F, 0x00DDAD23, 0x00DDAF7F, 0x00DDAE93, 0x00DDBFD0, 0x00DDBE97, 0x00DDC561, 0x00DDC56A, 
						  0x00DDC578, 0x00DDC671, 0x00DDC686, 0x00DDC6AC, 0x00DDC6D0, 0x00DDC71C, 0x00DDC4AD, 0x00DDC537, 0x00DDC552, 0x00DDDBF5, 
						  0x00DDE2F6, 0x00DDE319, 0x00DDE35E, 0x00DDE384, 0x00DDE3AD, 0x00DDE3E1, 0x00DDE3EA, 0x00DDE432, 0x00DDE44A, 0x00DDE488, 
						  0x00DDE4A3, 0x00DDE4F8, 0x00DDE525, 0x00DDF034, 0x00DDF04B, 0x00DDF581, 0x00DDFB14, 0x00DDFB38, 0x00DDFC25, 0x00DDFC60, 
						  0x00DDFA9B, 0x00DDFF94, 0x00DDFEF1, 0x00DDFF6E, 0x00DE0E6A, 0x00DE12FE, 0x00DE1958, 0x00DE1963, 0x00DE19C6, 0x00DE1A07, 
						  0x00DE1A2B, 0x00DE1AB0, 0x00DE1AD3, 0x00DE1ADE, 0x00DE1861, 0x00DE186C, 0x00DE18AC, 0x00DE18B7, 0x00DE1900, 0x00DE190B, 
						  0x00DE1CCC, 0x00DE1CFD, 0x00DE1D20, 0x00DE1C7D, 0x00DE1D49, 0x00DE1F60, 0x00DE1FB8, 0x00DE1FD6, 0x00DE2006, 0x00DE2036, 
						  0x00DE2064, 0x00DE2297, 0x00DE22E7, 0x00DE2349, 0x00DE23AF, 0x00DE23E2, 0x00DE2194, 0x00DE252A, 0x00DE2558, 0x00DE222C, 
						  0x00DE29F8, 0x00DE2A2C, 0x00DE2A5F, 0x00DE2A82, 0x00DE2B93, 0x00DE2C82, 0x00DE2CAC, 0x00DE2D10, 0x00DE2D24, 0x00DE2DC7, 
						  0x00DE2DDB, 0x00DE2DE4, 0x00DE2DED, 0x00DE2E8A, 0x00DE2EB6, 0x00DE2EE2, 0x00DE2EF6, 0x00DE2EFF, 0x00DE2F08, 0x00DE2F73, 
						  0x00DE2F87, 0x00DE2F90, 0x00DE2F99, 0x00DE3072, 0x00DE30A0, 0x00DE3171, 0x00DE31E6, 0x00DE3215, 0x00DE3291, 0x00DE338E, 
						  0x00DE27A1, 0x00DE33ED, 0x00DE347B, 0x00DE34A4, 0x00DE34AD, 0x00DE3801, 0x00DE387B, 0x00DE3882, 0x00DE3734, 0x00DE373F, 
						  0x00DE374A, 0x00DE3984, 0x00DE39B1, 0x00DE39F7, 0x00DE3A02, 0x00DE3A0D, 0x00DE3AF1, 0x00DE3B5F, 0x00DE3D44, 0x00DE3D52, 
						  0x00DE3DCC, 0x00DE3DEC, 0x00DE3E22, 0x00DE3E42, 0x00DE3E82, 0x00DE3CBA, 0x00DE3CCC, 0x00DE4172, 0x00DE43F0, 0x00DE4A95, 
						  0x00DE4C33, 0x00DE4C62, 0x00DE4C8D, 0x00DE4D0A, 0x00DE4E2F, 0x00DE4E64, 0x00DE4BAA, 0x00DE5035, 0x00DE5099, 0x00DE50A7, 
						  0x00DE50FB, 0x00DE4F94, 0x00DE5023, 0x00DE5431, 0x00DE5468, 0x00DE54B6, 0x00DE54BD, 0x00DE54D9, 0x00DE54E0, 0x00DE5644, 
						  0x00DE564B, 0x00DE5659, 0x00DE56B5, 0x00DE56BC, 0x00DE56E3, 0x00DE57C2, 0x00DE57C9, 0x00DE583A, 0x00DE5841, 0x00DE5874, 
						  0x00DE587B, 0x00DE589B, 0x00DE58A2, 0x00DE560A, 0x00DE5611, 0x00DE6803, 0x00DE6618, 0x00DE6952, 0x00DE696E, 0x00DE6AB5, 
						  0x00DE6AE8, 0x00DE6B01, 0x00DE6B28, 0x00DE6B5B, 0x00DE6B74, 0x00DE6B9B, 0x00DE69C7, 0x00DE6C2C, 0x00DE6C55, 0x00DE6CBB, 
						  0x00DE6CE4, 0x00DE6D17, 0x00DE6D30, 0x00DE6D57, 0x00DE69E0, 0x00DE6DA9, 0x00DE6DD2, 0x00DE6E02, 0x00DE6E1B, 0x00DE6E42, 
						  0x00DE6E71, 0x00DE6E8A, 0x00DE6EB1, 0x00DE6EE3, 0x00DE6EFC, 0x00DE6F23, 0x00DE6F55, 0x00DE6F6E, 0x00DE6F95, 0x00DE6A07, 
						  0x00DE6A56, 0x00DE6A77, 0x00DE6A8E, 0x00DE6FF1, 0x00DE700F, 0x00DE6FCF, 0x00DE7146, 0x00DE7173, 0x00DE7189, 0x00DE71A7, 
						  0x00DE704F, 0x00DE722B, 0x00DE7249, 0x00DE7267, 0x00DE728E, 0x00DE72AC, 0x00DE72CA, 0x00DE72F1, 0x00DE730F, 0x00DE732D, 
						  0x00DE734D, 0x00DE736C, 0x00DE73A5, 0x00DE73DE, 0x00DE706C, 0x00DE73FC, 0x00DE7427, 0x00DE746D, 0x00DE748B, 0x00DE74B4, 
						  0x00DE74CA, 0x00DE74E8, 0x00DE7550, 0x00DE7566, 0x00DE7584, 0x00DE708A, 0x00DE7112, 0x00DE7128, 0x00DE774F, 0x00DE7765, 
						  0x00DE7783, 0x00DE765D, 0x00DE7673, 0x00DE7691, 0x00DE76E8, 0x00DE7706, 0x00DE7724, 0x00DE78F1, 0x00DE7925, 0x00DE793E, 
						  0x00DE7965, 0x00DE79A8, 0x00DE79FC, 0x00DE7A24, 0x00DE77F6, 0x00DE7A4D, 0x00DE780F, 0x00DE7836, 0x00DE78A6, 0x00DE78CA, 
						  0x00DE7B8A, 0x00DE7BA3, 0x00DE7BCA, 0x00DE7C02, 0x00DE7C26, 0x00DE7C4D, 0x00DE7C8C, 0x00DE7CA5, 0x00DE7CCC, 0x00DE7A9A, 
						  0x00DE7D77, 0x00DE7D9B, 0x00DE7DC2, 0x00DE7DF8, 0x00DE7E1C, 0x00DE7E43, 0x00DE7E79, 0x00DE7E92, 0x00DE7EB9, 0x00DE7EE8, 
						  0x00DE7F13, 0x00DE7F3A, 0x00DE7ABE, 0x00DE7FBC, 0x00DE7FC8, 0x00DE7FF0, 0x00DE8019, 0x00DE8038, 0x00DE804B, 0x00DE805B, 
						  0x00DE8067, 0x00DE808F, 0x00DE80B8, 0x00DE8140, 0x00DE8159, 0x00DE8180, 0x00DE7AE5, 0x00DE8236, 0x00DE823F, 0x00DE8267, 
						  0x00DE8290, 0x00DE82E5, 0x00DE82FE, 0x00DE8325, 0x00DE83F2, 0x00DE841A, 0x00DE8443, 0x00DE84CD, 0x00DE84D6, 0x00DE84FE, 
						  0x00DE8527, 0x00DE85F7, 0x00DE861F, 0x00DE7B2D, 0x00DE8648, 0x00DE7B54, 0x00DE87E2, 0x00DE8809, 0x00DE881F, 0x00DE883D, 
						  0x00DE8868, 0x00DE887E, 0x00DE889C, 0x00DE86EF, 0x00DE88F5, 0x00DE8913, 0x00DE8947, 0x00DE8965, 0x00DE8983, 0x00DE870D, 
						  0x00DE872B, 0x00DE8752, 0x00DE8770, 0x00DE878E, 0x00DE87C4, 0x00DE8BAC, 0x00DE8BD3, 0x00DE8C91, 0x00DE8C9A, 0x00DE8AC0, 
						  0x00DE8CC2, 0x00DE8CEB, 0x00DE8D31, 0x00DE8D59, 0x00DE8D82, 0x00DE8DBB, 0x00DE8DE2, 0x00DE8AE4, 0x00DE8B0B, 0x00DE8B93, 
						  0x00DE8E77, 0x00DE8E95, 0x00DE8EB3, 0x00DE9030, 0x00DE9053, 0x00DE907B, 0x00DE90A4, 0x00DE8F30, 0x00DE8F5A, 0x00DE8F90, 
						  0x00DE8FDF, 0x00DE9007, 0x00DE941C, 0x00DE9471, 0x00DE94A1, 0x00DE94C9, 0x00DE94F2, 0x00DEBFCA, 0x00DEBFD1, 0x00DEC162, 
						  0x00DEC9A7, 0x00DECC94, 0x00DECCD9, 0x00DECD19, 0x00DECE50, 0x00DECE7A, 0x00DECE83, 0x00DECE8F, 0x00DECECC, 0x00DECED5, 
						  0x00DECEE1, 0x00DECF1B, 0x00DECF27, 0x00DED021, 0x00DED036, 0x00DED178, 0x00DED18F, 0x00DED1B3, 0x00DED2F4, 0x00DED313, 
						  0x00DED336, 0x00DED40F, 0x00DED432, 0x00DED44A, 0x00DED468, 0x00DED47B, 0x00DED781, 0x00DED7BA, 0x00DEDA2A, 0x00DEDDFC, 
						  0x00DEDE83, 0x00DEDE98, 0x00DEDED9, 0x00DEDEEB, 0x00DEDE69, 0x00DEE9BF, 0x00DEE8D3, 0x00DEF1FE, 0x00DEF246, 0x00DEF148, 
						  0x00DEF16E, 0x00DEF3CF, 0x00DEF2E3, 0x00DF02B5, 0x00DF02DF, 0x00DF03AB, 0x00DF03C2, 0x00DF041E, 0x00DF0490, 0x00DF01C0, 
						  0x00DF020A, 0x00DF05D6, 0x00DF0637, 0x00DF06AF, 0x00DF08B8, 0x00DF0A2B, 0x00DF0A7F, 0x00DF0A88, 0x00DF0C15, 0x00DF0C60, 
						  0x00DF0CF2, 0x00DF0EA5, 0x00DF0F4E, 0x00DF0ECC, 0x00DF1A83, 0x00DF1A8A, 0x00DF1ABC, 0x00DF1B14, 0x00DF1D22, 0x00DF1FC8, 
						  0x00DF1FDE, 0x00DF208F, 0x00DF20A5, 0x00DF221E, 0x00DF224A, 0x00DF2285, 0x00DF230C, 0x00DF23ED, 0x00DF2403, 0x00DF25BC, 
						  0x00DF2640, 0x00DF28C1, 0x00DF28CA, 0x00DF28D8, 0x00DF2911, 0x00DF2932, 0x00DF2940, 0x00DF2949, 0x00DF2982, 0x00DF2AC3, 
						  0x00DF2AEE, 0x00DF2B14, 0x00DF2B22, 0x00DF2B2B, 0x00DF2B64, 0x00DF2C53, 0x00DF2C71, 0x00DF2C7F, 0x00DF2C88, 0x00DF2CC1, 
						  0x00DF2CD3, 0x00DF2D0D, 0x00DF2D1B, 0x00DF2D24, 0x00DF2D5D, 0x00DF2DBF, 0x00DF2DD0, 0x00DF2806, 0x00DF289F, 0x00DF31BE, 
						  0x00DF3288, 0x00DF3E0A, 0x00DF419D, 0x00DF424E, 0x00DF4261, 0x00DF43F0, 0x00DF4412, 0x00DF44F4, 0x00DF48FB, 0x00DF4A75, 
						  0x00DF4A97, 0x00DF4A45, 0x00DF4D1D, 0x00DF4E75, 0x00DF5015, 0x00DF5063, 0x00DF4F12, 0x00DF4F61, 0x00DF4F72, 0x00DF4FCB, 
						  0x00DF4FD9, 0x00DF539A, 0x00DF53A8, 0x00DF511C, 0x00DF5161, 0x00DF516F, 0x00DF51BA, 0x00DF51C8, 0x00DF54A8, 0x00DF54ED, 
						  0x00DF54FB, 0x00DF5546, 0x00DF5554, 0x00DF5676, 0x00DF572F, 0x00DF5751, 0x00DF576C, 0x00DF5784, 0x00DF5810, 0x00DF5833, 
						  0x00DF5B69, 0x00DF5BAB, 0x00DF5BB4, 0x00DF5BED, 0x00DF5A3C, 0x00DF5A4B, 0x00DF5A7F, 0x00DF5C6C, 0x00DF5EBA, 0x00DF5EFC, 
						  0x00DF5F0A, 0x00DF5F13, 0x00DF5F4C, 0x00DF5D12, 0x00DF5D39, 0x00DF5D77, 0x00DF5DAB, 0x00DF60B9, 0x00DF60C9, 0x00DF5FC8, 
						  0x00DF613F, 0x00DF614F, 0x00DF6217, 0x00DF623F, 0x00DF6071, 0x00DF60AA, 0x00DF644E, 0x00DF6461, 0x00DF6474, 0x00DF6393, 
						  0x00DF6698, 0x00DF67E6, 0x00DF6794, 0x00DF692E, 0x00DF687E, 0x00DF68B0, 0x00DF68FE, 0x00DF6A70, 0x00DF6AFE, 0x00DF699B, 
						  0x00DF69F3, 0x00DF6A3B, 0x00DF6A47, 0x00DF6C23, 0x00DF6C7D, 0x00DF6D57, 0x00DF6EF8, 0x00DF6F3B, 0x00DF6FCD, 0x00DF7026, 
						  0x00DF7064, 0x00DF70D3, 0x00DF711E, 0x00DF726E, 0x00DF729F, 0x00DF7462, 0x00DF746D, 0x00DF7478, 0x00DF7745, 0x00DF777F, 
						  0x00DF778B, 0x00DF7676, 0x00DF7716, 0x00DF794A, 0x00DF795D, 0x00DF7974, 0x00DF7BAE, 0x00DF7BC5, 0x00DF7D5F, 0x00DF7D6E, 
						  0x00DF7DB6, 0x00DF7EA9, 0x00DF7ECC, 0x00DF7EFD, 0x00DF7F12, 0x00DF7F27, 0x00DF7F3A, 0x00DF7F4F, 0x00DF7F62, 0x00DF7CD6, 
						  0x00DF7D0E, 0x00DF7D21, 0x00DF7D30, 0x00DF812F, 0x00DF8136, 0x00DF8269, 0x00DF8288, 0x00DF82F8, 0x00DF8351, 0x00DF8367, 
						  0x00DF84CA, 0x00DF84D3, 0x00DF84E1, 0x00DF8548, 0x00DF855E, 0x00DF85D6, 0x00DF8767, 0x00DF87A6, 0x00DF87B4, 0x00DF87BD, 
						  0x00DF883C, 0x00DF885D, 0x00DF886B, 0x00DF8874, 0x00DF88FF, 0x00DF8993, 0x00DF89A1, 0x00DF89AA, 0x00DF8A15, 0x00DF8A23, 
						  0x00DF8A2C, 0x00DF8AB7, 0x00DF8BE0, 0x00DF8C07, 0x00DF8C10, 0x00DF8C1E, 0x00DF8448, 0x00DF8CD1, 0x00DF8D56, 0x00DF8D8B, 
						  0x00DF8D94, 0x00DF8DA2, 0x00DF8EBF, 0x00DF84B4, 0x00DF90B0, 0x00DF925D, 0x00DF9273, 0x00DF92A2, 0x00DF9334, 0x00DF901D, 
						  0x00DF9480, 0x00DF949A, 0x00DF94BB, 0x00DF94E1, 0x00DF950D, 0x00DF9537, 0x00DF9B8B, 0x00DF9CBE, 0x00DF9E80, 0x00DF9E9B, 
						  0x00DF9EA9, 0x00DF9EE2, 0x00DF9F20, 0x00DF9D2E, 0x00DF9D45, 0x00DF9D84, 0x00DF9FA8, 0x00DFA016, 0x00DFA4B0, 0x00DFA514, 
						  0x00DFA522, 0x00DFA52B, 0x00DFA56B, 0x00DFA3C2, 0x00DFAAFC, 0x00DFAB98, 0x00DFAD3E, 0x00DFAD47, 0x00DFAF5E, 0x00DFAF83, 
						  0x00DFB01C, 0x00DFB028, 0x00DFB05D, 0x00DFB15F, 0x00DFB246, 0x00DFB336, 0x00DFB34D, 0x00DFB403, 0x00DFBC04, 0x00DFBD73, 
						  0x00DFC132, 0x00DFC148, 0x00DFC0BD, 0x00DFC372, 0x00DFC614, 0x00DFC76B, 0x00DFC77E, 0x00DFC791, 0x00DFC7BE, 0x00DFCAF3, 
						  0x00DFCF6C, 0x00DFD011, 0x00DFD9E0, 0x00E0134A, 0x00E0148A, 0x00E01538, 0x00E0155F, 0x00E016E7, 0x00E016FD, 0x00E0172E, 
						  0x00E017DA, 0x00E018AF, 0x00E018DD, 0x00E0189C, 0x00E0198A, 0x00E01E4D, 0x00E01E81, 0x00E01F9A, 0x00E01FDC, 0x00E020AA, 
						  0x00E020E9, 0x00E020FB, 0x00E0223A, 0x00E0239A, 0x00E0246A, 0x00E02601, 0x00E024BD, 0x00E024F0, 0x00E0250B, 0x00E026F7, 
						  0x00E0282A, 0x00E0287F, 0x00E0288B, 0x00E028B2, 0x00E028F7, 0x00E02BFA, 0x00E02C2A, 0x00E02CDA, 0x00E02D22, 0x00E02DBC, 
						  0x00E030EA, 0x00E0328A, 0x00E054DC, 0x00E0559F, 0x00E0558A, 0x00E05726, 0x00E05A63, 0x00E05EE0, 0x00E05EE9, 0x00E05CF7, 
						  0x00E064D7, 0x00E06552, 0x00E09340, 0x00E09362, 0x00E0A6B6, 0x00E0A67C, 0x00E0A779, 0x00E0ACCF, 0x00E0ACD8, 0x00E0ACE1, 
						  0x00E0AB31, 0x00E0AF69, 0x00E0AF72, 0x00E0AFCB, 0x00E0B03A, 0x00E0B043, 0x00E0AE37, 0x00E0B9E1, 0x00E0BA16, 0x00E0BA26, 
						  0x00E0BA77, 0x00E0BAB5, 0x00E0BAC5, 0x00E0BAFA, 0x00E0BB0A, 0x00E0BB3F, 0x00E0BB74, 0x00E0BB88, 0x00E0BC44, 0x00E0C077, 
						  0x00E0C08B, 0x00E0C839, 0x00E0C842, 0x00E0CDBC, 0x00E0CE0C, 0x00E0CE84, 0x00E0CCDC, 0x00E0CD11, 0x00E0CD32, 0x00E0CD56, 
						  0x00E0CD7A, 0x00E0CD9B, 0x00E0EBCA, 0x00E0F156, 0x00E0F1B2, 0x00E0F1C2, 0x00E0F1F9, 0x00E0F456, 0x00E0F4C3, 0x00E0F4E3, 
						  0x00E100A6, 0x00E10122, 0x00E102BD, 0x00E103A8, 0x00E141B8, 0x00E141C9, 0x00E141EE, 0x00E1487D, 0x00E14BD6, 0x00E1506B, 
						  0x00E1514F, 0x00E15198, 0x00E151D7, 0x00E152C4, 0x00E152CE, 0x00E15321, 0x00E15391, 0x00E153FA, 0x00E15486, 0x00E154D1, 
						  0x00E156B2, 0x00E159CC, 0x00E15B4E, 0x00E15D14, 0x00E15D20, 0x00E15DF6, 0x00E160E9, 0x00E161D5, 0x00E15E4E, 0x00E163F1, 
						  0x00E1644C, 0x00E1647A, 0x00E16246, 0x00E16290, 0x00E16554, 0x00E16568, 0x00E165DC, 0x00E166DC, 0x00E16972, 0x00E16998, 
						  0x00E16A68, 0x00E16A71, 0x00E16AC8, 0x00E16AD1, 0x00E168A0, 0x00E168B1, 0x00E168C8, 0x00E168D9, 0x00E168FC, 0x00E1691A, 
						  0x00E1692E, 0x00E16CAA, 0x00E16D07, 0x00E175C9, 0x00E17693, 0x00E177DA, 0x00E17E38, 0x00E18105, 0x00E1813E, 0x00E18387, 
						  0x00E183CC, 0x00E18096, 0x00E180B2, 0x00E180CB, 0x00E1852D, 0x00E18546, 0x00E1854F, 0x00E1846E, 0x00E18477, 0x00E184EC, 
						  0x00E18703, 0x00E1870C, 0x00E18751, 0x00E188D3, 0x00E188DC, 0x00E18945, 0x00E1894E, 0x00E18A26, 0x00E18CEE, 0x00E18CFA, 
						  0x00E18D03, 0x00E18D45, 0x00E18D51, 0x00E18D5A, 0x00E18E88, 0x00E18E91, 0x00E18C1C, 0x00E18C25, 0x00E18FF1, 0x00E18FFA, 
						  0x00E19307, 0x00E19310, 0x00E1931C, 0x00E1910A, 0x00E19113, 0x00E1970E, 0x00E19724, 0x00E199E0, 0x00E19A00, 0x00E19A20, 
						  0x00E19A3E, 0x00E19A51, 0x00E19A6F, 0x00E19A8A, 0x00E19AA8, 0x00E19ABB, 0x00E19949, 0x00E19963, 0x00E19985, 0x00E199A3, 
						  0x00E199B6, 0x00E19B59, 0x00E19BBD, 0x00E19EE9, 0x00E19F14, 0x00E19F1D, 0x00E19F26, 0x00E19F68, 0x00E19F90, 0x00E19FBB, 
						  0x00E19FC4, 0x00E19FCD, 0x00E1A00B, 0x00E1A037, 0x00E1A05F, 0x00E1A068, 0x00E19DBF, 0x00E1A086, 0x00E1A08F, 0x00E1A098, 
						  0x00E19DE3, 0x00E19E73, 0x00E19E7C, 0x00E19E85, 0x00E1B8A3, 0x00E1B92D, 0x00E1BB61, 0x00E1BB8B, 0x00E1BB94, 0x00E1B9E6, 
						  0x00E1BA0D, 0x00E1BA16, 0x00E1BD35, 0x00E1BD73, 0x00E1BC67, 0x00E1BCCA, 0x00E1BCE2, 0x00E1BDBE, 0x00E1BDFC, 0x00E1BE0A, 
						  0x00E1BE20, 0x00E1BE35, 0x00E1C8A9, 0x00E1C941, 0x00E1D365, 0x00E1D3A3, 0x00E1D297, 0x00E1D2FA, 0x00E1D312, 0x00E1D420, 
						  0x00E1D435, 0x00E1D44A, 0x00E1DA2D, 0x00E1DAFC, 0x00E1DB9F, 0x00E1DBCB, 0x00E1DE6C, 0x00E1E288, 0x00E1E308, 0x00E1FD80, 
						  0x00E20231, 0x00E21D92, 0x00E221ED, 0x00E221FB, 0x00E22216, 0x00E2223D, 0x00E23689, 0x00E22628, 0x00E2263C, 0x00E22658, 
						  0x00E22892, 0x00E22BC5, 0x00E22C1F, 0x00E22F02, 0x00E23ED3, 0x00E24400, 0x00E24778, 0x00E247A2, 0x00E2474B, 0x00E25683, 
						  0x00E256A8, 0x00E256DE, 0x00E25714, 0x00E2574A, 0x00E25BA0, 0x00E25BA7, 0x00E25C0C, 0x00E25D21, 0x00E25D28, 0x00E25D8F, 
						  0x00E2640C, 0x00E26413, 0x00E26934, 0x00E2693B, 0x00E2687A, 0x00E26881, 0x00E26A48, 0x00E26AAC, 0x00E26AD2, 0x00E26AF8, 
						  0x00E26CC2, 0x00E26CC9, 0x00E26D86, 0x00E26DD9, 0x00E26C3C, 0x00E26C43, 0x00E26F40, 0x00E26F47, 0x00E26FC9, 0x00E26FD0, 
						  0x00E2705C, 0x00E2710C, 0x00E271B8, 0x00E26EB7, 0x00E26EBE, 0x00E272DB, 0x00E272E2, 0x00E27514, 0x00E2751B, 0x00E27477, 
						  0x00E2747E, 0x00E27E08, 0x00E27E0F, 0x00E28324, 0x00E2832B, 0x00E2861A, 0x00E28621, 0x00E28A5E, 0x00E28A65, 0x00E289BE, 
						  0x00E289C5, 0x00E28B55, 0x00E28B5C, 0x00E28C4C, 0x00E28C53, 0x00E28D3C, 0x00E28D43, 0x00E28EB5, 0x00E28EBC, 0x00E28DFC, 
						  0x00E28E03, 0x00E29101, 0x00E29108, 0x00E29045, 0x00E2904C, 0x00E29424, 0x00E2942B, 0x00E29936, 0x00E29A4E, 0x00E29C55, 
						  0x00E29DA7, 0x00E29ED3, 0x00E29FEA, 0x00E29880, 0x00E2A3E6, 0x00E2A5A0, 0x00E2ABBA, 0x00E2ABC1, 0x00E2AC6C, 0x00E2AE4C, 
						  0x00E2AE53, 0x00E2AFA0, 0x00E2AFD6, 0x00E2B00C, 0x00E2AF0B, 0x00E2AF28, 0x00E2AF45, 0x00E2AF6A, 0x00E2B4DF, 0x00E2B4EB, 
						  0x00E2B54E, 0x00E2B5C8, 0x00E2B5CF, 0x00E2B5E8, 0x00E2B644, 0x00E2B669, 0x00E2B6A7, 0x00E2B6FF, 0x00E2B706, 0x00E2B815, 
						  0x00E2B81C, 0x00E2B8F9, 0x00E2B900, 0x00E2BA0C, 0x00E2BC43, 0x00E2C33F, 0x00E2C34B, 0x00E2C3AE, 0x00E2C428, 0x00E2C42F, 
						  0x00E2C448, 0x00E2C4A4, 0x00E2C4C9, 0x00E2C507, 0x00E2C55F, 0x00E2C566, 0x00E2C675, 0x00E2C67C, 0x00E2C759, 0x00E2C760, 
						  0x00E2C86C, 0x00E2CAA3, 0x00E2CF30, 0x00E2CFF6, 0x00E2D5FB, 0x00E2D657, 0x00E2D6B3, 0x00E2D70F, 0x00E2D76B, 0x00E2D7CA, 
						  0x00E2D829, 0x00E2D888, 0x00E2D8E4, 0x00E2DFC5, 0x00E2DFE0, 0x00E2E428, 0x00E2E686, 0x00E2E6DD, 0x00E2E725, 0x00E2E745, 
						  0x00E2E76A, 0x00E2F1C1, 0x00E2F332, 0x00E2F63A, 0x00E2F643, 0x00E2F767, 0x00E2F770, 0x00E2F894, 0x00E2F89D, 0x00E2F9B2, 
						  0x00E2F9BB, 0x00E2FA88, 0x00E2FA91, 0x00E2FBF4, 0x00E2FBFD, 0x00E2FD59, 0x00E2FD62, 0x00E2FEB2, 0x00E2FEBB, 0x00E2FFEE, 
						  0x00E2FFF7, 0x00E3002A, 0x00E30033, 0x00E3003C, 0x00E30045, 0x00E3004E, 0x00E30057, 0x00E302DD, 0x00E302E6, 0x00E3035D, 
						  0x00E303B0, 0x00E30597, 0x00E3052E, 0x00E3053E, 0x00E30557, 0x00E320CA, 0x00E3214E, 0x00E32C30, 0x00E32CD9, 0x00E32D4D, 
						  0x00E334DE, 0x00E334EE, 0x00E33539, 0x00E33549, 0x00E33591, 0x00E335A1, 0x00E33424, 0x00E33434, 0x00E35326, 0x00E35788, 
						  0x00E33DEB, 0x00E341B5, 0x00E35D45, 0x00E36045, 0x00E3644F, 0x00E3694A, 0x00E3696C, 0x00E3698C, 0x00E368FE, 0x00E3690A, 
						  0x00E36916, 0x00E36924, 0x00E39035, 0x00E397B0, 0x00E397D4, 0x00E397FA, 0x00E3983C, 0x00E39868, 0x00E39898, 0x00E398B7, 
						  0x00E398F4, 0x00E39915, 0x00E3993C, 0x00E39960, 0x00E3997C, 0x00E399B9, 0x00E399E0, 0x00E39700, 0x00E39721, 0x00E39763, 
						  0x00E39784, 0x00E39D6F, 0x00E3B6DF, 0x00E3B683, 0x00E3B694, 0x00E3B6AA, 0x00E3B79A, 0x00E3B7A1, 0x00E3B94F, 0x00E3B960, 
						  0x00E3B976, 0x00E3B991, 0x00E3C144, 0x00E3C964, 0x00E3CBD3, 0x00E3CF98, 0x00E3CFFB, 0x00E3D239, 0x00E3D29C, 0x00E3D19D, 
						  0x00E3D328, 0x00E3D410, 0x00E3D52A, 0x00E3E794, 0x00E3F76B, 0x00E40D56, 0x00E40D76, 0x00E40D86, 0x00E40DA3, 0x00E4126C, 
						  0x00E4125D, 0x00E41468, 0x00E41581, 0x00E415C1, 0x00E41750, 0x00E42684, 0x00E42BC6, 0x00E42BD8, 0x00E42BE8, 0x00E42C12, 
						  0x00E42C36, 0x00E42C5C, 0x00E42E53, 0x00E42EBA, 0x00E430A3, 0x00E431B7, 0x00E43A01, 0x00E43A2F, 0x00E43A5D, 0x00E43A8B, 
						  0x00E43933, 0x00E4395B, 0x00E43983, 0x00E439AB, 0x00E439D3, 0x00E43ACD, 0x00E43AED, 0x00E45477, 0x00E45486, 0x00E454B8, 
						  0x00E454C7, 0x00E45562, 0x00E45575, 0x00E455A4, 0x00E455D3, 0x00E45602, 0x00E459D1, 0x00E45BA1, 0x00E45BE8, 0x00E45AE4, 
						  0x00E45B23, 0x00E45B62, 0x00E45AAD, 0x00E45C36, 0x00E45C45, 0x00E45C62, 0x00E45C71, 0x00E45C8E, 0x00E45C9D, 0x00E45CBA, 
						  0x00E45CC9, 0x00E4601E, 0x00E4604D, 0x00E4600F, 0x00E4612E, 0x00E46236, 0x00E46292, 0x00E462A1, 0x00E462BE, 0x00E462CD, 
						  0x00E46507, 0x00E46516, 0x00E46545, 0x00E4664E, 0x00E46706, 0x00E46762, 0x00E46771, 0x00E4678E, 0x00E4679D, 0x00E4697E, 
						  0x00E4696F, 0x00E46A4B, 0x00E46AD6, 0x00E46B32, 0x00E46B41, 0x00E46C8E, 0x00E46C7F, 0x00E46D5B, 0x00E46DE6, 0x00E46E42, 
						  0x00E46E51, 0x00E46EA2, 0x00E46EB1, 0x00E4701E, 0x00E4700F, 0x00E470FB, 0x00E47186, 0x00E473D2, 0x00E47401, 0x00E47430, 
						  0x00E473BF, 0x00E474FE, 0x00E475E6, 0x00E4761D, 0x00E47654, 0x00E476B2, 0x00E476C1, 0x00E476DE, 0x00E476ED, 0x00E4770A, 
						  0x00E47719, 0x00E47E8B, 0x00E47EEA, 0x00E47F30, 0x00E47FC3, 0x00E47FD6, 0x00E47FFA, 0x00E48010, 0x00E48035, 0x00E48047, 
						  0x00E48067, 0x00E48079, 0x00E482D6, 0x00E48332, 0x00E48341, 0x00E4835E, 0x00E4836D, 0x00E4838A, 0x00E48399, 0x00E48792, 
						  0x00E487C1, 0x00E487F0, 0x00E4877F, 0x00E4890E, 0x00E489F6, 0x00E48A2D, 0x00E48A92, 0x00E48AA1, 0x00E48ABE, 0x00E48ACD, 
						  0x00E48AEA, 0x00E48AF9, 0x00E48F98, 0x00E49228, 0x00E49239, 0x00E491C7, 0x00E491D8, 0x00E492A3, 0x00E49352, 0x00E496AC, 
						  0x00E496BC, 0x00E496CC, 0x00E49723, 0x00E49739, 0x00E49749, 0x00E49759, 0x00E49696, 0x00E49B24, 0x00E49D30, 0x00E4A314, 
						  0x00E4A3E4, 0x00E4A6F2, 0x00E4CDE2, 0x00E4CDF4, 0x00E4CE14, 0x00E4CE33, 0x00E4CE5B, 0x00E4CD43, 0x00E4CD78, 0x00E4CDAC, 
						  0x00E4D662, 0x00E4D746, 0x00E4DA06, 0x00E55B99, 0x00E55BA8, 0x00E55D17, 0x00E55D3E, 0x00E55D4D, 0x00E55D57, 0x00E55D68, 
						  0x00E55C26, 0x00E55D72, 0x00E55D80, 0x00E55C39, 0x00E55C43, 0x00E55C6D, 0x00E55C77, 0x00E55CA1, 0x00E55CAB, 0x00E55CD5, 
						  0x00E55CE4, 0x00E55CEE, 0x00E55CFF, 0x00E55D09, 0x00E55F3E, 0x00E55F4D, 0x00E5632E, 0x00E5647F, 0x00E566DD, 0x00E566FD, 
						  0x00E569A9, 0x00E569E2, 0x00E56A15, 0x00E56B41, 0x00E56E62, 0x00E57828, 0x00E579FE, 0x00E57A21, 0x00E57A44, 0x00E57AB9, 
						  0x00E57B78, 0x00E57E5E, 0x00E57F30, 0x00E58B20, 0x00E58D0C, 0x00E58DFB, 0x00E58E75, 0x00E5929B, 0x00E59316, 0x00E594C0, 
						  0x00E594E6, 0x00E594FC, 0x00E59F0C, 0x00E5AE37, 0x00E5AE88, 0x00E5AECD, 0x00E5AF1A, 0x00E5AF5F, 0x00E5AFBC, 0x00E5B001, 
						  0x00E5B04B, 0x00E5B090, 0x00E5B0D5, 0x00E5B114, 0x00E5B152, 0x00E5B17D, 0x00E5B1A8, 0x00E5B1DC, 0x00E5B210, 0x00E5B244, 
						  0x00E5B278, 0x00E5B2B2, 0x00E5B2EC, 0x00E5B320, 0x00E5B354, 0x00E5B388, 0x00E5B3BC, 0x00E5B3F0, 0x00E5B424, 0x00E5B458, 
						  0x00E5B48C, 0x00E5B4C6, 0x00E5B584, 0x00E5B5A8, 0x00E5B631, 0x00E5B66D, 0x00E5B699, 0x00E5B6C7, 0x00E5C67C, 0x00E5C78A, 
						  0x00E5EDBD, 0x00E5EDDD, 0x00E5EDFD, 0x00E5EE1D, 0x00E5EEB1, 0x00E5EED4, 0x00E5EEFE, 0x00E5F548, 0x00E5F558, 0x00E5F568, 
						  0x00E5F578, 0x00E5F588, 0x00E5F90E, 0x00E5F951, 0x00E604E8, 0x00E604F6, 0x00E60534, 0x00E6054B, 0x00E607E0, 0x00E60854, 
						  0x00E60898, 0x00E608CF, 0x00E608E4, 0x00E6091D, 0x00E60948, 0x00E6096B, 0x00E60AD8, 0x00E60453, 0x00E60D6C, 0x00E60D5D, 
						  0x00E66B99, 0x00E66BD2, 0x00E66C0B, 0x00E66C3E, 0x00E66C7D, 0x00E66C9D, 0x00E66F7A, 0x00E67BD8, 0x00E67D39, 0x00E67DAE, 
						  0x00E67DD3, 0x00E68352, 0x00E68AB9, 0x00E69ED1, 0x00E69EFC, 0x00E69F0A, 0x00E69F1A, 0x00E6AE65, 0x00E6AE7F, 0x00E6B15A, 
						  0x00E6B1A1, 0x00E6B1E0, 0x00E6B227, 0x00E6B26E, 0x00E6B2B5, 0x00E6B2FC, 0x00E6B34F, 0x00E6B390, 0x00E6B3CF, 0x00E6B408, 
						  0x00E6B53F, 0x00E6B567, 0x00E6BBAB, 0x00E6BAC2, 0x00E6CDCD, 0x00E6CDF2, 0x00E6CF03, 0x00E6CF2B, 0x00E6CF53, 0x00E6CF81, 
						  0x00E6CFAF, 0x00E6CFED, 0x00E6D00D, 0x00E6D992, 0x00E6DA01, 0x00E6DC51, 0x00E6DC96, 0x00E6DCCD, 0x00E6DBCF, 0x00E6DC14, 
						  0x00E6DD88, 0x00E6DDB4, 0x00E6E319, 0x00E6E342, 0x00E6E36E, 0x00E6E4C9, 0x00E6E4DE, 0x00E6E51B, 0x00E6E6C1, 0x00E6E6FE, 
						  0x00E6E738, 0x00E6E769, 0x00E6E77F, 0x00E6E793, 0x00E6E7CD, 0x00E6E7E6, 0x00E6E800, 0x00E6E894, 0x00E6E8BB, 0x00E6E8F7, 
						  0x00E6E90C, 0x00E6E946, 0x00E6E9B3, 0x00E6E9DC, 0x00E6EB9A, 0x00E6ED13, 0x00E6ED43, 0x00E6ED4D, 0x00E6ED5C, 0x00E6ED66, 
						  0x00E6ED7C, 0x00E6ED86, 0x00E6ED97, 0x00E6EDA1, 0x00E6EDE1, 0x00E6EE62, 0x00E6EEE8, 0x00E6EEF2, 0x00E6EF00, 0x00E6EF3A, 
						  0x00E6EF44, 0x00E6EF7E, 0x00E6EF88, 0x00E6EFC2, 0x00E6EFCC, 0x00E705AF, 0x00E70730, 0x00E73089, 0x00E730BF, 0x00E730D9, 
						  0x00E730FC, 0x00E7311E, 0x00E73143, 0x00E73167, 0x00E73183, 0x00E731A7, 0x00E731F5, 0x00E7328F, 0x00E732DA, 0x00E72FDC, 
						  0x00E72FEA, 0x00E73010, 0x00E73FA0, 0x00E74036, 0x00E74049, 0x00E74052, 0x00E74079, 0x00E740A0, 0x00E740BD, 0x00E740FE, 
						  0x00E74115, 0x00E73F2C, 0x00E73F5A, 0x00E73F70, 0x00E73F8C, 0x00E78990, 0x00E789B4, 0x00E78AB5, 0x00E78AE2, 0x00E78D6C, 
						  0x00E78D9D, 0x00E78DB9, 0x00E78DC5, 0x00E78DDB, 0x00E78E17, 0x00E78ECF, 0x00E78EDD, 0x00E78F10, 0x00E78F1E, 0x00E79422, 
						  0x00E7942E, 0x00E79614, 0x00E79634, 0x00E7ADF3, 0x00E7AE2F, 0x00E79F61, 0x00E7B5D9, 0x00E7B606, 0x00E7B675, 0x00E7B6F8, 
						  0x00E7B728, 0x00E7B80A, 0x00E79E0B, 0x00E7C6FD, 0x00E7C8AA, 0x00E7C8DA, 0x00E7C903, 0x00E7C9AE, 0x00E7C9ED, 0x00E7A77E, 
						  0x00E7A79A, 0x00E7A7F7, 0x00E7A863, 0x00E7A891, 0x00E7A98F, 0x00E7AC79, 0x00E7AD42, 0x00E7AD6B, 0x00E7ADB7, 0x00E7CCC9, 
						  0x00E7CFBB, 0x00E7CFE8, 0x00E7D00F, 0x00E7D036, 0x00E7DDD2, 0x00E7E10A, 0x00E7EA22, 0x00E7ED6A, 0x00E7ED78, 0x00E7ED86, 
						  0x00E7ED98, 0x00E7EDC7, 0x00E7ED58, 0x00E81176, 0x00E811A2, 0x00E811CE, 0x00E811FA, 0x00E81226, 0x00E81252, 0x00E8127E, 
						  0x00E812B0, 0x00E812E2, 0x00E8133F, 0x00E81386, 0x00E813C5, 0x00E8140C, 0x00E81453, 0x00E8149A, 0x00E814ED, 0x00E81531, 
						  0x00E8157C, 0x00E815D6, 0x00E81628, 0x00E81685, 0x00E816CE, 0x00E82888, 0x00E83B5D, 0x00E83D6D, 0x00E83D8C, 0x00E83B78, 
						  0x00E83E47, 0x00E83F9F, 0x00E840D7, 0x00E84163, 0x00E841C9, 0x00E84357, 0x00E84379, 0x00E843AB, 0x00E844DE, 0x00E844BF, 
						  0x00E84697, 0x00E8455D, 0x00E848AD, 0x00E8494C, 0x00E8474E, 0x00E847A8, 0x00E847E9, 0x00E84C13, 0x00E84D9C, 0x00E84DB1, 
						  0x00E84DCB, 0x00E84DE4, 0x00E84EC5, 0x00E84EE5, 0x00E84EFA, 0x00E84F14, 0x00E84F2D, 0x00E86149, 0x00E86193, 0x00E86785, 
						  0x00E86947, 0x00E869A9, 0x00E86A6E, 0x00E86AF2, 0x00E865D3, 0x00E86CDA, 0x00E86CEE, 0x00E86D0F, 0x00E86DCA, 0x00E86E0B, 
						  0x00E86E20, 0x00E86E3B, 0x00E86BF7, 0x00E86EDA, 0x00E86EF8, 0x00E86C38, 0x00E86C4C, 0x00E86C6D, 0x00E87117, 0x00E8720C, 
						  0x00E87035, 0x00E87063, 0x00E8708D, 0x00E870DF, 0x00E8736D, 0x00E875F5, 0x00E87A22, 0x00E8790B, 0x00E87AA5, 0x00E87AD9, 
						  0x00E87B34, 0x00E87B7B, 0x00E87B96, 0x00E87946, 0x00E87954, 0x00E8796F, 0x00E879C0, 0x00E87C95, 0x00E87D2C, 0x00E87D73, 
						  0x00E87D8E, 0x00E87ED0, 0x00E87EDF, 0x00E87E64, 0x00E880A0, 0x00E880AF, 0x00E88034, 0x00E88A8F, 0x00E88AAD, 0x00E88C67, 
						  0x00E88CF3, 0x00E88D2C, 0x00E88D65, 0x00E88D9E, 0x00E88B89, 0x00E88BC2, 0x00E88BFB, 0x00E88C34, 0x00E88F60, 0x00E89E6D, 
						  0x00E8A322, 0x00E8A945, 0x00E8A9D8, 0x00E8ECC9, 0x00E8ECF4, 0x00E8ED1F, 0x00E8ED60, 0x00E8ED80, 0x00E8EFE9, 0x00E8EFFB, 
						  0x00E8F00D, 0x00E8F042, 0x00E8F552, 0x00E8F3C0, 0x00E8F3D8, 0x00E90E68, 0x00E90E9E, 0x00EC8CD0, 0x00ECA90E, 0x00ECA930, 
						  0x00ECA93D, 0x00ECA969, 0x00ECA976, 0x00ECAAC9, 0x00ECAB80, 0x00ECACD9, 0x00ECAD23, 0x00ECADB2, 0x00ECADDA, 0x00ECAE07, 
						  0x00ECAE27, 0x00ECB4BC, 0x00ECB4F9, 0x00ECB540, 0x00ECB57F, 0x00ECC29C, 0x00ECC2A3, 0x00ECD7DC, 0x00ED06B1, 0x00ED06C5, 
						  0x00ED06D9, 0x00ED0723, 0x00ED072F, 0x00ED0743, 0x00ED078D, 0x00ED07A1, 0x00ED07B5, 0x00ED12FB, 0x00ED183B, 0x00ED1860, 
						  0x00ED1AE8, 0x00ED198D, 0x00ED23FC, 0x00ED2600, 0x00ED25C2, 0x00ED25C9, 0x00ED25EA, 0x00ED282C, 0x00ED2840, 0x00ED2847, 
						  0x00ED285A, 0x00ED2889, 0x00ED2897, 0x00ED28AB, 0x00ED2A8F, 0x00ED2D14, 0x00ED32E2, 0x00ED4F80, 0x00ED4FB8, 0x00ED5568, 
						  0x00ED56AF, 0x00ED5AC7, 0x00ED5ADB, 0x00ED5AFC, 0x00ED5B20, 0x00ED5C9B, 0x00ED5CBC, 0x00ED5CEC, 0x00ED5D11, 0x00ED5E1E, 
						  0x00ED5E0F, 0x00ED5E7C, 0x00ED5ECD, 0x00ED5EDC, 0x00ED6AA6, 0x00ED7A8E, 0x00ED7AB6, 0x00ED7AC8, 0x00ED7AEA, 0x00ED7B15, 
						  0x00ED7B27, 0x00ED7B49, 0x00ED84F3, 0x00ED861B, 0x00ED8651, 0x00ED867C, 0x00ED8770, 0x00ED8796, 0x00ED87C2, 0x00ED898C, 
						  0x00ED89A8, 0x00ED89C8, 0x00ED89F3, 0x00ED8A38, 0x00ED8A51, 0x00ED8ADB, 0x00ED8B28, 0x00ED844B, 0x00ED8484, 0x00ED9A67, 
						  0x00EDA7E1, 0x00EDA858, 0x00EDA9BB, 0x00EDAA32, 0x00EDAAD3, 0x00EDB3DA, 0x00EDB3F2, 0x00EDBAAC, 0x00EDCF7E, 0x00EDCF9C, 
						  0x00EDCFCE, 0x00EDCD66, 0x00EDCDDD, 0x00EDD399, 0x00EDD431, 0x00EDD566, 0x00EDE16D, 0x00EDE19C, 0x00EDE1BF, 0x00EDE1E2, 
						  0x00EDE231, 0x00EDE23B, 0x00EDE25A, 0x00EDE283, 0x00EDE2A0, 0x00EDE2B6, 0x00EDE2D0, 0x00EDE2E7, 0x00EDE339, 0x00EDE388, 
						  0x00EDE0F2, 0x00EDE11C, 0x00EDE47A, 0x00EDE68A, 0x00EDE782, 0x00EDECF3, 0x00EDF2F6, 0x00EDF30C, 0x00EDF324, 0x00EDF348, 
						  0x00EDF374, 0x00EDF938, 0x00EE01DF, 0x00EE00D8, 0x00EE0DB4, 0x00EE0DC0, 0x00EE0DD2, 0x00EE0DDB, 0x00EE2581, 0x00EE2E6D, 
						  0x00EE6826, 0x00EE673F, 0x00EE6992, 0x00EE69B9, 0x00EE69F6, 0x00EE6A99, 0x00EE6AAB, 0x00EE6AF2, 0x00EE6B04, 0x00EE889A, 
						  0x00EE785C, 0x00EE8926, 0x00EE789C, 0x00EE855D, 0x00EE783E, 0x00EE8B1B, 0x00EE931B, 0x00EE932D, 0x00EE93DB, 0x00EE93ED, 
						  0x00EE9414, 0x00EE9426, 0x00EE95E1, 0x00EE9B60, 0x00EE9C0E, 0x00EE9E30, 0x00EE9E42, 0x00EE9F9E, 0x00EE9FB0, 0x00EE9FCA, 
						  0x00EEA009, 0x00EEA020, 0x00EEA03F, 0x00EEBAFF, 0x00EEBCE3, 0x00EEBCFA, 0x00EEBC3F, 0x00EEBCB2, 0x00EEC87B, 0x00EEC976, 
						  0x00EEC98C, 0x00EEC9C7, 0x00EEC9DF, 0x00EECD2F, 0x00EED6DC, 0x00EED6F3, 0x00EED711, 0x00EEDA5F, 0x00EEDFD2, 0x00EEE014, 
						  0x00EEED89, 0x00EEF671, 0x00EEF75E, 0x00EEF7A0, 0x00EF0B02, 0x00EF0C00, 0x00EF1190, 0x00EF17B7, 0x00EF2409, 0x00EF569F, 
						  0x00EF56A9, 0x00EF54FF, 0x00EF5509, 0x00EF57D3, 0x00EF5DF9, 0x00EF6524, 0x00EF74E6, 0x00EF76CD, 0x00EF788C, 0x00EF7A6C, 
						  0x00EF7C4C, 0x00EF8436, 0x00EF8FA7, 0x00EF8FBA, 0x00EF8FD5, 0x00EF9083, 0x00EF9135, 0x00EF9345, 0x00EF938E, 0x00EF93DF, 
						  0x00EFA635, 0x00EFA7F3, 0x00EFA7FA, 0x00EFA94C, 0x00EFE88D, 0x00EFFC95, 0x00EFFCAB, 0x00F019C7, 0x00F01A5A, 0x00F01A6D, 
						  0x00F01ACF, 0x00F01BCD, 0x00F01BE1, 0x00F01CC1, 0x00F01CE4, 0x00F01D08, 0x00F01E49, 0x00F01EAF, 0x00F01931, 0x00F01FFD, 
						  0x00F02219, 0x00F02252, 0x00F02272, 0x00F023E2, 0x00F0241B, 0x00F022ED, 0x00F0231C, 0x00F023AD, 0x00F0251D, 0x00F02535, 
						  0x00F0295E, 0x00F02976, 0x00F034D6, 0x00F0384B, 0x00F0386B, 0x00F03C15, 0x00F04F40, 0x00F054A0, 0x00F054AC, 0x00F055FA, 
						  0x00F05BF8, 0x00F05BEC, 0x00F05E92, 0x00F05E9E, 0x00F095C6, 0x00F09A22, 0x00F09A8D, 0x00F09AA1, 0x00F09AB4, 0x00F09AC0, 
						  0x00F0E4A4, 0x00F13A51, 0x00F1D774, 0x00F23D49, 0x00F2442E, 0x00F28F96, 0x00F2901B, 0x00F295AF, 0x00F29A7E, 0x00F29F8C, 
						  0x00F2A14F, 0x00F2A18D, 0x00F2AE17, 0x00F2AE2E, 0x00F2AE9E, 0x00F2B3DF, 0x00F2C4B9, 0x00F2C4EA, 0x00F2C5BE, 0x00F2C65E, 
						  0x00F2CA39, 0x00F2CA72, 0x00F2CA88, 0x00F2D89A, 0x00F2D8D0, 0x00F2D940, 0x00F2D96C, 0x00F2D9B2, 0x00F2D9E2, 0x00F2DA22, 
						  0x00F2DA34, 0x00F2DAB2, 0x00F5E37F, 0x00F5E44A, 0x00F5ED88, 0x00F666A4, 0x00F666B1, 0x00F67B3B, 0x00F69990, 0x00F6997D, 
						  0x00F6DBE3, 0x00F6DF49, 0x00F6F340, 0x00F6F3B7, 0x00F6F3E1, 0x00F6F411, 0x00F6F2A1, 0x00F6F2C8, 0x00F6F565, 0x00F6F599, 
						  0x00F6F5CD, 0x00F6F67E, 0x00F6F7D0, 0x00F6F845, 0x00F6F8BA, 0x00F6F92F, 0x00F6FA77, 0x00F6FAEF, 0x00F6FB67, 0x00F6FB94, 
						  0x00F6FC42, 0x00F70024, 0x00F7062E, 0x00F7061F, 0x00F706CA, 0x00F70875, 0x00F7085D, 0x00F714D1, 0x00F71551, 0x00F715FC, 
						  0x00F7164C, 0x00F716FD, 0x00F716DC, 0x00F7173D, 0x00F7171C, 0x00F7177D, 0x00F7175C, 0x00F717BD, 0x00F7179C, 0x00F7187D, 
						  0x00F7185C, 0x00F718BD, 0x00F7189C, 0x00F718FD, 0x00F718DC, 0x00F71AC2, 0x00F71ACE, 0x00F7CE7B, 0x00F8B1B5, 0x00FC2D0A, 
						  0x00FC2FCD, 0x00FC2FFC, 0x00FC33D3, 0x00FC33E0, 0x00FC3430, 0x00FC35FD, 0x00FC364D, 0x00FC370A, 0x00FC36BC, 0x00FC374A, 
						  0x00FC38AA, 0x00FC393A, 0x00FC3A0C, 0x00FC3A5C, 0x00FC3C18, 0x00FE15B6, 0x00782C42,
						  0x00BD9C49, 0x00BD9C5F, 0x00BF7303, 0x00BF73B7, 0x011714F6, 0x01171500, 0x01171510, 0x011715E6, 0x011715F0, 0x01171600, 
						  0x011717DA, 0x0117182B, 0x011722AE, 0x011722C9, 0x011723C6, 0x011723D5, 0x0117252F, 0x01172561, 0x01172570, 0x01172428, 
						  0x011724CA, 0x011724F2, 0x011725F1, 0x01172834, 0x01172844, 0x011728C7, 0x011728EE, 0x011729E4, 0x011729F4, 0x01172A77, 
						  0x01172A9E, 0x01172CDC, 0x01172D91, 0x01172D9E, 0x01172DC2, 0x011739FE, 0x01173A68, 0x01173ACB, 0x01173AFB, 0x01173B50, 
						  0x01173B5D, 0x01173B82, 0x01173F32, 0x01173EFF, 0x01174516, 0x0117454A, 0x011745A4, 0x011744FF, 0x0117553B, 0x01175561, 
						  0x011755B0, 0x011759C2, 0x01175BCF, 0x01176988, 0x011769D3, 0x01176CA3, 0x01177B66, 0x01177B4A, 0x01177BA6, 0x01177B8A, 
						  0x00401C05, 0x00401C31, 0x00401C4E, 0x00401C7D, 0x00401D32, 0x00401D52, 0x00401CEF, 0x00401E39, 0x00401E2A, 0x00401F2C, 
						  0x004021A8, 0x00406E2B, 0x004073A1, 0x0040941D, 0x0040C3C5, 0x0040C482, 0x0040D67F, 0x0040E753, 0x00412D9E, 0x00412456, 
						  0x00418011, 0x00417338, 0x0041DE5F, 0x0041E003, 0x0041E048, 0x0041DF81, 0x0041E1CF, 0x0041E221, 0x00421113, 0x004211FC, 
						  0x00421209, 0x00421249, 0x00422ED6, 0x0042227C, 0x00422334, 0x0042252B, 0x004229C9, 0x00422AB8, 0x00424B51, 0x00428D3D, 
						  0x00429666, 0x00429853, 0x0042B30A, 0x0042F80A, 0x0042F85C, 0x0042F92C, 0x0042F991, 0x0042F99E, 0x0042F9B1, 0x0043021C, 
						  0x004302A1, 0x004302AE, 0x004302D2, 0x0043031C, 0x004303AC, 0x0043042C, 0x0043048C, 0x00430843, 0x0043096C, 0x00430C3A, 
						  0x00430EF1, 0x00430F69, 0x00430F76, 0x00430F9E, 0x0043187D, 0x0043188A, 0x004318AF, 0x004319B1, 0x00433275, 0x004332D9, 
						  0x004333A3, 0x004334F5, 0x00433589, 0x00433681, 0x00433CB7, 0x00433CC4, 0x00434317, 0x00434607, 0x00434614, 0x00434639, 
						  0x004346DE, 0x004346EB, 0x0043472B, 0x00434A9E, 0x00434AAB, 0x00434AEB, 0x0043594D, 0x004359FD, 0x00435A57, 0x004373DB, 
						  0x004374E8, 0x0043753B, 0x00437603, 0x004376D3, 0x004377A3, 0x00437873, 0x00437A44, 0x00437B73, 0x00437BFE, 0x00438410, 
						  0x00438441, 0x004384FE, 0x0043855D, 0x00438A5A, 0x00438AB7, 0x0043BC6F, 0x0043BD3B, 0x0043BE0B, 0x0043C3CA, 0x0043C37C, 
						  0x0043C473, 0x0043C5B2, 0x0043C5D8, 0x0043D5B3, 0x0043D8C1, 0x0043D8CE, 0x0043D8E1, 0x0043D963, 0x0043D9CC, 0x0043DA1C, 
						  0x0043DAB9, 0x0043DAA9, 0x0043DAF1, 0x0043DAFE, 0x0043DB11, 0x0043DB91, 0x0043DB9E, 0x0043DBB1, 0x0043DC2C, 0x0043DDBC, 
						  0x0043DE3C, 0x0043E145, 0x0043E1BE, 0x00440AC6, 0x00440AEB, 0x00441A28, 0x00441F36, 0x004421C0, 0x00442950, 0x00445482, 
						  0x004454F9, 0x0044E7F6, 0x00450A43, 0x00450A5B, 0x004510E6, 0x00451468, 0x00451586, 0x00452CAD, 0x00452DB0, 0x004532D4, 
						  0x004540DC, 0x004541FC, 0x0045605C, 0x004596DE, 0x00459725, 0x00461CED, 0x004632FF, 0x004632BC, 0x0046354F, 0x0046350C, 
						  0x004635A9, 0x00463599, 0x0046383C, 0x004639E5, 0x004696BC, 0x00469879, 0x004698B0, 0x00470D6B, 0x00471C28, 0x00472266, 
						  0x004722D2, 0x004722DF, 0x00472303, 0x00473E93, 0x00473EC9, 0x00474948, 0x00474A62, 0x00474FFA, 0x00478FA2, 0x00479030, 
						  0x004790CE, 0x0047911C, 0x00479B5C, 0x0047A123, 0x0047A7EA, 0x0047A7F6, 0x0047A87D, 0x0047A8AC, 0x0047A8E6, 0x0047A8FC, 
						  0x0047A98A, 0x0047A996, 0x0047A9D4, 0x0047A9FF, 0x0047A6DF, 0x0047A6F5, 0x0047B65C, 0x0047CEB5, 0x0047E9BC, 0x0047E9C7, 
						  0x0047E9DD, 0x0047E9FB, 0x0047EA07, 0x0047EA4A, 0x0047EA9B, 0x00480A35, 0x004812FA, 0x0048158C, 0x004815DC, 0x00482072, 
						  0x00482191, 0x004832F2, 0x00483EA3, 0x00483F0A, 0x00485762, 0x004858E0, 0x00485BCF, 0x00485C1F, 0x004861AB, 0x0048619E, 
						  0x00487C32, 0x00487FFF, 0x0048A1D9, 0x0048A3FF, 0x0048A54A, 0x0048A5FC, 0x0048A99D, 0x0048AA33, 0x0048ABB1, 0x0048AE0D, 
						  0x0048AE5D, 0x0048AEAD, 0x0048B5A4, 0x0048CDE9, 0x0048CF57, 0x0048D0AC, 0x0048D33F, 0x0048D30E, 0x0048D5BE, 0x0048D487, 
						  0x0048D67E, 0x0048D73A, 0x0048DACA, 0x0048DCFC, 0x0048DD7C, 0x0048DEE2, 0x0048DF08, 0x0049020D, 0x004902C6, 0x0049036B, 
						  0x004903A9, 0x00490520, 0x0049056C, 0x0049066C, 0x004906B9, 0x00490869, 0x004908C4, 0x0049138B, 0x0049129D, 0x00491304, 
						  0x00491FD6, 0x0049926A, 0x004992BC, 0x00499879, 0x004A8A84, 0x004A89C6, 0x004AD51C, 0x004B3FEE, 0x004B707B, 0x004B708B, 
						  0x004B70A6, 0x004B7A1C, 0x004B7A4C, 0x004B7BD0, 0x004B7C0B, 0x004B804C, 0x004BBC23, 0x004C27E1, 0x004C2993, 0x004C29F9, 
						  0x004C2B8C, 0x004C2C91, 0x004C2CF8, 0x004C2D96, 0x004C2D4C, 0x004C2DCA, 0x004C2F2D, 0x004C2F9C, 0x004C2FFC, 0x004C47FD, 
						  0x004C488D, 0x004C491D, 0x004C962F, 0x004C9AEF, 0x004CE554, 0x004CE84F, 0x004CE8B6, 0x004D00FA, 0x004D014C, 0x004D2840, 
						  0x004D9060, 0x004DC69C, 0x004DC715, 0x004DC7EC, 0x004DC865, 0x004DCA11, 0x004DC9BC, 0x004E590F, 0x004E6503, 0x004E6CDB, 
						  0x004E7854, 0x004E7BB4, 0x004ECD6D, 0x004ECEDF, 0x004ECF02, 0x004ECF2A, 0x004ED35A, 0x004ED30C, 0x004F51D6, 0x004F543A, 
						  0x004F56FA, 0x004F59D1, 0x004F5BD6, 0x004F60FD, 0x004F6714, 0x004F6756, 0x004F673A, 0x004F69FC, 0x004F6CA5, 0x004F8F4B, 
						  0x004F9B06, 0x004F9E2E, 0x004FA4ED, 0x004FA66D, 0x004FAA7F, 0x004FAAAC, 0x004FAB03, 0x004FAD12, 0x004FAEC2, 0x004FB2ED, 
						  0x004FBC50, 0x004FC406, 0x004FC3EA, 0x004FC5C3, 0x004FCB4C, 0x004FCC31, 0x004FCC3E, 0x004FCC62, 0x004FE2F4, 0x0050B67F, 
						  0x0050B71B, 0x00510BA3, 0x00512616, 0x005127DC, 0x005182DC, 0x005190D9, 0x0051A297, 0x0051A67F, 0x0051BE9E, 0x0051C1C9, 
						  0x0051D669, 0x0051D7AC, 0x0051E3BD, 0x0051E607, 0x0051E62B, 0x0051E841, 0x0051E8AA, 0x0051ED2A, 0x0051EDBD, 0x0051F6AD, 
						  0x0051F6EE, 0x005200AA, 0x005230AD, 0x00523B78, 0x00523C5B, 0x00524261, 0x005242A0, 0x005242E9, 0x0052437C, 0x0052432F, 
						  0x0052613A, 0x0052628C, 0x005264FC, 0x0052A9A4, 0x0052EB73, 0x00534462, 0x00534B4F, 0x00534B81, 0x00534BBF, 0x0053DD88, 
						  0x005434BB, 0x005435EF, 0x00544604, 0x0054472A, 0x005451CC, 0x0054549D, 0x00545FD4, 0x0054B2D5, 0x0054FE5F, 0x0054FDCC, 
						  0x0054FEDA, 0x0054FE8C, 0x005518BF, 0x005519AE, 0x0055549F, 0x005559E4, 0x00555A31, 0x0055588F, 0x005573AA, 0x00557FDC, 
						  0x0055809C, 0x005582A0, 0x00558485, 0x0055B7DD, 0x0055C60E, 0x0055C71F, 0x0055C802, 0x0055C828, 0x0055DCBA, 0x0056015D, 
						  0x005601F9, 0x00560241, 0x005602A6, 0x005603CB, 0x00560419, 0x00560616, 0x0056078F, 0x005606EA, 0x00560773, 0x00560F9C, 
						  0x00560F8D, 0x00560FFB, 0x0056118A, 0x0056135C, 0x005613AC, 0x0056328A, 0x00563471, 0x00564629, 0x005648C5, 0x00564CBE, 
						  0x00565199, 0x00565189, 0x00565215, 0x00566051, 0x0056608F, 0x00566342, 0x00566A5A, 0x00566A0C, 0x00566AAC, 0x00566A9C, 
						  0x0056A204, 0x0056A221, 0x0056A242, 0x0057E220, 0x0058E656, 0x005912AB, 0x0059159E, 0x0059246E, 0x00592B9C, 0x0059E793, 
						  0x005A1FD0, 0x005A7752, 0x005A78D9, 0x005A90BD, 0x005A9A3D, 0x005A9A8A, 0x005A9ADC, 0x005A9BAC, 0x005A9DD7, 0x005AE88C, 
						  0x005B2E77, 0x005B2DF4, 0x005B6E62, 0x005BCFC9, 0x005BCFB9, 0x005BD5B5, 0x005BD819, 0x005BD809, 0x005C023A, 0x005C028C, 
						  0x005C0355, 0x005C0555, 0x005C085C, 0x005C0E33, 0x005C77F3, 0x005C838D, 0x005C8A30, 0x005C8B3E, 0x005C8C72, 0x005C8CF7, 
						  0x005CE853, 0x005CE93E, 0x005CF227, 0x005CF2A7, 0x005D041D, 0x005D0D15, 0x005D172B, 0x005D1795, 0x005D1673, 0x005D1965, 
						  0x005D1891, 0x005D18FB, 0x005D1CBD, 0x005D1CE4, 0x005D220A, 0x005D222A, 0x005D23AA, 0x005D262A, 0x005D267C, 0x005D26DC, 
						  0x005D272C, 0x005D281C, 0x005D286C, 0x005D292C, 0x005D297C, 0x005D2A2C, 0x005D2F41, 0x005D2F8D, 0x005D3257, 0x005D32A3, 
						  0x005D44C2, 0x005D4568, 0x005D460E, 0x005D637A, 0x005D6466, 0x005D64A4, 0x005D653E, 0x005D6320, 0x005D6731, 0x005D6798, 
						  0x005D6971, 0x005D6E44, 0x005D6D2A, 0x005D70FD, 0x005D8401, 0x005D8337, 0x005D86D7, 0x005D8524, 0x005D857B, 0x005D87EC, 
						  0x005D8835, 0x005D88C1, 0x005D8978, 0x005D8DA4, 0x005D8E35, 0x005DAB5D, 0x005DB00C, 0x005DB038, 0x005DB047, 0x005DB1DE, 
						  0x005DB1F1, 0x005DBA91, 0x005DC367, 0x005E2CB4, 0x005E2C8A, 0x005E2D6C, 0x005E48CC, 0x005E48BD, 0x005E4914, 0x005E48FD, 
						  0x005E6B51, 0x005E6B69, 0x005E6BF7, 0x005E6C98, 0x005E6CB0, 0x005E6D0B, 0x005E7B84, 0x005E7BF8, 0x005EACCB, 0x005EEED9, 
						  0x005EEEE9, 0x005EEF5C, 0x005EEFA3, 0x005EF69E, 0x005EFBDA, 0x005F0814, 0x005F05FE, 0x005F138E, 0x005F1730, 0x005F1965, 
						  0x005F1D18, 0x005F1D78, 0x005F22DC, 0x005F2E59, 0x005F2E49, 0x005F3D23, 0x005F3DD5, 0x005F5076, 0x005F5106, 0x005F58DE, 
						  0x005F59B7, 0x005F59F0, 0x005F5A0C, 0x005F60B2, 0x005F5D64, 0x005F6476, 0x005F6F7C, 0x005F7588, 0x005F8E76, 0x005F8F85, 
						  0x005F8F95, 0x005F8FE9, 0x005F9003, 0x005F7BD3, 0x005F8174, 0x005F83E5, 0x005F9C56, 0x005F9C6B, 0x005F9E2C, 0x005FA730, 
						  0x005FA7B1, 0x005FA8AE, 0x005FAAE2, 0x005FC3A0, 0x005FD6BF, 0x005FDF18, 0x005FE8E3, 0x005FEA43, 0x005FEF03, 0x005FF343, 
						  0x0060003A, 0x0060008C, 0x006002E1, 0x006002EE, 0x00600312, 0x0060113C, 0x0060121C, 0x00602D2C, 0x00605D04, 0x00605E0C, 
						  0x00606878, 0x00606A41, 0x00606C86, 0x00606D32, 0x00607059, 0x00606F92, 0x006072F3, 0x00607842, 0x006079CC, 0x00608181, 
						  0x0060823D, 0x006082CE, 0x00607F2F, 0x0060836C, 0x006083C8, 0x006084A8, 0x006085AC, 0x00608B8A, 0x006090B8, 0x006090DC, 
						  0x00609178, 0x0060919C, 0x0060921A, 0x0060926C, 0x006098EC, 0x0060B25E, 0x0060B287, 0x0060B2C3, 0x0060B2F2, 0x0060BDB2, 
						  0x0060BE4C, 0x0060BE59, 0x0060C2D2, 0x006151DD, 0x0061524A, 0x006152CC, 0x0061532C, 0x00620148, 0x0062544C, 0x0062EC3B, 
						  0x0062EC84, 0x0062F124, 0x0062F294, 0x0062F57C, 0x0062F663, 0x00633654, 0x00633C49, 0x00633C39, 0x00633D35, 0x00637B74, 
						  0x00637C00, 0x00637C0F, 0x00637C2D, 0x0063EDCA, 0x0063EE4A, 0x0064040C, 0x0064046C, 0x0064218A, 0x0064219D, 0x00644534, 
						  0x00644A8F, 0x0064709F, 0x006470DF, 0x00647491, 0x00647794, 0x0064724A, 0x00647A61, 0x00647C52, 0x0064816F, 0x00648AFB, 
						  0x00648B1A, 0x00649F59, 0x0064A79C, 0x0064AB7E, 0x0064CDBD, 0x0064D2C4, 0x0064D1BC, 0x0064D33E, 0x0064D9B1, 0x0064D96F, 
						  0x0064DA62, 0x0064F62C, 0x0064F81C, 0x0064F999, 0x0064F989, 0x0064FA7E, 0x0064FAFA, 0x0064FB53, 0x0064FC05, 0x0064FC6C, 
						  0x006522F8, 0x00652C20, 0x00652C53, 0x00652F9E, 0x0065308E, 0x0065316E, 0x006571D2, 0x00657E9F, 0x0065826A, 0x006582C3, 
						  0x0065841C, 0x0065846C, 0x0065BEEA, 0x0065BF30, 0x0065BECF, 0x0065C147, 0x0065C24D, 0x0065C53C, 0x0065C5C1, 0x0065C5CE, 
						  0x0065C5F2, 0x0065C641, 0x0065C64E, 0x0065C661, 0x0065C6E3, 0x0065C86B, 0x0065C8AC, 0x0065C95E, 0x0066340D, 0x0066344D, 
						  0x00663496, 0x0066C1D4, 0x0066CA50, 0x0066D573, 0x0066D898, 0x00670682, 0x0067178D, 0x0067201A, 0x0067206C, 0x006720BC, 
						  0x00673BEB, 0x0067BFCD, 0x0067CB83, 0x0067EB60, 0x0067FF7A, 0x006805D0, 0x00681DAE, 0x0068227F, 0x0068458A, 0x00684693, 
						  0x0068B0FA, 0x0068B34B, 0x0068B3AF, 0x0068B464, 0x0068B4EF, 0x0068B7DE, 0x0068BBE3, 0x0068C075, 0x0068C0B8, 0x0068C110, 
						  0x0068BFDE, 0x0068C339, 0x0068C384, 0x0068C4D3, 0x0068C637, 0x0068C79A, 0x0068C88A, 0x0068C9E1, 0x0068CD8D, 0x0068CE73, 
						  0x0068D00E, 0x0069239E, 0x006923F6, 0x006A7AC6, 0x006A7B41, 0x006A7BC1, 0x006AF824, 0x006B11A0, 0x006B4E2D, 0x006B545A, 
						  0x006B54AC, 0x006B5B02, 0x006B5B10, 0x006B59B5, 0x006B59CF, 0x006B5EFF, 0x006B60C7, 0x006B616D, 0x006B6304, 0x006B6244, 
						  0x006B65AF, 0x006B6490, 0x006B690C, 0x006B7A08, 0x006B7AE6, 0x006B692F, 0x006B7DC7, 0x006B6990, 0x006B8186, 0x006B82A9, 
						  0x006B6A15, 0x006B6B5F, 0x006B6D19, 0x006B6DA5, 0x006B6881, 0x006B7400, 0x006B769E, 0x006B93DC, 0x006B955C, 0x006B97DC, 
						  0x006B9AA3, 0x006B9B19, 0x006B9B09, 0x006B9B91, 0x006B9B9E, 0x006B9BC2, 0x006B9C11, 0x006B9C1E, 0x006B9C42, 0x006B9CC1, 
						  0x006B9CCE, 0x006B9CF2, 0x006B9D41, 0x006B9D4E, 0x006B9D72, 0x006B9EC1, 0x006B9ECE, 0x006B9EF2, 0x006B9F6C, 0x006B9FCC, 
						  0x006BA1A5, 0x006BA25C, 0x006BA2FC, 0x006BAC5A, 0x006BABD7, 0x006BAD51, 0x006BB12A, 0x006BB17C, 0x006BB23E, 0x006BB32E, 
						  0x006BB896, 0x006BB99D, 0x006BB9F6, 0x006BCAEA, 0x006BD510, 0x006BDE93, 0x006BE389, 0x006BE220, 0x006BE830, 0x006BE787, 
						  0x006BE7C0, 0x006BFF39, 0x006C0356, 0x006C065D, 0x006C06F7, 0x006C079D, 0x006C0AA1, 0x006C096E, 0x006C09C9, 0x006C20B5, 
						  0x006C2105, 0x006C27AE, 0x006C292C, 0x006C2660, 0x006C2B7C, 0x006C2C9B, 0x006C26BF, 0x006C2F42, 0x006C30C6, 0x006C3132, 
						  0x006C3425, 0x006C34BC, 0x006C356C, 0x006C368E, 0x006C38E4, 0x006C3B89, 0x006C3BCD, 0x006C3D87, 0x006C3FF9, 0x006C403D, 
						  0x006C4437, 0x006C439E, 0x006C4D23, 0x006C5001, 0x006C4F29, 0x006C5176, 0x006C515A, 0x006C57CC, 0x006C5DF8, 0x006C5E3C, 
						  0x006C5ED3, 0x006C653D, 0x006C65A0, 0x006C643F, 0x006C64D2, 0x006C6B7C, 0x006C6BB5, 0x006C6BEE, 0x006C6E16, 0x006C6E51, 
						  0x006C6E96, 0x006C6FE6, 0x006C720A, 0x006C725C, 0x006C72BC, 0x006C78FF, 0x006C7A9D, 0x006C7D40, 0x006C81EA, 0x006C822A, 
						  0x006C9DAE, 0x006C9F65, 0x006CB1A7, 0x006CB359, 0x006CB7F7, 0x006CB9A9, 0x006CC423, 0x006CCA9A, 0x006CCAEC, 0x006CCB7C, 
						  0x006CD77C, 0x006CD7FC, 0x006CDD3C, 0x006CDE9E, 0x006D200D, 0x006D2CC2, 0x006D2EE6, 0x006D2ECA, 0x006D2F23, 0x006D2F0C, 
						  0x006D347A, 0x006D350A, 0x006D44C8, 0x006D5802, 0x006D5B46, 0x006D5B2A, 0x006D5B83, 0x006D5B6C, 0x006D5BE3, 0x006D5BCC, 
						  0x006D693A, 0x006D6F12, 0x006D715C, 0x006D71C3, 0x006D71AC, 0x006D7223, 0x006D720C, 0x006D745B, 0x006D744A, 0x006D74CC, 
						  0x006D9375, 0x006D9853, 0x006D983C, 0x006D989C, 0x006DB0B1, 0x006DB74C, 0x006DB94A, 0x006DBA61, 0x006DBA6E, 0x006DBA92, 
						  0x006DBAE1, 0x006DBAEE, 0x006DBB12, 0x006DBBEC, 0x006DBC6C, 0x006DDD02, 0x006DDD28, 0x006DDE7C, 0x006DE07A, 0x006DE09A, 
						  0x006DE12C, 0x006DE211, 0x006DE21E, 0x006DE242, 0x006DE2EC, 0x006DE3CC, 0x006DF49C, /*0x006DF65A,*/ 0x006DF681, 0x006DF68E, 
						  0x006DF6B2, 0x006DF6FC, 0x006E0406, 0x006E06CC, 0x006E0DFE, 0x006E19B5, 0x006E1A06, 0x006E26C8, 0x006E28C9, 0x006E29DE, 
						  0x006E2E80, 0x006E2EA0, 0x006E3067, 0x006E30C4, 0x006E3450, 0x006E3848, 0x006E392E, 0x006E39D0, 0x006E3A32, 0x006E3A5E, 
						  0x006E3A90, 0x006E3AB9, 0x006E3AEA, 0x006E3B3F, 0x006E3C2A, 0x006E3CFA, 0x006E3D5D, 0x006E3DB0, 0x006E3DD2, 0x006E3E8B, 
						  0x006E3ECC, 0x006E3F29, 0x006E4302, 0x006E438F, 0x006E453E, 0x006E459B, 0x006E465C, 0x006E49B7, 0x006E49F4, 0x006E4BCB, 
						  0x006E5582, 0x006E55AC, 0x006E5861, 0x006E5891, 0x006E57FC, 0x006E5D7A, 0x006E602C, 0x006E6E19, 0x006E72AA, 0x006E761D, 
						  0x006E77BC, 0x006E787C, 0x006E7DB8, 0x006E8334, 0x006ECB63, 0x006ECCD4, 0x006ECD15, 0x006ECC5B, 0x006ECBDF, 0x006ECDDD, 
						  0x006ECE47, 0x006ED225, 0x006ED58B, 0x006ED7E1, 0x006ED880, 0x006ED8B1, 0x006ED8E8, 0x006EDA31, 0x006EEECA, 0x006EEF5A, 
						  0x006EF86C, 0x006EF8EC, 0x006EF94C, 0x006F56AA, 0x006F56E6, 0x006F5736, 0x006F5B1D, 0x006F5D5F, 0x006F99DA, 0x006F9AF1, 
						  0x006F9B72, 0x006FABBC, 0x006FDB4F, 0x006FEA9D, 0x006FEAED, 0x006FEB4D, 0x006FEC6A, 0x006FEC1C, 0x006FED1C, 0x006FF48C, 
						  0x006FF600, 0x006FF769, 0x00701AEF, 0x00701C46, 0x00701D31, 0x007023A2, 0x007026BD, 0x00702599, 0x0070289F, 0x00702944, 
						  0x00702BAC, 0x00702B5F, 0x00702EE3, 0x00702F63, 0x007030A3, 0x00703DB5, 0x00703DCB, 0x007041C8, 0x007041DE, 0x007042D6, 
						  0x007042EC, 0x007043AB, 0x007043C1, 0x00704492, 0x00704FF1, 0x00705071, 0x00705161, 0x00705211, 0x00705361, 0x00705401, 
						  0x007066D3, 0x00706795, 0x00706566, 0x007065D4, 0x007069C1, 0x00706CE3, 0x00706DF0, 0x00706F02, 0x00706FFD, 0x00707043, 
						  0x007071DA, 0x00707E91, 0x00707EFB, 0x0070802C, 0x00708331, 0x007087EF, 0x0070851F, 0x00708B28, 0x0070A319, 0x0070BC19, 
						  0x0070C0CC, 0x0070C1AC, 0x0070C22C, 0x0070C8BC, 0x0070CA4A, 0x0070CA9C, 0x0070ECD7, 0x0070EFAE, 0x0070F19C, 0x0070F2D5, 
						  0x0070F435, 0x0070F46D, 0x0070F52E, 0x0070F888, 0x0070FB4A, 0x0070FBDA, 0x0070FC2C, 0x0070FCAC, 0x0070FD2C, 0x0070FD8C, 
						  0x0070FE6C, 0x00711272, 0x00711C28, 0x00711E27, 0x00711D32, 0x007120AD, 0x007123C5, 0x007121F7, 0x00712A7E, 0x00713953, 
						  0x007137CC, 0x00713A9A, 0x00713AC3, 0x00713AFC, 0x00713BC6, 0x00713CC8, 0x00713D31, 0x00713D7B, 0x00713E3F, 0x007148D6, 
						  0x007148F6, 0x007149F6, 0x00714A9B, 0x00714AB2, 0x007147ED, 0x007147FC, 0x00714838, 0x00714B9C, 0x00714B8D, 0x00714F6F, 
						  0x0071525D, 0x007152FC, 0x00715186, 0x0071567D, 0x007156D3, 0x007157A6, 0x007155D3, 0x00715627, 0x0071557F, 0x007166CC, 
						  0x0071679C, 0x00716813, 0x0071748C, 0x00717550, 0x00718436, 0x00718476, 0x00718511, 0x0071853D, 0x007198F3, 0x00719ACC, 
						  0x00719DEC, 0x0071A2D8, 0x0071A3B8, 0x0071A77D, 0x0071A8E6, 0x0071AB70, 0x0071ADAC, 0x0071AF9D, 0x0071B121, 0x0071B143, 
						  0x0071B17B, 0x0071B3F1, 0x0071B538, 0x0071B54B, 0x0071B907, 0x0071B91A, 0x0071B93C, 0x0071BAD1, 0x0071B9AC, 0x0071BA32, 
						  0x0071BA43, 0x0071BA69, 0x0071C053, 0x0071C32A, 0x0071C3D3, 0x0071C452, 0x0071C4A2, 0x0071C4E1, 0x0071C613, 0x0071C6DD, 
						  0x0071C88F, 0x0071C99C, 0x0071CE5C, 0x0071CEDC, 0x0071CFDA, 0x0071D06C, 0x0071D1AC, 0x0071D2B1, 0x0071D2BE, 0x0071D2E2, 
						  0x0071D5EA, 0x0071D63A, 0x0071D7DC, 0x0071D83C, 0x0071D903, 0x0071DBAA, 0x0071DE09, 0x0071E015, 0x0071E155, 0x0071E2CF, 
						  0x0071EE69, 0x0071F05C, 0x0071F165, 0x0071F3DF, 0x007209CD, 0x007215F3, 0x0072163C, 0x0072164A, 0x00721721, 0x00721795, 
						  0x00721DAD, 0x00721E3D, 0x00721ECD, 0x0072248A, 0x007224DC, 0x007226FC, 0x0072348A, 0x007238E7, 0x0072390E, 0x00723856, 
						  0x00724211, 0x00724978, 0x007248A6, 0x00724BAD, 0x00724CB3, 0x00725EFF, 0x007263AD, 0x0072646A, 0x0072641C, 0x007264AA, 
						  0x0072653D, 0x00726783, 0x0072688D, 0x007271BC, 0x0072720C, 0x007276A3, 0x007286E6, 0x0072870C, 0x00728779, 0x00729544, 
						  0x00729A1D, 0x00729B74, 0x00729BF4, 0x00729C74, 0x00729CF4, 0x00729D8D, 0x00729E1D, 0x00729EAD, 0x00729F3D, 0x00729FCD, 
						  0x0072A05D, 0x0072B1D2, 0x0072B1F8, 0x0072B23C, 0x0072D610, 0x0072D679, 0x0073066C, 0x00731825, 0x00731D62, 0x00732FB2, 
						  0x007366BE, 0x00738115, 0x00738E21, 0x007391FC, 0x0073C9AA, 0x0073D7DA, 0x0073F895, 0x0073F9D8, 0x0073FA1E, 0x0073FAEA, 
						  0x0073FB3C, 0x0073FBC3, 0x00741C9D, 0x00741C2B, 0x007459BD, 0x00745A71, 0x0074A700, 0x0074A725, 0x0074A6AE, 0x0074AA31, 
						  0x0074ADB5, 0x0074ADE1, 0x0074AE66, 0x0074ACC3, 0x0074B866, 0x0074B9ED, 0x0074BA77, 0x0074BAB8, 0x0074BC60, 0x0074BCA2, 
						  0x0074C380, 0x0074C3C7, 0x0074C490, 0x0074C6B3, 0x0074C8E4, 0x0074D2EE, 0x0074D9AA, 0x0074DA2A, 0x0074DD1A, 0x0074DDDC, 
						  0x0074DE2C, 0x0074DE7C, 0x0074DEFC, 0x0074E0DC, 0x0074E1BA, 0x0074E20C, 0x00751215, 0x00754FC7, 0x00755C71, 0x00755C1C, 
						  0x00755D11, 0x00755CBC, 0x00755D5C, 0x00755F53, 0x007560DA, 0x0075619C, 0x00756333, 0x007563D8, 0x007587EC, 0x0075A0BC, 
						  0x0075A0CB, 0x0075EE01, 0x00760691, 0x0076055E, 0x00767BCD, 0x0076CEE7, 0x0076EF6A, 0x00770A09, 0x007709F9, 0x00770AD9, 
						  0x00770AC9, 0x00770F85, 0x00771015, 0x0077125B, 0x0077124A, 0x00777457, 0x00777486, 0x007778BC, 0x00777B41, 0x00777AEF, 
						  0x00778181, 0x0077812F, 0x00778845, 0x00778F3A, 0x00779045, 0x007790D6, 0x00779173, 0x0077963C, 0x0077980C, 0x0077B5A6, 
						  0x0077B787, 0x0077BF7C, 0x0077C08A, 0x0077C0DC, 0x0077CB01, 0x0077CB48, 0x0077E632, 0x0077E602, 0x0077E937, 0x0077F83D, 
						  0x0077F8B5, 0x0077F925, 0x0077F999, 0x0077FCB3, 0x00780B42, 0x00780ECA, 0x00780F4A, 0x0078107A, 0x007812DC, 0x0078132C, 
						  0x0078137C, 0x007813CC, 0x0078144C, 0x0078157C, 0x0079539A, 0x0079534C, 0x007953DA, 0x007954F2, 0x00795518, 0x00795572, 
						  0x00795598, 0x0079593A, /*0x00795ADA,*/ 0x00795C9C, 0x00795DFC, 0x00796AB5, 0x0079B5EB, 0x0079B75D, 0x0079E5AE, 0x0079E655, 
						  0x0079EC6D, 0x007A455E, 0x007A647D, 0x007AFEBD, 0x007AFEFA, 0x007AFF4C, 0x007B7110, 0x007B7773, 0x007BAEB5, 0x007C007C, 
						  0x007C52FD, 0x007C5808, 0x007C8392, 0x007C83EB, 0x007C8511, 0x007CBA2F, 0x007CCA8D, 0x007CE048, 0x007D1709, 0x007D22AE, 
						  0x007D25E9, 0x007D29A7, 0x007D306F, 0x007D3777, 0x007D497C, 0x007D9A94, 0x007E0E64, 0x007E0F4A, 0x007E2E8A, 0x007E3E2A, 
						  0x007E5AE4, 0x007E5BED, 0x007E5C64, 0x007E5D44, 0x007E61C6, 0x007E61AA, 0x007E64C4, 0x007E6575, 0x007E6635, 0x007E6985, 
						  0x007E7F38, 0x007E8B9D, 0x007E8C7D, 0x007E8D7D, 0x007E8E0D, 0x007E8E9D, 0x007E8F2D, 0x007E9CB3, 0x007EA63B, 0x007F4EF5, 
						  0x007F765B, 0x007F7E59, 0x007F9C81, 0x007F9C8D, 0x007FB9EB, 0x007FE71F, 0x007FFD9C, 0x0080478C, 0x008047AF, 0x008049A3, 
						  0x008049C6, 0x00804B19, 0x00804B09, 0x00804C15, 0x00806791, 0x00807926, 0x0080F609, 0x0080F5F9, 0x0080F643, 0x0080F6D3, 
						  0x0080F915, 0x00813A84, 0x00817DAD, 0x00818095, 0x008181BE, 0x0081B4C4, 0x0081C8D2, 0x0081C8FC, 0x00820BBD, 0x00820F00, 
						  0x0082CDAE, 0x00832749, 0x00839B73, 0x00839C08, 0x0083A0EF, 0x00838A70, 0x00838F68, 0x0083C192, 0x0083DEDA, 0x0083DE8C, 
						  0x0083DF1A, 0x0083E1A2, 0x0083E408, 0x0083E8D9, 0x0083E8C9, 0x0083EA0C, 0x0083EA7C, 0x0083EACC, 0x0083EB5C, 0x0083EC6E, 
						  0x0083EE15, 0x0083EECC, 0x0083EF7E, 0x0083F2E5, 0x0083F7EF, 0x0083F818, 0x0083F90E, 0x0083FFF8, 0x0084097F, 0x00844595, 
						  0x008447D6, 0x008488B5, 0x00848A2B, 0x00848D77, 0x00848DA4, 0x00848E0C, 0x00848E3F, 0x00848E5A, 0x0084A45D, 0x0084A5A9, 
						  0x0084BAA9, 0x0084BB21, 0x0084DDF4, 0x00850CB4, 0x00854CC4, 0x008554AC, 0x0085555A, 0x0085565D, 0x00855803, 0x008558AC, 
						  0x0085592C, 0x00856FC1, 0x00856FFD, 0x0085716A, 0x008571BC, 0x008572CC, 0x0085733C, 0x008591FD, 0x0085A60C, 0x00860DE2, 
						  0x00860E7B, 0x00861128, 0x00861CC3, 0x00861BE2, 0x0086493F, 0x00864CAA, 0x00865161, 0x00865BB0, 0x00867DD7, 0x00867F38, 
						  0x008672B3, 0x008675A3, 0x008679C4, 0x00867A86, 0x00867B2D, 0x0086CB48, 0x0086CCDF, 0x0086CF1A, 0x0086DC27, 0x0086E010, 
						  0x0086E1F4, 0x0086E214, 0x0086E280, 0x0086E290, 0x00874003, 0x0087461B, 0x0087447E, 0x0087469D, 0x00875695, 0x008761A3, 
						  0x0087624E, 0x00876376, 0x00876458, 0x008764EB, 0x00876B0A, 0x008782AD, 0x008784E1, 0x0087848C, 0x00878B97, 0x00878BF7, 
						  0x00878C7D, 0x00878E22, 0x00878E48, 0x0087926A, 0x0087921C, 0x00879454, 0x008796E4, 0x0087A3CC, 0x0087A43C, 0x0087A4C8, 
						  0x0087A4EC, 0x0087A7BA, 0x0087A80C, 0x0087A8BC, 0x0087A94C, 0x0087AAA3, 0x0087AEA1, 0x0087AEAE, 0x0087AED2, 0x0087B01C, 
						  0x0087B80C, 0x0087B8BD, 0x0087C2C0, 0x0087F3C0, 0x0087F3D4, 0x0087FE38, 0x0087FE7A, 0x00880049, 0x0088008B, 0x00880279, 
						  0x008802BB, 0x00880700, 0x0088089D, 0x00880508, 0x00880BD4, 0x00880BF4, 0x00880D17, 0x00880E41, 0x0088106A, 0x0088109C, 
						  0x008810B0, 0x008819AD, 0x00881CD7, 0x00881CF7, 0x00881D70, 0x00881F61, 0x008823B3, 0x00882466, 0x00882EE3, 0x00883466, 
						  0x00883047, 0x00883838, 0x00883904, 0x00883A9E, 0x00883B9E, 0x00883EC5, 0x008840BC, 0x0088421C, 0x0088478A, 0x0088483A, 
						  0x008848F1, 0x008849BA, 0x0088511D, 0x00885481, 0x00885568, 0x00885867, 0x008858EE, 0x00885A2E, 0x00885B10, 0x00885B69, 
						  0x00885DAF, 0x00885FED, 0x0088675E, 0x0088683E, 0x00887514, 0x00887784, 0x008878E5, 0x00887C04, 0x008887DB, 0x00888BB1, 
						  0x00888C10, 0x00889341, 0x00889488, 0x00889611, 0x008896A1, 0x00889731, 0x008897B1, 0x00889BC3, 0x00889FF1, 0x0088A231, 
						  0x0088A301, 0x0088A621, 0x0088A5CC, 0x0088A66A, 0x0088AC6E, 0x0088AC7F, 0x0088ADAE, 0x0088ADBF, 0x0088B1AF, 0x0088B371, 
						  0x0088B491, 0x0088B5B1, 0x0088B6D1, 0x0088B90A, 0x0088BAEC, 0x0088BB4C, 0x0088C003, 0x008912A6, 0x0089135E, 0x00891885, 
						  0x00891A69, 0x00891A59, 0x00891B9A, 0x00891CC1, 0x00891CCE, 0x00891CF2, 0x00891EA5, 0x00891F7C, 0x00891FFC, 0x008937BA, 
						  0x008937DD, 0x008936C8, 0x00894191, 0x0089454D, 0x0089456D, 0x008946E3, 0x00894F3E, 0x008951A0, 0x008950B7, 0x008950DD, 
						  0x0089526D, 0x008956EA, 0x00895862, 0x008958D9, 0x008959B2, 0x008959D8, 0x00895A62, 0x00895A88, 0x00895AE2, 0x00895B59, 
						  0x0089643C, 0x0089679C, 0x0089685C, 0x008968BC, 0x00896CAC, 0x0089748C, 0x00897551, 0x0089755E, 0x00897582, 0x008975D1, 
						  0x008975DE, 0x00897602, 0x0089773C, 0x0089A9EC, 0x0089AA4C, 0x0089AAAC, 0x0089AB0C, 0x0089AB6C, 0x0089ABCC, 0x0089AC2C, 
						  0x0089CFF4, 0x008A5619, 0x008A880B, 0x008A8B73, 0x008A8EB3, 0x008A8FCC, 0x008A9051, 0x008A905E, 0x008A9082, 0x008A97A6, 
						  0x008A97D5, 0x008A99F1, 0x008A9BBE, 0x008AA212, 0x008AB82C, 0x008ABD33, 0x008ABF08, 0x008AC1BE, 0x008AC1EC, 0x008AC74F, 
						  0x008ACBC0, 0x008ACAA7, 0x008ACAD5, 0x008ACB44, 0x008ACD0E, 0x008ACE67, 0x008AD17B, 0x008AD30B, 0x008AE28A, 0x008AE62F, 
						  0x008AFA26, 0x008AFD08, 0x008AFF0C, 0x008AFF8C, 0x008B0897, 0x008B091B, 0x008B0935, 0x008B1080, 0x008B11EE, 0x008B12A2, 
						  0x008B13FF, 0x008B12E7, 0x008B1727, 0x008B17F5, 0x008B1862, 0x008B1985, 0x008B19C2, 0x008B1ACB, 0x008B1DCE, 0x008B1E6A, 
						  0x008B1F5C, 0x008B206C, 0x008B28CF, 0x008B2A7B, 0x008B2ABC, 0x008B2E2B, 0x008B30C3, 0x008B323F, 0x008B376C, 0x008B3666, 
						  0x008B3DE3, 0x008B3E01, 0x008B3F62, 0x008B3F82, 0x008B3F1F, 0x008B8ABC, 0x008C02BD, 0x008C05A8, 0x008C06C4, 0x008C0804, 
						  0x008C0BAF, 0x008C0D87, 0x008C0FCF, 0x008C12DA, 0x008C13CC, 0x008C142C, 0x008C1CF6, 0x008C1DD6, 0x008C22C2, 0x008C22E1, 
						  0x008C3D32, 0x008C4097, 0x008C42A4, 0x008C48C5, 0x008C4B46, 0x008C5694, 0x008C7170, 0x008C7290, 0x008C7423, 0x008C74D8, 
						  0x008C74FC, 0x008C93BC, 0x008CA311, 0x008D2211, 0x008D39E5, 0x008D7D4F, 0x008DA7D0, 0x008DA8C2, 0x008DA981, 0x008DA6F3, 
						  0x008DAA34, 0x008E23EE, 0x008E52AC, 0x008E5308, 0x008E532C, 0x008E6F1A, 0x008E722B, 0x008E71A8, 0x008E71CE, 0x008E8205, 
						  0x008EE6A4, 0x008EE6E0, 0x008EE723, 0x008EF441, 0x008EF4D4, 0x008EF8FD, 0x008EFA21, 0x008EFD85, 0x008EFE3E, 0x008EFEF1, 
						  0x008EFF91, 0x008F0071, 0x008F014F, 0x008F08BF, 0x008F095C, 0x008F07FC, 0x008F0ED7, 0x008F1309, 0x008F12F9, 0x008F14B5, 
						  0x008F19E2, 0x008F1A7E, 0x008F18DA, 0x008F1924, 0x008F1B18, 0x008F1B68, 0x008F1DF8, 0x008F1C51, 0x008F1CC0, 0x008F1EBE, 
						  0x008F1F07, 0x008F2130, 0x008F266A, 0x008F268A, 0x008F272B, 0x008F33C5, 0x008F356A, 0x008F41FA, 0x008F48B2, 0x008F4AF7, 
						  0x008F4C72, 0x008F4C98, 0x008F4FDA, 0x008F502C, 0x008F50CC, 0x008F6E91, 0x008F7028, 0x008F7098, 0x008F7341, 0x008F73CB, 
						  0x008F75CC, 0x008F756F, 0x008F7AC8, 0x008F7BC0, 0x008F79BC, 0x008F7CDE, 0x008F7D50, 0x008F7A3B, 0x008F90CB, 0x008F90DF, 
						  0x008F9B08, 0x008FA0DC, 0x008FA372, 0x008FA483, 0x008FA112, 0x008FA13D, 0x008FA711, 0x008FA875, 0x008FA954, 0x008FAB24, 
						  0x008FAA10, 0x008FABC4, 0x008FAC9B, 0x008FAE74, 0x008FBD37, 0x008FBF29, 0x008FBFBF, 0x008FBDA6, 0x008FC62F, 0x008FC57F, 
						  0x008FC9FA, 0x008FCDEA, 0x008FD049, 0x008FD039, 0x008FD0CA, 0x008FD15C, 0x008FD27C, 0x008FD2D8, 0x008FD2FC, 0x008FD37C, 
						  0x008FD3FC, 0x008FD4BC, 0x008FD56C, 0x008FD5EC, 0x008FD671, 0x008FD67E, 0x008FD6A2, 0x008FD845, 0x008FD88C, 0x008FE105, 
						  0x008FE764, 0x008FEB72, 0x008FEC7C, 0x008FEACB, 0x008FEB30, 0x008FF174, 0x008FF830, 0x008FF8A0, 0x00900AF1, 0x00900C51, 
						  0x00900D61, 0x00900F31, 0x00901094, 0x009011A7, 0x0090150D, 0x00901636, 0x0090187E, 0x00901746, 0x00901789, 0x00901966, 
						  0x00901BB8, 0x00901CC6, 0x00901E58, 0x00901F49, 0x0090203B, 0x0090221D, 0x009023E9, 0x00902493, 0x00902501, 0x00902570, 
						  0x009030EA, 0x009031C9, 0x009031B9, 0x00903259, 0x0090327F, 0x0090323C, 0x009033E9, 0x0090340F, 0x009033CC, 0x009035C3, 
						  0x0090379C, 0x0090382C, 0x009038CC, 0x00903923, 0x009039C3, 0x00903AA5, 0x00903C8C, 0x00903F8E, 0x0090405E, 0x00904204, 
						  0x00908551, 0x0090A4E6, 0x00919E3C, 0x0091CE0C, 0x0091CE19, 0x0091CE53, 0x0091D374, 0x0091DC6E, 0x0091DCD9, 0x0091E014, 
						  0x0091E5CC, 0x0091E6A3, 0x0091E711, 0x0091E71E, 0x0091E742, 0x0091F206, 0x0091F666, 0x0091FB60, 0x0091FABB, 0x0091FAE1, 
						  0x0091FDDA, 0x0091FE49, 0x0092039E, 0x0092059F, 0x009205C3, 0x009206CB, 0x00920717, 0x009208A1, 0x00920903, 0x00920949, 
						  0x009209D5, 0x00920AAF, 0x00920B08, 0x00920C57, 0x00920D91, 0x00921E3D, 0x00921E54, 0x00921E0D, 0x0092203D, 0x00922054, 
						  0x0092200D, 0x009222C1, 0x0092222C, 0x0092235C, 0x0092240C, 0x009225DB, 0x0092261C, 0x009226CD, 0x00922751, 0x009226FC, 
						  0x009227EC, 0x00922B61, 0x00922B6E, 0x00922B92, 0x00922C81, 0x00922C8E, 0x00922CB2, 0x00922D8C, 0x00922EAE, 0x00922FFE, 
						  0x0092336D, 0x009233A8, 0x00924C99, 0x00924CEF, 0x009252D4, 0x009258B3, 0x00926478, 0x0092678F, 0x0092677C, 0x009268A8, 
						  0x00927CA9, 0x00927EE8, 0x00928CFE, 0x009290B5, 0x0092BE4B, 0x0092BE65, 0x0092ECA1, 0x0092EACA, 0x00932AAE, 0x00932A6F, 
						  0x00932C72, 0x00932D6E, 0x00932E4E, 0x00932E6C, 0x00932E99, 0x00932EDD, 0x00932FE8, 0x00933192, 0x00933320, 0x009338BA, 
						  0x009341FE, 0x0093420A, 0x00934332, 0x009345E1, 0x00934865, 0x0093480C, 0x009349AF, 0x009349E8, 0x00934A74, 0x009355F8, 
						  0x009356F8, 0x00935718, 0x009357CD, 0x00935849, 0x00935A94, 0x00935F8A, 0x00936073, 0x009360FC, 0x00936501, 0x00936553, 
						  0x009368D1, 0x00936930, 0x009369B1, 0x00936B93, 0x00936BBC, 0x00936EDB, 0x00936F63, 0x00937F1F, 0x009395DE, 0x00939618, 
						  0x00939632, 0x0093967D, 0x00939B11, 0x0093AD9A, 0x0093AE2C, 0x0093BADC, 0x0093BBB9, 0x0093BBA9, 0x0093C775, 0x0093CB5B, 
						  0x0093CB4A, 0x0093F3BB, 0x0093F469, 0x009480F9, 0x0094814F, 0x00948684, 0x00948D09, 0x00948D5F, 0x00949224, 0x009496E2, 
						  0x0094A90D, 0x0094D019, 0x0094D06F, 0x0094D564, 0x0094EE7E, 0x0094F218, 0x00954799, 0x009547EF, 0x00954CE4, 0x00955299, 
						  0x009552EF, 0x009557B4, 0x00956EF6, 0x0095716A, 0x0095B7A9, 0x0095B7FF, 0x0095BD44, 0x0095C239, 0x0095C28F, 0x0095C754, 
						  0x0095E256, 0x0095E81B, 0x0095ED59, 0x0095FA09, 0x00960705, 0x009608AC, 0x0096089C, 0x00967A28, 0x00967BA9, 0x00967BD2, 
						  0x00967CBD, 0x00967D00, 0x00968063, 0x00968095, 0x009682DA, 0x00968206, 0x0096841A, 0x0096844A, 0x00968526, 0x0096884A, 
						  0x009689F3, 0x00968C2A, 0x00968CBC, 0x0096906C, 0x00969CF3, 0x0096BA29, 0x0096BA7F, 0x0096BF94, 0x0096C4A9, 0x0096C4FF, 
						  0x0096CA14, 0x00971BED, 0x00976669, 0x009766BF, 0x00976BB4, 0x00976E56, 0x009771D9, 0x0097722F, 0x00977724, 0x0097C074, 
						  0x0097E06C, 0x0097E0F3, 0x0097E93A, 0x0097E9CF, 0x0097EDCA, 0x0097EEA1, 0x0097F49A, 0x0097F6A3, 0x009800C2, 0x009800E8, 
						  0x0098050C, 0x0098058C, 0x00981417, 0x009814B5, 0x00981BCC, 0x00981FDC, 0x00982053, 0x00981E4E, 0x00981EAB, 0x00981EC2, 
						  0x00981EFC, 0x00982125, 0x009823E4, 0x009829AB, 0x00982E79, 0x00982FC2, 0x0098315B, 0x009831E7, 0x0098345F, 0x009834C6, 
						  0x00983598, 0x009832C2, 0x00983328, 0x00983AF6, 0x00983B79, 0x009839D2, 0x00983A38, 0x00983D6A, 0x00983D8A, 0x00983E0A, 
						  0x009848A1, 0x009848AE, 0x009848D2, 0x00984959, 0x00984949, 0x009849E3, 0x00984ACC, 0x00984B4C, 0x00984BE5, 0x00984C5E, 
						  0x00984F72, 0x00985CA1, 0x00985CD0, 0x00985ED1, 0x00985F25, 0x00986025, 0x0098638F, 0x009862AA, 0x00986324, 0x0098690A, 
						  0x00986B0A, 0x00986B5C, 0x00986C1C, 0x00986C7A, 0x00986CCC, 0x00986E11, 0x00986E1E, 0x00986E42, 0x00986E93, 0x009874B4, 
						  0x009880FA, 0x0098827A, 0x0098AD02, 0x0098AD28, 0x0098AF72, 0x0098AF98, 0x0098AFF2, 0x0098B018, 0x0098B072, 0x0098B098, 
						  0x0098B0F2, 0x0098B118, 0x0098B172, 0x0098B198, 0x0098B1F2, 0x0098B218, 0x0098BB2C, 0x0098BBAC, 0x0099562F, 0x00996623, 
						  0x0099BE7D, 0x0099C8A9, 0x0099C899, 0x0099CD45, 0x0099FB0A, 0x0099FB9C, 0x0099FC0C, 0x009A06EF, 0x009A0762, 0x009A16A6, 
						  0x009A4C2B, 0x009A55A9, 0x009A5599, 0x009A5AF5, 0x009A7AFA, 0x009A8195, 0x009A8229, 0x009A84B2, 0x009A8694, 0x009A8DF5, 
						  0x009A8E76, 0x009A8FE2, 0x009A92A2, 0x009A9493, 0x009A9510, 0x009A98BC, 0x009A98FB, 0x009AA8EE, 0x009AA900, 0x009AAFDB, 
						  0x009AB068, 0x009AAF5C, 0x009AB464, 0x009AB626, 0x009AC73F, 0x009AC9B2, 0x009ACE86, 0x009AD0C7, 0x009AD144, 0x009AD352, 
						  0x009AD849, 0x009ADBE2, 0x009ADE12, 0x009AE0BA, 0x009AECC6, 0x009AEEA7, 0x009AF106, 0x009AEFDC, 0x009AEFEE, 0x009AF083, 
						  0x009AF1EF, 0x009AFC61, 0x009AFCC0, 0x009AF6C9, 0x009AFED2, 0x009AFF28, 0x009AFFFA, 0x009B0065, 0x009B032A, 0x009B03CB, 
						  0x009B037F, 0x009B046A, 0x009B0663, 0x009B0B29, 0x009B0A29, 0x009B0CA2, 0x009B0DB7, 0x009B0DEA, 0x009B0E96, 0x009B0F19, 
						  0x009B0D16, 0x009B0D7D, 0x009B10A3, 0x009B0F8A, 0x009B0FBB, 0x009B120D, 0x009B1480, 0x009B14F0, 0x009B1ED9, 0x009B1EC9, 
						  0x009B2209, 0x009B252A, 0x009B2729, 0x009B2719, 0x009B2949, 0x009B2B49, 0x009B31F9, 0x009B31E9, 0x009B335A, 0x009B3573, 
						  0x009B38F3, 0x009B39A9, 0x009B3999, 0x009B3A79, 0x009B3E4C, 0x009B3F15, 0x009B3FDD, 0x009B404C, 0x009B40AC, 0x009B4315, 
						  0x009B437D, 0x009B43DC, 0x009B44A5, 0x009B452C, 0x009B45BC, 0x009B4795, 0x009B4873, 0x009B4C2C, 0x009B4CF3, 0x009B4D8E, 
						  0x009B4F2E, 0x009B50BB, 0x009B50AA, 0x009B6DE3, 0x009B7D66, 0x009B803E, 0x009B7F1A, 0x009B7FEB, 0x009B840E, 0x009B898A, 
						  0x009B8E1C, 0x009BA6F5, 0x009BA741, 0x009BA87B, 0x009BA8EF, 0x009BA95D, 0x009BA9E7, 0x009BAA52, 0x009BACFD, 0x009BAECA, 
						  0x009BB10C, 0x009BB1EC, 0x009BB258, 0x009BB283, 0x009BB2EC, 0x009BD95B, 0x009BD975, 0x009BDAC4, 0x009BD86D, 0x009BE055, 
						  0x009C0344, 0x009C03F7, 0x009C084C, 0x009C12F8, 0x009C2D2D, 0x009C2DF1, 0x009C2D9C, 0x009C2E3A, 0x009C2FBE, 0x009C306A, 
						  0x009C301C, 0x009C30B9, 0x009C30A9, 0x009C314A, 0x009C319C, 0x009C328C, 0x009C32EC, 0x009C336A, 0x009C33BC, 0x009C343C, 
						  0x009C34E5, 0x009C3692, 0x009C36B8, 0x009C36FC, 0x009C44CC, 0x009C4AA2, 0x009C4CF2, 0x009C5C76, 0x009C8FB0, 0x009C9811, 
						  0x009C9CB1, 0x009C9CC1, 0x009C9CE4, 0x009CBDBC, 0x009CBD5C, 0x009CBD96, 0x009CD5A4, 0x009CD77E, 0x009CD798, 0x009CDDE9, 
						  0x009CDDD9, 0x009CDE29, 0x009CDE19, 0x009CDEA5, 0x009CDF35, 0x009D12DC, 0x009D15D7, 0x009D1443, 0x009D13FF, 0x009D16D7, 
						  0x009D1746, 0x009D3190, 0x009D5169, 0x009D5159, 0x009D5515, 0x009D9B0D, 0x009D9FE7, 0x009DA0A5, 0x009DA0ED, 0x009DA13E, 
						  0x009DA347, 0x009DA219, 0x009DA462, 0x009DA488, 0x009DA513, 0x009DD4B2, 0x009DE259, 0x009DE529, 0x009DE6E9, 0x009DECC9, 
						  0x009DEE72, 0x009DF159, 0x009DF659, 0x009DFA69, 0x009DFE89, 0x009E026D, 0x009E0285, 0x009E01FC, 0x009E020F, 0x009E0222, 
						  0x009E023A, 0x009E07B8, 0x009E07C8, 0x009E0A5D, 0x009E0A70, 0x009E0A89, 0x009E0AA1, 0x009E0AD4, 0x009E0AEC, 0x009E0D18, 
						  0x009E0FA2, 0x009E0FB0, 0x009E1035, 0x009E13C1, 0x009E1410, 0x009E145F, 0x009E1FBD, 0x009E2156, 0x009E3283, 0x009E3331, 
						  0x009E33AE, 0x009E352A, 0x009E35B9, 0x009E37BA, 0x009E3DC0, 0x009E3E3D, 0x009E55D6, 0x009E2641, 0x009E2755, 0x009E285F, 
						  0x009E2AB9, 0x009E2AD3, 0x009E22BA, 0x009E2C87, 0x009E2D1E, 0x009E2E25, 0x009E2F11, 0x009E2FF9, 0x009E3090, 0x009E3197, 
						  0x009E5F6A, 0x009E6B7A, 0x009E6BCA, 0x009E6C1A, 0x009E6C7A, 0x009E6DFD, 0x009E7108, 0x009E7123, 0x009E7909, 0x009E78F9, 
						  0x009E793C, 0x009E798C, 0x009E7A0C, 0x009E7AAC, 0x009E7AFE, 0x009E7B8A, 0x009E7BDC, 0x009E7EB5, 0x009E7FC2, 0x009E7FE8, 
						  0x009E802C, 0x009E8EE5, 0x009E8F36, 0x009E9FE1, 0x009EB1E0, 0x009EB2E0, 0x009EB30A, 0x009EB331, 0x009EB4AA, 0x009F00A2, 
						  0x009F0350, 0x009F03FF, 0x009F04D9, 0x009F05F7, 0x009F06D6, 0x009F0D4A, 0x009F0DB2, 0x009F0DD8, 0x009F0E5A, 0x009F0F3E, 
						  0x009F12AE, 0x009F15E1, 0x009F1C0F, 0x009F1D7C, 0x009F1DCC, 0x009F1E4A, 0x009F1E9C, 0x009F1F1C, 0x009F1F9C, 0x009F20E1, 
						  0x009F20EE, 0x009F2112, 0x009F21BC, 0x009F222C, 0x009F2D2A, 0x009F2DE1, 0x009F2D8C, 0x009F2EE9, 0x009F2ED9, 0x009F2F8C, 
						  0x009F3055, 0x009F469B, 0x009F491E, 0x009F56CA, 0x009F571C, 0x009F57CC, 0x009F6AC8, 0x009F767D, 0x009FB46B, 0x009FB4A6, 
						  0x009FB5FA, 0x009FB990, 0x009FBA33, 0x009FBACE, 0x009FBBB8, 0x009FC97A, 0x009FC99A, 0x009FCF6C, 0x009FD08C, 0x009FD9BA, 
						  0x009FDA0F, 0x00A0020E, 0x00A000BC, 0x00A00570, 0x00A005A6, 0x00A004C5, 0x00A00502, 0x00A00929, 0x00A00BE7, 0x00A00C97, 
						  0x00A00AB3, 0x00A012CC, 0x00A0135C, 0x00A013F3, 0x00A03092, 0x00A030C4, 0x00A031A9, 0x00A031BD, 0x00A031F6, 0x00A032F9, 
						  0x00A03E5E, 0x00A03E96, 0x00A0435A, 0x00A0760D, 0x00A0766D, 0x00A078F3, 0x00A07CF9, 0x00A08004, 0x00A08072, 0x00A080E0, 
						  0x00A082A9, 0x00A08483, 0x00A084F9, 0x00A084E9, 0x00A0858C, 0x00A08655, 0x00A087B9, 0x00A087AA, 0x00A08A24, 0x00A08CCE, 
						  0x00A0A24D, 0x00A0D827, 0x00A0D937, 0x00A0D9E7, 0x00A0E34F, 0x00A0E848, 0x00A0E88A, 0x00A0FB7A, 0x00A1068C, 0x00A10A3A, 
						  0x00A10A8C, 0x00A1141C, 0x00A19BD2, 0x00A19C23, 0x00A1B538, 0x00A1C1B7, 0x00A1C21F, 0x00A1E0AD, 0x00A1E0DC, 0x00A1E403, 
						  0x00A21DE5, 0x00A21EC3, 0x00A22171, 0x00A222DF, 0x00A2253D, 0x00A22791, 0x00A249FA, 0x00A255FC, 0x00A2564C, 0x00A2582C, 
						  0x00A2588C, 0x00A26501, 0x00A2813C, 0x00A2E49D, 0x00A2E4ED, 0x00A31F2B, 0x00A32F33, 0x00A3C126, 0x00A3BE41, 0x00A3BE57, 
						  0x00A3BE95, 0x00A3C2D7, 0x00A3D0B3, 0x00A41BF3, 0x00A41C11, 0x00A41DBA, 0x00A41D6C, 0x00A41E33, 0x00A41E51, 0x00A43F52, 
						  0x00A43F72, 0x00A43F0F, 0x00A4426A, 0x00A44302, 0x00A44322, 0x00A442BF, 0x00A44563, 0x00A4460A, 0x00A448D5, 0x00A44901, 
						  0x00A4491E, 0x00A4494D, 0x00A45BBC, 0x00A45C1C, 0x00A45C9C, 0x00A45F18, 0x00A49A7B, 0x00A49AAA, 0x00A66CBC, 0x00A6DD0B, 
						  0x00A7CE31, 0x00A7CEC8, 0x00A7CF6E, 0x00A8128A, 0x00A825A9, 0x00A879A1, 0x00A879F6, 0x00BBBF60, 0x00BBD2AA, 0x00BBD34B, 
						  0x00BBD38C, 0x00BBD46E, 0x00BBD57C, 0x00BBE254, 0x00BC15E4, 0x00BC16D4, 0x00BC17C4, 0x00BC18B4, 0x00BC19A4, 0x00BC1A94, 
						  0x00BC2DDE, 0x00BC7FBC, 0x00BC81F4, 0x00BC9AFA, 0x00BC9AAC, 0x00BC9D39, 0x00BC9D29, 0x00BCA2EA, 0x00BCA33C, 0x00BCA405, 
						  0x00BCA47C, 0x00BDAF27, 0x00BDAFA1, 0x00BDE759, 0x00BDE5D8, 0x00BE077F, 0x00BE073C, 0x00BE07BA, 0x00BE080C, 0x00BE085C, 
						  0x00BE91B7, 0x00BE919C, 0x00BEAA9C, 0x00BEB65A, 0x00BEB60C, 0x00BEB710, 0x00BEB7A1, 0x00BEBB4A, 0x00BEBB9C, 0x00BEBC82, 
						  0x00BEBCA8, 0x00BEC09C, 0x00BEFC81, 0x00BF0386, 0x00BF82D6, 0x00BF832E, 0x00BF84FA, 0x00BF83E9, 0x00BF9E4C, 0x00BFA100, 
						  0x00BFA17E, 0x00BFAF9A, 0x00BFB0A9, 0x00BFB099, 0x00BFB0E3, 0x00BFB153, 0x00BFB24C, 0x00BFB2AA, 0x00BFB2FC, 0x00BFB3F5, 
						  0x00BFB46E, 0x00BFB5AB, 0x00BFB5EC, 0x00BFB66C, 0x00BFB70B, 0x00BFB6FA, 0x00C5EDB0, 0x00C5F380, 0x00C5F489, 0x00C5FC2F, 
						  0x00C5FC6F, 0x00C60261, 0x00C60391, 0x00C604C1, 0x00C67A9D, 0x00C78A2F, 0x00C78AE6, 0x00C7BB1A, 0x00C7BB2F, 0x00C7C0F6, 
						  0x00C7C122, 0x00C7C1BA, 0x00C7C41D, 0x00C7C4EE, 0x00C7C591, 0x00C81CDD, 0x00C81FCB, 0x00C820DA, 0x00C8218A, 0x00C82EAA, 
						  0x00C82F8B, 0x00C891B4, 0x00C894C9, 0x00C893AF, 0x00C89F5B, 0x00C8ABEE, 0x00C8ACB6, 0x00C8AC9A, 0x00C8AD2A, 0x00C8AD7C, 
						  0x00C8ADFC, 0x00C8AE5C, 0x00C950CF, 0x00C950F5, 0x00C95021, 0x00C9504A, 0x00C951DA, 0x00C951E9, 0x00C9525A, 0x00C95269, 
						  0x00C952DA, 0x00C952E9, 0x00C9535C, 0x00C9536B, 0x00C95391, 0x00C953A0, 0x00C95889, 0x00C9589B, 0x00C958CA, 0x00C958DC, 
						  0x00C959FA, 0x00C95A0C, 0x00C95A3B, 0x00C95A4D, 0x00C95B4C, 0x00C95B5E, 0x00C95B8D, 0x00C95B9F, 0x00C9612C, 0x00C9613B, 
						  0x00C961A8, 0x00C961B7, 0x00C96346, 0x00C9637E, 0x00C963AE, 0x00C963E6, 0x00C9659C, 0x00C965C0, 0x00C967CF, 0x00C967DE, 
						  /*0x00C96C29, 0x00C96CBA,*/ 0x00C9721C, 0x00C9722B, 0x00C97FBA, 0x00C9800C, 0x00C9808C, 0x00C982BB, 0x00C99494, 0x00C994AB, 
						  0x00C994CE, 0x00C996D1, 0x00C996E8, 0x00C99772, 0x00C997D2, 0x00C9998C, 0x00C9CEEE, 0x00C9CF8A, 0x00C9CFDC, 0x00C9D04C, 
						  0x00C9D15B, 0x00C9D19C, 0x00C9D24E, 0x00C9E692, 0x00C9E6C5, 0x00C9E782, 0x00C9EA39, 0x00C9EA72, 0x00C9EECB, 0x00C9EF44, 
						  0x00C9F05A, 0x00C9F179, 0x00C9F169, 0x00C9F1F5, 0x00CA402C, 0x00CA40F1, 0x00CA40FE, 0x00CA4122, 0x00CA8404, 0x00CA84ED, 
						  0x00CA859A, 0x00CA8B90, 0x00CA8D90, 0x00CA8EE6, 0x00CA9187, 0x00CA95DB, 0x00CA9521, 0x00CA9553, 0x00CA974B, 0x00CA975B, 
						  0x00CA978F, 0x00CA9853, 0x00CA9863, 0x00CA96AC, 0x00CA99C2, 0x00CA9A60, 0x00CA9DFF, 0x00CAA201, 0x00CAA20E, 0x00CAA232, 
						  0x00CAB5A2, 0x00CAB7C3, 0x00CAB7AC, 0x00CAC094, 0x00CAC0B0, 0x00CABE78, 0x00CACA33, 0x00CACA46, 0x00CACA80, 0x00CACAC2, 
						  0x00CACBA0, 0x00CACDD0, 0x00CACF35, 0x00CACF83, 0x00CAD60B, 0x00CADEAA, 0x00CADF0C, 0x00CADFA6, 0x00CAE036, 0x00CAFB39, 
						  0x00CAFB9A, 0x00CB056A, 0x00CB05D5, 0x00CB11EE, 0x00CB12C8, 0x00CB1053, 0x00CB1694, 0x00CB169F, 0x00CB190E, 0x00CB1CCC, 
						  0x00CB235D, 0x00CB2A1D, 0x00CB4746, 0x00CB472A, 0x00CB4E14, 0x00CB4F0A, 0x00CB551C, 0x00CB5A09, 0x00CB59F9, 0x00CB64CE, 
						  0x00CB677F, 0x00CB6AF5, 0x00CB6E31, 0x00CB6E3E, 0x00CB6E62, 0x00CB6F81, 0x00CB6F8E, 0x00CB6FB2, 0x00CB7001, 0x00CB700E, 
						  0x00CB7032, 0x00CB727C, 0x00CBE986, 0x00CBF786, 0x00CBF67B, 0x00CBF6A8, 0x00CBF66F, 0x00CBF838, 0x00CBFA54, 0x00CBFCB6, 
						  0x00CC057D, 0x00CC07DB, 0x00CC0C57, 0x00CC2E2F, 0x00CC3114, 0x00CC3028, 0x00CC335C, 0x00CC35E1, 0x00CC4A03, 0x00CC4D32, 
						  0x00CC4BC9, 0x00CC4EB0, 0x00CC5976, 0x00CC5A1E, 0x00CC5A70, 0x00CC659A, 0x00CC7A48, 0x00CC795D, 0x00CC7CA0, 0x00CC7DA4, 
						  0x00CC7E68, 0x00CC7EC1, 0x00CC80A2, 0x00CC8166, 0x00CC818C, 0x00CC8325, 0x00CC8362, 0x00CC86D3, 0x00CC85DC, 0x00CC866F, 
						  0x00CC8692, 0x00CC876C, 0x00CC87BC, 0x00CC8887, 0x00CC902A, 0x00CC95D0, 0x00CC9DE0, 0x00CCA86C, 0x00CCA92C, 0x00CCA9EC, 
						  0x00CCAAAC, 0x00CCAB6C, 0x00CCAF28, 0x00CCAF4C, 0x00CCB17C, 0x00CCB361, 0x00CCB36E, 0x00CCB392, 0x00CCB65C, 0x00CCB6CC, 
						  0x00CCB783, 0x00CCBBD5, 0x00CCBC15, 0x00CCBC6D, 0x00CCBC8B, 0x00CCBD13, 0x00CCBB61, 0x00CCBB6B, 0x00CCBB7C, 0x00CCC227, 
						  0x00CCC50F, 0x00CCC5BC, 0x00CCD2F9, 0x00CCD346, 0x00CCD36F, 0x00CCD3CA, 0x00CCD599, 0x00CCD5E6, 0x00CCD60F, 0x00CCD66A, 
						  0x00CCD759, 0x00CCD749, 0x00CCD805, 0x00CCD919, 0x00CCD90A, 0x00CCF001, 0x00CCF05C, 0x00CCF30C, 0x00CCF373, 0x00CCF3CF, 
						  0x00CCF682, 0x00CCF5B0, 0x00CCF61C, 0x00CCFDB1, 0x00CCFE0D, 0x00CCFE75, 0x00CCFEFB, 0x00CCFF57, 0x00CCFFBF, 0x00CD007B, 
						  0x00CD01F9, 0x00CD023B, 0x00CD0111, 0x00CD1B49, 0x00CD1C7A, 0x00CD1C8E, 0x00CD1CC7, 0x00CD1CDE, 0x00CD1DCB, 0x00CD1DE0, 
						  0x00CD1DF2, 0x00CD22DC, 0x00CD23BC, 0x00CD2534, 0x00CD2771, 0x00CD277E, 0x00CD27A2, 0x00CD2F90, 0x00CD3357, 0x00CD344E, 
						  0x00CD34EB, 0x00CD373B, 0x00CD4038, 0x00CD409C, 0x00CD41AC, 0x00CD58DC, 0x00CD5991, 0x00CD599E, 0x00CD59C2, 0x00CDB5A9, 
						  0x00CDC779, 0x00CDC7F3, 0x00CDC65C, 0x00CDCA34, 0x00CDC6A6, 0x00CDC6D5, 0x00CDCAD6, 0x00CDCAE9, 0x00CDCAAF, 0x00CDD03F, 
						  0x00CDD1DA, 0x00CDD409, 0x00CDD429, 0x00CDD464, 0x00CDD4A6, 0x00CDD7CA, 0x00CDDA6A, 0x00CDDE9A, 0x00CDE128, 0x00CDE66E, 
						  0x00CDEA2E, 0x00CDEBAC, 0x00CDEC6C, 0x00CDF381, 0x00CDF38E, 0x00CDF3B2, 0x00CDF401, 0x00CDF40E, 0x00CDF432, 0x00CE03D5, 
						  0x00CE06B6, 0x00CE073A, 0x00CE0EB6, 0x00CE0E9A, 0x00CE103B, 0x00CE1077, 0x00CE0FB2, 0x00CE0FBE, 0x00CE117D, 0x00CE11AD, 
						  0x00CE12BD, 0x00CE12CA, 0x00CE12FF, 0x00CE14A3, 0x00CE14B0, 0x00CE14E5, 0x00CE1403, 0x00CE142C, 0x00CE168A, 0x00CE1761, 
						  0x00CE17B1, 0x00CE1825, 0x00CE18C6, 0x00CE18D4, 0x00CE1C3C, 0x00CE233A, 0x00CE26EA, 0x00CE270A, 0x00CE287C, 0x00CE297C, 
						  0x00CE2C8C, 0x00CE2CEC, 0x00CE2E1B, 0x00CE2FC8, 0x00CE4B0B, 0x00CE4C8F, 0x00CE497E, 0x00CE5168, 0x00CE5386, 0x00CE593F, 
						  0x00CE6473, 0x00CE6835, 0x00CE6880, 0x00CE6895, 0x00CE6B2B, 0x00CE6C50, 0x00CE6FC8, 0x00CE7219, 0x00CE72CE, 0x00CE75C1, 
						  0x00CE75E5, 0x00CE7827, 0x00CE7883, 0x00CE796C, 0x00CE7FAC, 0x00CE7FD3, 0x00CE8467, 0x00CE86F6, 0x00CE8AFB, 0x00CE8EAC, 
						  0x00CE923F, 0x00CE9561, 0x00CE9EC9, 0x00CE9F08, 0x00CEB65F, 0x00CEDD60, 0x00CEE63A, 0x00CEE693, 0x00CEE71C, 0x00CEE77C, 
						  0x00CEEA1C, 0x00CEF15A, 0x00CEF22C, 0x00CEF653, 0x00CEF7A0, 0x00CEFAA6, 0x00CEFC18, 0x00CEFCDB, 0x00CEFD04, 0x00CEFABA, 
						  0x00CEFE06, 0x00CEFE46, 0x00CEFAE0, 0x00CF011F, 0x00CEFF7F, 0x00CF016F, 0x00CF020A, 0x00CF025A, 0x00CEFF96, 0x00CF03AA, 
						  0x00CEFFAD, 0x00CF0485, 0x00CEFFC4, 0x00CF05C3, 0x00CF0680, 0x00CEFFDB, 0x00CF0744, 0x00CF07D7, 0x00CEFFF2, 0x00CF0009, 
						  0x00CF0020, 0x00CF08E4, 0x00CF0A5C, 0x00CF0AC9, 0x00CF0AEF, 0x00CF0B5C, 0x00CF0C4B, 0x00CF090A, 0x00CF0CB8, 0x00CF0CC5, 
						  0x00CF0CD5, 0x00CF0CE4, 0x00CF0CF1, 0x00CF0D01, 0x00CF0977, 0x00CF0D61, 0x00CF0E31, 0x00CF19C3, 0x00CF1A33, 0x00CF1BF8, 
						  0x00CF1C78, 0x00CF1DB8, 0x00CF1E98, 0x00CF1F28, 0x00CF1F9F, 0x00CF2028, 0x00CF20D8, 0x00CF2158, 0x00CF2258, 0x00CF2801, 
						  0x00CF280E, 0x00CF2832, 0x00CF3A42, 0x00CF3A7F, 0x00CF3A8C, 0x00CF3AC6, 0x00CF402C, 0x00CF710C, 0x00CF730A, 0x00CF732A, 
						  0x00CF737C, 0x00CF73FC, 0x00CF747C, 0x00CF7A7E, 0x00CF7BD0, 0x00CF7E53, 0x00CF811C, 0x00CF8744, 0x00CF8833, 0x00CF8B3A, 
						  0x00CF8BCA, 0x00CF8D13, 0x00CF8E5C, 0x00CF91DC, 0x00CF92CC, 0x00CF932C, 0x00CF9551, 0x00CF955E, 0x00CF9582, 0x00CFF9B3, 
						  0x00D0008F, 0x00D00240, 0x00D00278, 0x00D0036F, 0x00D005E1, 0x00D005F1, 0x00D00618, 0x00D02543, 0x00D02672, 0x00D02F42, 
						  0x00D02F71, 0x00D03035, 0x00D034B3, 0x00D03628, 0x00D0364C, 0x00D03B52, 0x00D03C7E, 0x00D03D79, 0x00D04129, 0x00D0411A, 
						  0x00D04183, 0x00D04C98, 0x00D0551F, 0x00D05779, 0x00D058E9, 0x00D05C43, 0x00D06011, 0x00D063F1, 0x00D06501, 0x00D06611, 
						  0x00D07F13, 0x00D0867B, 0x00D089FC, 0x00D0A489, 0x00D0C3E4, 0x00D0C3FE, 0x00D0C434, 0x00D0C2C9, 0x00D0C2E9, 0x00D0C330, 
						  0x00D0C709, 0x00D0C723, 0x00D0CA72, 0x00D0CAA5, 0x00D0CAD8, 0x00D0CB18, 0x00D0CB86, 0x00D0CBC6, 0x00D0C74F, 0x00D0CD73, 
						  0x00D0CEBF, 0x00D0CFCF, 0x00D0CFE8, 0x00D0D0E2, 0x00D0D4BB, 0x00D0D563, 0x00D0D972, 0x00D0D9B2, 0x00D0D6BD, 0x00D0DBF0, 
						  0x00D0DC1F, 0x00D0DCF2, 0x00D0D68F, 0x00D0E6B2, 0x00D0E7E6, 0x00D0F5BD, 0x00D0FFE9, 0x00D0FF01, 0x00D1025A, 0x00D1024E, 
						  0x00D102AA, 0x00D1029E, 0x00D10B89, 0x00D10B79, 0x00D112B5, 0x00D11572, 0x00D11826, 0x00D1180A, 0x00D11863, 0x00D1184C, 
						  0x00D118C3, 0x00D118AC, 0x00D1242E, 0x00D12BF9, 0x00D130EC, 0x00D1324F, 0x00D1321C, 0x00D13A93, 0x00D1427C, 0x00D1435C, 
						  0x00D1565F, 0x00D15781, 0x00D1578E, 0x00D157B2, 0x00D159C2, 0x00D17112, 0x00D1722C, 0x00D173FB, 0x00D174DD, 0x00D1750C, 
						  0x00D175E4, 0x00D17E7D, 0x00D17E6F, 0x00D18805, 0x00D1870C, 0x00D18716, 0x00D1873B, 0x00D187A2, 0x00D189C7, 0x00D18C7F, 
						  0x00D18E35, 0x00D18D3C, 0x00D18D46, 0x00D18D6B, 0x00D18DD2, 0x00D18FF8, 0x00D18EFF, 0x00D18F09, 0x00D18F2E, 0x00D18F95, 
						  0x00D19082, 0x00D190A8, 0x00D19221, 0x00D1922E, 0x00D19252, 0x00D19421, 0x00D1942E, 0x00D19452, 0x00D194EA, 0x00D1979C, 
						  0x00D19921, 0x00D199FC, 0x00D1A1EE, 0x00D1A289, 0x00D1A2DE, 0x00D1A391, 0x00D1A045, 0x00D1A453, 0x00D1A0AB, 0x00D1A66B, 
						  0x00D1A6CD, 0x00D1A840, 0x00D1A878, 0x00D1A745, 0x00D1A994, 0x00D1B28A, 0x00D1B316, 0x00D1B911, 0x00D1BA71, 0x00D1BAB8, 
						  0x00D1BB71, 0x00D1BBBE, 0x00D1BE4D, 0x00D1BCE5, 0x00D1BD32, 0x00D1C1E1, 0x00D1C274, 0x00D1C345, 0x00D1C3B1, 0x00D1C5DE, 
						  0x00D1C706, 0x00D1C4D9, 0x00D1C8CC, 0x00D1CBF5, 0x00D1CDD1, 0x00D1CF3A, 0x00D1DABC, 0x00D1DBB9, 0x00D1DBA9, 0x00D1DBF3, 
						  0x00D1DCFC, 0x00D1DDD5, 0x00D1E3B2, 0x00D1E75A, 0x00D1E83A, 0x00D1E93C, 0x00D1EB3A, 0x00D1EB9C, 0x00D1EBF8, 0x00D1EC1C, 
						  0x00D1EC9C, 0x00D1ED2C, 0x00D26F3A, 0x00D26EEC, 0x00D26F7A, 0x00D276BC, 0x00D2771C, 0x00D277F1, 0x00D277FE, 0x00D27822, 
						  0x00D27E18, 0x00D27F92, 0x00D27FB8, 0x00D2ADFD, 0x00D2AC83, 0x00D2AD20, 0x00D2B199, 0x00D2B1DB, 0x00D2B22B, 0x00D2B2BB, 
						  0x00D30CAE, 0x00D31D43, 0x00D31D5A, 0x00D31EC8, 0x00D31ED4, 0x00D31DD3, 0x00D31DE0, 0x00D31E09, 0x00D31F32, 0x00D32284, 
						  0x00D322A5, 0x00D321F7, 0x00D323C2, 0x00D324D7, 0x00D32561, 0x00D3257C, 0x00D325F6, 0x00D32660, 0x00D3266D, 0x00D326F0, 
						  0x00D326FD, 0x00D32772, 0x00D3279E, 0x00D328A5, 0x00D328E2, 0x00D32A24, 0x00D32A92, 0x00D32B73, 0x00D32B8E, 0x00D32C1F, 
						  0x00D32CDF, 0x00D3308D, 0x00D33AC3, 0x00D33C0A, 0x00D33C26, 0x00D33ACF, 0x00D33CED, 0x00D33AF5, 0x00D33B5D, 0x00D33B97, 
						  0x00D33E77, 0x00D33E7E, 0x00D33FBF, 0x00D34153, 0x00D34213, 0x00D3447D, 0x00D344CD, 0x00D347A1, 0x00D347AE, 0x00D347D2, 
						  0x00D349E3, 0x00D34A6C, 0x00D34B73, 0x00D34CBA, 0x00D34CD6, 0x00D34B7F, 0x00D34D9D, 0x00D34BA5, 0x00D34C0D, 0x00D34C47, 
						  0x00D34E91, 0x00D34E9E, 0x00D34EC2, 0x00D34F21, 0x00D34F5B, 0x00D34FB7, 0x00D35077, 0x00D3507E, 0x00D350D1, 0x00D3510B, 
						  0x00D35167, 0x00D352C8, 0x00D35593, 0x00D35603, 0x00D35673, 0x00D3AD9A, 0x00D3ADEA, 0x00D3AF2A, 0x00D3BE8C, 0x00D3BEEC, 
						  0x00D3BF3C, 0x00D3CB6A, 0x00D3CD6C, 0x00D3D10E, 0x00D3D0DC, 0x00D3D4C2, 0x00D3D634, 0x00D3DA1F, 0x00D3DA64, 0x00D3DBD6, 
						  0x00D3DC12, 0x00D3DF9F, 0x00D3E04B, 0x00D3E1BF, 0x00D3E337, 0x00D3E9D5, 0x00D3E9EE, 0x00D3EB51, 0x00D3EC33, 0x00D3EE9A, 
						  0x00D3F205, 0x00D3F4C6, 0x00D3F83E, 0x00D3F855, 0x00D3F8A3, 0x00D3F914, 0x00D3F7CC, 0x00D3FA75, 0x00D3FAA1, 0x00D3FAC4, 
						  0x00D3FAF7, 0x00D3FB11, 0x00D3FBFB, 0x00D3FD01, 0x00D3FE34, 0x00D3FE61, 0x00D3FEA8, 0x00D3FEB2, 0x00D4010A, 0x00D403D3, 
						  0x00D403EC, 0x00D40532, 0x00D4059D, 0x00D40602, 0x00D40664, 0x00D41245, 0x00D41288, 0x00D412AC, 0x00D412D6, 0x00D41332, 
						  0x00D414F6, 0x00D41537, 0x00D4158B, 0x00D415CC, 0x00D41640, 0x00D41661, 0x00D41680, 0x00D416F0, 0x00D41731, 0x00D41785, 
						  0x00D417C6, 0x00D41921, 0x00D41962, 0x00D419B6, 0x00D419F7, 0x00D413FA, 0x00D41A4B, 0x00D41A8C, 0x00D41AD4, 0x00D41B09, 
						  0x00D41B5C, 0x00D41BF7, 0x00D41C67, 0x00D41CA8, 0x00D41CFC, 0x00D41D3D, 0x00D41DFA, 0x00D41E3B, 0x00D4143B, 0x00D4204B, 
						  0x00D4205C, 0x00D4206A, 0x00D4207B, 0x00D4214C, 0x00D4217B, 0x00D421C0, 0x00D421F2, 0x00D433B9, 0x00D42551, 0x00D42572, 
						  0x00D42593, 0x00D425B6, 0x00D425D9, 0x00D425F9, 0x00D4359D, 0x00D438C4, 0x00D43952, 0x00D43A69, 0x00D43B07, 0x00D43968, 
						  0x00D4398D, 0x00D43C35, 0x00D43C83, 0x00D43CA2, 0x00D43E2B, 0x00D43E83, 0x00D4417E, 0x00D442E4, 0x00D44618, 0x00D44B3C, 
						  0x00D44CEA, 0x00D44EAD, 0x00D45648, 0x00D457BC, 0x00D459F3, 0x00D4639E, 0x00D463BD, 0x00D4649D, 0x00D46562, 0x00D4667E, 
						  0x00D4700D, 0x00D475C3, 0x00D475E0, 0x00D4768F, 0x00D47508, 0x00D47527, 0x00D47781, 0x00D4933A, 0x00D4957A, 0x00D495ED, 
						  0x00D4961A, 0x00D4978A, 0x00D4982A, 0x00D4A0B1, 0x00D4A4AE, 0x00D4A62E, 0x00D4AD5A, 0x00D4AE3A, 0x00D4AE98, 0x00D4AF71, 
						  0x00D4BCFA, 0x00D4D45C, 0x00D4D50C, 0x00D4D58A, 0x00D4D5FD, 0x00D4D62C, 0x00D4D6AC, 0x00D4DB91, 0x00D4DB9E, 0x00D4DBC2, 
						  0x00D4E673, 0x00D4EA8E, 0x00D4EBAE, 0x00D4EBBC, 0x00D50E42, 0x00D50E68, 0x00D518AC, 0x00D51933, 0x00D51A1E, 0x00D52077, 
						  0x00D52190, 0x00D522EA, 0x00D5230A, 0x00D5235C, 0x00D581BB, 0x00D583E9, 0x00D58564, 0x00D5857B, 0x00D585C5, 0x00D584DD, 
						  0x00D58502, 0x00D58513, 0x00D58528, 0x00D58F3E, 0x00D5904E, 0x00D5917E, 0x00D5950A, 0x00D5ADAE, 0x00D5AE69, 0x00D5AE9B, 
						  0x00D5AECD, 0x00D5AF84, 0x00D5B364, 0x00D5B384, 0x00D5B3BF, 0x00D5B5F2, 0x00D5B649, 0x00D5B652, 0x00D5B9D2, 0x00D5B9E2, 
						  0x00D5C88E, 0x00D5C8B0, 0x00D5C79A, 0x00D5CE49, 0x00D5CE62, 0x00D5D460, 0x00D5D4E4, 0x00D5D741, 0x00D5EB4B, 0x00D5ED9E, 
						  0x00D5F791, 0x00D5F625, 0x00D5F6C4, 0x00D5F6DB, 0x00D61286, 0x00D6126A, 0x00D61474, 0x00D61766, 0x00D6174A, 0x00D6232C, 
						  0x00D623AC, 0x00D6273C, 0x00D627AC, 0x00D62879, 0x00D62869, 0x00D62B3D, 0x00D6349A, 0x00D63595, 0x00D63653, 0x00D63839, 
						  0x00D6382A, 0x00D638DD, 0x00D63997, 0x00D63CBD, 0x00D63CF1, 0x00D69E1B, 0x00D69E49, 0x00D69EA0, 0x00D69F3E, 0x00D69F76, 
						  0x00D69FD1, 0x00D6A079, 0x00D6A150, 0x00D6A233, 0x00D6A292, 0x00D6A36C, 0x00D6A3E5, 0x00D6A432, 0x00D6A3BF, 0x00D6AB37, 
						  0x00D6AB73, 0x00D6B0FE, 0x00D6B197, 0x00D6B2CB, 0x00D6B1D1, 0x00D6B206, 0x00D6B23B, 0x00D6B270, 0x00D6B296, 0x00D6B324, 
						  0x00D6B3A4, 0x00D6B429, 0x00D6B446, 0x00D6B5BD, 0x00D6B62E, 0x00D6B6E1, 0x00D6B7DF, 0x00D6B7EC, 0x00D6B81A, 0x00D6B856, 
						  0x00D6B96A, 0x00D6C3BA, /*0x00D6C40A,*/ 0x00D6C42A, 0x00D6C5A3, 0x00D6C722, 0x00D6C748, 0x00D6C823, 0x00D6C841, 0x00D6C9FA, 
						  0x00D6CA8C, 0x00D6CAF8, 0x00D6CB1C, 0x00D6CBB3, 0x00D6CBD1, 0x00D6CD9C, 0x00D6CE2C, 0x00D6CEB8, 0x00D6D025, 0x00D6D051, 
						  0x00D6D06E, 0x00D6D09D, 0x00D6D112, 0x00D6D192, 0x00D6D225, 0x00D6D251, 0x00D6D26E, 0x00D6D29D, 0x00D6D305, 0x00D6D331, 
						  0x00D6D34E, 0x00D6D37D, 0x00D6D3BE, 0x00D6D542, 0x00D6D562, 0x00D6D4FF, 0x00D6D643, 0x00D6D69B, 0x00D6D68A, 0x00D6D76A, 
						  0x00D6D83C, 0x00D6D902, 0x00D6D922, 0x00D6D8BF, 0x00D6DA9A, 0x00D6DAEC, 0x00D6DBEA, 0x00D6DC32, 0x00D6DC78, 0x00D6DCE8, 
						  0x00D6DDBC, 0x00D6DE18, 0x00D6DE5D, 0x00D6DE8C, 0x00D6DEE8, 0x00D6E0B9, 0x00D6E27A, 0x00D6E433, 0x00D6E3A3, 0x00D6E591, 
						  0x00D6E5B3, 0x00D6E523, 0x00D6E733, 0x00D6E6A3, 0x00D6E7CC, 0x00D6E85C, 0x00D6E913, 0x00D8306E, 0x00D82EBD, 0x00D84469, 
						  0x00D85259, 0x00D852DC, 0x00D862EF, 0x00D8786C, 0x00D878DC, 0x00D8795C, 0x00D8E189, 0x00DCF489, 0x00DCF4B9, 0x00DCF4C5, 
						  0x00DCF6B0, 0x00DCF6D5, 0x00DD0294, 0x00DD02EB, 0x00DD0177, 0x00DD01D8, 0x00DD0EBA, 0x00DD276F, 0x00DD597D, 0x00DD77AC, 
						  0x00DD781A, 0x00DD79EC, 0x00DDD02F, 0x00DDEAF2, 0x00DDFBC3, 0x00DE1F0B, 0x00DE383D, 0x00DE3861, 0x00DE36E7, 0x00DE39A1, 
						  0x00DE3ACA, 0x00DE4376, 0x00DE4B8C, 0x00DE5160, 0x00DE524C, 0x00DE540E, 0x00DE5537, 0x00DE569F, 0x00DE56CD, 0x00DE5704, 
						  0x00DE5758, 0x00DE5546, 0x00DE5948, 0x00DE5958, 0x00DE5995, 0x00DE59A4, 0x00DE557B, 0x00DE61E6, 0x00DE61CA, 0x00DE99AD, 
						  0x00DEC782, 0x00DEC951, 0x00DEC98B, 0x00DED199, 0x00DEE82F, 0x00DF0840, 0x00DF065E, 0x00DF1A1D, 0x00DF1A61, 0x00DF1B64, 
						  0x00DF3217, 0x00DF325A, 0x00DF3C27, 0x00DF3DCE, 0x00DF44BD, 0x00DF5893, 0x00DF6026, 0x00DF6E43, 0x00DF7A24, 0x00DF7E38, 
						  0x00DF7E5B, 0x00DF817D, 0x00DF8196, 0x00DF81BB, 0x00DF80B1, 0x00DF80C9, 0x00DF80E2, 0x00DF815D, 0x00DF9817, 0x00DF9892, 
						  0x00DFA16C, 0x00DFA18F, 0x00DFA24E, 0x00DFA289, 0x00DFA862, 0x00DFB3C9, 0x00DFCA92, 0x00DFCAC5, 0x00DFCD5E, 0x00DFCDD3, 
						  0x00DFCF8F, 0x00DFCFC2, 0x00DFD539, 0x00E00332, 0x00E00358, 0x00E0059A, 0x00E0094A, 0x00E00D0A, 0x00E00E3A, 0x00E00F2A, 
						  0x00E0105A, 0x00E0499A, 0x00E04A31, 0x00E04A3E, 0x00E04A62, 0x00E04AEC, 0x00E04D6C, 0x00E04DCC, 0x00E04E9A, 0x00E04E4C, 
						  0x00E04F2A, 0x00E04EDC, 0x00E04FAC, 0x00E04FFC, 0x00E050CA, 0x00E0507C, 0x00E0515A, 0x00E0510C, 0x00E0519C, 0x00E051EC, 
						  0x00E0526C, 0x00E052BC, 0x00E0530C, 0x00E0574C, 0x00E077DC, 0x00E0782C, 0x00E0791C, 0x00E0AEF3, 0x00E0EA7A, 0x00E0EACC, 
						  0x00E0ECBC, 0x00E0ED0C, 0x00E176D5, 0x00E178BE, 0x00E178FB, 0x00E17F80, 0x00E18AB6, 0x00E197E3, 0x00E198F1, 0x00E1B839, 
						  0x00E1B829, 0x00E1C825, 0x00E1D7D9, 0x00E1D7EC, 0x00E21321, 0x00E21366, 0x00E2162E, 0x00E2167D, 0x00E216DE, 0x00E21711, 
						  0x00E21748, 0x00E2177B, 0x00E2199B, 0x00E21A10, 0x00E21E41, 0x00E21E4E, 0x00E21E72, 0x00E26A8B, 0x00E26B25, 0x00E26D64, 
						  0x00E26DBB, 0x00E2703A, 0x00E270EA, 0x00E2719A, 0x00E27670, 0x00E27AE9, 0x00E27C29, 0x00E27C60, 0x00E27D91, 0x00E27AB2, 
						  0x00E28249, 0x00E281AA, 0x00E29564, 0x00E299A0, 0x00E2ABFA, 0x00E2ACB4, 0x00E2B10A, 0x00E2B0BC, 0x00E2B3A2, 0x00E2B574, 
						  0x00E2BBEB, 0x00E2C202, 0x00E2C3D4, 0x00E2CA4B, 0x00E37C73, 0x00E396BF, 0x00E418E0, 0x00E41957, 0x00E42B98, 0x00E42FD8, 
						  0x00E4DF0C, 0x00E4E36B, 0x00E4E4FB, 0x00E4E6BB, 0x00E4E8AB, 0x00E4EACB, 0x00E4ED1B, 0x00E4EF9B, 0x00E4F25B, 0x00E4F3DB, 
						  0x00E4F58B, 0x00E4F76B, 0x00E4F97B, 0x00E4FBBB, 0x00E4FE2B, 0x00E500CB, 0x00E5029B, 0x00E5049B, 0x00E506CB, 0x00E5092B, 
						  0x00E50BBB, 0x00E50E7B, 0x00E5151B, 0x00E516AB, 0x00E5186B, 0x00E51989, 0x00E51D7B, 0x00E51F2B, 0x00E5221B, 0x00E523EB, 
						  0x00E526CB, 0x00E5289B, 0x00E52BFB, 0x00E52DFB, 0x00E5313B, 0x00E532EB, 0x00E534BB, 0x00E535CB, 0x00E536AB, 0x00E538EB, 
						  0x00E53B3B, 0x00E53CEB, 0x00E53EDB, 0x00E5401B, 0x00E5414B, 0x00E5427B, 0x00E5443B, 0x00E545DB, 0x00E547FB, 0x00E5499B, 
						  0x00E54B3B, 0x00E54CFB, 0x00E54E9B, 0x00E57806, 0x00E579E2, 0x00E57A9B, 0x00E57B40, 0x00E57E40, 0x00E58DD0, 0x00E58E30, 
						  0x00E58E50, 0x00E58EB9, 0x00E58ED3, 0x00E59A2C, 0x00E59AAC, 0x00E5BE94, 0x00E5BEC1, 0x00E5BEFF, 0x00E5BF30, 0x00E5F1E9, 
						  0x00E5F1D9, 0x00E5F265, 0x00E607CA, 0x00E6099E, 0x00E60DE0, 0x00E60E00, 0x00E6919C, 0x00E691EE, 0x00E697C2, 0x00E69832, 
						  0x00E698A2, 0x00E7280C, 0x00E73070, 0x00E73261, 0x00E797FA, 0x00E7984C, 0x00E798CC, 0x00E7E187, 0x00E7E2DD, 0x00E7E318, 
						  0x00E7E3D1, 0x00E7E3ED, 0x00E7E5F3, 0x00E8F110, 0x00E8F18C, 0x00E8F20D, 0x00E8F294, 0x00ECA410, 0x00ECA548, 0x00ECA6C5, 
						  0x00ECD848, 0x00ECD881, 0x00ECD8BB, 0x00ECE118, 0x00ECE151, 0x00ECE18B, 0x00ECE641, 0x00ECE798, 0x00ECE4BC, 0x00ECFA9C, 
						  0x00ED181D, 0x00ED1299, 0x00ED12D3, 0x00ED1AD0, 0x00ED194B, 0x00ED1971, 0x00ED2CDE, 0x00EDE84F, 0x00EDF108, 0x00EDF12D, 
						  0x00EE24F6, 0x00EE24DA, 0x00EE2E55, 0x00EE34F3, 0x00EE781F, 0x00EECBEA, 0x00EED6C0, 0x00EEFC61, 0x00EF0577, 0x00EF07D1, 
						  0x00EF0DE8, 0x00EF0F46, 0x00EF0703, 0x00EF1267, 0x00EF1506, 0x00EF175C, 0x00EF1357, 0x00EF13BF, 0x00EF1D81, 0x00EF23BF, 
						  0x00EF23E5, 0x00EF841B, 0x00EF9068, 0x00EF911A, 0x00EF931E, 0x00EFA71A, 0x00EFA5F0, 0x00EFA616, 0x00EFA931, 0x00EFB91A, 
						  0x00EFB8CC, 0x00F27EED, 0x00F29597, 0x00F2A388, 0x00F2A4E1, 0x00F2ADFB, 0x00F2DCC2, 0x00F2DCE7, 0x00F2E8C3, 0x00F5DDDF, 
						  0x00F5DDAF, 0x00F5E65A, 0x00F5E6AC, 0x00F5E72C, 0x00F5EF5A, 0x00F5EFEC, 0x00F5F05C, 0x00F5F0AC, 0x00F6ACFD, 0x00F6BEC8, 
						  0x00F6F38E, 0x00F8A295, 0x00FC37C3, 0x00FE62F1}; 

	DWORD get_this_off4_calls[] = {						  0x00939C71, 0x00939CC4, 0x00939CFB, 0x0097323F, 0x009730B1, 0x009730E1, 0x0097312B, 0x00973169, 0x00974CCA, 0x0117201A, 
						  0x0117206C, 0x0117210C, 0x01177BCC, 0x01177C2C, 0x0040720F, 0x00408794, 0x00408822, 0x0040B7E0, 0x0040FD33, 0x00412D16, 
						  0x0041239C, 0x00412AEC, 0x00412BFA, 0x00417940, 0x00417BBE, 0x00417C3D, 0x0041C27E, 0x0041CBA5, 0x0041CC16, 0x0041D44F, 
						  0x0041D5A9, 0x0041E70C, 0x0041E84C, 0x0041F5B6, 0x0041F4DC, 0x00422E71, 0x00421FFC, 0x004220DB, 0x004221E1, 0x00422229, 
						  0x00428F91, 0x004337F0, 0x004338A4, 0x00433ED5, 0x00434196, 0x0043425C, 0x0043454A, 0x0043459A, 0x00434881, 0x00434928, 
						  0x00434C31, 0x00434CD8, 0x00436F80, 0x00437643, 0x0043835F, 0x0043836A, 0x00442D60, 0x00444235, 0x00446A7A, 0x0044785A, 
						  0x004478AA, 0x0044815C, 0x004481FC, 0x00448380, 0x004491B4, 0x0044935A, 0x0045089F, 0x0045091A, 0x004509A5, 0x00450B43, 
						  0x00450BC2, 0x00450FEE, 0x0045511B, 0x004553A4, 0x00455431, 0x004560FA, 0x0045661C, 0x00456EC4, 0x00456F64, 0x00456FD4, 
						  0x00457044, 0x004570B4, 0x00458BEF, 0x0045A7EB, 0x0045A91D, 0x0045A953, 0x0045A9AF, 0x0045AB29, 0x0045AB97, 0x0045A54C, 
						  0x0045A56A, 0x0045AC9B, 0x0045AF0D, 0x0045AFEE, 0x0045B0CD, 0x0045B0EE, 0x0045B97F, 0x00462111, 0x0046211D, 0x00462142, 
						  0x0046243D, 0x00462576, 0x00462582, 0x004625BD, 0x00462609, 0x00462615, 0x00462650, 0x00462690, 0x0046269F, 0x00462787, 
						  0x00462796, 0x0046287F, 0x0046237B, 0x004623BB, 0x004623CE, 0x00463EDA, 0x00463F30, 0x004650A2, 0x00465101, 0x004651C2, 
						  0x00465311, 0x00465306, 0x0046834F, 0x00468361, 0x00469013, 0x00469098, 0x0046A984, 0x0046B075, 0x0046B43D, 0x0046B7B4, 
						  0x0046D58C, 0x0046FEC1, 0x00470023, 0x004700A1, 0x00474011, 0x00474661, 0x00474833, 0x00474B4D, 0x00474A1B, 0x00474AE9, 
						  0x00474C2A, 0x00474C75, 0x00474CAD, 0x00474D12, 0x00474D22, 0x00474D4C, 0x00474DEE, 0x00474E2D, 0x00474EAA, 0x00474ED6, 
						  0x00474E9D, 0x00474F57, 0x00474F86, 0x00474F4D, 0x004750BF, 0x00475179, 0x00477AB4, 0x00477B5C, 0x00478181, 0x004788A3, 
						  0x00478D7B, 0x00479385, 0x004791C4, 0x00479673, 0x0047999C, 0x004799A7, 0x00479D62, 0x00479FCA, 0x0047A01C, 0x0047A0CC, 
						  0x0047B60A, 0x0047B6DC, 0x0047B72C, 0x0047D641, 0x0047D758, 0x0047D74C, 0x0047D9F6, 0x0047D98C, 0x0047D9C6, 0x0047DB09, 
						  0x0047DB15, 0x0047DB20, 0x0047DB8F, 0x0047DC63, 0x0047DD51, 0x0047DE3F, 0x0047DEDD, 0x0047DFEF, 0x0047FB61, 0x0047FBAC, 
						  0x00487EBD, 0x0048944F, 0x0048DDFA, 0x0048DE4C, 0x0048E051, 0x0048E245, 0x0048E35C, 0x0048E42E, 0x0048E816, 0x0048E997, 
						  0x004917E0, 0x00492112, 0x00493EAA, 0x00493E9D, 0x00497CE6, 0x0049C1DF, 0x004A232C, 0x004A23AC, 0x004A242A, 0x004A24FC, 
						  0x004A4118, 0x004A4252, 0x004A4357, 0x004A43AD, 0x004A43C0, 0x004A704C, 0x004A81CF, 0x004A821F, 0x004A83BC, 0x004A8415, 
						  0x004A855A, 0x004A86A7, 0x004A8726, 0x004A880D, 0x004A88E9, 0x004A891B, 0x004A8AE9, 0x004A8B6A, 0x004A8BF1, 0x004A8C3D, 
						  0x004A8D12, 0x004A8D7E, 0x004A8E26, 0x004A9046, 0x004A911C, 0x004A9161, 0x004A96D3, 0x004A96E0, 0x004A9790, 0x004A98C5, 
						  0x004A9C02, 0x004A9C84, 0x004A9CF4, 0x004A9D63, 0x004A9DD2, 0x004AA1B3, 0x004AA248, 0x004AA420, 0x004AA554, 0x004AA6E5, 
						  0x004AA6F2, 0x004AA82C, 0x004AA7D4, 0x004AAB2E, 0x004AAA69, 0x004AABF6, 0x004AAC79, 0x004AAC8C, 0x004AAC99, 0x004AAEE5, 
						  0x004AAFEE, 0x004AB058, 0x004AB368, 0x004ABF7F, 0x004AC063, 0x004AC158, 0x004AC168, 0x004AC567, 0x004ACFBD, 0x004AD749, 
						  0x004AD792, 0x004AD669, 0x004AD713, 0x004ADA25, 0x004ADA89, 0x004AD827, 0x004AD833, 0x004ADC00, 0x004ADC82, 0x004AEFA4, 
						  0x004AF479, 0x004AF52F, 0x004AFBF1, 0x004B0037, 0x004B0110, 0x004B019C, 0x004B0CAD, 0x004B0DB0, 0x004B125B, 0x004B1271, 
						  0x004AE171, 0x004AE750, 0x004B1450, 0x004B170C, 0x004B1B25, 0x004B1CFC, 0x004B1D70, 0x004B205F, 0x004B210C, 0x004B22F1, 
						  0x004B2641, 0x004B298F, 0x004B2A5E, 0x004B2DCF, 0x004B30AB, 0x004B3163, 0x004B2B35, 0x004B33A1, 0x004B349C, 0x004B34F4, 
						  0x004B357D, 0x004B35D3, 0x004B368D, 0x004B3707, 0x004B3BB7, 0x004B3BCB, 0x004B3C5E, 0x004B3C6A, 0x004B3C7E, 0x004B3E11, 
						  0x004B3E1D, 0x004B3E31, 0x004B3ED3, 0x004B40BE, 0x004B40CA, 0x004B40DE, 0x004B4206, 0x004B4216, 0x004B4278, 0x004B42AE, 
						  0x004B43E1, 0x004B450C, 0x004B4519, 0x004B4557, 0x004B4678, 0x004B4684, 0x004B4698, 0x004B46F4, 0x004B474E, 0x004B475B, 
						  0x004B476B, 0x004B488B, 0x004B49C1, 0x004B49D9, 0x004B4CC1, 0x004B4E5D, 0x004B4FDD, 0x004B5044, 0x004B505A, 0x004B50BB, 
						  0x004B5130, 0x004B535F, 0x004B5401, 0x004B540E, 0x004B5427, 0x004B544B, 0x004B546A, 0x004B51BF, 0x004B51F5, 0x004B526D, 
						  0x004B559D, 0x004B55AA, 0x004B55B7, 0x004B5647, 0x004B5792, 0x004B579F, 0x004B5934, 0x004B5944, 0x004B595B, 0x004B59DA, 
						  0x004B59E9, 0x004B5AB8, 0x004B5AC8, 0x004B5ADF, 0x004B5B5E, 0x004B5B6D, 0x004B5B8F, 0x004B5CC5, 0x004B5CE0, 0x004B5C6F, 
						  0x004B5E88, 0x004B5E98, 0x004B5EAF, 0x004B5F95, 0x004B5FA9, 0x004B611A, 0x004B6127, 0x004B61D2, 0x004B63B3, 0x004B6450, 
						  0x004B64D9, 0x004B65C8, 0x004B6789, 0x004B67A0, 0x004B695C, 0x004B6969, 0x004B6976, 0x004B6B5E, 0x004B6B6E, 0x004B6E7A, 
						  0x004B706B, 0x004B71C1, 0x004B724C, 0x004B736D, 0x004B73AB, 0x004B73CF, 0x004B72E5, 0x004B72F5, 0x004B730C, 0x004B7348, 
						  0x004B7740, 0x004B7911, 0x004B79CD, 0x004B79DA, 0x004B7E2B, 0x004B7C4F, 0x004B8373, 0x004B8380, 0x004B8408, 0x004B8520, 
						  0x004B8510, 0x004B876F, 0x004B8940, 0x004B89E0, 0x004B8CAB, 0x004B8CFC, 0x004B8F12, 0x004B92D2, 0x004B941C, 0x004B96D5, 
						  0x004B981C, 0x004B986C, 0x004B9878, 0x004B98B3, 0x004B98FF, 0x004B990B, 0x004B9946, 0x004B9ABF, 0x004B9D02, 0x004BA0AF, 
						  0x004BA0D4, 0x004BA10E, 0x004BA16A, 0x004BA18F, 0x004BA1C3, 0x004BA340, 0x004BA3E8, 0x004BA620, 0x004BA6F1, 0x004BA8E3, 
						  0x004BA90E, 0x004BABC8, 0x004BAC1D, 0x004BADD7, 0x004BB0DD, 0x004BB1EA, 0x004BB1F7, 0x004BC082, 0x004BCE7C, 0x004BCE95, 
						  0x004BCEE2, 0x004BCEF9, 0x004BCF33, 0x004BCF82, 0x004BD063, 0x004BD0B0, 0x004BD192, 0x004BD19E, 0x004BD39F, 0x004C76AE, 
						  0x004C7816, 0x004C7A40, 0x004C89D9, 0x004C9B48, 0x004CAB81, 0x004CACB3, 0x004CADF8, 0x004CADC0, 0x004CB29D, 0x004CB32B, 
						  0x004CB336, 0x004CB4E8, 0x004CB544, 0x004CB55F, 0x004CB6FF, 0x004CB7C6, 0x004CB490, 0x004CB4B0, 0x004CBA89, 0x004CC6B6, 
						  0x004CC746, 0x004CC7D6, 0x004CC866, 0x004CC9CD, 0x004CC9EA, 0x004CC8EA, 0x004CC8F5, 0x004CC900, 0x004CC90B, 0x004CC91B, 
						  0x004CC92C, 0x004CCAAB, 0x004CCC92, 0x004D000C, 0x004D00AD, 0x004D9851, 0x004D9861, 0x004DA476, 0x004DEC1C, 0x004DEE6D, 
						  0x004DF102, 0x004E1CED, 0x004E64DA, 0x004FB481, 0x004FB48D, 0x004FB4EA, 0x0050180D, 0x00501C42, 0x00501D76, 0x0050B668, 
						  0x0050B5BE, 0x0050BCAD, 0x0050C413, 0x005102DC, 0x005102A9, 0x005125BE, 0x005125E1, 0x005142F9, 0x005140DD, 0x00514537, 
						  0x005159A9, 0x005163D9, 0x00517226, 0x00517BCB, 0x00517C55, 0x00517D4F, 0x00517E8E, 0x00517F5E, 0x00517FC6, 0x0051809E, 
						  0x00518249, 0x00518256, 0x00518269, 0x0051827C, 0x005182A4, 0x0051848D, 0x00518C4B, 0x00518E04, 0x00518E25, 0x00518F28, 
						  0x005190AF, 0x00519890, 0x00519AD4, 0x00519F6A, 0x0051A139, 0x0051A274, 0x0051A3AA, 0x0051A655, 0x0051AAF7, 0x0051A8E3, 
						  0x0051B35C, 0x0051B374, 0x0051B425, 0x0051B443, 0x0051B4FB, 0x0051B5E6, 0x0051B671, 0x0051B69A, 0x0051B2E2, 0x0051B32D, 
						  0x0051C111, 0x0051C19F, 0x0051C6E5, 0x0051C952, 0x0051CABE, 0x0051D573, 0x0051F0B1, 0x0051F686, 0x00522568, 0x005226D0, 
						  0x00522779, 0x00522861, 0x00522F4B, 0x00523B45, 0x0052409F, 0x0052630C, 0x005263DC, 0x0052645C, 0x00527901, 0x005279F7, 
						  0x00528FAA, 0x0052AB4C, 0x0052ABC1, 0x0052C0D3, 0x0052C100, 0x005357C6, 0x005359FB, 0x00535AC3, 0x0053666B, 0x0053C159, 
						  0x0053C714, 0x0053CB65, 0x0053CB7D, 0x0053CAC1, 0x0053CC14, 0x0053CC6D, 0x0053CC82, 0x0053CDA8, 0x0053CDB8, 0x0053CD20, 
						  0x0053D0E0, 0x0053D0EC, 0x0054288B, 0x005428C0, 0x00543DCE, 0x00543D35, 0x005453DC, 0x0054782C, 0x00549B17, 0x00549D43, 
						  0x00549E69, 0x0054A4F2, 0x0054A575, 0x0054A86D, 0x0054FB3E, 0x00550198, 0x005501E1, 0x0055030A, 0x00550241, 0x00550353, 
						  0x00550428, 0x00551303, 0x005511A0, 0x00554835, 0x00554879, 0x005548CD, 0x005548E2, 0x00554919, 0x00554943, 0x0055497F, 
						  0x005565BB, 0x005565CB, 0x0055802C, 0x0055960C, 0x00559591, 0x005609FA, 0x00562641, 0x0056A2DD, 0x00581B95, 0x00581C66, 
						  0x00581D35, 0x00581E17, 0x00581F04, 0x00582054, 0x00582921, 0x00582D33, 0x00582D3E, 0x00582DBF, 0x00582DCA, 0x00582F5C, 
						  0x00582F87, 0x00583254, 0x005832E4, 0x0058383A, 0x00583E8C, 0x00583FA7, 0x00585C56, 0x00585E15, 0x005864B4, 0x0058683F, 
						  0x005874A5, 0x005875A2, 0x005877FD, 0x00588AE4, 0x00588C02, 0x00588D90, 0x0058C7E1, 0x0059AB0C, 0x0059AA69, 0x0059AE95, 
						  0x0059AEA5, 0x0059AEBE, 0x0059AF18, 0x0059E2D6, 0x0059E388, 0x005A05A7, 0x005A05B8, 0x005A1C86, 0x005A1C9F, 0x005A1CCB, 
						  0x005A1C13, 0x005A1E61, 0x005A45F6, 0x005A80BE, 0x005A8116, 0x005A814B, 0x005A7F5E, 0x005A9727, 0x005A9948, 0x005A9C4C, 
						  0x005B0B4F, 0x005B169D, 0x005B1820, 0x005B2BE2, 0x005B472A, 0x005B4778, 0x005C1245, 0x005C77B6, 0x005C78E1, 0x005CA6A5, 
						  0x005CC22F, 0x005CC284, 0x005D0931, 0x005D094B, 0x005D0991, 0x005D09AB, 0x005D09DC, 0x005D0CF4, 0x005D0D5A, 0x005D407C, 
						  0x005D40BC, 0x005D40FC, 0x005D412C, 0x005D415C, 0x005D480C, 0x005D484C, 0x005D48CC, 0x005D490C, 0x005D494C, 0x005D498C, 
						  0x005D49BC, 0x005D49EC, 0x005D6582, 0x005D7733, 0x005D79F2, 0x005D7B98, 0x005D8B4F, 0x005D8CB5, 0x005D9D2C, 0x005DAF91, 
						  0x005DB2FE, 0x005DB6F6, 0x005E059B, 0x005E403A, 0x005E408C, 0x005E410A, 0x005E41BC, 0x005E420C, 0x005E7CAC, 0x005E7FB3, 
						  0x005E82FB, 0x005E8EE1, 0x005E9166, 0x005E9172, 0x005E95A3, 0x005E95B2, 0x005E966E, 0x005E967D, 0x005E9EC2, 0x005E9ED3, 
						  0x005E9EF0, 0x005E9F31, 0x005E9F83, 0x005EAAD2, 0x005EAC5B, 0x005EAECC, 0x005EB118, 0x005EB387, 0x005EB39C, 0x005EB515, 
						  0x005EB541, 0x005EB1FB, 0x005EB995, 0x005ECC77, 0x005EDFE6, 0x005EDFFB, 0x005EE030, 0x005EE1AB, 0x005EE1BA, 0x005EE1EC, 
						  0x005EE7C1, 0x005EEC40, 0x005EF39F, 0x005EF5C9, 0x005EFB0F, 0x005F04E2, 0x005F0509, 0x005F0B9F, 0x005F0EA6, 0x005F704E, 
						  0x005F77C0, 0x005F7E79, 0x005F943C, 0x005F948C, 0x005F94CC, 0x005F950C, 0x005F954C, 0x005F958C, 0x005F95CC, 0x005F99E7, 
						  0x005F9824, 0x005FA1F4, 0x005FA265, 0x005FA2D5, 0x005FA9CC, 0x005FAA0C, 0x005FAB3E, 0x005FB61D, 0x005FB6DD, 0x005FB959, 
						  0x005FBA17, 0x005FBA9D, 0x005FBB2A, 0x005FBB72, 0x005FBCA0, 0x005FBEB8, 0x005FC161, 0x005FC221, 0x005FC84D, 0x005FCBE2, 
						  0x005FCC48, 0x005FCE4C, 0x005FCFBC, 0x005FD292, 0x005FD78C, 0x005FDFCF, 0x005FE222, 0x005FF9FF, 0x005FFAFF, 0x006016F4, 
						  0x00601C78, 0x00601CE0, 0x00601DDF, 0x00601E88, 0x0060932A, 0x0060937C, 0x00609A2C, 0x0060BC88, 0x0060C1BC, 0x0060D047, 
						  0x0060D083, 0x0060D194, 0x006102DF, 0x00615A31, 0x00615B70, 0x00616BBE, 0x00616C18, 0x00616C87, 0x00616D61, 0x0061966D, 
						  0x00619678, 0x0061968C, 0x00619761, 0x00619856, 0x00619893, 0x00619ACD, 0x0061A41C, 0x0061AB79, 0x0061AC16, 0x0061A9A4, 
						  0x0061A9F3, 0x0061ACF0, 0x0061AFFA, 0x0061B117, 0x0061D60D, 0x0061EE22, 0x0061EF1D, 0x0061FD3D, 0x00620A57, 0x0062125A, 
						  0x0062B2F4, 0x0062B61D, 0x0062B678, 0x0062B7B9, 0x0062BC03, 0x0062B5E6, 0x0062C273, 0x0062C17D, 0x0062C2CA, 0x0062C31A, 
						  0x0062E6BA, 0x00633BDC, 0x0063B066, 0x0063B378, 0x0063BB15, 0x0063BB46, 0x0063BB97, 0x0063BB6D, 0x006460E8, 0x006493F7, 
						  0x00649D4F, 0x0064B91A, 0x00650233, 0x00650341, 0x00650496, 0x006504B7, 0x006560CF, 0x006560FB, 0x0065D160, 0x0066311C, 
						  0x006641C7, 0x0066494C, 0x006649BC, 0x00664AD7, 0x00664D67, 0x00665A0C, 0x00665B4C, 0x00665BBC, 0x00668BFC, 0x0066943C, 
						  0x0066964C, 0x0066AD7C, 0x0066B98D, 0x0066BA9C, 0x0066BB7D, 0x0066C919, 0x0066CDD4, 0x0066E11C, 0x0066E1BC, 0x0066E21C, 
						  0x0066E252, 0x0066F437, 0x0066F71D, 0x0067008D, 0x006721FC, 0x0067237A, 0x006724E6, 0x00672578, 0x00672AB8, 0x0067324C, 
						  0x0067348C, 0x0067359C, 0x006735EC, 0x006737BC, 0x006738CC, 0x00676E3C, 0x00676F0C, 0x00676F78, 0x0067726C, 0x00677320, 
						  0x00677352, 0x0067742A, 0x0067764C, 0x00677C07, 0x00677D63, 0x0067803C, 0x006780CA, 0x0067812A, 0x006782A6, 0x00678312, 
						  0x006783DA, 0x006788DA, 0x006790CC, 0x00679360, 0x00679A9C, 0x00679B0C, 0x00679B8C, 0x00679C6C, 0x00679DBA, 0x00679DC6, 
						  0x0067A83A, 0x0067A9F2, 0x0067AA97, 0x0067AF67, 0x0067B8A7, 0x0067B9DC, 0x0067BA9C, 0x0067BD34, 0x0067BDE8, 0x0067C0F7, 
						  0x0067C710, 0x0067CDDC, 0x0067D13C, 0x0067D1ED, 0x0067D5EC, 0x0067D83C, 0x0067DC12, 0x0067DFBC, 0x0067DFFC, 0x0067EBBA, 
						  0x0067EC0A, 0x0067EC5C, 0x0067ECDC, 0x0067EE2C, 0x0067F01C, 0x006801CC, 0x006807A4, 0x006807DD, 0x006808CC, 0x006809ED, 
						  0x00680DE2, 0x006822C6, 0x00682579, 0x006826B7, 0x00682AE9, 0x00682C69, 0x006847DD, 0x00684F4C, 0x00684FFC, 0x00685072, 
						  0x00685FBC, 0x00686AAC, 0x00686D7C, 0x006870EC, 0x006871AC, 0x006871FC, 0x0068753C, 0x006889CC, 0x00688A5C, 0x00688ADC, 
						  0x00688B9C, 0x00689311, 0x0068B446, 0x0068B7C7, 0x0068B98C, 0x0068B9DF, 0x0068B829, 0x0068BD40, 0x0068BD8B, 0x0068BDDE, 
						  0x0068BC2E, 0x0068BBCC, 0x0068BF1F, 0x0068CA27, 0x0068CA3B, 0x0068D15C, 0x0068D1FC, 0x0068E42C, 0x0068E57C, 0x0068E626, 
						  0x0068FA0C, 0x0069060C, 0x006907CC, 0x0069089E, 0x0069129C, 0x006927BD, 0x0069310A, 0x0069315C, 0x006931AC, 0x00693346, 
						  0x0069372C, 0x006937DC, 0x006A17DD, 0x006A1A8D, 0x006A1C17, 0x006A1C44, 0x006A1C9F, 0x006A2375, 0x006A2631, 0x006A40FD, 
						  0x006A6290, 0x006AD026, 0x006AD041, 0x006AD2DC, 0x006AD355, 0x006AE16D, 0x006AE388, 0x006AEAEE, 0x006B905A, 0x006B998A, 
						  0x006B9A1C, 0x006BA0AC, 0x006BA10C, 0x006BA4D9, 0x006BA4CA, 0x006BD45B, 0x006BE5BB, 0x006BF09C, 0x006C4B5A, 0x006C584C, 
						  0x006C589C, 0x006C59BD, 0x006C5A3A, 0x006C5A8C, 0x006C5AF8, 0x006C5B1C, 0x006C5B9A, 0x006C8C36, 0x006C9796, 0x006CCC0B, 
						  0x006CCC4C, 0x006CDDBC, 0x006CE7EC, 0x006CE86C, 0x006CE8FB, 0x006CEB58, 0x006CEBEE, 0x006CED30, 0x006CED3D, 0x006CEDB2, 
						  0x006CEDCE, 0x006CEF65, 0x006CEFE2, 0x006CF0B5, 0x006CF136, 0x006CF15E, 0x006D5E1B, 0x006D5E0A, 0x006D5E8C, 0x006D5F1B, 
						  0x006D5F0A, 0x006D5F4C, 0x006D813A, 0x006DB70A, 0x006DBB9A, 0x006DBCCC, 0x006DBD9C, 0x006E60CC, 0x006E628A, 0x006E631C, 
						  0x006E650C, 0x006E655C, 0x006E8E4A, 0x006E90CD, 0x006E9115, 0x006E916A, 0x006E9287, 0x006EBD88, 0x006EBDED, 0x006EDAC2, 
						  0x006EDBC5, 0x006EDBED, 0x006EDC3A, 0x006F0A2B, 0x006F0F9A, 0x006F10D5, 0x006F10FF, 0x006F115A, 0x006F12A7, 0x006F13D1, 
						  0x006F4826, 0x006F49D8, 0x006F4A3D, 0x006F5591, 0x006F5429, 0x006F77FB, 0x006F9BC6, 0x006F9BDC, 0x006F9BEF, 0x006F9D5B, 
						  0x006F9D1E, 0x006F9DBC, 0x006F9DCD, 0x006F9DDC, 0x006F9F9C, 0x006F9FAD, 0x006F9FDA, 0x006FA00C, 0x006FA268, 0x006FA2B8, 
						  0x006FA2C9, 0x006FA324, 0x006FA2EE, 0x006FA464, 0x006FA4A1, 0x006FA44C, 0x006FA503, 0x006FA517, 0x006FA526, 0x006FA54A, 
						  0x006FA6EC, 0x006FA700, 0x006FA72D, 0x006FA75C, 0x006FAA62, 0x006FAAB5, 0x006FAAC6, 0x006FAAF1, 0x006FAB27, 0x006FB56C, 
						  0x006FB5B2, 0x00702643, 0x0070310A, 0x0070322C, 0x00703E3B, 0x0070422A, 0x00704327, 0x007043FC, 0x0070662D, 0x00706728, 
						  0x007067EA, 0x00706B50, 0x0070A526, 0x0070ECCD, 0x0070ED14, 0x0070EFA4, 0x0070EFBF, 0x0070F30B, 0x0070F345, 0x0070F4F6, 
						  0x0070F50E, 0x0070FFE7, 0x00710500, 0x00710825, 0x00710758, 0x0071471F, 0x0071491A, 0x00714855, 0x00718DBA, 0x00718FE2, 
						  0x007191F2, 0x0071995C, 0x00719B4C, 0x00719BCC, 0x00719C7A, 0x00719D0C, 0x0071A1CC, 0x0071A4CA, 0x0071BFEA, 0x0071CB4A, 
						  0x0071CC9C, 0x0071CD1C, 0x0071D6BC, 0x0071D70C, 0x0071ECC8, 0x0071EC85, 0x0071F310, 0x0071F304, 0x0071F652, 0x0071F6D5, 
						  0x0071F6F7, 0x0071F7AC, 0x0071F7CE, 0x007208ED, 0x00720ACA, 0x00720B1C, 0x00720BAC, 0x007266ED, 0x00726A83, 0x0072737C, 
						  0x0072743C, 0x0072829C, 0x00729ACC, 0x0072B785, 0x0072F807, 0x0072FB65, 0x0072FDE3, 0x0072FEB9, 0x00730372, 0x007356CE, 
						  0x00738846, 0x0073D2DF, 0x0073D735, 0x007405EC, 0x00740683, 0x00740701, 0x00740875, 0x0074097F, 0x00741997, 0x007421CB, 
						  0x00742352, 0x00742416, 0x007425BC, 0x00742616, 0x0074269E, 0x0074285E, 0x00742C4F, 0x00742D2C, 0x00742DC2, 0x00746770, 
						  0x00746977, 0x00746BA0, 0x0074A413, 0x0074BDF6, 0x00751CF5, 0x0075422C, 0x00754264, 0x007570F6, 0x007571D1, 0x0075723E, 
						  0x007572B1, 0x00757332, 0x007575CC, 0x00757E38, 0x007583F1, 0x007584E1, 0x0075852C, 0x007585C8, 0x00758639, 0x00758652, 
						  0x007591D1, 0x0075A038, 0x0075A5F0, 0x0075B0D2, 0x0076389C, 0x00766663, 0x00766883, 0x00767191, 0x0076B60F, 0x0076B709, 
						  0x0076DD96, 0x0076DDCD, 0x0076EB78, 0x0076F2CB, 0x00770A3C, 0x0077129B, 0x0077128A, 0x00775F81, 0x00775F8D, 0x00775FC9, 
						  0x00775FD5, 0x0077A310, 0x0077A343, 0x0077A418, 0x0077A45E, 0x0077B96D, 0x0077CB60, 0x00787525, 0x00799963, 0x0079B870, 
						  0x0079D830, 0x0079C75B, 0x007A0CF3, 0x007A694B, 0x007A6957, 0x007A69B4, 0x007A6D0A, 0x007B4A79, 0x007B4A85, 0x007B4A99, 
						  0x007B4ABA, 0x007B4C4F, 0x007B555B, 0x007B5CD0, 0x007B7AF2, 0x007B81D0, 0x007B81DC, 0x007B86D5, 0x007B97DC, 0x007BC789, 
						  0x007BC82E, 0x007BC93F, 0x007BC9F9, 0x007BCB0A, 0x007BCC49, 0x007BCCD0, 0x007BCD83, 0x007BC64F, 0x007C01A8, 0x007C8D50, 
						  0x007C8D5C, 0x007CD9B8, 0x007CF13C, 0x007CF44B, 0x007CF7DD, 0x007CFB1E, 0x007D15AE, 0x007D1C33, 0x007D3641, 0x007DB5A9, 
						  0x007DE0ED, 0x007E0E11, 0x007E880A, 0x007E885A, 0x007E88CC, 0x007E894C, 0x007E8ADC, 0x007E8BEA, 0x007E8F7C, 0x007E9B7C, 
						  0x007E9BCC, 0x007E9C1C, 0x007EC5C3, 0x007EF17B, 0x007F0BEC, 0x007F1F6D, 0x007F3215, 0x007F33F4, 0x007F63F8, 0x007F63EC, 
						  0x007F9C63, 0x007FBB6E, 0x007FCCEC, 0x007FCF83, 0x007FCF90, 0x007FD560, 0x007FD56C, 0x007FE80E, 0x007FF53D, 0x00804B4C, 
						  0x00804D76, 0x00804D6A, 0x00806CA0, 0x00806D0F, 0x00806F85, 0x008098DF, 0x008098EB, 0x00809BEA, 0x00809C48, 0x00809C69, 
						  0x00809E0D, 0x00809E78, 0x00809E99, 0x0080B68B, 0x0080B698, 0x0080B75B, 0x0080B768, 0x0080E478, 0x0080E4E7, 0x0080ED66, 
						  0x0080ED72, 0x0080EE31, 0x0080EE3D, 0x0080F78A, 0x0080F7DC, 0x0080F95C, 0x0080F9DC, 0x00822D37, 0x00822E52, 0x00823BDD, 
						  0x008243F9, 0x00824A39, 0x00827203, 0x0082720F, 0x00827357, 0x00827363, 0x00829BCC, 0x00829C46, 0x00829DB0, 0x00829E00, 
						  0x00829E2C, 0x0082A016, 0x0082A05F, 0x0082A0AB, 0x0082B26C, 0x0082C05B, 0x00832B5C, 0x00832B68, 0x00832BB0, 0x00832D79, 
						  0x00832D85, 0x00832E5C, 0x008342D4, 0x0083490A, 0x00834AC0, 0x00834ACC, 0x0083544F, 0x0083545B, 0x008355CA, 0x008355D6, 
						  0x008358A1, 0x008358AD, 0x008360FD, 0x00836109, 0x00836163, 0x008361E2, 0x00836248, 0x00837F79, 0x00837F85, 0x00838069, 
						  0x00838075, 0x008382AE, 0x008382BA, 0x00838A4D, 0x0083E85A, 0x0083ED7A, 0x0083F01C, 0x0084236B, 0x008423E0, 0x008428D2, 
						  0x00842F7B, 0x00843805, 0x00846DA5, 0x00849C6C, 0x00849D07, 0x0084A91C, 0x00850309, 0x00850407, 0x00850413, 0x00850D82, 
						  0x00850D8F, 0x0085112E, 0x0085113A, 0x0085120E, 0x0085121A, 0x00851D22, 0x00851D69, 0x00853A6B, 0x00853A77, 0x00853EB7, 
						  0x00853EC3, 0x00853F97, 0x00853FA3, 0x008541ED, 0x008541F9, 0x008556AC, 0x0085572A, 0x0085577C, 0x0085598C, 0x0086481E, 
						  0x0086477C, 0x00864A1D, 0x00865845, 0x00865FF9, 0x00866D09, 0x0086756C, 0x00867630, 0x00867C15, 0x00867C36, 0x0086A3B0, 
						  0x0086C348, 0x0086DE71, 0x0086DE84, 0x0086E6CC, 0x0086FC43, 0x0086FC73, 0x0086FCD5, 0x0086FD34, 0x0086FEED, 0x0087378E, 
						  0x0087AA1C, 0x0087B9DC, 0x0087BBDC, 0x0087EDF1, 0x0087F26A, 0x0087F2DA, 0x0087F8D0, 0x00881F17, 0x008822E3, 0x00882742, 
						  0x00882DE9, 0x00882836, 0x00883892, 0x00883D75, 0x00883DAE, 0x00884C80, 0x00884D39, 0x00884D4A, 0x00884D57, 0x00884DBF, 
						  0x00884E3C, 0x00884EA1, 0x00884FEB, 0x0088506B, 0x0088518C, 0x0088521A, 0x00885225, 0x00885312, 0x0088531F, 0x0088532E, 
						  0x008853B5, 0x00885438, 0x008857FD, 0x00886A6E, 0x008869AA, 0x00886B62, 0x0088875C, 0x00888ABB, 0x00888B42, 0x00889870, 
						  0x008898F5, 0x008899D6, 0x00889B75, 0x00889AB4, 0x00889B9C, 0x0088BBCA, 0x0088BFAC, 0x0088C06C, 0x0088C0EC, 0x008919BA, 
						  0x00891BEA, 0x00891C3C, 0x00891D3A, 0x00891DCC, 0x0089205C, 0x008920BC, 0x008922CB, 0x008922BA, 0x0089576A, 0x00896D3A, 
						  0x00896DCC, 0x00896E4C, 0x00896EAC, 0x008971DA, 0x0089786C, 0x008978EC, 0x0089794C, 0x008A382C, 0x008A38AC, 0x008A3E71, 
						  0x008A3E7E, 0x008A64E3, 0x008A658A, 0x008A91CC, 0x008A9F76, 0x008AA07F, 0x008AA0CC, 0x008AAD00, 0x008AADA0, 0x008AE78C, 
						  0x008AE9EB, 0x008AEC72, 0x008AFD4F, 0x008B3843, 0x008C18A8, 0x008C8EC1, 0x008C929C, 0x008CC2CA, 0x008CC6E7, 0x008CD147, 
						  0x008CD396, 0x008CD749, 0x008CDA5A, 0x008CD5B7, 0x008CE1AE, 0x008CE7A6, 0x008CE8B6, 0x008CE9F3, 0x008CEC94, 0x008CF543, 
						  0x008D0A32, 0x008D23C6, 0x008D23D2, 0x008D82F2, 0x008D7C71, 0x008D7C80, 0x008D8868, 0x008D9637, 0x008D9646, 0x008DEE9D, 
						  0x008DFF7B, 0x008E070C, 0x008E27F4, 0x008E2E11, 0x008E3356, 0x008E6673, 0x008E669B, 0x008E7BB1, 0x008E7BC4, 0x008E9389, 
						  0x008E939B, 0x008E9646, 0x008E9684, 0x008E9690, 0x008E969E, 0x008E96A7, 0x008E9826, 0x008E9864, 0x008E9870, 0x008E987E, 
						  0x008E9887, 0x008E98FE, 0x008E992E, 0x008E9979, 0x008E9985, 0x008E9993, 0x008E999C, 0x008E9C9A, 0x008E9CC3, 0x008E9BE4, 
						  0x008E9C10, 0x008E9C19, 0x008E9F23, 0x008E9F2C, 0x008EA005, 0x008EA011, 0x008EA075, 0x008EA09D, 0x008EA25B, 0x008EA3FE, 
						  0x008EA40A, 0x008EA575, 0x008EA625, 0x008EA62E, 0x008EA7AA, 0x008EA7BA, 0x008EA84F, 0x008EA858, 0x008EABCF, 0x008EABDD, 
						  0x008EAAE9, 0x008EAB36, 0x008EAB50, 0x008EAB78, 0x008EB070, 0x008EB23F, 0x008EB2AE, 0x008EB174, 0x008EB1A4, 0x008EB623, 
						  0x008EB62F, 0x008ECAD4, 0x008ED0BB, 0x008ED129, 0x008ED132, 0x008ED159, 0x008ED1AF, 0x008ED1DE, 0x008ECFFD, 0x008ED051, 
						  0x008ED08B, 0x008ED0AB, 0x008EDC68, 0x008EDE4C, 0x008EE74A, 0x008EE756, 0x008EE599, 0x008EE5AD, 0x008EE5FB, 0x008EE8A7, 
						  0x008EE8B7, 0x008EE90F, 0x008EE91B, 0x008EE92F, 0x008EE94C, 0x008EEABF, 0x008EE9E6, 0x008EEA05, 0x008EEA1B, 0x008EEA37, 
						  0x008EEA4D, 0x008EEA6A, 0x008EEA80, 0x008EEA9C, 0x008EED07, 0x008EED2E, 0x008EEC81, 0x008EEC9E, 0x008EECAE, 0x008EEEA7, 
						  0x008EEEB7, 0x008EEED5, 0x008EEDAC, 0x008EEE07, 0x008EEE17, 0x008EEE2E, 0x008EEE42, 0x008EEF2A, 0x008EEFDE, 0x008EF14C, 
						  0x008EF33F, 0x008EF369, 0x008EF226, 0x008EF248, 0x008EF25C, 0x008EF26F, 0x008EF2A5, 0x008EF2C0, 0x008EF6B8, 0x008EF763, 
						  0x008EF78C, 0x008EF7A2, 0x008EFBE7, 0x008EFC31, 0x008EFC42, 0x008EFB3D, 0x008EFB80, 0x008EFBC2, 0x008EFD18, 0x008EFD2C, 
						  0x008EFD35, 0x008F0441, 0x008F04DB, 0x008F0540, 0x008F05E8, 0x008F0742, 0x008F0E0E, 0x008F0E28, 0x008F0E63, 0x008F0E76, 
						  0x008F0E82, 0x008F0E95, 0x008F0F79, 0x008F1037, 0x008F109C, 0x008F136E, 0x008F150A, 0x008F300F, 0x008F302A, 0x008F2F78, 
						  0x008F2F8D, 0x008F2F9F, 0x008F2FB7, 0x008F5887, 0x008F5890, 0x008F5950, 0x008F842A, 0x008F92E7, 0x008FADD8, 0x008FB138, 
						  0x008FB14D, 0x008FB2E0, 0x008FB43E, 0x008FB553, 0x008FB58D, 0x008FD72A, 0x008FD77C, 0x008FDB8C, 0x008FDC9C, 0x008FDF22, 
						  0x008FE7E7, 0x008FE6C3, 0x008FE6F6, 0x008FE743, 0x008FE78A, 0x008FEBD6, 0x008FEC5B, 0x008FECCF, 0x008FF6A2, 0x008FF6D9, 
						  0x008FF6EB, 0x008FF750, 0x008FF9EB, 0x008FF90D, 0x008FF943, 0x008FF962, 0x008FFABD, 0x008FFB0D, 0x008FFBE7, 0x008FFC56, 
						  0x008FFD40, 0x008FFE20, 0x008FFF8D, 0x008FFFAA, 0x008FFFC9, 0x0090000E, 0x00900142, 0x0090018E, 0x0090088B, 0x00900894, 
						  0x009008D6, 0x009008F9, 0x00900902, 0x009009E9, 0x009007D5, 0x00900E3B, 0x009007DE, 0x009007FB, 0x00900804, 0x00900821, 
						  0x009013F2, 0x0090168B, 0x0090186D, 0x00901A31, 0x00901C63, 0x00901C8E, 0x00901D31, 0x00901E20, 0x00901FC5, 0x009020D7, 
						  0x00902180, 0x009021A5, 0x00902613, 0x00903D3C, 0x00904EFD, 0x0090509C, 0x00905115, 0x00905191, 0x009051A7, 0x0090532E, 
						  0x009053A1, 0x009053B7, 0x009055CE, 0x00905649, 0x00905673, 0x009058BA, 0x00905A4D, 0x00905A80, 0x00905CA1, 0x00905D11, 
						  0x00905D60, 0x00906D43, 0x00906D76, 0x00906E1E, 0x009073E7, 0x009074C7, 0x00907552, 0x009075C5, 0x00907806, 0x00907861, 
						  0x00907896, 0x009078B6, 0x00907A15, 0x00907A73, 0x00907A86, 0x00907B03, 0x00907B19, 0x00907B8F, 0x00907B98, 0x00907DDD, 
						  0x00907DED, 0x00907CB4, 0x00907CEC, 0x00907D0C, 0x00907D4F, 0x00907D58, 0x00907F57, 0x00908255, 0x009082D3, 0x0090814D, 
						  0x00908520, 0x0090870F, 0x0090871F, 0x0090873B, 0x00908770, 0x0090883A, 0x00908912, 0x00908ADE, 0x00908B8F, 0x00908BA8, 
						  0x00908BCA, 0x00908BEE, 0x00908E0E, 0x00908E2A, 0x00908F0D, 0x00908F31, 0x00909078, 0x00909088, 0x0090909E, 0x009090B6, 
						  0x009090E0, 0x009090E9, 0x0090915E, 0x0090916A, 0x00909211, 0x00909221, 0x00909268, 0x00909288, 0x00909298, 0x00909411, 
						  0x00909439, 0x00909442, 0x00909368, 0x00909378, 0x009093C7, 0x00909401, 0x0090951E, 0x009095B3, 0x009095BC, 0x009096E1, 
						  0x009096EA, 0x00909819, 0x00909831, 0x0090991B, 0x00909B37, 0x00909A2E, 0x00909A4E, 0x00909BCF, 0x00909BF3, 0x00909C8E, 
						  0x00909CBF, 0x00909CC8, 0x00909D8A, 0x00909D93, 0x00909DCC, 0x00909DD5, 0x00909F5C, 0x00909F78, 0x0090A155, 0x0090A1BA, 
						  0x0090A253, 0x0090A56C, 0x0090A72A, 0x0090A74A, 0x0090A77F, 0x0090A788, 0x0090A926, 0x0090A942, 0x0090AE00, 0x0090AE6A, 
						  0x00919F72, 0x0091ACE2, 0x0091B271, 0x0091CC5C, 0x0091CDEB, 0x0091CF31, 0x0091CF47, 0x0091CF5F, 0x0091CF77, 0x0091CF8D, 
						  0x0091D275, 0x0091D29B, 0x0091D2A4, 0x0091D2C0, 0x0091D414, 0x0091D433, 0x0091D48F, 0x0091D4D0, 0x0091D510, 0x0091D626, 
						  0x0091D63C, 0x0091D7EE, 0x0091D859, 0x0091D862, 0x0091D7A9, 0x0091D7B2, 0x0091D7DE, 0x0091D8AA, 0x0091E57E, 0x0091E64A, 
						  0x0091E7BF, 0x0091E81A, 0x0091E89C, 0x0091E8FA, 0x00922ACC, 0x00922BFC, 0x00922F8B, 0x0092309C, 0x0092572A, 0x009257AC, 
						  0x0092585C, 0x00925FB4, 0x00925FF6, 0x0092606D, 0x009260FD, 0x009261BC, 0x0092624E, 0x00926306, 0x00925E16, 0x009264CB, 
						  0x00925E6F, 0x00925E9F, 0x0092C8BD, 0x0092C8D6, 0x0092CC18, 0x0092CDE6, 0x0092CDF5, 0x00931AC8, 0x009335A8, 0x00933640, 
						  0x00937641, 0x009376A1, 0x009377F3, 0x00937812, 0x00937CFA, 0x009381F8, 0x00938204, 0x00938BB9, 0x00938BE4, 0x00938C0A, 
						  0x00938C13, 0x00938AD5, 0x00938AF6, 0x00938B17, 0x00938B9F, 0x00938ECF, 0x00939046, 0x0093908D, 0x0093922E, 0x00938DF4, 
						  0x00938E07, 0x009395EE, 0x0093976D, 0x009397FE, 0x00939833, 0x00938E79, 0x00939E9B, 0x00939EAD, 0x00939EDD, 0x00939EE8, 
						  0x00939F0A, 0x0093A01F, 0x0093A044, 0x0093A065, 0x0093A15B, 0x0093BBEC, 0x0093BD3A, 0x0093BDDA, 0x0093BF7A, 0x0093C06A, 
						  0x0093C12A, 0x0093C1EA, 0x0093C25A, 0x0093C2DA, 0x0093C34A, 0x0093C3C1, 0x0093C4AA, 0x0093C55A, 0x0093C65A, 0x0093C6CA, 
						  0x0093EBAA, 0x0093EC6A, 0x0093ED0A, 0x0093EDCA, 0x0093EE3A, 0x0093EEFA, 0x0093F288, 0x0093F2CB, 0x0093F2EB, 0x0093F304, 
						  0x0093F31D, 0x0093F483, 0x0093F4FA, 0x0093F50A, 0x0093F570, 0x0093F582, 0x0093F3A2, 0x0093F886, 0x0093F8BC, 0x0093F8F0, 
						  0x0093F987, 0x0093FA67, 0x0093F3EF, 0x0093F413, 0x0093F43C, 0x0093F44C, 0x0093FCC8, 0x0093FBD1, 0x0093FD76, 0x0093FD82, 
						  0x0093FDBD, 0x0094053A, 0x0094090A, 0x00940926, 0x0094093C, 0x00940969, 0x00940972, 0x00940AD3, 0x00940ADC, 0x00940B13, 
						  0x00940B1C, 0x00940B62, 0x009409EA, 0x00940A0D, 0x00940A27, 0x00940A54, 0x00940A5D, 0x00940A7F, 0x00940A8F, 0x00940C58, 
						  0x00940E3D, 0x00940E46, 0x00940E5A, 0x00940E63, 0x00940E8B, 0x00940E9C, 0x00940D6E, 0x00940D88, 0x00940DA2, 0x00940DCC, 
						  0x00940DD5, 0x00940DF1, 0x00940E01, 0x00940FC8, 0x00940FD1, 0x00940FEC, 0x00940FF5, 0x00941093, 0x0094118A, 0x009411A4, 
						  0x00941231, 0x009421CA, 0x0094225A, 0x0094240A, 0x009424BA, 0x0094257A, 0x0094265A, 0x00942E6A, 0x00942E73, 0x00942DA0, 
						  0x00942DA9, 0x00942DE9, 0x00942DF2, 0x00942E1D, 0x00942E2D, 0x00942F4B, 0x00942F5B, 0x00942FED, 0x0094300E, 0x00943017, 
						  0x00943048, 0x00943058, 0x0094308E, 0x00943097, 0x00943337, 0x0094336F, 0x0094324C, 0x00943255, 0x0094328F, 0x00943298, 
						  0x009439C2, 0x009439CB, 0x00943B5E, 0x00943B67, 0x00943BF0, 0x00943C0E, 0x00943A99, 0x00943AA2, 0x00943AFF, 0x00943B22, 
						  0x00943B2B, 0x00943E49, 0x00943EA9, 0x00943ECB, 0x00943F0F, 0x00943D56, 0x00943D82, 0x00943D9C, 0x00943DA5, 0x00943DC1, 
						  0x00943DDB, 0x00943DFA, 0x009440B8, 0x009440E0, 0x0094413F, 0x00944148, 0x0094416E, 0x00944177, 0x009441AF, 0x009441C8, 
						  0x00944029, 0x00944437, 0x00944480, 0x00944356, 0x0094435F, 0x00944384, 0x00944394, 0x009443AE, 0x009443C2, 0x0094441D, 
						  0x009445FF, 0x00944608, 0x00944641, 0x0094465A, 0x0094459B, 0x009445C3, 0x00944828, 0x00944831, 0x0094495A, 0x00944982, 
						  0x009449B6, 0x009449EF, 0x00944A38, 0x00944A76, 0x00944AC1, 0x00944732, 0x00944744, 0x0094476B, 0x00944785, 0x00944D30, 
						  0x00944C58, 0x00944C61, 0x00944F27, 0x00944F71, 0x00944DD6, 0x00944DE8, 0x00944DFA, 0x00944E03, 0x00944E1F, 0x00944E47, 
						  0x00944E91, 0x00944E9A, 0x0094507A, 0x00945083, 0x009452D2, 0x00945306, 0x0094534B, 0x00945159, 0x0094516B, 0x00945192, 
						  0x009451AC, 0x009451EE, 0x009451F7, 0x009470EA, 0x0094720A, 0x009472CA, 0x009498DE, 0x00949902, 0x0094992B, 0x009497F1, 
						  0x0094983A, 0x00949981, 0x0094999A, 0x009499F1, 0x00949A16, 0x00949A67, 0x00949A7D, 0x00949AFA, 0x00949B6B, 0x00949B88, 
						  0x00949BD1, 0x00949C4A, 0x00949C8E, 0x00949E85, 0x0094A07B, 0x0094A1E4, 0x00949F02, 0x00949F14, 0x00949F3B, 0x00949F7A, 
						  0x00949FA4, 0x0094A4F4, 0x0094A529, 0x0094A469, 0x0094A480, 0x0094A830, 0x0094A84E, 0x0094A91F, 0x0094A68A, 0x0094A6C7, 
						  0x0094A6DD, 0x0094A6F0, 0x0094A9F9, 0x0094B53C, 0x0094B66A, 0x0094B6DA, 0x0094B74A, 0x0094E143, 0x0094E14C, 0x0094E1DA, 
						  0x0094E1FB, 0x0094E204, 0x0094E22F, 0x0094E23F, 0x0094E26F, 0x0094E278, 0x009500A2, 0x0095010D, 0x009501EE, 0x00950223, 
						  0x0094FF5B, 0x0094FF64, 0x0094FFA1, 0x0094FFAA, 0x00950634, 0x0095063D, 0x009506CD, 0x00950708, 0x009505A4, 0x009505AD, 
						  0x009505D4, 0x009505DD, 0x00950B51, 0x00950D71, 0x00950D7A, 0x00950DC4, 0x00950DCD, 0x00950C01, 0x009511A4, 0x009510B7, 
						  0x009510E6, 0x009510EF, 0x00951110, 0x00951147, 0x00953F0A, 0x0095401A, 0x0095412A, 0x009541AA, 0x009568B6, 0x009568F0, 
						  0x00956937, 0x0095694A, 0x0095695B, 0x00956A04, 0x00956CAA, 0x00956CC2, 0x00956E34, 0x00956E4C, 0x00956E7A, 0x00956F0C, 
						  0x00956B52, 0x00956F3A, 0x00956B66, 0x00956B79, 0x00956B90, 0x0095712C, 0x0095713C, 0x00957254, 0x0095733B, 0x009573A6, 
						  0x009573D4, 0x00957023, 0x00957069, 0x0095707A, 0x009575CD, 0x0095758B, 0x009579C0, 0x009578A6, 0x009578DE, 0x009578E7, 
						  0x00957939, 0x00957957, 0x00957B35, 0x00957C75, 0x00957C7E, 0x00957BCD, 0x00957BD8, 0x00957C05, 0x00957C0E, 0x00957C2F, 
						  0x00957C38, 0x00959A8A, 0x00959B4A, 0x00959C0A, 0x00959C7A, 0x00959D0A, 0x00959D7A, 0x00959DEA, 0x00959EAA, 0x0095A11A, 
						  0x0095A18A, 0x0095A1FA, 0x0095DAE1, 0x0095DB21, 0x0095DB37, 0x0095DB4E, 0x0095DCB4, 0x0095DC00, 0x0095DC19, 0x0095DFB5, 
						  0x0095E17C, 0x0095E26C, 0x0095E2B4, 0x0095DF34, 0x0095DF57, 0x0095E39F, 0x0095E3E6, 0x0095E416, 0x0095E42C, 0x0095E483, 
						  0x0095E48F, 0x0095E54A, 0x0095E55A, 0x0095E583, 0x0095E61F, 0x0095E843, 0x0095E867, 0x0095E912, 0x0095E723, 0x0095E73C, 
						  0x0095E74B, 0x0095E787, 0x0095EB4C, 0x0095EB55, 0x0095EB86, 0x0095EB8F, 0x0095EC05, 0x0095EC1B, 0x0095EC3B, 0x0095EA61, 
						  0x0095EA7C, 0x0095EA9F, 0x0095EDD8, 0x0095EE06, 0x0095EE60, 0x0095EE79, 0x0095EEA4, 0x0095EEE0, 0x0095EF23, 0x0095EDB1, 
						  0x0095F15E, 0x0095F189, 0x0095F215, 0x0095F22B, 0x0095F24B, 0x0095F25A, 0x0095F081, 0x0095F09C, 0x0095F0B2, 0x0095F0CE, 
						  0x0095F375, 0x0095F381, 0x0095F57B, 0x0095F5FB, 0x0095F637, 0x0095F4AD, 0x0095F4DD, 0x0095F52A, 0x0095F6FB, 0x0095F951, 
						  0x0095F976, 0x0095F9B6, 0x0095FA31, 0x0095F887, 0x0095F8CF, 0x0095F8F1, 0x0095FC0E, 0x0095FB16, 0x0095FB30, 0x0095FB39, 
						  0x0095FB53, 0x0095FB70, 0x0095FB79, 0x0095FBB7, 0x0095FD93, 0x0095FD39, 0x0095FFC1, 0x0095FFDE, 0x0095FF07, 0x0095FFA2, 
						  0x009621EA, 0x0096227C, 0x00962A6A, 0x00962ADA, 0x00962CFA, 0x00962DBA, 0x00962E7A, 0x00962F3A, 0x00962FFA, 0x009630BA, 
						  0x009631CA, 0x0096329A, 0x0096335A, 0x009633EA, 0x0096344C, 0x00963F02, 0x00963F14, 0x00963F7D, 0x00963F86, 0x00963FA1, 
						  0x00964012, 0x0096401B, 0x00964F7D, 0x00965224, 0x0096522D, 0x0096524B, 0x009653E4, 0x009655AE, 0x009655CA, 0x009656BD, 
						  0x009656DA, 0x009656F7, 0x00965883, 0x009658EE, 0x0096590B, 0x0096595E, 0x00965A84, 0x00965EE2, 0x00965FA2, 0x00966018, 
						  0x00966CCA, 0x00966D3A, 0x00966DFA, 0x00966E9A, 0x009673B1, 0x009675D3, 0x009675F9, 0x00967624, 0x00967686, 0x0096779B, 
						  0x009677C9, 0x009677DF, 0x009677E8, 0x00967829, 0x00967841, 0x0096784E, 0x00967916, 0x0096791F, 0x0096794A, 0x00967953, 
						  0x00967529, 0x00967570, 0x00967599, 0x009675A2, 0x00967B18, 0x00967B49, 0x00967C13, 0x00967C71, 0x00967C7A, 0x00967D8C, 
						  0x00967D95, 0x00967DC5, 0x00967A82, 0x00967B0F, 0x00967F2F, 0x00967F38, 0x00967FA1, 0x0096802F, 0x00968151, 0x00968182, 
						  0x009681B6, 0x009681C6, 0x009681DF, 0x009685AA, 0x009685C8, 0x009685FC, 0x009686D3, 0x009686F1, 0x0096872D, 0x00968736, 
						  0x00968750, 0x009687D1, 0x00968F88, 0x0096915A, 0x009691CA, 0x009695F5, 0x00969698, 0x00969802, 0x00969818, 0x0096988A, 
						  0x00969A00, 0x00969ABA, 0x00969ACF, 0x00969BE5, 0x00969C11, 0x00969C1A, 0x00969F3E, 0x0096A12C, 0x0096D18A, 0x0096F3BC, 
						  0x0096F3CF, 0x0096F483, 0x0096F512, 0x0096F5A3, 0x0096F62E, 0x0096F63A, 0x0096F65D, 0x0096F83A, 0x0096F854, 0x0096FA25, 
						  0x0096FA2E, 0x0096F8D1, 0x0096F96F, 0x0096FF3A, 0x0096FFAA, 0x0097053C, 0x0097055F, 0x00970568, 0x00970730, 0x00970776, 
						  0x009707AB, 0x009707E4, 0x00970600, 0x00970612, 0x00970639, 0x00970653, 0x009706A1, 0x009709E9, 0x00970A1E, 0x00970A56, 
						  0x009708DE, 0x009708F0, 0x0097099A, 0x00970B86, 0x00970B9F, 0x00971966, 0x00971EE5, 0x00971F82, 0x00971F9F, 0x009720BF, 
						  0x00971E05, 0x00971E8C, 0x00971EB0, 0x0097239E, 0x009728D0, 0x009728EE, 0x00972908, 0x00972BBE, 0x00972C10, 0x00972AD5, 
						  0x00972B43, 0x00972D62, 0x00972FB3, 0x00973041, 0x009733BB, 0x009733A8, 0x00973457, 0x00973463, 0x0097349E, 0x009734AD, 
						  0x009747BA, 0x0097484A, 0x0097490A, 0x009749EA, 0x00974A5A, 0x00974AFA, 0x00974B6A, 0x00974BDA, 0x00978636, 0x009786C1, 
						  0x00978736, 0x00978752, 0x009787F5, 0x00978851, 0x00978905, 0x00978970, 0x00978991, 0x009789A3, 0x00978F9A, 0x0097900A, 
						  0x0097957A, 0x009795A4, 0x009795F9, 0x0097960F, 0x009797D7, 0x009797F1, 0x0097985D, 0x00979892, 0x009796DC, 0x00979BA7, 
						  0x00979D61, 0x00979D71, 0x00979D8F, 0x00979D98, 0x00979DE8, 0x00979E28, 0x00979CC3, 0x00979CFE, 0x0097A031, 0x0097A060, 
						  0x00979F77, 0x0097AD4A, 0x0097ADBA, 0x0097AEBA, 0x0097AF7A, 0x0097C871, 0x0097CD2A, 0x0097F252, 0x0098067A, 0x00983DEA, 
						  0x00983F3D, 0x00983FBA, 0x00983F6C, 0x0098402A, 0x0098484C, 0x00985903, 0x00985953, 0x0098D6FF, 0x0098E68F, 0x0098F2E5, 
						  0x0099995F, 0x0099A43F, 0x0099C003, 0x0099C013, 0x0099C261, 0x0099C2D5, 0x0099C2E4, 0x0099C2F1, 0x0099C42B, 0x0099C43B, 
						  0x0099E0E9, 0x0099E124, 0x009A015E, 0x009A1D63, 0x009A24BF, 0x009A39D7, 0x009A3A20, 0x009A3A38, 0x009A3A61, 0x009A46C6, 
						  0x009A46D2, 0x009A5043, 0x009A5053, 0x009A5328, 0x009A53A0, 0x009A53AF, 0x009A53BC, 0x009A541B, 0x009A542B, 0x009A6259, 
						  0x009AEC7C, 0x009B2172, 0x009B34FD, 0x009B385C, 0x009B46CC, 0x009B481A, 0x009B4E2C, 0x009B50EC, 0x009B5433, 0x009B5AF6, 
						  0x009B5A06, 0x009B5AA8, 0x009B6001, 0x009B7041, 0x009B7823, 0x009B8C40, 0x009B8C5C, 0x009B930C, 0x009B9CB5, 0x009B9CC2, 
						  0x009BA053, 0x009BA063, 0x009BA26E, 0x009BA27B, 0x009BA46B, 0x009BA47B, 0x009BC2A1, 0x009BC1C2, 0x009BC1CE, 0x009BE6B1, 
						  0x009BECCA, 0x009BEF56, 0x009C07ED, 0x009C24F7, 0x009C73EE, 0x009C84BF, 0x009C9504, 0x009C9510, 0x009CA0D3, 0x009CA0E3, 
						  0x009CA26B, 0x009CA27B, 0x009CD319, 0x009CD32E, 0x009CE77A, 0x009D218F, 0x009D5C53, 0x009D6DEF, 0x009D6CE4, 0x009D7210, 
						  0x009D738B, 0x009D7556, 0x009DA08A, 0x009DAC83, 0x009DC400, 0x009DD730, 0x009E6222, 0x009E8884, 0x009E97F4, 0x009F0F9C, 
						  0x009F1511, 0x009F13AC, 0x009F3259, 0x009F38E0, 0x009F43B3, 0x009F4C93, 0x009F8EF6, 0x009F913F, 0x009F927A, 0x009FA285, 
						  0x009FA433, 0x009FA452, 0x009FCB9D, 0x009FCC4D, 0x009FE03C, 0x009FFD82, 0x00A0124C, 0x00A024FA, 0x00A06224, 0x00A069A8, 
						  0x00A06D53, 0x00A06DA0, 0x00A06C87, 0x00A06D06, 0x00A07078, 0x00A0724B, 0x00A072D8, 0x00A09FFC, 0x00A0A2EF, 0x00A0A315, 
						  0x00A0A323, 0x00A0A36B, 0x00A0CA69, 0x00A16E3A, 0x00A16DBC, 0x00A16EDC, 0x00A16FFB, 0x00A16F4C, 0x00A170AC, 0x00A1E15A, 
						  0x00A1E1AA, 0x00A1E32A, 0x00A1E37C, 0x00A1ED4C, 0x00A1EDAC, 0x00A2176A, 0x00A2184C, 0x00A21DA3, 0x00A278C6, 0x00A277B5, 
						  0x00A27D3E, 0x00A27DC5, 0x00A284CC, 0x00A29A0F, 0x00A29A27, 0x00A29A3F, 0x00A29A57, 0x00A29A6F, 0x00A29A87, 0x00A29EDF, 
						  0x00A29EF7, 0x00A29F0F, 0x00A29F27, 0x00A29F3F, 0x00A29F57, 0x00A2A19F, 0x00A2A1B7, 0x00A2A1CF, 0x00A2A1E7, 0x00A2A1FF, 
						  0x00A2A217, 0x00A2A45F, 0x00A2A477, 0x00A2A48F, 0x00A2A4A7, 0x00A2A4BF, 0x00A2A4D7, 0x00A2A78F, 0x00A2A7A7, 0x00A2A7BF, 
						  0x00A2A7D7, 0x00A2A7EF, 0x00A2A807, 0x00A2AA4F, 0x00A2AA67, 0x00A2AA7F, 0x00A2AA97, 0x00A2AAAF, 0x00A2AAC7, 0x00A2AD0F, 
						  0x00A2AD27, 0x00A2AD3F, 0x00A2AD57, 0x00A2AD6F, 0x00A2AD87, 0x00A2B03F, 0x00A2B057, 0x00A2B06F, 0x00A2B087, 0x00A2B09F, 
						  0x00A2B0B7, 0x00A2B2FF, 0x00A2B317, 0x00A2B32F, 0x00A2B347, 0x00A2B35F, 0x00A2B377, 0x00A2B5BF, 0x00A2B5D7, 0x00A2B5EF, 
						  0x00A2B607, 0x00A2B61F, 0x00A2B637, 0x00A2B87F, 0x00A2B897, 0x00A2B8AF, 0x00A2B8C7, 0x00A2B8DF, 0x00A2B8F7, 0x00A2BB3F, 
						  0x00A2BB57, 0x00A2BB6F, 0x00A2BB87, 0x00A2BB9F, 0x00A2BBB7, 0x00A2BDFF, 0x00A2BE17, 0x00A2BE2F, 0x00A2BE47, 0x00A2BE5F, 
						  0x00A2BE77, 0x00A2C1BF, 0x00A2C1D7, 0x00A2C1EF, 0x00A2C207, 0x00A2C21F, 0x00A2C237, 0x00A2C47F, 0x00A2C497, 0x00A2C4AF, 
						  0x00A2C4C7, 0x00A2C4DF, 0x00A2C4F7, 0x00A2C73F, 0x00A2C757, 0x00A2C76F, 0x00A2C787, 0x00A2C79F, 0x00A2C7B7, 0x00A2C9FF, 
						  0x00A2CA17, 0x00A2CA2F, 0x00A2CA47, 0x00A2CA5F, 0x00A2CA77, 0x00A2CCBF, 0x00A2CCD7, 0x00A2CCEF, 0x00A2CD07, 0x00A2CD1F, 
						  0x00A2CD37, 0x00A2CF7F, 0x00A2CF97, 0x00A2CFAF, 0x00A2CFC7, 0x00A2CFDF, 0x00A2CFF7, 0x00A2D23F, 0x00A2D257, 0x00A2D26F, 
						  0x00A2D287, 0x00A2D29F, 0x00A2D2B7, 0x00A2D4FF, 0x00A2D517, 0x00A2D52F, 0x00A2D547, 0x00A2D55F, 0x00A2D577, 0x00A2D7BF, 
						  0x00A2D7D7, 0x00A2D7EF, 0x00A2D807, 0x00A2D81F, 0x00A2D837, 0x00A2DA7F, 0x00A2DA97, 0x00A2DAAF, 0x00A2DAC7, 0x00A2DADF, 
						  0x00A2DAF7, 0x00A2E40C, 0x00A42294, 0x00A49E97, 0x00A49EF4, 0x00A5E528, 0x00A7C14D, 0x00A7DEB7, 0x00A8FD9A, 0x00A8FD4C, 
						  0x00A90B98, 0x00BB9AF4, 0x00BB9FA5, 0x00BBBCDE, 0x00BBBDE4, 0x00BBCF8A, 0x00BBD96B, 0x00BBDA41, 0x00BBDB41, 0x00BBDCDD, 
						  0x00BBDE0A, 0x00BBDE29, 0x00BBE2CB, 0x00BBE2F5, 0x00BBE2FF, 0x00BBE322, 0x00BBE5B5, 0x00BBE5BF, 0x00BBE5EB, 0x00BBF36F, 
						  0x00BC5110, 0x00BC52AC, 0x00BC531F, 0x00BD2ACB, 0x00BD2AFB, 0x00BD2C6C, 0x00BD692E, 0x00BD6D2C, 0x00BD6DF8, 0x00BDC0D9, 
						  0x00BDCD6D, 0x00BDFDD3, 0x00BDFDDD, 0x00BDFDF0, 0x00BDFDFA, 0x00BE3F1E, 0x00BE3F71, 0x00BE47A7, 0x00BE47B8, 0x00BE495E, 
						  0x00BE49AE, 0x00BE8D46, 0x00BE93BC, 0x00BE9422, 0x00BE9A19, 0x00BE9C67, 0x00BEBC1A, 0x00BEC12C, 0x00BEC1CC, 0x00BEC72C, 
						  0x00BEC745, 0x00BEC7C4, 0x00BEC7AD, 0x00BEDA5B, 0x00BEF6D3, 0x00BF174E, 0x00BF45D3, 0x00BF6479, 0x00BF9DD1, 0x00BF9EB3, 
						  0x00BF9F00, 0x00BF9FD1, 0x00C6000A, 0x00C605CA, 0x00C606F1, 0x00C6078C, 0x00C607DC, 0x00C6090C, 0x00C6A7D9, 0x00C6A845, 
						  0x00C6A86F, 0x00C6C79B, 0x00C6C800, 0x00C77929, 0x00C77AAB, 0x00C77AC9, 0x00C77AE7, 0x00C77B7A, 0x00C77B96, 0x00C77BAF, 
						  0x00C77F55, 0x00C77F66, 0x00C7815C, 0x00C7816D, 0x00C82CC6, 0x00C89283, 0x00C9E9CE, 0x00CA4E70, 0x00CB468A, 0x00CB46AA, 
						  0x00CB46CA, 0x00CB4D1A, 0x00CB590A, 0x00CB63DB, 0x00CB641C, 0x00CB656C, 0x00CB667C, 0x00CB672A, 0x00CB682A, 0x00CB68BC, 
						  0x00CB693C, 0x00CB6DCC, 0x00CB6EAC, 0x00CB71AA, 0x00CB72FC, 0x00CB73AA, 0x00CBEDBA, 0x00CBEE0C, 0x00CC10FA, 0x00CC117A, 
						  0x00CC11CC, 0x00CC12EC, 0x00CCB25C, 0x00CCB2DC, 0x00CCD798, 0x00CE98CA, 0x00CE9A5C, 0x00CE9B9A, 0x00CE9BBC, 0x00CEE103, 
						  0x00CF242A, 0x00CF287C, 0x00CF29AC, 0x00CF94DA, 0x00CF94FA, 0x00CF960C, 0x00CF976C, 0x00CF97EC, 0x00D008AA, 0x00D008CC, 
						  0x00D0680A, 0x00D0685C, 0x00D0691A, 0x00D06ABC, 0x00D06B1C, 0x00D06C0C, 0x00D1091A, 0x00D10A1A, 0x00D10F1A, 0x00D110DC, 
						  0x00D111C8, 0x00D111EC, 0x00D117BC, 0x00D11BC9, 0x00D11BBA, 0x00D11C0B, 0x00D11BFA, 0x00D11CCC, 0x00D143AC, 0x00D1442C, 
						  0x00D1939C, 0x00D23959, 0x00D2399D, 0x00D23A42, 0x00D23A83, 0x00D23A9B, 0x00D2283C, 0x00D229DA, 0x00D22A1D, 0x00D22AB2, 
						  0x00D22B0D, 0x00D22B7C, 0x00D22BF1, 0x00D22C6B, 0x00D22CD8, 0x00D22E14, 0x00D22E82, 0x00D22EE1, 0x00D22F4D, 0x00D22FB1, 
						  0x00D23111, 0x00D231AE, 0x00D2324B, 0x00D2328F, 0x00D23310, 0x00D23411, 0x00D234D2, 0x00D23519, 0x00D23565, 0x00D235A9, 
						  0x00D2277D, 0x00D2367D, 0x00D23C10, 0x00D23C46, 0x00D23C77, 0x00D26AFD, 0x00D26B4D, 0x00D26D59, 0x00D26D4D, 0x00D2FBBB, 
						  0x00D2FC27, 0x00D30307, 0x00D30470, 0x00D30A16, 0x00D30A54, 0x00D30B72, 0x00D3481A, 0x00D3499A, 0x00D3535C, 0x00D353CD, 
						  0x00D3541D, 0x00D3548C, 0x00D3553A, 0x00D3577C, 0x00D357FC, 0x00D358CA, 0x00D3596C, 0x00D3647C, 0x00D3649D, 0x00D36D54, 
						  0x00D408B2, 0x00D408BF, 0x00D4090C, 0x00D40AB9, 0x00D40E40, 0x00D43CAC, 0x00D43E35, 0x00D44039, 0x00D448F7, 0x00D447FF, 
						  0x00D44822, 0x00D44E07, 0x00D45032, 0x00D452E4, 0x00D45453, 0x00D45AAB, 0x00D45D93, 0x00D463C7, 0x00D47017, 0x00D48AE7, 
						  0x00D48B74, 0x00D499FA, 0x00D49A8A, 0x00D49B4A, 0x00D49BBA, 0x00D49C2A, 0x00D49C9A, 0x00D4DA6A, 0x00D4DAFC, 0x00D4DC4A, 
						  0x00D4DCCA, 0x00D4DD9A, 0x00D4DE1A, 0x00D4DE9A, 0x00D4DF1A, 0x00D4E04A, 0x00D4E26A, 0x00D4E2FC, 0x00D4E37C, 0x00D4E5BC, 
						  0x00D4FA35, 0x00D5119C, 0x00D5121C, 0x00D5126C, 0x00D5134C, 0x00D5139C, 0x00D514AC, 0x00D5154C, 0x00D515EC, 0x00D5168C, 
						  0x00D5199C, 0x00D51E7C, 0x00D5AE5A, 0x00D5AE8C, 0x00D5AEBE, 0x00D5AF75, 0x00D5B163, 0x00D5B186, 0x00D5B20B, 0x00D5B371, 
						  0x00D5B391, 0x00D5B331, 0x00D5C6FD, 0x00D5D4D8, 0x00D5D7E7, 0x00D5D7FE, 0x00D5D835, 0x00D5DCD6, 0x00D5DD1E, 0x00D5DD2C, 
						  0x00D5E1E9, 0x00D5E21A, 0x00D6159A, 0x00D628AC, 0x00D629FC, 0x00D62A8C, 0x00D62BFC, 0x00D6CF1C, 0x00D8595A, 0x00D85AFC, 
						  0x00D85B7C, 0x00D85BFC, 0x00D85CBC, 0x00D85D7C, 0x00D85E3C, 0x00D85F0C, 0x00D85FCC, 0x00D8F90A, 0x00D8FBBC, 0x00DD3B1C, 
						  0x00DD3CBC, 0x00DD3F5C, 0x00DD4BDC, 0x00DDB00C, 0x00DDEC3A, 0x00DDEC8C, 0x00DDEF9C, 0x00DE37C3, 0x00DE3F4E, 0x00DE3FCC, 
						  0x00DE42AB, 0x00DE4EFB, 0x00DE99CD, 0x00DF63A5, 0x00DF9044, 0x00DF9B9A, 0x00DFAFEC, 0x00E0538A, 0x00E053DC, 0x00E057CA, 
						  0x00E0581C, 0x00E05F7A, 0x00E0600C, 0x00E07B6C, 0x00E07BBC, 0x00E0E73E, 0x00E17C7C, 0x00E1D4F9, 0x00E1D4EA, 0x00E22202, 
						  0x00E2221D, 0x00E22244, 0x00E25960, 0x00E27308, 0x00E2DFCC, 0x00E2DFE7, 0x00E3BF0C, 0x00E43C99, 0x00E56559, 0x00E5CF2B, 
						  0x00E5D3AC, 0x00E66F42, 0x00E6745C, 0x00E68AD1, 0x00E6BDCB, 0x00E6C507, 0x00E6C8DC, 0x00E6E20E, 0x00E704A3, 0x00E70246, 
						  0x00E702BE, 0x00E70896, 0x00E7090A, 0x00E70954, 0x00E709E3, 0x00E70AD9, 0x00E70C7C, 0x00E70CD7, /*0x00E71DA8, 0x00E71D7C,*/ 
						  0x00E81E8B, 0x00E88373, 0x00E889DC, 0x00E9096F, 0x00EC8FCC, 0x00ECA599, 0x00ECA5D9, 0x00ECA923, 0x00ECA95C, 0x00ECA98C, 
						  0x00ECAA02, 0x00ECAA5D, 0x00ECAC19, 0x00ECAD95, 0x00ECADA5, 0x00ECADCD, 0x00ECADF0, 0x00ECADFD, 0x00ECAE1D, 0x00ECA890, 
						  0x00ECA89E, 0x00ECB0AB, 0x00ECB114, 0x00ECC1F6, 0x00ECC588, 0x00ECC76C, 0x00ECC792, 0x00ECD1B4, 0x00ECD1F5, 0x00ECD7D3, 
						  0x00ECDAA7, 0x00ECE708, 0x00ECE507, 0x00ED2395, 0x00ED22C5, 0x00ED3252, 0x00ED3E5A, 0x00ED44FC, 0x00ED45EC, 0x00ED7ACF, 
						  0x00ED7B2E, 0x00ED85CB, 0x00EDA813, 0x00EDA9ED, 0x00EDAB05, 0x00EDD3E9, 0x00EDE17E, 0x00EDE0AC, 0x00EDE52C, 0x00EE10C0, 
						  0x00EE6C51, 0x00EE76C5, 0x00EE996C, 0x00EEC51D, 0x00EED916, 0x00EEDDA4, 0x00EEE046, 0x00EEE1BB, 0x00EEEEC7, 0x00EEEEF8, 
						  0x00EEEF1D, 0x00EF01EF, 0x00EEFCC8, 0x00EF082F, 0x00EF0859, 0x00EF0921, 0x00EF0AC7, 0x00EF102C, 0x00EF13F2, 0x00EF134A, 
						  0x00EF1368, 0x00EF1B8E, 0x00EF5DED, 0x00EFCBFF, 0x00EFFC4C, 0x00F0DD9A, 0x00F235A7, 0x00F235C3, 0x00F23CEF, 0x00F23D11, 
						  0x00F23D3D, 0x00F243E7, 0x00F295E5, 0x00F2A6C8, 0x00F2AD2A, 0x00F2B1AA, 0x00F2BC2A, 0x00F2BCAC, 0x00F2CBF0, 0x00F2DADA, 
						  0x00F2DBCF, 0x00F2E69C, 0x00F2F1C9, 0x00F65FD0, 0x00F6667E, 0x00F66697, 0x00F666FE, 0x00F66BE8, 0x00F66C1A, 0x00F678BD, 
						  0x00F67B49, 0x00F67EF5, 0x00F681C3, 0x00F68258, 0x00F68D0D, 0x00F694C9, 0x00F6DF69, 0x00F6DECD, 0x00F6E2C5, 0x00F6E37E, 
						  0x00F6E6B1, 0x00F6E7D5, 0x00F6E96B, 0x00F6EB8A, 0x00F6EBC0, 0x00F6EC13, 0x00F6EC49, 0x00F6ED68, 0x00F6EDA1, 0x00F6EE70, 
						  0x00F6EEA9, 0x00F6EFE4, 0x00F6F01D, 0x00F6F2E3, 0x00F6F331, 0x00F6F3AB, 0x00F6F3D5, 0x00F6F402, 0x00F6F2BC, 0x00F6F559, 
						  0x00F6F58D, 0x00F6F5C1, 0x00F6F66F, 0x00F6F698, 0x00F6F6C4, 0x00F6F7B3, 0x00F6F828, 0x00F6F89D, 0x00F6F912, 0x00F6F95C, 
						  0x00F6F98B, 0x00F6FA5A, 0x00F6FAD2, 0x00F6FB4A, 0x00F6FBA8, 0x00F6FC0A, 0x00F6FC28, 0x00F715D7, 0x00F71627, 0x00F71A65, 
						  0x00F728D7, 0x00F72908, 0x00F7292D, 0x00F7D2ED, 0x00FC2FBE, 0x00FC2E74, 0x00FC2E98, 0x00FC3103, 0x00FC319C, 0x00FC31BA, 
						  0x00FC39CE, 0x00FC4FE4, 0x00FC5045, 0x00FE097F, 0x00FE09A3, 0x00FE0B5F, 0x00FE0B83, 0x00FE0C6F, 0x00FE0D69, 0x00FE0D92, 
						  0x00FE0EB2, 0x00FE1009, 0x00FE102F, 0x00FE1073, 0x00FE1099, 0x00FE11AC, 0x00FE11B9, 0x00FE11E2, 0x00FE12CF, 0x00FE1503,
						  0x00BF5282, 0x00BF52AA, 0x00BF567A, 0x00BF56DB, 0x00BF5B69, 0x00BF5B8D, 0x00BF5D5A, 0x00BF5DBB, 
						  0x01172BA9, 0x01172BB6, 0x00401ED9, 0x0042E1D9, 0x0042E1E6, 0x0042EAC9, 0x0042EAD6, 0x0042EBC9, 0x0042EBD6, 0x00455229, 
						  0x00455236, 0x00486AF9, 0x00486B06, 0x00486BD2, 0x004F6639, 0x004F6646, 0x004FC2C9, 0x004FC2D6, 0x00566939, 0x00566946, 
						  0x005D2139, 0x005D2146, 0x005D22D9, 0x005D22E6, 0x005D2429, 0x005D2436, 0x005D2559, 0x005D2566, 0x00600209, 0x00600216, 
						  0x0060906E, 0x0060912E, 0x0064FA3E, 0x0065C2A9, 0x0065C2B6, 0x0065C862, 0x00671E02, 0x006844B9, 0x006844C6, 0x006B9489, 
						  0x006B9496, 0x006B9609, 0x006B9616, 0x006B9709, 0x006B9716, 0x006B9DE9, 0x006B9DF6, 0x006D314A, 0x006D748E, 0x006DB879, 
						  0x006DB886, 0x006DDFA9, 0x006DDFB6, 0x006DF589, 0x006DF596, 0x006E5D32, 0x006EEE42, 0x0070FA79, 0x0070FA86, 0x00716589, 
						  0x00716596, 0x0071C212, 0x0071CE1E, 0x0071D02E, 0x00721C99, 0x00721CA6, 0x0073F709, 0x0073F716, 0x00778E69, 0x00778E76, 
						  0x00795DBE, 0x0083DDB9, 0x0083DDC6, 0x00857099, 0x008570A6, 0x00878179, 0x00878186, 0x00878309, 0x00878316, 0x00891AC9, 
						  0x00891AD6, 0x00896A69, 0x00896A76, 0x00896BD9, 0x00896BE6, 0x008AC0E9, 0x008AC0F6, 0x008B1CF9, 0x008B1D06, 0x008F2722, 
						  0x008F4D09, 0x008F4D16, 0x008FC929, 0x008FC936, 0x008FCAF9, 0x008FCB06, 0x008FCC69, 0x008FCC76, 0x008FCE69, 0x008FCE76, 
						  0x008FD11E, 0x008FD47E, 0x00902FA9, 0x00902FB6, 0x0091E1E9, 0x0091E1F6, 0x0091E2E9, 0x0091E2F6, 0x00921AC9, 0x00921AD6, 
						  0x00922489, 0x00922496, 0x009225D2, 0x0093A2D9, 0x0093A2E6, 0x0093ADEE, 0x00968C7E, 0x0097FE79, 0x0097FE86, 0x0097FF79, 
						  0x0097FF86, 0x00984779, 0x00984786, 0x00986609, 0x00986616, 0x00986709, 0x00986716, 0x00986839, 0x00986846, 0x009B400E, 
						  0x009BAD89, 0x009BAD96, 0x009BAF49, 0x009BAF56, 0x009C2EE9, 0x009C2EF6, 0x009E7A61, 0x009F1CA9, 0x009F1CB6, 0x00A083A9, 
						  0x00A083B6, 0x00A257EE, 0x00BBCEC2, 0x00BBD2FE, 0x00BBD342, 0x00BFB5A2, 0x00C5FCD9, 0x00C5FCE6, 0x00C5FDD9, 0x00C5FDE6, 
						  0x00C5FED9, 0x00C5FEE6, 0x00C8AB19, 0x00C8AB26, 0x00C8ACE2, 0x00C97EE9, 0x00C97EF6, 0x00C9994E, 0x00C9CE19, 0x00C9CE26, 
						  0x00C9D152, 0x00CA3F59, 0x00CA3F66, 0x00CB6C19, 0x00CB6C26, 0x00CCB009, 0x00CCB016, 0x00CE2619, 0x00CE2626, 0x00CF7239, 
						  0x00CF7246, 0x00CF90C9, 0x00CF90D6, 0x00CF919E, 0x00D035DE, 0x00D194A5, 0x00D19751, 0x00D1D6B9, 0x00D1D6C6, 0x00D1EA69, 
						  0x00D1EA76, 0x00D1EB5E, 0x00D3D076, 0x00D3D1FB, 0x00D3DA6E, 0x00D3DBE0, 0x00D3DD43, 0x00D3DE26, 0x00D3DF05, 0x00D3E9DF, 
						  0x00D3F862, 0x00D407F2, 0x00D40819, 0x00D408CF, 0x00D408DC, 0x00D40972, 0x00D407CF, 0x00D41099, 0x00D42098, 0x00D43972, 
						  0x00D43C3F, 0x00D45584, 0x00D45808, 0x00D45900, 0x00D463A8, 0x00D464A7, 0x00D4716D, 0x00D49269, 0x00D49276, 0x00D494A9, 
						  0x00D494B6, 0x00D49702, 0x00D4AE78, 0x00D4F197, 0x00D4F1C8, 0x00D4F1ED, 0x00D4F425, 0x00D4F547, 0x00D4F578, 0x00D4F59D, 
						  0x00D4F7A7, 0x00D4F7D8, 0x00D4F7FD, 0x00D4FB55, 0x00D52B6B, 0x00D52F24, 0x00D52F4F, 0x00D5B09C, 0x00D5B6BC, 0x00D5B8B0, 
						  0x00D5BD1C, 0x00D5C898, 0x00D5C7A4, 0x00D5CCA8, 0x00D5CD0B, 0x00D5CE14, 0x00D5DA78, 0x00D5DACA, 0x00D5D9F0, 0x00D5E3BC, 
						  0x00D5E206, 0x00D5E6E8, 0x00D5E852, 0x00D5EAF7, 0x00D5EA93, 0x00D5EBC3, 0x00D5EBF1, 0x00D5ECD5, 0x00D5F7B7, 0x00D5FA97, 
						  0x00D61099, 0x00D610A6, 0x00D61399, 0x00D613A6, 0x00D614A2, 0x00D6333A, 0x00D634A7, 0x00D63B9F, 0x00D63C0D, 0x00D6CA4E, 
						  0x00D6CD5E, 0x00D6D7BE, 0x00D6E25A, 0x00D6E78E, 0x00D839AF, 0x00D83A23, 0x00D82F80, 0x00D84353, 0x00D8464D, 0x00D8497F, 
						  0x00D843B7, 0x00D84C32, 0x00D84D06, 0x00D84E92, 0x00D84FD6, 0x00D85244, 0x00D852C7, 0x00D8565C, 0x00D863A1, 0x00D87579, 
						  0x00D87586, 0x00D87679, 0x00D87686, 0x00D87779, 0x00D87786, 0x00D8DCB3, 0x00D8DCCE, 0x00D8DCF8, 0x00D8DBA6, 0x00D8E3A9, 
						  0x00D8E537, 0x00D8E6A7, 0x00D8E8D3, 0x00D8EAAC, 0x00D8EB5A, 0x00D8F05D, 0x00D963ED, 0x00E04F6E, 0x00E59952, 0x00E79729, 
						  0x00E79736, 0x00EC8CC4, 0x00ED00AD, 0x00ED20C3, 0x00EDD266, 0x00EDDBA4, 0x00EDE393, 0x00EDE695, 0x00EDE78D, 0x00EDF0A8, 
						  0x00EDF854, 0x00EDFE03, 0x00EDFDB2, 0x00EE0148, 0x00EE1391, 0x00EEEF67, 0x00EEEF98, 0x00EEEFBD, 0x00EF077B, 0x00EF0913, 
						  0x00EF1C92, 0x00EF2153, 0x00EF2486, 0x00EF24C3, 0x00F09195, 0x00F09802, 0x00F09DA0, 0x00F3DFBF, 0x00F3E084, 0x00F5E303, 
						  0x00F5E3CF, 0x00F5E589, 0x00F5E596, 0x00F5EE19, 0x00F5EE26, 0x00F67BE7, 0x00F6E48B, 0x00F6E5B2, 0x00F6EC9F, 0x00F6ECF0, 
						  0x00F6F35B, 0x00F6F295, 0x00F6F5F8, 0x00F6F525, 0x00F71587, 0x00F7CF39};

	DWORD get_this_off4 = 0x0061FD50;

	DWORD get_this_off8_calls[] = {						  0x01109D3A, 0x01109F78, 0x01171F49, 0x01171F56, 0x01177899, 0x011778A6, 0x01177972, 0x011779E9, 0x011779F6, 0x01177AC2, 
						  0x00402930, 0x00405818, 0x00405828, 0x00405846, 0x00405862, 0x004058A0, 0x004058AC, 0x0040893D, 0x0040CBE9, 0x0040F90D, 
						  0x00410193, 0x00411399, 0x00411649, 0x00411814, 0x00411820, 0x004118D0, 0x004118E3, 0x00411A1A, 0x00411A33, 0x00411A46, 
						  0x00411B50, 0x00411BD3, 0x004131D3, 0x00413203, 0x0041359E, 0x0041372F, 0x0041382F, 0x00413ADC, 0x00413C3F, 0x00413DBE, 
						  0x00413F23, 0x004140B9, 0x00413FD5, 0x0041404F, 0x004165C9, 0x0041C3A3, 0x0041C4DA, 0x0041CB3A, 0x00423152, 0x0042377B, 
						  0x00437713, 0x0043920C, 0x00439218, 0x0043B24E, 0x0043B25B, 0x0043B28A, 0x0043D6CD, 0x00448AC0, 0x00449176, 0x0044917F, 
						  0x00449194, 0x004523EF, 0x0045257B, 0x00452644, 0x0046630D, 0x0046FED2, 0x00476EB4, 0x0047CB61, 0x0047CDD9, 0x0047CD19, 
						  0x004801B2, 0x0048B67D, 0x0048E9AB, 0x004917F7, 0x00492065, 0x0049212D, 0x0049436F, 0x00499DE3, 0x00499E94, 0x004A39B0, 
						  0x004A5369, 0x004A5396, 0x004A53A2, 0x004A53C1, 0x004A54C9, 0x004A54F6, 0x004A5502, 0x004A5521, 0x004A705C, 0x004A81B9, 
						  0x004A9407, 0x004AA8AD, 0x004AA9C0, 0x004AB21A, 0x004ABE5F, 0x004AC0F9, 0x004AC14B, 0x004AC6E9, 0x004ACBFB, 0x004ACC15, 
						  0x004ACC29, 0x004ACE47, 0x004AD215, 0x004AD272, 0x004AD28F, 0x004AD2C6, 0x004ADB08, 0x004AD888, 0x004AD892, 0x004ADE64, 
						  0x004B00B2, 0x004AE04A, 0x004B123F, 0x004AE5ED, 0x004AE638, 0x004B16E3, 0x004B16F6, 0x004B1638, 0x004B1AF4, 0x004B1CB0, 
						  0x004B1DFB, 0x004B1E25, 0x004B200F, 0x004B2173, 0x004B27A0, 0x004B2ED5, 0x004B37CF, 0x004B37E4, 0x004B38C3, 0x004B3953, 
						  0x004B3B4C, 0x004B3E01, 0x004B40A9, 0x004B3F72, 0x004B435E, 0x004B436E, 0x004B4475, 0x004B48A0, 0x004B48C0, 0x004B4B4A, 
						  0x004B4C9B, 0x004B4E3C, 0x004B4E4F, 0x004B4D97, 0x004B51E5, 0x004B55E8, 0x004B58CF, 0x004B5A4C, 0x004B5A82, 0x004B5C63, 
						  0x004B5E36, 0x004B63C3, 0x004B63EC, 0x004B6878, 0x004B6A8F, 0x004B6CA5, 0x004B6D6E, 0x004B7021, 0x004B6F8B, 0x004B72BB, 
						  0x004B75D9, 0x004B75EE, 0x004B76CB, 0x004B83B1, 0x004B8310, 0x004B885F, 0x004B8D82, 0x004B9029, 0x004B91F9, 0x004B92FE, 
						  0x004B930F, 0x004B936F, 0x004B94A5, 0x004B9505, 0x004B9581, 0x004B95B3, 0x004B95C4, 0x004B95F9, 0x004B965D, 0x004BA6BC, 
						  0x004BABB8, 0x004BABD3, 0x004BCBA8, 0x004BCF45, 0x004BCF94, 0x004BD075, 0x004BD0C2, 0x004BE424, 0x004BE4D4, 0x004BE5AF, 
						  0x004BE7E3, 0x004BF150, 0x004C1325, 0x004C1337, 0x004C5210, 0x004C94AA, 0x004C95BC, 0x004C9953, 0x004C9983, 0x004C987A, 
						  0x004C9901, 0x004D1ECA, 0x004D8FB6, 0x004D8FC6, 0x004DADDF, 0x004DC2EB, 0x004EEC7F, 0x004F7D74, 0x00512F9C, 0x00512FDB, 
						  0x00516AD0, 0x0051CC3A, 0x0051CC6C, 0x0052079A, 0x0052EFC0, 0x0052F585, 0x0052F598, 0x0052F5E5, 0x00530001, 0x00530C84, 
						  0x00530E34, 0x00530E94, 0x00530EEC, 0x00530F28, 0x00530F7C, 0x00530FAC, 0x00530FFC, 0x0053108C, 0x005310DC, 0x0053112C, 
						  0x0053115C, 0x0053341F, 0x0053E15F, 0x0053E051, 0x0053E8B2, 0x0053EE8D, 0x00542304, 0x00544238, 0x0054539E, 0x005477E1, 
						  0x005485AF, 0x005542EC, 0x00557749, 0x00557756, 0x00568879, 0x00568888, 0x00573D5E, 0x0057C6B7, 0x0058E9D9, 0x0058EA1A, 
						  0x0058EA53, 0x0058E983, 0x0058EC00, 0x0058EC53, 0x0058ECBA, 0x0058ED1A, 0x0058ED7C, 0x0058EB90, 0x0059AB29, 0x0059E4EE, 
						  0x0059E5B5, 0x0059E656, 0x0059E738, 0x005A9927, 0x005ACA6A, 0x005B97C5, 0x005B9C7A, 0x005B9D0A, 0x005CA6B0, 0x005DD8BC, 
						  0x005E95EA, 0x005E96E5, 0x005E973F, 0x005EDD42, 0x005EDE97, 0x005F0F16, 0x005F26C9, 0x005F26D6, 0x00610964, 0x0061097D, 
						  0x00610990, 0x006109E7, 0x00611398, 0x0061232B, 0x00612712, 0x006148FB, 0x00614E9B, 0x00614ED1, 0x0061565E, 0x0061595E, 
						  0x00615BBF, 0x0061C208, 0x0061C2E0, 0x0061C61C, 0x0061D1FA, 0x0061DD2D, 0x0061E31F, 0x0061ED2E, 0x00633A89, 0x00633A96, 
						  0x0063C95F, 0x0063CBEF, 0x0063D174, 0x0063D204, 0x0063DD94, 0x0063DE24, 0x0063FE20, 0x00640110, 0x00646E56, 0x00646FBB, 
						  0x0064F19C, 0x00653CC5, 0x0065921A, 0x0065949E, 0x0065948A, 0x0065CE70, 0x0065CF74, 0x0066313C, 0x00665536, 0x00665AD2, 
						  0x0066ADB8, 0x0066CA2A, 0x0066E387, 0x0067A6D1, 0x0068079A, 0x0068524E, 0x0068E4BE, 0x0068E4C9, 0x0068E748, 0x00690A19, 
						  0x006913F1, 0x00691502, 0x00691513, 0x00696B01, 0x0069BFF0, 0x0069BFC7, 0x0069CCB2, 0x0069CB50, 0x0069CF2A, 0x0069D1A3, 
						  0x006A21AC, 0x006A2396, 0x006A2652, 0x006A258E, 0x006A3ECE, 0x006A454C, 0x006A4643, 0x006A464D, 0x006A6589, 0x006A673F, 
						  0x006A86F6, 0x006A87A6, 0x006A8F9E, 0x006AAC22, 0x006AC9EC, 0x006AEE20, 0x006AEE42, 0x006B98B9, 0x006B98C6, 0x006B99DE, 
						  0x006C59F2, 0x006CAE82, 0x006CCC02, 0x006CE8F2, 0x006D5E4E, 0x006E62DE, 0x006E9AAF, 0x006E9B03, 0x006EA084, 0x006EA114, 
						  0x006EB290, 0x006EE02F, 0x006EE434, 0x006EE4C4, 0x006EF5F0, 0x006F13C8, 0x006F1B3F, 0x006F2114, 0x006F21A4, 0x006F38F0, 
						  0x006F5F81, 0x006F5F9C, 0x006F9B94, 0x006FB72F, 0x006FBAD4, 0x006FBB64, 0x006FCBB0, 0x00700407, 0x00700421, 0x00700432, 
						  0x00700935, 0x00700A65, 0x00701590, 0x00701858, 0x00702444, 0x007025CD, 0x00702BC9, 0x00706AC8, 0x0070709E, 0x0070F365, 
						  0x00719CCE, 0x0071BAE9, 0x0071B9C4, 0x0071BA1C, 0x0071CBC9, 0x0071CBD6, 0x0071DB46, 0x007210D1, 0x00726B4E, 0x00726A5D, 
						  0x007273FE, 0x00728140, 0x00728151, 0x00728369, 0x0072828A, 0x00732015, 0x007357C6, 0x00739A37, 0x00751A2E, 0x007636A3, 
						  0x0076385E, 0x00763C85, 0x007641B4, 0x007670BF, 0x00774E35, 0x00774E4E, 0x00775F58, 0x0077A28D, 0x0077A3D4, 0x0077A24A, 
						  0x0077C5CE, 0x00788A7C, 0x00789955, 0x00789889, 0x0078A9A5, 0x0078B006, 0x0078B159, 0x007971E0, 0x0079E44D, 0x007B579E, 
						  0x007B599B, 0x007B67C4, 0x007B73B3, 0x007B7898, 0x007B7FCA, 0x007B8978, 0x007BF4BA, 0x007C12FF, 0x007C2A99, 0x007C8D82, 
						  0x007C8D8E, 0x007CC2D1, 0x007D8175, 0x007E5A72, 0x007E9E01, 0x007F171B, 0x007F1A47, 0x007F18E2, 0x007F264F, 0x007F6657, 
						  0x007FC0B2, 0x007FC0D1, 0x007FC100, 0x007FC048, 0x007FC058, 0x007FC075, 0x007FC08E, 0x007FC622, 0x007FDD6F, 0x007FDB4E, 
						  0x0080005A, 0x0080294B, 0x00806CAB, 0x008084F9, 0x0080AAB3, 0x0080ABA4, 0x0080ABD9, 0x0080B3B6, 0x0080B9CD, 0x0080C749, 
						  0x0080C7A5, 0x0080CAFD, 0x0080D41C, 0x0080D47F, 0x0080D7C4, 0x0080D969, 0x0080E262, 0x0080F425, 0x0081054C, 0x00811E9A, 
						  0x00816742, 0x00816768, 0x00819EBB, 0x00822CBA, 0x00824917, 0x00825DC7, 0x00827BE1, 0x008283D9, 0x00828701, 0x0082974D, 
						  0x0082BCAE, 0x0082B895, 0x0082B992, 0x0082D72C, 0x00830415, 0x008316D3, 0x00831C4B, 0x00833216, 0x00837E5C, 0x00838F36, 
						  0x008429A6, 0x0084B8B9, 0x0084E8AD, 0x0084E903, 0x0084EBA0, 0x0084ECBA, 0x0084FAA9, 0x00851026, 0x008524BE, 0x00852758, 
						  0x0085279B, 0x00853483, 0x00853DA6, 0x008550A2, 0x0085BF38, 0x00865E38, 0x00865E7E, 0x00865EC0, 0x00865FAC, 0x00865FDF, 
						  0x0086603D, 0x008662FF, 0x0086B61B, 0x0086B8F7, 0x0086BD14, 0x0086C830, 0x0086CB68, 0x0086CFA1, 0x0086F0E0, 0x0086F1EC, 
						  0x00874DB0, 0x00878CD5, 0x0087AF49, 0x0087AF56, 0x0087C101, 0x0087C131, 0x0087C147, 0x0087C174, 0x0087E8B3, 0x0087EC16, 
						  0x0087EC39, 0x0087EC55, 0x0087F391, 0x0087F39D, 0x0087F456, 0x0087F46B, 0x0087F495, 0x00882ADB, 0x00882D4A, 0x008895A0, 
						  0x00891972, 0x00891D8E, 0x00896D8E, 0x00896F59, 0x00896F66, 0x008970C9, 0x008970D6, 0x0089782E, 0x0089BBA1, 0x0089BBB0, 
						  0x0089BBC3, 0x0089BBE8, 0x0089BBFB, 0x0089BCBA, 0x0089CD9E, 0x0089CDBB, 0x0089CB36, 0x0089CE75, 0x0089D115, 0x0089D199, 
						  0x0089CBA3, 0x0089CBCE, 0x0089DD1F, 0x0089DD43, 0x0089E15C, 0x0089E66C, 0x0089E83B, 0x0089E8C4, 0x0089E8E5, 0x0089E95B, 
						  0x0089EE9C, 0x0089FEB2, 0x008A0429, 0x008A0466, 0x008A0B7C, 0x008A0F9C, 0x008A12D5, 0x008A1E9C, 0x008A262C, 0x008A468E, 
						  0x008A90F9, 0x008A9106, 0x008AB73C, 0x008AE782, 0x008AE365, 0x008B32F8, 0x008B4467, 0x008B8F72, 0x008C186C, 0x008C8F4D, 
						  0x008CD433, 0x008CDEA3, 0x008D0618, 0x008D062B, 0x008D18A2, 0x008D1847, 0x008D23AE, 0x008D708B, 0x008D8DD2, 0x008DC0D6, 
						  0x008DF14D, 0x008DF166, 0x008E00A5, 0x008E034E, 0x008E9BCC, 0x008E9F04, 0x008EA49F, 0x008ED392, 0x008EFDB5, 0x008EFE6E, 
						  0x008F5DFA, 0x008F826B, 0x008F7E50, 0x008FEE26, 0x008FEAF7, 0x008FF30D, 0x008FF286, 0x008FF297, 0x008FF2F5, 0x008FF68C, 
						  0x00900B47, 0x00900BDA, 0x00900CAA, 0x00900D16, 0x00900DB6, 0x00900DFF, 0x00900F87, 0x0090101D, 0x009010ED, 0x0090115C, 
						  0x009011FC, 0x00901248, 0x00901682, 0x0090206F, 0x0090208F, 0x009020A6, 0x00902B14, 0x00902B34, 0x00903A38, 0x00903B22, 
						  0x00904E7D, 0x0090503D, 0x009052EA, 0x00905499, 0x009054AF, 0x009054E0, 0x0090558A, 0x00905661, 0x00905C4C, 0x00905D4C, 
						  0x00906AF0, 0x0090832A, 0x009092AC, 0x0090956C, 0x0090967A, 0x0090977C, 0x0090994C, 0x00909976, 0x00909ADA, 0x00909AFE, 
						  0x00909A91, 0x00909D01, 0x0090A79C, 0x0090A7C7, 0x0091D6F3, 0x0091DD34, 0x00922989, 0x00922996, 0x00922F82, 0x00925E8A, 
						  0x0092D013, 0x009335C8, 0x00936418, 0x009365EC, 0x009366DE, 0x0093673A, 0x00936E3B, 0x00937327, 0x00937333, 0x00937F86, 
						  0x00937F92, 0x00938141, 0x00938177, 0x009391B9, 0x00939432, 0x00938E8F, 0x00939F26, 0x0093FE7C, 0x00940AB7, 0x00942DBE, 
						  0x009430E4, 0x00943224, 0x00943A71, 0x00943E37, 0x0094411C, 0x009447AF, 0x00944C7D, 0x00944C8F, 0x00944E69, 0x009494DA, 
						  0x00949534, 0x00949610, 0x00949640, 0x00949686, 0x00949861, 0x00949894, 0x00949B21, 0x00949C71, 0x00949F5D, 0x0094A44D, 
						  0x0094A6B5, 0x0094E0F0, 0x0094FF46, 0x00950574, 0x00950C93, 0x009568CD, 0x0095DC4C, 0x0095DF00, 0x0095E6F3, 0x0095EB35, 
						  0x0095ED18, 0x0096223E, 0x0096755E, 0x00967ADA, 0x0096F35F, 0x0096F770, 0x00970921, 0x00970937, 0x00972CB1, 0x009785F8, 
						  0x0097C836, 0x0098D6B4, 0x0098DB90, 0x0098DC40, 0x0098F580, 0x00999D6B, 0x00999D7B, 0x00999E2D, 0x00999E3D, 0x0099B1AF, 
						  0x0099B1B8, 0x0099C301, 0x0099C30E, 0x0099E262, 0x0099E272, 0x0099E46A, 0x009A03DF, 0x009A03FE, 0x009A05A1, 0x009A05B1, 
						  0x009A0696, 0x009A06A6, 0x009A1D81, 0x009A27C9, 0x009A27D9, 0x009A2A84, 0x009A2A94, 0x009A3BB5, 0x009A45C4, 0x009A53CC, 
						  0x009A53D9, 0x009A5A72, 0x009A6668, 0x009A6678, 0x009AA455, 0x009AA479, 0x009AAA5E, 0x009AABE8, 0x009AABF9, 0x009AAC18, 
						  0x009AAC29, 0x009AAC48, 0x009AAC5C, 0x009AAD78, 0x009AB4B8, 0x009AB4E4, 0x009AB74D, 0x009AB781, 0x009AB833, 0x009AB861, 
						  0x009AB872, 0x009AB8A0, 0x009AB8AD, 0x009AB8D9, 0x009AB8E6, 0x009AB912, 0x009AB65F, 0x009ABF73, 0x009ABFA0, 0x009ACCA5, 
						  0x009ACCB2, 0x009ACDE7, 0x009AD0E9, 0x009AD0FA, 0x009AD1E4, 0x009AD203, 0x009ACF32, 0x009AD23E, 0x009AD269, 0x009AD37F, 
						  0x009AD5DC, 0x009AD6AB, 0x009AD99C, 0x009AE03A, 0x009AE0F3, 0x009B2887, 0x009B37FA, 0x009B3B4E, 0x009B5446, 0x009B6110, 
						  0x009B6149, 0x009B6020, 0x009B602C, 0x009B6042, 0x009B604E, 0x009B7063, 0x009B706F, 0x009B70B9, 0x009B70C5, 0x009B79CA, 
						  0x009B79D6, 0x009B78AF, 0x009B78BF, 0x009B7CE0, 0x009B7CED, 0x009B8742, 0x009B95F3, 0x009B9603, 0x009B96AC, 0x009B96BC, 
						  0x009BA2C6, 0x009BA2D3, 0x009BC2F2, 0x009BC302, 0x009BC1DB, 0x009BC20C, 0x009BE6BD, 0x009BE6C9, 0x009BECDA, 0x009BECEA, 
						  0x009BEF62, 0x009BEF6E, 0x009BFBB6, 0x009BFBC2, 0x009C07FD, 0x009C080D, 0x009C2476, 0x009C2482, 0x009C54C4, 0x009C628D, 
						  0x009C7DD8, 0x009C8747, 0x009C8757, 0x009C8AEB, 0x009C8AFB, 0x009C8C93, 0x009C9D7F, 0x009CA54E, 0x009CA91C, 0x009CD3E8, 
						  0x009CD421, 0x009CDA9A, 0x009CE7A9, 0x009CE7B5, 0x009D24CF, 0x009D24DF, 0x009D294D, 0x009D2959, 0x009D5C72, 0x009D5C88, 
						  0x009D5CDC, 0x009D5CE8, 0x009D5D31, 0x009D6E00, 0x009D6CD7, 0x009D6D9E, 0x009D6F03, 0x009D9889, 0x009DAC96, 0x009DACA2, 
						  0x009DD773, 0x009DD77F, 0x009DD7C9, 0x009DD7D9, 0x009E6216, 0x009E623B, 0x009E88AA, 0x009E88B6, 0x009EA867, 0x009EA880, 
						  0x009E983B, 0x009E98A1, 0x009E98B1, 0x009E98C5, 0x009F3269, 0x009F3284, 0x009F38FC, 0x009F3908, 0x009F393B, 0x009F3947, 
						  0x009F4552, 0x009F455E, 0x009F43D3, 0x009F43F9, 0x009F4D88, 0x009F4D78, 0x009FA279, 0x009FA1C6, 0x009FA1FE, 0x00A0281E, 
						  0x00A0283A, 0x00A0296A, 0x00A0297A, 0x00A02522, 0x00A02B8C, 0x00A0252E, 0x00A02BB8, 0x00A02D36, 0x00A02D42, 0x00A05566, 
						  0x00A055AF, 0x00A056E6, 0x00A0572F, 0x00A0A2CA, 0x00A0CC4F, 0x00A0CC68, 0x00A0CC8F, 0x00A0CC9F, 0x00A0CA91, 0x00A0CAB5, 
						  0x00A0D20D, 0x00A17DF4, 0x00A2DD59, 0x00A2DD66, 0x00A3E9E3, 0x00A48C49, 0x00A48C74, 0x00A4944C, 0x00A49F0E, 0x00A4B0EF, 
						  0x00A657EE, 0x00A6588C, 0x00A65925, 0x00A659B9, 0x00A65A06, 0x00A65A4C, 0x00A6F77C, 0x00A6F7AB, 0x00A6F7E8, 0x00A6F825, 
						  0x00A708F6, 0x00A7095F, 0x00A71F68, 0x00A71FA0, 0x00A7BC63, 0x00A7BC90, 0x00A7BBC9, 0x00A7BBF0, 0x00A7BC24, 0x00A7C4BB, 
						  0x00A7C4EE, 0x00A7CB2C, 0x00A7CC2C, 0x00A7D40C, 0x00A7D51C, 0x00A7D7FC, 0x00A7D9A6, 0x00A7D8D3, 0x00A7D91B, 0x00A7DC90, 
						  0x00A7DF38, 0x00A7DF75, 0x00A7E4EF, 0x00A7EB7E, 0x00A8368D, 0x00A836D2, 0x00A83DC2, 0x00BB89DD, 0x00BB9939, 0x00BB9B40, 
						  0x00BB9BEB, 0x00BB9C75, 0x00BB9CEA, 0x00BB9E33, 0x00BBA409, 0x00BBA427, 0x00BBAAF1, 0x00BBABB2, 0x00BBABEF, 0x00BBAC4B, 
						  0x00BBADD3, 0x00BBB97A, 0x00BBE2B2, 0x00BBF127, 0x00BBF22F, 0x00BBF2D7, 0x00BBF365, 0x00BBF38A, 0x00BBF3B0, 0x00BC4FDA, 
						  0x00BCA624, 0x00BCA66F, 0x00BD73D8, 0x00BD742C, 0x00BD784B, 0x00BD7857, 0x00BDC11C, 0x00BDD0A1, 0x00BDD127, 0x00BDD226, 
						  0x00BDD295, 0x00BDD3DE, 0x00BDD79E, 0x00BDD9F2, 0x00BDDB11, 0x00BDDE73, 0x00BDDEF5, 0x00BDDF13, 0x00BDE647, 0x00BDE671, 
						  0x00BDE6FA, 0x00BE67A9, 0x00BE678C, 0x00BE6B45, 0x00BEA208, 0x00BEA386, 0x00BEA453, 0x00BEA485, 0x00BECEAF, 0x00BED254, 
						  0x00BED2E4, 0x00BEE540, 0x00BF45FB, 0x00BF4607, 0x00BF6361, 0x00BF9CB6, 0x00C60159, 0x00C60166, 0x00C69272, 0x00C6A341, 
						  0x00C6BAA4, 0x00C6BB34, 0x00C6CB6C, 0x00C7098B, 0x00C70995, 0x00C75F06, 0x00C75F6C, 0x00C75FF6, 0x00C76376, 0x00C78BCF, 
						  0x00C79594, 0x00C79624, 0x00C7B591, 0x00C7C7ED, 0x00C845D5, 0x00C8467A, 0x00C8778F, 0x00C877BB, 0x00C903CA, 0x00C91DFB, 
						  0x00C99A10, 0x00C99AF6, 0x00CA075D, 0x00CA080E, 0x00CA081A, 0x00CA1BE8, 0x00CB5039, 0x00CB5046, 0x00CB6342, 0x00CB638E, 
						  0x00CB63D2, 0x00CB687E, 0x00CB765A, 0x00CB798D, 0x00CB7780, 0x00CB77A3, 0x00CB77F2, 0x00CB7B4A, 0x00CB944C, 0x00CB94E0, 
						  0x00CB94F3, 0x00CB9860, 0x00CB99A5, 0x00CB9735, 0x00CB9747, 0x00CBA78B, 0x00CBA580, 0x00CBA826, 0x00CBA878, 0x00CBB0EF, 
						  0x00CBB256, 0x00CBB306, 0x00CBB558, 0x00CBBAA9, 0x00CBB9A9, 0x00CBBD95, 0x00CBBB89, 0x00CBBE79, 0x00CBBBEF, 0x00CBBC38, 
						  0x00CBBC58, 0x00CBBF7C, 0x00CBBFA2, 0x00CBC037, 0x00CBC055, 0x00CBCC31, 0x00CBCC97, 0x00CBD3AE, 0x00CBD477, 0x00CBD4FE, 
						  0x00CBD661, 0x00CBD744, 0x00CBDAA4, 0x00CBDD4E, 0x00CBDDA1, 0x00CBDF91, 0x00CBE029, 0x00CBF3AA, 0x00CBFC54, 0x00CBFC7C, 
						  0x00CC0BDF, 0x00CC0C04, 0x00CD5A39, 0x00CD5A46, 0x00CE9AEE, 0x00CF2BF1, 0x00CF2C07, 0x00CF2C45, 0x00CF2C5B, 0x00CF2C9C, 
						  0x00CF2CB2, 0x00CF348A, 0x00CF360E, 0x00CF34DE, 0x00CF354B, 0x00CF3971, 0x00CF36DA, 0x00CF3758, 0x00CF3CBB, 0x00CF793A, 
						  0x00CF797D, 0x00CF7C5B, 0x00CF7B96, 0x00CF7E01, 0x00CF7E17, 0x00CF7EAB, 0x00CF7FC1, 0x00CF83A9, 0x00CF7FE5, 0x00CF8533, 
						  0x00CF8563, 0x00CF8085, 0x00CF870B, 0x00CF871D, 0x00CF880C, 0x00CF89EB, 0x00CF9409, 0x00CF9416, 0x00CF95CE, 0x00CF9CEC, 
						  0x00CF9C04, 0x00CF9C3B, 0x00CF9CD7, 0x00CFA60F, 0x00CFA8EA, 0x00CFC87D, 0x00CFC8A3, 0x00CFC8FB, 0x00CFC9A4, 0x00CFCB91, 
						  0x00CFCAF0, 0x00CFCB4B, 0x00CFCC29, 0x00CFCC43, 0x00CFCC84, 0x00CFCCF7, 0x00CFCD71, 0x00CFCD9D, 0x00CFCDBD, 0x00CFCDDD, 
						  0x00CFCDFD, 0x00CFCE1D, 0x00CFCE81, 0x00CFCEAD, 0x00CFCED1, 0x00CFCEFD, 0x00CFCF1D, 0x00CFD28D, 0x00CFD2B3, 0x00CFD3CC, 
						  0x00CFD450, 0x00CFD4BC, 0x00CFD5D1, 0x00CFD530, 0x00CFD58B, 0x00CFD669, 0x00CFD683, 0x00CFD714, 0x00CFD793, 0x00CFD7C1, 
						  0x00CFD7ED, 0x00CFD80D, 0x00CFD82D, 0x00CFD84D, 0x00CFD86D, 0x00CFD891, 0x00CFD8A4, 0x00CFD8D1, 0x00CFD8FD, 0x00CFD921, 
						  0x00CFD94D, 0x00CFD96D, 0x00CFDCB7, 0x00CFE06A, 0x00CFE31C, 0x00CFE36F, 0x00CFE396, 0x00CFE3D5, 0x00CFE422, 0x00CFE29B, 
						  0x00CFE2FA, 0x00CFF41A, 0x00CFF4ED, 0x00CFF80C, 0x00CFF642, 0x00CFF661, 0x00CFF680, 0x00CFF8BB, 0x00CFFC38, 0x00D00699, 
						  0x00D006A6, 0x00D00B2A, 0x00D00C10, 0x00D00BDF, 0x00D00C77, 0x00D0113B, 0x00D015EB, 0x00D0184A, 0x00D01AAB, 0x00D01ABD, 
						  0x00D0234A, 0x00D024A8, 0x00D023DF, 0x00D024F7, 0x00D0263F, 0x00D02CE9, 0x00D03ACA, 0x00D04279, 0x00D04286, 0x00D0477C, 
						  0x00D04E9A, 0x00D04ECC, 0x00D04F58, 0x00D04FA3, 0x00D04FD3, 0x00D05017, 0x00D0508E, 0x00D050A0, 0x00D051A3, 0x00D0535E, 
						  0x00D0540F, 0x00D05422, 0x00D05452, 0x00D05465, 0x00D054AA, 0x00D054E8, 0x00D05C1F, 0x00D05A31, 0x00D05FB7, 0x00D0705B, 
						  0x00D06F83, 0x00D07023, 0x00D0764A, 0x00D07808, 0x00D07B9C, 0x00D07CBC, 0x00D0820C, 0x00D080BA, 0x00D080FA, 0x00D0809C, 
						  0x00D0837C, 0x00D0839A, 0x00D082AE, 0x00D0831D, 0x00D091B9, 0x00D09228, 0x00D09402, 0x00D096EA, 0x00D097AC, 0x00D097D0, 
						  0x00D09818, 0x00D09091, 0x00D098C2, 0x00D11C42, 0x00D11C8E, 0x00D18672, 0x00D192C9, 0x00D192D6, 0x00D19545, 0x00D19821, 
						  0x00D2236B, 0x00D2237A, 0x00D223F1, 0x00D23828, 0x00D23852, 0x00D23882, 0x00D238AC, 0x00D238BD, 0x00D238EF, 0x00D23919, 
						  0x00D23931, 0x00D23987, 0x00D239FA, 0x00D22AE0, 0x00D22B3B, 0x00D22C1F, 0x00D22CA8, 0x00D22F40, 0x00D2314E, 0x00D231EB, 
						  0x00D23279, 0x00D233A9, 0x00D23547, 0x00D23593, 0x00D22774, 0x00D23618, 0x00D25BE3, 0x00D34899, 0x00D348A6, 0x00D376EF, 
						  0x00D37743, 0x00D37D14, 0x00D38123, 0x00D3A8E1, 0x00D40B08, 0x00D40B17, 0x00D4406E, 0x00D45168, 0x00D45078, 0x00D454CF, 
						  0x00D454F9, 0x00D454B7, 0x00D45AF6, 0x00D45B0F, 0x00D45B3E, 0x00D45D4D, 0x00D45E2A, 0x00D470D4, 0x00D4720A, 0x00D4D999, 
						  0x00D4D9A6, 0x00D4DABE, 0x00D4E2BE, 0x00D52B0E, 0x00D52B43, 0x00D61622, 0x00D62452, 0x00D629BE, 0x00D634CE, 0x00D85ABE, 
						  0x00D85C7E, 0x00D85D3E, 0x00D85DFE, 0x00D85EC1, 0x00D85F8E, 0x00DD2319, 0x00DD2326, 0x00DD3BE9, 0x00DD3BF6, 0x00DE0D6B, 
						  0x00DE0DDE, 0x00DE0E8B, 0x00DE0ED4, 0x00DE102F, 0x00DE1097, 0x00DE11BE, 0x00DE12B6, 0x00DFA6CB, 0x00E00429, 0x00E00436, 
						  0x00E01B19, 0x00E01B26, 0x00E028FE, 0x00E05FCE, 0x00E0984C, 0x00E09913, 0x00E099B3, 0x00E09CAC, 0x00E0B119, 0x00E14884, 
						  0x00E1655B, 0x00E1656F, 0x00E166E3, 0x00E16979, 0x00E1699F, 0x00E168A7, 0x00E168B8, 0x00E16903, 0x00E16CC6, 0x00E2A4EC, 
						  0x00E2BBC3, 0x00E2CA23, 0x00E33E02, 0x00E4097C, 0x00E40A22, 0x00E40A2C, 0x00E58244, 0x00E5826D, 0x00E582A1, 0x00E582F9, 
						  0x00E66F96, 0x00E81949, 0x00EC9C1D, 0x00ECAD06, 0x00ECC18A, 0x00ECC1AA, 0x00ECC1CC, 0x00ECCA67, 0x00ECCD07, 0x00ECD126, 
						  0x00ECD639, 0x00ECDAC7, 0x00ECDA5A, 0x00ECDDBD, 0x00ECDFB3, 0x00ECE2B2, 0x00ED088A, 0x00ED1E85, 0x00ED2095, 0x00ED3189, 
						  0x00ED3332, 0x00ED3408, 0x00ED31D2, 0x00ED31DE, 0x00ED4A58, 0x00ED4A64, 0x00ED4ADE, 0x00ED4C4C, 0x00ED4C58, 0x00ED4ECA, 
						  0x00ED53DD, 0x00ED541D, 0x00ED55BA, 0x00ED56F1, 0x00ED5771, 0x00ED5C2D, 0x00ED5C39, 0x00ED5DA8, 0x00ED5F55, 0x00ED6C7E, 
						  0x00ED855A, 0x00ED85A3, 0x00ED8660, 0x00ED8739, 0x00EDD5BB, 0x00EDD62B, 0x00EDE06E, 0x00EDE60D, 0x00EE2D76, 0x00EE7505, 
						  0x00EE8AF8, 0x00EE9BDE, 0x00EEC882, 0x00EECD94, 0x00EECDB5, 0x00EECE97, 0x00EECEB8, 0x00EED1BF, 0x00EED732, 0x00EED740, 
						  0x00EED691, 0x00EED69F, 0x00EEDBDA, 0x00EF0FD9, 0x00EF1BB0, 0x00EF2075, 0x00EF6506, 0x00EF6A2D, 0x00EF6CD1, 0x00EF6F22, 
						  0x00EF97F1, 0x00EF9EDD, 0x00EFE462, 0x00EFE70D, 0x00EFF61F, 0x00EFF74F, 0x00EFF79F, 0x00F009DD, 0x00F01134, 0x00F011A4, 
						  0x00F07BF7, 0x00F07B59, 0x00F07B65, 0x00F07BEB, 0x00F07C85, 0x00F07C91, 0x00F07CD6, 0x00F093EA, 0x00F0E08D, 0x00F0E179, 
						  0x00F0E730, 0x00F0EC90, 0x00F0EDDD, 0x00F0EE1D, 0x00F0EE8D, 0x00F15069, 0x00F2447E, 0x00F24535, 0x00F29B36, 0x00F29DA3, 
						  0x00F29DBD, 0x00F29E8B, 0x00F29F1B, 0x00F29F7B, 0x00F2AE78, 0x00F2DB40, 0x00F2E4F9, 0x00F2E506, 0x00F2ED77, 0x00F3E140, 
						  0x00F3E156, 0x00F60E22, 0x00F60E2E, 0x00F60E41, 0x00F60FD2, 0x00F60FE2, 0x00F60FF9, 0x00F6C3AA, 0x00F6F548, 0x00F6F57C, 
						  0x00F6F5B0, 0x00F6F5E7, 0x00F6F61E, 0x00F6F65B, 0x00F6F791, 0x00F6F806, 0x00F6F87B, 0x00F6F8F0, 0x00F6FA38, 0x00F6FAB0, 
						  0x00F6FB28, 0x00F6F514, 0x00F8B19B, 0x00FC301B, 0x00FC3254, 0x00FC4D14, 0x00FC525B, 0x00FC5584, 0x00D37DC4, 0x00D455BF, 
						  0x00D45929, 0x00EC9A84, 0x00ECDC23, 0x00ECE3DB, 0x00ED1799, 0x00ED17B0, 0x00ED19F6, 0x00ED1A3C, 0x00ED1A4F, 0x00EDFE1B, 
						  0x00EDFD29, 0x00EDFDCA, 0x00F0E075, 0x00F0E154, 0x00F0E65D, 0x00F0E711};

	DWORD get_this_off8 = 0x0047CB90;

	DWORD get_this_off3C_calls[] = {0x00459649, 0x0045956D, 0x0045969A, 0x0047C2B4, 0x0047C37C, 0x00491C4B, 0x00491DEA, 0x00491E0E, 0x00491E3A, 0x0049F312, 
						  0x0049F7F7, 0x004A1FF4, 0x004A1EC4, 0x004A6CBA, 0x004A6CCB, 0x004A6CAA, 0x004CD2DB, 0x004CD35A, 0x0050E77E, 0x0053FBFD, 
						  0x00583AAE, 0x0058B289, 0x005E439D, 0x005EC5FE, 0x005EC627, 0x005EC769, 0x005F141D, 0x005F1433, 0x005F15C8, 0x005F1ABB, 
						  0x005F1ADF, 0x005F1AE9, 0x005F1BE8, 0x005F324D, 0x005F3269, 0x005F32AF, 0x0060770D, 0x00607738, 0x006079F4, 0x00608019, 
						  0x00608034, 0x00607FCE, 0x006085CE, 0x00608619, 0x00608634, 0x00643B55, 0x00643BF1, 0x00643C4A, 0x00643E3C, 0x00643E9C, 
						  0x00643EE0, 0x0064408D, 0x0064429A, 0x006442BE, 0x00644359, 0x00644404, 0x0064BB4B, 0x0064BC91, 0x006A9277, 0x006A9A5E, 
						  0x006A9A78, 0x006AADF6, 0x006AB660, 0x006AB67A, 0x006AD29A, 0x006F0C59, 0x00736759, 0x00741891, 0x00742082, 0x00742240, 
						  0x0074224A, 0x00742636, 0x00753298, 0x0075333B, 0x0075335A, 0x00789A84, 0x00789A94, 0x00789AB5, 0x007D0591, 0x007D05D1, 
						  0x007E2843, 0x00829BA8, 0x00829A72, 0x00872764, 0x00884FF8, 0x00884F9D, 0x008F92BA, 0x009D3548, 0x009D3586, 0x009D372F, 
						  0x009D3739, 0x009D3944, 0x009D394E, 0x009D3BDC, 0x009DE601, 0x009DE547, 0x009DE7C1, 0x009DE707, 0x009E7483, 0x009E7671, 
						  0x009E7773, 0x009E78D0, 0x00C89AB5, 0x00D24919, 0x00D28C53, 0x00E1FB8A, 0x00E1FC8D, 0x00E1FCA3, 0x00E20AD8, 0x00E20AE3, 
						  0x00E32BB7, 0x00E32C26, 0x00E32C67, 0x00E32CC3, 0x00E32CCF, 0x00E32D43, 0x00E32D0C, 0x00E32DD5, 0x00E333DA, 0x00E36AFC, 
						  0x00E36D3B, 0x00E379FA, 0x00E37B1A, 0x00E37B3A, 0x00E37B8A, 0x00E37BBD, 0x00E37BAA, 0x00E37C19, 0x00E3B634, 0x00E3B904, 
						  0x00E40D91, 0x00E49299, 0x00E492B4, 0x00E492C3, 0x00E492E4, 0x00E49300, 0x00E49348, 0x00E496A2, 0x00E496EA, 0x00E496FE, 
						  0x00E49719, 0x00E4972F, 0x00E49777, 0x00E49671, 0x00E4968C, 0x00E49E41, 0x00E49E85, 0x00E49D0B, 0x00E49D26, 0x00E4A2BA, 
						  0x00E4A30A, 0x00E4A32A, 0x00E4A35F, 0x00E4A3DA, 0x00E4A52E, 0x00E5832A, 0x00E68B3B, 0x00E69AFE, 0x00E69B2A, 0x00E69B4E, 
						  0x00E69B7E, 0x00E69BAE, 0x00E69BEA, 0x00E69C0A, 0x00E69C51, 0x00E69C8E, 0x00E69CBA, 0x00E69CDA, 0x00E69CFA, 0x00E69D94, 
						  0x00E69DAA, 0x00E69DD4, 0x00E69DEA, 0x00E709F4, 0x00E70AEA, /*0x00E71D83, 0x00E71DAF,*/ 0x00E8B71D, 0x00E8BB0D, 0x00E8BE3D, 
						  0x00E8C34D, 0x00E90982, 0x00F2A7E4, 0x00F2B24C};

	DWORD get_this_off3C = 0x004A6CE0;

	DWORD get_this_off60_calls[] = {0x004060DC, 0x00452CF4, 0x00453A2F, 0x004E4455, 0x004E43E2, 0x005B03A6, 0x005C5088, 0x006F7D12, 0x00706D20, 0x00706E33, 
						  0x00735DBC, 0x00735F06, 0x00736114, 0x0073621D, 0x00736237, 0x0073625D, 0x00741881, 0x007420C3, 0x007532EE, 0x00753348, 
						  0x00765B70, 0x0078AA0E, 0x008CE45B, 0x008D3304, 0x00907289, 0x009CB7A7, 0x00C7C7FA, 0x00C80740, 0x00C80B2C, 0x00C82EE7, 
						  0x00C89AC6, /*0x00C96C67, 0x00C96C0F,*/ 0x00E2A539, 0x00E2B487, 0x00E2C2E7, 0x00E356D9, 0x00E6C875, 0x00E6CDFD};

	DWORD set_this_off60_calls[] = {0x004060E5, 0x004D948B, 0x004E41FE, 0x00514836, 0x00550F87, 0x0064D568, 0x006ADF16, 0x006B04F9, 0x00706DDC, 0x00706ECD, 
						  0x0073FE9B, 0x00765D2B, 0x00765D94, 0x0078DF06, 0x008C853F, 0x008D28BD, 0x008D2B5A, 0x008D2B7F, 0x00C80804, 0x00C80BCC, 
						  0x00C82F38, 0x00C89CC6, /*0x00C96CA5, 0x00C96CFE,*/ 0x00D2DD47, 0x00D2E61C, 0x00E2A613, 0x00E69937, 0x00E8C18C};

	DWORD get_useless_calls[] = {0x00FE6147, 0x0116FF9A, 0x01172960, 0x01172978, 0x01172882, 0x01172B10, 0x01172B28, 0x01172A32, 0x01172EE9, 0x01172EF6, 
						  0x01172F0F, 0x011735D6, 0x011735E3, 0x011735FC, 0x01176C6A, 0x01187538, 0x01187548, 0x011AF308, 0x011B4E08, 0x011BB0E8, 
						  0x011BB0F8, 0x011C5568, 0x011C55B8, 0x011C58D8, 0x011C58E8, 0x011E12C8, 0x011E2FB8, 0x011E2FC8, 0x00407220, 0x004087A5, 
						  0x00408833, 0x0040AD25, 0x0040AD4D, 0x0040E21A, 0x00412D30, 0x00412D44, 0x00412364, 0x00412AB7, 0x00412ACD, 0x00412BD1, 
						  0x00412BE1, 0x00415B76, 0x004164FA, 0x00416555, 0x00416560, 0x0041654A, 0x00417846, 0x00417860, 0x00417AD9, 0x0041C215, 
						  0x0041C222, 0x0041CAEC, 0x0041CAFD, 0x0041CBEE, 0x0041CBFB, 0x0041D3CA, 0x0041D52A, 0x0041E6F2, 0x0041E7F4, 0x0041F53D, 
						  0x0041F463, 0x0041F48A, 0x0041F50E, 0x00422DDF, 0x00421FBD, 0x00422077, 0x004221B4, 0x00424A2C, 0x00428F66, 0x0042DD0A, 
						  0x0042DD95, 0x0042DE8D, 0x0042DF7D, 0x004337C4, 0x004337D1, 0x0043387F, 0x00433932, 0x00433EAD, 0x00433F0C, 0x0043413C, 
						  0x0043424F, 0x00434575, 0x00434586, 0x00434490, 0x00434862, 0x00434915, 0x00434C12, 0x00434CC5, 0x00435B10, 0x00435B1B, 
						  0x00435B26, 0x00436AA4, 0x00436AB1, 0x00436EB5, 0x00436EAA, 0x00436F91, 0x00436FFD, 0x00437035, 0x0043833C, 0x00438345, 
						  0x00438DC9, 0x00438DD1, 0x00439BE3, 0x00439BEE, 0x00439BF9, 0x00439C04, 0x00439C0F, 0x00439C1A, 0x00439EE9, 0x00439F39, 
						  0x0043A179, 0x0043A1EB, 0x0043A281, 0x0043A702, 0x0043C19A, 0x0043C2C5, 0x0043C2ED, 0x0043C6E7, 0x0043E83A, 0x0043F218, 
						  0x0043EE8C, 0x0043EE97, 0x0043EEA2, 0x0043EEE3, 0x0043F3CC, 0x0043F3D7, 0x004411EA, 0x0044534A, 0x00445A8D, 0x00446305, 
						  0x00446335, 0x0044635D, 0x004463AD, 0x00449169, 0x00449255, 0x004492D7, 0x004492E8, 0x004504C4, 0x004504CC, 0x004504BC, 
						  0x00450873, 0x00450880, 0x004508ED, 0x004508FA, 0x00450963, 0x00450970, 0x00450D86, 0x00450DAA, 0x00450FAF, 0x0045275A, 
						  0x0045426C, 0x0045477A, 0x004550FF, 0x00455389, 0x00456EA9, 0x00456F49, 0x00456FB9, 0x00457029, 0x00457099, 0x00458BCD, 
						  0x00458BDA, 0x0045A6FE, 0x0045A712, 0x0045A89D, 0x0045A8B1, 0x0045AA39, 0x0045A510, 0x0045AB6B, 0x0045AC63, 0x0045AC70, 
						  0x0045ADD8, 0x0045AF4A, 0x0045AF5B, 0x0045B0BC, 0x0045ADC7, 0x0045B8EC, 0x0045B94A, 0x0045B957, 0x0045E0B6, 0x0045E64E, 
						  0x0045E732, 0x0045E73D, 0x0045E8B0, 0x00462124, 0x00462149, 0x00462430, 0x00462593, 0x004625A8, 0x00462626, 0x0046263B, 
						  0x004627FC, 0x00462823, 0x00462890, 0x00462398, 0x004623A5, 0x004623DF, 0x004628D8, 0x00462B7A, 0x00462C5D, 0x00463EB5, 
						  0x00463F0B, 0x00464049, 0x0046405D, 0x00464092, 0x004640A6, 0x00465067, 0x0046507D, 0x004650B3, 0x004650D5, 0x00465035, 
						  0x00465056, 0x00465197, 0x004651D9, 0x0046524C, 0x00465267, 0x00465278, 0x0046529C, 0x0046647E, 0x00466500, 0x00469908, 
						  0x00469BED, 0x00469C22, 0x00469CAF, 0x0046BDDE, 0x0046BE1E, 0x0047792B, 0x0047798F, 0x00477A0A, 0x00477D9B, 0x00477DFF, 
						  0x00479D10, 0x0047AE7A, 0x0047D886, 0x0047D89A, 0x0047D93D, 0x0047D94E, 0x0047DAAA, 0x0047DAB7, 0x0047DB63, 0x0047DB70, 
						  0x0047DBFA, 0x0047DC07, 0x0047DD27, 0x0047DD34, 0x0047DE13, 0x0047DE20, 0x0047DEAA, 0x0047DEB7, 0x0047DF9D, 0x00480159, 
						  0x00480383, 0x004810B5, 0x004810DD, 0x004836B5, 0x004836DD, 0x004841F5, 0x0048421D, 0x00484D69, 0x00484D71, 0x00486775, 
						  0x004867A5, 0x004867D5, 0x00486805, 0x00486835, 0x00486865, 0x0048688D, 0x004868DD, 0x0048692D, 0x0048697D, 0x004869CD, 
						  0x00486A1D, 0x004881E9, 0x004881F4, 0x004880FE, 0x00488109, 0x00488114, 0x0048815B, 0x0048960F, 0x0048973E, 0x0048976A, 
						  0x004891C9, 0x00489A89, 0x00489A94, 0x00489AB5, 0x00489A7E, 0x0048A1AE, 0x0048AD6D, 0x0048AF57, 0x0048B06E, 0x0048B5F7, 
						  0x0048B99A, 0x0048BB25, 0x0048BB1A, 0x0048BB66, 0x0048BC76, 0x0048F19B, 0x0048F1A6, 0x0048F582, 0x0048F621, 0x0048F62C, 
						  0x0048FA25, 0x0048FA30, 0x0048FA3B, 0x0048FA1A, 0x0048FE19, 0x00491E78, 0x0049263D, 0x0049302B, 0x00493095, 0x004930C5, 
						  0x004930EF, 0x0049315D, 0x004931AD, 0x004943BC, 0x00494855, 0x0049487D, 0x00496D05, 0x00496D2D, 0x004978A5, 0x004978CD, 
						  0x004979B5, 0x004979DD, 0x00497B66, 0x004986EE, 0x004988F2, 0x0049A890, 0x0049AF20, 0x0049C208, 0x004A12AC, 0x004A18DC, 
						  0x004A254C, 0x004A3CB6, 0x004A3BE2, 0x004A40F5, 0x004A422F, 0x004A4334, 0x004A4395, 0x004A4BAC, 0x004A5B2A, 0x004A6EFD, 
						  0x004A73D1, 0x004A81E7, 0x004A835C, 0x004A8396, 0x004A83FB, 0x004A8408, 0x004A84D8, 0x004A84F5, 0x004A8652, 0x004A865F, 
						  0x004A86E6, 0x004A86F7, 0x004A87C6, 0x004A87D7, 0x004A88B2, 0x004A88BF, 0x004A8934, 0x004A8941, 0x004A8A2B, 0x004A8A3C, 
						  0x004A8B2B, 0x004A8B38, 0x004A8BA7, 0x004A8BB4, 0x004A8CD2, 0x004A8CDF, 0x004A8D4B, 0x004A8D58, 0x004A8DB6, 0x004A8DC3, 
						  0x004A9017, 0x004A90C1, 0x004A90D2, 0x004A900A, 0x004A93B2, 0x004A93C6, 0x004A947E, 0x004A94EB, 0x004A94F8, 0x004A96F7, 
						  0x004A9704, 0x004A971A, 0x004A9752, 0x004A975F, 0x004A9889, 0x004A9896, 0x004A9952, 0x004A995F, 0x004A9A12, 0x004A9A1F, 
						  0x004A9A6B, 0x004A9A78, 0x004A9ACB, 0x004A9AD8, 0x004A9B4B, 0x004A9B58, 0x004A9BCB, 0x004A9BD8, 0x004A9C48, 0x004A9C55, 
						  0x004A9CBB, 0x004A9CC8, 0x004A9D2B, 0x004A9D38, 0x004A9DB6, 0x004A9F57, 0x004A9F6E, 0x004A9F87, 0x004A9FF9, 0x004AA13B, 
						  0x004AA148, 0x004AA220, 0x004AA3FB, 0x004AA53A, 0x004AA547, 0x004AA66B, 0x004AA833, 0x004AA7E5, 0x004AA7FA, 0x004AA810, 
						  0x004AA81D, 0x004AAA46, 0x004AAA80, 0x004AAAB4, 0x004AAB88, 0x004AAB95, 0x004AAC2A, 0x004AAEA4, 0x004AAEB1, 0x004AAFF5, 
						  0x004AB05F, 0x004AB104, 0x004AAE42, 0x004AAE52, 0x004ABC2E, 0x004ABD85, 0x004ABDFD, 0x004ABEF5, 0x004ABF12, 0x004ABB27, 
						  0x004ABB38, 0x004AC4DC, 0x004AC4F9, 0x004ACE90, 0x004ACEA9, 0x004ACEC0, 0x004ACF32, 0x004ACF4F, 0x004AD65C, 0x004AD6A1, 
						  0x004AD6B9, 0x004AD8E0, 0x004AD8F1, 0x004AD941, 0x004AD95E, 0x004ADBDB, 0x004ADBF1, 0x004ADC56, 0x004ADC73, 0x004AEDF7, 
						  0x004AEE15, 0x004AF175, 0x004AF18C, 0x004AF40C, 0x004AF41C, 0x004AF4C6, 0x004AF4D6, 0x004AFAE0, 0x004AFB05, 0x004B00ED, 
						  0x004B08C3, 0x004B0BAC, 0x004B0BC3, 0x004AE11D, 0x004AE138, 0x004AE155, 0x004B16DC, 0x004B16EF, 0x004B167A, 0x004B1687, 
						  0x004B17C1, 0x004B173F, 0x004B1ABF, 0x004B1C61, 0x004B1D7F, 0x004B1DC3, 0x004B1FB8, 0x004B211B, 0x004B215F, 0x004B22F8, 
						  0x004B24D4, 0x004B252A, 0x004B2744, 0x004B283E, 0x004B2862, 0x004B2873, 0x004B2CB6, 0x004B2CDA, 0x004B2CEB, 0x004B2EA4, 
						  0x004B2EBE, 0x004B2F7A, 0x004B2F9E, 0x004B2FAF, 0x004B2B3C, 0x004B31CB, 0x004B31DC, 0x004B3237, 0x004B3254, 0x004B34E7, 
						  0x004B34FF, 0x004B355F, 0x004B3570, 0x004B35A2, 0x004B35B7, 0x004B366F, 0x004B3680, 0x004B36FA, 0x004B3B6D, 0x004B3BBE, 
						  0x004B3BD2, 0x004B3C2E, 0x004B3C3F, 0x004B3C71, 0x004B3C85, 0x004B3E24, 0x004B3E38, 0x004B3EA4, 0x004B3EB1, 0x004B40D1, 
						  0x004B40E5, 0x004B4289, 0x004B429A, 0x004B4307, 0x004B4322, 0x004B452E, 0x004B4541, 0x004B45A9, 0x004B45FC, 0x004B4617, 
						  0x004B468B, 0x004B469F, 0x004B4705, 0x004B4712, 0x004B4772, 0x004B47AA, 0x004B47C5, 0x004B4983, 0x004B4990, 0x004B4BEC, 
						  0x004B4C18, 0x004B4C94, 0x004B4CA7, 0x004B4DF4, 0x004B4E35, 0x004B4E48, 0x004B4F6A, 0x004B5020, 0x004B504B, 0x004B50A8, 
						  0x004B50CC, 0x004B50D9, 0x004B51CA, 0x004B5235, 0x004B5250, 0x004B5278, 0x004B54C5, 0x004B54D6, 0x004B54F6, 0x004B5507, 
						  0x004B5765, 0x004B5729, 0x004B5736, 0x004B5758, 0x004B5970, 0x004B5983, 0x004B59BF, 0x004B5A35, 0x004B5AF4, 0x004B5B07, 
						  0x004B5B43, 0x004B5BE8, 0x004B5C80, 0x004B5C93, 0x004B5CA0, 0x004B5EC4, 0x004B5EE3, 0x004B5F00, 0x004B61D9, 0x004B62A1, 
						  0x004B6465, 0x004B6480, 0x004B649D, 0x004B6AD4, 0x004B6AF0, 0x004B6AFD, 0x004B6DEC, 0x004B6DFD, 0x004B6FF0, 0x004B701A, 
						  0x004B7185, 0x004B7215, 0x004B737E, 0x004B738B, 0x004B734F, 0x004B7641, 0x004B7652, 0x004B782F, 0x004B7840, 0x004B7965, 
						  0x004B797A, 0x004B799C, 0x004B79A9, 0x004B82A3, 0x004B82B4, 0x004B82D4, 0x004B82E5, 0x004B8452, 0x004B8463, 0x004B8483, 
						  0x004B8494, 0x004B8732, 0x004B873F, 0x004B882B, 0x004B883C, 0x004B8903, 0x004B8910, 0x004B8CBC, 0x004B8CD5, 0x004B8CE8, 
						  0x004B8E39, 0x004B8E54, 0x004B9147, 0x004B91E2, 0x004B9291, 0x004B929E, 0x004B93D3, 0x004B93E6, 0x004B9889, 0x004B989E, 
						  0x004B991C, 0x004B9931, 0x004B972D, 0x004B973E, 0x004B976A, 0x004B9788, 0x004B9A97, 0x004B9CE3, 0x004BA0A2, 0x004BA0E5, 
						  0x004BA15D, 0x004BA1A0, 0x004BA333, 0x004BA610, 0x004BA8F4, 0x004BA901, 0x004BABE4, 0x004BABF1, 0x004BADF4, 0x004BB216, 
						  0x004BB223, 0x004BB249, 0x004BB25D, 0x004BB279, 0x004BB6A5, 0x004BB6CD, 0x004BCF56, 0x004BCFA5, 0x004BD086, 0x004BD0D3, 
						  0x004BD18B, 0x004BDC7F, 0x004BDDD5, 0x004BDE05, 0x004BDE2D, 0x004BDE7D, 0x004BE4BC, 0x004BE8DC, 0x004BF375, 0x004BF39D, 
						  0x004C01B9, 0x004C0CC7, 0x004C0D35, 0x004C1B10, 0x004C1B1B, 0x004C1D0C, 0x004C2579, 0x004C365D, 0x004C3868, 0x004C385D, 
						  0x004C3BDA, 0x004C406B, 0x004C44DD, 0x004C5F6C, 0x004C7209, 0x004C7256, 0x004C762C, 0x004C763F, 0x004C7655, 0x004C76FC, 
						  0x004C7749, 0x004C77EB, 0x004C77F8, 0x004C7A17, 0x004C7A26, 0x004C892F, 0x004C89AF, 0x004C8A08, 0x004C8A15, 0x004CA840, 
						  0x004CA848, 0x004CAA9B, 0x004CAA3F, 0x004CAAFB, 0x004CAB0C, 0x004CACA0, 0x004CAC24, 0x004CAC40, 0x004CAD95, 0x004CADA2, 
						  0x004CADCD, 0x004CB22B, 0x004CB1CF, 0x004CB270, 0x004CB27D, 0x004CB291, 0x004CB30F, 0x004CB319, 0x004CB50F, 0x004CB520, 
						  0x004CB6CB, 0x004CB6E0, 0x004CB463, 0x004CB474, 0x004CBA05, 0x004CBA26, 0x004CBA44, 0x004CBA68, 0x004CBAFA, 0x004CBB3A, 
						  0x004CBB6A, 0x004CBBAA, 0x004CC175, 0x004CC180, 0x004CC487, 0x004CC498, 0x004CC5BF, 0x004CC67C, 0x004CC689, 0x004CC6A4, 
						  0x004CC70C, 0x004CC719, 0x004CC734, 0x004CC79C, 0x004CC7A9, 0x004CC7C4, 0x004CC82C, 0x004CC839, 0x004CC854, 0x004CC982, 
						  0x004CC98D, 0x004CC998, 0x004CC9A3, 0x004CCAC2, 0x004CCACF, 0x004CCD01, 0x004CCCAD, 0x004CCCC3, 0x004CCCD9, 0x004CCCE4, 
						  0x004CCCF6, 0x004CF8E7, 0x004CFE73, 0x004CFEEE, 0x004D0060, 0x004D7B60, 0x004D7B6E, 0x004DB933, 0x004DB976, 0x004DC009, 
						  0x004DC01C, 0x004DC2DA, 0x004DF085, 0x004E17F5, 0x004E17EA, 0x004E29A3, 0x004E4CB5, 0x004E4CDD, 0x004E4DC5, 0x004E4DED, 
						  0x004F1DE0, 0x004F1EB2, 0x004F64F5, 0x004F6525, 0x004F654D, 0x004F659D, 0x004F84F5, 0x004F851D, 0x004F8B57, 0x004FC1A5, 
						  0x004FC1CD, 0x004FD515, 0x004FD53D, 0x004FD625, 0x004FD64D, 0x004FD735, 0x004FD75D, 0x004FD845, 0x004FD86D, 0x004FF115, 
						  0x004FF9AD, 0x005011CB, 0x0050125F, 0x005017CD, 0x00501BF8, 0x00501D08, 0x005022C9, 0x005023AC, 0x00502559, 0x0050267C, 
						  0x00503CD0, 0x005046EA, 0x0050745C, 0x0050914A, 0x0050B06C, 0x0050B3F0, 0x0050B419, 0x0050B485, 0x0050B653, 0x0050B5A9, 
						  0x0050BF38, 0x0050B898, 0x0050C452, 0x0050C5A1, 0x0050C5A9, 0x0050C5B4, 0x0050C45A, 0x0050C96B, 0x0050C973, 0x0050C97B, 
						  0x0050C986, 0x0050C4A0, 0x0050CD8D, 0x0050CD95, 0x0050CDDB, 0x0050CEA5, 0x0050CEB0, 0x0050CEBB, 0x0050CBD0, 0x0050D293, 
						  0x0050D29E, 0x0050CBD8, 0x0050CBE0, 0x0050D83C, 0x0050D894, 0x0050F9F4, 0x0051021A, 0x00512374, 0x0051251A, 0x00514202, 
						  0x005142DA, 0x005140CC, 0x00514B9F, 0x00515998, 0x00516223, 0x005166BF, 0x005170FF, 0x00517AB5, 0x00517C3B, 0x00517D3E, 
						  0x00517E2B, 0x00517EFB, 0x00517FB5, 0x00518055, 0x00518293, 0x0051811D, 0x0051847C, 0x005187CB, 0x005189AE, 0x00518B0C, 
						  0x00518B14, 0x00518719, 0x00518DB6, 0x00518DF3, 0x00518E86, 0x00518FA9, 0x005195F3, 0x00519A31, 0x00519AC3, 0x00519F59, 
						  0x0051A09F, 0x0051A1B8, 0x0051A2EF, 0x0051A576, 0x0051AAE6, 0x0051A8D2, 0x0051B384, 0x0051B3A0, 0x0051B3C1, 0x0051B3E5, 
						  0x0051B600, 0x0051B60D, 0x0051B631, 0x0051B2BB, 0x0051B2CC, 0x0051B2FA, 0x0051C088, 0x0051C69C, 0x0051C732, 0x0051C76E, 
						  0x0051C857, 0x0051CAAD, 0x0051D52B, 0x0051F07E, 0x0051F093, 0x0051F647, 0x0051F668, 0x0051F93C, 0x005208BC, 0x005209E6, 
						  0x00521A92, 0x00522595, 0x00522450, 0x00522725, 0x005227E0, 0x00522F21, 0x00522FCF, 0x00522CDD, 0x00522CE5, 0x005231D3, 
						  0x00523224, 0x00523575, 0x00523580, 0x00523AC1, 0x0052408E, 0x005269E2, 0x00526B61, 0x00527670, 0x00527959, 0x00527A6A, 
						  0x00528F81, 0x005294AC, 0x0052AB13, 0x0052AB88, 0x0052C0F3, 0x0052C6CD, 0x0052D2D4, 0x0052D2CC, 0x0052D420, 0x0052ECD6, 
						  0x0052ED16, 0x0052F08E, 0x0052F096, 0x0052EF8E, 0x0052EF96, 0x0052F0F6, 0x0052F61D, 0x0052F628, 0x0052F363, 0x0052F36B, 
						  0x0052F398, 0x0052F6F6, 0x0052F8A9, 0x005326FB, 0x00532799, 0x00532F3E, 0x00532F56, 0x00532F84, 0x00532FD5, 0x00533257, 
						  0x0053361A, 0x00533AE0, 0x00533C40, 0x00533C2A, 0x00533CF6, 0x00534145, 0x0053413A, 0x0053420E, 0x00534506, 0x0053467B, 
						  0x005346E2, 0x00534707, 0x005344FE, 0x00534F46, 0x00534F4E, 0x00534F60, 0x00534F76, 0x00534F92, 0x00534FB2, 0x00534FC1, 
						  0x00534FD6, 0x00534FE2, 0x00535080, 0x0053587D, 0x00535888, 0x005356D7, 0x00535D65, 0x00536007, 0x00536018, 0x00536079, 
						  0x00536984, 0x0053699A, 0x005365F1, 0x00536D7A, 0x00536D85, 0x00536BB7, 0x00537E20, 0x00539B7F, 0x0053B042, 0x0053B04A, 
						  0x0053BCB6, 0x0053C164, 0x0053C71F, 0x0053C7F4, 0x0053C9CC, 0x0053CAA3, 0x0053CAB4, 0x0053CAED, 0x0053CBF6, 0x0053CC07, 
						  0x0053CC38, 0x0053CD02, 0x0053CD13, 0x0053CD44, 0x0053D0F3, 0x0053DEFB, 0x0053DF27, 0x0053ED06, 0x0053EFF3, 0x0053F00D, 
						  0x0053F086, 0x0053F154, 0x0053F5E9, 0x005406D0, 0x00540CB4, 0x005412FF, 0x005428B3, 0x005432B0, 0x005432B8, 0x005432C0, 
						  0x005432C8, 0x005432E4, 0x00543D71, 0x00543C8B, 0x005443A7, 0x00544FF1, 0x0054758A, 0x0054791A, 0x005497D2, 0x00549836, 
						  0x00549AA0, 0x00549AB3, 0x00549AF0, 0x00549C9F, 0x00549CAC, 0x00549DF7, 0x00549EF8, 0x00549F0C, 0x0054A38C, 0x0054A4A4, 
						  0x0054A549, 0x0054A7E4, 0x0054B815, 0x0054BEE6, 0x0054BF29, 0x0054C35E, 0x0054C36C, 0x0054FB18, 0x0054FB25, 0x00550171, 
						  0x005501C8, 0x0055021F, 0x0055022C, 0x0055028A, 0x00550364, 0x00550371, 0x00550380, 0x00550441, 0x0055044E, 0x0055045F, 
						  0x005505EB, 0x00550653, 0x00550696, 0x005508E3, 0x005508F1, 0x00551CA8, 0x00551BEF, 0x00552631, 0x00552702, 0x005547D5, 
						  0x005547EA, 0x0055489A, 0x005548A7, 0x00554646, 0x00556418, 0x0055640D, 0x0055652D, 0x00556541, 0x0055658A, 0x00556597, 
						  0x0055667C, 0x005571F5, 0x00557225, 0x0055724D, 0x0055729D, 0x00558F58, 0x0055928D, 0x00559522, 0x00559580, 0x005597DE, 
						  0x0055B4A3, 0x0055B935, 0x0055B981, 0x0055CAC5, 0x0055CAED, 0x0055CFD5, 0x0055E431, 0x0055E441, 0x0055E452, 0x0055E463, 
						  0x0055E474, 0x0055E485, 0x0055E496, 0x0055E4A7, 0x0055E4B8, 0x0055E4C9, 0x0055F3D5, 0x0055F3FD, 0x00561F95, 0x00561FBD, 
						  0x00562634, 0x00562A11, 0x00563E1A, 0x00563F4D, 0x00567376, 0x005673E3, 0x0056743D, 0x0056748B, 0x00568A9A, 0x00568B7D, 
						  0x0056DB73, 0x0056E0E7, 0x00574FF1, 0x00574F68, 0x00581918, 0x00581928, 0x005819A8, 0x005819B8, 0x00581B7B, 0x00581B88, 
						  0x00581C2F, 0x00581C3C, 0x00581D16, 0x00581DFD, 0x00581E0A, 0x00581EDB, 0x00581EE8, 0x00581FA1, 0x0058243C, 0x00582530, 
						  0x005829D6, 0x00582898, 0x005828D0, 0x0058292C, 0x00582CF3, 0x00582D00, 0x00582D87, 0x00582D94, 0x00582EEA, 0x00582F76, 
						  0x0058321F, 0x005832AF, 0x00583820, 0x0058382D, 0x00583EA6, 0x00583F8D, 0x00583F9A, 0x00585C30, 0x00585DFF, 0x0058626C, 
						  0x005862CC, 0x0058633C, 0x00586409, 0x0058641A, 0x005867F6, 0x0058676C, 0x0058748B, 0x00587498, 0x0058751A, 0x00587531, 
						  0x00587550, 0x0058756E, 0x00587586, 0x0058780A, 0x00588A18, 0x00588B6C, 0x00588C93, 0x0058C778, 0x0058C798, 0x0058C7B1, 
						  0x0058F585, 0x0058FBF3, 0x0058FC85, 0x0058FC8D, 0x00591540, 0x00591558, 0x00591BC2, 0x00591BDA, 0x00597FA4, 0x0059AA7E, 
						  0x0059AA8F, 0x0059AEAC, 0x0059AEC5, 0x0059B838, 0x0059B843, 0x0059E30A, 0x005A1146, 0x005A11B0, 0x005A13D6, 0x005A1C41, 
						  0x005A1C4E, 0x005A1BA1, 0x005A1BB2, 0x005A1DF9, 0x005A45DC, 0x005A4696, 0x005A5BAE, 0x005A7F73, 0x005A7F80, 0x005A9916, 
						  0x005A997C, 0x005A99AB, 0x005A9E96, 0x005A9DA1, 0x005AD4C0, 0x005AF854, 0x005AF880, 0x005B1674, 0x005B1685, 0x005B17F7, 
						  0x005B1808, 0x005B470F, 0x005B4757, 0x005B94D9, 0x005BA7EC, 0x005BA82A, 0x005BAAEA, 0x005BC1A9, 0x005BC269, 0x005BC329, 
						  0x005BC3FE, 0x005BC6BA, 0x005BC9CD, 0x005BCA4D, 0x005BE1CC, 0x005C4EE8, 0x005C4EDD, 0x005C65DF, 0x005CB9E5, 0x005CBA0D, 
						  0x005CC1F9, 0x005CC273, 0x005CE3E7, 0x005D5C15, 0x005D5C3D, 0x005DD457, 0x005DED99, 0x005E0295, 0x005E02BD, 0x005E057A, 
						  0x005E2F5D, 0x005E6142, 0x005E9179, 0x005E95B9, 0x005E9684, 0x005EA80D, 0x005EB3B1, 0x005EB3C2, 0x005EB210, 0x005EB221, 
						  0x005ECD5E, 0x005EE179, 0x005EEB73, 0x005F0E38, 0x005F4345, 0x005F436D, 0x005F45B5, 0x005F45DD, 0x005F46C5, 0x005F46ED, 
						  0x005F4BD7, 0x005F4E8C, 0x005F4F2C, 0x005FA1CC, 0x005FA22D, 0x005FA23A, 0x005FA256, 0x005FA29D, 0x005FA2AA, 0x005FA2C6, 
						  0x005FA9BD, 0x005FA9FD, 0x005FB05D, 0x005FB4B1, 0x005FB610, 0x005FB6D0, 0x005FB930, 0x005FB94A, 0x005FB9EC, 0x005FBA06, 
						  0x005FBA62, 0x005FBB0D, 0x005FBB54, 0x005FBB63, 0x005FBC77, 0x005FBC88, 0x005FBE8D, 0x005FC1C4, 0x005FC10E, 0x005FCBC5, 
						  0x005FCC2B, 0x005FCE1C, 0x005FDFA9, 0x005FE178, 0x005FE199, 0x005FE1B9, 0x005FE1D0, 0x005FE1E6, 0x005FE211, 0x005FE685, 
						  0x005FE6AF, 0x005FE74D, 0x005FE837, 0x005FE977, 0x005FFA14, 0x005FFA2A, 0x005FFA63, 0x005FFA82, 0x005FFB14, 0x005FFB2A, 
						  0x005FFB63, 0x005FFB82, 0x006016D9, 0x006018A5, 0x006018CD, 0x00601C4D, 0x00601CB4, 0x00601D1C, 0x00601DB9, 0x00601E7B, 
						  0x0060205C, 0x0060204C, 0x0060211E, 0x00608A65, 0x00608A8D, 0x00608E57, 0x00609F05, 0x00609F2D, 0x0060A78C, 0x0060BC39, 
						  0x0060C170, 0x0060CFDC, 0x0060CFED, 0x0060E6B5, 0x0060E6DD, 0x0060E7C5, 0x0060E7ED, 0x0060E8D5, 0x0060E8FD, 0x0060E9E5, 
						  0x0060EA0D, 0x0060F755, 0x0060F77D, 0x0060FCF0, 0x0060FCFB, 0x0061062E, 0x00610653, 0x00610B29, 0x00610D84, 0x00610D8F, 
						  0x0061128D, 0x0061156D, 0x006115F3, 0x006114CF, 0x00611834, 0x00611760, 0x00611BA8, 0x00611BBC, 0x0061202D, 0x00612510, 
						  0x00612597, 0x00612A29, 0x00612B5A, 0x00612B62, 0x00612B74, 0x00612B8A, 0x00612BA6, 0x00612BBE, 0x00612BCE, 0x00612BDC, 
						  0x00612BE6, 0x00612BFE, 0x00612C13, 0x00612C1B, 0x00612E2F, 0x00612E4C, 0x00612E6A, 0x00612EAD, 0x00612D39, 0x00612EE0, 
						  0x00612F3A, 0x00612D5A, 0x00612D62, 0x00612D6A, 0x00612D7C, 0x00612DF0, 0x00612DF8, 0x00612E0D, 0x00612FD6, 0x00612FE5, 
						  0x00613070, 0x00613D45, 0x00613D3A, 0x00613F6D, 0x0061451E, 0x00614529, 0x00614DFA, 0x00614E05, 0x0061511F, 0x006162D5, 
						  0x00616ED5, 0x00617ACF, 0x006189AD, 0x00618EC6, 0x00618EFA, 0x00619BD7, 0x00619BE2, 0x0061A39A, 0x0061A3A2, 0x0061A7C1, 
						  0x0061A7C9, 0x0061B177, 0x0061AE5D, 0x0061B35C, 0x0061B517, 0x0061B409, 0x0061B7D5, 0x0061B7FD, 0x0061B84D, 0x0061B9FD, 
						  0x0061BE06, 0x0061BE15, 0x0061BE56, 0x0061BE65, 0x0061D194, 0x0061D2A3, 0x0061D349, 0x0061D433, 0x0061D4B3, 0x0061DDC5, 
						  0x0061DDCD, 0x0061E07B, 0x0061E083, 0x0061E225, 0x0061E3A8, 0x0061E215, 0x0061E21D, 0x0061FA63, 0x0061FA6C, 0x0061FFB3, 
						  0x0061FFC2, 0x00620236, 0x00620835, 0x0062104C, 0x0062105E, 0x00621075, 0x006210C9, 0x006211F2, 0x006207F9, 0x00620817, 
						  0x00621E6D, 0x00621F80, 0x00621FE5, 0x006220C5, 0x006220BA, 0x006220FD, 0x00623049, 0x00623099, 0x0062496C, 0x00624D8C, 
						  0x00624D94, 0x0062A1D7, 0x0062B2D1, 0x0062B2E5, 0x0062B606, 0x0062B653, 0x0062B793, 0x0062B56A, 0x0062C0FC, 0x0062C196, 
						  0x0062C2DB, 0x0062C2E8, 0x0062C32B, 0x0062C338, 0x0062C34A, 0x0062E301, 0x0062E6CB, 0x0062E6D8, 0x0062E6E7, 0x006315C7, 
						  0x0063173C, 0x00631808, 0x00631510, 0x006379AA, 0x00637A9D, 0x00637DE2, 0x0063912C, 0x0063AB8C, 0x0063BC7C, 0x0063BCCC, 
						  0x0063D1EC, 0x0063D96C, 0x0063DE0C, 0x0063E13C, 0x0063E7DF, 0x0063E8CF, 0x0063EB45, 0x0063EB95, 0x0063EBC5, 0x0063EBED, 
						  0x0063EC45, 0x0063EC6D, 0x0063ECBD, 0x0063ED1D, 0x006402F5, 0x00640325, 0x0064034D, 0x0064039D, 0x00644BFD, 0x00646435, 
						  0x0064648D, 0x006468A2, 0x00646E37, 0x00646F9C, 0x006472C9, 0x00647335, 0x006473A1, 0x0064740D, 0x0064750D, 0x006475B3, 
						  0x00647658, 0x006476FD, 0x00647DE5, 0x0064810B, 0x00648AE9, 0x006498EC, 0x0064CE7D, 0x0064CF50, 0x0064DB6E, 0x0064DE90, 
						  0x0064DB40, 0x0064F2A2, 0x0064F47D, 0x0064FE55, 0x0064FE4A, 0x0064FFF7, 0x006500B7, 0x00650210, 0x00650319, 0x00650414, 
						  0x00650485, 0x00652DBD, 0x00652ECF, 0x0065423D, 0x006558A7, 0x00655ADA, 0x00655BCD, 0x006560D6, 0x00656C35, 0x00656C5D, 
						  0x00657FEA, 0x006581CD, 0x006621AA, 0x0066290A, 0x00662AED, 0x00662B7D, 0x00663C2A, 0x00663DCD, 0x00667255, 0x00667260, 
						  0x00670829, 0x00674DEB, 0x0067508C, 0x006745DF, 0x006746A1, 0x00675A3D, 0x00675FAA, 0x006830EE, 0x006912A3, 0x00693D09, 
						  0x0069A5FE, 0x0069A606, 0x0069F61A, 0x006A19FE, 0x006A1A22, 0x006A1A54, 0x006A1A74, 0x006A1AB5, 0x006A1B0F, 0x006A1C8C, 
						  0x006A26F7, 0x006A51C0, 0x006A531C, 0x006A80D5, 0x006A8CB7, 0x006A8CC2, 0x006A8CCD, 0x006AA705, 0x006AA710, 0x006A96F7, 
						  0x006A96FF, 0x006A8FD3, 0x006A8FF0, 0x006AB428, 0x006AB430, 0x006AAC54, 0x006AAC6E, 0x006ADD29, 0x006ADDD3, 0x006ADDEA, 
						  0x006AEF02, 0x006AEF0A, 0x006AFAC1, 0x006AF96A, 0x006AF972, 0x006AF97A, 0x006AF9F9, 0x006AFA04, 0x006AFA0F, 0x006B1F43, 
						  0x006B2153, 0x006B2D8E, 0x006B36A5, 0x006B36CD, 0x006B3DA5, 0x006B3DCD, 0x006B3ED4, 0x006B3ECC, 0x006B475F, 0x006B48BC, 
						  0x006BED55, 0x006BED85, 0x006BEDAD, 0x006BEDFD, 0x006BF501, 0x006BF4F9, 0x006C124F, 0x006C125A, 0x006C1265, 0x006C118C, 
						  0x006C1197, 0x006C37BD, 0x006C45DF, 0x006C4885, 0x006C48B5, 0x006C48E5, 0x006C490F, 0x006C497D, 0x006C49CD, 0x006C4A1D, 
						  0x006C5F66, 0x006C5F6E, 0x006C5F77, 0x006C5F88, 0x006C5FA8, 0x006C5FC8, 0x006C6020, 0x006C76DF, 0x006C78E9, 0x006C7B36, 
						  0x006C7B4A, 0x006C7E44, 0x006C7E58, 0x006C7CA5, 0x006C7CB7, 0x006C7EDD, 0x006C8141, 0x006C8149, 0x006C8154, 0x006C815C, 
						  0x006C8167, 0x006C816F, 0x006C817A, 0x006C8182, 0x006C818A, 0x006C8195, 0x006C7FD6, 0x006C8D42, 0x006C96C8, 0x006C9D3F, 
						  0x006CA4EC, 0x006CA514, 0x006CA9EF, 0x006CAC7B, 0x006CACDF, 0x006CB4DA, 0x006CB4E5, 0x006CAF2D, 0x006CBB2A, 0x006CBB35, 
						  0x006CB57D, 0x006CBBC9, 0x006CBC99, 0x006CBD69, 0x006CBE39, 0x006CCEF3, 0x006CCEFB, 0x006CCE59, 0x006CD0F3, 0x006CD0FB, 
						  0x006CD059, 0x006CD2F3, 0x006CD2FB, 0x006CD259, 0x006CD4F3, 0x006CD4FB, 0x006CD459, 0x006CE93C, 0x006CF4CA, 0x006CF5BD, 
						  0x006D061A, 0x006D070D, 0x006D101A, 0x006D115D, 0x006D14EA, 0x006D15DD, 0x006D1EE3, 0x006D1EF7, 0x006D226A, 0x006D2845, 
						  0x006D286D, 0x006D3380, 0x006D338B, 0x006D356D, 0x006D357B, 0x006D3589, 0x006D36EA, 0x006D4555, 0x006D456B, 0x006D454A, 
						  0x006D477B, 0x006D47AE, 0x006D483A, 0x006D4A88, 0x006D4622, 0x006D4FA5, 0x006D4FCD, 0x006D6320, 0x006D669D, 0x006D6AC5, 
						  0x006D6AED, 0x006D773D, 0x006D7755, 0x006D7915, 0x006D780E, 0x006D8085, 0x006D7FE4, 0x006D81B3, 0x006D81C1, 0x006D83C1, 
						  0x006D82A5, 0x006D877D, 0x006D8B51, 0x006D8D6D, 0x006D9D43, 0x006D9D51, 0x006D9D5F, 0x006DA003, 0x006DA278, 0x006D9EFF, 
						  0x006D9F1C, 0x006DB358, 0x006DB385, 0x006DC12A, 0x006DC26D, 0x006DC50E, 0x006DC519, 0x006DC524, 0x006DC561, 0x006DC56F, 
						  0x006DC57D, 0x006DF0AA, 0x006DF2FA, 0x006DF740, 0x006E043E, 0x006E0D4A, 0x006E108C, 0x006E10A3, 0x006E127A, 0x006E12D7, 
						  0x006E12DF, 0x006E1978, 0x006E1AC1, 0x006E1897, 0x006E18B6, 0x006E1E8D, 0x006E1EF3, 0x006E202F, 0x006E24E9, 0x006E25AF, 
						  0x006E277A, 0x006E2781, 0x006E27B2, 0x006E27B9, 0x006E2BA6, 0x006E2D84, 0x006E2DE0, 0x006E2E14, 0x006E2E46, 0x006E2C72, 
						  0x006E3170, 0x006E31AF, 0x006E31F6, 0x006E324D, 0x006E3675, 0x006E3793, 0x006E3504, 0x006E38CC, 0x006E3D3B, 0x006E3D52, 
						  0x006E3D7B, 0x006E359C, 0x006E41DE, 0x006E41FC, 0x006E4245, 0x006E4281, 0x006E4291, 0x006E4319, 0x006E4646, 0x006E40BF, 
						  0x006E498A, 0x006E4AA3, 0x006E4ADF, 0x006E4C6C, 0x006E4E3F, 0x006E4E6F, 0x006E4E9E, 0x006E4EB9, 0x006E4EDE, 0x006E4F05, 
						  0x006E4C87, 0x006E4FE9, 0x006E518E, 0x006E5199, 0x006E51A4, 0x006E530A, 0x006E5440, 0x006E5514, 0x006E553E, 0x006E581B, 
						  0x006E583A, 0x006E598E, 0x006E5995, 0x006E59C7, 0x006E59CE, 0x006E5B5D, 0x006E5B64, 0x006E5B83, 0x006E5B8A, 0x006E65A0, 
						  0x006E6CBA, 0x006E6D78, 0x006E7156, 0x006E7B8B, 0x006E7C7A, 0x006E7D75, 0x006E7AFC, 0x006E7B1B, 0x006E81F8, 0x006EA0FC, 
						  0x006EA7DC, 0x006EAA0F, 0x006EAB75, 0x006EABA5, 0x006EABCD, 0x006EAC1D, 0x006EB3D5, 0x006EB3FD, 0x006EE4AC, 0x006EE8DC, 
						  0x006EEA35, 0x006EEA65, 0x006EEB0F, 0x006EEB4D, 0x006EEB9D, 0x006EECF5, 0x006EED25, 0x006EED4D, 0x006EED9D, 0x006EF7E5, 
						  0x006EF80D, 0x006F0237, 0x006F218C, 0x006F29BC, 0x006F2C7F, 0x006F2DD5, 0x006F2E05, 0x006F2E2D, 0x006F2E7D, 0x006F3B45, 
						  0x006F3B6D, 0x006F4FD5, 0x006F4FE0, 0x006F4FEB, 0x006F4FCA, 0x006F632C, 0x006F7626, 0x006F773C, 0x006F7AB6, 0x006FBB4C, 
						  0x006FBFBC, 0x006FC1FF, 0x006FC3B5, 0x006FC3E5, 0x006FC40D, 0x006FC45D, 0x006FCD95, 0x006FCDBD, 0x006FE9DD, 0x006FEF00, 
						  0x006FF175, 0x006FF9ED, 0x007002E5, 0x0070030D, 0x00700630, 0x0070071D, 0x0070078B, 0x007008CF, 0x00700D6A, 0x00700DAF, 
						  0x00700E16, 0x00701128, 0x00700A81, 0x0070151D, 0x00701525, 0x0070152D, 0x00701535, 0x0070508A, 0x007050AF, 0x00705889, 
						  0x007064AC, 0x00707B28, 0x007079E1, 0x007079E9, 0x00707C71, 0x00707C69, 0x00707E15, 0x00707E20, 0x00707E0A, 0x00707F5A, 
						  0x0070A474, 0x0070A97D, 0x0070A98F, 0x0070A9A1, 0x0070ADAD, 0x0070ADB8, 0x0070AC5B, 0x0070AC66, 0x0070AC71, 0x0070AF0E, 
						  0x0070B2BD, 0x0070B515, 0x0070B53D, 0x0070F0DA, 0x0070FECA, 0x00710CFF, 0x00710EA5, 0x00710ED5, 0x00710F05, 0x00710F2D, 
						  0x00710F7D, 0x00710FCD, 0x007143E5, 0x00714415, 0x0071443D, 0x0071448D, 0x00715E5F, 0x00715F35, 0x00715F5D, 0x007167DE, 
						  0x00717968, 0x007185EB, 0x0071864E, 0x0071883F, 0x00718B85, 0x00718BB5, 0x00718BDF, 0x00718C4D, 0x00718C9D, 0x0071BC0D, 
						  0x0071BCD5, 0x0071BCFD, 0x0071EF5D, 0x0071EF71, 0x0071EFCC, 0x0071EE44, 0x0071EE4C, 0x0071F428, 0x0071F7FC, 0x0071F843, 
						  0x00720080, 0x007200DC, 0x00720130, 0x0071FF96, 0x0071FFDE, 0x0072000C, 0x00721053, 0x0072105B, 0x0072193F, 0x00721B5B, 
						  0x00721BBF, 0x007231AF, 0x00723F0F, 0x00724D48, 0x00725059, 0x007254FA, 0x007253A3, 0x00725866, 0x00725898, 0x007258AD, 
						  0x0072590F, 0x0072612D, 0x00727760, 0x0072774A, 0x00727790, 0x0072777A, 0x00727817, 0x007278B6, 0x007278D3, 0x007278E2, 
						  0x007279CA, 0x00727A36, 0x00727AB6, 0x00727ABE, 0x00727AC7, 0x00727AD8, 0x00727AF8, 0x00727B18, 0x00727B39, 0x00727BD3, 
						  0x00727C04, 0x007282C4, 0x007282CC, 0x0072844F, 0x007284C8, 0x007284F9, 0x0072B97E, 0x0072B9F4, 0x0072BB98, 0x0072BBA0, 
						  0x0072BF75, 0x0072BF8D, 0x0072BF98, 0x0072BFA3, 0x0072BFAE, 0x0072BF6A, 0x0072BFE5, 0x0072BFF0, 0x0072BFDA, 0x0072C67D, 
						  0x0072CD54, 0x0072F7B4, 0x0072FB2E, 0x0072FDB7, 0x0072FE95, 0x0072FEE6, 0x0072FED7, 0x00730357, 0x00733335, 0x0073B4B3, 
						  0x0073BAD2, 0x0073C1E6, 0x0073CDD8, 0x0073CDE3, 0x0073D20D, 0x0073DB99, 0x0073DAA9, 0x0073DF15, 0x0073E834, 0x0073FCD6, 
						  0x00740596, 0x0074063F, 0x007406DD, 0x0074088C, 0x00740899, 0x007408AD, 0x007408C1, 0x00740951, 0x007419A2, 0x007421BE, 
						  0x00742345, 0x00742409, 0x0074252F, 0x00742609, 0x00742691, 0x00742851, 0x00742C42, 0x00742CB6, 0x00742D72, 0x00742DA1, 
						  0x00744954, 0x00744B49, 0x00744C19, 0x00744C21, 0x00744C29, 0x00744D17, 0x00746787, 0x007467A0, 0x0074698C, 0x0074699D, 
						  0x007469B8, 0x00746BB7, 0x00746BC4, 0x00746BDF, 0x00748115, 0x00748E04, 0x0074A3D4, 0x0074BD80, 0x0074BDB9, 0x0074CE98, 
						  0x0074CEA0, 0x0074DC4A, 0x0074F54A, 0x0074F555, 0x0074F82A, 0x0074FF15, 0x0074FFAA, 0x00750023, 0x00750632, 0x00751BE7, 
						  0x00751BF2, 0x00751C33, 0x0075248F, 0x007523E6, 0x007523EE, 0x007551EB, 0x0075549F, 0x00756495, 0x007564BD, 0x0075667D, 
						  0x007566A6, 0x007566CF, 0x007566F8, 0x007569F9, 0x00757017, 0x007570C6, 0x00757136, 0x007571B7, 0x0075721D, 0x00757299, 
						  0x0075730A, 0x0075735B, 0x00757C85, 0x00757DF4, 0x00757E52, 0x00757E96, 0x007581FB, 0x0075841A, 0x00758503, 0x00758513, 
						  0x00758548, 0x007585E2, 0x00758730, 0x007586AD, 0x007586BA, 0x007586F3, 0x00758776, 0x00758B89, 0x00758CB7, 0x0075913F, 
						  0x00759150, 0x00759369, 0x00759513, 0x0075988D, 0x00759C65, 0x00759C75, 0x0075A609, 0x0075A616, 0x0075A8EF, 0x0075B084, 
						  0x0075B091, 0x0075D045, 0x0075D06D, 0x0075EC8F, 0x0075F2D5, 0x00761BBE, 0x00763415, 0x0076345D, 0x00765E35, 0x00765C6C, 
						  0x0076620D, 0x007665A3, 0x0076681E, 0x007673AD, 0x00767DA7, 0x00768745, 0x00768750, 0x00768AB8, 0x00768AC3, 0x00769C22, 
						  0x0076B520, 0x0076B5AA, 0x0076B5BA, 0x0076B6DA, 0x0076C17C, 0x0076D1F5, 0x0076D225, 0x0076D24D, 0x0076D29D, 0x0076DD7D, 
						  0x0076DDB4, 0x0076E595, 0x0076F24E, 0x0076FF8D, 0x0076FFE5, 0x0077001D, 0x00771A8C, 0x00771BFC, 0x00772735, 0x0077275D, 
						  0x007735AC, 0x0077571A, 0x0077579F, 0x00775B65, 0x00775B95, 0x00775BC5, 0x00775BED, 0x00775C3D, 0x00775C8D, 0x00778ABD, 
						  0x00778D25, 0x00778D55, 0x00778D7D, 0x00778DCD, 0x0077AEF7, 0x0077AC0C, 0x0077DB1D, 0x0077DC30, 0x00780D8F, 0x00781267, 
						  0x007874B2, 0x00788C41, 0x00788C49, 0x0078CE3E, 0x0078CFC9, 0x00790FBD, 0x0079109D, 0x007911BD, 0x007915CD, 0x0079187F, 
						  0x00791A1F, 0x0079218D, 0x007923EF, 0x0079490D, 0x0079499F, 0x00794B4D, 0x00794BDD, 0x00794C9F, 0x00794CFF, 0x00794D6F, 
						  0x00794E25, 0x00794E4D, 0x00798D97, 0x0079C096, 0x0079F14B, 0x007A2E53, 0x007A2EDD, 0x007A351D, 0x007A5991, 0x007A6927, 
						  0x007A6938, 0x007A6E56, 0x007A7361, 0x007A7D18, 0x007A9F3E, 0x007AC33E, 0x007AC66A, 0x007ACE6D, 0x007ACF2E, 0x007ACFE4, 
						  0x007AD0C9, 0x007AD79C, 0x007B03F8, 0x007B0456, 0x007B02EA, 0x007B032C, 0x007B0514, 0x007B0718, 0x007B0528, 0x007B055E, 
						  0x007B05EA, 0x007B2538, 0x007B142A, 0x007B2066, 0x007B2BA1, 0x007B2BC2, 0x007B41B2, 0x007B4A8C, 0x007B4AA0, 0x007B4AC1, 
						  0x007B4C56, 0x007B524F, 0x007B525A, 0x007B5265, 0x007B5321, 0x007B5359, 0x007B56E9, 0x007B5DAF, 0x007B61AA, 0x007B66C2, 
						  0x007B69BB, 0x007B6CF5, 0x007B6653, 0x007B665B, 0x007B6D83, 0x007B6D92, 0x007B7BB4, 0x007B7B59, 0x007B81E3, 0x007BC04A, 
						  0x007BC50B, 0x007BC712, 0x007BC790, 0x007BC835, 0x007BC8BE, 0x007BC946, 0x007BCA00, 0x007BCA89, 0x007BCB11, 0x007BCC50, 
						  0x007BCD2E, 0x007BCD8A, 0x007BC656, 0x007BE402, 0x007BF059, 0x007BF096, 0x007C015D, 0x007C096A, 0x007C0982, 0x007C12E6, 
						  0x007C1BA9, 0x007C1FCD, 0x007C2030, 0x007C2042, 0x007C21FC, 0x007C2C4A, 0x007C2C55, 0x007C2DEA, 0x007C2F6D, 0x007C31DA, 
						  0x007C3226, 0x007C3476, 0x007C34C6, 0x007C6EA0, 0x007C8966, 0x007C8A43, 0x007C9231, 0x007CB3AA, 0x007CBA54, 0x007CC256, 
						  0x007CCA0F, 0x007CF414, 0x007CF421, 0x007CF65A, 0x007CF662, 0x007CF917, 0x007CF91F, 0x007CF97A, 0x007D1BC8, 0x007D1BD5, 
						  0x007D501F, 0x007D55A3, 0x007D55E6, 0x007D6285, 0x007D7B24, 0x007D837A, 0x007D851D, 0x007D8910, 0x007DC985, 0x007DC990, 
						  0x007DC99B, 0x007DC9A6, 0x007DC9B1, 0x007DC97A, 0x007DCA71, 0x007DCA89, 0x007DD75E, 0x007DD7CB, 0x007DD6EE, 0x007E039B, 
						  0x007E1461, 0x007E148C, 0x007E2404, 0x007E2A20, 0x007E2A29, 0x007E2B70, 0x007E2FA4, 0x007E3256, 0x007E3ABD, 0x007E3C97, 
						  0x007E3CB0, 0x007E4166, 0x007E41A1, 0x007E41F5, 0x007E4201, 0x007E4E96, 0x007E529F, 0x007E5685, 0x007E56DD, 0x007E572D, 
						  0x007EA62D, 0x007EA8C7, 0x007EF168, 0x007EF96D, 0x007F2A1F, 0x007F2C68, 0x007F2C73, 0x007F2D05, 0x007F2E53, 0x007F2E6E, 
						  0x007F3098, 0x007F30DA, 0x007F32E0, 0x007F3405, 0x007F3431, 0x007F585E, 0x007F57F9, 0x007F6177, 0x007F63FF, 0x007F9BF6, 
						  0x007FBB47, 0x007FCFA7, 0x007FCFB8, 0x007FCFCE, 0x007FD573, 0x007FE7E6, 0x007FE944, 0x0080020F, 0x0080271C, 0x0080296A, 
						  0x008029F2, 0x00802A7F, 0x00802AB1, 0x00802AE3, 0x00802B25, 0x00802B57, 0x00802B89, 0x00802BBC, 0x00802BEF, 0x00802C22, 
						  0x00802C55, 0x00802C88, 0x00802CBB, 0x00802CDB, 0x00802D0E, 0x00802D5D, 0x00802DA9, 0x00802DD9, 0x00802E11, 0x00802E8C, 
						  0x00802F40, 0x0080323D, 0x0080796E, 0x008098F2, 0x008099C1, 0x00809C10, 0x00809C1D, 0x00809B77, 0x00809B84, 0x00809D8E, 
						  0x00809E3B, 0x00809E48, 0x00809D7D, 0x0080B12E, 0x0080B266, 0x0080B647, 0x0080B654, 0x0080B717, 0x0080B724, 0x0080CA93, 
						  0x0080D75A, 0x0080E41C, 0x0080E439, 0x0080ED79, 0x0080EE44, 0x00810533, 0x00810EA5, 0x00811C5E, 0x008122DA, 0x008131C7, 
						  0x008131F4, 0x00813256, 0x008155E1, 0x0081969D, 0x008196C4, 0x00821FE7, 0x00823266, 0x00823914, 0x00823D0C, 0x00824344, 
						  0x00824D16, 0x00824E1A, 0x00825055, 0x00827216, 0x0082736A, 0x0082889C, 0x008298A7, 0x0082B0F4, 0x0082B19E, 0x0082B279, 
						  0x0082D2D6, 0x0082DDC4, 0x0082DE04, 0x0082E583, 0x0082FA1A, 0x0082FA25, 0x0083156C, 0x0083225F, 0x00832B3C, 0x00832B49, 
						  0x00832D51, 0x00832D62, 0x00834215, 0x008342E1, 0x00834184, 0x00834792, 0x0083483B, 0x00834917, 0x00834AD3, 0x00834BD1, 
						  0x00835462, 0x008355DD, 0x008357AA, 0x008358B4, 0x00836050, 0x00836061, 0x00837E34, 0x00837E3C, 0x00837F8C, 0x0083807C, 
						  0x008381B7, 0x008382C1, 0x00838656, 0x00838A23, 0x0083EBF9, 0x008409E2, 0x008409F7, 0x008437EB, 0x008469FA, 0x008467B1, 
						  0x00846AF9, 0x00846D49, 0x00846E7A, 0x00846C3B, 0x008471BB, 0x00847021, 0x008488C9, 0x008488D1, 0x0084892E, 0x008494E9, 
						  0x00849517, 0x00849C73, 0x00849D0E, 0x00849F65, 0x0084A12B, 0x0084A8F8, 0x0084AB61, 0x0084C26F, 0x0084C2CE, 0x0084C535, 
						  0x0084C4BF, 0x0084C838, 0x0084D22F, 0x0084DAFC, 0x0084ED73, 0x0084FD63, 0x00850316, 0x0085041A, 0x0085023D, 0x00850D34, 
						  0x00850D41, 0x00850FBB, 0x00850FC3, 0x00851141, 0x00851221, 0x00851C5B, 0x00851C6C, 0x008521F9, 0x00852996, 0x00853579, 
						  0x00853A7E, 0x00853D7E, 0x00853D86, 0x00853ECA, 0x00853FAA, 0x008540F6, 0x00854200, 0x0085622A, 0x00859568, 0x0085A8FA, 
						  0x0085A9DD, 0x0085B527, 0x0085B6E7, 0x0085DC7F, 0x0085EB1D, 0x0085E40C, 0x0085F5D2, 0x0085F8F9, 0x0085F7FD, 0x00860185, 
						  0x00860E2E, 0x00860F51, 0x00861321, 0x008614A7, 0x00863199, 0x0086452C, 0x00864762, 0x0086476F, 0x0086584C, 0x0086600A, 
						  0x008663C6, 0x008674FC, 0x008687F2, 0x0086B434, 0x0086B486, 0x0086B491, 0x0086B7E0, 0x0086B7F3, 0x0086B7FE, 0x0086B876, 
						  0x0086BC7E, 0x0086BC89, 0x0086BCC8, 0x0086BD64, 0x0086BEC6, 0x0086C45F, 0x0086C46A, 0x0086C475, 0x0086C9F5, 0x0086CA79, 
						  0x0086CBD5, 0x0086C1A4, 0x0086C1AC, 0x0086CDB6, 0x0086CE06, 0x0086D2E8, 0x0086D63A, 0x0086D11C, 0x0086D124, 0x0086D146, 
						  0x0086DDB4, 0x0086DE5A, 0x0086E637, 0x0086FB34, 0x0086FC2C, 0x0086FC9D, 0x0086FD49, 0x0086FE66, 0x00870735, 0x00871B87, 
						  0x00871BAC, 0x00871A22, 0x00871A51, 0x00871AC2, 0x008737A3, 0x008737B4, 0x00873C69, 0x00873C8F, 0x00873C97, 0x0087556C, 
						  0x00875D96, 0x008768F5, 0x00877D7B, 0x00877DE5, 0x00877E15, 0x00877E45, 0x00877E75, 0x00877EA5, 0x00877ECF, 0x00877F6D, 
						  0x00877FBD, 0x0087800D, 0x0087805D, 0x008780AD, 0x0087B66A, 0x0087BD35, 0x0087BD40, 0x0087BD4B, 0x0087BD2A, 0x0087C3A4, 
						  0x0087C3AC, 0x0087C3B4, 0x0087C3BC, 0x0087C72F, 0x0087C7D8, 0x0087C7E3, 0x0087C8A4, 0x0087C8AF, 0x0087CC25, 0x0087D429, 
						  0x0087D598, 0x0087D682, 0x0087EB7A, 0x0087F27F, 0x0087F2FB, 0x0087F75F, 0x0087F8BC, 0x0088141B, 0x00881428, 0x00881DEC, 
						  0x0088215C, 0x008825D7, 0x008825F5, 0x00882983, 0x008827B1, 0x00882D72, 0x00882DA8, 0x00882DBB, 0x008827C8, 0x00883519, 
						  0x00884353, 0x00884B63, 0x00884E16, 0x00884E7B, 0x00884F2A, 0x00884F3B, 0x0088516C, 0x0088517F, 0x008851FC, 0x0088520D, 
						  0x00885394, 0x00885420, 0x00885713, 0x00885724, 0x00886939, 0x00886B3A, 0x00886D3F, 0x00886D4C, 0x0088820F, 0x00888A80, 
						  0x00888AF6, 0x0088985B, 0x00889973, 0x00889A9F, 0x0088A395, 0x0088A4BD, 0x0088FA26, 0x008905DA, 0x008906CD, 0x00890F1F, 
						  0x0089176F, 0x00891EF5, 0x00891EEA, 0x00893D45, 0x00893D50, 0x00893D5B, 0x00893D3A, 0x00893FC3, 0x00893F35, 0x00893F3D, 
						  0x00893FAF, 0x00895E5A, 0x00895FAD, 0x008961EA, 0x008962DD, 0x0089664A, 0x0089673D, 0x0089D251, 0x0089CBBC, 0x0089D37C, 
						  0x0089DD13, 0x0089E8B2, 0x0089E8D3, 0x0089FEA3, 0x008A0417, 0x008A0454, 0x008A0DB8, 0x008A0DBF, 0x008A0F85, 0x008A10F0, 
						  0x008A1479, 0x008A1366, 0x008A1C5A, 0x008A21B9, 0x008A358A, 0x008A361A, 0x008A372D, 0x008A82A9, 0x008A851F, 0x008A88EC, 
						  0x008A8A0A, 0x008A8CDF, 0x008A8DE5, 0x008A8E0D, 0x008A9F4E, 0x008A9F5F, 0x008AA06C, 0x008AACEF, 0x008AADB1, 0x008AAED1, 
						  0x008B3B4B, 0x008B4F8A, 0x008B507D, 0x008B5BD5, 0x008B5BFD, 0x008B5CEB, 0x008B5D4F, 0x008B9F80, 0x008C043A, 0x008C04CD, 
						  0x008C11DD, 0x008C1C01, 0x008C30BF, 0x008C312F, 0x008C3205, 0x008C322D, 0x008C385A, 0x008C38FF, 0x008C39FC, 0x008C3AA4, 
						  0x008C3B2F, 0x008C3C65, 0x008C3C5A, 0x008C3F1D, 0x008C3F71, 0x008C436D, 0x008C49EF, 0x008C542D, 0x008C5466, 0x008C5483, 
						  0x008C54B3, 0x008C6B6A, 0x008C7091, 0x008C762C, 0x008C79EB, 0x008C7A29, 0x008C7F20, 0x008C858B, 0x008C8593, 0x008C8562, 
						  0x008C8773, 0x008C8857, 0x008C8BC1, 0x008C93CD, 0x008C93D5, 0x008C93EF, 0x008C98A6, 0x008C9D64, 0x008CA548, 0x008CA556, 
						  0x008CA6FD, 0x008CA70B, 0x008CA9FE, 0x008CB694, 0x008CB98C, 0x008CC0BE, 0x008CC0C6, 0x008CC0E1, 0x008CC6F8, 0x008CC727, 
						  0x008CCCED, 0x008CCF5E, 0x008CCF69, 0x008CCF74, 0x008CD5AA, 0x008CDDD7, 0x008CDDDF, 0x008CE11F, 0x008CE799, 0x008CE8A9, 
						  0x008CE9B7, 0x008CEB17, 0x008CF310, 0x008CFA0C, 0x008CFA3B, 0x008CFF3A, 0x008D01B0, 0x008D082A, 0x008D04C5, 0x008D04D0, 
						  0x008D09BD, 0x008D0A10, 0x008D0F05, 0x008D0E8E, 0x008D1608, 0x008D1681, 0x008D1913, 0x008D2A93, 0x008D3E85, 0x008D3E7A, 
						  0x008D3EE5, 0x008D3EDA, 0x008D592D, 0x008D596B, 0x008D59A3, 0x008D59AE, 0x008D5A6E, 0x008D5C22, 0x008D6DD7, 0x008D6FAA, 
						  0x008D7229, 0x008D7391, 0x008D740D, 0x008D7558, 0x008D7A63, 0x008D787A, 0x008D81C0, 0x008D81CB, 0x008D81EA, 0x008D81F5, 
						  0x008D847A, 0x008D848C, 0x008D849E, 0x008D84D0, 0x008D7C55, 0x008D8561, 0x008D862A, 0x008D8635, 0x008D8654, 0x008D865F, 
						  0x008D7C87, 0x008D8D96, 0x008D961B, 0x008D964D, 0x008DAB5E, 0x008DACA4, 0x008DBA4E, 0x008DCE69, 0x008DD5AD, 0x008DDA56, 
						  0x008DDAD4, 0x008DDACC, 0x008DDBE0, 0x008DDDA7, 0x008DDCA9, 0x008DE2D9, 0x008DE2F3, 0x008DE321, 0x008DE625, 0x008DF1BB, 
						  0x008DF1E3, 0x008DF209, 0x008DEFEF, 0x008DEFFA, 0x008DF019, 0x008DF9BB, 0x008DFCF0, 0x008DFCFB, 0x008DFD06, 0x008DFD11, 
						  0x008DFD1C, 0x008DF825, 0x008DF82D, 0x008DFF6E, 0x008E0753, 0x008E07B1, 0x008E07BC, 0x008E0835, 0x008E1269, 0x008E1388, 
						  0x008E17A9, 0x008E17C1, 0x008E1DC2, 0x008E1F6A, 0x008E27E7, 0x008E2DE9, 0x008E3337, 0x008E360B, 0x008E361F, 0x008E3846, 
						  0x008E3B0D, 0x008E4D4D, 0x008E5052, 0x008E5038, 0x008E5EFB, 0x008E7B9F, 0x008E7BF7, 0x008E7FF0, 0x008E7DBC, 0x008E7DF6, 
						  0x008E881D, 0x008E8877, 0x008E9C4B, 0x008EA7ED, 0x008EAAC7, 0x008EB03C, 0x008EB8FE, 0x008EBA8A, 0x008EBBCD, 0x008EBF4E, 
						  0x008EBF59, 0x008EBF64, 0x008EBF6F, 0x008EBF7A, 0x008EBFA4, 0x008EC4AD, 0x008EC8E2, 0x008EC941, 0x008EC9C9, 0x008ECA55, 
						  0x008ECA4A, 0x008ECAF4, 0x008ECB27, 0x008ED1F7, 0x008ED209, 0x008EDEDA, 0x008EE065, 0x008EE0CD, 0x008EE125, 0x008EE155, 
						  0x008EE18D, 0x008EE1DD, 0x008F0671, 0x008F11CA, 0x008F1275, 0x008F129D, 0x008F25E5, 0x008F260D, 0x008F2B77, 0x008F2B82, 
						  0x008F2C90, 0x008F2F07, 0x008F2F12, 0x008F3747, 0x008F3C4A, 0x008F42A2, 0x008F42AA, 0x008F4845, 0x008F4943, 0x008F51F9, 
						  0x008F54B4, 0x008F54BF, 0x008F54CA, 0x008F5515, 0x008F5520, 0x008F54EA, 0x008F5DE1, 0x008F823D, 0x008F82AD, 0x008F8AEF, 
						  0x008F97C6, 0x008F97EB, 0x008F9818, 0x008F9874, 0x008FA3B9, 0x008FA3D4, 0x008FA449, 0x008FA65E, 0x008FA6DB, 0x008FF6FC, 
						  0x008FF709, 0x008FF738, 0x00901CE8, 0x00901E7A, 0x00901F6B, 0x0090205D, 0x00902DF5, 0x00902E25, 0x00902E4D, 0x00902E9D, 
						  0x0090368B, 0x009036EF, 0x0090398A, 0x00903A2A, 0x0090AA5C, 0x0090AC55, 0x0090AC7D, 0x0091BBE5, 0x0091BC0D, 0x0091F19D, 
						  0x0091F2B0, 0x0091EFC6, 0x0091F309, 0x0091F315, 0x0091F3E1, 0x0091FA9B, 0x009214CD, 0x009214E6, 0x00921A15, 0x00921A3D, 
						  0x009223E8, 0x009223DD, 0x00923569, 0x00923574, 0x009236CA, 0x00924C6E, 0x0092506F, 0x00926CFB, 0x00926D06, 0x00926D27, 
						  0x009270A6, 0x00927143, 0x00927C1D, 0x00928345, 0x0092839D, 0x00928E83, 0x00928E8E, 0x00929677, 0x00929BC4, 0x00929D59, 
						  0x0092A999, 0x0092AA84, 0x0092AC4D, 0x0092B1BD, 0x0092B3CC, 0x0092B2AF, 0x0092B460, 0x0092B46D, 0x0092B7C6, 0x0092B83F, 
						  0x0092B989, 0x0092BCB8, 0x0092BFDC, 0x0092C23C, 0x0092C244, 0x0092C2BC, 0x0092C2C4, 0x0092C463, 0x0092C503, 0x0092C5E6, 
						  0x0092C68E, 0x0092D6FB, 0x0092D736, 0x0092D6B9, 0x0092D799, 0x0092D953, 0x0092D981, 0x0092D78C, 0x0092D9C7, 0x0092D9D4, 
						  0x0092DD7C, 0x0092DE07, 0x0092DE99, 0x0092D9BC, 0x0092E001, 0x0092E032, 0x0092E079, 0x0092DF0F, 0x0092E104, 0x0092E11D, 
						  0x0092E32A, 0x0092E339, 0x0092E200, 0x0092E20F, 0x0092E2A8, 0x0092E40A, 0x0092E699, 0x0092E6A1, 0x0092E919, 0x0092E934, 
						  0x0092E9F8, 0x0092EA3F, 0x0092F1D3, 0x0092F20A, 0x0092F2B5, 0x0092F343, 0x0092F37A, 0x0092F443, 0x0092F47A, 0x00930DDD, 
						  0x00930DE5, 0x0093133D, 0x00931345, 0x0093170D, 0x00931715, 0x00933835, 0x0093385D, 0x0093736A, 0x009376F7, 0x00937713, 
						  0x00937726, 0x009378D7, 0x00937AE5, 0x00937AFF, 0x00937B55, 0x00937B95, 0x00937BD0, 0x00937BE8, 0x00937C20, 0x00937C38, 
						  0x0093809B, 0x009380D7, 0x009381BB, 0x0093AEE5, 0x0093AEFF, 0x0093AF35, 0x0093AF75, 0x0093AFB0, 0x0093AFC8, 0x0093B007, 
						  0x0093B01F, 0x0093B078, 0x0093B0A6, 0x0093B115, 0x0093B150, 0x0093B17F, 0x0093B1B0, 0x0093B1F5, 0x0093B20F, 0x0093B245, 
						  0x0093B285, 0x0093B2C0, 0x0093B2D8, 0x0093B310, 0x0093B328, 0x0093B365, 0x0093B37F, 0x0093B3B5, 0x0093B3F5, 0x0093B430, 
						  0x0093B448, 0x0093B480, 0x0093B498, 0x0093B4D5, 0x0093B4EF, 0x0093B525, 0x0093B565, 0x0093B5A5, 0x0093B5E0, 0x0093B5F8, 
						  0x0093B645, 0x0093B65D, 0x0093B690, 0x0093B6A8, 0x0093B6E7, 0x0093B6FF, 0x0093B735, 0x0093B770, 0x0093B788, 0x0093B7C7, 
						  0x0093B7DF, 0x0093B815, 0x0093B82F, 0x0093B865, 0x0093B8A5, 0x0093B8E0, 0x0093B8F8, 0x0093B937, 0x0093B94F, 0x0093B9C5, 
						  0x0093BA05, 0x0093BA40, 0x0093BA58, 0x0093BA97, 0x0093BAAF, 0x0093BE79, 0x0093DF10, 0x0093DF28, 0x0093DF6E, 0x0093DF86, 
						  0x0093DFC5, 0x0093DFDF, 0x0093E015, 0x0093E055, 0x0093E090, 0x0093E0A8, 0x0093E0EE, 0x0093E106, 0x0093E148, 0x0093E176, 
						  0x0093E1B5, 0x0093E1F0, 0x0093E21F, 0x0093E257, 0x0093E295, 0x0093E2AF, 0x0093E2E5, 0x0093E325, 0x0093E365, 0x0093E3A0, 
						  0x0093E3B8, 0x0093E3F0, 0x0093E408, 0x0093E535, 0x0093E570, 0x0093E588, 0x0093E705, 0x0093E740, 0x0093E758, 0x0093E790, 
						  0x0093E7A8, 0x0093E7E5, 0x0093E820, 0x0093E838, 0x0093E870, 0x0093E888, 0x0093E910, 0x0093E928, 0x0093E960, 0x0093E978, 
						  0x009401C5, 0x00940200, 0x0094022F, 0x00940260, 0x009402E5, 0x009402FF, 0x00940335, 0x00940375, 0x009403B0, 0x009403C8, 
						  0x00940400, 0x00940418, 0x00941878, 0x009418A6, 0x009418E0, 0x0094190F, 0x0094194E, 0x00941995, 0x009419D5, 0x00941A10, 
						  0x00941A28, 0x00941A60, 0x00941A78, 0x00941AB5, 0x00941ACF, 0x00941B05, 0x00941B45, 0x00941B80, 0x00941B98, 0x00941BD0, 
						  0x00941BE8, 0x00941C95, 0x00941CAF, 0x00941CE5, 0x00941D20, 0x00941D38, 0x00941DB5, 0x00941DCF, 0x00941E05, 0x00941E45, 
						  0x00941E80, 0x00941E98, 0x00941ED0, 0x00941EE8, 0x00942109, 0x0094347D, 0x00943851, 0x009440D7, 0x009441BF, 0x00944651, 
						  0x009445BA, 0x00944D27, 0x00946048, 0x00946076, 0x00946115, 0x00946150, 0x0094617F, 0x009461B0, 0x009461F0, 0x00946208, 
						  0x00946240, 0x00946258, 0x00946335, 0x00946370, 0x00946388, 0x009463C0, 0x009463D8, 0x00946455, 0x0094646F, 0x009464A5, 
						  0x009464E5, 0x00946520, 0x00946538, 0x00946575, 0x009465B0, 0x009465C8, 0x00946600, 0x00946618, 0x00946655, 0x0094666F, 
						  0x009466A0, 0x009466B8, 0x009466F0, 0x00946708, 0x009467E5, 0x009467FF, 0x00946835, 0x00946870, 0x00946888, 0x009468C0, 
						  0x009468D8, 0x00946915, 0x0094692F, 0x00946965, 0x009469A5, 0x009469E0, 0x009469F8, 0x00946A30, 0x00946A48, 0x00946B25, 
						  0x00946B60, 0x00946B78, 0x00946BB5, 0x00946BF0, 0x00946C08, 0x00946FA9, 0x009480CE, 0x0094841F, 0x00948CDE, 0x00948FBF, 
						  0x0094AB75, 0x0094AB9D, 0x0094B1E8, 0x0094B216, 0x0094B250, 0x0094B290, 0x0094B2A8, 0x0094B2E0, 0x0094B2F8, 0x0094B335, 
						  0x0094B34F, 0x0094B385, 0x0094B3C0, 0x0094B3D8, 0x0094B410, 0x0094B428, 0x0094B460, 0x0094B478, 0x0094B4BE, 0x0094B4D6, 
						  0x0094B5F9, 0x0094B6FB, 0x0094C05B, 0x0094C12F, 0x0094CD65, 0x0094CFEE, 0x0094D2FF, 0x0094EBBB, 0x0094E988, 0x0094F033, 
						  0x0094F161, 0x0094FB0E, 0x0094FBB0, 0x00950F9F, 0x00950FC5, 0x0095129A, 0x00951455, 0x0095147D, 0x00952FCB, 0x0095302F, 
						  0x009530A8, 0x009530D6, 0x00953110, 0x0095313F, 0x00953170, 0x009531B5, 0x009531CF, 0x00953205, 0x00953245, 0x00953280, 
						  0x00953298, 0x009532D0, 0x009532E8, 0x00953365, 0x009533A0, 0x009533B8, 0x009533F0, 0x00953408, 0x00953445, 0x0095345F, 
						  0x00953495, 0x009534D5, 0x00953510, 0x00953528, 0x00953560, 0x00953578, 0x009535B0, 0x009535C8, 0x00953600, 0x00953618, 
						  0x00953655, 0x0095366F, 0x009536A5, 0x009536E5, 0x00953720, 0x00953738, 0x00953777, 0x0095378F, 0x00953E49, 0x0095476E, 
						  0x00954A7F, 0x0095526E, 0x0095554F, 0x00955BCE, 0x00955BD9, 0x00955BE4, 0x00955BEF, 0x00957AF8, 0x00958D88, 0x00958DB6, 
						  0x00958DF0, 0x00958E70, 0x00958E88, 0x00958EC0, 0x00958ED8, 0x00958F15, 0x00958F2F, 0x00958F65, 0x00958FA5, 0x00958FE0, 
						  0x00958FF8, 0x00959030, 0x00959048, 0x00959085, 0x0095909F, 0x009590D5, 0x00959110, 0x00959128, 0x00959160, 0x00959178, 
						  0x009591B7, 0x009591CF, 0x00959255, 0x00959290, 0x009592A8, 0x009592E0, 0x009592F8, 0x00959335, 0x00959375, 0x009593B0, 
						  0x009593C8, 0x0095940E, 0x00959426, 0x00959465, 0x0095947F, 0x009594B5, 0x009594F5, 0x00959530, 0x00959548, 0x00959580, 
						  0x00959598, 0x00959688, 0x009596B6, 0x009596F0, 0x0095971F, 0x00959750, 0x00959795, 0x009597AF, 0x009597E5, 0x00959820, 
						  0x00959838, 0x00959877, 0x0095988F, 0x009598C0, 0x009598D8, 0x009599C9, 0x0095A1AB, 0x0095B77E, 0x0095BADF, 0x0095C20E, 
						  0x0095C4EF, 0x0095DBE6, 0x0095DF12, 0x0095DF1A, 0x0095E7B6, 0x0095F961, 0x00961175, 0x009611B0, 0x009611C8, 0x00961245, 
						  0x0096125F, 0x00961295, 0x009612D5, 0x00961315, 0x00961350, 0x00961368, 0x009613A7, 0x009613BF, 0x00961490, 0x009614A8, 
						  0x00961565, 0x009615A5, 0x009615E0, 0x009615F8, 0x00961635, 0x0096164F, 0x00961685, 0x009616C5, 0x00961700, 0x00961718, 
						  0x00961750, 0x00961768, 0x009617A5, 0x009617BF, 0x009617F5, 0x00961835, 0x00961870, 0x00961888, 0x009618C0, 0x009618D8, 
						  0x00961915, 0x0096192F, 0x00961965, 0x009619A0, 0x009619B8, 0x009619F0, 0x00961A08, 0x00961A40, 0x00961A58, 0x00961A95, 
						  0x00961AAF, 0x00961AE5, 0x00961B25, 0x00961B60, 0x00961B78, 0x00961BB0, 0x00961BC8, 0x00961C05, 0x00961C1F, 0x00961C55, 
						  0x00961C95, 0x00961CD0, 0x00961CE8, 0x00961D20, 0x00961D38, 0x00961EB7, 0x00961ECF, 0x00961F45, 0x00961F5F, 0x00961F95, 
						  0x00961FD0, 0x00961FE8, 0x00962027, 0x0096203F, 0x00962075, 0x0096208F, 0x009620C5, 0x00962100, 0x00962118, 0x00962157, 
						  0x0096216F, 0x009621A0, 0x009621B8, 0x00964475, 0x009644B0, 0x009644C8, 0x009645A5, 0x009645BF, 0x009645F5, 0x00964635, 
						  0x00964670, 0x00964688, 0x00966568, 0x00966596, 0x009665D5, 0x00966610, 0x0096663F, 0x00966677, 0x009667F5, 0x00966830, 
						  0x00966848, 0x009668C5, 0x009668DF, 0x00966915, 0x00966955, 0x00966997, 0x009669AF, 0x009669E0, 0x009669F8, 0x00966A35, 
						  0x00966A70, 0x00966A88, 0x00966AC7, 0x00966ADF, 0x00966B10, 0x00966B28, 0x00966F78, 0x00966F6D, 0x009675CB, 0x00967813, 
						  0x00968D48, 0x00968D76, 0x00968DB5, 0x00968DF0, 0x00968E1F, 0x00968E5E, 0x00968EA5, 0x00968EE0, 0x00968EF8, 0x00968F30, 
						  0x00968F48, 0x00969A21, 0x00969A38, 0x00969A3F, 0x00969A69, 0x00969A70, 0x00969A8B, 0x00969FB4, 0x0096B9FE, 0x0096BD2F, 
						  0x0096C47E, 0x0096C7AF, 0x0096CED5, 0x0096CF10, 0x0096CF28, 0x0096D0A5, 0x0096D0BF, 0x0096D0F5, 0x0096D130, 0x0096D148, 
						  0x0096D780, 0x0096D798, 0x0096FCE5, 0x0096FD20, 0x0096FD4F, 0x0096FD87, 0x0096FDC5, 0x0096FDDF, 0x0096FE15, 0x0096FE55, 
						  0x0096FE90, 0x0096FEA8, 0x0096FEE0, 0x0096FEF8, 0x00970B96, 0x00970F00, 0x00970FE5, 0x00971025, 0x00971060, 0x00971078, 
						  0x009710B0, 0x009710C8, 0x00971105, 0x00971140, 0x00971158, 0x009712C9, 0x00971EC3, 0x00971F1C, 0x00972395, 0x009725C9, 
						  0x009727EA, 0x00972A38, 0x00972C07, 0x00972B6E, 0x00972E2D, 0x00972FAA, 0x00972FFD, 0x00973E98, 0x00973EC6, 0x00973F05, 
						  0x00973F40, 0x00973F6F, 0x00973FA0, 0x00973FE7, 0x00973FFF, 0x00974085, 0x0097409F, 0x009740D5, 0x00974115, 0x00974150, 
						  0x00974168, 0x009741A7, 0x009741BF, 0x009741F5, 0x00974230, 0x00974248, 0x00974287, 0x0097429F, 0x009742D0, 0x009742E8, 
						  0x00974327, 0x0097433F, 0x00974375, 0x009743B7, 0x009743CF, 0x00974400, 0x00974418, 0x00974465, 0x0097447F, 0x009744B5, 
						  0x009744F5, 0x00974530, 0x00974548, 0x00974580, 0x00974598, 0x00974709, 0x009763BB, 0x0097663E, 0x0097694F, 0x00976F90, 
						  0x009771AE, 0x009774BF, 0x00978D25, 0x00978D60, 0x00978D8F, 0x00978DC7, 0x00978E45, 0x00978E80, 0x00978E98, 0x00979B53, 
						  0x00979F38, 0x0097A6F8, 0x0097A726, 0x0097A760, 0x0097A7A5, 0x0097A7BF, 0x0097A7F5, 0x0097A835, 0x0097A870, 0x0097A888, 
						  0x0097A8C0, 0x0097A8D8, 0x0097A91E, 0x0097A936, 0x0097A975, 0x0097A98F, 0x0097A9C5, 0x0097AA05, 0x0097AA40, 0x0097AA58, 
						  0x0097AA90, 0x0097AAA8, 0x0097AAE5, 0x0097AAFF, 0x0097AB35, 0x0097AB75, 0x0097ABB0, 0x0097ABC8, 0x0097AC00, 0x0097AC18, 
						  0x0097AC89, 0x0097BE0F, 0x0097CB58, 0x0097CB86, 0x0097CBC0, 0x0097CBEF, 0x0097CC27, 0x0097CC60, 0x0097CC78, 0x0097D864, 
						  0x0097EFE8, 0x0097F211, 0x0097F2A0, 0x0097F7BA, 0x0097FDC5, 0x0097FDED, 0x00981303, 0x009813B5, 0x0098150F, 0x009811A0, 
						  0x00981919, 0x00981C0A, 0x0098221B, 0x009821DF, 0x00982350, 0x00982444, 0x009823A1, 0x009823AE, 0x009823BE, 0x00982410, 
						  0x0098250C, 0x00982516, 0x009829FE, 0x00982A65, 0x00982C63, 0x00982CD6, 0x00982D53, 0x00982D5A, 0x009828C0, 0x009828D3, 
						  0x00982DEE, 0x00982DFA, 0x00983541, 0x00983548, 0x0098362C, 0x00983633, 0x00983C0D, 0x00983C14, 0x00983C5C, 0x00983C88, 
						  0x00983CEA, 0x0098421D, 0x00984225, 0x00984474, 0x0098446C, 0x0098510D, 0x00985181, 0x00984F9E, 0x00986D55, 0x00986D4A, 
						  0x0098724F, 0x009889A9, 0x0098ED59, 0x0098ED61, 0x0098F764, 0x0098F76C, 0x0098F75C, 0x0098F894, 0x0098F88C, 0x0098FB77, 
						  0x009902A8, 0x00990014, 0x0099001C, 0x0099061D, 0x00991064, 0x009910B4, 0x0099105C, 0x009912A4, 0x0099139C, 0x009913EC, 
						  0x00991834, 0x0099183C, 0x0099182C, 0x009919E4, 0x009919DC, 0x00991A98, 0x00992494, 0x009924DC, 0x0099248C, 0x0099268D, 
						  0x009937A2, 0x009938FB, 0x00993903, 0x009939DC, 0x00994B0C, 0x0099614F, 0x00996A57, 0x00996A5F, 0x00996A67, 0x00996A6F, 
						  0x00996BAD, 0x00996C07, 0x00996D8A, 0x00996DEB, 0x00997177, 0x0099717F, 0x009973C4, 0x009973BC, 0x00997A34, 0x00997A2C, 
						  0x00998988, 0x009989B4, 0x00998BDC, 0x00998B7C, 0x00998C7C, 0x00998F3F, 0x00998F56, 0x009990A6, 0x00999144, 0x0099918C, 
						  0x0099913C, 0x00999236, 0x0099923E, 0x00999253, 0x009992E6, 0x00999437, 0x0099A562, 0x0099A90A, 0x0099AA5A, 0x0099ABC9, 
						  0x0099C276, 0x0099C285, 0x0099C2AF, 0x0099C7E7, 0x0099D5E3, 0x0099E57D, 0x0099E585, 0x0099E8E1, 0x0099E919, 0x0099E992, 
						  0x009A08BC, 0x009A08C4, 0x009A39DE, 0x009A3A3F, 0x009A3A68, 0x009A3CDB, 0x009A3CED, 0x009A3B52, 0x009A46D9, 0x009A5347, 
						  0x009A5354, 0x009A537C, 0x009A7D12, 0x009A7D53, 0x009AFC32, 0x009AFEF9, 0x009B19FA, 0x009B1C85, 0x009B1CAD, 0x009B2391, 
						  0x009B23BE, 0x009B23DC, 0x009B23EE, 0x009B2407, 0x009B2CFF, 0x009B2D2C, 0x009B2D4A, 0x009B2D5C, 0x009B2D75, 0x009B3D7B, 
						  0x009B3DDF, 0x009B5B0F, 0x009B612D, 0x009B681E, 0x009B67A4, 0x009B67E9, 0x009B6CBD, 0x009B6CE2, 0x009B6D44, 0x009B6C98, 
						  0x009B9960, 0x009B99C7, 0x009B9AAA, 0x009B9CD3, 0x009B9CEB, 0x009B9CFE, 0x009BA28C, 0x009BA299, 0x009BA2AC, 0x009BBD53, 
						  0x009BBD5E, 0x009BBD69, 0x009BBD74, 0x009BC370, 0x009BC1F4, 0x009BF23C, 0x009BF28A, 0x009C0F23, 0x009C101E, 0x009C0E8A, 
						  0x009C2BEF, 0x009C4412, 0x009C4C19, 0x009C506D, 0x009C55DB, 0x009C597F, 0x009C5FBA, 0x009C7FA7, 0x009C8CAC, 0x009C9062, 
						  0x009C90DC, 0x009C91AD, 0x009C932A, 0x009C9372, 0x009C9517, 0x009C9EE9, 0x009C9F0E, 0x009CD405, 0x009CED2D, 0x009CF844, 
						  0x009D32DD, 0x009D3749, 0x009D376F, 0x009D37AA, 0x009D37DC, 0x009D3840, 0x009D34EF, 0x009D3AA0, 0x009D3BAD, 0x009D3A1A, 
						  0x009D3A42, 0x009D3A7B, 0x009D3A8E, 0x009D3FB3, 0x009D3FE6, 0x009D3FF8, 0x009D3F2C, 0x009D3F3B, 0x009D3F51, 0x009D3F78, 
						  0x009D4052, 0x009D4865, 0x009D4895, 0x009D48C5, 0x009D48ED, 0x009D493D, 0x009D498D, 0x009D5127, 0x009D96EF, 0x009DB30C, 
						  0x009DB7E1, 0x009DB584, 0x009DC27D, 0x009DCECE, 0x009DCED9, 0x009E1655, 0x009E1660, 0x009E1760, 0x009E1818, 0x009E1509, 
						  0x009E18BA, 0x009E14DE, 0x009E62E8, 0x009E6334, 0x009E633F, 0x009E662A, 0x009E6676, 0x009E6681, 0x009E83A5, 0x009E839A, 
						  0x009EBC4F, 0x009EBD5C, 0x009EC251, 0x009EC2FF, 0x009EC307, 0x009EC5E4, 0x009ED064, 0x009ED53A, 0x009ED46D, 0x009ED478, 
						  0x009ED483, 0x009EE41A, 0x009EE4E0, 0x009EE7FE, 0x009EE806, 0x009EFDA1, 0x009F09DA, 0x009F122A, 0x009F160A, 0x009F1796, 
						  0x009F13E7, 0x009F1ABA, 0x009F218A, 0x009F2435, 0x009F242A, 0x009F2475, 0x009F2480, 0x009F248B, 0x009F246A, 0x009F35A7, 
						  0x009F4047, 0x009F4E73, 0x009F7097, 0x009F70A2, 0x009F75FD, 0x009F78DF, 0x009F8F07, 0x009F917D, 0x009F900C, 0x009F9033, 
						  0x009F924A, 0x009F928D, 0x009F9369, 0x009F939A, 0x009FBB00, 0x009FBB0B, 0x009FBB16, 0x009FBB21, 0x009FCB89, 0x009FCC39, 
						  0x009FD70B, 0x009FE01F, 0x009FE053, 0x009FE064, 0x009FE077, 0x009FE092, 0x009FE0A5, 0x009FE1D4, 0x009FE1DF, 0x009FE1EA, 
						  0x009FE1F5, 0x009FE6A3, 0x009FE7F8, 0x009FE7BC, 0x009FECA0, 0x009FED9D, 0x009FF45B, 0x00A015F0, 0x00A03E1D, 0x00A03E25, 
						  0x00A03E2D, 0x00A03E35, 0x00A049BE, 0x00A04E32, 0x00A06209, 0x00A0FA05, 0x00A0FA35, 0x00A0FA8D, 0x00A0FADD, 0x00A148A5, 
						  0x00A148D5, 0x00A14905, 0x00A1492D, 0x00A1497D, 0x00A149CD, 0x00A16DEE, 0x00A16F86, 0x00A18940, 0x00A18EC5, 0x00A18EED, 
						  0x00A1CF5D, 0x00A1CFAF, 0x00A1D01D, 0x00A1F5EF, 0x00A1F875, 0x00A1F89D, 0x00A21D5B, 0x00A21D7B, 0x00A23DFF, 0x00A24685, 
						  0x00A246B5, 0x00A246E5, 0x00A24715, 0x00A2473D, 0x00A2478D, 0x00A247DD, 0x00A2482D, 0x00A26C5F, 0x00A26F75, 0x00A26F9D, 
						  0x00A30A6C, 0x00A3C6DC, 0x00A409CF, 0x00A41455, 0x00A41485, 0x00A414B5, 0x00A414E5, 0x00A41515, 0x00A41545, 0x00A41575, 
						  0x00A415A5, 0x00A415D5, 0x00A41605, 0x00A41635, 0x00A41665, 0x00A41695, 0x00A416BD, 0x00A4170D, 0x00A4175D, 0x00A417AD, 
						  0x00A417FD, 0x00A4184D, 0x00A4189D, 0x00A418ED, 0x00A4193D, 0x00A4198D, 0x00A419DD, 0x00A41A2D, 0x00A41A7D, 0x00A4218B, 
						  0x00A42279, 0x00A425F3, 0x00A42663, 0x00A48969, 0x00A48A29, 0x00A48F4B, 0x00A48FBA, 0x00A49EA8, 0x00A49EBD, 0x00A57AE9, 
						  0x00A57BA9, 0x00A57C69, 0x00A57D29, 0x00A57DE9, 0x00A57EA9, 0x00A57F69, 0x00A58029, 0x00A580E9, 0x00A581A9, 0x00A58269, 
						  0x00A59949, 0x00A5C309, 0x00A5CB49, 0x00A5E0F9, 0x00A5E1C5, 0x00A5E1ED, 0x00A5E4B9, 0x00A5E4D3, 0x00A5E4EC, 0x00A5F1D9, 
						  0x00A5F5F9, 0x00A60349, 0x00A60B59, 0x00A61569, 0x00A619B9, 0x00A621D9, 0x00A63C7D, 0x00A64BE9, 0x00A65559, 0x00A673F6, 
						  0x00A6CB79, 0x00A6D330, 0x00A6D33B, 0x00A6DBE9, 0x00A6FF79, 0x00A71E39, 0x00A76999, 0x00A77359, 0x00A77999, 0x00A77FF9, 
						  0x00A785F9, 0x00A79809, 0x00A7B579, 0x00A7C0E8, 0x00A7C3A8, 0x00A7C51E, 0x00A7C526, 0x00A7DE9D, 0x00A80BA3, 0x00A80BAB, 
						  0x00A80F9E, 0x00A84155, 0x00A8F34D, 0x00A8F7F9, 0x00A8F8B9, 0x00A8F979, 0x00A8FA45, 0x00A8FA6D, 0x00A90DC6, 0x00A90DD1, 
						  0x00A9162B, 0x00A9176B, 0x00A91B0B, 0x00A925F9, 0x00A926B9, 0x00A92BF9, 0x00A95E19, 0x00A963E9, 0x00A972E9, 0x00BBACF8, 
						  0x00BBC51D, 0x00BBECDC, 0x00BBF223, 0x00BBF382, 0x00BBFDDC, 0x00BBFF3F, 0x00BC015C, 0x00BC028F, 0x00BC062F, 0x00BC077D, 
						  0x00BC08DD, 0x00BC0ACF, 0x00BC0DFD, 0x00BC0E85, 0x00BC0EAD, 0x00BC1D75, 0x00BC1D9D, 0x00BC323C, 0x00BC3313, 0x00BC352F, 
						  0x00BC5CAA, 0x00BC5CDA, 0x00BC9653, 0x00BC9695, 0x00BC9F9A, 0x00BCA44A, 0x00BCABBF, 0x00BCB10D, 0x00BCCDD5, 0x00BD047A, 
						  0x00BD0B6F, 0x00BD5A6A, 0x00BD7533, 0x00BD762B, 0x00BD7701, 0x00BD7805, 0x00BDB535, 0x00BDB53D, 0x00BDB794, 0x00BDB79C, 
						  0x00BDBD10, 0x00BDBD18, 0x00BDC093, 0x00BDFD17, 0x00BDFD48, 0x00BDFD52, 0x00BDFD0D, 0x00BDFF5A, 0x00BE1454, 0x00BE3E8D, 
						  0x00BE8D2E, 0x00BE934E, 0x00BE9385, 0x00BE9471, 0x00BE94CB, 0x00BE9704, 0x00BE977E, 0x00BE97CB, 0x00BE9A26, 0x00BE9A9F, 
						  0x00BE9B19, 0x00BEAE6D, 0x00BEB1AD, 0x00BEB2FD, 0x00BEB445, 0x00BEB475, 0x00BEB49D, 0x00BEB4ED, 0x00BED2CC, 0x00BED90C, 
						  0x00BEDC6F, 0x00BEDDE5, 0x00BEDE15, 0x00BEDE3D, 0x00BEDE8D, 0x00BEE725, 0x00BEE74D, 0x00BF1C2D, 0x00BF3A8D, 0x00BF3E5F, 
						  0x00BF3F05, 0x00BF3F2D, 0x00BF6A25, 0x00BF6A4D, 0x00BF746A, 0x00BFAD9D, 0x00BFBCEF, 0x00BFC0FD, 0x00BFC2DD, 0x00BFCF85, 
						  0x00BFCFAD, 0x00BFD9ED, 0x00C63A64, 0x00C63B64, 0x00C652A1, 0x00C6BB1C, 0x00C6BFBF, 0x00C6C115, 0x00C6C145, 0x00C6C16D, 
						  0x00C6C1BD, 0x00C6DF01, 0x00C6DF11, 0x00C6E02A, 0x00C6E34A, 0x00C6E705, 0x00C70ACE, 0x00C70D1B, 0x00C71924, 0x00C7192C, 
						  0x00C7191C, 0x00C71F7C, 0x00C7259D, 0x00C725E4, 0x00C73B7F, 0x00C7871A, 0x00C78B6C, 0x00C78F9C, 0x00C7960C, 0x00C79B1F, 
						  0x00C79C45, 0x00C79C75, 0x00C79C9D, 0x00C79CED, 0x00C7A4D5, 0x00C7A4FD, 0x00C7B0B4, 0x00C7C975, 0x00C7C99D, 0x00C7CC50, 
						  0x00C7CC5B, 0x00C7CE29, 0x00C7CF0B, 0x00C7D1BA, 0x00C7D3BE, 0x00C7D3D6, 0x00C7D72E, 0x00C7D770, 0x00C7D9D1, 0x00C7D9D9, 
						  0x00C7D9E1, 0x00C7D9E9, 0x00C7DB81, 0x00C7DB89, 0x00C7DB91, 0x00C7DB99, 0x00C7DFA0, 0x00C7DFAD, 0x00C7E004, 0x00C7E011, 
						  0x00C7DEF1, 0x00C7DF30, 0x00C7DF3D, 0x00C7E1F8, 0x00C81105, 0x00C8112D, 0x00C82DE6, 0x00C82DF1, 0x00C832F2, 0x00C83A12, 
						  0x00C83CA6, 0x00C83D34, 0x00C83EFE, 0x00C849D2, 0x00C85F57, 0x00C85F62, 0x00C85F6D, 0x00C85FBD, 0x00C85FC8, 0x00C8603F, 
						  0x00C86721, 0x00C86BAE, 0x00C86E4C, 0x00C8732A, 0x00C8754E, 0x00C87556, 0x00C8A107, 0x00C8B124, 0x00C8B12F, 0x00C8B229, 
						  0x00C8B231, 0x00C8BC4D, 0x00C90E2D, 0x00C918B7, 0x00C94E5E, 0x00C980E5, 0x00C9A444, 0x00C9A554, 0x00C9A588, 0x00C9B5A5, 
						  0x00C9C53C, 0x00C9C71C, 0x00C9C727, 0x00C9C7AA, 0x00C9E14E, 0x00C9E159, 0x00C9F00A, 0x00C9F6EE, 0x00C9F6F9, 0x00CA1643, 
						  0x00CA1771, 0x00CA291C, 0x00CA292B, 0x00CA2943, 0x00CA295B, 0x00CA2989, 0x00CA2E14, 0x00CA2E35, 0x00CA2E4C, 0x00CA2E6D, 
						  0x00CA2E85, 0x00CA2E9D, 0x00CA390A, 0x00CA392C, 0x00CA3AAD, 0x00CA3AD5, 0x00CA750C, 0x00CA760B, 0x00CA757C, 0x00CA7B79, 
						  0x00CA7BA3, 0x00CA7BBE, 0x00CA9B8F, 0x00CAA291, 0x00CAA2AC, 0x00CAA85D, 0x00CAA882, 0x00CAA922, 0x00CAAF35, 0x00CAAF5D, 
						  0x00CABF88, 0x00CABFA1, 0x00CAC169, 0x00CAC769, 0x00CAC7A8, 0x00CAC7E7, 0x00CAC7F7, 0x00CAC83F, 0x00CAC9D3, 0x00CAC9E3, 
						  0x00CACA16, 0x00CACA63, 0x00CAC6A1, 0x00CACB21, 0x00CACB2C, 0x00CAC6B1, 0x00CACC1A, 0x00CACC25, 0x00CACC60, 0x00CACE4D, 
						  0x00CACE58, 0x00CAC6FB, 0x00CAC70B, 0x00CAC759, 0x00CAD0DA, 0x00CAD17D, 0x00CAD457, 0x00CAD47E, 0x00CAD393, 0x00CAD3A0, 
						  0x00CAD3E4, 0x00CAD40B, 0x00CADA90, 0x00CADBAA, 0x00CADDFC, 0x00CAD84E, 0x00CAE599, 0x00CAEB96, 0x00CAEE30, 0x00CAEE43, 
						  0x00CAEE7A, 0x00CAEF12, 0x00CAEF25, 0x00CAEC9E, 0x00CAEF5C, 0x00CAEFB4, 0x00CAECDE, 0x00CAED53, 0x00CAF6AA, 0x00CAF6BD, 
						  0x00CAF6F4, 0x00CAF77D, 0x00CAF790, 0x00CAF548, 0x00CAF7C7, 0x00CAF582, 0x00CAF5EB, 0x00CAFA63, 0x00CAFAC3, 0x00CAFC11, 
						  0x00CAFC2D, 0x00CAFD62, 0x00CAFD88, 0x00CAFF91, 0x00CAFF9C, 0x00CAFFA7, 0x00CAFFB4, 0x00CB00B0, 0x00CB00BB, 0x00CB00C6, 
						  0x00CB00DA, 0x00CB00E7, 0x00CB029C, 0x00CB02B0, 0x00CB07CC, 0x00CB07D4, 0x00CB0708, 0x00CB0710, 0x00CB0BAC, 0x00CB0BB4, 
						  0x00CB1422, 0x00CB142A, 0x00CB1E54, 0x00CB1E80, 0x00CB1E4C, 0x00CB2074, 0x00CB20A0, 0x00CB206C, 0x00CB262C, 0x00CB2824, 
						  0x00CB281C, 0x00CB2B0E, 0x00CB2E45, 0x00CB2E50, 0x00CB2F3A, 0x00CB34F5, 0x00CB34FC, 0x00CB3517, 0x00CB351E, 0x00CB33F6, 
						  0x00CB340C, 0x00CB3454, 0x00CB498D, 0x00CB4995, 0x00CB4E34, 0x00CB526D, 0x00CB5275, 0x00CB567D, 0x00CB5685, 0x00CB5BFB, 
						  0x00CB5C03, 0x00CB5F8B, 0x00CB5F93, 0x00CB6B85, 0x00CB733E, 0x00CB791E, 0x00CB7771, 0x00CB77E3, 0x00CB8C35, 0x00CB94D4, 
						  0x00CB94CC, 0x00CB9726, 0x00CB9DF2, 0x00CBA0AC, 0x00CBA646, 0x00CBA64D, 0x00CBA5B3, 0x00CBA869, 0x00CBAE1F, 0x00CBADE6, 
						  0x00CBADED, 0x00CBAEAA, 0x00CBB99A, 0x00CBB9BF, 0x00CBC021, 0x00CBC02C, 0x00CBC049, 0x00CBC238, 0x00CBC259, 0x00CBC260, 
						  0x00CBC43F, 0x00CBC446, 0x00CBC33F, 0x00CBCE2F, 0x00CBCA31, 0x00CBCA39, 0x00CBCA41, 0x00CBD810, 0x00CBDF82, 0x00CBEB4A, 
						  0x00CBEBD5, 0x00CBF4BA, 0x00CBF4DA, 0x00CC1025, 0x00CC152C, 0x00CC164C, 0x00CC1654, 0x00CC165F, 0x00CC1758, 0x00CC1834, 
						  0x00CC3913, 0x00CC391B, 0x00CC3923, 0x00CC3ADA, 0x00CC3AE5, 0x00CC42A3, 0x00CC42AE, 0x00CC42B9, 0x00CC42C4, 0x00CC3B58, 
						  0x00CC3B60, 0x00CC3B68, 0x00CC3B70, 0x00CC3B7B, 0x00CC6284, 0x00CC628C, 0x00CC627C, 0x00CC6B3E, 0x00CC8F0F, 0x00CCC846, 
						  0x00CCC851, 0x00CCE760, 0x00CCF3F6, 0x00CD03BD, 0x00CD032F, 0x00CD0C8A, 0x00CD20B5, 0x00CD20DD, 0x00CD21F7, 0x00CD29D5, 
						  0x00CD29EB, 0x00CD29F6, 0x00CD2A01, 0x00CD2A0C, 0x00CD2A17, 0x00CD5385, 0x00CD53AD, 0x00CD65D6, 0x00CD9C19, 0x00CDB54F, 
						  0x00CDB556, 0x00CDB563, 0x00CDB56A, 0x00CDB6F0, 0x00CDB6F7, 0x00CDB704, 0x00CDB70B, 0x00CDB770, 0x00CDB777, 0x00CDB784, 
						  0x00CDB78B, 0x00CDB7ED, 0x00CDB7F4, 0x00CDB801, 0x00CDB808, 0x00CDB665, 0x00CDB66C, 0x00CDB679, 0x00CDB680, 0x00CDB889, 
						  0x00CDB890, 0x00CDB89D, 0x00CDB8A4, 0x00CDB8FE, 0x00CDB905, 0x00CDB91D, 0x00CDB924, 0x00CDB9CE, 0x00CDB9D5, 0x00CDBA1F, 
						  0x00CDBA26, 0x00CDBA67, 0x00CDC337, 0x00CDC33E, 0x00CDC350, 0x00CDC357, 0x00CDC3A0, 0x00CDC3E6, 0x00CDC3ED, 0x00CDC418, 
						  0x00CDC41F, 0x00CDC20A, 0x00CDC211, 0x00CDC290, 0x00CDC297, 0x00CDC2A9, 0x00CDC2B0, 0x00CDC79D, 0x00CDC80D, 0x00CDC846, 
						  0x00CDC84D, 0x00CDC86C, 0x00CDC873, 0x00CDC903, 0x00CDC98F, 0x00CDC9B0, 0x00CDC9B7, 0x00CDC9F6, 0x00CDC6F9, 0x00CDCC72, 
						  0x00CDCB9F, 0x00CDCBB8, 0x00CDCC03, 0x00CDCC0E, 0x00CDCD41, 0x00CDCD52, 0x00CDD0E5, 0x00CDD10F, 0x00CDD08E, 0x00CDD0BD, 
						  0x00CDD298, 0x00CDD2A3, 0x00CDD20B, 0x00CDD224, 0x00CDD59C, 0x00CDD5A3, 0x00CDD5B5, 0x00CDD5BC, 0x00CDD961, 0x00CDD968, 
						  0x00CDDA2F, 0x00CDDA36, 0x00CDDB50, 0x00CDDB57, 0x00CDD889, 0x00CDD890, 0x00CDDD91, 0x00CDDD98, 0x00CDDE5F, 0x00CDDE66, 
						  0x00CDDF80, 0x00CDDF87, 0x00CDDCB9, 0x00CDDCC0, 0x00CDE307, 0x00CDE30E, 0x00CDE1C4, 0x00CDE504, 0x00CDE50C, 0x00CDE5D7, 
						  0x00CDE5DE, 0x00CDE6C2, 0x00CDE41B, 0x00CDE4BC, 0x00CDE8C4, 0x00CDE8CC, 0x00CDE997, 0x00CDE99E, 0x00CDEA82, 0x00CDE7DB, 
						  0x00CDE87C, 0x00CDF059, 0x00CDF083, 0x00CDF09E, 0x00CDF4F1, 0x00CDF552, 0x00CE1807, 0x00CE2535, 0x00CE255D, 0x00CE3A60, 
						  0x00CE465E, 0x00CE481A, 0x00CE4A61, 0x00CE4A99, 0x00CE4BE9, 0x00CE4C2B, 0x00CE4938, 0x00CE4959, 0x00CE4D91, 0x00CE4E4C, 
						  0x00CE51FF, 0x00CE520E, 0x00CE521D, 0x00CE522F, 0x00CE5620, 0x00CE5821, 0x00CE5887, 0x00CE5964, 0x00CE57AF, 0x00CE5F6C, 
						  0x00CE5F73, 0x00CE6236, 0x00CE623D, 0x00CE62A9, 0x00CE62B0, 0x00CE62ED, 0x00CE62F4, 0x00CE631C, 0x00CE6323, 0x00CE63CD, 
						  0x00CE63EE, 0x00CE6534, 0x00CE656B, 0x00CE65B5, 0x00CE6951, 0x00CE6972, 0x00CE6A2A, 0x00CE6A4B, 0x00CE6D29, 0x00CE6D60, 
						  0x00CE6DAA, 0x00CE6F1D, 0x00CE710C, 0x00CE7113, 0x00CE7511, 0x00CE751E, 0x00CE765F, 0x00CE78E9, 0x00CE78F0, 0x00CE7B33, 
						  0x00CE7B3A, 0x00CE7E99, 0x00CE7ECD, 0x00CE808A, 0x00CE8093, 0x00CE853D, 0x00CE8581, 0x00CE84DF, 0x00CE86C6, 0x00CE8912, 
						  0x00CE8AC3, 0x00CE8B8C, 0x00CE892C, 0x00CE8C00, 0x00CE8963, 0x00CE897A, 0x00CE8981, 0x00CE89CD, 0x00CE89D4, 0x00CE89F0, 
						  0x00CE89F8, 0x00CE8C82, 0x00CE8E26, 0x00CE8E74, 0x00CE8C9C, 0x00CE8F3D, 0x00CE8FC2, 0x00CE8CD3, 0x00CE8CED, 0x00CE8CF4, 
						  0x00CE8D40, 0x00CE8D47, 0x00CE8D63, 0x00CE8D6B, 0x00CE905E, 0x00CE970F, 0x00CEA60C, 0x00CEA6B9, 0x00CEA6C1, 0x00CEA89B, 
						  0x00CEA8FF, 0x00CEA989, 0x00CEAA69, 0x00CEAD9C, 0x00CEAF3D, 0x00CEAF45, 0x00CEB83D, 0x00CEB845, 0x00CEBBCD, 0x00CEBBD5, 
						  0x00CEC069, 0x00CEC0C8, 0x00CEC0DF, 0x00CEC8B7, 0x00CEC8CF, 0x00CECF17, 0x00CECF84, 0x00CED00D, 0x00CECFF9, 0x00CED151, 
						  0x00CED364, 0x00CED36E, 0x00CED410, 0x00CED1B5, 0x00CED1E6, 0x00CED13D, 0x00CEDFDB, 0x00CEDF66, 0x00CEDF99, 0x00CEE4FD, 
						  0x00CEEB5F, 0x00CEEC35, 0x00CEEC5D, 0x00CEEF5D, 0x00CEF1AA, 0x00CF1515, 0x00CF1565, 0x00CF1645, 0x00CF166D, 0x00CF2CC1, 
						  0x00CF2E44, 0x00CF2E62, 0x00CF36C8, 0x00CF3746, 0x00CF3CAC, 0x00CF4C10, 0x00CF4A4F, 0x00CF4A66, 0x00CF4F5C, 0x00CF5298, 
						  0x00CF54D8, 0x00CF7FB2, 0x00CF7FD3, 0x00CF86FC, 0x00CF927A, 0x00CF9D26, 0x00CF9D95, 0x00CF9DEE, 0x00CF9EC8, 0x00CF9EEB, 
						  0x00CF9F22, 0x00CF9FAC, 0x00CF9C29, 0x00CFA20D, 0x00CF9C4A, 0x00CFA293, 0x00CFA2BA, 0x00CFABC8, 0x00CFAD02, 0x00CFAB83, 
						  0x00CFB216, 0x00CFB2D9, 0x00CFB369, 0x00CFB92D, 0x00CFBC4A, 0x00CFC16D, 0x00CFC8B2, 0x00CFC90A, 0x00CFC8EC, 0x00CFC992, 
						  0x00CFC9FF, 0x00CFCAE1, 0x00CFCAFF, 0x00CFCC72, 0x00CFCCE2, 0x00CFD2C2, 0x00CFD43E, 0x00CFD521, 0x00CFD53F, 0x00CFD702, 
						  0x00CFD726, 0x00CFDC8A, 0x00CFE3C6, 0x00CFE3F0, 0x00CFE4F8, 0x00CFED61, 0x00CFF70F, 0x00CFF72B, 0x00CFF7FD, 0x00CFFA6D, 
						  0x00CFFA94, 0x00CFFAA6, 0x00CFFAC5, 0x00CFFAD6, 0x00CFF9F4, 0x00CFFA04, 0x00CFFA1B, 0x00CFFBEB, 0x00D00D79, 0x00D00DA4, 
						  0x00D01191, 0x00D011FB, 0x00D015DC, 0x00D01835, 0x00D01868, 0x00D01879, 0x00D01A9C, 0x00D02775, 0x00D0286D, 0x00D02875, 
						  0x00D02980, 0x00D032B5, 0x00D032C0, 0x00D032CB, 0x00D032D6, 0x00D032E1, 0x00D032EC, 0x00D0331A, 0x00D03C30, 0x00D03FE8, 
						  0x00D03FDD, 0x00D040F5, 0x00D04E8B, 0x00D04EDF, 0x00D05123, 0x00D051BC, 0x00D051D5, 0x00D051EF, 0x00D0523B, 0x00D05255, 
						  0x00D0534C, 0x00D0538A, 0x00D05498, 0x00D054D6, 0x00D04D64, 0x00D05931, 0x00D0598B, 0x00D0599B, 0x00D05A22, 0x00D05C10, 
						  0x00D05C6F, 0x00D05A43, 0x00D05EC6, 0x00D05EE9, 0x00D05F1E, 0x00D05F53, 0x00D05F88, 0x00D06C4B, 0x00D070A4, 0x00D070E4, 
						  0x00D070FE, 0x00D07109, 0x00D06F6E, 0x00D06F95, 0x00D06FC6, 0x00D06FD3, 0x00D06FE7, 0x00D06FFB, 0x00D07901, 0x00D07908, 
						  0x00D07931, 0x00D07938, 0x00D0797D, 0x00D07F84, 0x00D07F8B, 0x00D07FB3, 0x00D08027, 0x00D080AE, 0x00D080EE, 0x00D08173, 
						  0x00D0836D, 0x00D0838B, 0x00D083F0, 0x00D083F7, 0x00D0857B, 0x00D093E6, 0x00D09467, 0x00D09687, 0x00D0A04E, 0x00D0A059, 
						  0x00D0A0E5, 0x00D0A199, 0x00D0A1A1, 0x00D0A291, 0x00D0A2D4, 0x00D0A2DC, 0x00D0A45A, 0x00D0A4B3, 0x00D0A4BB, 0x00D0A835, 
						  0x00D0A9AD, 0x00D0A9B5, 0x00D0AA1D, 0x00D0A96F, 0x00D0AE78, 0x00D0AF12, 0x00D0AF41, 0x00D0AF93, 0x00D0B152, 0x00D0B23A, 
						  0x00D0B2D3, 0x00D0C02A, 0x00D0C0C9, 0x00D0CD83, 0x00D0CD8B, 0x00D0CCAB, 0x00D0CCB3, 0x00D0D157, 0x00D0E2B1, 0x00D0DEC1, 
						  0x00D0F72D, 0x00D0F738, 0x00D0FF12, 0x00D0FF1A, 0x00D10495, 0x00D1048A, 0x00D109E7, 0x00D10CD5, 0x00D10CFD, 0x00D11D55, 
						  0x00D11D4A, 0x00D11E37, 0x00D11E42, 0x00D12016, 0x00D12029, 0x00D12067, 0x00D1207C, 0x00D1209C, 0x00D120B1, 0x00D120DD, 
						  0x00D120F3, 0x00D12212, 0x00D1221E, 0x00D122FD, 0x00D1231C, 0x00D12D1E, 0x00D12D47, 0x00D12D71, 0x00D12D9B, 0x00D12DC4, 
						  0x00D12DEE, 0x00D13D0D, 0x00D13CFC, 0x00D13FFB, 0x00D1407C, 0x00D1412B, 0x00D141AC, 0x00D147CD, 0x00D147D5, 0x00D14D2D, 
						  0x00D14D35, 0x00D15050, 0x00D1503C, 0x00D15204, 0x00D151EC, 0x00D16039, 0x00D16040, 0x00D16326, 0x00D16D05, 0x00D16CFA, 
						  0x00D17ADE, 0x00D17BF0, 0x00D17BF8, 0x00D183B5, 0x00D186DD, 0x00D18D0D, 0x00D18ECD, 0x00D19160, 0x00D1B3B8, 0x00D1E03B, 
						  0x00D1E69C, 0x00D1E6FC, 0x00D222A2, 0x00D2658A, 0x00D26805, 0x00D26835, 0x00D26865, 0x00D26895, 0x00D268DD, 0x00D2692D, 
						  0x00D2697D, 0x00D269CD, 0x00D26A7D, 0x00D2BFCA, 0x00D2C6DE, 0x00D2D966, 0x00D2DB33, 0x00D2DBB6, 0x00D2DBBE, 0x00D2DBC6, 
						  0x00D2DBCE, 0x00D2E57C, 0x00D311FA, 0x00D334ED, 0x00D34AEA, 0x00D3573A, 0x00D38F5D, 0x00D391ED, 0x00D394CD, 0x00D3951D, 
						  0x00D3AB3C, 0x00D3AD0D, 0x00D41B71, 0x00D41C0C, 0x00D4278A, 0x00D42B6A, 0x00D42BEA, 0x00D43670, 0x00D43791, 0x00D43B71, 
						  0x00D44C4B, 0x00D44B91, 0x00D44BD9, 0x00D4794A, 0x00D48C3F, 0x00D48CDD, 0x00D48D2F, 0x00D48E2F, 0x00D48F1F, 0x00D4900F, 
						  0x00D490FF, 0x00D4AFAD, 0x00D4AFDC, 0x00D4B00A, 0x00D4B039, 0x00D4E17C, 0x00D4E1AB, 0x00D4E981, 0x00D4E9AA, 0x00D4EC0C, 
						  0x00D4EC3B, 0x00D504C5, 0x00D52DBD, 0x00D52DEC, 0x00D58A7D, 0x00D5BA38, 0x00D5BA75, 0x00D60EFF, 0x00D60F9F, 0x00D6188C, 
						  0x00D618BB, 0x00D6A41B, 0x00D6B892, 0x00D842FE, 0x00D85568, 0x00D878AE, 0x00DD219D, 0x00DD21EF, 0x00DD225F, 0x00DD62E1, 
						  0x00DD630F, 0x00DDA3AA, 0x00DDE95F, 0x00DDEE11, 0x00DDEE1A, 0x00DDF044, 0x00DDF07C, 0x00DDF09A, 0x00DE0245, 0x00DE026D, 
						  0x00DE12E1, 0x00DE130F, 0x00DE3357, 0x00DE3363, 0x00DE3C7A, 0x00DE4FE3, 0x00DE5EDA, 0x00DE60DD, 0x00DEA1FF, 0x00DEA26F, 
						  0x00DEA2DD, 0x00DEA32F, 0x00DEA39F, 0x00DEE70D, 0x00DEE75D, 0x00DEE7AD, 0x00DF06F3, 0x00DF0720, 0x00DF191E, 0x00DF197F, 
						  0x00DF29A5, 0x00DF5225, 0x00DFFD25, 0x00DFFD55, 0x00DFFD85, 0x00DFFDB5, 0x00DFFDE5, 0x00DFFE15, 0x00DFFE45, 0x00DFFF4F, 
						  0x00E0001D, 0x00E0006D, 0x00E000BD, 0x00E0010D, 0x00E0015D, 0x00E001AD, 0x00E001FD, 0x00E0085B, 0x00E01693, 0x00E01BEA, 
						  0x00E02153, 0x00E02FC3, 0x00E042B8, 0x00E042EA, 0x00E04301, 0x00E043B8, 0x00E043F5, 0x00E04411, 0x00E07111, 0x00E0711A, 
						  0x00E07201, 0x00E0720A, 0x00E075CA, 0x00E07CD9, 0x00E07D0B, 0x00E07D22, 0x00E07F99, 0x00E07FD6, 0x00E07FF2, 0x00E0C751, 
						  0x00E0CFBC, 0x00E0D0FC, 0x00E0E6DD, 0x00E0E7D7, 0x00E0F7A8, 0x00E12A82, 0x00E12A8B, 0x00E12DA6, 0x00E12DAF, 0x00E12E82, 
						  0x00E12ED9, 0x00E12F2E, 0x00E13196, 0x00E1319F, 0x00E13272, 0x00E132C9, 0x00E1331E, 0x00E13586, 0x00E1358F, 0x00E13662, 
						  0x00E136B9, 0x00E1370E, 0x00E13976, 0x00E1397F, 0x00E13A52, 0x00E13AA9, 0x00E13AFE, 0x00E1457A, 0x00E14800, 0x00E14B2B, 
						  0x00E1503D, 0x00E150DC, 0x00E150E5, 0x00E1510A, 0x00E1511D, 0x00E15137, 0x00E152DD, 0x00E152F4, 0x00E1530A, 0x00E15681, 
						  0x00E156E1, 0x00E1573A, 0x00E15959, 0x00E15ADD, 0x00E15CED, 0x00E1578B, 0x00E157CA, 0x00E16513, 0x00E166A0, 0x00E16703, 
						  0x00E16844, 0x00E169C5, 0x00E16DE8, 0x00E16E18, 0x00E16E48, 0x00E16E78, 0x00E16F5A, 0x00E16FDC, 0x00E1892C, 0x00E1B3CD, 
						  0x00E1B41D, 0x00E1B46D, 0x00E1B4DD, 0x00E1B52F, 0x00E1B59D, 0x00E1B5ED, 0x00E1B63D, 0x00E1B68D, 0x00E1B6DD, 0x00E1F8B9, 
						  0x00E253D3, 0x00E253E1, 0x00E33E2A, 0x00E39F2B, 0x00E39F46, 0x00E3A813, 0x00E3A99F, 0x00E3A9B2, 0x00E3A9BB, 0x00E3A81F, 
						  0x00E3A82B, 0x00E3C248, 0x00E3E8A4, 0x00E43EC7, 0x00E43ED2, 0x00E44028, 0x00E44033, 0x00E4DD52, 0x00E56761, 0x00E56759, 
						  0x00E57020, 0x00E5702B, 0x00E570ED, 0x00E5888C, 0x00E58894, 0x00E5AA0D, 0x00E5AA2E, 0x00E5D03A, 0x00E5D20D, 0x00E5D541, 
						  0x00E5D77B, 0x00E5D7D5, 0x00E5D8F0, 0x00E5DD98, 0x00E5DFC4, 0x00E6BB49, 0x00E6BC60, 0x00E6BD4C, 0x00E6BDD6, 0x00E6C2B9, 
						  0x00E6C6BE, 0x00E6E817, 0x00E6F327, 0x00E6F42A, 0x00E70225, 0x00E70879, 0x00E708ED, 0x00E70C60, 0x00E70C91, 0x00E715A1, 
						  0x00E715DF, 0x00E7194E, 0x00E71A69, 0x00E7220C, 0x00E72222, 0x00E724D5, 0x00E7674D, 0x00E79145, 0x00E79151, 0x00E791C5, 
						  0x00E7992A, 0x00E79AA4, 0x00E79AB2, 0x00E7D7D4, 0x00E7D808, 0x00E7DE9D, 0x00E7DF65, 0x00E7DF8D, 0x00E81D89, 0x00E8225C, 
						  0x00E82906, 0x00E82912, 0x00E8291E, 0x00E83C3E, 0x00E84B3D, 0x00E8509E, 0x00E85D90, 0x00E855AF, 0x00E855BA, 0x00E855C5, 
						  0x00E855D0, 0x00E86F3B, 0x00E87BCD, 0x00E8936F, 0x00E8CC25, 0x00E8CC55, 0x00E8DECA, 0x00E8EAAA, 0x00E90ADE, 0x00E90B18, 
						  0x00E91089, 0x00E94B8C, 0x00E94C7E, 0x00EC8AF0, 0x00ECA770, 0x00ECA7EB, 0x00ECA7F7, 0x00ECAB56, 0x00ECB534, 0x00ECB66E, 
						  0x00ECB69A, 0x00ECB6BF, 0x00ECD01D, 0x00ECF168, 0x00ECF173, 0x00ECF17E, 0x00ECF15D, 0x00ECFC4A, 0x00ECFC80, 0x00ED05F9, 
						  0x00ED0602, 0x00ED060B, 0x00ED04AB, 0x00ED04B7, 0x00ED04C3, 0x00ED04CF, 0x00ED04DB, 0x00ED04E7, 0x00ED1340, 0x00ED134C, 
						  0x00ED1654, 0x00ED1660, 0x00ED22D9, 0x00ED2E60, 0x00ED2E6C, 0x00ED2FCE, 0x00ED2FFB, 0x00ED341C, 0x00ED38F7, 0x00ED3902, 
						  0x00ED390D, 0x00ED3918, 0x00ED446D, 0x00ED449C, 0x00ED4670, 0x00ED4692, 0x00ED4A7D, 0x00ED4B54, 0x00ED4BB7, 0x00ED4C8C, 
						  0x00ED50FA, 0x00ED68E1, 0x00ED68E9, 0x00ED6BD7, 0x00ED6C53, 0x00ED7196, 0x00ED71A1, 0x00ED8D2D, 0x00ED97C9, 0x00ED9AF9, 
						  0x00ED9B98, 0x00EDAB42, 0x00EDAB84, 0x00EDAB8D, 0x00EDAB96, 0x00EDB241, 0x00EDAF19, 0x00EDAF25, 0x00EDAF73, 0x00EDBE3B, 
						  0x00EDC16B, 0x00EDC219, 0x00EDC2E9, 0x00EDC2F8, 0x00EDC30E, 0x00EDC367, 0x00EDC425, 0x00EDC4AD, 0x00EDC081, 0x00EDC668, 
						  0x00EDC6B6, 0x00EDC754, 0x00EDC61E, 0x00EDCC63, 0x00EDCE96, 0x00EDE4E2, 0x00EDF1C0, 0x00EE0389, 0x00EE05AF, 0x00EE05D7, 
						  0x00EE0631, 0x00EE1068, 0x00EE105D, 0x00EE1098, 0x00EE108D, 0x00EE2125, 0x00EE214D, 0x00EE320C, 0x00EE36C1, 0x00EE368D, 
						  0x00EE3741, 0x00EE370D, 0x00EE3835, 0x00EE385D, 0x00EE3945, 0x00EE396D, 0x00EE7241, 0x00EE724A, 0x00EE7548, 0x00EE7902, 
						  0x00EE790E, 0x00EE8280, 0x00EE828C, 0x00EE8CB1, 0x00EE95FF, 0x00EE9633, 0x00EE9664, 0x00EE97B5, 0x00EE9AA1, 0x00EE9AAA, 
						  0x00EE9AE1, 0x00EE9B79, 0x00EE9C39, 0x00EEA13F, 0x00EEA148, 0x00EEA331, 0x00EEA4F6, 0x00EEA6FE, 0x00EEA70A, 0x00EEA74E, 
						  0x00EEA79E, 0x00EEACD0, 0x00EEAD19, 0x00EEB133, 0x00EEB994, 0x00EEBA29, 0x00EEBD20, 0x00EEBD2C, 0x00EEBD34, 0x00EEC59C, 
						  0x00EEC6CD, 0x00EEC8F7, 0x00EECB9C, 0x00EECB05, 0x00EECB61, 0x00EECB7A, 0x00EED12A, 0x00EED047, 0x00EED520, 0x00EED425, 
						  0x00EEDCC1, 0x00EEDCDA, 0x00EEDD1C, 0x00EEE0D4, 0x00EEE340, 0x00EEE3EC, 0x00EEEA75, 0x00EEEA9D, 0x00EEF1B6, 0x00EF02B4, 
						  0x00EF03E3, 0x00EF0A69, 0x00EF0A75, 0x00EF0CA0, 0x00EF17D8, 0x00EF1846, 0x00EF187C, 0x00EF2670, 0x00EF5B0F, 0x00EF69BB, 
						  0x00EF69CE, 0x00EF6A1A, 0x00EF6A44, 0x00EF6E85, 0x00EF6E9C, 0x00EF8888, 0x00EF9ABA, 0x00EF9AC6, 0x00EF9E1A, 0x00EF9E53, 
						  0x00EF9FBD, 0x00EFA149, 0x00EFA155, 0x00EFA15E, 0x00EFA167, 0x00EF9EF9, 0x00EF9F39, 0x00EFB278, 0x00EFB28E, 0x00EFB299, 
						  0x00EFB2B2, 0x00EFB2C0, 0x00EFB2CE, 0x00EFB2DC, 0x00EFB2EA, 0x00EFB2F8, 0x00EFB4B8, 0x00EFB4CE, 0x00EFB4D9, 0x00EFB4F2, 
						  0x00EFB500, 0x00EFB50E, 0x00EFB51C, 0x00EFB52A, 0x00EFB538, 0x00EFB6D8, 0x00EFB6EE, 0x00EFB6F9, 0x00EFB712, 0x00EFB720, 
						  0x00EFB72E, 0x00EFB73C, 0x00EFB74A, 0x00EFB778, 0x00EFB78E, 0x00EFB799, 0x00EFB7B2, 0x00EFB7C0, 0x00EFB7CE, 0x00EFB7DC, 
						  0x00EFB7EA, 0x00EFB818, 0x00EFB82E, 0x00EFB839, 0x00EFB852, 0x00EFB860, 0x00EFB86E, 0x00EFB87C, 0x00EFB88A, 0x00EFBD61, 
						  0x00EFE7EC, 0x00EFF7FA, 0x00EFFB19, 0x00EFFD2A, 0x00F0066F, 0x00F017D3, 0x00F01ABD, 0x00F01DC7, 0x00F01DD0, 0x00F01DD9, 
						  0x00F018FC, 0x00F02379, 0x00F02382, 0x00F0238B, 0x00F023A1, 0x00F02844, 0x00F0284D, 0x00F02856, 0x00F02B0D, 0x00F02BB9, 
						  0x00F02CC7, 0x00F02CD2, 0x00F02CDD, 0x00F02CE8, 0x00F02CF3, 0x00F02E31, 0x00F02E5D, 0x00F03434, 0x00F03734, 0x00F0373D, 
						  0x00F03746, 0x00F04EFA, 0x00F05FD4, 0x00F05FDC, 0x00F06378, 0x00F06380, 0x00F066EF, 0x00F06782, 0x00F06599, 0x00F06619, 
						  0x00F068FE, 0x00F0693B, 0x00F06952, 0x00F068DD, 0x00F06F9B, 0x00F073C1, 0x00F074A1, 0x00F07569, 0x00F0760E, 0x00F0761F, 
						  0x00F07719, 0x00F07ED5, 0x00F07EE1, 0x00F07EED, 0x00F08EEC, 0x00F08E04, 0x00F09891, 0x00F09973, 0x00F0B542, 0x00F0B554, 
						  0x00F0BAB7, 0x00F143BA, 0x00F142D9, 0x00F148D4, 0x00F1490F, 0x00F14378, 0x00F1438B, 0x00F149A6, 0x00F149CD, 0x00F149EE, 
						  0x00F1499D, 0x00F15070, 0x00F1517A, 0x00F15183, 0x00F15202, 0x00F1515D, 0x00F1D806, 0x00F1D857, 0x00F24546, 0x00F29C5A, 
						  0x00F29B58, 0x00F29B8B, 0x00F29E24, 0x00F2A02C, 0x00F2A273, 0x00F2A41C, 0x00F2AF95, 0x00F2AFBA, 0x00F2AFCC, 0x00F2B4C7, 
						  0x00F2B4E5, 0x00F2B61D, 0x00F2B65E, 0x00F2B674, 0x00F2BE35, 0x00F2BEAC, 0x00F2BED5, 0x00F2BECA, 0x00F2BF48, 0x00F2C5E4, 
						  0x00F2C5F6, 0x00F2C684, 0x00F2D074, 0x00F2D0D3, 0x00F2D49A, 0x00F2C9E9, 0x00F2C9F5, 0x00F2D81C, 0x00F2D981, 0x00F2DD40, 
						  0x00F2F89F, 0x00F2F8A8, 0x00F5E487, 0x00F5F9D5, 0x00F5F9DD, 0x00F6065F, 0x00F612D5, 0x00F61676, 0x00F6184D, 0x00F61019, 
						  0x00F6194E, 0x00F61959, 0x00F61D45, 0x00F61D6D, 0x00F62305, 0x00F6230D, 0x00F63419, 0x00F63424, 0x00F651CC, 0x00F651DE, 
						  0x00F65920, 0x00F65954, 0x00F69442, 0x00F69A14, 0x00F69FCF, 0x00F69FD8, 0x00F69FE1, 0x00F6A197, 0x00F6A1A2, 0x00F6A1AD, 
						  0x00F6A1B8, 0x00F6A1C3, 0x00F6A70F, 0x00F6A718, 0x00F6A721, 0x00F6B4C8, 0x00F6B4D0, 0x00F6CD6D, 0x00F6CD75, 0x00F6DFCE, 
						  0x00F6DFD9, 0x00F6E446, 0x00F6E452, 0x00F6E45E, 0x00F6E55C, 0x00F6ECBD, 0x00F6ECC6, 0x00F6ECCF, 0x00F6ED0E, 0x00F70034, 
						  0x00F70051, 0x00F70B5C, 0x00F7200A, 0x00F7220A, 0x00F76FAD, 0x00F77BD2, 0x00F77BDB, 0x00F77CA6, 0x00F77CBB, 0x00F7802F, 
						  0x00F88FA2, 0x00F88D90, 0x00F890F5, 0x00F89100, 0x00F8910B, 0x00F89116, 0x00F89121, 0x00F890EA, 0x00F89369, 0x00F893A8, 
						  0x00F895A9, 0x00F89C7A, 0x00F89C86, 0x00F89C92, 0x00F8A025, 0x00F89A69, 0x00F8A1D1, 0x00F8A1D9, 0x00F8B0E3, 0x00F8B22C, 
						  0x00F8B408, 0x00F8B5CC, 0x00F8B8E2, 0x00F8B7B6, 0x00F8B981, 0x00F8B7CF, 0x00F8BCB4, 0x00F8C1FB, 0x00F8C21E, 0x00F8C243, 
						  0x00F8C86D, 0x00F93A81, 0x00F93B55, 0x00F93B4D, 0x00F9BF6E, 0x00FC3022, 0x00FC3494, 0x00FC349C, 0x00FC34A5, 0x00FC8205, 
						  0x00FE05F6, 0x00FE0601, 0x00FE060C, 0x00FE07C5, 0x00FE088C, 0x00FE08D7, 0x00FE069F, 0x00FE06CF, 0x00FE0AA6};

	DWORD get_useless = 0x00450E10;

	DWORD sqrt_calls[] = {0x010002F8, 0x010006B8, 0x01000B7C, 0x01001193, 0x0100138E, 0x0100154E, 0x0100D3EE, 0x01029B38, 0x0102959E, 0x01029833, 
						  0x0102DBB5, 0x0102E254, 0x010323D8, 0x01031E46, 0x010320DB, 0x01035BE0, 0x01057B5E, 0x01057B6B, 0x0107AB16, 0x0108B5F5, 
						  0x0108B6C6, 0x0108B72B, 0x0108B425, 0x0108C091, 0x0108C4CF, 0x0109FCA2, 0x0109FCC9, 0x0109FCF0, 0x0109FE86, 0x0109FEAD, 
						  0x0109FED4, 0x010A0048, 0x010A006F, 0x010A0096, 0x010A3E36, 0x010A3EA6, 0x010AFB9D, 0x010B8866, 0x010B898A, 0x010D7035, 
						  0x010D70E6, 0x010E51E6, 0x010EFCCE, 0x010EFCE5, 0x010F47B9, 0x011068EB, 0x01107205, 0x01107B82, 0x011CBBA7, 0x011CBBC7, 
						  0x011CBC17, 0x011CBC37, 0x011CBC87, 0x011CBCA7, 0x011CBCF7, 0x011CBD17, 0x011CBD67, 0x011CBD87, 0x011CBDD7, 0x011CBDF7, 
						  0x011CBE47, 0x011CBE67, 0x011CBF47, 0x011CBF67, 0x011CBF97, 0x011CBFB7, 0x011CC007, 0x011CC027, 0x011CC077, 0x011CC097, 
						  0x011CC107, 0x011CC127, 0x011CC157, 0x011CC177, 0x011CC207, 0x011CC227, 0x011CC277, 0x011CC297, 0x011CC2E7, 0x011CC307, 
						  0x011CC387, 0x011CC3A7, 0x011CC3F7, 0x011CC417, 0x011CC4B7, 0x011CC4D7, 0x011CC5B7, 0x011CC5D7, 0x011CC627, 0x011CC647, 
						  0x011CC6B7, 0x011CC6D7, 0x011CC737, 0x011CC757, 0x011CC787, 0x011CC7A7, 0x011CC7F7, 0x011CC817, 0x011CC867, 0x011CC887, 
						  0x011CC957, 0x011CC977, 0x011CC9E7, 0x011CCA07, 0x011CCAD7, 0x011CCAF7, 0x011CCB47, 0x011CCB67, 0x011CCBB7, 0x011CCBD7, 
						  0x011CCC47, 0x011CCC67, 0x011CCCB7, 0x011CCCD7, 0x011CCD27, 0x011CCD47, 0x011CCD97, 0x011CCDB7, 0x011CCE07, 0x011CCE27, 
						  0x011CCE77, 0x011CCE97, 0x011CCF47, 0x011CCF67, 0x011CCFF7, 0x011CD017, 0x011CD187, 0x011CD1A7, 0x011CD1F7, 0x011CD217, 
						  0x011CD2C7, 0x011CD2E7, 0x011CD347, 0x011CD367, 0x011CD3E7, 0x011CD407, 0x011CD487, 0x011CD4A7, 0x011CD617, 0x011CD637, 
						  0x011CD687, 0x011CD6A7, 0x011CD757, 0x011CD777, 0x011CD837, 0x011CD857, 0x011CD8A7, 0x011CD8C7, 0x011CD937, 0x011CD957, 
						  0x011CD9A7, 0x011CD9C7, 0x011CDA17, 0x011CDA37, 0x011CDA87, 0x011CDAA7, 0x011CDB47, 0x011CDB67, 0x011CDBB7, 0x011CDBD7, 
						  0x011CDC27, 0x011CDC47, 0x011CDCB7, 0x011CDCD7, 0x011CDD27, 0x011CDD47, 0x011CDD97, 0x011CDDB7, 0x011CDDE7, 0x011CDE07, 
						  0x011CDE57, 0x011CDE77, 0x011CDEA7, 0x011CDEC7, 0x011CDF37, 0x011CDF57, 0x011CDFC7, 0x011CDFE7, 0x011CE017, 0x011CE037, 
						  0x011CE087, 0x011CE0A7, 0x011CE0F7, 0x011CE117, 0x011CE1D7, 0x011CE1F7, 0x011CE227, 0x011CE247, 0x011CE2B7, 0x011CE2D7, 
						  0x011CE327, 0x011CE347, 0x011CE3B7, 0x011CE3D7, 0x011CE427, 0x011CE447, 0x011CE497, 0x011CE4B7, 0x011CE507, 0x011CE527, 
						  0x011CE557, 0x011CE577, 0x011CE5E7, 0x011CE607, 0x011CE657, 0x011CE677, 0x011CE6E7, 0x011CE707, 0x011CE757, 0x011CE777, 
						  0x011CE7E7, 0x011CE807, 0x011CE897, 0x011CE8B7, 0x011CE907, 0x011CE927, 0x011CE957, 0x011CE977, 0x011CEA17, 0x011CEA37, 
						  0x011CEAA7, 0x011CEAC7, 0x011CEAF7, 0x011CEB17, 0x011CEB67, 0x011CEB87, 0x011CEC57, 0x011CEC77, 0x011CECC7, 0x011CECE7, 
						  0x011CED87, 0x011CEDA7, 0x011CEDF7, 0x011CEE17, 0x011CEEF7, 0x011CEF17, 0x011CEFA7, 0x011CEFC7, 0x011CF017, 0x011CF037, 
						  0x011CF0B7, 0x011CF0D7, 0x011CF127, 0x011CF147, 0x011E37D7, 0x011E37F7, 0x011E3847, 0x011E3867, 0x011E38B7, 0x011E38D7, 
						  0x011E3927, 0x011E3947, 0x011E39B7, 0x011E39D7, 0x011E3A27, 0x011E3A47, 0x011E3A77, 0x011E3A97, 0x011E3AE7, 0x011E3B07, 
						  0x011E3B57, 0x011E3B77, 0x011E3BC7, 0x011E3BE7, 0x011E3C37, 0x011E3C57, 0x011E3CA7, 0x011E3CC7, 0x011E3D17, 0x011E3D37, 
						  0x011E3D87, 0x011E3DA7, 0x011E3DF7, 0x011E3E17, 0x011E3E67, 0x011E3E87, 0x011E3ED7, 0x011E3EF7, 0x011E3F47, 0x011E3F67, 
						  0x011E3FB7, 0x011E3FD7, 0x011E4027, 0x011E4047, 0x011E40B7, 0x011E40D7, 0x011E4127, 0x011E4147, 0x011E4197, 0x011E41B7, 
						  0x011E4207, 0x011E4227, 0x011E4277, 0x011E4297, 0x011E42E7, 0x011E4307, 0x011E4357, 0x011E4377, 0x011E43C7, 0x011E43E7, 
						  0x011E4437, 0x011E4457, 0x011E44A7, 0x011E44C7, 0x011E4517, 0x011E4537, 0x011E4587, 0x011E45A7, 0x011E45F7, 0x011E4617, 
						  0x011E4667, 0x011E4687, 0x011E46D7, 0x011E46F7, 0x011E4747, 0x011E4767, 0x011E47B7, 0x011E47D7, 0x011E4827, 0x011E4847, 
						  0x011E4897, 0x011E48B7, 0x011E4907, 0x011E4927, 0x011E4977, 0x011E4997, 0x011E49E7, 0x011E4A07, 0x011E4A57, 0x011E4A77, 
						  0x011E4AC7, 0x011E4AE7, 0x011E4B37, 0x011E4B57, 0x011E4BA7, 0x011E4BC7, 0x011E4C17, 0x011E4C37, 0x011E4C87, 0x011E4CA7, 
						  0x011E4D17, 0x011E4D37, 0x011E4D87, 0x011E4DA7, 0x011E4DF7, 0x011E4E17, 0x011E4E67, 0x011E4E87, 0x011E4ED7, 0x011E4EF7, 
						  0x011E4F47, 0x011E4F67, 0x011E4FB7, 0x011E4FD7, 0x011E5027, 0x011E5047, 0x011E5097, 0x011E50B7, 0x011E5107, 0x011E5127, 
						  0x011E5177, 0x011E5197, 0x011E51E7, 0x011E5207, 0x011E5257, 0x011E5277, 0x011E52C7, 0x011E52E7, 0x011E5337, 0x011E5357, 
						  0x011E53A7, 0x011E53C7, 0x011F0E27, 0x011F0E47, 0x011F0E97, 0x011F0EB7, 0x011F0F07, 0x011F0F27, 0x011F0F77, 0x011F0F97, 
						  0x011F1007, 0x011F1027, 0x011F1077, 0x011F1097, 0x00A9E6DE, 0x00AA4D76, 0x00AA4DCF, 0x00AA4E14, 0x00AA52AC, 0x00AA534D, 
						  0x00AA54DC, 0x00AA557D, 0x00AA5FB1, 0x00AABD8F, 0x00AE1F77, 0x00AF8AD6, 0x00AF8B1D, 0x00B0944C, 0x00B3590D, 0x00B35F2B, 
						  0x00B35FF1, 0x00B4B742, 0x00B4CC31, 0x00B4D3F3, 0x00B4E6A6, 0x00B5BFAC, 0x00B85BB5, 0x00B86D30, 0x00B86D82, 0x00B9790E, 
						  0x00B999D0, 0x00B999FE, 0x00B99AD9, 0x00B99BA0, 0x00B9C430, 0x00B9C618, 0x00B9C702, 0x00B9CB49, 0x00B9D334, 0x00B9DC1F, 
						  0x00BA3F11, 0x00BA4571, 0x00BB1829, 0x00BB19BE, 0x00BB1A5F, 0x00BB1BFF, 0x00BB1E90, 0x00BB1F30, 0x00BB51BF, 0x00BB5675, 
						  0x00BB56CF, 0x00BB598A, 0x00BB76BE, 0x00C098DF, 0x00C0CC73, 0x00C0E02B, 0x00C119E3, 0x00C1192C, 0x00C1898F, 0x00C245E2, 
						  0x00C27A72, 0x00C294C6, 0x00C294F7, 0x00C3A670, 0x00C3A74C, 0x00C3A82C, 0x00C3A909, 0x00C3B72A, 0x00C3B7EA, 0x00C3BD07, 
						  0x00C3EB43, 0x00C3ECA7, 0x00C3EBFF, 0x00C41A8C, 0x00C41DFC, 0x00C41FF5, 0x00C422D5, 0x00C4F42E, 0x00C51529, 0x00DAD2E4, 
						  0x00DADA38, 0x00DC692D, 0x00DC87D4, 0x00DC98A1, 0x00EB92CF, 0x00EB95E1, 0x00EBA475, 0x00EBBEBC, 0x00EBCA19, 0x00EBCD95, 
						  0x00EBCDBA, 0x00EBE09B, 0x00EBEABA, 0x00EC2FEC, 0x00EC391C, 0x00EC4D5C, 0x00EC529B, 0x00EC596E, 0x00EC5AD7, 0x00EC70BD, 
						  0x00EE3C0E, 0x00F0BCCC, 0x00F0BBF6, 0x00F0BF5A, 0x00F175CE, 0x00F26AB9, 0x00F2FD91, 0x00F4EC10, 0x00F50E29, 0x00F50E98, 
						  0x00F565A8, 0x00F57523, 0x00F57EA0, 0x00F57EBB, 0x00F5A3D9, 0x00F5C3CB, 0x00F5C5DC, 0x00F7A2F7, 0x00F8D87C, 0x00F8D8C4, 
						  0x00F8E613, 0x00F8E991, 0x00F8F1B5, 0x00F902BD, 0x00F9032C, 0x00F9CC88, 0x00FAE941, 0x00FAE977, 0x00FBF9AE, 0x00FBFBC6, 
						  0x00FBFB15, 0x00FBFECA, 0x00FC00F6, 0x00FC02C8, 0x00FC04FB, 0x00FC064D, 0x00FC0709, 0x00FC003A, 0x00FC023C, 0x00FC11C4, 
						  0x00FC13C8, 0x00FC1326, 0x00FC156C, 0x00FC15EF, 0x00FC1C2E, 0x00FC1DD7, 0x00FC220E, 0x00FC1EE8, 0x00FCA34F, 0x00FCA412, 
						  0x00FD4672, 0x00FD49FB, 0x00FD4A72, 0x00FD4BD2, 0x00FD4EF8, 0x00FD4E02, 0x00FD4F6B, 0x00FD4FF9, 0x00FD5223, 0x00FD5112, 
						  0x00FD5376, 0x00FD5272, 0x00FE32DD, 0x00FE39F8, 0x00FE3882, 0x00FE3B2C, 0x00FE4060, 0x00FE4085, 0x00FE40AA, 0x00FE450D};

	DWORD sqrt_jumps[] = {0x00AA5CFD, 0x00AA5D1E};

	DWORD sqrt = 0x0110D760;

	DWORD determine_visiblity = 0x004A68B0;

	DWORD dot_product = 0x0064DF40;

	DWORD dot_product_minus_unknown = 0x004A6910;

	DWORD get_row_column_calls[] = {0x0048F7B8, 0x0048F7EC, 0x0048F820, 0x0048F854, 0x0048F888, 0x0048F8BC, 0x0048F8F0, 0x0048F924, 0x0048F958, 0x0059290F, 
						  0x0059291E, 0x0059292D, 0x0059293E, 0x0059294D, 0x0059295C, 0x00C7E0FB, 0x00C7E10F, 0x00C7E124, 0x00C7E143, 0x00C7E158, 
						  0x00C7E16D, 0x00C7E18C, 0x00C7E1A1, 0x00C7E1B6, 0x00E3BFFE, 0x00E3C013, 0x00E3C032, 0x00E3C047, 0x00E3C05C, 0x00E3C07B, 
						  0x00E3BFEA, 0x00E3C090, 0x00E3C0A5, 0x00E43EE1, 0x00E43EFF, 0x00E43F1D, 0x00E43F38, 0x00E43F53, 0x00E43F6E, 0x00E43F89, 
						  0x00E43FA4, 0x00E43FBF, 0x00E5DA3D, 0x00E5D996, 0x00E5D9A7, 0x00E5D9B9, 0x00E5D9D7, 0x00E5D9E9, 0x00E5D9FB, 0x00E5DA19, 
						  0x00E5DA2B, 0x00E90B96, 0x00E90BAA, 0x00E90BBE, 0x00E90BD2, 0x00E90BE6, 0x00E90BFA, 0x00E90C0E, 0x00E90C22, 0x00E90C36, 
						  0x00ED61E0, 0x00ED6270};

	DWORD get_row_column = 0x004932F0;

	DWORD get_this_plus_12x = 0x00D6C400;
	DWORD get_this_plus_12x_1 = 0x006DF650;

	DWORD get_this_plus_112x = 0x00795AD0;

	DWORD initialize_object_A = 0x00C96C90;
	DWORD initialize_object_B = 0x00C96C00;

	DWORD traverse_list = 0x00E71D70;

	DWORD test_bit1_calls[] = {0x0048B043, 0x00499366, 0x004C1244, 0x004C1CF5, 0x00508AE9, 0x005280B1, 0x0053FC16, 0x00541747, 0x005ACED1, 0x005ACF09, 
						  0x005ACF41, 0x005ACF79, 0x005AD01E, 0x005AEF6F, 0x005AEFDB, 0x005B1A4E, 0x00620BE4, 0x00629843, 0x00649031, 0x00649092, 
						  0x0064958A, 0x006ED970, 0x006F6003, 0x006F601A, 0x006F6031, 0x006F6048, 0x006F6F05, 0x00703ED4, 0x00704143, 0x00706F9B, 
						  0x0070722F, 0x0070728A, 0x0072B80D, 0x0074A049, 0x0074B6AF, 0x00787E11, 0x007882F3, 0x0078843A, 0x007881C0, 0x0078A4D1, 
						  0x0078A4FF, 0x0078A52D, 0x0078A5E0, 0x0078A649, 0x0078A703, 0x0078A753, 0x0078A790, 0x0078A7EB, 0x0078A819, 0x0078A86D, 
						  0x0078A8FE, 0x0078A94E, 0x0078A40B, 0x0078A439, 0x0078AD09, 0x0078AD37, 0x0078A467, 0x0078A4A3, 0x0078BD91, 0x0078C3B6, 
						  0x0078CAAD, 0x0078CAE1, 0x00864474, 0x0086447F, 0x008738F0, 0x00873955, 0x008739F5, 0x008C1096, 0x008E1B86, 0x009C4483, 
						  0x009C5221, 0x009C5567, 0x009DCFEB, 0x009FDD6A, 0x00A05B00, 0x00C73B40, 0x00C7745D, 0x00C7EF5A, 0x00C7EF8A, 0x00C7EFBA, 
						  0x00C9E70C, 0x00C9E9DB, 0x00D5732C, 0x00E25A47, 0x00E265E0, 0x00E27687, 0x00E278FB, 0x00E28029, 0x00E283F9, 0x00E2A7E7, 
						  0x00E397B7, 0x00E3989F, 0x00E398FB, 0x00E39943, 0x00E39707, 0x00E3976A, 0x00E39FC9, 0x00E58EA3, 0x00E79E12, 0x00E7E352, 
						  0x00E7E645, 0x00E840FC, 0x00E84ECC, 0x00E86BFE, 0x00E87912};
	DWORD test_bit1 = 0x0048B390;

	DWORD test_bit2_calls[] = {0x004A3C58, 0x004A3B6E, 0x004A3B89, 0x0064924C, 0x006493B5};
	DWORD test_bit2 = 0x004A3D50;

	DWORD test_bit6_calls[] = {0x00624D59, 0x00624E9E, 0x00624FA6, 0x0062FD18, 0x00631969, 0x0063223F};
	DWORD test_bit6 = 0x006254B0;

	DWORD test_bit11_calls[] = {0x0048B052, 0x00E1DDBE, 0x00E1DFC0};
	DWORD test_bit11 = 0x0048B3B0;

	DWORD test_bit12_calls[] = {0x011730FA, 0x011730AD, 0x007091BB, 0x00C8063C, 0x00C8069E, 0x00C8054E, 0x00C80A9B, 0x00C8096E, 0x00C80A38, 0x00C90379, 
						  0x00E27B67, 0x00E27CDE, 0x00E27E3B, 0x00E840E3, 0x00E8416F, 0x00E841D5, 0x00E84543, 0x00E846A3, 0x00E84867, 0x00E848B9, 
						  0x00E84958, 0x00E8475A, 0x00E863EC};
	DWORD test_bit12 = 0x00709BC0;

	DWORD test_bit15_calls[] = {0x00E1E6DE, 0x00E1E724, 0x00E1E852, 0x00E1E913, 0x00E1EA7D, 0x00E1EB18};
	DWORD test_bit15 = 0x00E1FA90;

	DWORD test_bit16_calls[] = {0x004387BC, 0x00668F0C, 0x00E1EA17, 0x00E1EE10, 0x00E1EFFB, 0x00E89893};
	DWORD test_bit16 = 0x00438800;

	DWORD test_bit18_calls[] = {0x005380E9, 0x005387EA, 0x0053FD8A};
	DWORD test_bit18 = 0x005387C0;

	DWORD test_bit21_calls[] = {0x007AD63B, 0x007B0F8D, 0x0085951E, 0x00880935, 0x00880EC5, 0x00C805B7, 0x00C809D7, 0x00E58E90, 0x01173028};
	DWORD test_bit21 = 0x007AD670;

	DWORD test_bit23_calls[] = {0x0051E404};
	DWORD test_bit23 = 0x0051E490;

	DWORD test_bit27_calls[] = { 0x0051E22A, 0x0064F6C7, 0x00E840C2, 0x00E8414E, 0x00E841B4, 0x00E84682, 0x00E84739, 0x00E84898, 0x00E84937};
	DWORD test_bit27 = 0x0051E320;

	DWORD test_bit28_calls[] = {0x00E1DDD2, 0x00E1E66A, 0x00E33C7A, 0x00E352F4, 0x00E359E1, 0x00E3641D, 0x00E49807, 0x00E49AE3};
	DWORD test_bit28 = 0x00E1FA30;

	DWORD test_not_bit30 = 0x0051E340;

	DWORD test_is_zero = 0x00445E50;
	DWORD test_is_zero_1 = 0x00D33E20;
	DWORD test_is_zero_2 = 0x00BD9220;

	DWORD get_this_off94_calls[] ={0x0040B503, 0x0040B50F, 0x0040B525, 0x0048C27C, 0x00514983, 0x0051E2EB, 0x0051E282, 0x0054941F, 0x006E7E2A, 0x0074A631, 
						  0x0074A65F, 0x0074CB47, 0x0079AEC9, 0x007FBBFD, 0x008581FF, 0x008CEAA7, 0x00937ADC, 0x00937B4C, 0x00937B8C, 0x00937BDF, 
						  0x00937C2F, 0x0093AEDC, 0x0093AF2C, 0x0093AF6C, 0x0093AFBF, 0x0093B016, 0x0093B10C, 0x0093B1EC, 0x0093B23C, 0x0093B27C, 
						  0x0093B2CF, 0x0093B31F, 0x0093B35C, 0x0093B3AC, 0x0093B3EC, 0x0093B43F, 0x0093B48F, 0x0093B4CC, 0x0093B51C, 0x0093B55C, 
						  0x0093B59C, 0x0093B5EF, 0x0093B654, 0x0093B69F, 0x0093B6F6, 0x0093B72C, 0x0093B77F, 0x0093B7D6, 0x0093B80C, 0x0093B85C, 
						  0x0093B89C, 0x0093B8EF, 0x0093B946, 0x0093B9BC, 0x0093B9FC, 0x0093BA4F, 0x0093BAA6, 0x0093DF1F, 0x0093DF7D, 0x0093DFBC, 
						  0x0093E00C, 0x0093E04C, 0x0093E09F, 0x0093E0FD, 0x0093E1AC, 0x0093E28C, 0x0093E2DC, 0x0093E31C, 0x0093E35C, 0x0093E3AF, 
						  0x0093E3FF, 0x0093E52C, 0x0093E57F, 0x0093E6FC, 0x0093E74F, 0x0093E79F, 0x0093E7DC, 0x0093E82F, 0x0093E87F, 0x0093E91F, 
						  0x0093E96F, 0x009401BC, 0x009402DC, 0x0094032C, 0x0094036C, 0x009403BF, 0x0094040F, 0x0094198C, 0x009419CC, 0x00941A1F, 
						  0x00941A6F, 0x00941AAC, 0x00941AFC, 0x00941B3C, 0x00941B8F, 0x00941BDF, 0x00941C8C, 0x00941CDC, 0x00941D2F, 0x00941DAC, 
						  0x00941DFC, 0x00941E3C, 0x00941E8F, 0x00941EDF, 0x0094610C, 0x009461FF, 0x0094624F, 0x0094632C, 0x0094637F, 0x009463CF, 
						  0x0094644C, 0x0094649C, 0x009464DC, 0x0094652F, 0x0094656C, 0x009465BF, 0x0094660F, 0x0094664C, 0x009466AF, 0x009466FF, 
						  0x009467DC, 0x0094682C, 0x0094687F, 0x009468CF, 0x0094690C, 0x0094695C, 0x0094699C, 0x009469EF, 0x00946A3F, 0x00946B1C, 
						  0x00946B6F, 0x00946BAC, 0x00946BFF, 0x0094B29F, 0x0094B2EF, 0x0094B32C, 0x0094B37C, 0x0094B3CF, 0x0094B41F, 0x0094B46F, 
						  0x0094B4CD, 0x009531AC, 0x009531FC, 0x0095323C, 0x0095328F, 0x009532DF, 0x0095335C, 0x009533AF, 0x009533FF, 0x0095343C, 
						  0x0095348C, 0x009534CC, 0x0095351F, 0x0095356F, 0x009535BF, 0x0095360F, 0x0095364C, 0x0095369C, 0x009536DC, 0x0095372F, 
						  0x00953786, 0x00958E7F, 0x00958ECF, 0x00958F0C, 0x00958F5C, 0x00958F9C, 0x00958FEF, 0x0095903F, 0x0095907C, 0x009590CC, 
						  0x0095911F, 0x0095916F, 0x009591C6, 0x0095924C, 0x0095929F, 0x009592EF, 0x0095932C, 0x0095936C, 0x009593BF, 0x0095941D, 
						  0x0095945C, 0x009594AC, 0x009594EC, 0x0095953F, 0x0095958F, 0x0095978C, 0x009597DC, 0x0095982F, 0x00959886, 0x009598CF, 
						  0x0096116C, 0x009611BF, 0x0096123C, 0x0096128C, 0x009612CC, 0x0096130C, 0x0096135F, 0x009613B6, 0x0096149F, 0x0096155C, 
						  0x0096159C, 0x009615EF, 0x0096162C, 0x0096167C, 0x009616BC, 0x0096170F, 0x0096175F, 0x0096179C, 0x009617EC, 0x0096182C, 
						  0x0096187F, 0x009618CF, 0x0096190C, 0x0096195C, 0x009619AF, 0x009619FF, 0x00961A4F, 0x00961A8C, 0x00961ADC, 0x00961B1C, 
						  0x00961B6F, 0x00961BBF, 0x00961BFC, 0x00961C4C, 0x00961C8C, 0x00961CDF, 0x00961D2F, 0x00961EC6, 0x00961F3C, 0x00961F8C, 
						  0x00961FDF, 0x00962036, 0x0096206C, 0x009620BC, 0x0096210F, 0x00962166, 0x009621AF, 0x0096446C, 0x009644BF, 0x0096459C, 
						  0x009645EC, 0x0096462C, 0x0096467F, 0x009665CC, 0x009667EC, 0x0096683F, 0x009668BC, 0x0096690C, 0x0096694C, 0x009669A6, 
						  0x009669EF, 0x00966A2C, 0x00966A7F, 0x00966AD6, 0x00966B1F, 0x00968DAC, 0x00968E9C, 0x00968EEF, 0x00968F3F, 0x0096CECC, 
						  0x0096CF1F, 0x0096D09C, 0x0096D0EC, 0x0096D13F, 0x0096D78F, 0x0096FCDC, 0x0096FDBC, 0x0096FE0C, 0x0096FE4C, 0x0096FE9F, 
						  0x0096FEEF, 0x00970FDC, 0x0097101C, 0x0097106F, 0x009710BF, 0x009710FC, 0x0097114F, 0x00973EFC, 0x00973FF6, 0x0097407C, 
						  0x009740CC, 0x0097410C, 0x0097415F, 0x009741B6, 0x009741EC, 0x0097423F, 0x00974296, 0x009742DF, 0x00974336, 0x0097436C, 
						  0x009743C6, 0x0097440F, 0x0097445C, 0x009744AC, 0x009744EC, 0x0097453F, 0x0097458F, 0x00978D1C, 0x00978E3C, 0x00978E8F, 
						  0x0097A79C, 0x0097A7EC, 0x0097A82C, 0x0097A87F, 0x0097A8CF, 0x0097A92D, 0x0097A96C, 0x0097A9BC, 0x0097A9FC, 0x0097AA4F, 
						  0x0097AA9F, 0x0097AADC, 0x0097AB2C, 0x0097AB6C, 0x0097ABBF, 0x0097AC0F, 0x0097CC6F, 0x009FE987, 0x00C72F67, 0x00C72FCC, 
						  0x00C80542, 0x00C80962, 0x00C906D5, 0x00C90670, 0x00C979B0, 0x00E2801D, 0x00E283ED, 0x00E3854F, 0x00E57E7F, 0x00E597CA, 
						  0x00E8410C};

	DWORD get_this_off94 = 0x00937B20;

	DWORD get_this_offB4_calls[] = {0x00440604, 0x0048A2A8, 0x0048B1E0, 0x0049B020, 0x0049E9AF, 0x0049EAFB, 0x0049EBCC, 0x0049EC5B, 0x0049EC67, 0x0049EC7E, 
						  0x0049ECA8, 0x0049ECCC, 0x0049ED19, 0x0049F29A, 0x0049F2A6, 0x0049F2B9, 0x0049F79C, 0x0049F7AC, 0x0049F7C3, 0x0049F8EF, 
						  0x004A0811, 0x00545C87, 0x00545CD9, 0x00545B89, 0x005AF81B, 0x005AF976, 0x005C58E3, 0x005C59B3, 0x005C6690, 0x005C66F7, 
						  0x005E435F, 0x005EBE3C, 0x005EBE98, 0x005EC0B6, 0x005EC1D0, 0x005EC22C, 0x005F30BF, 0x00642FF7, 0x00643805, 0x0064568A, 
						  0x006456C6, 0x00645B2E, 0x00649762, 0x006A8F61, 0x006AABE5, 0x006AC8E2, 0x006ACFE6, 0x006B534C, 0x007CD177, 0x007E27E8, 
						  0x007E27F8, 0x007E280F, 0x00C873CC, 0x00C87441, 0x00C8775A, 0x00C8776F, 0x00CA21AF, 0x00CA21CF, 0x00CA220B, 0x00CA2230, 
						  0x00CA49A8, 0x00E3357E, 0x00E3C82C, 0x00E58C05, 0x00E68CDD, 0x00E6B494, 0x00E7068A, 0x00E70A48, 0x00E70B3E, 0x00E82A79, 
						  0x00E82C9B};

	DWORD get_this_offB4 = 0x004407C0;

	DWORD get_this_off38_calls[] = {0x01109084, 0x011090A6, 0x00405FF0, 0x0043795B, 0x0049F307, 0x0049F7EC, 0x005AA0F4, 0x005E4392, 0x005F9A44, 0x005F9B65, 
						  0x005FF70B, 0x0071155B, 0x00711567, 0x0072DA84, 0x0072DA90, 0x0072DAD2, 0x0072DBD4, 0x0072DBE0, 0x0072DC1B, 0x0072DCA9, 
						  0x0072DE81, 0x0072DE8D, 0x0072E325, 0x0072E363, 0x0072E700, 0x0072E72C, 0x0072E98A, 0x0072E898, 0x0072E8A8, 0x0072F160, 
						  0x0072F16C, 0x0072ECE5, 0x0072F52A, 0x0072F566, 0x0072F5DA, 0x007304BD, 0x007304C9, 0x007305B2, 0x007305CA, 0x00730FF8, 
						  0x00730FEC, 0x007359D8, 0x007359CC, 0x00735AD8, 0x00735B12, 0x00735B33, 0x00735ACC, 0x00735B68, 0x00735B5C, 0x00735DF5, 
						  0x00735E36, 0x00735FA7, 0x00735FC8, 0x00735FF8, 0x00735FEC, 0x00736092, 0x0073609E, 0x00736286, 0x007361FF, 0x0073638B, 
						  0x00736397, 0x007365E6, 0x007365F5, 0x007370BA, 0x007371EA, 0x00737204, 0x00737458, 0x0073744C, 0x00737534, 0x00737540, 
						  0x0073779C, 0x00737928, 0x0073798C, 0x00737CD8, 0x00737CCC, 0x00737D56, 0x00737D4A, 0x00737EC9, 0x00737ED5, 0x00738222, 
						  0x007386E8, 0x007386DC, 0x00738758, 0x0073874C, 0x007392B8, 0x007392AC, 0x007393E4, 0x007393F0, 0x007398FE, 0x0073990A, 
						  0x00739974, 0x00739980, 0x00739BB8, 0x00739BAC, 0x00739CF8, 0x00739CEC, 0x00739DE8, 0x00739DDC, 0x0073A161, 0x0073A13C, 
						  0x00741A0C, 0x00743179, 0x0074315D, 0x00745744, 0x00745760, 0x007457C4, 0x007457E0, 0x0074628D, 0x0074626C, 0x00746458, 
						  0x0074644C, 0x0074650B, 0x00746517, 0x00746588, 0x0074657C, 0x00746753, 0x0074673C, 0x0074695A, 0x0074693C, 0x00746B6C, 
						  0x00746B83, 0x00748B4C, 0x00748B5B, 0x00749415, 0x00749432, 0x00749475, 0x00749481, 0x00749505, 0x00749511, 0x0074E4B6, 
						  0x0074E6C8, 0x0074E6BC, 0x0074E788, 0x0074E77C, 0x0074EA5C, 0x0074F685, 0x0074F691, 0x0074F752, 0x0074F75E, 0x0074F948, 
						  0x0074F93C, 0x0074FB08, 0x0074FAFC, 0x00750148, 0x0075013C, 0x00750688, 0x00750694, 0x007509A8, 0x0075099C, 0x00750FA8, 
						  0x00750F9C, 0x00751068, 0x0075105C, 0x007510D8, 0x007510CC, 0x00751198, 0x0075118C, 0x00752CDC, 0x00753518, 0x0075350C, 
						  0x007538E8, 0x007538DC, 0x0077C4C4, 0x0077C6A8, 0x0077EF48, 0x0077EF3C, 0x0077F008, 0x0077EFFC, 0x0077F0F8, 0x0077F104, 
						  0x0077F18F, 0x0077F42B, 0x0077F445, 0x0077F687, 0x0077F6A1, 0x0078D193, 0x0078D23C, 0x00797F0A, 0x0079882D, 0x0079953C, 
						  0x007995EC, 0x007A6263, 0x007A62AE, 0x007B502E, 0x007BB93D, 0x007E2838, 0x008055EC, 0x00849A91, 0x00876CAD, 0x008E6472, 
						  0x008E739B, 0x00A179B8, 0x00A179D3, 0x00A46629, 0x00BBAD21, 0x00BF1488, 0x00BF159D, 0x00BF1629, 0x00C777B4, 0x00C81276, 
						  0x00C84857, 0x00C848A8, 0x00C847AE, 0x00C847FD, 0x00C85219, 0x00C857BF, 0x00C92EFE, 0x00C95519, 0x00C955D9, 0x00C955E6, 
						  0x00C95647, 0x00C95654, 0x00C9585B, 0x00C9956E, 0x00C99589, 0x00C995B6, 0x00CA12F7, 0x00CA1930, 0x00CA509D, 0x00E0FA6E, 
						  0x00E2265F, 0x00E24407, 0x00E2662A, 0x00E2663A, 0x00E28154, 0x00E28164, 0x00E2839D, 0x00E28524, 0x00E28530, 0x00E2857F, 
						  0x00E2A5D5, 0x00E32077, 0x00E320E1, 0x00E32932, 0x00E351EB, 0x00E35935, 0x00E35944, 0x00E34142, 0x00E3416C, 0x00E34183, 
						  0x00E3482A, 0x00E35BFF, 0x00E35FAA, 0x00E35FB9, 0x00E36010, 0x00E360C5, 0x00E3611A, 0x00E39152, 0x00E39165, 0x00E390A9, 
						  0x00E390BC, 0x00E3CB66, 0x00E3CB72, 0x00E3CFB2, 0x00E3D253, 0x00E3D130, 0x00E3D13C, 0x00E3E3DE, 0x00E3E604, 0x00E3E7CB, 
						  0x00E3E812, 0x00E3E83B, 0x00E40390, 0x00E403A5, 0x00E403C9, 0x00E43BD0, 0x00E43BF4, 0x00E498AD, 0x00E498B9, 0x00E49AAF, 
						  0x00E49AD4, 0x00E557E8, 0x00E557F4, 0x00E55846, 0x00E582E1, 0x00E58349, 0x00E62FD3, 0x00E63065, 0x00E6D4C0, 0x00E6D4E4, 
						  0x00E83DA8, 0x00E83DB6, 0x00E843EA, 0x00E84420, 0x00E8432D, 0x00E844FA, 0x00E8450A, 0x00E84A22, 0x00E84A32, 0x00E861AF, 
						  0x00E861BF, 0x00E8AF7A, 0x00E8B33A, 0x00E8B84A, 0x00E8BC2A, 0x00E8BF5A, 0x00E8DB20, 0x00E8DCBC, 0x00E8E5D9, 0x00E8E626, 
						  0x00F01EEB, 0x00F05BFF, 0x00F71A3C};

	DWORD get_this_off38 = 0x005F9D70;
}

